//
// C++ Implementation: kpgusersfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgusersfolder.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgserver.h"
#include "kpguser.h"


KPGUsersFolder::KPGUsersFolder(KPGServer *parent)
 : KPGItemsFolder(parent, i18n("Users"))
{
	setPixmap(0, *m_pIconFolderGrey);
}


KPGUsersFolder::~KPGUsersFolder()
{
}

void KPGUsersFolder::refresh() throw(const KPGSqlException &)
{
    // delete all child items (databases)
    while (QListViewItem * pItem = firstChild())
        delete pItem;
    
        // obtain list of users
    QString strQuery("SELECT usesysid, usename, usecreatedb, usesuper, usecatupd, valuntil FROM ");
    strQuery.append("pg_catalog.pg_user u "); // or pg_shadow
    strQuery.append("ORDER BY usename");
                
    try
    {
        m_pqxxResultUsers = connection()->runQuery(strQuery);
    
        KPGUser *pUser = 0;
            
        for (result::size_type i = 0; i != m_pqxxResultUsers.size(); ++i)
        {
            if(pUser == 0)
                pUser = new KPGUser(this, m_pqxxResultUsers[i]["usename"].c_str());
            else
                pUser = new KPGUser(this, pUser, m_pqxxResultUsers[i]["usename"].c_str());           
            
            pUser->setProperties(m_pqxxResultUsers[i]);
        }
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(e.what(), strQuery);
    } 
}
