//
// C++ Interface: kpguser
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGUSER_H
#define KPGUSER_H

#include "kpgtreeitem.h"

class KPGUsersFolder;
class QDate;


/**
  * Database User
  *
  * @author Lumir Vanek
  */
class KPGUser : public KPGTreeItem
{
public:
    KPGUser(KPGUsersFolder *, const QString &);
	KPGUser(KPGUsersFolder *, KPGUser *, const QString &);
    ~KPGUser();

	virtual eNodeType type() const { return nodeUser; }
	
	void setProperties(const pqxx::result::tuple &);
		
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return; }
		
	/*
	 * Functions for accessing properties
	 */
	int sysId() const { return m_iSysId; }
	bool canCreateDb() const { return m_bCreateDb; } 
	bool isSuper() const { return m_bIsSuper; }
	bool canCatUpd() const { return m_bUCatUpd; } 
	const QDate validUntil() const;
	const QString & validUntilAsString() const { return m_strValUntil; }
		
protected:
	
	/*
	 * Properties
	 */
	int m_iSysId; 
	bool m_bCreateDb; 
	bool m_bIsSuper; 
	bool m_bUCatUpd; 
	QString m_strValUntil;
};

#endif
