/***************************************************************************
                          kpgtablesfolder  -  description
                             -------------------
    begin                : Ne no 1 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kpgtablesfolder.h"

#include <kdebug.h>
#include <klocale.h>

// application specific includes
#include "../kpogreview.h"
#include "../kpgconfiguration.h"
#include "../kpggeneralsettings.h"
#include "kpgconnection.h"
#include "kpgserver.h"
#include "kpgschema.h"
#include "kpgdatabase.h"
#include "kpgtable.h"


KPGTablesFolder::KPGTablesFolder(KPGSchema *parent, pqxx::oid oidNameSpace)
 : KPGItemsFolder(parent, i18n("Tables"))
{
	m_oidNameSpace = oidNameSpace;
}


KPGTablesFolder::~KPGTablesFolder()
{
}

void KPGTablesFolder::refresh() throw(const KPGSqlException &)
{
    // delete all child items (tables)
    while (QListViewItem * pItem = firstChild())
        delete pItem;
		
	// Get pointer to server for version info
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (parent()->parent());
    KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
    
    bool bVersion80_OrNewer = false;
	bool bVersion81_OrNewer = false;
	    
	// Is it 8.0 or newer ?
	if(pServer->versionMajor() > 7)
    {             
       bVersion80_OrNewer = true;
    }     
	    
    // Is it 8.1 or newer ?
	if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 1)) || ((pServer->versionMajor() > 8))) 
	{
		bVersion81_OrNewer = true;
	}

	// obtain list of tables
    QString strQuery("SELECT rel.oid, rel.relname, rel.reltype, description, pg_get_userbyid(rel.relowner) AS relowner");
	strQuery.append(", rel.relhasoids, rel.relhassubclass, rel.reltuples, c.conname, c.conkey, rel.relacl");
    
    strQuery.append(", CASE rel.relkind WHEN 'r' THEN 'Ordinary table' WHEN 't' THEN 'Toast table' END AS kind");
    strQuery.append(", toast.oid AS toast_table_oid, toast.relname AS toast_table");
	    
    if(bVersion80_OrNewer) // tablespace info
    {
    	strQuery.append(QString(", CASE rel.reltablespace WHEN 0 THEN %1 ELSE rel.reltablespace END AS reltablespace, ts.spcname").arg(pDatabase->oidTablespace()));
	}
	
	if(bVersion81_OrNewer) // size info
	{
		strQuery.append(", pg_catalog.pg_size_pretty(pg_catalog.pg_relation_size(rel.oid)) AS size_pretty");
		strQuery.append(", pg_catalog.pg_size_pretty(pg_catalog.pg_total_relation_size(rel.oid)) AS size_pretty_total");
		strQuery.append(", pg_catalog.pg_relation_size(rel.oid) AS table_size");
		strQuery.append(", pg_catalog.pg_total_relation_size(rel.oid) AS table_size_total");
	}
    		
	strQuery.append(" FROM pg_catalog.pg_class rel ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=rel.oid AND des.objsubid=0 ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_constraint c ON c.conrelid=rel.oid AND c.contype='p' ");
	
	strQuery.append("LEFT JOIN pg_catalog.pg_class toast ON rel.reltoastrelid=toast.oid ");
	
	if(bVersion80_OrNewer)
    {
    	strQuery.append("LEFT JOIN pg_catalog.pg_tablespace ts ON CASE rel.reltablespace ");
    	strQuery.append(QString("WHEN 0 THEN %1 ELSE rel.reltablespace END=ts.oid ").arg(pDatabase->oidTablespace()));
    }
    
	strQuery.append("WHERE ((rel.relkind = 'r') OR (rel.relkind = 't')) AND rel.relnamespace = " + QString("%1").arg(m_oidNameSpace) + " ");
	strQuery.append("ORDER BY rel.relname");
		
	bool bLazyLoadTablesChilds = KPoGreView::configuration()->general()->lazyLoadTablesChilds();
	
  	try
  	{
  	    m_pqxxResultTables = connection()->runQuery(strQuery);

		KPGTable *pTable = 0;
		
    	for (result::size_type i = 0; i != m_pqxxResultTables.size(); ++i)
    	{
			pqxx::oid oid;
			m_pqxxResultTables[i][0].to(oid);
			
			if(pTable == 0)
      		    pTable = new KPGTable(this, m_pqxxResultTables[i]["relname"].c_str(), oid);
			else
				pTable = new KPGTable(this, pTable, m_pqxxResultTables[i]["relname"].c_str(), oid);
			
			pTable->setProperties(m_pqxxResultTables[i], bVersion80_OrNewer, bVersion81_OrNewer);
			
			if(!bLazyLoadTablesChilds)
			{
				pTable->refreshChildItems();
			}
    	}
  	}
  	catch (const KPGSqlException &e)
	{
		kdError() << k_funcinfo << "Routing exception up. Tables folder" <<  endl;
		throw; // if it is KPGSqlException re-throw it
	}
  	catch (const std::exception &e)
  	{
		kdError() << k_funcinfo << e.what() << endl;
    	throw KPGSqlException(e.what(), strQuery);
  	} 
}

void KPGTablesFolder::fillListOfObjectOidsWithChildItems(KPGOidNameList & listOfObjectOids)
{
    QListViewItem * pItem = firstChild();
    while(pItem)
    {
        KPGTreeItem *pTreeItem = static_cast <KPGTreeItem *> (pItem);
        
        if(pTreeItem->type() != nodeTable)
        {
            kdError() << k_funcinfo << "Logic error !" << endl;
            return;
        }
        
        KPGTable *pTable = static_cast <KPGTable *> (pItem);
        
        KPGOidName oidName(pTable->oid(), pTable->text(0), pTable->type(), pTable->pixmap(0), pTable->description());
        oidName.setOidUnderlyingType(pTable->oidReltype()); 
                
        listOfObjectOids.append(oidName);
        
        pItem = pItem->nextSibling();
    }
}


