//
// C++ Implementation: kpgoperatorclasesfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgoperatorclassesfolder.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgschema.h"
#include "kpgoperatorclass.h"
#include "kpgserver.h"


KPGOperatorClassesFolder::KPGOperatorClassesFolder(KPGSchema *parent, pqxx::oid oidNameSpace)
 : KPGItemsFolder(parent, i18n("Operator Classes"))
{
	setPixmap(0, *m_pIconFolderViolet);
	m_oidNameSpace = oidNameSpace;
}

KPGOperatorClassesFolder::~KPGOperatorClassesFolder()
{
}

void KPGOperatorClassesFolder::refresh() throw(const KPGSqlException &)
{
    // delete all child items 
    while (QListViewItem * pItem = firstChild())
        delete pItem;
    
    // Get pointer to server for version info
    KPGServer *pServer = static_cast <KPGServer *> (parent()->parent()->parent());
    
    bool bVersion83_OrNewer = false;
    
    // Is it 8.1 or newer ?
	if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 3)) || ((pServer->versionMajor() > 8))) 
	{
		bVersion83_OrNewer = true;
	}
	
    // obtain list of operator classes
    QString strQuery("SELECT op.oid, op.opcname, op.opcdefault, opcintype, it.typname as intypename, opckeytype, dt.typname as keytypename, amname, pg_get_userbyid(op.opcowner) \
    as opowner ");
            
	strQuery.append("FROM pg_catalog.pg_opclass op ");
	
	if(bVersion83_OrNewer)
	{
		strQuery.append("JOIN pg_catalog.pg_am am ON am.oid=opcmethod ");
	}
	else
	{
		strQuery.append("JOIN pg_catalog.pg_am am ON am.oid=opcamid ");
	}
		
	strQuery.append("JOIN pg_catalog.pg_type it ON it.oid=opcintype ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_type dt ON dt.oid=opckeytype ");
	strQuery.append("WHERE opcnamespace = " + QString("%1").arg(m_oidNameSpace) + " ");
	strQuery.append("ORDER BY op.opcname");
			
    try
    {
        m_pqxxResultOperatorClasses = connection()->runQuery(strQuery);
    
        KPGOperatorClass *pOperatorClass = 0;
            
        for (result::size_type i = 0; i != m_pqxxResultOperatorClasses.size(); ++i)
        {
            pqxx::oid oid;
            m_pqxxResultOperatorClasses[i][0].to(oid);
            
            if(pOperatorClass == 0)
                pOperatorClass = new KPGOperatorClass(this, m_pqxxResultOperatorClasses[i]["opcname"].c_str(), oid);
            else
                pOperatorClass = new KPGOperatorClass(this, pOperatorClass, m_pqxxResultOperatorClasses[i]["opcname"].c_str(), oid);
             
            pOperatorClass->setProperties(m_pqxxResultOperatorClasses[i]);
        }
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(e.what(), strQuery);
    } 
}
