//
// C++ Implementation: kpgcastsfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcastsfolder.h"

#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgcast.h"
#include "kpgdatabase.h"


KPGCastsFolder::KPGCastsFolder(KPGDatabase *parent)
 : KPGItemsFolder(parent, i18n("Casts"))
{
	setPixmap(0, *m_pIconFolderGreen);
}


KPGCastsFolder::~KPGCastsFolder()
{
}

void KPGCastsFolder::refresh() throw(const KPGSqlException &)
{
    // delete all child items
    while (QListViewItem * pItem = firstChild())
        delete pItem;
    
    // obtain list of casts
    QString strQuery("SELECT ca.oid, st.typname || ' -> ' || tt.typname AS name, CASE WHEN ca.castcontext = 'e' THEN 'explicit' WHEN ca.castcontext = 'a' THEN 'implicitly in \
    assignment' WHEN ca.castcontext = 'i' THEN 'implicitly in expressions' END AS castcontext, castsource, st.typname AS srctype, casttarget, tt.typname AS trgtype, castfunc, \
    pr.proname, pr.pronamespace, nspname ");
	strQuery.append("FROM pg_catalog.pg_cast ca ");
	strQuery.append("JOIN pg_catalog.pg_type st ON st.oid=castsource ");
	strQuery.append("JOIN pg_catalog.pg_type tt ON tt.oid=casttarget ");
	strQuery.append("LEFT JOIN pg_catalog.pg_proc pr ON pr.oid=castfunc ");
	strQuery.append("LEFT JOIN pg_catalog.pg_namespace na ON na.oid=pr.pronamespace ");
	strQuery.append("ORDER BY st.typname, tt.typname");
		
	try
    {
        m_pqxxResultCasts = connection()->runQuery(strQuery);
    
        KPGCast *pCast = 0;
            
        for (result::size_type i = 0; i != m_pqxxResultCasts.size(); ++i)
        {
            pqxx::oid oid;
            m_pqxxResultCasts[i][0].to(oid);
            
            if(pCast == 0)
                pCast = new KPGCast(this, QString(m_pqxxResultCasts[i]["name"].c_str()), oid);
            else
                pCast = new KPGCast(this, pCast, QString(m_pqxxResultCasts[i]["name"].c_str()), oid);
                    
            pCast->setProperties(m_pqxxResultCasts[i]);
        }
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(e.what(), strQuery);
    } 
}

