/***************************************************************************
                          komba2.h  -  description
                             -------------------
    begin    apps            : Wed Jan 31 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KOMBA2_H
#define KOMBA2_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt

// include files for KDE 
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include <kurl.h>

#include "recentmounts.h"

// forward declaration of the Komba2 classes
class Komba2Doc;
class Komba2View;
class MyShareItem;
/**
  * The base class for Komba2 application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of Komba2View creates your center view, which is connected
  * to the window's Doc object.
  * Komba2App reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
class Komba2App:public KMainWindow
{
  Q_OBJECT friend class Komba2View;

public:
    /** construtor of Komba2App, calls all init functions to create the application.
     */
  Komba2App (QWidget * parent = 0, const char *name = 0, const char *option =
	     0);
   ~Komba2App ();
    /** opens a file specified by commandline option
     */
  void openDocumentFile (const KURL & url = 0);
    /** returns a pointer to the current document connected to the KTMainWindow instance and is used by
     * the View class to access the document object's methods
     */
  Komba2Doc *getDocument () const;
  void setViewSize (QValueList < int >i)
  {
    viewsize = i;
  };
  void addFileOpenRecent (MyShareItem * item);
  RecentMounts *recentMounts ()
  {
    return fileOpenRecent;
  };
  void setCanQuit (bool s)
  {
    canquit = s;
  };
  bool canQuit ()
  {
    return canquit;
  };
  void setWaitForQuit (bool s)
  {
    waitforquit = s;
  };
  bool waitForQuit ()
  {
    return waitforquit;
  };
//    QStringList getRecentHosts() { return fileOpenRecent->items(); };
protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */
  void saveOptions ();
    /** read general Options again and initialize all variables like the recent file list
     */
  void readOptions ();
    /** initializes the KActions of the application */
  void initActions ();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
  void initStatusBar ();
    /** initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */
  void initDocument (const char *option = 0);
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
  void initView ();
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
  virtual bool queryClose ();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
  virtual bool queryExit ();
    /** saves the window properties for each open window during session end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KTMainWindow#saveProperties
     */
  virtual void saveProperties (KConfig * _cfg);
    /** reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KTMainWindow#readProperties
     */
  virtual void readProperties (KConfig * _cfg);

  void enableMount (bool m)
  {
    mount->setEnabled (m);
  };
  void enableUnmount (bool m)
  {
    unmount->setEnabled (m);
  };
  void enableWorkgroupMenu (bool enable);
  void enableHostMenu (bool enable);
  void enableShareMountedMenu (bool enable);
  void enableShareUnmountedMenu (bool enable);
  void enableNetworkMenu (bool enable);
  void popupMenu (const QString mmenu, const QPoint & p);
		/** disables all Rescanmenus */
  void disableRescan ();
  void setHostAskForPassword (bool b);
  void setShareAskForPassword (bool b);
  public slots:
    /** open a new application window by creating a new instance of Komba2App */
  void slotFileNewWindow ();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
  void slotFileQuit ();
    /** toggles the toolbar
     */
  void slotViewToolBar ();
    /** toggles the statusbar
     */
  void slotViewStatusBar ();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    /** opens a file from the recent files menu */
  void slotFileOpenRecent (int id);

  void slotStatusMsg (const QString & text);
	  /** Mount a share if a share is selected in view */
  void slotMount ();
  void slotMountTo ();
	  /** Mount a share if a share is selected in view */
  void slotUnmount ();

  void slotPreferences ();
  void slotSetAccount ();
  void slotSendMessage ();
  void slotRescan ();
  void slotExplore ();
  void slotPing ();
  void slotTraceroute ();
  void slotMountAll ();
  void slotUnmountAll ();
  void slotToggleAskForPassword ();
private:
    /** the configuration object of the application */
  KConfig * config;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
  Komba2View *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
  Komba2Doc *doc;

  // KAction pointers to enable/disable actions
  KAction *fileNewWindow;
  KAction *prefDialog;
  KAction *mount;
  KAction *mount_to;
  KAction *unmount;
  KAction *host_rescan;
  KAction *wg_rescan;
  KAction *net_rescan;
  KAction *rescan;
  KAction *explore;
  KAction *set_hostaccount;
  KToggleAction *wg_ask_for_password;
  KToggleAction *host_ask_for_password;
  KToggleAction *share_ask_for_password;
  KAction *set_wgaccount;
  KAction *set_account;
  KAction *set_shareaccount;
  KAction *send_message;
  KAction *host_send_message;
  KAction *net_send_message;
  KAction *wg_send_message;
  KAction *find;
  KAction *ping;
  KAction *traceroute;

  KAction *fileQuit;
  KAction *mountall;
  KAction *unmountall;

  RecentMounts *fileOpenRecent;
  KToggleAction *viewToolBar;
  KToggleAction *viewStatusBar;
  QValueList < int >viewsize;
  bool canquit;
  bool waitforquit;
};

#endif // KOMBA2_H
