/***************************************************************************
                          knutdock.cpp  -  description
                             -------------------
    begin                : t zari 23 2003
    copyright            : (C) 2003 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutdock.h"
#include "knutnet.h"

//#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kapp.h>
#include <kaboutapplication.h>
#include <kmessagebox.h>

#include <qpainter.h>
#include <qtooltip.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qstring.h>


#include <math.h>
#include <stdio.h>
#include <stdlib.h>

//#include <iostream>

KNutDock::KNutDock(struct upsInfo* tActiveUpsInfo, SettingDataDef* tSettingData, KNutUpsData* tUpsRecords){
  QString valueName;

  m_settingData = tSettingData;
  m_upsRecords = tUpsRecords;
  m_activeUpsInfo = tActiveUpsInfo;

//saves backgroundcolor of kicker  
  backgroundColor = paletteBackgroundColor();

  m_typeOfIcon = m_settingData->typeOfKIcon;

  if (!m_settingData->customKIconColor) m_myBGColor = backgroundColor;
  else m_myBGColor = m_settingData->kIconBackgroundColor;

  m_toolTipFlags=m_settingData->toolTipFlags;

  clearValues();


  KIconLoader *loader = KGlobal::iconLoader();
  m_mainPix = loader->loadIcon ("knutclient",KIcon::Small,16);

  // aplications's own icons
  m_errorPix = UserIcon ("knc_error");
  m_connectPix = UserIcon ("knc_conn");
  m_upsPix = UserIcon ("knc_ups");
  m_battPix = UserIcon ("knc_batt");

  createMainMenu();

  m_statusLayer = 0;
  m_runtimeLayer = 0;

  m_loadLayer = new QPixmap(24,24);
  m_chargeLayer = new QPixmap(24,24);
  m_mainLayer = new QPixmap(24,24);


  initImage();
  changeKIcon(); // this function calls function repaintIcon 

  }


KNutDock::~KNutDock(){

  if (m_statusLayer) delete m_statusLayer;
  if (m_runtimeLayer) delete m_runtimeLayer;

  delete m_loadLayer;
  delete m_chargeLayer;
  delete m_mainLayer;

  delete m_upsServerMenu;
  delete m_menu;
  }

void KNutDock::changeUps (void) {

  m_upsServerMenu->clear();
  createUpsMenu();
  }


void KNutDock::clearDockValues(void){

  initImage(); // paints standart icon

  clearValues();
  repaintDock(true);
  }


void KNutDock::changeToolTip(void){

  m_toolTipFlags=m_settingData->toolTipFlags;
  toolTip(m_runtimeValue, m_statusValue, m_batteryChargeValue, m_upsLoadValue);
  }


void KNutDock::changeKIBColor(void) {

  if (!m_settingData->customKIconColor) m_myBGColor = backgroundColor;
  else m_myBGColor = m_settingData->kIconBackgroundColor; // uses defined color

  repaintDock(true);
  }

void KNutDock::changeKIcon (void) {

  m_typeOfIcon = m_settingData->typeOfKIcon;
  if ( m_typeOfIcon == generalKI) {

    if (m_mainLayer) {
    delete m_mainLayer;
    m_mainLayer=new QPixmap(24,24);
    }

    if (!m_statusLayer) {
      m_statusLayer = new QPixmap(24,24);
      }
    if (!m_runtimeLayer) {
      m_runtimeLayer = new QPixmap(24,24);
      }
    paintStatus(m_statusValue);
    paintRuntime(m_runtimeValue, m_statusValue);
    }
  else {  // picture Icon
    delete m_statusLayer;
    m_statusLayer = 0;
    delete m_runtimeLayer;
    m_runtimeLayer=0;
    }
  paintLoad(m_upsLoadValue);
  paintCharge(m_batteryChargeValue);

  m_statusWarningValue = m_statusValue & (KNutNet::CAL | KNutNet::TRIM | KNutNet::BOOST
                     | KNutNet::OVER | KNutNet::RB);
  repaintDock(true);
  }

void KNutDock::initImage(void) {
  setPixmap(m_mainPix);
  m_dataOk = idle;
  m_dataOkOld = m_dataOk;
  }

void KNutDock::setNewUPS(void) {
  m_upsServerMenu->clear();
  createUpsMenu();
  }


void KNutDock::repaintDock (const bool always) {
  QString nutStringVar;
  int myRuntimeValue;
  int myUpsLoadValue;
  int myStatusValue;  
  int myStatusBatValue;
  int myBatteryChargeValue;
  bool repaintNow = false;
  // value repaintNow is seted when some ups values are changed
  bool okFloat;
  QString valueName;
  QPainter paint;


  if (m_activeUpsInfo->upsNet == 0) { repaint(); return;}

  m_dataOkOld=m_dataOk; 

  if ((m_activeUpsInfo->upsNet->getState() == KNutNet::Connected) // paints icons with information values
       && (!m_activeUpsInfo->netError))  {
    // ups is connected dataOK is ok (program shows icon of connecting UPS)
    m_dataOk = ok; // pro paint event udava ze mam pouzit nase ikony

    if (!m_activeUpsInfo->upsNet->existName(m_activeUpsInfo->runtimeVar)) {
      nutStringVar = m_activeUpsInfo->upsNet->readStringVar(m_activeUpsInfo->runtimeVar);
//std::cout << "KNutDock::repaintDock RUNTIME " << nutStringVar << std::endl;
      if (nutStringVar.isEmpty()) myRuntimeValue=knc::numberVarError;
      else {
        myRuntimeValue = (int)nutStringVar.toFloat(&okFloat);
        if (!okFloat) myRuntimeValue = knc::numberVarError;
        }
      }
    else myRuntimeValue = knc::numberVarError;

    myStatusValue = m_activeUpsInfo->upsNet->readStatus();


    switch (m_typeOfIcon) {
      case generalKI:
//    *********STATUS****************  
      if (myStatusValue !=m_statusValue  ) {
        m_statusValue = myStatusValue;
        paintStatus(m_statusValue);
        repaintNow = true;
        }

//   **********RUNTIME***********
      myStatusBatValue = myStatusValue & KNutNet::OB; // OB = UPS runs on battery 
      if ((myRuntimeValue != m_runtimeValue) || (myStatusBatValue != m_statusBatValue)) {
        // when runtime is changed or flags OB is changed we must repaint icons
        // when OB is changed same items in icon will change color
        m_runtimeValue = myRuntimeValue; // runtime is old value of runtime, one is defined like global value of class
        m_statusBatValue = myStatusBatValue;
        paintRuntime(m_runtimeValue, m_statusValue);
        repaintNow = true;
        }
      break;

      case pictureKI:
//    *********STATUS****************
      if (myStatusValue !=m_statusValue  ) {
        m_statusValue = myStatusValue;
        m_statusWarningValue = myStatusValue & (KNutNet::CAL | KNutNet::TRIM | KNutNet::BOOST
                         | KNutNet::OVER | KNutNet::RB);
        repaintNow = true;
        }

//   **********RUNTIME***********
      if (myRuntimeValue != m_runtimeValue) {
        m_runtimeValue = myRuntimeValue;
        repaintNow = true;
        }
      break;
      } /////////////////////  end of models

    // Other values are for all modes

//  **********UPS LOAD***************
    if (m_activeUpsInfo->nutVariables == 1) valueName = "LOADPCT";
    else valueName = "ups.load";
    if (!m_activeUpsInfo->upsNet->existName(valueName)) {
      nutStringVar = m_activeUpsInfo->upsNet->readStringVar(valueName);
      if (nutStringVar.isEmpty()) myUpsLoadValue=knc::numberVarError;
      else {
        myUpsLoadValue = (int)nutStringVar.toFloat(&okFloat);
        if (!okFloat) myUpsLoadValue=knc::numberVarError;
        }
      }
    else myUpsLoadValue=knc::numberVarError;

    if (myUpsLoadValue != m_upsLoadValue) {
      m_upsLoadValue = myUpsLoadValue;
      if (m_typeOfIcon == generalKI) paintLoad(m_upsLoadValue);
      repaintNow = true;
      }

//  *********BATTERY CHARGE****************
    if (m_activeUpsInfo->nutVariables == 1) valueName="BATTPCT";
    else valueName="battery.charge";
    if (!m_activeUpsInfo->upsNet->existName(valueName)) {
      nutStringVar = m_activeUpsInfo->upsNet->readStringVar(valueName);
      if (nutStringVar.isEmpty()) myBatteryChargeValue=knc::numberVarError;
      else {
        myBatteryChargeValue = (int)nutStringVar.toFloat(&okFloat);
        if (!okFloat) myBatteryChargeValue = knc::numberVarError;
        }
      }
    else myBatteryChargeValue=knc::numberVarError;

    if (myBatteryChargeValue != m_batteryChargeValue) {
      m_batteryChargeValue = myBatteryChargeValue;
      if (m_typeOfIcon == generalKI)paintCharge(m_batteryChargeValue);
      repaintNow = true;
      }
//  ************* End of values********************

    if (repaintNow || always  || (m_dataOk != m_dataOkOld)) {


      switch (m_typeOfIcon) {
        case generalKI:
          m_mainLayer->fill(m_myBGColor);
//          copyBlt (m_mainLayer,0,0,m_runtimeLayer,0,0,24,24);
          bitBlt (m_mainLayer,0,0,m_runtimeLayer,0,0,24,24,AndROP);
          bitBlt (m_mainLayer,0,0,m_loadLayer,0,0,24,24,AndROP);
          bitBlt (m_mainLayer,0,0,m_chargeLayer,0,0,24,24,AndROP);
          bitBlt (m_mainLayer,0,0,m_statusLayer,0,0,24,24,AndROP);
        break;
        case pictureKI:
//          if (m_statusValue & KNutNet::OL) bitBlt (m_mainLayer,0,0,m_loadLayer,0,0,24,24,AndROP); // icon of UPS
          if (m_statusValue & KNutNet::OL) {  // ONLINE - icon of UPS
            int myLoad;
            QPainter paint;
            copyBlt (m_mainLayer,0,0,&m_upsPix,0,0,24,24); // icon of UPS

            paint.begin(m_mainLayer);
            if (m_upsLoadValue == knc::numberVarError) myLoad=0;
            else myLoad = abs(m_upsLoadValue/10);

            if (m_upsLoadValue != knc::numberVarError) {
            if (myLoad > 12) myLoad=12;
            if (myLoad > 10) myLoad++; // preskocime rysku pro 100 %
            if (myLoad < 9) paint.setPen(QColor(0,192,0)); //green
            else {
              if (myLoad < 11) paint.setPen(QColor(255,255,0)); //yellow
              else paint.setPen(QColor(255,0,0));//red
              }
            for (int i = 19; i < 22; i++) paint.drawLine(i,13,i,13-myLoad +1);

            if (myLoad < 13) {
              paint.setPen(QColor(168,220,255));
                for (int i = 20; i < 23; i++ ) paint.drawLine(i,1,i,13-myLoad);
                }
              }
            paint.setPen(QColor(Qt::black)); // line for 100 % load
            paint.drawLine(19,3,22,3);
            if (!m_statusWarningValue) paintOKPoint(paint);
            else paintErrorPoint(paint);
            paint.end();
            }
          else {
            QPainter paint;
            copyBlt (m_mainLayer,0,0,&m_battPix,0,0,24,24); // icon of Battery
            paint.begin(m_mainLayer);
            if (m_batteryChargeValue != knc::numberVarError) {
              if (m_batteryChargeValue < 40) paint.setPen(Qt::red);
              else paint.setPen(Qt::black);
              if (m_batteryChargeValue < 40) paint.setPen(Qt::red);
              else {
                if (m_batteryChargeValue < 50) paint.setPen(Qt::yellow);
                else paint.setPen(Qt::green);
                }
              int delka = abs((16*m_batteryChargeValue)/100);
              delka += abs((delka-1)/4) -1;
              paint.drawLine (2,7,2+delka,7);
              paint.drawLine (2,8,2+delka,8);
              paint.drawLine (2,9,2+delka,9);
              }
            paint.end();
            }
        break;
        }
      toolTip(m_runtimeValue, m_statusValue, m_batteryChargeValue, m_upsLoadValue);

      setPixmap(*m_mainLayer);
      }
    }
  else { // KNutNet->state isn't  connected
     // we must test activeUpsInfo->netError because error can rise higher level
    if (m_activeUpsInfo->netError)
      m_dataOk = error; // error is value not variable
    else {
      if ((m_activeUpsInfo->upsNet->getState() == KNutNet::Connecting) ||
        (m_activeUpsInfo->upsNet->getState() == KNutNet::HostLookup))
        m_dataOk = connecting;
      else m_dataOk = idle; 
      } 
    if ((m_dataOk != m_dataOkOld) or always) {
      toolTip(0, -1, 0, 0);
      m_dataOkOld=m_dataOk; 
      if (m_dataOk == connecting) setPixmap(m_connectPix);
      else {
        if (m_dataOk == error) setPixmap(m_errorPix);
        else  {
          setPixmap(m_mainPix);
          }
        }
      }
    }
  repaint();
  }



void KNutDock::toolTip (int runtime, int status, int batteryCharge, int upsLoad ) {

  QString text;
  QString manufacturer = "";
  QString upsModel = "";
  QString serial = "";
  QString firmware = "";
  int myNetErr = 0;

  int min = abs(runtime/60);
  int sec = runtime - (min*60);

  if (m_activeUpsInfo->upsNet != 0) {
    myNetErr= m_activeUpsInfo->upsNet->getError();
    switch (m_activeUpsInfo->nutVariables) {
      case 1:
        manufacturer = m_activeUpsInfo->upsNet->readStringVar("MFR");
        upsModel = m_activeUpsInfo->upsNet->readStringVar("MODEL");
        serial = m_activeUpsInfo->upsNet->readStringVar("SERIAL");
        firmware = m_activeUpsInfo->upsNet->readStringVar("FIRMREV");
      break;
      case 2:
        manufacturer = m_activeUpsInfo->upsNet->readStringVar("ups.mfr");
        upsModel = m_activeUpsInfo->upsNet->readStringVar("ups.model");
        serial = m_activeUpsInfo->upsNet->readStringVar("ups.serial");
        firmware = m_activeUpsInfo->upsNet->readStringVar("ups.firmware");
      break;
      }
    }

  text = i18n("Name")+" : "+m_activeUpsInfo->record.name + "\n"
  +i18n("UPS name")+" : "+m_activeUpsInfo->record.upsName + "\n"
  +i18n("UPS address")+" : "+m_activeUpsInfo->record.upsAddress +"\n"
  +i18n("Status : ");

  if (status == -1) {
    text += i18n("Connection doesn't exist.");
    }
  else {
    if (status & KNutNet::OL) {
      text += i18n("UPS On line");
      }
    else {
      if (status & KNutNet::OB) {
        text += i18n("UPS On battery");
        }
      else {
        if (status & KNutNet::OFF) {
          text += i18n("UPS Of line");
          }
        }  
      }

    if (status & KNutNet::LB) {
      text += "\n" + i18n("Status : ") + i18n("UPS Battery is low");
      }
    if (status & KNutNet::RB) {
      text += "\n" + i18n("Status : ") + i18n("Replace battery");
      }
    if (status & KNutNet::CAL) {
      text += "\n" + i18n("Status : ") + i18n("UPS is performing calibration");
      }
    if (status & KNutNet::OVER) {
      text += "\n" + i18n("Status : ") + i18n("UPS is Overload");
      }
    if (status & KNutNet::TRIM) {
      text += "\n" + i18n("Status : ") + i18n("UPS is trimming voltage");
      }
    if (status & KNutNet::BOOST) {
      text += "\n" + i18n("Status : ")+ i18n("UPS is boosting voltage");
      }


    }
  if ((status == -1) && (myNetErr != KNutNet::NoError)) {
    text += "\n" + i18n("Error : ")+ KNutVarData::errorToText(myNetErr);
    }

  if (m_toolTipFlags & TTMFR) text += "\n" + i18n("Manufac. : ")+ manufacturer;

  if (m_toolTipFlags & TTModel) text += "\n" + i18n("Name")+" : "+ upsModel;

  if (m_toolTipFlags & TTSerial) text += "\n" + i18n("Serial")+" : "+ serial;

  if (m_toolTipFlags & TTFirm) text += "\n" + i18n("Firmware")+" : "+ firmware;

  if (m_toolTipFlags & TTRun) {
    if (runtime != knc::numberVarError)
      text += "\n" + i18n("Runtime") + i18n(" : %1:%2 min").arg(min).arg(sec);
    }

  if (m_toolTipFlags & TTCharge) {
    if (batteryCharge != knc::numberVarError)
      text += "\n" + i18n("Battery Charge") + QString(" : %1 %").arg(batteryCharge);
    }

  if (m_toolTipFlags & TTLoad) {
    if (upsLoad != knc::numberVarError)
      text += "\n" + i18n("UPS Load") + QString(" : %1 %").arg(upsLoad);
    }

  QToolTip::remove(this);
  QToolTip::add(this,text);
 }

 
 
/*********************************************************************************************/
/*                                                                                           */
/*                         PRIVATE SLOTS                                                     */
/*                                                                                           */
/*********************************************************************************************/
 
 void KNutDock::slotShowMyAbout() {
  KAboutApplication *dialog;

  dialog= new KAboutApplication;
  dialog->exec();
  delete dialog;
}

void KNutDock::slotExitApplication (void) {

  if (m_settingData->areYouSure) {
    if (KMessageBox::warningYesNo (0,i18n("Are you sure ?")) == 3)
      emit endApplication();
    }
  else emit endApplication();
  }

void KNutDock::slotUpsName(int i) {

  emit UPSChanged(m_upsRecords->getName(i-101));
  }


void KNutDock::slotMinimize(void) {

  emit minimize ();
  }

void KNutDock::slotPreferences(void) {

  emit preferences();
  }

void KNutDock::slotPrintUPSVars(void) {

  emit printUPSVars();
  }

void KNutDock::slotInstComms(void) {

  emit instComms();
  }

void KNutDock::slotRWVars(void) {

  emit RWVars();
  }

void KNutDock::slotRefreshConnection(void) {

  emit makeRefreshConnection();
  }


//------------------------------------------

void KNutDock::mousePressEvent(QMouseEvent *e) {

//qDebug("KNutDock::mousePressEvent");
  if( e->button()==LeftButton  ) emit activeMainWindow();
  if( e->button()==RightButton ) m_menu->popup(e->globalPos());
  }




void KNutDock::paintEvent (QPaintEvent *e) {

  KSystemTray::paintEvent(e);
  if ((m_activeUpsInfo->upsNet->getState() == KNutNet::Connected) and
     (m_statusValue != KNutNet::NS)) { // When driver isn't connected, getState is connected and m_statusValue is NS // NONE STATUS
    if (m_typeOfIcon == pictureKI) {
      QPainter painter(this);
//      painter.begin();
      if (m_statusValue & KNutNet::OL) {  // ONLINE - icon of UPS
        painter.setPen(Qt::black);
        paintNumbers (m_upsLoadValue, -2, 15, &painter );
        }
      else {  // OFFLINE icon of battery
        if (m_batteryChargeValue != knc::numberVarError) {
          if (m_batteryChargeValue < 40) painter.setPen(Qt::red);
          else painter.setPen(Qt::black);
          paintNumbers(m_batteryChargeValue,-2,16,&painter);
          }
        else {
          painter.setPen(Qt::black);
          paintDash (3,16,&painter);
          paintDash (8,16,&painter);
          }
        }
 //     painter.end();
      }
    }
  }




/*********************************************************************************************/
/*                                                                                           */
/*                         PRIVATE FUNCTIONS                                                 */
/*                                                                                           */
/*********************************************************************************************/

void KNutDock::clearValues(void) {

  m_batteryChargeValue = 0;
  m_runtimeValue = 0;
  m_upsLoadValue = 0;
  m_statusValue = 0;
  }


void KNutDock::createUpsMenu(void) {

  int n = m_upsRecords->getCount();
  for (int i =0; i < n; i++) {
    if (m_activeUpsInfo->record.name == m_upsRecords->getName(i))
      m_upsServerMenu->insertItem(kapp->miniIcon(),m_upsRecords->getName(i), this, SLOT(slotUpsName(int)),0,101+i);
    else
      m_upsServerMenu->insertItem(m_upsRecords->getName(i), this, SLOT(slotUpsName(int)),0,101+i);
    }
  }

void KNutDock::createMainMenu(void) {

  m_menu = new KPopupMenu;
  m_upsServerMenu = new KPopupMenu;
  createUpsMenu();

  m_menu->insertTitle (kapp->miniIcon(),"knutclient");
  m_menu->insertSeparator();
  m_menu->insertItem("UPS",m_upsServerMenu);
  m_menu->insertSeparator();
  m_menu->insertItem(i18n("&Showing UPS variables and commands"), this, SLOT(slotPrintUPSVars()));
  m_menu->insertItem(i18n("&Running instant commands"), this, SLOT(slotInstComms()));
  m_menu->insertItem(i18n("Setting R&W variables"), this, SLOT(slotRWVars()));
  m_menu->insertSeparator();
  m_menu->insertItem(SmallIcon("reload"),i18n("Reconnect"), this, SLOT(slotRefreshConnection()));
  m_menu->insertSeparator();
  m_menu->insertItem(SmallIcon("configure"),i18n("&Preferences"), this, SLOT(slotPreferences()));
  m_menu->insertSeparator();
  m_menu->insertItem(kapp->miniIcon(),i18n("&About KNutClient"), this, SLOT(slotShowMyAbout()));
  m_menu->insertSeparator();
  m_menu->insertItem(i18n("&Minimize"), this, SLOT(slotMinimize()));
  m_menu->insertSeparator();
  m_menu->insertItem (SmallIcon("exit"),i18n("&Exit"),this ,SLOT(slotExitApplication()));
  }


void KNutDock::paintCharge (int charge ) {
  QPainter paint;

  m_chargeLayer->fill(Qt::white);
  paint.begin(m_chargeLayer);
  if (charge > 199) charge = 199;

  if (m_typeOfIcon == generalKI) {
    if (charge != knc::numberVarError) {
      if (charge < 40) paint.setPen(Qt::red);
      else paint.setPen(Qt::black);
      paintNumbers(charge,8,2,&paint);
      }
    else {
      paint.setPen(Qt::black);
      paintDash (13,2,&paint);
      paintDash (18,2,&paint);
      }
    }
  else {
    // picture version
    if (charge != knc::numberVarError) {
      if (charge < 40) paint.setPen(Qt::red);
      else paint.setPen(Qt::black);
      paintNumbers(charge,-2,16,&paint);

      if (charge < 40) paint.setPen(Qt::red);
      else {
        if (charge < 50) paint.setPen(Qt::yellow);
        else paint.setPen(Qt::green);
        }
      int delka = abs((16*charge)/100);
      delka += abs((delka-1)/4) -1;
      paint.drawLine (2,7,2+delka,7);
      paint.drawLine (2,8,2+delka,8);
      paint.drawLine (2,9,2+delka,9);
      }
    else {
      paint.setPen(Qt::black);
      paintDash (3,16,&paint);
      paintDash (8,16,&paint);
      }

    }
  paint.end();
  }


void KNutDock::paintErrorPoint ( QPainter& paint ) {

  paint.setPen(QColor(0,0,255));
  paint.setPen(QColor(255,0,0));

  paint.drawLine(19,18,21,18);
  paint.drawLine(19,19,21,19);
  paint.drawLine(19,20,21,20);
  }


void KNutDock::paintOKPoint (QPainter& paint  ) {

  paint.setPen(QColor(0,255,0));
  paint.drawLine(19,18,21,18);
  paint.drawLine(19,19,21,19);
  paint.drawLine(19,20,21,20);
  }


void KNutDock::paintStatus (int status ) {
  QPainter paint;
  int lastPos = 0;

  m_statusLayer->fill(Qt::white);
  paint.begin(m_statusLayer);

  if (status & KNutNet::OL) {
    paint.setPen(Qt::black);
    paintChar (1,2,'P',&paint);
    }
  else {
    if (status & KNutNet::OB) {
      paint.setPen(Qt::red);
      paintChar (1,2,'B',&paint);
      }
    }

  if (status & KNutNet::LB) {
    paint.setPen(Qt::red);
    paintChar (6,2,'L',&paint);
    }
  if ((lastPos <2) && (status & KNutNet::RB)) {
    paint.setPen(Qt::red);
    paintChar (6,2,'R',&paint);
    lastPos++;
    }
  if ((lastPos <2) && (status & KNutNet::BOOST)) {
    paint.setPen(Qt::red);
    paintChar (6,2,'B',&paint);
    lastPos++;
    }
  if ((lastPos <2) && (status & KNutNet::TRIM)) {
    paint.setPen(Qt::red);
    paintChar (6,2,'T',&paint);
    lastPos++;
    }
  if ((lastPos <2) && (status & KNutNet::CAL)) {
    paint.setPen(Qt::red);
    paintChar (6,2,'C',&paint);
    lastPos++;
    }
  paint.end();
  }

void KNutDock::paintRuntime (int runtime, int status ) {
  QPainter paint;

  m_runtimeLayer->fill(Qt::white);
  paint.begin(m_runtimeLayer);

  if (status & KNutNet::OB)
    paint.setPen(Qt::red);
  else
    paint.setPen(Qt::black);
  if (runtime != knc::numberVarError) {

    int min = abs(runtime/60);
    int sec = runtime - (min*60);

    paintNumber(1,11, abs(min/10) ,&paint);
    paintNumber(6,11,min-((abs(min/10))*10) ,&paint);
    paintNumber(13,11, abs(sec/10) ,&paint);
    paintNumber(18,11,sec-((abs(sec/10))*10) ,&paint);
    }
  else {
    paintDash (1,11,&paint);
    paintDash (6,11,&paint);
    paintDash (13,11,&paint);
    paintDash (18,11,&paint);
    }
  paint.drawLine (11,12,11,13);
  paint.drawLine (11,15,11,16);
  paint.end();
  }

void KNutDock::paintLoad (int load ) {
  QPainter paint;
  int myLoad;

//  if (m_typeOfIcon != generalKI) bitBlt (m_loadLayer,0,0,m_upsLayer,0,0,24,24,AndROP);
  m_loadLayer->fill(Qt::white);
  paint.begin(m_loadLayer);
  if (load == knc::numberVarError) myLoad=0;
  else myLoad = abs(load/10);

  if (m_typeOfIcon == generalKI) {
    if (load != knc::numberVarError) {
      if (myLoad > 11) myLoad=11;
      if (myLoad < 9) paint.setPen(Qt::green);
      else {
      if (myLoad < 11) paint.setPen(Qt::yellow);
      else paint.setPen(Qt::red);
      }
    paint.setPen(Qt::green.light(60));
    for (int i = 0; i < myLoad; i++) {
      paint.drawLine((i*2)+1,19,(i*2)+1,21);
      }
    paint.setPen(Qt::cyan.light(150));
      for (int i = myLoad; i < 11; i++) {
        paint.drawLine((i*2)+1,19,(i*2)+1,21);
      }
    }
  }
  paint.end();

  }




void KNutDock::paintNumbers (int numbers, int x, int y, QPainter* p ) {
  bool first = false;

  if (numbers > 199) numbers = 199;

  if (numbers != knc::numberVarError) {

    if (numbers > 99) {
      paintNumber (x,y,1,p);
      numbers -= 100;
      first=true;
      }
    int second = abs (numbers/10);
    int third = numbers - (second * 10);

    if ((second != 0) || (first)) paintNumber (x+5,y,second,p);
    paintNumber (x+10,y,third,p);

    }
  else {
    p->setPen(Qt::black);
    paintDash (x+5,y,p);
    paintDash (x+10,y,p);
    }
  }


void KNutDock::paintDash (int x, int y, QPainter *p) {

  p->drawLine(x,y+3,x+3,y+3);
  }

void KNutDock::paintNumber (int x, int y, int number, QPainter *p) {
  // x and y are left top corner

  if ((number > -1) && (number < 10)) {
   // painting - kreslim
    switch (number) {
      case 0:
      p->drawRect(x,y,4,7);
      break;
      case 1:
        p->drawLine (x+3,y,x+3,y+6);
      break;
      case 2:
        p->drawLine(x,y,x+3,y);
        p->lineTo(x+3,y+3);
        p->lineTo(x,y+3);
        p->lineTo(x,y+6);
        p->lineTo(x+3,y+6);
      break;
      case 3:
        p->drawLine(x,y,x+3,y);
        p->lineTo(x+3,y+6);
        p->lineTo(x,y+6);
        p->drawLine(x,y+3,x+3,y+3);
      break;
      case 4:
        p->drawLine(x,y,x,y+3);
        p->lineTo(x+3,y+3);
        p->drawLine (x+3,y,x+3,y+6);
      break;
      case 5:
        p->drawLine(x+3,y,x,y);
        p->lineTo(x,y+3);
        p->lineTo(x+3,y+3);
        p->lineTo(x+3,y+6);
        p->lineTo(x,y+6);
      break;
      case 6:
        p->drawRect(x,y+3,4,4);
        p->drawLine(x,y+3,x,y);
        p->lineTo(x+3,y);
      break;
      case 7:
        p->drawLine(x,y,x+3,y);
        p->lineTo(x+3,y+6);
      break;
      case 8:
        p->drawRect(x,y,4,7);
        p->drawLine(x,y+3,x+3,y+3);
      break;
      case 9:
        p->drawRect(x,y,4,4);
        p->drawLine(x+3,y+3,x+3,y+6);
        p->lineTo(x,y+6);
      break;
      }
    } 
  }


void KNutDock::paintChar (int x, int y, char LCDChar, QPainter *p) {
  // x and y are left up  corner
  switch (LCDChar) {
    case 'L':
      p->drawLine(x,y,x,y+6);
      p->lineTo(x+3,y+6);
    break;
    case 'O':
      p->drawRect(x,y,4,7);
    break;
    case 'B':
      p->drawLine(x,y,x,y+6);
      p->lineTo(x+2,y+6);
      p->drawLine(x,y,x+2,y);
      p->drawLine(x,y+3,x+2,y+3);
      p->drawLine(x+3,y+1,x+3,y+2);
      p->drawLine(x+3,y+4,x+3,y+5);
    break;
    case 'U':
      p->drawLine(x,y,x,y+6);
      p->lineTo(x+3,y+6);
      p->lineTo(x+3,y);
    break;
    case 'C':
      p->drawLine(x+3,y+1,x+3,y);
      p->lineTo(x,y);
      p->lineTo(x,y+6);
      p->lineTo(x+3,y+6);
      p->lineTo(x+3,y+5);
    break;
    case 'R':
      p->drawLine(x,y,x,y+6);
      p->drawLine(x,y,x+2,y);
      p->drawLine(x,y+3,x+2,y+3);
      p->drawLine(x+3,y+1,x+3,y+2);
      p->drawLine(x+3,y+4,x+3,y+6);
    break;
    case 'P':
      p->drawLine(x,y,x,y+6);
      p->drawLine(x,y,x+2,y);
      p->drawLine(x,y+3,x+2,y+3);
      p->drawLine(x+3,y+1,x+3,y+2);
    break;
    case 'T':
      p->drawLine(x+2,y,x+2,y+6);
      p->drawLine(x,y,x+4,y);
    break;
    }
  }




#include "knutdock.moc"
