// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.1 $

//***********************************************
//***  hk_kdemodule PART definition             ***
//***********************************************
#include "hk_kdemodulepart.h"
#include "hk_kdemodulepartfactory.h"
#include <kinstance.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kaction.h>
#include <klocale.h>
#include <kurl.h>
#include <kactionclasses.h>
#include <kparts/partmanager.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <qcombobox.h>
#include <hk_drivermanager.h>
#include <hk_connection.h>
#include <hk_database.h>
#include <hk_datasource.h>
class hk_kdemodulepartprivate
{
  public:
  hk_kdemodulepartprivate()
  	{
		p_module=NULL;
		activate=false;
	}
   hk_kdemodulepartwidget* p_module;
   bool activate;
};

hk_kdemodulepart::hk_kdemodulepart(QWidget* pWidget, const char* /*widgetname*/,QObject* parent, const char* name, const QStringList &)
:KParts::ReadWritePart(parent,name)
{
    p_private=new hk_kdemodulepartprivate;
    setInstance(hk_kdemodulepartfactory::instance());
    p_private->p_module = new hk_kdemodulepartwidget(this,pWidget,0,WDestructiveClose);
    setWidget(p_private->p_module);
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
     setXMLFile(locate("data","hk_kdeclasses/hk_kdemodulepart.rc"));
    
    
    p_private->p_module->p_printaction=new KAction(i18n("&Print"),"fileprint",0,p_private->p_module,SLOT(print()),actionCollection(),"print");

//p_private->p_printaction->setEnabled(false);
    //p_private->p_module->p_closeaction=new KAction(i18n("&Close"),"fileclose",0,p_private->p_module,SLOT(close_module()),actionCollection(),"closemodule");
    p_private->p_module->p_saveaction=new KAction(i18n("&Save"),"filesave",0,p_private->p_module,SLOT(savebutton_clicked()),actionCollection(),"save");
    p_private->p_module->p_saveaction->setEnabled(false);

    p_private->p_module->p_saveasaction=new KAction(i18n("Save &as"),"filesaveas",0,p_private->p_module,SLOT(saveasbutton_clicked()),actionCollection(),"saveas");
    p_private->p_module->p_saveasaction->setEnabled(!p_private->p_module->runtime_only());


        p_private->p_module->p_cutaction=new KAction(i18n("Cu&t"),"editcut",CTRL+Key_X,p_private->p_module,SLOT(cut_clicked()),actionCollection(),"cut");
        p_private->p_module->p_undoaction=new KAction(i18n("&Undo"),"undo",CTRL+Key_Z,p_private->p_module,SLOT(undo_clicked()),actionCollection(),"undo");

        p_private->p_module->p_redoaction=new KAction(i18n("Re&do"),"redo",CTRL+SHIFT+Key_Z,p_private->p_module,SLOT(redo_clicked()),actionCollection(),"redo");

        p_private->p_module->p_copyaction=new KAction(i18n("&Copy"),"editcopy",CTRL+Key_C,p_private->p_module,SLOT(copy_clicked()),actionCollection(),"copy");
        p_private->p_module->p_pasteaction=new KAction(i18n("&Paste"),"editpaste",CTRL+Key_V,p_private->p_module,SLOT(paste_clicked()),actionCollection(),"paste");
        p_private->p_module->p_replaceaction=new KAction(i18n("&Replace"),0,CTRL+Key_R,p_private->p_module,SLOT(replace_clicked()),actionCollection(),"replace");
        p_private->p_module->p_findaction=new KAction(i18n("&Find"),"find",CTRL+Key_F,p_private->p_module,SLOT(find_clicked()),actionCollection(),"find");
        p_private->p_module->p_findaction=new KAction(i18n("Find &Next"),"forward",Key_F3,p_private->p_module,SLOT(findnext_clicked()),actionCollection(),"findnext");
        p_private->p_module->p_findaction=new KAction(i18n("Find Pre&vious"),"previous",SHIFT+Key_F3,p_private->p_module,SLOT(findprevious_clicked()),actionCollection(),"findprevious");



        p_private->p_module->p_selectallaction=new KAction(i18n("Select &All"),0,CTRL+Key_A,p_private->p_module,SLOT(selectall_clicked()),actionCollection(),"selectall");

        p_private->p_module->p_configeditoraction=new KAction(i18n("Configure &editor"),0,0,p_private->p_module,SLOT(configeditor_clicked()),actionCollection(),"configeditor");




}

hk_kdemodulepart::~hk_kdemodulepart()
{
  if (widget())
  {
    if (p_private->p_module->has_changed())
     p_private->p_module->save_module();
  }
  delete p_private;
}



/*void hk_kdemodulepart::show_dbdesignercolumndialog(void)
{
    p_private->p_table->simpledbdesigner()->show_dbdesignercolumndialog();
}*/


void hk_kdemodulepart::setReadWrite(bool rw)
{
    KParts::ReadWritePart::setReadWrite(rw);
}


bool hk_kdemodulepart::openFile()
{
 // URL handling:   mysql:/user:password@host:port/databasename/datasourcetype/datasourcename
 // where datasourcetype is either tables or queries


    return true;
}


bool hk_kdemodulepart::saveFile()
{
    return true;
}






KAboutData* hk_kdemodulepart::createAboutData()
{
    KAboutData* a= new KAboutData("hk_kdemodulepart", I18N_NOOP("hk_kdemodulepart"),
        "0.1", I18N_NOOP("database module editor"),
        KAboutData::License_GPL,"(c) 2002-2006, Horst Knorr <hk_classes@knoda.org>");

    return a;

}





