/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "prefgeneral.h"

PrefGeneral::PrefGeneral(QWidget* parent, const char* name, WFlags fl)
: PrefGeneralLayout(parent,name,fl)
{
	m_dbChooseBtn->setIconSet(KGlobal::iconLoader()->loadIcon("fileopen", KIcon::Small, 0, false));
	m_tmpChooseBtn->setIconSet(KGlobal::iconLoader()->loadIcon("fileopen", KIcon::Small, 0, false));
	m_decodeChooseBtn->setIconSet(KGlobal::iconLoader()->loadIcon("fileopen", KIcon::Small, 0, false));
	//Check if configuration entries exist, else put defaults...
	m_dbEdit->setText(Config().dbDir );
	m_tmpEdit->setText(Config().tmpDir);
	m_decodeEdit->setText(Config().decodeDir);
	connect(m_dbChooseBtn, SIGNAL(clicked()), this, SLOT(slotSelectDbDir()));
	connect(m_tmpChooseBtn, SIGNAL(clicked()), this, SLOT(slotSelectTmpDir()));
	connect(m_decodeChooseBtn, SIGNAL(clicked()), this, SLOT(slotSelectDecodeDir()));
	
}

PrefGeneral::~PrefGeneral()
{
}

void PrefGeneral::slotSelectDecodeDir( )
{
	KURL uri = KDirSelectDialog::selectDirectory(m_decodeEdit->text().stripWhiteSpace() , true, this, "Please select a directory");
	if (!uri.isEmpty())
		 m_decodeEdit->setText(uri.path(1));
	
}

void PrefGeneral::slotSelectTmpDir( )
{
	KURL uri = KDirSelectDialog::selectDirectory(m_tmpEdit->text().stripWhiteSpace() , true, this, "Please select a directory");
	if (!uri.isEmpty())
		 m_tmpEdit->setText(uri.path(1));
}

void PrefGeneral::slotSelectDbDir( )
{
	KURL uri = KDirSelectDialog::selectDirectory(m_dbEdit->text().stripWhiteSpace() , true, this, "Please select a directory");
	if (!uri.isEmpty()) 
		m_dbEdit->setText(uri.path(1));
	 
}

/*$SPECIALIZATION$*/


#include "prefgeneral.moc"

