/***************************************************************************
                          kfocusview.h  -  description
                             -------------------
    begin                : Sun Aug 12 08:36:08 PDT 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : jeffyu@cs.stanford.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFOCUSVIEW_H
#define KFOCUSVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>

// Forward declaration of KFocus classes
class KFocusDoc;
class KFVProjectList;

/** The KFocusView class provides the view widget for the KFocusApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KFocusView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KFocusApp class to manipulate and display
 * the document structure provided by the KFocusDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KFocusView : public QWidget
{
  Q_OBJECT
public:
  /** Constructor for the main view */
  KFocusView(QWidget *parent = 0, const char *name=0);
  /** Destructor for the main view */
  ~KFocusView();

  /** returns a pointer to the document connected to the view instance. Mind that this method requires a KFocusApp instance as a parent
   * widget to get to the window document pointer by calling the KFocusApp::getDocument() method.
   *
   * @see KFocusApp#getDocument
   */
  KFocusDoc *getDocument() const;

  /** contains the implementation for printing functionality */
  void print(QPrinter *pPrinter);
	
public slots: // Public slots
  /** Put the ui into the base state (empty doc) */
  void enterBaseState();
  /** Slot to put the view in an active state */
  void enterActiveState();

private: // Private attributes
	KFVProjectList* vProjectList_;

private: // Private methods
  /** Create the widgest that go in this view */
  void createWidgets();

};

#endif // KFOCUSVIEW_H
