/** -*-C-*-ish
    MySQL interface library for Kaya
    Copyright (C) 2005,2006 Chris Morris

    Based on the Postgres interface library Copyright (C) 2004, 2005
    Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence. When linked against a version
    of libmysqlclient that is GPL licensed then you must either use section 3
    of the LGPL to change the copy used for linking to GPL, or use the FLOSS
    Exception published by MySQL if that is applicable to your circumstances.
*/

#include "my_inter.h"
#include <VMState.h>
#include <KayaAPI.h>
#include <cstring>

MyRes::MyRes()
{
    myres = NULL;
    rows = 0;
    cols = 0;
    colnames = NULL;
    res_table = NULL;
}

void* do_mysql_connect(KString rawhost, KString rawuser, KString rawpass, KString rawdb, KInt rawport)
{
  char* host = CSTRING(rawhost);
  char* user = CSTRING(rawuser);
  char* pass = CSTRING(rawpass);
  char* db = CSTRING(rawdb);
  int port = CINT(rawport);

  MYSQL* mc = mysql_init(NULL);
  mc = mysql_real_connect(mc,host,user,pass,db,port,NULL,0);

  MyCon * myc = new MyCon();
  myc->con = mc;
  myc->ok = 1;
  if (mc == NULL) {
    myc->ok = 0;
  }    
  return (void*)myc;
}

bool my_ok(void* conn)
{
    MyCon* myc = (MyCon*)conn;
//    cout << pgc->ok << endl;
    return myc->ok;
}

/*wchar_t* pg_getError(void* conn)
{
    PGconn* pgc = ((PGCon*)conn)->con;
    return strtowc(PQerrorMessage(pgc));
}*/
/* we don't need this function for now, and it needs calling something else when we do bring it back
DBtype getDBtype(wchar_t* rawval)
{
  // MySQL doesn't appear to have a convenient type interface
  return DBTEXT;
} */


void* do_mysql_query(void* vmptr,void* conn,KString rawquery)
{
  char* query = CSTRING(rawquery);
  VMState* vm = (VMState*)vmptr;
  MyCon* myc = (MyCon*)conn;

  int success = mysql_query(myc->con,query);
  if (success!=0) {
    // TODO: make this more helpful
    vm->kaya_internalError(1);
  }
  MYSQL_RES* res = mysql_store_result(myc->con);

  MyRes* myr = new MyRes();
  if (res != NULL) {
    int numrows = mysql_num_rows(res);
    int numflds = mysql_num_fields(res);
    
    KayaArray resarray = newKayaArray(numrows);

    for(int i = 0; i<numrows; i++) {
      KayaArray row = newKayaArray(numflds);
      MYSQL_ROW myrow = mysql_fetch_row(res);
      for(int j = 0; j<numflds; j++) {
	char* val = myrow[j];
	KayaValue pv,fld;
	pv = KayaString(KSTRING(val));
	fld = KayaUnion(0,1);
	KayaUnionSetArg(fld,0,pv);
	KayaArrayPush(row,fld);
      }
      KayaArrayPush(resarray,KayaArrayVal(row));
    }

    KayaArray colarray = newKayaArray(numflds);
    MYSQL_FIELD* mfields = mysql_fetch_fields(res);
    for(int k = 0; k<numflds; k++) {
      char* fn = mfields[k].name;
      KayaValue fname = KayaString(KSTRING(fn));
      KayaArrayPush(colarray,fname);
    }

    myr -> res_table = resarray;
    myr -> rows = numrows;
    myr -> cols = numflds;
    myr -> colnames = colarray;

    mysql_free_result(res);
  }
  return myr;
}

void* do_mysql_incquery(void* vmptr,void* conn,KString rawquery)
{
  char* query = CSTRING(rawquery);
  VMState* vm = (VMState*)vmptr;
  MyCon* myc = (MyCon*)conn;

  int success = mysql_query(myc->con,query);
  if (success!=0) {
    // TODO: make this more helpful
    vm->kaya_internalError(1);
  }
  MYSQL_RES* res = mysql_store_result(myc->con);
  MyRes* myr = new MyRes();
  if (res != NULL) {
    int numrows = mysql_num_rows(res);
    int numflds = mysql_num_fields(res);
    
    KayaArray colarray = newKayaArray(numflds);
    MYSQL_FIELD* mfields = mysql_fetch_fields(res);
    for(int k = 0; k<numflds; k++) {
      char* fn = mfields[k].name;
      KayaValue fname = KayaString(KSTRING(fn));
      KayaArrayPush(colarray,fname);
    }

    myr -> rows = numrows;
    myr -> cols = numflds;
    myr -> colnames = colarray;
    myr -> myres = res;
  }
  return myr;
}

Array* my_getrow(void* vmptr, void* resptr) {
  VMState* vm = (VMState*)vmptr;
  MYSQL_RES* res = ((MyRes*)resptr)->myres;
  int numflds = mysql_num_fields(res);
  KayaArray row = newKayaArray(numflds);
  MYSQL_ROW myrow = mysql_fetch_row(res);
  if (myrow == NULL) {
      vm->kaya_internalError(2);
  }
  for(int j = 0; j<numflds; j++) {
    char* val = myrow[j];
    KayaValue pv,fld;
    pv = KayaString(KSTRING(val));
    fld = KayaUnion(0,1);
    KayaUnionSetArg(fld,0,pv);
    KayaArrayPush(row,fld);
  }
  return row;
}

void my_discard(void* resptr) {
  MYSQL_RES* res = ((MyRes*)resptr)->myres;
  mysql_free_result(res);
}

Array* my_getstrs(void* res)
{
    return ((MyRes*)res)->res_table;
}

Array* my_colnames(void* res)
{
    return ((MyRes*)res)->colnames;
}

int my_numrows(void* res)
{
    return ((MyRes*)res)->rows;
}

int my_numcols(void* res)
{
    return ((MyRes*)res)->cols;
}

void do_mysql_close(void* conn)
{
    mysql_close(((MyCon*)conn)->con);
}

void* do_mysqlprepare(wchar_t* query) {
  return (void*)CSTRING(query);
}

void* do_mysql_execp(void* vmptr, void* conn, void* queryptr, KArray params) {
  char* query = (char*)queryptr;
  VMState* vm = (VMState*)vmptr;
  MyCon* myc = (MyCon*)conn;

  MYSQL_STMT* stmt = mysql_stmt_init(myc->con);
  int prep = mysql_stmt_prepare(stmt,query,strlen(query));
  if (prep!=0) {
    // TODO: make this more helpful
    vm->kaya_internalError(1);
  }
  
  int sz = KayaArraySize(params);
  MYSQL_BIND bind[sz];
  unsigned long lens[sz]; 
  memset(bind, 0, sizeof(bind));
  my_bool is_true = (my_bool)1;
  for (int i=0;i<sz;i++) {
    KValue val = KayaArrayLookup(params,i);
    if (KayaUnionGetTag(val) == 0) {
      bind[i].buffer_type = MYSQL_TYPE_NULL;
    } else {
      bind[i].buffer_type = MYSQL_TYPE_STRING;
      char* param = CSTRING(KayaGetString(KayaUnionGetArg(val,0)));
      bind[i].buffer = (void*)param;
      lens[i] = strlen(param);
      bind[i].buffer_length = lens[i];
      bind[i].length = &(lens[i]);
      bind[i].is_null = 0;
      bind[i].is_unsigned = true;
    }
  }

  my_bool bound = mysql_stmt_bind_param(stmt,bind);

  int success = mysql_stmt_execute(stmt);
  if (success!=0) {
    // TODO: make this more helpful
    vm->kaya_internalError(1);
  }

  MYSQL_RES* res = mysql_stmt_result_metadata(stmt);
  MyRes* myr = new MyRes();
  if (res != NULL) {
    /* CIM: What on earth convinced the MySQL developers that this
       byzantine mess made a decent C API for prepared statements?! 
       If Postgres and SQLite can have an API where executing a prepared
       statement returns the results in much the same format as a normal
       statement, why does MySQL have this mess where you have to know
       what the statement result rows will contain before you get them...
    */
    
    int asuccess = mysql_stmt_attr_set(stmt,STMT_ATTR_UPDATE_MAX_LENGTH,&is_true);
    int ssuccess = mysql_stmt_store_result(stmt);

    int numrows = mysql_stmt_num_rows(stmt);
    int numflds = mysql_num_fields(res);
    
    KayaArray resarray = newKayaArray(numrows);
    MYSQL_FIELD* mfields = mysql_fetch_fields(res);
    
    MYSQL_BIND rbind[numflds];
    memset(rbind, 0, sizeof(rbind));

    unsigned long rlength[numflds];
    my_bool rnull[numflds];
    for(int i=0;i<numflds;i++) {
      rbind[i].buffer_type = MYSQL_TYPE_STRING;
      // at least it's possible to find this out without trial and error!
      unsigned long bsz = mfields[i].max_length;
      rbind[i].buffer = (char*)GC_MALLOC_ATOMIC((bsz+1)*sizeof(char));
      rbind[i].buffer_length = bsz+1;
      rbind[i].is_null = &rnull[i];
      rbind[i].length = &rlength[i];
    }

    mysql_stmt_bind_result(stmt,rbind);

    for(int i = 0; i<numrows; i++) {
      KayaArray row = newKayaArray(numflds);
      int fsuccess = mysql_stmt_fetch(stmt);
      
      for(int j = 0; j<numflds; j++) {
	KayaValue pv,fld;
	pv = KayaString(KSTRING((char*)rbind[i].buffer));
	fld = KayaUnion(0,1);
	KayaUnionSetArg(fld,0,pv);
	KayaArrayPush(row,fld);
      }
      KayaArrayPush(resarray,KayaArrayVal(row));
    }

    KayaArray colarray = newKayaArray(numflds);
    for(int k = 0; k<numflds; k++) {
      char* fn = mfields[k].name;
      KayaValue fname = KayaString(KSTRING(fn));
      KayaArrayPush(colarray,fname);
    }

    myr -> res_table = resarray;
    myr -> rows = numrows;
    myr -> cols = numflds;
    myr -> colnames = colarray;

    mysql_free_result(res);
  }
  return myr; 
}
