from basicTests import jppyTest
import unittest
import os
import mx.DateTime

import jppy
from jppy.printers import contact_printer, contact_label, todos_printer

class todosPrinterTest(jppyTest):
    def runTest(self):
        pass

class contactPrinterTest(jppyTest):
    def runTest(self):
        contact = jppy.Contact()
        contact['firstname'] = "Jack"
        contact['lastname'] = "Brown"
        contact['zip1'] = "NG12 1BX"
        contact['phone1'] = "at-home-12345"
        contact['type1'] = jppy.addressBook().getPhoneLabels().index('Home')
        contact['phone2'] = "there@somewhere.com"
        contact['type2'] = jppy.addressBook().getPhoneLabels().index('Email')
        contact.log("This is a test log entry")
        contact.category = 2
        render = contact_printer(jppy.addressBook(),contact)
        filename = render.filename
        self.assertEqual(os.path.isfile(filename),1)
        #os.system("acroread %s" % render.filename)
        
        if os.path.getsize(render.filename) < 100:
            self.fail("PDF is less than 100 bytes, which is likely broken.")
        del render
        # make sure it cleans up after itself
        self.assertEqual(os.path.isfile(filename),0)

class todosPrinterTest(jppyTest):
    def runTest(self):
        tasklist = jppy.taskList()
        for i in range(0,10):
            t = jppy.Todo()
            t['description'] = "Todo item %d" % i
            t['due'] = mx.DateTime.now() + i
            t['priority'] = 3
            tasklist.save(t)
        todos = tasklist.records()
        render = todos_printer(tasklist, todos)
        filename = render.filename
        self.assertEqual(os.path.isfile(filename),1)
        #os.system("acroread %s" % render.filename)        
        if os.path.getsize(render.filename) < 100:
            self.fail("PDF is less than 100 bytes, which is likely broken.")
        del render
        # make sure it cleans up after itself
        self.assertEqual(os.path.isfile(filename),0)

def suite():
    suite  = unittest.TestSuite()
    suite.addTest(contactPrinterTest())
    suite.addTest(todosPrinterTest())    
    return suite




