#include <Python.h>
#include "pytype_contacts.h"
#include "pytype_basics.h"

/* Here we're using ContactObject as if it were a parent class for all
   TodoObject, et. al. */

void SetBasicRecordObjectAttributeDefaults(PyObject *self, int (*packer)( )) {
  ((PyPiContact*)self)->saved_br.size = 0;
  ((PyPiContact*)self)->saved_br.buf = NULL;
  ((PyPiContact*)self)->deleted = 0;
  ((PyPiContact*)self)->modified = 0;
  ((PyPiContact*)self)->busy = 0;
  ((PyPiContact*)self)->secret = 0;
  ((PyPiContact*)self)->archived = 0;
  ((PyPiContact*)self)->category = 0;
  ((PyPiContact*)self)->unique_id = 0;
  ((PyPiContact*)self)->unsaved_changes = 0;
  ((PyPiContact*)self)->packer = packer;
}

void SetSavedBrAndRTandUniqueIDandAttribs(PCRecType rt, unsigned int unique_id, 
						 unsigned char attrib, int size, 
						 void *buf, PyObject *self) {
  ((PyPiContact*)self)->saved_br.size = size;
  ((PyPiContact*)self)->saved_br.attrib = attrib;
  ((PyPiContact*)self)->saved_br.rt = ((PyPiContact*)self)->rt = rt;
  ((PyPiContact*)self)->saved_br.unique_id = ((PyPiContact*)self)->unique_id = unique_id;
  ((PyPiContact*)self)->saved_br.buf = malloc(size);
  memcpy(((PyPiContact*)self)->saved_br.buf,buf,size);

  ((PyPiContact*)self)->deleted = (attrib & 0x80) ? 1 : 0;
  ((PyPiContact*)self)->modified = (attrib & 0x40) ? 1 : 0;
  ((PyPiContact*)self)->busy = (attrib & 0x20) ? 1 : 0;
  ((PyPiContact*)self)->secret = (attrib & 0x10) ? 1 : 0;

  /* http://cvs.coldsync.org/cgi-bin/viewcvs.cgi/coldsync/libpdb/
     pdb.c?rev=1.44&content-type=text/vnd.viewcvs-markup 
     The archived bit is only set, if deleted is set. Otherwise,
     the bit is used as part of the category */

  if (((PyPiContact*)self)->deleted) {
    ((PyPiContact*)self)->archived = (attrib & 0x08) ? 1 : 0;
    ((PyPiContact*)self)->category = 0;
  } else {
    ((PyPiContact*)self)->archived = 0;
    ((PyPiContact*)self)->category = (attrib & 0x0F);
    
  }
}

char *FriendlyNameForRecordType(PCRecType rt) {
  switch(rt) {
  case PALM_REC: 
    return "normal";
  case MODIFIED_PALM_REC:
    return "modified";
  case DELETED_PALM_REC:
    return "deleted";
  case NEW_PC_REC:
    return "new_pc";
  case DELETED_PC_REC:
    return "deleted_pc";
  case REPLACEMENT_PALM_REC:
    return "replacement_rec";
  case DELETED_DELETED_PALM_REC:
    return "deleted_palm";
  default:
    return "unknown";
  }
}

PyObject *Attribute_Repr(PyObject* self) {
  static PyObject *format = NULL;
  PyObject *args, *result;

  if (format == NULL) {
    format = PyString_FromString("d:%d m:%d b:%d s:%d a:%d cat:%d type:%s uid=%d");
    if (format == NULL)
      return NULL;
  }

  args = Py_BuildValue("iiiiiisi", 
		       ((PyPiContact*)self)->deleted,
		       ((PyPiContact*)self)->modified,
		       ((PyPiContact*)self)->busy,
		       ((PyPiContact*)self)->secret,
		       ((PyPiContact*)self)->archived,
		       ((PyPiContact*)self)->category,
		       FriendlyNameForRecordType(((PyPiContact*)self)->rt),
		       ((PyPiContact*)self)->unique_id);  
  
  if (args == NULL)
    return NULL;

  result = PyString_Format(format, args);
  Py_DECREF(args);
  return result;
}


PyObject * PyPi_Getbool(PyObject *self, void *closure) {
  void *addr = (void *)self + (size_t) closure;
  if (*(int *)(addr)) {
    Py_INCREF(Py_True);
    return Py_True;  
  } else {
    Py_INCREF(Py_False);
    return Py_False;  
  }
}

PyObject * PyPi_GetCategory(PyObject *self, void *closure) {
  void *addr = (void *)self + (size_t) closure;
  return PyInt_FromLong(*(long *)addr);
}

int PyPi_Setbool(PyObject *self, PyObject *value, void *closure) {
  void *addr = (void *)self + (size_t) closure;

  if (value == NULL) {
    PyErr_SetString(PyExc_TypeError, "Cannot delete the attribute");
    return -1;
  }
  
  if (!(PyBool_Check(value) || PyInt_Check(value))) {
    PyErr_SetString(PyExc_TypeError, "The attribute value must be a boolean");
    return -1;
  }

  if (PyInt_Check(value) && PyInt_AsLong(value)) {
    *(int*)addr = 1;
  } else if (PyBool_Check(value) && (value == Py_True)) {
    *(int*)addr = 1;
  } else {
    *(int*)addr = 0;
  }

  return 0;
}

int PyPi_SetCategory(PyObject *self, PyObject *value, void *closure) {
  void *addr = (void *)self + (size_t) closure;
  int category;
  if (value == NULL) {
    PyErr_SetString(PyExc_TypeError, "Cannot delete the attribute");
    return -1;
  }
  
  if (!PyInt_Check(value)) {
    PyErr_SetString(PyExc_TypeError, "The category must be an integer");
    return -1;
  }
  
  category = PyInt_AsLong(value);
  if ((category >= 0) && (category <= 15)) {
    *(int*)addr = category;
  } else {
    PyErr_SetString(PyExc_ValueError, "The category value must be 0 <= x <= 15");
    return -1;
  }

  return 0;
}


VObject *safeAddPropValue(VObject *o, const char *id, char *val) {
  VObject *vo = NULL;
  unsigned int charsetflag = 0;
  unsigned int qpflag = 0;
  unsigned int n = 0;

  if (val) {
    GString *val_copy = g_string_new(val);
    for (n=0; ; n++) {
      if (val[n] == 0)
	break;
      if ((unsigned char)(val[n]) > 127) {
	qpflag = 1;
	charsetflag = 1;
      };
      if ((unsigned char)(val[n]) == '\n')
	qpflag = 1;
    };
    if (qpflag) {
      for (n=0; n < val_copy->len ; n++) {
	if ((unsigned char)(val_copy->str[n]) == '\n') {
	  g_string_insert_c(val_copy, n, '\r');
	  n++;
	}
      };
    };
    vo = addPropValue(o, id, val_copy->str);
    g_string_free(val_copy,1);
    if (charsetflag) {
      if (isAPropertyOf(vo,"CHARSET") == NULL)
	addPropValue(vo,"CHARSET","cp1252");
    }
    if (qpflag) {
      if (isAPropertyOf(vo,VCEncodingProp) == NULL)
      addPropValue(vo,VCEncodingProp,VCQuotedPrintableProp);
    }
  }

  return vo;
}

// adds the properties to the original VObject
VObject *safeAddPropValuePart(VObject *o, const char *id, char *val) {
  VObject *vo = NULL;
  unsigned int charsetflag = 0;
  unsigned int qpflag = 0;
  unsigned int n = 0;

  if (val) {
    GString *val_copy = g_string_new(val);
    for (n=0; ; n++) {
      if (val[n] == 0)
	break;
      if ((unsigned char)(val[n]) > 127) {
	qpflag = 1;
	charsetflag = 1;
      };
      if ((unsigned char)(val[n]) == '\n')
	qpflag = 1;
    };
    if (qpflag) {
      for (n=0; n < val_copy->len ; n++) {
	if ((unsigned char)(val_copy->str[n]) == '\n') {
	  g_string_insert_c(val_copy, n, '\r');
	  n++;
	}
      };
    };
    vo = addPropValue(o, id, val_copy->str);
    g_string_free(val_copy,1);
    if (charsetflag) {
      if (isAPropertyOf(o,"CHARSET") == NULL)
	addPropValue(o,"CHARSET","cp1252");
    }
    if (qpflag) {
      if (isAPropertyOf(o,VCEncodingProp) == NULL)
      addPropValue(o,VCEncodingProp,VCQuotedPrintableProp);
    }
  }

  return vo;
}
