/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.IOException;
import java.lang.reflect.Array;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.DataTable;
import nom.tam.util.TableException;

public class ColumnTable
implements DataTable {
    private Object[] arrays;
    private int[] sizes;
    private int nrow;
    private int chunk;
    private int rowSize;
    private char[] types;
    private Class[] bases;
    private byte[][] bytePointers;
    private short[][] shortPointers;
    private int[][] intPointers;
    private long[][] longPointers;
    private float[][] floatPointers;
    private double[][] doublePointers;
    private char[][] charPointers;
    private boolean[][] booleanPointers;

    public ColumnTable(Object[] objectArray, int[] nArray) throws TableException {
        this.setup(objectArray, nArray);
    }

    protected void setup(Object[] objectArray, int[] nArray) throws TableException {
        this.checkArrayConsistency(objectArray, nArray);
        this.getNumberOfRows();
        this.initializePointers();
    }

    public int getNRows() {
        return this.nrow;
    }

    public int getNCols() {
        return this.arrays.length;
    }

    public Object getColumn(int n) {
        return this.arrays[n];
    }

    public void setColumn(int n, Object object) throws TableException {
        boolean bl = object.getClass() != this.arrays[n].getClass() || Array.getLength(object) != Array.getLength(this.arrays[n]);
        this.arrays[n] = object;
        if (bl) {
            this.setup(this.arrays, this.sizes);
        }
    }

    public void addColumn(Object object, int n) throws TableException {
        String string = object.getClass().getName();
        this.nrow = this.checkColumnConsistency(object, string, this.nrow, n);
        this.rowSize += this.nrow * ArrayFuncs.getBaseLength(object);
        this.getNumberOfRows();
        int n2 = this.arrays.length;
        Object[] objectArray = new Object[n2 + 1];
        int[] nArray = new int[n2 + 1];
        Class[] classArray = new Class[n2 + 1];
        char[] cArray = new char[n2 + 1];
        System.arraycopy(this.arrays, 0, objectArray, 0, n2);
        System.arraycopy(this.sizes, 0, nArray, 0, n2);
        System.arraycopy(this.bases, 0, classArray, 0, n2);
        System.arraycopy(this.types, 0, cArray, 0, n2);
        this.arrays = objectArray;
        this.sizes = nArray;
        this.bases = classArray;
        this.types = cArray;
        this.arrays[n2] = object;
        this.sizes[n2] = n;
        this.bases[n2] = ArrayFuncs.getBaseClass(object);
        this.types[n2] = string.charAt(1);
        this.addPointer(object);
    }

    public void addRow(Object[] objectArray) throws TableException {
        if (this.arrays.length == 0) {
            int n = 0;
            while (n < objectArray.length) {
                this.addColumn(objectArray[n], Array.getLength(objectArray[n]));
                ++n;
            }
        } else {
            if (objectArray.length != this.arrays.length) {
                throw new TableException("Row length mismatch");
            }
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n].getClass() != this.arrays[n].getClass() || Array.getLength(objectArray[n]) != this.sizes[n]) {
                    throw new TableException("Row column mismatch at column:" + n);
                }
                Object object = ArrayFuncs.newInstance(this.bases[n], (this.nrow + 1) * this.sizes[n]);
                System.arraycopy(this.arrays[n], 0, object, 0, this.nrow * this.sizes[n]);
                System.arraycopy(objectArray[n], 0, object, this.nrow * this.sizes[n], this.sizes[n]);
                this.arrays[n] = object;
                ++n;
            }
            this.initializePointers();
            ++this.nrow;
        }
    }

    public Object getElement(int n, int n2) {
        Object object = ArrayFuncs.newInstance(this.bases[n2], this.sizes[n2]);
        System.arraycopy(this.arrays[n2], this.sizes[n2] * n, object, 0, this.sizes[n2]);
        return object;
    }

    public void setElement(int n, int n2, Object object) throws TableException {
        String string = object.getClass().getName();
        if (!string.equals("[" + this.types[n2])) {
            throw new TableException("setElement: Incompatible element type");
        }
        if (Array.getLength(object) != this.sizes[n2]) {
            throw new TableException("setElement: Incompatible element size");
        }
        System.arraycopy(object, 0, this.arrays[n2], this.sizes[n2] * n, this.sizes[n2]);
    }

    public Object getRow(int n) {
        Object[] objectArray = new Object[this.arrays.length];
        int n2 = 0;
        while (n2 < this.arrays.length) {
            objectArray[n2] = this.getElement(n, n2);
            ++n2;
        }
        return objectArray;
    }

    public void setRow(int n, Object object) throws TableException {
        if (!(object instanceof Object[])) {
            throw new TableException("setRow: Incompatible row");
        }
        int n2 = 0;
        while (n2 < this.arrays.length) {
            this.setElement(n, n2, ((Object[])object)[n2]);
            ++n2;
        }
    }

    protected void checkArrayConsistency(Object[] objectArray, int[] nArray) throws TableException {
        if (objectArray.length != nArray.length) {
            throw new TableException("readArraysAsColumns: Incompatible arrays and sizes.");
        }
        int n = 0;
        int n2 = 0;
        this.types = new char[objectArray.length];
        this.bases = new Class[objectArray.length];
        boolean bl = true;
        int n3 = 0;
        while (n3 < objectArray.length) {
            String string = objectArray[n3].getClass().getName();
            n = this.checkColumnConsistency(objectArray[n3], string, n, nArray[n3]);
            n2 += nArray[n3] * ArrayFuncs.getBaseLength(objectArray[n3]);
            this.types[n3] = string.charAt(1);
            this.bases[n3] = ArrayFuncs.getBaseClass(objectArray[n3]);
            ++n3;
        }
        this.nrow = n;
        this.rowSize = n2;
        this.arrays = objectArray;
        this.sizes = nArray;
    }

    private int checkColumnConsistency(Object object, String string, int n, int n2) throws TableException {
        if (string.charAt(0) != '[' || string.length() != 2) {
            throw new TableException("Non-primitive array for column");
        }
        int n3 = Array.getLength(object);
        if (n3 == 0 && n2 != 0 || n3 != 0 && n2 == 0) {
            throw new TableException("Size mismatch in column");
        }
        if (n3 % n2 != 0) {
            throw new TableException("Row size does not divide array for column");
        }
        int n4 = 0;
        if (n2 > 0) {
            n4 = n3 / n2;
            if (n != 0 && n4 != n) {
                throw new TableException("Different number of rows in different columns");
            }
        }
        if (n4 > 0) {
            return n4;
        }
        return n;
    }

    protected void getNumberOfRows() {
        int n = 65536;
        this.chunk = this.rowSize == 0 ? 0 : (this.rowSize > n ? 1 : (n / this.rowSize >= this.nrow ? this.nrow : n / this.rowSize + 1));
    }

    protected void initializePointers() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < this.arrays.length) {
            switch (this.types[n9]) {
                case 'B': {
                    ++n;
                    break;
                }
                case 'S': {
                    ++n2;
                    break;
                }
                case 'I': {
                    ++n3;
                    break;
                }
                case 'J': {
                    ++n4;
                    break;
                }
                case 'F': {
                    ++n5;
                    break;
                }
                case 'D': {
                    ++n6;
                    break;
                }
                case 'C': {
                    ++n7;
                    break;
                }
                case 'Z': {
                    ++n8;
                }
            }
            ++n9;
        }
        this.bytePointers = new byte[n][];
        this.shortPointers = new short[n2][];
        this.intPointers = new int[n3][];
        this.longPointers = new long[n4][];
        this.floatPointers = new float[n5][];
        this.doublePointers = new double[n6][];
        this.charPointers = new char[n7][];
        this.booleanPointers = new boolean[n8][];
        n = 0;
        n2 = 0;
        n3 = 0;
        n4 = 0;
        n5 = 0;
        n6 = 0;
        n7 = 0;
        n8 = 0;
        int n10 = 0;
        while (n10 < this.arrays.length) {
            switch (this.types[n10]) {
                case 'B': {
                    this.bytePointers[n] = (byte[])this.arrays[n10];
                    ++n;
                    break;
                }
                case 'S': {
                    this.shortPointers[n2] = (short[])this.arrays[n10];
                    ++n2;
                    break;
                }
                case 'I': {
                    this.intPointers[n3] = (int[])this.arrays[n10];
                    ++n3;
                    break;
                }
                case 'J': {
                    this.longPointers[n4] = (long[])this.arrays[n10];
                    ++n4;
                    break;
                }
                case 'F': {
                    this.floatPointers[n5] = (float[])this.arrays[n10];
                    ++n5;
                    break;
                }
                case 'D': {
                    this.doublePointers[n6] = (double[])this.arrays[n10];
                    ++n6;
                    break;
                }
                case 'C': {
                    this.charPointers[n7] = (char[])this.arrays[n10];
                    ++n7;
                    break;
                }
                case 'Z': {
                    this.booleanPointers[n8] = (boolean[])this.arrays[n10];
                    ++n8;
                }
            }
            ++n10;
        }
    }

    protected void addPointer(Object object) throws TableException {
        String string = object.getClass().getName();
        char c = string.charAt(1);
        switch (c) {
            case 'B': {
                byte[][] byArrayArray = new byte[this.bytePointers.length + 1][];
                System.arraycopy(this.bytePointers, 0, byArrayArray, 0, this.bytePointers.length);
                byArrayArray[this.bytePointers.length] = (byte[])object;
                this.bytePointers = byArrayArray;
                break;
            }
            case 'Z': {
                boolean[][] blArrayArray = new boolean[this.booleanPointers.length + 1][];
                System.arraycopy(this.booleanPointers, 0, blArrayArray, 0, this.booleanPointers.length);
                blArrayArray[this.booleanPointers.length] = (boolean[])object;
                this.booleanPointers = blArrayArray;
                break;
            }
            case 'S': {
                short[][] sArrayArray = new short[this.shortPointers.length + 1][];
                System.arraycopy(this.shortPointers, 0, sArrayArray, 0, this.shortPointers.length);
                sArrayArray[this.shortPointers.length] = (short[])object;
                this.shortPointers = sArrayArray;
                break;
            }
            case 'C': {
                char[][] cArrayArray = new char[this.charPointers.length + 1][];
                System.arraycopy(this.charPointers, 0, cArrayArray, 0, this.charPointers.length);
                cArrayArray[this.charPointers.length] = (char[])object;
                this.charPointers = cArrayArray;
                break;
            }
            case 'I': {
                int[][] nArrayArray = new int[this.intPointers.length + 1][];
                System.arraycopy(this.intPointers, 0, nArrayArray, 0, this.intPointers.length);
                nArrayArray[this.intPointers.length] = (int[])object;
                this.intPointers = nArrayArray;
                break;
            }
            case 'J': {
                long[][] lArrayArray = new long[this.longPointers.length + 1][];
                System.arraycopy(this.longPointers, 0, lArrayArray, 0, this.longPointers.length);
                lArrayArray[this.longPointers.length] = (long[])object;
                this.longPointers = lArrayArray;
                break;
            }
            case 'F': {
                float[][] fArrayArray = new float[this.floatPointers.length + 1][];
                System.arraycopy(this.floatPointers, 0, fArrayArray, 0, this.floatPointers.length);
                fArrayArray[this.floatPointers.length] = (float[])object;
                this.floatPointers = fArrayArray;
                break;
            }
            case 'D': {
                double[][] dArrayArray = new double[this.doublePointers.length + 1][];
                System.arraycopy(this.doublePointers, 0, dArrayArray, 0, this.doublePointers.length);
                dArrayArray[this.doublePointers.length] = (double[])object;
                this.doublePointers = dArrayArray;
                break;
            }
            default: {
                throw new TableException("Invalid type for added column:" + string);
            }
        }
    }

    public int read(ArrayDataInput arrayDataInput) throws IOException {
        boolean bl = false;
        int n = 0;
        while (n < this.nrow) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 < this.arrays.length) {
                int n11 = this.sizes[n10] * n;
                int n12 = this.sizes[n10];
                switch (this.types[n10]) {
                    case 'I': {
                        int[] nArray = this.intPointers[n4];
                        ++n4;
                        arrayDataInput.read(nArray, n11, n12);
                        break;
                    }
                    case 'S': {
                        short[] sArray = this.shortPointers[n3];
                        ++n3;
                        arrayDataInput.read(sArray, n11, n12);
                        break;
                    }
                    case 'B': {
                        byte[] byArray = this.bytePointers[n2];
                        ++n2;
                        arrayDataInput.read(byArray, n11, n12);
                        break;
                    }
                    case 'F': {
                        float[] fArray = this.floatPointers[n7];
                        ++n7;
                        arrayDataInput.read(fArray, n11, n12);
                        break;
                    }
                    case 'D': {
                        double[] dArray = this.doublePointers[n8];
                        ++n8;
                        arrayDataInput.read(dArray, n11, n12);
                        break;
                    }
                    case 'C': {
                        char[] cArray = this.charPointers[n6];
                        ++n6;
                        arrayDataInput.read(cArray, n11, n12);
                        break;
                    }
                    case 'J': {
                        long[] lArray = this.longPointers[n5];
                        ++n5;
                        arrayDataInput.read(lArray, n11, n12);
                        break;
                    }
                    case 'Z': {
                        boolean[] blArray = this.booleanPointers[n9];
                        ++n9;
                        arrayDataInput.read(blArray, n11, n12);
                    }
                }
                ++n10;
            }
            ++n;
        }
        return this.rowSize * this.nrow;
    }

    public int write(ArrayDataOutput arrayDataOutput) throws IOException {
        if (this.rowSize == 0) {
            return 0;
        }
        int n = 0;
        while (n < this.nrow) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 < this.arrays.length) {
                int n11 = this.sizes[n10] * n;
                int n12 = this.sizes[n10];
                switch (this.types[n10]) {
                    case 'I': {
                        int[] nArray = this.intPointers[n4];
                        ++n4;
                        arrayDataOutput.write(nArray, n11, n12);
                        break;
                    }
                    case 'S': {
                        short[] sArray = this.shortPointers[n3];
                        ++n3;
                        arrayDataOutput.write(sArray, n11, n12);
                        break;
                    }
                    case 'B': {
                        byte[] byArray = this.bytePointers[n2];
                        ++n2;
                        arrayDataOutput.write(byArray, n11, n12);
                        break;
                    }
                    case 'F': {
                        float[] fArray = this.floatPointers[n7];
                        ++n7;
                        arrayDataOutput.write(fArray, n11, n12);
                        break;
                    }
                    case 'D': {
                        double[] dArray = this.doublePointers[n8];
                        ++n8;
                        arrayDataOutput.write(dArray, n11, n12);
                        break;
                    }
                    case 'C': {
                        char[] cArray = this.charPointers[n6];
                        ++n6;
                        arrayDataOutput.write(cArray, n11, n12);
                        break;
                    }
                    case 'J': {
                        long[] lArray = this.longPointers[n5];
                        ++n5;
                        arrayDataOutput.write(lArray, n11, n12);
                        break;
                    }
                    case 'Z': {
                        boolean[] blArray = this.booleanPointers[n9];
                        ++n9;
                        arrayDataOutput.write(blArray, n11, n12);
                    }
                }
                ++n10;
            }
            ++n;
        }
        return this.rowSize * this.nrow;
    }

    public Class[] getBases() {
        return this.bases;
    }

    public char[] getTypes() {
        return this.types;
    }

    public Object[] getColumns() {
        return this.arrays;
    }

    public int[] getSizes() {
        return this.sizes;
    }
}

