/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import nom.tam.util.FormatException;

public class ByteParser {
    private byte[] input;
    private int offset;
    private int numberLength;
    private boolean foundSign;
    private boolean fillFields = false;

    public ByteParser(byte[] byArray) {
        this.input = byArray;
        this.offset = 0;
    }

    public void setBuffer(byte[] byArray) {
        this.input = byArray;
        this.offset = 0;
    }

    public byte[] getBuffer() {
        return this.input;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public void setFillFields(boolean bl) {
        this.fillFields = bl;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getNumberLength() {
        return this.numberLength;
    }

    public double getDouble() throws FormatException {
        return this.getDouble(this.input.length - this.offset);
    }

    public double getDouble(int n) throws FormatException {
        int n2 = this.offset;
        boolean bl = true;
        double d = 0.0;
        boolean bl2 = false;
        if ((n -= this.skipWhite(n)) == 0) {
            return 0.0;
        }
        double d2 = this.checkSign();
        if (this.foundSign) {
            --n;
        }
        d = this.getBareInteger(n);
        n -= this.numberLength;
        if (this.numberLength > 0) {
            bl = false;
        }
        if (n > 0 && this.input[this.offset] == 46) {
            double d3;
            ++this.offset;
            if ((d3 = this.getBareInteger(--n)) > 0.0) {
                d += d3 / Math.pow(10.0, this.numberLength);
            }
            n -= this.numberLength;
            if (this.numberLength > 0) {
                bl = false;
            }
        }
        if (bl) {
            this.offset = n2;
            this.numberLength = 0;
            throw new FormatException("Invalid real field");
        }
        if (n > 0 && (this.input[this.offset] == 101 || this.input[this.offset] == 69 || this.input[this.offset] == 100 || this.input[this.offset] == 68)) {
            ++this.offset;
            if (--n > 0) {
                int n3 = this.checkSign();
                if (this.foundSign) {
                    --n;
                }
                int n4 = (int)this.getBareInteger(n);
                d *= Math.pow(10.0, n4 * n3);
                n -= this.numberLength;
            }
        }
        if (this.fillFields && n > 0) {
            if (this.isWhite(n)) {
                this.offset += n;
            } else {
                this.numberLength = 0;
                this.offset = n2;
                throw new FormatException("Non-blanks following real.");
            }
        }
        this.numberLength = this.offset - n2;
        return d2 * d;
    }

    public float getFloat() throws FormatException {
        return (float)this.getDouble(this.input.length - this.offset);
    }

    public float getFloat(int n) throws FormatException {
        return (float)this.getDouble(n);
    }

    public int getInt(int n) throws FormatException {
        int n2 = this.offset;
        n -= this.skipWhite(n);
        int n3 = 0;
        boolean bl = true;
        int n4 = this.checkSign();
        if (this.foundSign) {
            --n;
        }
        while (n > 0 && this.input[this.offset] >= 48 && this.input[this.offset] <= 57) {
            n3 = n3 * 10 + this.input[this.offset] - 48;
            ++this.offset;
            --n;
            bl = false;
        }
        if (bl) {
            this.numberLength = 0;
            this.offset = n2;
            throw new FormatException("Invalid Integer");
        }
        if (n > 0 && this.fillFields) {
            if (this.isWhite(n)) {
                this.offset += n;
            } else {
                this.numberLength = 0;
                this.offset = n2;
                throw new FormatException("Non-white following integer");
            }
        }
        this.numberLength = this.offset - n2;
        return n4 * n3;
    }

    public int getInt() throws FormatException {
        return this.getInt(this.input.length - this.offset);
    }

    public long getLong(int n) throws FormatException {
        int n2 = this.offset;
        n -= this.skipWhite(n);
        long l = 0L;
        boolean bl = true;
        long l2 = this.checkSign();
        if (this.foundSign) {
            --n;
        }
        while (n > 0 && this.input[this.offset] >= 48 && this.input[this.offset] <= 57) {
            l = l * 10L + (long)this.input[this.offset] - 48L;
            bl = false;
            ++this.offset;
            --n;
        }
        if (bl) {
            this.numberLength = 0;
            this.offset = n2;
            throw new FormatException("Invalid long number");
        }
        if (n > 0 && this.fillFields) {
            if (this.isWhite(n)) {
                this.offset += n;
            } else {
                this.offset = n2;
                this.numberLength = 0;
                throw new FormatException("Non-white following long");
            }
        }
        this.numberLength = this.offset - n2;
        return l2 * l;
    }

    public String getString(int n) {
        String string = new String(this.input, this.offset, n);
        this.offset += n;
        this.numberLength = n;
        return string;
    }

    public boolean getBoolean() throws FormatException {
        return this.getBoolean(this.input.length - this.offset);
    }

    public boolean getBoolean(int n) throws FormatException {
        int n2 = this.offset;
        if ((n -= this.skipWhite(n)) == 0) {
            throw new FormatException("Blank boolean field");
        }
        boolean bl = false;
        if (this.input[this.offset] == 84 || this.input[this.offset] == 116) {
            bl = true;
        } else if (this.input[this.offset] != 70 && this.input[this.offset] != 102) {
            this.numberLength = 0;
            this.offset = n2;
            throw new FormatException("Invalid boolean value");
        }
        ++this.offset;
        if (this.fillFields && --n > 0) {
            if (this.isWhite(n)) {
                this.offset += n;
            } else {
                this.numberLength = 0;
                this.offset = n2;
                throw new FormatException("Non-white following boolean");
            }
        }
        this.numberLength = this.offset - n2;
        return bl;
    }

    public void skip(int n) {
        this.offset += n;
    }

    private double getBareInteger(int n) {
        int n2 = this.offset;
        double d = 0.0;
        while (n > 0 && this.input[this.offset] >= 48 && this.input[this.offset] <= 57) {
            d *= 10.0;
            d += (double)(this.input[this.offset] - 48);
            ++this.offset;
            --n;
        }
        this.numberLength = this.offset - n2;
        return d;
    }

    public int skipWhite(int n) {
        int n2 = 0;
        while (n2 < n) {
            if (this.input[this.offset + n2] != 32 && this.input[this.offset + n2] != 9 && this.input[this.offset + n2] != 10 && this.input[this.offset + n2] != 13) break;
            ++n2;
        }
        this.offset += n2;
        return n2;
    }

    private int checkSign() {
        this.foundSign = false;
        if (this.input[this.offset] == 43) {
            this.foundSign = true;
            ++this.offset;
            return 1;
        }
        if (this.input[this.offset] == 45) {
            this.foundSign = true;
            ++this.offset;
            return -1;
        }
        return 1;
    }

    private boolean isWhite(int n) {
        int n2 = this.offset;
        boolean bl = this.skipWhite(n) == n;
        this.offset = n2;
        return bl;
    }
}

