/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image;

import java.io.IOException;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.RandomAccess;

public class ImageTiler {
    RandomAccess f;
    long fileOffset;
    int[] dims;
    Class base;

    public ImageTiler(RandomAccess randomAccess, long l, int[] nArray, Class clazz) {
        this.f = randomAccess;
        this.fileOffset = l;
        this.dims = nArray;
        this.base = clazz;
    }

    public Object getMemoryImage() {
        return null;
    }

    public Object getTile(int[] nArray, int[] nArray2) throws IOException {
        if (nArray.length != this.dims.length || nArray2.length != this.dims.length) {
            throw new IOException("Inconsistent sub-image request");
        }
        int n = 1;
        int n2 = 0;
        while (n2 < this.dims.length) {
            if (nArray[n2] < 0 || nArray2[n2] < 0 || nArray[n2] + nArray2[n2] > this.dims[n2]) {
                throw new IOException("Sub-image not within image");
            }
            n *= nArray2[n2];
            ++n2;
        }
        Object object = ArrayFuncs.newInstance(this.base, n);
        this.getTile(object, nArray, nArray2);
        return object;
    }

    public void getTile(Object object, int[] nArray, int[] nArray2) throws IOException {
        Object object2 = this.getMemoryImage();
        if (object2 == null && this.f == null) {
            throw new IOException("No data source for tile subset");
        }
        this.fillTile(object2, object, this.dims, nArray, nArray2);
    }

    protected void fillTile(Object object, Object object2, int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        int n = nArray.length;
        int[] nArray4 = new int[n];
        int n2 = ArrayFuncs.getBaseLength(object2);
        int n3 = nArray3[n - 1];
        System.arraycopy(nArray2, 0, nArray4, 0, n);
        long l = 0L;
        if (object == null) {
            l = this.f.getFilePointer();
        }
        int n4 = 0;
        do {
            int n5;
            int n6;
            boolean bl;
            boolean bl2 = bl = nArray4[n6 = nArray.length - 1] + nArray3[n6] >= 0 && nArray4[n6] < nArray[n6];
            if (bl) {
                n5 = 0;
                while (n5 < n6) {
                    if (nArray4[n5] < 0 || nArray4[n5] >= nArray[n5]) {
                        bl = false;
                        break;
                    }
                    ++n5;
                }
            }
            if (bl) {
                if (object != null) {
                    this.fillMemData(object, nArray4, n3, object2, n4, 0);
                } else {
                    n5 = ImageTiler.getOffset(nArray, nArray4) * n2;
                    int n7 = n3;
                    int n8 = n5;
                    int n9 = n4;
                    if (nArray4[n6] < 0) {
                        n8 -= nArray4[n6] * n2;
                        n9 -= nArray4[n6];
                        n7 += nArray4[n6];
                    }
                    if (nArray4[n6] + n3 > nArray[n6]) {
                        n7 -= nArray4[n6] + n3 - nArray[n6];
                    }
                    this.fillFileData(object2, n8, n9, n7);
                }
            }
            n4 += n3;
        } while (ImageTiler.incrementPosition(nArray2, nArray4, nArray3));
        if (object == null) {
            this.f.seek(l);
        }
    }

    protected void fillMemData(Object object, int[] nArray, int n, Object object2, int n2, int n3) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            this.fillMemData(objectArray[nArray[n3]], nArray, n, object2, n2, n3 + 1);
        } else {
            int n4 = nArray[n3];
            int n5 = n2;
            int n6 = n;
            if (nArray[n3] < 0) {
                n4 -= nArray[n3];
                n5 -= nArray[n3];
                n6 += nArray[n3];
            }
            if (nArray[n3] + n > this.dims[n3]) {
                n6 -= nArray[n3] + n - this.dims[n3];
            }
            System.arraycopy(object, n4, object2, n5, n6);
        }
    }

    protected void fillFileData(Object object, int n, int n2, int n3) throws IOException {
        this.f.seek(this.fileOffset + (long)n);
        if (this.base == Float.TYPE) {
            this.f.read((float[])object, n2, n3);
        } else if (this.base == Integer.TYPE) {
            this.f.read((int[])object, n2, n3);
        } else if (this.base == Short.TYPE) {
            this.f.read((short[])object, n2, n3);
        } else if (this.base == Double.TYPE) {
            this.f.read((double[])object, n2, n3);
        } else if (this.base == Byte.TYPE) {
            this.f.read((byte[])object, n2, n3);
        } else if (this.base == Character.TYPE) {
            this.f.read((char[])object, n2, n3);
        } else if (this.base == Long.TYPE) {
            this.f.read((long[])object, n2, n3);
        } else {
            throw new IOException("Invalid type for tile array");
        }
    }

    protected static boolean incrementPosition(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray.length - 2;
        while (n >= 0) {
            if (nArray2[n] - nArray[n] < nArray3[n] - 1) {
                int n2 = n;
                nArray2[n2] = nArray2[n2] + 1;
                int n3 = n + 1;
                while (n3 < nArray.length - 1) {
                    nArray2[n3] = nArray[n3];
                    ++n3;
                }
                return true;
            }
            --n;
        }
        return false;
    }

    public static final int getOffset(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n2 > 0) {
                n *= nArray[n2];
            }
            n += nArray2[n2];
            ++n2;
        }
        return n;
    }

    public Object getCompleteImage() throws IOException {
        if (this.f == null) {
            throw new IOException("Attempt to read from null file");
        }
        long l = this.f.getFilePointer();
        Object object = ArrayFuncs.newInstance(this.base, this.dims);
        this.f.seek(this.fileOffset);
        this.f.readArray(object);
        this.f.seek(l);
        return object;
    }
}

