/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.BufferedFile;

public class Fits {
    private ArrayDataInput dataStr;
    private Vector hduList = new Vector();
    private boolean atEOF;

    public static String version() {
        return "0.96a";
    }

    public Fits() {
    }

    public Fits(InputStream inputStream) throws FitsException {
        this(inputStream, false);
    }

    public Fits(InputStream inputStream, boolean bl) throws FitsException {
        this.streamInit(inputStream, bl, false);
    }

    protected void streamInit(InputStream inputStream, boolean bl, boolean bl2) throws FitsException {
        if (inputStream == null) {
            throw new FitsException("Null input stream");
        }
        if (bl) {
            try {
                inputStream = new GZIPInputStream(inputStream);
            }
            catch (IOException iOException) {
                throw new FitsException("Cannot inflate input stream" + iOException);
            }
        }
        this.dataStr = inputStream instanceof ArrayDataInput ? (ArrayDataInput)((Object)inputStream) : new BufferedDataInputStream(inputStream);
    }

    protected void randomInit(String string) throws FitsException {
        String string2 = "r";
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            throw new FitsException("Non-existent or unreadable file");
        }
        if (file.canWrite()) {
            string2 = string2 + "w";
        }
        try {
            this.dataStr = new BufferedFile(string, string2);
            ((BufferedFile)this.dataStr).seek(0L);
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to open file " + string);
        }
    }

    public Fits(File file) throws FitsException {
        this(file, false);
    }

    public Fits(File file, boolean bl) throws FitsException {
        this.fileInit(file, bl);
    }

    protected void fileInit(File file, boolean bl) throws FitsException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.streamInit(fileInputStream, bl, true);
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to create Input Stream from File: " + file);
        }
    }

    public Fits(String string) throws FitsException {
        if (string == null) {
            throw new FitsException("Null FITS Identifier String");
        }
        boolean bl = FitsUtil.isCompressed(string);
        int n = string.length();
        if (n > 4 && string.substring(0, 5).equalsIgnoreCase("http:")) {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (IOException iOException) {
                throw new FitsException("Unable to convert string to URL: " + string);
            }
            try {
                InputStream inputStream = uRL.openStream();
                this.streamInit(inputStream, bl, false);
            }
            catch (IOException iOException) {
                throw new FitsException("Unable to open stream from URL:" + string + " Exception=" + iOException);
            }
        }
        if (bl) {
            this.fileInit(new File(string), true);
        } else {
            this.randomInit(string);
        }
    }

    public Fits(URL uRL) throws FitsException {
        this(uRL, FitsUtil.isCompressed(uRL.getFile()));
    }

    public Fits(URL uRL, boolean bl) throws FitsException {
        try {
            this.streamInit(uRL.openStream(), bl, false);
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to open input from URL:" + uRL);
        }
    }

    public BasicHDU[] read() throws FitsException {
        this.readToEnd();
        int n = this.getNumberOfHDUs();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new BasicHDU[n];
        this.hduList.copyInto(objectArray);
        return objectArray;
    }

    public BasicHDU readHDU() throws FitsException, IOException {
        if (this.dataStr == null || this.atEOF) {
            return null;
        }
        Header header = Header.readHeader(this.dataStr);
        if (header == null) {
            this.atEOF = true;
            return null;
        }
        Data data = header.makeData();
        data.read(this.dataStr);
        BasicHDU basicHDU = FitsFactory.HDUFactory(header, data);
        this.hduList.addElement(basicHDU);
        return basicHDU;
    }

    public void skipHDU(int n) throws FitsException, IOException {
        int n2 = 0;
        while (n2 < n) {
            this.skipHDU();
            ++n2;
        }
    }

    public void skipHDU() throws FitsException, IOException {
        if (this.atEOF) {
            return;
        }
        Header header = new Header(this.dataStr);
        if (header == null) {
            this.atEOF = true;
            return;
        }
        int n = (int)header.getDataSize();
        this.dataStr.skip(n);
    }

    public BasicHDU getHDU(int n) throws FitsException, IOException {
        int n2;
        int n3 = n2 = this.getNumberOfHDUs();
        while (n3 <= n) {
            BasicHDU basicHDU = this.readHDU();
            if (basicHDU == null) {
                return null;
            }
            ++n3;
        }
        try {
            return (BasicHDU)this.hduList.elementAt(n);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new FitsException("Internal Error: hduList build failed");
        }
    }

    private void readToEnd() throws FitsException {
        while (this.dataStr != null && !this.atEOF) {
            try {
                if (this.readHDU() != null) continue;
                break;
            }
            catch (IOException iOException) {
                throw new FitsException("IO error: " + iOException);
            }
        }
    }

    public int size() throws FitsException {
        this.readToEnd();
        return this.getNumberOfHDUs();
    }

    public void addHDU(BasicHDU basicHDU) throws FitsException {
        this.insertHDU(basicHDU, this.getNumberOfHDUs());
    }

    public void insertHDU(BasicHDU basicHDU, int n) throws FitsException {
        if (basicHDU == null) {
            return;
        }
        if (n < 0 || n > this.getNumberOfHDUs()) {
            throw new FitsException("Attempt to insert HDU at invalid location: " + n);
        }
        try {
            if (n == 0) {
                if (this.getNumberOfHDUs() > 0) {
                    ((BasicHDU)this.hduList.elementAt(0)).setPrimaryHDU(false);
                }
                if (basicHDU.canBePrimary()) {
                    basicHDU.setPrimaryHDU(true);
                    this.hduList.insertElementAt(basicHDU, 0);
                } else {
                    this.insertHDU(BasicHDU.getDummyHDU(), 0);
                    basicHDU.setPrimaryHDU(false);
                    this.hduList.insertElementAt(basicHDU, 1);
                }
            } else {
                basicHDU.setPrimaryHDU(false);
                this.hduList.insertElementAt(basicHDU, n);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new FitsException("hduList inconsistency in insertHDU");
        }
    }

    public void deleteHDU(int n) throws FitsException {
        int n2 = this.getNumberOfHDUs();
        if (n < 0 || n >= n2) {
            throw new FitsException("Attempt to delete non-existent HDU:" + n);
        }
        try {
            this.hduList.removeElementAt(n);
            if (n == 0 && n2 > 1) {
                BasicHDU basicHDU = (BasicHDU)this.hduList.elementAt(0);
                if (basicHDU.canBePrimary()) {
                    basicHDU.setPrimaryHDU(true);
                } else {
                    this.insertHDU(BasicHDU.getDummyHDU(), 0);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new FitsException("Internal Error: hduList Vector Inconsitency");
        }
    }

    public void write(DataOutput dataOutput) throws FitsException {
        ArrayDataOutput arrayDataOutput;
        boolean bl = false;
        if (dataOutput instanceof ArrayDataOutput) {
            arrayDataOutput = (ArrayDataOutput)dataOutput;
        } else if (dataOutput instanceof DataOutputStream) {
            bl = true;
            arrayDataOutput = new BufferedDataOutputStream((DataOutputStream)dataOutput);
        } else {
            throw new FitsException("Cannot create ArrayDataOutput from class " + dataOutput.getClass().getName());
        }
        int n = 0;
        while (n < this.getNumberOfHDUs()) {
            try {
                BasicHDU basicHDU = (BasicHDU)this.hduList.elementAt(n);
                basicHDU.write(arrayDataOutput);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
                throw new FitsException("Internal Error: Vector Inconsistency" + arrayIndexOutOfBoundsException);
            }
            ++n;
        }
        if (bl) {
            try {
                arrayDataOutput.flush();
                arrayDataOutput.close();
            }
            catch (IOException iOException) {
                System.err.println("Warning: error closing FITS output stream");
            }
        }
    }

    public void read(InputStream inputStream) throws FitsException, IOException {
        boolean bl = false;
        this.dataStr = inputStream instanceof ArrayDataInput ? (ArrayDataInput)((Object)inputStream) : new BufferedDataInputStream(inputStream);
        this.read();
        if (bl) {
            this.dataStr.close();
            this.dataStr = null;
        }
    }

    public int currentSize() {
        return this.hduList.size();
    }

    public int getNumberOfHDUs() {
        return this.hduList.size();
    }

    public ArrayDataInput getStream() {
        return this.dataStr;
    }

    public void setStream(ArrayDataInput arrayDataInput) {
        this.dataStr = arrayDataInput;
        this.atEOF = false;
    }

    public static BasicHDU makeHDU(Header header) throws FitsException {
        Data data = FitsFactory.dataFactory(header);
        return FitsFactory.HDUFactory(header, data);
    }

    public static BasicHDU makeHDU(Object object) throws FitsException {
        return FitsFactory.HDUFactory(object);
    }

    public static BasicHDU makeHDU(Data data) throws FitsException {
        Header header = new Header();
        data.fillHeader(header);
        return FitsFactory.HDUFactory(header, data);
    }
}

