/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsHeap;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.TableData;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.ColumnTable;
import nom.tam.util.Cursor;
import nom.tam.util.RandomAccess;
import nom.tam.util.TableException;

public class BinaryTable
extends Data
implements TableData {
    FitsHeap heap;
    int heapOffset;
    int[] sizes;
    int[][] dimens;
    int[] flags;
    static final int COL_CONSTANT = 0;
    static final int COL_VARYING = 1;
    static final int COL_COMPLEX = 2;
    static final int COL_STRING = 4;
    static final int COL_BOOLEAN = 8;
    static final int COL_BIT = 16;
    int nRow;
    int nCol;
    int rowLen;
    Class[] bases;
    Object[] modelRow;
    Object[] columns;
    ColumnTable table;
    ArrayDataInput currInput;
    static /* synthetic */ Class class$java$lang$String;

    public BinaryTable() throws FitsException {
        try {
            this.table = new ColumnTable(new Object[0], new int[0]);
        }
        catch (TableException tableException) {
            System.err.println("Impossible exception in BinaryTable() constructor" + tableException);
        }
        this.heap = new FitsHeap(0);
        this.extendArrays(0);
        this.nRow = 0;
        this.nCol = 0;
        this.rowLen = 0;
    }

    public BinaryTable(Header header) throws FitsException {
        int n = header.getIntValue("PCOUNT");
        this.heapOffset = header.getIntValue("THEAP");
        this.nRow = header.getIntValue("NAXIS2");
        int n2 = header.getIntValue("NAXIS1");
        if (this.heapOffset > 0) {
            this.heapOffset -= this.nRow * n2;
        }
        if (this.heapOffset > n) {
            throw new FitsException("Inconsistent THEAP and PCOUNT");
        }
        this.heap = new FitsHeap(n - this.heapOffset);
        this.nCol = header.getIntValue("TFIELDS");
        this.rowLen = 0;
        this.extendArrays(this.nCol);
        int n3 = 0;
        while (n3 < this.nCol) {
            this.rowLen += this.processCol(header, n3);
            ++n3;
        }
    }

    private int processCol(Header header, int n) throws FitsException {
        char c;
        String string = header.getStringValue("TFORM" + (n + 1)).trim();
        String string2 = header.getStringValue("TDIM" + (n + 1));
        if (string == null) {
            throw new FitsException("No TFORM for column:" + n);
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        if ((c = this.getTformType(string)) == 'P') {
            int n2 = n;
            this.flags[n2] = this.flags[n2] | 1;
            c = this.getTformVarType(string);
        }
        int n3 = this.getTformLength(string);
        if (c == 'X') {
            n3 = (n3 + 7) / 8;
            int n4 = n;
            this.flags[n4] = this.flags[n4] | 0x10;
        } else if ((this.flags[n] & 1) != 0) {
            n3 = 2;
        }
        int n5 = n3;
        int[] nArray = null;
        if (string2 != null && c != 'X' && (this.flags[n] & 1) == 0) {
            nArray = BinaryTable.getTDims(string2);
        }
        if (nArray == null) {
            nArray = new int[]{n3};
        }
        if (c == 'C' || c == 'M') {
            int n6 = n;
            this.flags[n6] = this.flags[n6] | 2;
        }
        Class<Number> clazz = null;
        switch (c) {
            case 'A': {
                clazz = Byte.TYPE;
                int n7 = n;
                this.flags[n7] = this.flags[n7] | 4;
                this.bases[n] = class$java$lang$String == null ? (class$java$lang$String = BinaryTable.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            case 'L': {
                clazz = Byte.TYPE;
                this.bases[n] = Boolean.TYPE;
                int n8 = n;
                this.flags[n8] = this.flags[n8] | 8;
                break;
            }
            case 'B': 
            case 'X': {
                clazz = Byte.TYPE;
                this.bases[n] = Byte.TYPE;
                break;
            }
            case 'I': {
                clazz = Short.TYPE;
                this.bases[n] = Short.TYPE;
                n5 *= 2;
                break;
            }
            case 'J': {
                clazz = Integer.TYPE;
                this.bases[n] = Integer.TYPE;
                n5 *= 4;
                break;
            }
            case 'K': {
                clazz = Long.TYPE;
                this.bases[n] = Long.TYPE;
                n5 *= 8;
                break;
            }
            case 'C': 
            case 'E': {
                clazz = Float.TYPE;
                this.bases[n] = Float.TYPE;
                n5 *= 4;
                break;
            }
            case 'D': 
            case 'M': {
                clazz = Double.TYPE;
                this.bases[n] = Double.TYPE;
                n5 *= 8;
                break;
            }
            default: {
                throw new FitsException("Invalid type in column:" + n);
            }
        }
        if ((this.flags[n] & 1) != 0) {
            nArray = new int[]{this.nRow, 2};
            clazz = Integer.TYPE;
            n5 = 8;
        } else if ((this.flags[n] & 2) != 0) {
            int[] nArray2 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray2[nArray.length] = 2;
            nArray = nArray2;
        }
        this.modelRow[n] = ArrayFuncs.newInstance(clazz, nArray);
        this.dimens[n] = nArray;
        this.sizes[n] = n3;
        return n5;
    }

    private char getTformType(String string) {
        int n = 0;
        while (n < string.length()) {
            if (!Character.isDigit(string.charAt(n))) {
                return string.charAt(n);
            }
            ++n;
        }
        return '\u0000';
    }

    private char getTformVarType(String string) {
        int n = string.indexOf("P");
        if (string.length() > n + 1) {
            return string.charAt(n + 1);
        }
        return '\u0000';
    }

    private int getTformLength(String string) {
        if (Character.isDigit(string.charAt(0))) {
            return this.initialNumber(string);
        }
        String string2 = string.substring(1).trim();
        if (string2.length() == 0) {
            return 1;
        }
        if (Character.isDigit(string2.charAt(0))) {
            return this.initialNumber(string2);
        }
        return 1;
    }

    private int initialNumber(String string) {
        int n = 0;
        while (n < string.length()) {
            if (!Character.isDigit(string.charAt(n))) break;
            ++n;
        }
        return Integer.parseInt(string.substring(0, n));
    }

    public static int[] getTDims(String string) {
        StringTokenizer stringTokenizer;
        int n;
        int[] nArray = null;
        int n2 = string.indexOf(40);
        int n3 = string.lastIndexOf(41);
        if (n2 >= 0 && n3 > 0 && n2 < n3 && (n = (stringTokenizer = new StringTokenizer(string = string.substring(n2 + 1, n3 - n2), ",")).countTokens()) > 0) {
            nArray = new int[n];
            int n4 = n - 1;
            while (n4 >= 0) {
                nArray[n4] = Integer.parseInt(stringTokenizer.nextToken().trim());
                --n4;
            }
        }
        return nArray;
    }

    public void fillHeader(Header header) throws FitsException {
        try {
            header.setXtension("BINTABLE");
            header.setBitpix(8);
            header.setNaxes(2);
            header.setNaxis(1, this.rowLen);
            header.setNaxis(2, this.nRow);
            header.addValue("PCOUNT", this.heap.size(), (String)null);
            header.addValue("GCOUNT", 1L, (String)null);
            Cursor cursor = header.iterator();
            cursor.setKey("GCOUNT");
            cursor.next();
            cursor.add("TFIELDS", new HeaderCard("TFIELDS", this.modelRow.length, null));
            cursor.add("THEAP", new HeaderCard("THEAP", 0, null));
            int n = 0;
            while (n < this.modelRow.length) {
                if (n > 0) {
                    header.positionAfterIndex("TFORM", n);
                }
                this.fillForColumn(header, n, cursor);
                ++n;
            }
        }
        catch (HeaderCardException headerCardException) {
            System.err.println("Impossible exception");
        }
    }

    void pointToColumn(int n, Header header) throws FitsException {
        Cursor cursor = header.iterator();
        if (n > 0) {
            header.positionAfterIndex("TFORM", n);
        }
        this.fillForColumn(header, n, cursor);
    }

    void fillForColumn(Header header, int n, Cursor cursor) throws FitsException {
        String string = (this.flags[n] & 1) != 0 ? "1P" : "" + this.sizes[n];
        if (this.bases[n] == Integer.TYPE) {
            string = string + "J";
        } else if (this.bases[n] == Short.TYPE || this.bases[n] == Character.TYPE) {
            string = string + "I";
        } else if (this.bases[n] == Byte.TYPE) {
            string = string + "B";
        } else if (this.bases[n] == Float.TYPE) {
            string = string + "E";
        } else if (this.bases[n] == Double.TYPE) {
            string = string + "D";
        } else if (this.bases[n] == Long.TYPE) {
            string = string + "K";
        } else if (this.bases[n] == Boolean.TYPE) {
            string = string + "L";
        } else if (this.bases[n] == (class$java$lang$String == null ? (class$java$lang$String = BinaryTable.class$("java.lang.String")) : class$java$lang$String)) {
            string = string + "A";
        } else {
            throw new FitsException("Invalid column data class:" + this.bases[n]);
        }
        String string2 = "TFORM" + (n + 1);
        cursor.add(string2, new HeaderCard(string2, string, null));
        if (this.dimens[n].length > 0 && (this.flags[n] & 1) == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 40;
            int n3 = this.dimens[n].length - 1;
            while (n3 >= 0) {
                stringBuffer.append((char)n2);
                stringBuffer.append(this.dimens[n][n3]);
                n2 = 44;
                --n3;
            }
            stringBuffer.append(')');
            string2 = "TDIM" + (n + 1);
            cursor.add(string2, new HeaderCard(string2, new String(stringBuffer), null));
        }
    }

    private ColumnTable createTable() throws FitsException {
        ColumnTable columnTable;
        int n = this.modelRow.length;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(this.modelRow[n2]), this.sizes[n2] * this.nRow);
            ++n2;
        }
        try {
            columnTable = new ColumnTable(objectArray, this.sizes);
        }
        catch (TableException tableException) {
            throw new FitsException("Unable to create table:" + tableException);
        }
        return columnTable;
    }

    public BinaryTable(Object[][] objectArray) throws FitsException {
        this(BinaryTable.convertToColumns(objectArray));
    }

    private static Object[] convertToColumns(Object[][] objectArray) {
        Object[] objectArray2 = objectArray[0];
        int n = objectArray.length;
        Object[] objectArray3 = new Object[objectArray2.length];
        int n2 = 0;
        while (n2 < objectArray2.length) {
            Object object;
            if (objectArray2[n2] instanceof String) {
                object = new String[n];
                int n3 = 0;
                while (n3 < n) {
                    object[n3] = (String)objectArray[n3][n2];
                    ++n3;
                }
                objectArray3[n2] = object;
            } else {
                Object object2;
                object = ArrayFuncs.getBaseClass(objectArray2[n2]);
                int[] nArray = ArrayFuncs.getDimensions(objectArray2[n2]);
                if (nArray.length > 1 || nArray[0] > 1) {
                    object2 = new int[nArray.length + 1];
                    object2[0] = n;
                    Object[] objectArray4 = (Object[])ArrayFuncs.newInstance((Class)object, object2);
                    int n4 = 0;
                    while (n4 < n) {
                        objectArray4[n4] = objectArray[n4][n2];
                        ++n4;
                    }
                    objectArray3[n2] = objectArray4;
                } else {
                    object2 = ArrayFuncs.newInstance((Class)object, n);
                    int n5 = 0;
                    while (n5 < n) {
                        System.arraycopy(objectArray[n5][n2], 0, object2, n5, 1);
                        ++n5;
                    }
                    objectArray3[n2] = object2;
                }
            }
            ++n2;
        }
        return objectArray3;
    }

    public BinaryTable(Object[] objectArray) throws FitsException {
        this.heap = new FitsHeap(0);
        this.modelRow = new Object[objectArray.length];
        this.extendArrays(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            this.addColumn(objectArray[n]);
            ++n;
        }
    }

    public BinaryTable(ColumnTable columnTable) {
        this.nCol = columnTable.getNCols();
        this.extendArrays(this.nCol);
        this.bases = columnTable.getBases();
        this.sizes = columnTable.getSizes();
        this.modelRow = new Object[this.nCol];
        this.dimens = new int[this.nCol][1];
        this.flags = new int[this.nCol];
        int n = 0;
        while (n < this.nCol) {
            this.dimens[n][0] = this.sizes[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < this.nCol) {
            this.modelRow[n2] = ArrayFuncs.newInstance(this.bases[n2], this.sizes[n2]);
            ++n2;
        }
        this.columns = null;
        this.table = columnTable;
    }

    public Object[] getRow(int n) throws FitsException {
        if (!this.validRow(n)) {
            throw new FitsException("Invalid row");
        }
        Object[] objectArray = this.table != null ? this.getMemoryRow(n) : this.getFileRow(n);
        return objectArray;
    }

    private Object[] getMemoryRow(int n) throws FitsException {
        Object[] objectArray = new Object[this.modelRow.length];
        int n2 = 0;
        while (n2 < this.modelRow.length) {
            Object object = this.table.getElement(n, n2);
            object = this.columnToArray(n2, object);
            objectArray[n2] = this.encurl(object, n2, 1);
            if (objectArray[n2] instanceof Object[]) {
                objectArray[n2] = ((Object[])objectArray[n2])[0];
            }
            ++n2;
        }
        return objectArray;
    }

    private Object[] getFileRow(int n) throws FitsException {
        Object[] objectArray = new Object[this.nCol];
        int n2 = 0;
        while (n2 < objectArray.length) {
            objectArray[n2] = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(this.modelRow[n2]), this.sizes[n2]);
            ++n2;
        }
        try {
            FitsUtil.reposition(this.currInput, this.fileOffset + (long)(n * this.rowLen));
            this.currInput.readArray(objectArray);
        }
        catch (IOException iOException) {
            throw new FitsException("Error in deferred row read");
        }
        int n3 = 0;
        while (n3 < objectArray.length) {
            objectArray[n3] = this.columnToArray(n3, objectArray[n3]);
            objectArray[n3] = this.encurl(objectArray[n3], n3, 1);
            if (objectArray[n3] instanceof Object[]) {
                objectArray[n3] = ((Object[])objectArray[n3])[0];
            }
            ++n3;
        }
        return objectArray;
    }

    public void setRow(int n, Object[] objectArray) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        if (objectArray.length != this.getNCols()) {
            throw new FitsException("Updated row size does not agree with table");
        }
        Object[] objectArray2 = new Object[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = ArrayFuncs.flatten(objectArray[n2]);
            objectArray2[n2] = this.arrayToColumn(n2, object);
            ++n2;
        }
        try {
            this.table.setRow(n, objectArray2);
        }
        catch (TableException tableException) {
            throw new FitsException("Error modifying table: " + tableException);
        }
    }

    public void setColumn(int n, Object object) throws FitsException {
        object = ArrayFuncs.flatten(object);
        object = this.arrayToColumn(n, object);
        this.setFlattenedColumn(n, object);
    }

    public void setFlattenedColumn(int n, Object object) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        object = this.arrayToColumn(n, object);
        Object object2 = this.table.getColumn(n);
        if (object.getClass() != object2.getClass() || Array.getLength(object) != Array.getLength(object2)) {
            throw new FitsException("Replacement column mismatch at column:" + n);
        }
        try {
            this.table.setColumn(n, object);
        }
        catch (TableException tableException) {
            throw new FitsException("Unable to set column:" + n + " error:" + tableException);
        }
    }

    public Object getColumn(int n) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        Object object = this.getFlattenedColumn(n);
        return this.encurl(object, n, this.nRow);
    }

    private Object encurl(Object object, int n, int n2) {
        if (this.bases[n] != (class$java$lang$String == null ? (class$java$lang$String = BinaryTable.class$("java.lang.String")) : class$java$lang$String)) {
            if ((this.flags[n] & 1) == 0 && (this.dimens[n].length > 1 || this.dimens[n][0] != 1)) {
                int[] nArray = new int[this.dimens[n].length + 1];
                System.arraycopy(this.dimens[n], 0, nArray, 1, this.dimens[n].length);
                nArray[0] = n2;
                object = ArrayFuncs.curl(object, nArray);
            }
        } else if (this.dimens[n].length > 2) {
            int[] nArray = new int[this.dimens[n].length];
            System.arraycopy(this.dimens[n], 0, nArray, 1, this.dimens[n].length - 1);
            nArray[0] = n2;
            object = ArrayFuncs.curl(object, nArray);
        }
        return object;
    }

    public Object getFlattenedColumn(int n) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        if (!this.validColumn(n)) {
            throw new FitsException("Invalid column");
        }
        return this.columnToArray(n, this.table.getColumn(n));
    }

    public Object getElement(int n, int n2) throws FitsException {
        Object object;
        if (!this.validRow(n) || !this.validColumn(n2)) {
            throw new FitsException("No such element");
        }
        if (this.table == null) {
            Object[] objectArray = this.getRow(n);
            object = objectArray[n2];
        } else {
            object = this.table.getElement(n, n2);
            object = this.columnToArray(n2, object);
            if ((object = this.encurl(object, n2, 1)) instanceof Object[]) {
                object = ((Object[])object)[0];
            }
        }
        return object;
    }

    public int addRow(Object[] objectArray) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        if (this.nCol == 0 && this.nRow == 0) {
            int n = 0;
            while (n < objectArray.length) {
                this.addColumn(objectArray);
                ++n;
            }
        } else {
            Object[] objectArray2 = new Object[this.getNCols()];
            int n = 0;
            while (n < this.getNCols()) {
                Object object = ArrayFuncs.flatten(objectArray[n]);
                objectArray2[n] = this.arrayToColumn(n, object);
                ++n;
            }
            try {
                this.table.addRow(objectArray2);
            }
            catch (TableException tableException) {
                throw new FitsException("Error add row to table");
            }
            ++this.nRow;
        }
        return this.nRow;
    }

    public int addColumn(Object object) throws FitsException {
        this.extendArrays(this.nCol + 1);
        Class clazz = ArrayFuncs.getBaseClass(object);
        if (this.isVarying(object)) {
            int n = this.nCol;
            this.flags[n] = this.flags[n] | 1;
            this.dimens[this.nCol] = new int[]{2};
        }
        if ((this.flags[this.nCol] & 1) == 0) {
            int[] nArray = ArrayFuncs.getDimensions(object);
            if (clazz == (class$java$lang$String == null ? (class$java$lang$String = BinaryTable.class$("java.lang.String")) : class$java$lang$String)) {
                int[] nArray2 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray2[nArray.length] = -1;
                nArray = nArray2;
            }
            if (nArray.length == 1) {
                this.dimens[this.nCol] = new int[]{1};
            } else {
                this.dimens[this.nCol] = new int[nArray.length - 1];
                System.arraycopy(nArray, 1, this.dimens[this.nCol], 0, nArray.length - 1);
                object = ArrayFuncs.flatten(object);
            }
        }
        this.addFlattenedColumn(object, this.dimens[this.nCol]);
        return this.getNCols();
    }

    private boolean isVarying(Object object) {
        String string = object.getClass().getName();
        if (string.length() != 3 || string.charAt(0) != '[' || string.charAt(1) != '[') {
            return false;
        }
        Object[] objectArray = (Object[])object;
        if (objectArray.length < 2) {
            return false;
        }
        int n = Array.getLength(objectArray[0]);
        int n2 = 1;
        while (n2 < objectArray.length) {
            if (Array.getLength(objectArray[n2]) != n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int addFlattenedColumn(Object object, int[] nArray) throws FitsException {
        this.extendArrays(this.nCol + 1);
        this.bases[this.nCol] = ArrayFuncs.getBaseClass(object);
        if (this.bases[this.nCol] == Boolean.TYPE) {
            int n = this.nCol;
            this.flags[n] = this.flags[n] | 8;
        } else if (this.bases[this.nCol] == (class$java$lang$String == null ? (class$java$lang$String = BinaryTable.class$("java.lang.String")) : class$java$lang$String)) {
            int n = this.nCol;
            this.flags[n] = this.flags[n] | 4;
        }
        object = this.arrayToColumn(this.nCol, object);
        int n = 1;
        int n2 = 0;
        while (n2 < nArray.length) {
            n *= nArray[n2];
            ++n2;
        }
        this.sizes[this.nCol] = n;
        int n3 = Array.getLength(object) / n;
        if (this.getNCols() == 0) {
            this.nRow = n3;
        } else if (n3 > 0 && n3 != this.nRow) {
            throw new FitsException("Added column does not have correct row count");
        }
        if ((this.flags[this.nCol] & 1) == 0) {
            this.modelRow[this.nCol] = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(object), nArray);
            this.rowLen += n * ArrayFuncs.getBaseLength(object);
        } else {
            this.modelRow[this.nCol] = new int[2];
            this.rowLen += 8;
        }
        this.columns[this.nCol] = object;
        try {
            if (this.table != null) {
                this.table.addColumn(object, this.sizes[this.nCol]);
            } else if (this.nCol == this.columns.length - 1) {
                this.table = new ColumnTable(this.columns, this.sizes);
            }
        }
        catch (TableException tableException) {
            throw new FitsException("Error in ColumnTable:" + tableException);
        }
        ++this.nCol;
        return this.nCol;
    }

    public int getNRows() {
        return this.nRow;
    }

    public int getNCols() {
        return this.nCol;
    }

    protected boolean validRow(int n) {
        return this.getNRows() > 0 && n >= 0 && n < this.getNRows();
    }

    protected boolean validColumn(int n) {
        return n >= 0 && n < this.getNCols();
    }

    public void setElement(int n, int n2, Object object) throws FitsException {
        try {
            this.table.setElement(n, n2, ArrayFuncs.flatten(object));
        }
        catch (TableException tableException) {
            throw new FitsException("Error modifying table:" + tableException);
        }
    }

    public void read(ArrayDataInput arrayDataInput) throws FitsException {
        this.setFileOffset(arrayDataInput);
        this.currInput = arrayDataInput;
        if (arrayDataInput instanceof RandomAccess) {
            try {
                arrayDataInput.skipBytes(this.getTrueSize());
                arrayDataInput.skipBytes(FitsUtil.padding(this.getTrueSize()));
            }
            catch (IOException iOException) {
                throw new FitsException("Unable to skip binary table HDU:" + iOException);
            }
        } else {
            if (this.table == null) {
                this.table = this.createTable();
            }
            this.readTrueData(arrayDataInput);
        }
    }

    protected void readTrueData(ArrayDataInput arrayDataInput) throws FitsException {
        try {
            int n = this.table.read(arrayDataInput);
            arrayDataInput.skipBytes(this.heapOffset);
            this.heap.read(arrayDataInput);
            arrayDataInput.skipBytes(FitsUtil.padding(this.getTrueSize()));
        }
        catch (IOException iOException) {
            throw new FitsException("Error reading binary table data:" + iOException);
        }
    }

    public int getTrueSize() {
        int n = this.nRow * this.rowLen;
        if (this.heap.size() > 0) {
            n += this.heap.size() + this.heapOffset;
        }
        return n;
    }

    public void write(ArrayDataOutput arrayDataOutput) throws FitsException {
        if (this.table == null) {
            long l = FitsUtil.findOffset(arrayDataOutput);
            this.getData();
            FitsUtil.reposition(arrayDataOutput, l);
        }
        try {
            int n = this.table.write(arrayDataOutput);
            if (this.heapOffset > 0) {
                arrayDataOutput.write(new byte[this.heapOffset]);
            }
            if (this.heap.size() > 0) {
                this.heap.write(arrayDataOutput);
            }
            arrayDataOutput.write(new byte[FitsUtil.padding(this.getTrueSize())]);
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to write table:" + iOException);
        }
    }

    public Object getData() throws FitsException {
        if (this.table == null) {
            if (this.currInput == null) {
                throw new FitsException("Cannot find input for deferred read");
            }
            this.table = this.createTable();
            long l = FitsUtil.findOffset(this.currInput);
            FitsUtil.reposition(this.currInput, this.fileOffset);
            this.readTrueData(this.input);
            FitsUtil.reposition(this.currInput, l);
        }
        return this.table;
    }

    public int[][] getDimens() {
        return this.dimens;
    }

    public Class[] getBases() {
        return this.table.getBases();
    }

    public char[] getTypes() {
        if (this.table == null) {
            try {
                this.getData();
            }
            catch (FitsException fitsException) {
                // empty catch block
            }
        }
        return this.table.getTypes();
    }

    public Object[] getFlatColumns() {
        if (this.table == null) {
            try {
                this.getData();
            }
            catch (FitsException fitsException) {
                // empty catch block
            }
        }
        return this.table.getColumns();
    }

    public int[] getSizes() {
        return this.sizes;
    }

    private Object arrayToColumn(int n, Object object) throws FitsException {
        if (this.flags[n] == 0) {
            return object;
        }
        if ((this.flags[n] & 1) == 0) {
            if ((this.flags[n] & 4) != 0) {
                int[] nArray = this.dimens[n];
                if (nArray[nArray.length - 1] < 0) {
                    nArray[nArray.length - 1] = FitsUtil.maxLength((String[])object);
                }
                if (object instanceof String) {
                    object = new String[]{(String)object};
                }
                object = FitsUtil.stringsToByteArray((String[])object, nArray[nArray.length - 1]);
            } else if ((this.flags[n] & 8) != 0) {
                object = FitsUtil.booleanToByte((boolean[])object);
            }
        } else {
            int n2;
            if ((this.flags[n] & 8) != 0) {
                if (object instanceof boolean[]) {
                    object = new boolean[][]{(boolean[])object};
                }
                boolean[][] blArray = (boolean[][])object;
                byte[][] byArrayArray = new byte[blArray.length][];
                n2 = 0;
                while (n2 < blArray.length) {
                    byArrayArray[n2] = FitsUtil.booleanToByte(blArray[n2]);
                    ++n2;
                }
                object = byArrayArray;
            }
            int n3 = this.heap.putData(object);
            int n4 = ArrayFuncs.getBaseLength(object);
            if (!(object instanceof Object[])) {
                object = new Object[]{object};
            }
            n2 = Array.getLength(object);
            int[] nArray = new int[2 * n2];
            Object object2 = object;
            int n5 = 0;
            while (n5 < n2) {
                nArray[2 * n5] = Array.getLength(object2[n5]);
                nArray[2 * n5 + 1] = n3;
                n3 += nArray[2 * n5] * n4;
                if ((this.flags[n] & 2) != 0) {
                    int n6 = 2 * n5;
                    nArray[n6] = nArray[n6] / 2;
                }
                ++n5;
            }
            object = nArray;
        }
        return object;
    }

    private Object columnToArray(int n, Object objectArray) throws FitsException {
        if (this.flags[n] == 0) {
            return objectArray;
        }
        if ((this.flags[n] & 1) != 0) {
            Object[] objectArray2;
            int[] nArray;
            int[] nArray2 = (int[])objectArray;
            int n2 = nArray2.length / 2;
            if ((this.flags[n] & 2) != 0) {
                nArray = new int[]{n2, 0, 0};
                objectArray2 = (Object[])ArrayFuncs.newInstance(this.bases[n], nArray);
                nArray = new int[2];
                nArray[1] = 2;
            } else {
                nArray = new int[]{n2, 0};
                objectArray2 = (Object[])ArrayFuncs.newInstance(this.bases[n], nArray);
            }
            int n3 = 0;
            while (n3 < n2) {
                Object object;
                int n4 = nArray2[2 * n3 + 1];
                int n5 = nArray2[2 * n3];
                if ((this.flags[n] & 2) != 0) {
                    nArray[0] = n5;
                    object = ArrayFuncs.newInstance(this.bases[n], nArray);
                } else {
                    object = (this.flags[n] & 8) != 0 ? ArrayFuncs.newInstance(Byte.TYPE, n5) : ArrayFuncs.newInstance(this.bases[n], n5);
                }
                this.heap.getData(n4, object);
                if ((this.flags[n] & 8) != 0) {
                    object = FitsUtil.byteToBoolean((byte[])object);
                }
                objectArray2[n3] = object;
                ++n3;
            }
            objectArray = objectArray2;
        } else if ((this.flags[n] & 4) != 0) {
            int[] nArray = this.dimens[n];
            objectArray = FitsUtil.byteArrayToStrings((byte[])objectArray, nArray[nArray.length - 1]);
        } else if ((this.flags[n] & 8) != 0) {
            objectArray = FitsUtil.byteToBoolean((byte[])objectArray);
        }
        return objectArray;
    }

    private void extendArrays(int n) {
        boolean bl = false;
        if (this.sizes == null) {
            bl = true;
        } else if (this.sizes.length > n) {
            return;
        }
        int[] nArray = new int[n];
        int[][] nArrayArray = new int[n][];
        int[] nArray2 = new int[n];
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        Class[] classArray = new Class[n];
        if (!bl) {
            int n2 = this.sizes.length;
            System.arraycopy(this.sizes, 0, nArray, 0, n2);
            System.arraycopy(this.dimens, 0, nArrayArray, 0, n2);
            System.arraycopy(this.flags, 0, nArray2, 0, n2);
            System.arraycopy(this.modelRow, 0, objectArray, 0, n2);
            System.arraycopy(this.columns, 0, objectArray2, 0, n2);
            System.arraycopy(this.bases, 0, classArray, 0, n2);
        }
        this.sizes = nArray;
        this.dimens = nArrayArray;
        this.flags = nArray2;
        this.modelRow = objectArray;
        this.columns = objectArray2;
        this.bases = classArray;
    }

    public int getHeapSize() {
        return this.heapOffset + this.heap.size();
    }

    public int getHeapOffset() {
        return this.heapOffset;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

