/*=========================================================================

  Program:   Image Guided Surgery Software Toolkit
  Module:    $RCSfile: TrackingVolumeViewerQuadrantViews.cxx,v $
  Language:  C++
  Date:      $Date: 2009-01-30 20:48:03 $
  Version:   $Revision: 1.1 $

  Copyright (c) ISC  Insight Software Consortium.  All rights reserved.
  See IGSTKCopyright.txt or http://www.igstk.org/copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

// generated by Fast Light User Interface Designer (fluid) version 1.0107

#include "TrackingVolumeViewerQuadrantViews.h"

namespace igstk
{

TrackingVolumeViewerQuadrantViews::TrackingVolumeViewerQuadrantViews(int X, int Y, int W, int H, const char *L)
  : Fl_Group(X, Y, W, H, L)
{

  m_Reporter = ::itk::Object::New();
 
  const int C = 5;    // Width of the vertical separator

  Fl_Group * parentGroup = this->parent();

  m_X = 150; // width of the control panel
  m_Y = 0;

  m_Width = parentGroup->w() - m_X;
  m_Height = parentGroup->h(); 

  m_WW = (int) (m_Width-2*C)/2;
  m_HH = (int) (m_Height-2*C)/2;

  // Create widgets
  typedef igstk::FLTKWidget   WidgetType;

  m_AxialWidget    = new WidgetType(X, Y, m_WW, m_HH, "Display 0");
  m_SagittalWidget = new WidgetType(X+m_WW+C, Y, m_WW, m_HH, "Display 1");
  m_CoronalWidget  = new WidgetType(X, Y+m_HH+C, m_WW, m_HH, "Display 2");
  m_3DWidget       = new WidgetType(X+m_WW+C, Y+m_HH+C, m_WW, m_HH, "Display 3");       
 
  // Create views
  m_AxialView    = ViewType2D::New();
  m_AxialView->RequestSetOrientation( View2D::Axial );

  m_SagittalView = ViewType2D::New();
  m_SagittalView->RequestSetOrientation( View2D::Sagittal );

  m_CoronalView  = ViewType2D::New();
  m_CoronalView->RequestSetOrientation( View2D::Coronal );

  m_3DView = ViewType3D::New();

  m_AxialWidget->RequestSetView( m_AxialView );
  m_SagittalWidget->RequestSetView( m_SagittalView );
  m_CoronalWidget->RequestSetView( m_CoronalView );
  m_3DWidget->RequestSetView( m_3DView );

  end();
}

TrackingVolumeViewerQuadrantViews::~TrackingVolumeViewerQuadrantViews()
{
  delete m_AxialWidget;
  delete m_SagittalWidget;
  delete m_CoronalWidget;
  delete m_3DWidget;
}

unsigned long TrackingVolumeViewerQuadrantViews::AddObserver(
  const ::itk::EventObject & event, ::itk::Command * observer )
{
  return m_Reporter->AddObserver( event, observer );
}

void TrackingVolumeViewerQuadrantViews::RemoveObserver( unsigned long tag )
{
  m_Reporter->RemoveObserver( tag );
}

void TrackingVolumeViewerQuadrantViews::RemoveAllObservers()
{
  m_Reporter->RemoveAllObservers();
}


} // end namespace igstk
