<!-- <?xml version="1.0" encoding="UTF-16"?> -->
<instrumentationManifest
    xsi:schemaLocation="http://schemas.microsoft.com/win/2004/08/events eventman.xsd"
    xmlns="http://schemas.microsoft.com/win/2004/08/events"
    xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:trace="http://schemas.microsoft.com/win/2004/08/events/trace">
  <instrumentation>
    <events>
      <provider name="MozillaSpiderMonkey"
                message="$(string.ProviderMessage)"
                guid="{2C378EC2-8A64-4b48-9A41-3CA4506D06C5}"
                symbol="MozillaSpiderMonkey"
                resourceFileName="mozjs.dll"
                messageFileName="mozjs.dll">
        <events>
          <!-- execution -->
          <event symbol="EvtExecuteStart" value="1001" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="CodeLocationTemplate" task="Execution" opcode="ExecuteStart"
                 keywords="SampleKeyword" message="$(string.MozillaSpiderMonkey.ExecuteStart.message)"/>
          <event symbol="EvtExecuteDone" value="1002" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="CodeLocationTemplate" task="Execution" opcode="ExecuteStop"
                 keywords="SampleKeyword" message="$(string.MozillaSpiderMonkey.ExecuteDone.message)"/>
          
          <event symbol="EvtScriptCompileBegin" value="1003" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="CodeLocationTemplate" task="Execution" opcode="CompileBegin"
                 keywords="SampleKeyword" message="$(string.MozillaSpiderMonkey.ScriptCompileBegin.message)"/>
          <event symbol="EvtScriptCompileEnd" value="1004" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="CodeLocationTemplate" task="Execution" opcode="CompileEnd"
                 keywords="SampleKeyword" message="$(string.MozillaSpiderMonkey.ScriptCompileEnd.message)"/>

          <event symbol="EvtCalloutBegin" value="2001" version="1"
                 channel="MozillaChannel" level="win:Verbose"
                 template="FunctionInvocationTemplate" task="Execution" opcode="CalloutBegin"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>
          <event symbol="EvtCalloutEnd" value="2002" version="1"
                 channel="MozillaChannel" level="win:Verbose"
                 template="FunctionInvocationTemplate" task="Execution" opcode="CalloutEnd"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>

          <event symbol="EvtFunctionEntry" value="1005" version="1"
                 channel="MozillaChannel" level="win:Verbose"
                 template="FunctionInvocationTemplate" task="Execution" opcode="FunctionEnter"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>
          <event symbol="EvtFunctionExit" value="1006" version="1"
                 channel="MozillaChannel" level="win:Verbose"
                 template="FunctionInvocationTemplate" task="Execution" opcode="FunctionExit"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>

          <!-- allocation -->
          <event symbol="EvtObjectCreate" value="1007" version="1"
                 channel="MozillaChannel" level="win:Verbose"
                 template="ObjectCreateTemplate" task="Allocation" opcode="ObjectCreate"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>
          <event symbol="EvtObjectFinalize" value="1008" version="1"
                 channel="MozillaChannel" level="win:Verbose"
                 template="ObjectFinalizeTemplate" task="Allocation" opcode="ObjectFinalize"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>
          
          <event symbol="EvtStringCreate" value="1009" version="1"
                 channel="MozillaChannel" level="win:Verbose"
                 template="StringCreateTemplate" task="Allocation" opcode="StringCreate"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>
          <event symbol="EvtStringFinalize" value="1010" version="1"
                 channel="MozillaChannel" level="win:Verbose"
                 template="StringFinalizeTemplate" task="Allocation" opcode="StringFinalize"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>

          <event symbol="EvtObjectResize" value="1011" version="1"
                 channel="MozillaChannel" level="win:Verbose"
                 template="ObjectResizeTemplate" task="Allocation" opcode="ObjectResize"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>

          <!-- GC -->
          <event symbol="EvtGCStart" value="1012" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="CompartmentTemplate" task="Allocation" opcode="GCStart"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>
          <event symbol="EvtGCEnd" value="1013" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="CompartmentTemplate" task="Allocation" opcode="GCEnd"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>

          <event symbol="EvtGCStartMarkPhase" value="1014" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="CompartmentTemplate" task="Allocation" opcode="GCMarkStart"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>
          <event symbol="EvtGCEndMarkPhase" value="1015" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="CompartmentTemplate" task="Allocation" opcode="GCMarkEnd"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>
                    
          <event symbol="EvtGCStartSweepPhase" value="1016" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="CompartmentTemplate" task="Allocation" opcode="GCSweepStart"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>
          <event symbol="EvtGCEndSweepPhase" value="1017" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="CompartmentTemplate" task="Allocation" opcode="GCSweepEnd"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>

          <event symbol="EvtMemoryAcquire" value="1018" version="1"
                 channel="MozillaChannel" level="win:Verbose"
                 template="MemoryLocationTemplate" task="Allocation" opcode="AcquireMemory"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>
          <event symbol="EvtMemoryRelease" value="1019" version="1"
                 channel="MozillaChannel" level="win:Verbose"
                 template="MemoryLocationTemplate" task="Allocation" opcode="ReleaseMemory"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>

          <event symbol="EvtHeapResize" value="1020" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="HeapResizeTemplate" task="Allocation" opcode="ResizeHeap"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>

          <event symbol="EvtCustomString" value="1021" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="StringTemplate" task="Markers" opcode="CustomMark"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>
          <event symbol="EvtCustomANSIString" value="1022" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="ANSIStringTemplate" task="Markers" opcode="CustomMark"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>
          <event symbol="EvtCustomInt" value="1023" version="1"
                 channel="MozillaChannel" level="win:Informational"
                 template="IntTemplate" task="Markers" opcode="CustomMark"
                 keywords="SampleKeyword" message="$(string.SampleProvider.SampleEvent.message)"/>
        </events>

	<!-- So far, I am just using the standard win:Informational and win:Verbose levels -->
        <levels>
        </levels>

        <tasks>
          <task name="Execution" symbol="ExecutionTask" value="1"
                eventGUID="{A77103F5-3C77-4d71-A11A-BC6564F9B5B7}"/>
          <task name="Allocation" symbol="AllocationTask" value="2"
                eventGUID="{1FBF0FBF-019C-4a3f-BCC5-364AD54C4823}"/>
          <task name="GC" symbol="GCTask" value="3"
                eventGUID="{4BC38669-3062-41e6-AF41-12AF2D692B05}"/>
          <task name="Markers" symbol="MarkersTask" value="4"
                eventGUID="{83a61eb2-aa42-11df-AF41-0021859332ad}"/>
        </tasks>

        <opcodes>
          <opcode name="Default" symbol="OpDefault" value="10"/>
          <opcode name="ExecuteStart" symbol="OpExecuteStart" value="11"/>
          <opcode name="ExecuteStop" symbol="OpExecuteStop" value="12"/>
          <opcode name="CompileBegin" symbol="OpCompileBegin" value="13"/>
          <opcode name="CompileEnd" symbol="OpCompileEnd" value="14"/>
          <opcode name="CalloutBegin" symbol="OpCalloutBegin" value="15"/>
          <opcode name="CalloutEnd" symbol="OpCalloutEnd" value="16"/>
          <opcode name="FunctionEnter" symbol="OpFunctionEnter" value="17"/>
          <opcode name="FunctionExit" symbol="OpFunctionExit" value="18"/>
          <opcode name="ObjectCreate" symbol="OpObjectCreate" value="19"/>
          <opcode name="ObjectFinalize" symbol="OpObjectFinalize" value="20"/>
          <opcode name="StringCreate" symbol="OpStringCreate" value="21"/>
          <opcode name="StringFinalize" symbol="OpStringFinalize" value="22"/>
          <opcode name="ObjectResize" symbol="OpObjectResize" value="23"/>
          <opcode name="GCStart" symbol="OpGCStart" value="24"/>
          <opcode name="GCEnd" symbol="OpGCEnd" value="25"/>
          <opcode name="GCMarkStart" symbol="OpGCMarkStart" value="26"/>
          <opcode name="GCMarkEnd" symbol="OpGCMarkEnd" value="27"/>
          <opcode name="GCSweepStart" symbol="OpGCSweepStart" value="28"/>
          <opcode name="GCSweepEnd" symbol="OpGCSweepEnd" value="29"/>
          <opcode name="AcquireMemory" symbol="OpAcquireMemory" value="30"/>
          <opcode name="ReleaseMemory" symbol="OpReleaseMemory" value="31"/>
          <opcode name="ResizeHeap" symbol="OpResizeHeap" value="32"/>
          <opcode name="CustomMark" symbol="OpCustomMark" value="33"/>
        </opcodes>
        
        <channels>
          <channel name="MozillaChannel" chid="MozillaPerformanceReportingChannel"
                   symbol="MOZILLA_PERFORMANCE_REPORTING_CHANNEL" type="Analytic"
                   enabled="true"/>
        </channels>

        <keywords>
          <keyword name="SampleKeyword" symbol="KwSample" mask="0x1"/>
        </keywords>
        
        <templates>
          <template tid="CodeLocationTemplate">
            <data name="FileName" inType="win:AnsiString" outType="xs:string"/>
            <data name="LineNumber" inType="win:Int32" outType="xs:int"/>
          </template>
          
          <template tid="ObjectCreateTemplate">
            <data name="FileName" inType="win:AnsiString" outType="xs:string"/>
            <data name="LineNumber" inType="win:Int32" outType="xs:int"/>
            <data name="ClassName" inType="win:AnsiString" outType="xs:string"/>
            <data name="Address" inType="win:Int64" outType="xs:long"/>
            <data name="Size" inType="win:Int64" outType="xs:long"/>
          </template>

          <template tid="ObjectFinalizeTemplate">
            <data name="ClassName" inType="win:AnsiString" outType="xs:string"/>
            <data name="Address" inType="win:Int64" outType="xs:long"/>
          </template>

          <template tid="ObjectResizeTemplate">
            <data name="FileName" inType="win:AnsiString" outType="xs:string"/>
            <data name="LineNumber" inType="win:Int32" outType="xs:int"/>
            <data name="ClassName" inType="win:AnsiString" outType="xs:string"/>
            <data name="Address" inType="win:Int64" outType="xs:long"/>
            <data name="OldSize" inType="win:Int64" outType="xs:long"/>
            <data name="NewSize" inType="win:Int64" outType="xs:long"/>
          </template>

          <template tid="FunctionInvocationTemplate">
            <data name="FileName" inType="win:AnsiString" outType="xs:string"/>
            <data name="LineNumber" inType="win:Int32" outType="xs:int"/>
            <data name="ClassName" inType="win:AnsiString" outType="xs:string"/>
            <data name="FunctionName" inType="win:AnsiString" outType="xs:string"/>
          </template>

          <template tid="StringCreateTemplate">
            <data name="FileName" inType="win:AnsiString" outType="xs:string"/>
            <data name="LineNumber" inType="win:Int32" outType="xs:int"/>
            <data name="Address" inType="win:Int64" outType="xs:long"/>
            <data name="Size" inType="win:Int64" outType="xs:long"/>
          </template>

          <template tid="StringFinalizeTemplate">
            <data name="Address" inType="win:Int64" outType="xs:long"/>
            <data name="Size" inType="win:Int64" outType="xs:long"/>
          </template>

          <template tid="CompartmentTemplate">
            <data name="Compartment" inType="win:Int64" outType="xs:long"/>
          </template>

          <template tid="MemoryLocationTemplate">
            <data name="Compartment" inType="win:Int64" outType="xs:long"/>
            <data name="Address" inType="win:Int64" outType="xs:long"/>
            <data name="Size" inType="win:Int64" outType="xs:long"/>
          </template>

          <template tid="HeapResizeTemplate">
            <data name="Compartment" inType="win:Int64" outType="xs:long"/>
            <data name="OldSize" inType="win:Int64" outType="xs:long"/>
            <data name="NewSize" inType="win:Int64" outType="xs:long"/>
          </template>

          <template tid="ANSIStringTemplate">
            <data name="String" inType="win:AnsiString" outType="xs:string"/>
          </template>

          <template tid="StringTemplate">
            <data name="String" inType="win:UnicodeString" outType="xs:string"/>
          </template>

          <template tid="IntTemplate">
            <data name="Int" inType="win:Int32" outType="xs:int"/>
          </template>

        </templates>
      </provider>
    </events>
  </instrumentation>

  <localization>
    <resources culture="en-US">
      <stringTable>
        <string id="ProviderMessage" value="Event traces for Mozilla SpiderMonkey (Javascript engine)"/>
        <string id="MozillaSpiderMonkey.ExecuteStart.message" value="Javascript execution start" />
        <string id="MozillaSpiderMonkey.ExecuteDone.message" value="Javascript execution end" />

        <string id="MozillaSpiderMonkey.ScriptCompileBegin.message" value="Javascript code compilation start" />
        <string id="MozillaSpiderMonkey.ScriptCompileEnd.message" value="Javascript code compilation end" />
        <string id="SampleProvider.SampleEvent.message" value="Sample message" />
      </stringTable>
    </resources>
  </localization>
</instrumentationManifest>
