{- This module was generated from data in the Kate syntax highlighting file vhdl.xml, version 1.10,
   by  Rocky Scaletta (rocky@purdue.edu), Stefan Endrullis (stefan@endrullis.de), Florent Ouchet (outchy@users.sourceforge.net), Chris Higgs (chiggs.99@gmail.com), Jan Michel (jan@mueschelsoft.de) -}

module Text.Highlighting.Kate.Syntax.Vhdl ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "VHDL"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.vhdl;*.vhd"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "VHDL" }
  context <- currentContext <|> (pushContext "start" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("VHDL",["start"])], synStLanguage = "VHDL", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "start" -> return () >> pHandleEndLine
    "package" -> return () >> pHandleEndLine
    "packagebody" -> return () >> pHandleEndLine
    "architecture_main" -> return () >> pHandleEndLine
    "arch_decl" -> return () >> pHandleEndLine
    "detect_arch_parts" -> return () >> pHandleEndLine
    "generate1" -> return () >> pHandleEndLine
    "generate2" -> return () >> pHandleEndLine
    "process1" -> return () >> pHandleEndLine
    "proc_rules" -> return () >> pHandleEndLine
    "instance" -> return () >> pHandleEndLine
    "forOrWhile" -> return () >> pHandleEndLine
    "if_start" -> return () >> pHandleEndLine
    "if" -> return () >> pHandleEndLine
    "case1" -> return () >> pHandleEndLine
    "case2" -> return () >> pHandleEndLine
    "caseWhen" -> return () >> pHandleEndLine
    "entity" -> return () >> pHandleEndLine
    "entity_main" -> return () >> pHandleEndLine
    "preDetection" -> return () >> pHandleEndLine
    "generalDetection" -> return () >> pHandleEndLine
    "comment" -> (popContext) >> pEndLine
    "string" -> return () >> pHandleEndLine
    "attribute" -> (popContext) >> pEndLine
    "quot in att" -> return () >> pHandleEndLine
    "signal" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Data Type","dt"),("Comment","co"),("Integer","dv"),("Bit","ch"),("Error","er"),("Vector","st"),("Operator","ot"),("Attribute","bn"),("Region Marker","re"),("Signal","ot"),("Range","ot"),("Redirection","kw"),("Process","kw"),("Control","kw"),("Name","kw")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_keywordsToplevel = Set.fromList $ words $ "file library use"
list_keywords = Set.fromList $ words $ "access after alias all array assert assume assume_guarantee attribute begin block body bus component constant context cover default disconnect downto end exit fairness file force function generate generic group guarded impure inertial is label linkage literal map new next null of on open others parameter port postponed procedure process property protected pure range record register reject release report return select sequence severity signal shared strong subtype to transport type unaffected units until variable vmode vprop vunit wait when with note warning error failure in inout out buffer and abs or xor xnor not mod nand nor rem rol ror sla sra sll srl"
list_if = Set.fromList $ words $ "if else elsif then"
list_forOrWhile = Set.fromList $ words $ "loop"
list_directions = Set.fromList $ words $ "in inout out buffer linkage"
list_signals = Set.fromList $ words $ "signal variable constant type"
list_range = Set.fromList $ words $ "to downto others"
list_case = Set.fromList $ words $ "case when"
list_types = Set.fromList $ words $ "bit bit_vector character boolean boolean_vector integer integer_vector real real_vector time time_vector delay_length string severity_level positive natural file_open_kind file_open_status signed unsigned unresolved_unsigned unresolved_signed line text side width std_logic std_logic_vector std_ulogic std_ulogic_vector x01 x01z ux01 ux01z qsim_state qsim_state_vector qsim_12state qsim_12state_vector qsim_strength mux_bit mux_vector reg_bit reg_vector wor_bit wor_vector"

regex_'28'5cb'29'28package'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bis'29'5cb = compileRegex "(\\b)(package\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+is)\\b"
regex_'28'5cb'29'28package'5cs'2bbody'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bis'29'5cb = compileRegex "(\\b)(package\\s+body\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+is)\\b"
regex_architecture'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bof'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bis = compileRegex "architecture\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+of\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+is"
regex_'28'5cb'29generate'5cb = compileRegex "(\\b)generate\\b"
regex_'28'5cb'29end'5cs'2bgenerate'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b = compileRegex "(\\b)end\\s+generate(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\s*;"
regex_'28'5cb'29'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'28'3f'3d'5cs'2a'3a'28'3f'21'3d'29'29 = compileRegex "(\\b)\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b(?=\\s*:(?!=))"
regex_'28'5cb'29'28if'29'5cb = compileRegex "(\\b)(if)\\b"
regex_'28'5cb'29'28'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2a'3a'5cs'2a'29'3f'28'28for'7cwhile'29'5cs'2b'2e'2b'5cs'2b'29'3floop'5cb = compileRegex "(\\b)((\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*:\\s*)?((for|while)\\s+.+\\s+)?loop\\b"
regex_'28'5cb'29end'5cs'2bloop'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b = compileRegex "(\\b)end\\s+loop(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\s*;"
regex_'28'5cb'29end'5cs'2bif'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b = compileRegex "(\\b)end\\s+if(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\s*;"
regex_'28'5cb'29end'5cs'2bcase'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b = compileRegex "(\\b)end\\s+case(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\s*;"
regex_'28'5cb'29when'5cb = compileRegex "(\\b)when\\b"
regex_'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29 = compileRegex "(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)"
regex_generic = compileRegex "generic"
regex_port = compileRegex "port"

defaultAttributes = [("start","Normal Text"),("package","Normal Text"),("packagebody","Normal Text"),("architecture_main","Normal Text"),("arch_decl","Normal Text"),("detect_arch_parts","Normal Text"),("generate1","Normal Text"),("generate2","Normal Text"),("process1","Normal Text"),("proc_rules","Normal Text"),("instance","Normal Text"),("forOrWhile","Normal Text"),("if_start","Normal Text"),("if","Normal Text"),("case1","Normal Text"),("case2","Normal Text"),("caseWhen","Normal Text"),("entity","Normal Text"),("entity_main","Normal Text"),("preDetection","Normal Text"),("generalDetection","Normal Text"),("comment","Comment"),("string","Vector"),("attribute","Attribute"),("quot in att","Attribute"),("signal","Normal Text")]

parseRules "start" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((lookAhead (pRegExprDynamic "architecture\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)") >> return ([],"") ) >>~ pushContext "architecture_main")
                        <|>
                        ((pString False "entity" >>= withAttribute "Control") >>~ pushContext "entity")
                        <|>
                        ((lookAhead (pRegExpr regex_'28'5cb'29'28package'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bis'29'5cb) >> return ([],"") ) >>~ pushContext "package")
                        <|>
                        ((lookAhead (pRegExpr regex_'28'5cb'29'28package'5cs'2bbody'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bis'29'5cb) >> return ([],"") ) >>~ pushContext "packagebody")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywordsToplevel >>= withAttribute "Keyword")))
     return (attr, result)

parseRules "package" = 
  do (attr, result) <- (((pString True "%2" >>= withAttribute "Redirection"))
                        <|>
                        ((parseRules "preDetection"))
                        <|>
                        ((pString False "begin" >>= withAttribute "Redirection"))
                        <|>
                        ((pRegExprDynamic "(\\b)end(\\s+package)?(\\s+%3)?\\s*;" >>= withAttribute "Redirection") >>~ (popContext))
                        <|>
                        ((parseRules "generalDetection")))
     return (attr, result)

parseRules "packagebody" = 
  do (attr, result) <- (((pString True "%2" >>= withAttribute "Redirection"))
                        <|>
                        ((parseRules "preDetection"))
                        <|>
                        ((pString False "begin" >>= withAttribute "Redirection"))
                        <|>
                        ((pRegExprDynamic "(\\b)end(\\s+package)?(\\s+%3)?\\s*;" >>= withAttribute "Redirection") >>~ (popContext))
                        <|>
                        ((parseRules "generalDetection")))
     return (attr, result)

parseRules "architecture_main" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((pRegExpr regex_architecture'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bof'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bis >>= withAttribute "Control") >>~ pushContext "arch_decl")
                        <|>
                        ((pRegExprDynamic "(\\b)end(\\s+architecture)?(\\s+%1)?\\s*;" >>= withAttribute "Control") >>~ (popContext >> popContext))
                        <|>
                        ((pRegExprDynamic "(\\b)end(\\s+architecture)?(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*;" >>= withAttribute "Error") >>~ (popContext >> popContext))
                        <|>
                        ((parseRules "detect_arch_parts")))
     return (attr, result)

parseRules "arch_decl" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_signals >>= withAttribute "Signal") >>~ pushContext "signal")
                        <|>
                        ((pString False "component" >>= withAttribute "Control") >>~ pushContext "entity")
                        <|>
                        ((pString False "begin" >>= withAttribute "Control") >>~ (popContext))
                        <|>
                        ((parseRules "generalDetection")))
     return (attr, result)

parseRules "detect_arch_parts" = 
  do (attr, result) <- (((lookAhead (pRegExprDynamic "(\\b)((\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*:\\s*)(if|for).*\\s+generate\\b") >> return ([],"") ) >>~ pushContext "generate1")
                        <|>
                        ((lookAhead (pRegExprDynamic "(\\b)((\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*:\\s*)?process\\b") >> return ([],"") ) >>~ pushContext "process1")
                        <|>
                        ((lookAhead (pRegExprDynamic "\\b(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*:\\s*(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)") >> return ([],"") ) >>~ pushContext "instance")
                        <|>
                        ((parseRules "generalDetection")))
     return (attr, result)

parseRules "generate1" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((pRegExpr regex_'28'5cb'29generate'5cb >>= withAttribute "Control") >>~ pushContext "generate2")
                        <|>
                        ((pRegExprDynamic "(\\b)%3\\b" >>= withAttribute "Name"))
                        <|>
                        ((pString False "for" >>= withAttribute "Control"))
                        <|>
                        ((pString False "if" >>= withAttribute "Control"))
                        <|>
                        ((parseRules "generalDetection")))
     return (attr, result)

parseRules "generate2" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((pString False "begin" >>= withAttribute "Control"))
                        <|>
                        ((pRegExpr regex_'28'5cb'29end'5cs'2bgenerate'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b >>= withAttribute "Control") >>~ (popContext >> popContext))
                        <|>
                        ((parseRules "detect_arch_parts")))
     return (attr, result)

parseRules "process1" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((pRegExprDynamic "end\\s+process(\\s+%3)?\\s*;" >>= withAttribute "Process") >>~ (popContext))
                        <|>
                        ((pRegExprDynamic "end\\s+process(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?" >>= withAttribute "Error") >>~ (popContext))
                        <|>
                        ((pString False "process" >>= withAttribute "Process"))
                        <|>
                        ((pString False "begin" >>= withAttribute "Process"))
                        <|>
                        ((parseRules "proc_rules")))
     return (attr, result)

parseRules "proc_rules" = 
  do (attr, result) <- (((pRegExpr regex_'28'5cb'29'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'28'3f'3d'5cs'2a'3a'28'3f'21'3d'29'29 >>= withAttribute "Name"))
                        <|>
                        ((pRegExpr regex_'28'5cb'29'28if'29'5cb >>= withAttribute "Control") >>~ pushContext "if_start")
                        <|>
                        ((lookAhead (pRegExprDynamic "(\\b)(case)\\b") >> return ([],"") ) >>~ pushContext "case1")
                        <|>
                        ((pRegExpr regex_'28'5cb'29'28'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2a'3a'5cs'2a'29'3f'28'28for'7cwhile'29'5cs'2b'2e'2b'5cs'2b'29'3floop'5cb >>= withAttribute "Control") >>~ pushContext "forOrWhile")
                        <|>
                        ((parseRules "generalDetection")))
     return (attr, result)

parseRules "instance" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((pRegExprDynamic "\\b%1\\b" >>= withAttribute "Name"))
                        <|>
                        ((pRegExprDynamic "\\b%2\\b" >>= withAttribute "Name"))
                        <|>
                        ((pDetect2Chars False ')' ';' >>= withAttribute "Normal Text") >>~ (popContext))
                        <|>
                        ((parseRules "generalDetection")))
     return (attr, result)

parseRules "forOrWhile" = 
  do (attr, result) <- (((pRegExpr regex_'28'5cb'29end'5cs'2bloop'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b >>= withAttribute "Control") >>~ (popContext))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_forOrWhile >>= withAttribute "Control"))
                        <|>
                        ((parseRules "proc_rules")))
     return (attr, result)

parseRules "if_start" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((pString False "then" >>= withAttribute "Control") >>~ pushContext "if")
                        <|>
                        ((parseRules "generalDetection")))
     return (attr, result)

parseRules "if" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((pRegExpr regex_'28'5cb'29end'5cs'2bif'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b >>= withAttribute "Control") >>~ (popContext >> popContext))
                        <|>
                        ((parseRules "proc_rules"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_if >>= withAttribute "Control")))
     return (attr, result)

parseRules "case1" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((pString False "is" >>= withAttribute "Keyword") >>~ pushContext "case2")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_case >>= withAttribute "Control")))
     return (attr, result)

parseRules "case2" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((pRegExpr regex_'28'5cb'29end'5cs'2bcase'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b >>= withAttribute "Control") >>~ (popContext >> popContext))
                        <|>
                        ((pString False "when" >>= withAttribute "Control") >>~ pushContext "caseWhen")
                        <|>
                        ((parseRules "proc_rules")))
     return (attr, result)

parseRules "caseWhen" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((lookAhead (pRegExpr regex_'28'5cb'29when'5cb) >> return ([],"") ) >>~ (popContext))
                        <|>
                        ((lookAhead (pRegExpr regex_'28'5cb'29end'5cs'2bcase'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b) >> return ([],"") ) >>~ (popContext))
                        <|>
                        ((parseRules "proc_rules")))
     return (attr, result)

parseRules "entity" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((pRegExpr regex_'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29 >>= withAttribute "Name") >>~ pushContext "entity_main")
                        <|>
                        ((parseRules "generalDetection")))
     return (attr, result)

parseRules "entity_main" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((pRegExprDynamic "(\\b)end(\\s+(entity|component))?(\\s+%1)?\\s*;" >>= withAttribute "Control") >>~ (popContext >> popContext))
                        <|>
                        ((pRegExprDynamic "(\\b)end(\\s+(entity|component))?(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\s*;" >>= withAttribute "Error") >>~ (popContext >> popContext))
                        <|>
                        ((pRegExpr regex_generic >>= withAttribute "Control"))
                        <|>
                        ((pRegExpr regex_port >>= withAttribute "Control"))
                        <|>
                        ((parseRules "generalDetection")))
     return (attr, result)

parseRules "preDetection" = 
  do (attr, result) <- (((pDetect2Chars False '-' '-' >>= withAttribute "Comment") >>~ pushContext "comment")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "Vector") >>~ pushContext "string")
                        <|>
                        ((pAnyChar "[&><=:+\\-*\\/|].," >>= withAttribute "Operator"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Attribute") >>~ pushContext "attribute"))
     return (attr, result)

parseRules "generalDetection" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute "Data Type"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_signals >>= withAttribute "Signal") >>~ pushContext "signal")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_range >>= withAttribute "Range"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pInt >>= withAttribute "Integer"))
                        <|>
                        ((pHlCChar >>= withAttribute "Bit"))
                        <|>
                        ((pDetectSpaces >>= withAttribute "Normal Text")))
     return (attr, result)

parseRules "comment" = 
  pzero

parseRules "string" = 
  do (attr, result) <- ((pDetectChar False '"' >>= withAttribute "Vector") >>~ (popContext))
     return (attr, result)

parseRules "attribute" = 
  do (attr, result) <- (((pDetectChar False '"' >>= withAttribute "Attribute") >>~ pushContext "quot in att")
                        <|>
                        ((pDetectChar False ' ' >>= withAttribute "Normal Text") >>~ (popContext))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Attribute") >>~ (popContext))
                        <|>
                        ((pAnyChar "()=<>" >>= withAttribute "Attribute") >>~ (popContext)))
     return (attr, result)

parseRules "quot in att" = 
  do (attr, result) <- ((pDetectChar False '"' >>= withAttribute "Attribute") >>~ (popContext))
     return (attr, result)

parseRules "signal" = 
  do (attr, result) <- (((parseRules "preDetection"))
                        <|>
                        ((pDetectChar False ';' >>= withAttribute "Normal Text") >>~ (popContext))
                        <|>
                        ((parseRules "generalDetection")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
