{- This module was generated from data in the Kate syntax highlighting file pango.xml, version 0.1,
   by  Jonathan Schmidt-Domniné <devel@the-user.org> -}

module Text.Highlighting.Kate.Syntax.Pango ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Pango"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = ""

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Pango" }
  context <- currentContext <|> (pushContext "Start" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Pango",["Start"])], synStLanguage = "Pango", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Start" -> return () >> pHandleEndLine
    "FindPango" -> return () >> pHandleEndLine
    "FindAttributes" -> return () >> pHandleEndLine
    "InGravity" -> return () >> pHandleEndLine
    "InGravityHint" -> return () >> pHandleEndLine
    "InStretch" -> return () >> pHandleEndLine
    "InBoolean" -> return () >> pHandleEndLine
    "InStyle" -> return () >> pHandleEndLine
    "InUnderline" -> return () >> pHandleEndLine
    "InVariant" -> return () >> pHandleEndLine
    "InWeight" -> return () >> pHandleEndLine
    "InColor" -> return () >> pHandleEndLine
    "InInt" -> return () >> pHandleEndLine
    "InString" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Element","kw"),("Key","ot"),("Value","st"),("Decimal","dv"),("Color","fl"),("String","st"),("Error","er")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_tags = Set.fromList $ words $ "<span <b <big <i <s <sub <sup <small <tt <u"
list_endtags = Set.fromList $ words $ "</span> </b> </big> </i> </s> </sub> </sup> </small> </tt> </u>"
list_int'5fattributes = Set.fromList $ words $ "size= font_size= rise= letter_spacing="
list_plain'5fattributes = Set.fromList $ words $ "font= font_desc= font_family= face= lang="
list_color'5fattributes = Set.fromList $ words $ "strikethrough_color= foreground= fgcolor= color= background= bgcolor= underline_color="

regex_'3c'2f'28span'7cb'7cbig'7ci'7cs'7csub'7csup'7csmall'7ctt'7cu'29'3e = compileRegex "</(span|b|big|i|s|sub|sup|small|tt|u)>"
regex_'3c'28span'7cb'7cbig'7ci'7cs'7csub'7csup'7csmall'7ctt'7cu'29 = compileRegex "<(span|b|big|i|s|sub|sup|small|tt|u)"
regex_gravity'3d = compileRegex "gravity="
regex_gravity'5fhint'3d = compileRegex "gravity_hint="
regex_'28font'5f'29'3fstretch'3d = compileRegex "(font_)?stretch="
regex_'28strikethrough'7cfallback'29'3d = compileRegex "(strikethrough|fallback)="
regex_'28font'5f'29'3fstyle'3d = compileRegex "(font_)?style="
regex_underline'3d = compileRegex "underline="
regex_'28font'5f'29'3fvariant'3d = compileRegex "(font_)?variant="
regex_'28font'5f'29'3fweight'3d = compileRegex "(font_)?weight="
regex_'28size'7cfont'5fsize'7crise'7cletter'5fspacing'29'3d = compileRegex "(size|font_size|rise|letter_spacing)="
regex_'28font'7cfont'5fdesc'7cfont'5ffamily'7cface'7clang'29'3d = compileRegex "(font|font_desc|font_family|face|lang)="
regex_'28strikethrough'5fcolor'7cforeground'7cfgcolor'7ccolor'7cbackground'7cbgcolor'7cunderline'5fcolor'29'3d = compileRegex "(strikethrough_color|foreground|fgcolor|color|background|bgcolor|underline_color)="
regex_'5cS = compileRegex "\\S"
regex_'27'28south'7ceast'7cnorth'7cwest'7cauto'29'27 = compileRegex "'(south|east|north|west|auto)'"
regex_'27'28natural'7cstrong'7cline'29'27 = compileRegex "'(natural|strong|line)'"
regex_'27'28ultracondensed'7cextracondensed'7ccondensed'7csemicondensed'7cnormal'7csemiexpanded'7cexpanded'7cextraexpanded'7cultraexpanded'29'27 = compileRegex "'(ultracondensed|extracondensed|condensed|semicondensed|normal|semiexpanded|expanded|extraexpanded|ultraexpanded)'"
regex_'27'28false'7ctrue'29'27 = compileRegex "'(false|true)'"
regex_'27'28normal'7coblique'7citalic'29'27 = compileRegex "'(normal|oblique|italic)'"
regex_'27'28none'7csingle'7cdouble'7clow'7cerror'29'27 = compileRegex "'(none|single|double|low|error)'"
regex_'27'28normal'7csmallcaps'29'27 = compileRegex "'(normal|smallcaps)'"
regex_'27'5b0'2d9'5d'2a'27 = compileRegex "'[0-9]*'"
regex_'27'28ultralight'7clight'7cnormal'7cbold'7cultrabold'7cheavy'29'27 = compileRegex "'(ultralight|light|normal|bold|ultrabold|heavy)'"
regex_'27'28'28'23'5b0'2d9a'2dfA'2dF'5d'7b3'7d'29'7b1'2c4'7d'7csnow'7cghost_white'7cGhostWhite'7cwhite_smoke'7cWhiteSmoke'7cgainsboro'7cfloral_white'7cFloralWhite'7cold_lace'7cOldLace'7clinen'7cantique_white'7cAntiqueWhite'7cpapaya_whip'7cPapayaWhip'7cblanched_almond'7cBlanchedAlmond'7cbisque'7cpeach_puff'7cPeachPuff'7cnavajo_white'7cNavajoWhite'7cmoccasin'7ccornsilk'7civory'7clemon_chiffon'7cLemonChiffon'7cseashell'7choneydew'7cmint_cream'7cMintCream'7cazure'7calice_blue'7cAliceBlue'7clavender'7clavender_blush'7cLavenderBlush'7cmisty_rose'7cMistyRose'7cwhite'7cblack'7cdark_slate_gray'7cDarkSlateGray'7cdark_slate_grey'7cDarkSlateGrey'7cdim_gray'7cDimGray'7cdim_grey'7cDimGrey'7cslate_gray'7cSlateGray'7cslate_grey'7cSlateGrey'7clight_slate_gray'7cLightSlateGray'7clight_slate_grey'7cLightSlateGrey'7cgray'7cgrey'7clight_grey'7cLightGrey'7clight_gray'7cLightGray'7cmidnight_blue'7cMidnightBlue'7cnavy'7cnavy_blue'7cNavyBlue'7ccornflower_blue'7cCornflowerBlue'7cdark_slate_blue'7cDarkSlateBlue'7cslate_blue'7cSlateBlue'7cmedium_slate_blue'7cMediumSlateBlue'7clight_slate_blue'7cLightSlateBlue'7cmedium_blue'7cMediumBlue'7croyal_blue'7cRoyalBlue'7cblue'7cdodger_blue'7cDodgerBlue'7cdeep_sky_blue'7cDeepSkyBlue'7csky_blue'7cSkyBlue'7clight_sky_blue'7cLightSkyBlue'7csteel_blue'7cSteelBlue'7clight_steel_blue'7cLightSteelBlue'7clight_blue'7cLightBlue'7cpowder_blue'7cPowderBlue'7cpale_turquoise'7cPaleTurquoise'7cdark_turquoise'7cDarkTurquoise'7cmedium_turquoise'7cMediumTurquoise'7cturquoise'7ccyan'7clight_cyan'7cLightCyan'7ccadet_blue'7cCadetBlue'7cmedium_aquamarine'7cMediumAquamarine'7caquamarine'7cdark_green'7cDarkGreen'7cdark_olive_green'7cDarkOliveGreen'7cdark_sea_green'7cDarkSeaGreen'7csea_green'7cSeaGreen'7cmedium_sea_green'7cMediumSeaGreen'7clight_sea_green'7cLightSeaGreen'7cpale_green'7cPaleGreen'7cspring_green'7cSpringGreen'7clawn_green'7cLawnGreen'7cgreen'7cchartreuse'7cmedium_spring_green'7cMediumSpringGreen'7cgreen_yellow'7cGreenYellow'7clime_green'7cLimeGreen'7cyellow_green'7cYellowGreen'7cforest_green'7cForestGreen'7colive_drab'7cOliveDrab'7cdark_khaki'7cDarkKhaki'7ckhaki'7cpale_goldenrod'7cPaleGoldenrod'7clight_goldenrod_yellow'7cLightGoldenrodYellow'7clight_yellow'7cLightYellow'7cyellow'7cgold'7clight_goldenrod'7cLightGoldenrod'7cgoldenrod'7cdark_goldenrod'7cDarkGoldenrod'7crosy_brown'7cRosyBrown'7cindian_red'7cIndianRed'7csaddle_brown'7cSaddleBrown'7csienna'7cperu'7cburlywood'7cbeige'7cwheat'7csandy_brown'7cSandyBrown'7ctan'7cchocolate'7cfirebrick'7cbrown'7cdark_salmon'7cDarkSalmon'7csalmon'7clight_salmon'7cLightSalmon'7corange'7cdark_orange'7cDarkOrange'7ccoral'7clight_coral'7cLightCoral'7ctomato'7corange_red'7cOrangeRed'7cred'7chot_pink'7cHotPink'7cdeep_pink'7cDeepPink'7cpink'7clight_pink'7cLightPink'7cpale_violet_red'7cPaleVioletRed'7cmaroon'7cmedium_violet_red'7cMediumVioletRed'7cviolet_red'7cVioletRed'7cmagenta'7cviolet'7cplum'7corchid'7cmedium_orchid'7cMediumOrchid'7cdark_orchid'7cDarkOrchid'7cdark_violet'7cDarkViolet'7cblue_violet'7cBlueViolet'7cpurple'7cmedium_purple'7cMediumPurple'7cthistle'7csnow1'7csnow2'7csnow3'7csnow4'7cseashell1'7cseashell2'7cseashell3'7cseashell4'7cAntiqueWhite1'7cAntiqueWhite2'7cAntiqueWhite3'7cAntiqueWhite4'7cbisque1'7cbisque2'7cbisque3'7cbisque4'7cPeachPuff1'7cPeachPuff2'7cPeachPuff3'7cPeachPuff4'7cNavajoWhite1'7cNavajoWhite2'7cNavajoWhite3'7cNavajoWhite4'7cLemonChiffon1'7cLemonChiffon2'7cLemonChiffon3'7cLemonChiffon4'7ccornsilk1'7ccornsilk2'7ccornsilk3'7ccornsilk4'7civory1'7civory2'7civory3'7civory4'7choneydew1'7choneydew2'7choneydew3'7choneydew4'7cLavenderBlush1'7cLavenderBlush2'7cLavenderBlush3'7cLavenderBlush4'7cMistyRose1'7cMistyRose2'7cMistyRose3'7cMistyRose4'7cazure1'7cazure2'7cazure3'7cazure4'7cSlateBlue1'7cSlateBlue2'7cSlateBlue3'7cSlateBlue4'7cRoyalBlue1'7cRoyalBlue2'7cRoyalBlue3'7cRoyalBlue4'7cblue1'7cblue2'7cblue3'7cblue4'7cDodgerBlue1'7cDodgerBlue2'7cDodgerBlue3'7cDodgerBlue4'7cSteelBlue1'7cSteelBlue2'7cSteelBlue3'7cSteelBlue4'7cDeepSkyBlue1'7cDeepSkyBlue2'7cDeepSkyBlue3'7cDeepSkyBlue4'7cSkyBlue1'7cSkyBlue2'7cSkyBlue3'7cSkyBlue4'7cLightSkyBlue1'7cLightSkyBlue2'7cLightSkyBlue3'7cLightSkyBlue4'7cSlateGray1'7cSlateGray2'7cSlateGray3'7cSlateGray4'7cLightSteelBlue1'7cLightSteelBlue2'7cLightSteelBlue3'7cLightSteelBlue4'7cLightBlue1'7cLightBlue2'7cLightBlue3'7cLightBlue4'7cLightCyan1'7cLightCyan2'7cLightCyan3'7cLightCyan4'7cPaleTurquoise1'7cPaleTurquoise2'7cPaleTurquoise3'7cPaleTurquoise4'7cCadetBlue1'7cCadetBlue2'7cCadetBlue3'7cCadetBlue4'7cturquoise1'7cturquoise2'7cturquoise3'7cturquoise4'7ccyan1'7ccyan2'7ccyan3'7ccyan4'7cDarkSlateGray1'7cDarkSlateGray2'7cDarkSlateGray3'7cDarkSlateGray4'7caquamarine1'7caquamarine2'7caquamarine3'7caquamarine4'7cDarkSeaGreen1'7cDarkSeaGreen2'7cDarkSeaGreen3'7cDarkSeaGreen4'7cSeaGreen1'7cSeaGreen2'7cSeaGreen3'7cSeaGreen4'7cPaleGreen1'7cPaleGreen2'7cPaleGreen3'7cPaleGreen4'7cSpringGreen1'7cSpringGreen2'7cSpringGreen3'7cSpringGreen4'7cgreen1'7cgreen2'7cgreen3'7cgreen4'7cchartreuse1'7cchartreuse2'7cchartreuse3'7cchartreuse4'7cOliveDrab1'7cOliveDrab2'7cOliveDrab3'7cOliveDrab4'7cDarkOliveGreen1'7cDarkOliveGreen2'7cDarkOliveGreen3'7cDarkOliveGreen4'7ckhaki1'7ckhaki2'7ckhaki3'7ckhaki4'7cLightGoldenrod1'7cLightGoldenrod2'7cLightGoldenrod3'7cLightGoldenrod4'7cLightYellow1'7cLightYellow2'7cLightYellow3'7cLightYellow4'7cyellow1'7cyellow2'7cyellow3'7cyellow4'7cgold1'7cgold2'7cgold3'7cgold4'7cgoldenrod1'7cgoldenrod2'7cgoldenrod3'7cgoldenrod4'7cDarkGoldenrod1'7cDarkGoldenrod2'7cDarkGoldenrod3'7cDarkGoldenrod4'7cRosyBrown1'7cRosyBrown2'7cRosyBrown3'7cRosyBrown4'7cIndianRed1'7cIndianRed2'7cIndianRed3'7cIndianRed4'7csienna1'7csienna2'7csienna3'7csienna4'7cburlywood1'7cburlywood2'7cburlywood3'7cburlywood4'7cwheat1'7cwheat2'7cwheat3'7cwheat4'7ctan1'7ctan2'7ctan3'7ctan4'7cchocolate1'7cchocolate2'7cchocolate3'7cchocolate4'7cfirebrick1'7cfirebrick2'7cfirebrick3'7cfirebrick4'7cbrown1'7cbrown2'7cbrown3'7cbrown4'7csalmon1'7csalmon2'7csalmon3'7csalmon4'7cLightSalmon1'7cLightSalmon2'7cLightSalmon3'7cLightSalmon4'7corange1'7corange2'7corange3'7corange4'7cDarkOrange1'7cDarkOrange2'7cDarkOrange3'7cDarkOrange4'7ccoral1'7ccoral2'7ccoral3'7ccoral4'7ctomato1'7ctomato2'7ctomato3'7ctomato4'7cOrangeRed1'7cOrangeRed2'7cOrangeRed3'7cOrangeRed4'7cred1'7cred2'7cred3'7cred4'7cDeepPink1'7cDeepPink2'7cDeepPink3'7cDeepPink4'7cHotPink1'7cHotPink2'7cHotPink3'7cHotPink4'7cpink1'7cpink2'7cpink3'7cpink4'7cLightPink1'7cLightPink2'7cLightPink3'7cLightPink4'7cPaleVioletRed1'7cPaleVioletRed2'7cPaleVioletRed3'7cPaleVioletRed4'7cmaroon1'7cmaroon2'7cmaroon3'7cmaroon4'7cVioletRed1'7cVioletRed2'7cVioletRed3'7cVioletRed4'7cmagenta1'7cmagenta2'7cmagenta3'7cmagenta4'7corchid1'7corchid2'7corchid3'7corchid4'7cplum1'7cplum2'7cplum3'7cplum4'7cMediumOrchid1'7cMediumOrchid2'7cMediumOrchid3'7cMediumOrchid4'7cDarkOrchid1'7cDarkOrchid2'7cDarkOrchid3'7cDarkOrchid4'7cpurple1'7cpurple2'7cpurple3'7cpurple4'7cMediumPurple1'7cMediumPurple2'7cMediumPurple3'7cMediumPurple4'7cthistle1'7cthistle2'7cthistle3'7cthistle4'7cgray0'7cgrey0'7cgray1'7cgrey1'7cgray2'7cgrey2'7cgray3'7cgrey3'7cgray4'7cgrey4'7cgray5'7cgrey5'7cgray6'7cgrey6'7cgray7'7cgrey7'7cgray8'7cgrey8'7cgray9'7cgrey9'7cgray10'7cgrey10'7cgray11'7cgrey11'7cgray12'7cgrey12'7cgray13'7cgrey13'7cgray14'7cgrey14'7cgray15'7cgrey15'7cgray16'7cgrey16'7cgray17'7cgrey17'7cgray18'7cgrey18'7cgray19'7cgrey19'7cgray20'7cgrey20'7cgray21'7cgrey21'7cgray22'7cgrey22'7cgray23'7cgrey23'7cgray24'7cgrey24'7cgray25'7cgrey25'7cgray26'7cgrey26'7cgray27'7cgrey27'7cgray28'7cgrey28'7cgray29'7cgrey29'7cgray30'7cgrey30'7cgray31'7cgrey31'7cgray32'7cgrey32'7cgray33'7cgrey33'7cgray34'7cgrey34'7cgray35'7cgrey35'7cgray36'7cgrey36'7cgray37'7cgrey37'7cgray38'7cgrey38'7cgray39'7cgrey39'7cgray40'7cgrey40'7cgray41'7cgrey41'7cgray42'7cgrey42'7cgray43'7cgrey43'7cgray44'7cgrey44'7cgray45'7cgrey45'7cgray46'7cgrey46'7cgray47'7cgrey47'7cgray48'7cgrey48'7cgray49'7cgrey49'7cgray50'7cgrey50'7cgray51'7cgrey51'7cgray52'7cgrey52'7cgray53'7cgrey53'7cgray54'7cgrey54'7cgray55'7cgrey55'7cgray56'7cgrey56'7cgray57'7cgrey57'7cgray58'7cgrey58'7cgray59'7cgrey59'7cgray60'7cgrey60'7cgray61'7cgrey61'7cgray62'7cgrey62'7cgray63'7cgrey63'7cgray64'7cgrey64'7cgray65'7cgrey65'7cgray66'7cgrey66'7cgray67'7cgrey67'7cgray68'7cgrey68'7cgray69'7cgrey69'7cgray70'7cgrey70'7cgray71'7cgrey71'7cgray72'7cgrey72'7cgray73'7cgrey73'7cgray74'7cgrey74'7cgray75'7cgrey75'7cgray76'7cgrey76'7cgray77'7cgrey77'7cgray78'7cgrey78'7cgray79'7cgrey79'7cgray80'7cgrey80'7cgray81'7cgrey81'7cgray82'7cgrey82'7cgray83'7cgrey83'7cgray84'7cgrey84'7cgray85'7cgrey85'7cgray86'7cgrey86'7cgray87'7cgrey87'7cgray88'7cgrey88'7cgray89'7cgrey89'7cgray90'7cgrey90'7cgray91'7cgrey91'7cgray92'7cgrey92'7cgray93'7cgrey93'7cgray94'7cgrey94'7cgray95'7cgrey95'7cgray96'7cgrey96'7cgray97'7cgrey97'7cgray98'7cgrey98'7cgray99'7cgrey99'7cgray100'7cgrey100'7cdark_grey'7cDarkGrey'7cdark_gray'7cDarkGray'7cdark_blue'7cDarkBlue'7cdark_cyan'7cDarkCyan'7cdark_magenta'7cDarkMagenta'7cdark_red'7cDarkRed'7clight_green'7cLightGreen'29'27 = compileRegex "'((#[0-9a-fA-F]{3}){1,4}|snow|ghost white|GhostWhite|white smoke|WhiteSmoke|gainsboro|floral white|FloralWhite|old lace|OldLace|linen|antique white|AntiqueWhite|papaya whip|PapayaWhip|blanched almond|BlanchedAlmond|bisque|peach puff|PeachPuff|navajo white|NavajoWhite|moccasin|cornsilk|ivory|lemon chiffon|LemonChiffon|seashell|honeydew|mint cream|MintCream|azure|alice blue|AliceBlue|lavender|lavender blush|LavenderBlush|misty rose|MistyRose|white|black|dark slate gray|DarkSlateGray|dark slate grey|DarkSlateGrey|dim gray|DimGray|dim grey|DimGrey|slate gray|SlateGray|slate grey|SlateGrey|light slate gray|LightSlateGray|light slate grey|LightSlateGrey|gray|grey|light grey|LightGrey|light gray|LightGray|midnight blue|MidnightBlue|navy|navy blue|NavyBlue|cornflower blue|CornflowerBlue|dark slate blue|DarkSlateBlue|slate blue|SlateBlue|medium slate blue|MediumSlateBlue|light slate blue|LightSlateBlue|medium blue|MediumBlue|royal blue|RoyalBlue|blue|dodger blue|DodgerBlue|deep sky blue|DeepSkyBlue|sky blue|SkyBlue|light sky blue|LightSkyBlue|steel blue|SteelBlue|light steel blue|LightSteelBlue|light blue|LightBlue|powder blue|PowderBlue|pale turquoise|PaleTurquoise|dark turquoise|DarkTurquoise|medium turquoise|MediumTurquoise|turquoise|cyan|light cyan|LightCyan|cadet blue|CadetBlue|medium aquamarine|MediumAquamarine|aquamarine|dark green|DarkGreen|dark olive green|DarkOliveGreen|dark sea green|DarkSeaGreen|sea green|SeaGreen|medium sea green|MediumSeaGreen|light sea green|LightSeaGreen|pale green|PaleGreen|spring green|SpringGreen|lawn green|LawnGreen|green|chartreuse|medium spring green|MediumSpringGreen|green yellow|GreenYellow|lime green|LimeGreen|yellow green|YellowGreen|forest green|ForestGreen|olive drab|OliveDrab|dark khaki|DarkKhaki|khaki|pale goldenrod|PaleGoldenrod|light goldenrod yellow|LightGoldenrodYellow|light yellow|LightYellow|yellow|gold|light goldenrod|LightGoldenrod|goldenrod|dark goldenrod|DarkGoldenrod|rosy brown|RosyBrown|indian red|IndianRed|saddle brown|SaddleBrown|sienna|peru|burlywood|beige|wheat|sandy brown|SandyBrown|tan|chocolate|firebrick|brown|dark salmon|DarkSalmon|salmon|light salmon|LightSalmon|orange|dark orange|DarkOrange|coral|light coral|LightCoral|tomato|orange red|OrangeRed|red|hot pink|HotPink|deep pink|DeepPink|pink|light pink|LightPink|pale violet red|PaleVioletRed|maroon|medium violet red|MediumVioletRed|violet red|VioletRed|magenta|violet|plum|orchid|medium orchid|MediumOrchid|dark orchid|DarkOrchid|dark violet|DarkViolet|blue violet|BlueViolet|purple|medium purple|MediumPurple|thistle|snow1|snow2|snow3|snow4|seashell1|seashell2|seashell3|seashell4|AntiqueWhite1|AntiqueWhite2|AntiqueWhite3|AntiqueWhite4|bisque1|bisque2|bisque3|bisque4|PeachPuff1|PeachPuff2|PeachPuff3|PeachPuff4|NavajoWhite1|NavajoWhite2|NavajoWhite3|NavajoWhite4|LemonChiffon1|LemonChiffon2|LemonChiffon3|LemonChiffon4|cornsilk1|cornsilk2|cornsilk3|cornsilk4|ivory1|ivory2|ivory3|ivory4|honeydew1|honeydew2|honeydew3|honeydew4|LavenderBlush1|LavenderBlush2|LavenderBlush3|LavenderBlush4|MistyRose1|MistyRose2|MistyRose3|MistyRose4|azure1|azure2|azure3|azure4|SlateBlue1|SlateBlue2|SlateBlue3|SlateBlue4|RoyalBlue1|RoyalBlue2|RoyalBlue3|RoyalBlue4|blue1|blue2|blue3|blue4|DodgerBlue1|DodgerBlue2|DodgerBlue3|DodgerBlue4|SteelBlue1|SteelBlue2|SteelBlue3|SteelBlue4|DeepSkyBlue1|DeepSkyBlue2|DeepSkyBlue3|DeepSkyBlue4|SkyBlue1|SkyBlue2|SkyBlue3|SkyBlue4|LightSkyBlue1|LightSkyBlue2|LightSkyBlue3|LightSkyBlue4|SlateGray1|SlateGray2|SlateGray3|SlateGray4|LightSteelBlue1|LightSteelBlue2|LightSteelBlue3|LightSteelBlue4|LightBlue1|LightBlue2|LightBlue3|LightBlue4|LightCyan1|LightCyan2|LightCyan3|LightCyan4|PaleTurquoise1|PaleTurquoise2|PaleTurquoise3|PaleTurquoise4|CadetBlue1|CadetBlue2|CadetBlue3|CadetBlue4|turquoise1|turquoise2|turquoise3|turquoise4|cyan1|cyan2|cyan3|cyan4|DarkSlateGray1|DarkSlateGray2|DarkSlateGray3|DarkSlateGray4|aquamarine1|aquamarine2|aquamarine3|aquamarine4|DarkSeaGreen1|DarkSeaGreen2|DarkSeaGreen3|DarkSeaGreen4|SeaGreen1|SeaGreen2|SeaGreen3|SeaGreen4|PaleGreen1|PaleGreen2|PaleGreen3|PaleGreen4|SpringGreen1|SpringGreen2|SpringGreen3|SpringGreen4|green1|green2|green3|green4|chartreuse1|chartreuse2|chartreuse3|chartreuse4|OliveDrab1|OliveDrab2|OliveDrab3|OliveDrab4|DarkOliveGreen1|DarkOliveGreen2|DarkOliveGreen3|DarkOliveGreen4|khaki1|khaki2|khaki3|khaki4|LightGoldenrod1|LightGoldenrod2|LightGoldenrod3|LightGoldenrod4|LightYellow1|LightYellow2|LightYellow3|LightYellow4|yellow1|yellow2|yellow3|yellow4|gold1|gold2|gold3|gold4|goldenrod1|goldenrod2|goldenrod3|goldenrod4|DarkGoldenrod1|DarkGoldenrod2|DarkGoldenrod3|DarkGoldenrod4|RosyBrown1|RosyBrown2|RosyBrown3|RosyBrown4|IndianRed1|IndianRed2|IndianRed3|IndianRed4|sienna1|sienna2|sienna3|sienna4|burlywood1|burlywood2|burlywood3|burlywood4|wheat1|wheat2|wheat3|wheat4|tan1|tan2|tan3|tan4|chocolate1|chocolate2|chocolate3|chocolate4|firebrick1|firebrick2|firebrick3|firebrick4|brown1|brown2|brown3|brown4|salmon1|salmon2|salmon3|salmon4|LightSalmon1|LightSalmon2|LightSalmon3|LightSalmon4|orange1|orange2|orange3|orange4|DarkOrange1|DarkOrange2|DarkOrange3|DarkOrange4|coral1|coral2|coral3|coral4|tomato1|tomato2|tomato3|tomato4|OrangeRed1|OrangeRed2|OrangeRed3|OrangeRed4|red1|red2|red3|red4|DeepPink1|DeepPink2|DeepPink3|DeepPink4|HotPink1|HotPink2|HotPink3|HotPink4|pink1|pink2|pink3|pink4|LightPink1|LightPink2|LightPink3|LightPink4|PaleVioletRed1|PaleVioletRed2|PaleVioletRed3|PaleVioletRed4|maroon1|maroon2|maroon3|maroon4|VioletRed1|VioletRed2|VioletRed3|VioletRed4|magenta1|magenta2|magenta3|magenta4|orchid1|orchid2|orchid3|orchid4|plum1|plum2|plum3|plum4|MediumOrchid1|MediumOrchid2|MediumOrchid3|MediumOrchid4|DarkOrchid1|DarkOrchid2|DarkOrchid3|DarkOrchid4|purple1|purple2|purple3|purple4|MediumPurple1|MediumPurple2|MediumPurple3|MediumPurple4|thistle1|thistle2|thistle3|thistle4|gray0|grey0|gray1|grey1|gray2|grey2|gray3|grey3|gray4|grey4|gray5|grey5|gray6|grey6|gray7|grey7|gray8|grey8|gray9|grey9|gray10|grey10|gray11|grey11|gray12|grey12|gray13|grey13|gray14|grey14|gray15|grey15|gray16|grey16|gray17|grey17|gray18|grey18|gray19|grey19|gray20|grey20|gray21|grey21|gray22|grey22|gray23|grey23|gray24|grey24|gray25|grey25|gray26|grey26|gray27|grey27|gray28|grey28|gray29|grey29|gray30|grey30|gray31|grey31|gray32|grey32|gray33|grey33|gray34|grey34|gray35|grey35|gray36|grey36|gray37|grey37|gray38|grey38|gray39|grey39|gray40|grey40|gray41|grey41|gray42|grey42|gray43|grey43|gray44|grey44|gray45|grey45|gray46|grey46|gray47|grey47|gray48|grey48|gray49|grey49|gray50|grey50|gray51|grey51|gray52|grey52|gray53|grey53|gray54|grey54|gray55|grey55|gray56|grey56|gray57|grey57|gray58|grey58|gray59|grey59|gray60|grey60|gray61|grey61|gray62|grey62|gray63|grey63|gray64|grey64|gray65|grey65|gray66|grey66|gray67|grey67|gray68|grey68|gray69|grey69|gray70|grey70|gray71|grey71|gray72|grey72|gray73|grey73|gray74|grey74|gray75|grey75|gray76|grey76|gray77|grey77|gray78|grey78|gray79|grey79|gray80|grey80|gray81|grey81|gray82|grey82|gray83|grey83|gray84|grey84|gray85|grey85|gray86|grey86|gray87|grey87|gray88|grey88|gray89|grey89|gray90|grey90|gray91|grey91|gray92|grey92|gray93|grey93|gray94|grey94|gray95|grey95|gray96|grey96|gray97|grey97|gray98|grey98|gray99|grey99|gray100|grey100|dark grey|DarkGrey|dark gray|DarkGray|dark blue|DarkBlue|dark cyan|DarkCyan|dark magenta|DarkMagenta|dark red|DarkRed|light green|LightGreen)'"
regex_'27'28'2d'3f'29'5b0'2d9'5d'2a'27 = compileRegex "'(-?)[0-9]*'"
regex_'27'5b'5e'27'5d'2a'27 = compileRegex "'[^']*'"

defaultAttributes = [("Start","Normal Text"),("FindPango","Normal Text"),("FindAttributes","Normal Text"),("InGravity","String"),("InGravityHint","String"),("InStretch","String"),("InBoolean","String"),("InStyle","String"),("InUnderline","String"),("InVariant","String"),("InWeight","String"),("InColor","Color"),("InInt","Decimal"),("InString","String")]

parseRules "Start" = 
  do (attr, result) <- ((parseRules "FindPango"))
     return (attr, result)

parseRules "FindPango" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'3c'2f'28span'7cb'7cbig'7ci'7cs'7csub'7csup'7csmall'7ctt'7cu'29'3e >>= withAttribute "Element"))
                        <|>
                        ((pRegExpr regex_'3c'28span'7cb'7cbig'7ci'7cs'7csub'7csup'7csmall'7ctt'7cu'29 >>= withAttribute "Element") >>~ pushContext "FindAttributes")
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Normal Text")))
     return (attr, result)

parseRules "FindAttributes" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_gravity'3d >>= withAttribute "Key") >>~ pushContext "InGravity")
                        <|>
                        ((pRegExpr regex_gravity'5fhint'3d >>= withAttribute "Key") >>~ pushContext "InGravityHint")
                        <|>
                        ((pRegExpr regex_'28font'5f'29'3fstretch'3d >>= withAttribute "Key") >>~ pushContext "InStretch")
                        <|>
                        ((pRegExpr regex_'28strikethrough'7cfallback'29'3d >>= withAttribute "Key") >>~ pushContext "InBoolean")
                        <|>
                        ((pRegExpr regex_'28font'5f'29'3fstyle'3d >>= withAttribute "Key") >>~ pushContext "InStyle")
                        <|>
                        ((pRegExpr regex_underline'3d >>= withAttribute "Key") >>~ pushContext "InUnderline")
                        <|>
                        ((pRegExpr regex_'28font'5f'29'3fvariant'3d >>= withAttribute "Key") >>~ pushContext "InVariant")
                        <|>
                        ((pRegExpr regex_'28font'5f'29'3fweight'3d >>= withAttribute "Key") >>~ pushContext "InWeight")
                        <|>
                        ((pRegExpr regex_'28size'7cfont'5fsize'7crise'7cletter'5fspacing'29'3d >>= withAttribute "Key") >>~ pushContext "InInt")
                        <|>
                        ((pRegExpr regex_'28font'7cfont'5fdesc'7cfont'5ffamily'7cface'7clang'29'3d >>= withAttribute "Key") >>~ pushContext "InString")
                        <|>
                        ((pRegExpr regex_'28strikethrough'5fcolor'7cforeground'7cfgcolor'7ccolor'7cbackground'7cbgcolor'7cunderline'5fcolor'29'3d >>= withAttribute "Key") >>~ pushContext "InColor")
                        <|>
                        ((pDetectChar False '>' >>= withAttribute "Element") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error")))
     return (attr, result)

parseRules "InGravity" = 
  do (attr, result) <- (((pRegExpr regex_'27'28south'7ceast'7cnorth'7cwest'7cauto'29'27 >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "InGravityHint" = 
  do (attr, result) <- (((pRegExpr regex_'27'28natural'7cstrong'7cline'29'27 >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "InStretch" = 
  do (attr, result) <- (((pRegExpr regex_'27'28ultracondensed'7cextracondensed'7ccondensed'7csemicondensed'7cnormal'7csemiexpanded'7cexpanded'7cextraexpanded'7cultraexpanded'29'27 >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "InBoolean" = 
  do (attr, result) <- (((pRegExpr regex_'27'28false'7ctrue'29'27 >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "InStyle" = 
  do (attr, result) <- (((pRegExpr regex_'27'28normal'7coblique'7citalic'29'27 >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "InUnderline" = 
  do (attr, result) <- (((pRegExpr regex_'27'28none'7csingle'7cdouble'7clow'7cerror'29'27 >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "InVariant" = 
  do (attr, result) <- (((pRegExpr regex_'27'28normal'7csmallcaps'29'27 >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "InWeight" = 
  do (attr, result) <- (((pRegExpr regex_'27'5b0'2d9'5d'2a'27 >>= withAttribute "Decimal") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'27'28ultralight'7clight'7cnormal'7cbold'7cultrabold'7cheavy'29'27 >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "InColor" = 
  do (attr, result) <- (((pRegExpr regex_'27'28'28'23'5b0'2d9a'2dfA'2dF'5d'7b3'7d'29'7b1'2c4'7d'7csnow'7cghost_white'7cGhostWhite'7cwhite_smoke'7cWhiteSmoke'7cgainsboro'7cfloral_white'7cFloralWhite'7cold_lace'7cOldLace'7clinen'7cantique_white'7cAntiqueWhite'7cpapaya_whip'7cPapayaWhip'7cblanched_almond'7cBlanchedAlmond'7cbisque'7cpeach_puff'7cPeachPuff'7cnavajo_white'7cNavajoWhite'7cmoccasin'7ccornsilk'7civory'7clemon_chiffon'7cLemonChiffon'7cseashell'7choneydew'7cmint_cream'7cMintCream'7cazure'7calice_blue'7cAliceBlue'7clavender'7clavender_blush'7cLavenderBlush'7cmisty_rose'7cMistyRose'7cwhite'7cblack'7cdark_slate_gray'7cDarkSlateGray'7cdark_slate_grey'7cDarkSlateGrey'7cdim_gray'7cDimGray'7cdim_grey'7cDimGrey'7cslate_gray'7cSlateGray'7cslate_grey'7cSlateGrey'7clight_slate_gray'7cLightSlateGray'7clight_slate_grey'7cLightSlateGrey'7cgray'7cgrey'7clight_grey'7cLightGrey'7clight_gray'7cLightGray'7cmidnight_blue'7cMidnightBlue'7cnavy'7cnavy_blue'7cNavyBlue'7ccornflower_blue'7cCornflowerBlue'7cdark_slate_blue'7cDarkSlateBlue'7cslate_blue'7cSlateBlue'7cmedium_slate_blue'7cMediumSlateBlue'7clight_slate_blue'7cLightSlateBlue'7cmedium_blue'7cMediumBlue'7croyal_blue'7cRoyalBlue'7cblue'7cdodger_blue'7cDodgerBlue'7cdeep_sky_blue'7cDeepSkyBlue'7csky_blue'7cSkyBlue'7clight_sky_blue'7cLightSkyBlue'7csteel_blue'7cSteelBlue'7clight_steel_blue'7cLightSteelBlue'7clight_blue'7cLightBlue'7cpowder_blue'7cPowderBlue'7cpale_turquoise'7cPaleTurquoise'7cdark_turquoise'7cDarkTurquoise'7cmedium_turquoise'7cMediumTurquoise'7cturquoise'7ccyan'7clight_cyan'7cLightCyan'7ccadet_blue'7cCadetBlue'7cmedium_aquamarine'7cMediumAquamarine'7caquamarine'7cdark_green'7cDarkGreen'7cdark_olive_green'7cDarkOliveGreen'7cdark_sea_green'7cDarkSeaGreen'7csea_green'7cSeaGreen'7cmedium_sea_green'7cMediumSeaGreen'7clight_sea_green'7cLightSeaGreen'7cpale_green'7cPaleGreen'7cspring_green'7cSpringGreen'7clawn_green'7cLawnGreen'7cgreen'7cchartreuse'7cmedium_spring_green'7cMediumSpringGreen'7cgreen_yellow'7cGreenYellow'7clime_green'7cLimeGreen'7cyellow_green'7cYellowGreen'7cforest_green'7cForestGreen'7colive_drab'7cOliveDrab'7cdark_khaki'7cDarkKhaki'7ckhaki'7cpale_goldenrod'7cPaleGoldenrod'7clight_goldenrod_yellow'7cLightGoldenrodYellow'7clight_yellow'7cLightYellow'7cyellow'7cgold'7clight_goldenrod'7cLightGoldenrod'7cgoldenrod'7cdark_goldenrod'7cDarkGoldenrod'7crosy_brown'7cRosyBrown'7cindian_red'7cIndianRed'7csaddle_brown'7cSaddleBrown'7csienna'7cperu'7cburlywood'7cbeige'7cwheat'7csandy_brown'7cSandyBrown'7ctan'7cchocolate'7cfirebrick'7cbrown'7cdark_salmon'7cDarkSalmon'7csalmon'7clight_salmon'7cLightSalmon'7corange'7cdark_orange'7cDarkOrange'7ccoral'7clight_coral'7cLightCoral'7ctomato'7corange_red'7cOrangeRed'7cred'7chot_pink'7cHotPink'7cdeep_pink'7cDeepPink'7cpink'7clight_pink'7cLightPink'7cpale_violet_red'7cPaleVioletRed'7cmaroon'7cmedium_violet_red'7cMediumVioletRed'7cviolet_red'7cVioletRed'7cmagenta'7cviolet'7cplum'7corchid'7cmedium_orchid'7cMediumOrchid'7cdark_orchid'7cDarkOrchid'7cdark_violet'7cDarkViolet'7cblue_violet'7cBlueViolet'7cpurple'7cmedium_purple'7cMediumPurple'7cthistle'7csnow1'7csnow2'7csnow3'7csnow4'7cseashell1'7cseashell2'7cseashell3'7cseashell4'7cAntiqueWhite1'7cAntiqueWhite2'7cAntiqueWhite3'7cAntiqueWhite4'7cbisque1'7cbisque2'7cbisque3'7cbisque4'7cPeachPuff1'7cPeachPuff2'7cPeachPuff3'7cPeachPuff4'7cNavajoWhite1'7cNavajoWhite2'7cNavajoWhite3'7cNavajoWhite4'7cLemonChiffon1'7cLemonChiffon2'7cLemonChiffon3'7cLemonChiffon4'7ccornsilk1'7ccornsilk2'7ccornsilk3'7ccornsilk4'7civory1'7civory2'7civory3'7civory4'7choneydew1'7choneydew2'7choneydew3'7choneydew4'7cLavenderBlush1'7cLavenderBlush2'7cLavenderBlush3'7cLavenderBlush4'7cMistyRose1'7cMistyRose2'7cMistyRose3'7cMistyRose4'7cazure1'7cazure2'7cazure3'7cazure4'7cSlateBlue1'7cSlateBlue2'7cSlateBlue3'7cSlateBlue4'7cRoyalBlue1'7cRoyalBlue2'7cRoyalBlue3'7cRoyalBlue4'7cblue1'7cblue2'7cblue3'7cblue4'7cDodgerBlue1'7cDodgerBlue2'7cDodgerBlue3'7cDodgerBlue4'7cSteelBlue1'7cSteelBlue2'7cSteelBlue3'7cSteelBlue4'7cDeepSkyBlue1'7cDeepSkyBlue2'7cDeepSkyBlue3'7cDeepSkyBlue4'7cSkyBlue1'7cSkyBlue2'7cSkyBlue3'7cSkyBlue4'7cLightSkyBlue1'7cLightSkyBlue2'7cLightSkyBlue3'7cLightSkyBlue4'7cSlateGray1'7cSlateGray2'7cSlateGray3'7cSlateGray4'7cLightSteelBlue1'7cLightSteelBlue2'7cLightSteelBlue3'7cLightSteelBlue4'7cLightBlue1'7cLightBlue2'7cLightBlue3'7cLightBlue4'7cLightCyan1'7cLightCyan2'7cLightCyan3'7cLightCyan4'7cPaleTurquoise1'7cPaleTurquoise2'7cPaleTurquoise3'7cPaleTurquoise4'7cCadetBlue1'7cCadetBlue2'7cCadetBlue3'7cCadetBlue4'7cturquoise1'7cturquoise2'7cturquoise3'7cturquoise4'7ccyan1'7ccyan2'7ccyan3'7ccyan4'7cDarkSlateGray1'7cDarkSlateGray2'7cDarkSlateGray3'7cDarkSlateGray4'7caquamarine1'7caquamarine2'7caquamarine3'7caquamarine4'7cDarkSeaGreen1'7cDarkSeaGreen2'7cDarkSeaGreen3'7cDarkSeaGreen4'7cSeaGreen1'7cSeaGreen2'7cSeaGreen3'7cSeaGreen4'7cPaleGreen1'7cPaleGreen2'7cPaleGreen3'7cPaleGreen4'7cSpringGreen1'7cSpringGreen2'7cSpringGreen3'7cSpringGreen4'7cgreen1'7cgreen2'7cgreen3'7cgreen4'7cchartreuse1'7cchartreuse2'7cchartreuse3'7cchartreuse4'7cOliveDrab1'7cOliveDrab2'7cOliveDrab3'7cOliveDrab4'7cDarkOliveGreen1'7cDarkOliveGreen2'7cDarkOliveGreen3'7cDarkOliveGreen4'7ckhaki1'7ckhaki2'7ckhaki3'7ckhaki4'7cLightGoldenrod1'7cLightGoldenrod2'7cLightGoldenrod3'7cLightGoldenrod4'7cLightYellow1'7cLightYellow2'7cLightYellow3'7cLightYellow4'7cyellow1'7cyellow2'7cyellow3'7cyellow4'7cgold1'7cgold2'7cgold3'7cgold4'7cgoldenrod1'7cgoldenrod2'7cgoldenrod3'7cgoldenrod4'7cDarkGoldenrod1'7cDarkGoldenrod2'7cDarkGoldenrod3'7cDarkGoldenrod4'7cRosyBrown1'7cRosyBrown2'7cRosyBrown3'7cRosyBrown4'7cIndianRed1'7cIndianRed2'7cIndianRed3'7cIndianRed4'7csienna1'7csienna2'7csienna3'7csienna4'7cburlywood1'7cburlywood2'7cburlywood3'7cburlywood4'7cwheat1'7cwheat2'7cwheat3'7cwheat4'7ctan1'7ctan2'7ctan3'7ctan4'7cchocolate1'7cchocolate2'7cchocolate3'7cchocolate4'7cfirebrick1'7cfirebrick2'7cfirebrick3'7cfirebrick4'7cbrown1'7cbrown2'7cbrown3'7cbrown4'7csalmon1'7csalmon2'7csalmon3'7csalmon4'7cLightSalmon1'7cLightSalmon2'7cLightSalmon3'7cLightSalmon4'7corange1'7corange2'7corange3'7corange4'7cDarkOrange1'7cDarkOrange2'7cDarkOrange3'7cDarkOrange4'7ccoral1'7ccoral2'7ccoral3'7ccoral4'7ctomato1'7ctomato2'7ctomato3'7ctomato4'7cOrangeRed1'7cOrangeRed2'7cOrangeRed3'7cOrangeRed4'7cred1'7cred2'7cred3'7cred4'7cDeepPink1'7cDeepPink2'7cDeepPink3'7cDeepPink4'7cHotPink1'7cHotPink2'7cHotPink3'7cHotPink4'7cpink1'7cpink2'7cpink3'7cpink4'7cLightPink1'7cLightPink2'7cLightPink3'7cLightPink4'7cPaleVioletRed1'7cPaleVioletRed2'7cPaleVioletRed3'7cPaleVioletRed4'7cmaroon1'7cmaroon2'7cmaroon3'7cmaroon4'7cVioletRed1'7cVioletRed2'7cVioletRed3'7cVioletRed4'7cmagenta1'7cmagenta2'7cmagenta3'7cmagenta4'7corchid1'7corchid2'7corchid3'7corchid4'7cplum1'7cplum2'7cplum3'7cplum4'7cMediumOrchid1'7cMediumOrchid2'7cMediumOrchid3'7cMediumOrchid4'7cDarkOrchid1'7cDarkOrchid2'7cDarkOrchid3'7cDarkOrchid4'7cpurple1'7cpurple2'7cpurple3'7cpurple4'7cMediumPurple1'7cMediumPurple2'7cMediumPurple3'7cMediumPurple4'7cthistle1'7cthistle2'7cthistle3'7cthistle4'7cgray0'7cgrey0'7cgray1'7cgrey1'7cgray2'7cgrey2'7cgray3'7cgrey3'7cgray4'7cgrey4'7cgray5'7cgrey5'7cgray6'7cgrey6'7cgray7'7cgrey7'7cgray8'7cgrey8'7cgray9'7cgrey9'7cgray10'7cgrey10'7cgray11'7cgrey11'7cgray12'7cgrey12'7cgray13'7cgrey13'7cgray14'7cgrey14'7cgray15'7cgrey15'7cgray16'7cgrey16'7cgray17'7cgrey17'7cgray18'7cgrey18'7cgray19'7cgrey19'7cgray20'7cgrey20'7cgray21'7cgrey21'7cgray22'7cgrey22'7cgray23'7cgrey23'7cgray24'7cgrey24'7cgray25'7cgrey25'7cgray26'7cgrey26'7cgray27'7cgrey27'7cgray28'7cgrey28'7cgray29'7cgrey29'7cgray30'7cgrey30'7cgray31'7cgrey31'7cgray32'7cgrey32'7cgray33'7cgrey33'7cgray34'7cgrey34'7cgray35'7cgrey35'7cgray36'7cgrey36'7cgray37'7cgrey37'7cgray38'7cgrey38'7cgray39'7cgrey39'7cgray40'7cgrey40'7cgray41'7cgrey41'7cgray42'7cgrey42'7cgray43'7cgrey43'7cgray44'7cgrey44'7cgray45'7cgrey45'7cgray46'7cgrey46'7cgray47'7cgrey47'7cgray48'7cgrey48'7cgray49'7cgrey49'7cgray50'7cgrey50'7cgray51'7cgrey51'7cgray52'7cgrey52'7cgray53'7cgrey53'7cgray54'7cgrey54'7cgray55'7cgrey55'7cgray56'7cgrey56'7cgray57'7cgrey57'7cgray58'7cgrey58'7cgray59'7cgrey59'7cgray60'7cgrey60'7cgray61'7cgrey61'7cgray62'7cgrey62'7cgray63'7cgrey63'7cgray64'7cgrey64'7cgray65'7cgrey65'7cgray66'7cgrey66'7cgray67'7cgrey67'7cgray68'7cgrey68'7cgray69'7cgrey69'7cgray70'7cgrey70'7cgray71'7cgrey71'7cgray72'7cgrey72'7cgray73'7cgrey73'7cgray74'7cgrey74'7cgray75'7cgrey75'7cgray76'7cgrey76'7cgray77'7cgrey77'7cgray78'7cgrey78'7cgray79'7cgrey79'7cgray80'7cgrey80'7cgray81'7cgrey81'7cgray82'7cgrey82'7cgray83'7cgrey83'7cgray84'7cgrey84'7cgray85'7cgrey85'7cgray86'7cgrey86'7cgray87'7cgrey87'7cgray88'7cgrey88'7cgray89'7cgrey89'7cgray90'7cgrey90'7cgray91'7cgrey91'7cgray92'7cgrey92'7cgray93'7cgrey93'7cgray94'7cgrey94'7cgray95'7cgrey95'7cgray96'7cgrey96'7cgray97'7cgrey97'7cgray98'7cgrey98'7cgray99'7cgrey99'7cgray100'7cgrey100'7cdark_grey'7cDarkGrey'7cdark_gray'7cDarkGray'7cdark_blue'7cDarkBlue'7cdark_cyan'7cDarkCyan'7cdark_magenta'7cDarkMagenta'7cdark_red'7cDarkRed'7clight_green'7cLightGreen'29'27 >>= withAttribute "Color") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "InInt" = 
  do (attr, result) <- (((pRegExpr regex_'27'28'2d'3f'29'5b0'2d9'5d'2a'27 >>= withAttribute "Decimal") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "InString" = 
  do (attr, result) <- (((pRegExpr regex_'27'5b'5e'27'5d'2a'27 >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
