{- This module was generated from data in the Kate syntax highlighting file ini.xml, version 1.1,
   by  Jan Janssen (medhefgo@web.de) -}

module Text.Highlighting.Kate.Syntax.Ini ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "INI Files"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.ini;*.pls;*.kcfgc"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "INI Files" }
  context <- currentContext <|> (pushContext "ini" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("INI Files",["ini"])], synStLanguage = "INI Files", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "ini" -> return () >> pHandleEndLine
    "Value" -> (popContext) >> pEndLine
    "Comment" -> (popContext) >> pEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Normal Text","dt"),("Section","kw"),("Comment","co"),("Assignment","ot"),("Value","st"),("Float","fl"),("Int","dv"),("Keyword","kw")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "on off default defaults localhost null true false yes no normal e_all e_error e_warning e_parse e_notice e_strict e_core_error e_core_warning e_compile_error e_compile_warning e_user_error e_user_warning e_user_notice"

regex_'3b'2e'2a'24 = compileRegex ";.*$"
regex_'23'2e'2a'24 = compileRegex "#.*$"

defaultAttributes = [("ini","Normal Text"),("Value","Value"),("Comment","Comment")]

parseRules "ini" = 
  do (attr, result) <- (((pRangeDetect '[' ']' >>= withAttribute "Section") >>~ (popContext))
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Assignment") >>~ pushContext "Value")
                        <|>
                        ((pFirstNonSpace >> pDetectChar False ';' >>= withAttribute "Comment") >>~ pushContext "Comment")
                        <|>
                        ((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "Comment"))
     return (attr, result)

parseRules "Value" = 
  do (attr, result) <- (((pFloat >>= withAttribute "Float"))
                        <|>
                        ((pInt >>= withAttribute "Int"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'3b'2e'2a'24 >>= withAttribute "Comment") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'23'2e'2a'24 >>= withAttribute "Comment") >>~ (popContext)))
     return (attr, result)

parseRules "Comment" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
