// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Different utility functions
// ****************************************************************************

// Copyright 2008, 2009, 2010, 2011 Guy Voncken
//
// This file is part of guymager.
//
// guymager is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// guymager is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with guymager. If not, see <http://www.gnu.org/licenses/>.

#include "common.h"

#include <QtGui>

#include "config.h"
#include "util.h"

// ----------------
//   Global vars
// ----------------

#define UTIL_ZEROBLOCK_MAXSIZE 65536

char         *pUtilZeroBlock     = NULL;
unsigned int   UtilZeroBlockSize = 0;

// ----------------
//     Functions
// ----------------

void *UtilMemAlloc (size_t Size, const char */*pFile*/, int /*Line*/)
{
   return malloc(Size);
}

void UtilMemFree (void *pMem, const char */*pFile*/, int /*Line*/)
{
   free (pMem);
}

int UtilCalcDecimals (t_uint64 Value)
{
   QString Str;

   Str.setNum (Value);
   return Str.length();
}

bool UtilIsZeroOld (unsigned char *pData, unsigned int DataLen)
{
   long long          *pBuff    = (long long *)pData;   //lint !e826   Suspicious pointer-to-pointer conversion
   const unsigned int   CmpSize = sizeof (long long);   // 64 bit operations for optimal performance on amd64 processors

   while (DataLen >= CmpSize)
   {
      if (*pBuff++)
        return false;
      DataLen -= CmpSize;
   }

   pData = (unsigned char *) pBuff;
   while (DataLen--)
   {
      if (*pData++)
         return false;
   }

   return true;
}

bool UtilIsZero (unsigned char *pData, unsigned int DataLen)
{
   unsigned int ToCompare;
   unsigned int Remaining = DataLen;
   bool         IsZero    = true;
   
   while (Remaining)
   { 
      ToCompare = GETMIN(Remaining, UtilZeroBlockSize);
      IsZero = (memcmp (pData, pUtilZeroBlock, ToCompare) == 0);
      if (!IsZero)
         break;
      Remaining -= ToCompare;
   }
   return IsZero;
}

unsigned int UtilGetMaxZcompressedBufferSize (unsigned int UncompressedBufferSize)
{
   return (UncompressedBufferSize * 1.001) + 12;
}


APIRET UtilInit (void)
{   
   int MaxFifoBockSize;
   
   MaxFifoBockSize = GETMAX(CONFIG(FifoBlockSizeEWF), CONFIG(FifoBlockSizeAFF));
   
   UtilZeroBlockSize = GETMIN(UTIL_ZEROBLOCK_MAXSIZE, MaxFifoBockSize);

   pUtilZeroBlock = (char *) malloc (UtilZeroBlockSize);
   memset(pUtilZeroBlock, 0, UtilZeroBlockSize);
   
   return NO_ERROR;
}

APIRET UtilDeInit (void)
{
   free (pUtilZeroBlock);
   return NO_ERROR;
}
