// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Everything related to file names, extension names, paths,
//                  etc
// ****************************************************************************


#ifndef __FILE_H__
#define __FILE_H__

#include <QtGui> //lint !e537 Repeated include

#ifndef __COMMON_H__
   #include "common.h"
#endif

namespace t_File
{
   typedef enum
   {
      NotSet,
      DD,
      EWF,
      AFF
   } Format, t_Format;

   extern const char *pExtensionInfo;


   APIRET GetFormatDescription (t_Format F, QString &Str);
   APIRET GetFormatExtension   (t_Format F, QString *pExtWildcards, QString *pExtHumanReadable=NULL);
   APIRET Init                 (void);
}


// ------------------------------------
//             Error codes
// ------------------------------------

   #ifdef __MODULES_H__
      enum
      {
         ERROR_FILE_ONLY_CAN_BE_INSTANTIATED_ONCE = ERROR_BASE_FILE + 1,
         ERROR_FILE_INVALID_FORMAT,
         ERROR_FILE_INVALID_EWF_FORMAT
      };
   #endif

#endif


