# Gufw 9.10.2 - http://gufw.tuxfamily.org
# Copyright (C) 2009 Marcos Alvarez Costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information. 


import locale
import gettext
import sys
import gtk


class Variable:

    def __init__(self):

        # Run in develoment mode? (--dev parameter)
        self.dev = False
        for parameter in sys.argv:
            if parameter == "--dev":
                self.dev = True

        if self.dev:
            DIR = sys.path[0] + "/locale-langpack"
        else:
            DIR = "/usr/share/locale-langpack"
        _ = gettext.gettext
        gettext.bindtextdomain("gufw", DIR)
        gettext.textdomain("gufw")
        gtk.glade.bindtextdomain("gufw", DIR)
        gtk.glade.textdomain("gufw")

            
        # Define Texts
        self.texts = { "001" : _("To"),
                       "002" : _("Action"),
                       "003" : _("From"),
                       "004" : _("Gufw Log Enabled"),
                       "005" : _("Gufw Log Disabled"),
                       "006" : _("Deny all INCOMING traffic"),
                       "007" : _("Allow all INCOMING traffic"),
                       "008" : _("Enabled Firewall"),
                       "009" : _("Disabled Firewall"),
                       "010" : _("Select rule(s)"),
                       "011" : _("Reject all INCOMING traffic"),
                       "012" : _("Error performing operation"),
                       "013" : _("Rule added"),
                       "014" : _("Rule removed"),
                       "015" : _("Error: Insert a port number"),
                       "016" : _("Error: Fields filled out incorrectly"),
                       "017" : _("Error: Range ports only with tcp or udp protocol"),
                       "018" : _("You must run Gufw as root => gksu gufw"),
                       "019" : _("Rules removed"),
                       "020" : _("Rules added") }
        
        # Define constants
        self.constants = {"disabled"            : "disabled",
                          "enabled"             : "enabled",
                          "none"                : "none",
                          "deny"                : "deny",
                          "deny_upper"          : "DENY",
                          "allow"               : "allow",
                          "allow_upper"         : "ALLOW",
                          "limit"               : "limit",
                          "limit_upper"         : "LIMIT",
                          "reject"              : "reject",
                          "reject_upper"        : "REJECT",
                          "tcp"                 : "tcp",
                          "udp"                 : "udp",
                          "both"                : "both",
                          "ufw_log_low"         : "ufw_log_low",
                          "ufw_log_medium"      : "ufw_log_medium",
                          "ufw_log_high"        : "ufw_log_high",
                          "ufw_log_off"         : "ufw_log_off",
                          "ufw_log_on"          : "ufw_log_on",
                          "gufw_log_on"         : "gufw_log_on",
                          "gufw_log_off"        : "gufw_log_off",
                          "wrap_on"             : "wrap_on",
                          "wrap_off"            : "wrap_off",
                          "service_enabled"     : "service_enabled",
                          "service_disabled"    : "service_disabled",
                          "font_rules"          : "monospace 10",
                          "color_gray"          : "#b0b0b0",
                          "color_green"         : "#28ab2b",
                          "color_red"           : "#e31818",
                          "color_orange"        : "#e57f1b",
                          "color_blue"          : "#19308b",
                          "window_width"        : 327,
                          "window_height"       : 366,
                          "translators_credits" : _("translator-credits"),
                          "rule_added"          : "Rule added",
                          "rule_updated"        : "Rule updated",
                          "rule_deleted"        : "Rule deleted",
                          "any"                 : "any",
                          "anywhere"            : "Anywhere",
                          "service_yes"         : "yes",
                          "service_no"          : "service_no" }
        
        # Define paths
        self.paths = { "glade"               : sys.path[0] + "/glade/gufw.glade",
                       "pid_file"            : "/tmp/gufw.pid",
        
                       "shield_disabled_dev" : sys.path[0] + "/pixmaps/disable.png",
                       "shield_allow_dev"    : sys.path[0] + "/pixmaps/allow_all.png",
                       "shield_deny_dev"     : sys.path[0] + "/pixmaps/deny_all.png",
                       "shield_reject_dev"   : sys.path[0] + "/pixmaps/reject_all.png",
                       
                       "shield_disabled"     : "/usr/share/pixmaps/gufw/disable.png",
                       "shield_allow"        : "/usr/share/pixmaps/gufw/allow_all.png",
                       "shield_deny"         : "/usr/share/pixmaps/gufw/deny_all.png",
                       "shield_reject"       : "/usr/share/pixmaps/gufw/reject_all.png" }                           
                                    
        # Define Commands
        self.commands = { "enabled"              : "LANG=en ufw enable",
                          "disabled"             : "LANG=en ufw disable",
                          "status"               : "LANG=en ufw status",
                          "status_verbose"       : "LANG=en ufw status verbose",
                          "deny"                 : "LANG=en ufw default deny",
                          "allow"                : "LANG=en ufw default allow",
                          "reject"               : "LANG=en ufw default reject",
                          "search_policy"        : "LANG=en grep DEFAULT_INPUT_POLICY /etc/default/ufw",
                          "ufw_log_off"          : "LANG=en ufw logging off",
                          "ufw_log_on"           : "LANG=en ufw logging on",
                          "ufw_log_low"          : "LANG=en ufw logging low",
                          "ufw_log_medium"       : "LANG=en ufw logging medium",
                          "ufw_log_high"         : "LANG=en ufw logging high",
                          
                          "refresh_log_file"     : "LANG=en rm /var/log/gufw_log.txt | echo "" > /var/log/gufw_log.txt" ,
                          "append_log_file"      : "LANG=en echo '&' >> /var/log/gufw_log.txt",
                          "get_log_file"         : "LANG=en cat /var/log/gufw_log.txt",
                          "cfg_gufw_log"         : "LANG=en grep log=enabled /etc/gufw/gufw.cfg",
                          "gufw_log_on"          : "LANG=en sed -i 's/^log=disabled/log=enabled/' /etc/gufw/gufw.cfg",
                          "gufw_log_off"         : "LANG=en sed -i 's/^log=enabled/log=disabled/' /etc/gufw/gufw.cfg",
                          "read_size_win"        : "LANG=en cat /etc/gufw/size_window.cfg",
                          "save_size_win"        : 'LANG=en rm /etc/gufw/size_window.cfg | echo "width=&1;height=&2" > /etc/gufw/size_window.cfg',
                          
                          "refresh_log_file_dev" : "LANG=en rm cfg_files/gufw_log.txt | echo "" > cfg_files/gufw_log.txt" ,
                          "append_log_file_dev"  : "LANG=en echo '&' >> cfg_files/gufw_log.txt",
                          "get_log_file_dev"     : "LANG=en cat cfg_files/gufw_log.txt",
                          "cfg_gufw_log_dev"     : "LANG=en grep log=enabled cfg_files/gufw.cfg",
                          "gufw_log_on_dev"      : "LANG=en sed -i 's/^log=disabled/log=enabled/' cfg_files/gufw.cfg",
                          "gufw_log_off_dev"     : "LANG=en sed -i 's/^log=enabled/log=disabled/' cfg_files/gufw.cfg",
                          "read_size_win_dev"    : "LANG=en cat cfg_files/size_window.cfg",
                          "save_size_win_dev"    : 'LANG=en rm cfg_files/size_window.cfg | echo "width=&1;height=&2" > cfg_files/size_window.cfg' }
                          
        # Define Programs (Split by #)
        self.programs = { "Amule"        : "4662tcp#4672udp",
                          "Deluge"       : "6881tcp#6882tcp#6883tcp#6884tcp#6885tcp#6886tcp#6887tcp#6888tcp#6889tcp",
                          "Nicotine"     : "2234tcp#2235tcp#2236tcp#2237tcp#2238tcp#2239tcp#2240tcp",
                          "Transmission" : "51413tcp",
                          "Vuze"         : "28606tcp" }

        # Define Services (Split by #)
        self.services = { "ftp"    : "ftp",
                          "imap"   : "imap",
                          "ipp"    : "ipp",
                          "nfs"    : "nfs",
                          "pop3"   : "pop3",
                          "smtp"   : "smtp",
                          "ssh"    : "ssh",
                          "telnet" : "telnet",
                          "vnc"    : "5900tcp" }
                          
    # Return a constant
    def get_constant(self, name):
       return self.constants[name]
       
       
    # Return a Path
    def get_path(self, path):
        return self.paths[path]

    # Return a Text
    def get_text(self, txt_number):
        return self.texts[txt_number]


    # Return a Command
    def get_command(self, cmd):
        return self.commands[cmd]
        
        
    # Return a Program
    def get_program(self, prg):
        return self.programs[prg]

    # Return a Service
    def get_service(self, srv):
        return self.services[srv]
        
