# Gufw 9.10.2 - http://gufw.tuxfamily.org
# Copyright (C) 2009 Marcos Alvarez Costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.


import commands
from Variable import Variable


class Frontend:

    def __init__(self):
        self.variable = Variable()

       
    # Return status ufw
    def set_status(self, status):
        commands.getstatusoutput(self.variable.get_command(status))
        return status


    # Get status ufw
    def get_status(self):
        status = commands.getstatusoutput(self.variable.get_command("status"))
        if status[1].find("Status: active") != -1:
            return self.variable.get_constant("enabled")
        else:
            return self.variable.get_constant("disabled")


    # Return status ufw
    def set_default(self, default):
        commands.getstatusoutput(self.variable.get_command(default))
        return default


    # Get status ufw
    def get_default(self):
        default = commands.getstatusoutput(self.variable.get_command("search_policy"))
        if default[1].find("ACCEPT") != -1:
            return self.variable.get_constant("allow")
        elif default[1].find("DROP") != -1:
            return self.variable.get_constant("deny")
        elif default[1].find("REJECT") != -1:
            return self.variable.get_constant("reject")


    # Get actual rules (NOT SPLIT BY ACTION)
    def get_rules(self):
        rules        = commands.getstatusoutput(self.variable.get_command("status"))
        rule_lines   = rules[1].split("\n")
        return_rules = []
        
        for descomponent_rules in rule_lines:
            
            if descomponent_rules.find(self.variable.get_constant("allow_upper"))  != -1 or \
               descomponent_rules.find(self.variable.get_constant("deny_upper"))   != -1 or \
               descomponent_rules.find(self.variable.get_constant("limit_upper"))  != -1 or \
               descomponent_rules.find(self.variable.get_constant("reject_upper")) != -1:
                
                return_rules.append(descomponent_rules)
                
        return return_rules


    # Return status ufw
    def set_ufw_log(self, status_ufw_log):
        commands.getstatusoutput(self.variable.get_command(status_ufw_log))
        return status_ufw_log


    # Get status ufw
    def get_ufw_log(self):
        status = commands.getstatusoutput(self.variable.get_command("status_verbose"))
        if status[1].find("Logging: on (high)") != -1:
            return self.variable.get_constant("ufw_log_high")
        elif status[1].find("Logging: on (medium)") != -1:
            return self.variable.get_constant("ufw_log_medium")
        elif status[1].find("Logging: on (low)") != -1:
            return self.variable.get_constant("ufw_log_low")
        else:
            return self.variable.get_constant("ufw_log_off")


    # Return status ufw
    def set_gufw_log(self, status_gufw_log):
        if not self.variable.dev:
            status_gufw_log_aux = status_gufw_log
        else:
            status_gufw_log_aux = status_gufw_log + "_dev"
            
        commands.getstatusoutput(self.variable.get_command(status_gufw_log_aux))
        return status_gufw_log


    # Get status ufw
    def get_gufw_log(self):
        if not self.variable.dev:
            command = commands.getstatusoutput(self.variable.get_command("cfg_gufw_log"))
        else:
            command = commands.getstatusoutput(self.variable.get_command("cfg_gufw_log_dev"))
            
        if command[0] == 0:
            return self.variable.get_constant("gufw_log_on")
        else:
            return self.variable.get_constant("gufw_log_off")


    # Add rule 
    def add_rule_component(self, service, action, protocol, fromip, fromport, toip, toport):
        # Component rule
        if service == self.variable.get_constant("service_no"):
            rule = "LANG=en ufw &action proto &protocol from &fromIP port &fromPort to &toIP port &toPort"
        else:
            rule = "LANG=en ufw &action &toPort"
        
        # Action
        rule = rule.replace("&action", action)
        
        # Protocol
        if protocol != self.variable.get_constant("both"):
            rule = rule.replace("&protocol", protocol)
        else:
            rule = rule.replace(" proto &protocol ", " ")
            
        # FROM
        if fromip != "":
            rule = rule.replace("&fromIP", fromip)
        else:
            rule = rule.replace("&fromIP", self.variable.get_constant("any"))
            
        if fromport != "":
            rule = rule.replace("&fromPort", fromport)
        else:
            rule = rule.replace(" port &fromPort ", " ")
            
        # TO
        if toip != "":
            rule = rule.replace("&toIP", toip)
        else:
            rule = rule.replace("&toIP", self.variable.get_constant("any"))
            
        if toport != "":
            rule = rule.replace("&toPort", toport)
        else:
            rule = rule.replace(" port &toPort", "")

        # Return rule command
        return rule


    # Command Add rule
    def add_rule(self, rule):
        result = commands.getstatusoutput(rule)
        return result[1]


    # Add rule 
    def remove_rule_component(self, rule_to, action, rule_from):
        # Component rule
        protocol = ""
        toip     = ""
        toport   = ""
        fromip   = "" 
        fromport = ""
        rule   = "LANG=en ufw delete &action proto &protocol from &fromIP port &fromPort to &toIP port &toPort"
        
        # Set protocol
        if rule_to.find("/tcp")   != -1 or rule_from.find("/tcp") != -1:
            protocol = self.variable.get_constant("tcp")
            rule_to   = rule_to.replace("/tcp","")
            rule_from = rule_from.replace("/tcp","")
        elif rule_to.find("/udp")   != -1 or rule_from.find("/udp") != -1:
            protocol = self.variable.get_constant("udp")
            rule_to   = rule_to.replace("/udp","")
            rule_from = rule_from.replace("/udp","")
        else:
            protocol = self.variable.get_constant("both")

        
        # Set IP/Port TO
        to_aux = rule_to.split(" ")
        if len(to_aux) == 1:
            # IP or Port?
            if to_aux[0] == self.variable.get_constant("anywhere"):
                toip = ""
            elif ( to_aux[0].find(".") != -1 ) or ( len(to_aux[0]) > 11 ):
                toip = to_aux[0]
            else:
                toport = to_aux[0]
        elif len(to_aux) == 2:
            toip   = to_aux[0]
            toport = to_aux[1]
        elif len(to_aux) == 3:
            # It's a app command
            rule = "LANG=en ufw delete " + to_aux[2]
            return rule
            
        # Set IP/Port FROM
        from_aux = rule_from.split(" ")
        if len(from_aux) == 1:
            # IP or Port?
            if from_aux[0] == self.variable.get_constant("anywhere"):
                fromip = ""
            elif ( from_aux[0].find(".") != -1 ) or ( len(from_aux[0]) > 11 ):
                fromip = from_aux[0]
            else:
                fromport = from_aux[0]
        elif len(from_aux) == 2:
            fromip   = from_aux[0]
            fromport = from_aux[1]
        elif len(from_aux) == 3:
            # It's a app command
            rule = "LANG=en ufw delete " + from_aux[2]
            return rule
            
        # Set rule    
        # Action
        rule = rule.replace("&action", action)
        
        # Protocol
        if protocol != self.variable.get_constant("both"):
            rule = rule.replace("&protocol", protocol)
        else:
            rule = rule.replace(" proto &protocol ", " ")
            
        # FROM
        if fromip != "":
            rule = rule.replace("&fromIP", fromip)
        else:
            rule = rule.replace("&fromIP", self.variable.get_constant("any"))
            
        if fromport != "":
            rule = rule.replace("&fromPort", fromport)
        else:
            rule = rule.replace(" port &fromPort ", " ")
            
        # TO
        if toip != "":
            rule = rule.replace("&toIP", toip)
        else:
            rule = rule.replace("&toIP", self.variable.get_constant("any"))
            
        if toport != "":
            rule = rule.replace("&toPort", toport)
        else:
            rule = rule.replace(" port &toPort", "")

        # Return rule command
        return rule


    # Command Add rule
    def remove_rule(self, rule):
        result = commands.getstatusoutput(rule)
        return result[1]


    # Return size Gufw window
    def get_old_size_window(self):
        if not self.variable.dev:
            command = self.variable.get_command("read_size_win")
        else:
            command = self.variable.get_command("read_size_win_dev")
            
        width_height = commands.getstatusoutput(command)
        if width_height[0] == 0:
            width_height_split = width_height[1].split(";")
            width  = width_height_split[0].replace("width=","")
            height = width_height_split[1].replace("height=","")
        else:
            width  = self.variable.get_constant("window_width")
            height = self.variable.get_constant("window_height")
        
        return int(width),int(height)
        

    # Save actual size window
    def save_size_window(self, win_width, win_height):
        if not self.variable.dev:
            command = self.variable.get_command("save_size_win")
        else:
            command = self.variable.get_command("save_size_win_dev")
        
        command = command.replace("&1", str(win_width))
        command = command.replace("&2", str(win_height))
        
        commands.getstatusoutput(command)
