/*
 * globals.h
 * Contains global variables and constants (some #defined) for renum.
 *
 * Copyright 2004-2006,2009 by Dale McCoy.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _RENUM_GLOBALS_H_INCLUDED_
#define _RENUM_GLOBALS_H_INCLUDED_

#include<ostream>
#include<string>

// NFO header string
#define NFO_HEADER(ver)\
	("// Automatically generated by GRFCODEC. Do not modify!\n"\
	"// (Info version "+itoa(ver)+")\n")

#define NFO_FORMAT ("// Format: spritenum pcxfile xpos ypos compression ysize xsize xrel yrel\n")

extern const char*const VALID_PSEUDO; // List of valid pseudo-sprite characters
extern const char*const WHITESPACE; // List of whitespace characters
extern const std::string COMMENT; // List of comment prefix characters

extern std::string datadir; // Current data directory path
extern bool dosleep; // If true, program will wait after creating a new data directory
					 // If false, program will report where it found its data files.

extern const char*COMMENT_PREFIX; // Comment prefix string

#define NPOS (std::basic_string<char>::npos)

extern unsigned int _spritenum; // Current sprite number
extern unsigned int _grfver; // GRF format version of current NFO
extern unsigned int _act14_pal; // Palette info from action 14
extern unsigned int _autocorrect; // Auto-correction level

//TODO: add command-line arguments to set these appropriately.
extern std::ostream*pNfo; // NFO file output stream
extern std::ostream*pOut; // Console output stream
extern std::ostream*pErr; // Error output stream

#endif//_RENUM_GLOBALS_H_INCLUDED_
