#ifndef _BOARD_AND_LIST_TABCHILD_H
#define _BOARD_AND_LIST_TABCHILD_H
#include "boardTabChild.h"
#if QT_VERSION >= 0x040000
#define QListViewItem Q3ListViewItem
#else
#define Q3ListViewItem QListViewItem
#endif

class MoveTree;
class Q3ListViewItem;

class BoardAndListTabChild : public BoardTabChild
{
Q_OBJECT
public:
  BoardAndListTabChild(QWidget *parent = 0, const char *name = 0);
  void forward();
  void backward();
  int moveCount() const {
    return numMoves;
  }
  osl::NumEffectState getStateAndMovesToCurrent(osl::stl::vector<osl::Move> &moves);
  void toLastState();
private slots:
#if QT_VERSION >= 0x040000
  void updateBoardSlot(Q3ListViewItem *item);
#else
  void updateBoardSlot(QListViewItem *item);
#endif

protected:
  virtual void updateBoard(Q3ListViewItem *item);
  void init();
  bool tryForward();

  MoveTree *moveTree;
  int numMoves;
};

#endif // _BOARD_AND_LIST_TABCHILD_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
