#ifndef GPSSHOGI_GUI_OPENING_EDITOR_EDITBOARD_H
#define GPSSHOGI_GUI_OPENING_EDITOR_EDITBOARD_H
#include "board.h"

namespace gpsshogi
{
  namespace gui
  {
    /**
     * 編集可能な Board.
     *
     * 後手の持駒から/への駒の移動が基本の操作.
     * また，背景に画像を表示することもできる.
     */
    class EditBoard : public Board
    {
      Q_OBJECT

    public:
      EditBoard(osl::state::SimpleState state, QWidget *parent);

    public slots:
      void reset();
      void readPict();
      void togglePlayer();
      void setInitialPieces();

    protected:
      void mousePressEvent(QMouseEvent *e);
      void paintEvent(QPaintEvent *pe);

    private:
      osl::Ptype get_ptype(osl::Player&,
			   bool to_stand);

      bool available(osl::Player,
		     osl::Ptype) const;

      void remove_piece(osl::Piece);

      void place_piece(osl::Player,
		       osl::Square,
		       osl::Ptype);

      void update_state(osl::Piece pieces[40]);

      const QPixmap pieceToImage(osl::Player,
				 osl::Ptype) const;
      
      osl::Piece initial_pieces[40];
      QPixmap background;
    };
  }
}

#endif
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
