/* SqliteUtils.c generated by valac 0.11.3, the Vala compiler
 * generated from SqliteUtils.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))



gchar* dvb_database_sqlite_utils_escape (const gchar* text);
gchar* dvb_database_sqlite_utils_unescape (const gchar* text);


/**
     * Replace "'" with "''"
     */
gchar* dvb_database_sqlite_utils_escape (const gchar* text) {
	gchar* result = NULL;
	GRegex* regex;
	GRegex* _tmp1_ = NULL;
	GRegex* _tmp2_;
	GRegex* _tmp3_;
	gchar* escaped_str;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	if (text == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	regex = NULL;
	_tmp1_ = g_regex_new ("'", G_REGEX_MULTILINE, 0, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch4_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp3_ = _tmp2_;
	_g_regex_unref0 (regex);
	regex = _tmp3_;
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError * e;
		gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("SqliteUtils.vala:36: RegexError: %s", e->message);
		_tmp4_ = g_strdup (text);
		result = _tmp4_;
		_g_error_free0 (e);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	escaped_str = NULL;
	_tmp5_ = g_regex_replace_literal (regex, text, (gssize) (-1), 0, "''", 0, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch5_g_regex_error;
		}
		_g_free0 (escaped_str);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp7_ = _tmp6_;
	_g_free0 (escaped_str);
	escaped_str = _tmp7_;
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError * e;
		gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("SqliteUtils.vala:45: RegexError: %s", e->message);
		_tmp8_ = g_strdup (text);
		result = _tmp8_;
		_g_error_free0 (e);
		_g_free0 (escaped_str);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (escaped_str);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = escaped_str;
	_g_regex_unref0 (regex);
	return result;
}


/**
     * Replace "''" with "'"
     */
gchar* dvb_database_sqlite_utils_unescape (const gchar* text) {
	gchar* result = NULL;
	GRegex* regex;
	GRegex* _tmp0_ = NULL;
	GRegex* _tmp1_;
	GRegex* _tmp2_;
	gchar* new_str;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	regex = NULL;
	_tmp0_ = g_regex_new ("''", G_REGEX_MULTILINE, 0, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch6_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp2_ = _tmp1_;
	_g_regex_unref0 (regex);
	regex = _tmp2_;
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError * e;
		gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("SqliteUtils.vala:62: RegexError: %s", e->message);
		_tmp3_ = g_strdup (text);
		result = _tmp3_;
		_g_error_free0 (e);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	new_str = NULL;
	_tmp4_ = g_regex_replace_literal (regex, text, (gssize) (-1), 0, "'", 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch7_g_regex_error;
		}
		_g_free0 (new_str);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = _tmp5_;
	_g_free0 (new_str);
	new_str = _tmp6_;
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError * e;
		gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("SqliteUtils.vala:71: RegexError: %s", e->message);
		_tmp7_ = g_strdup (text);
		result = _tmp7_;
		_g_error_free0 (e);
		_g_free0 (new_str);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_free0 (new_str);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = new_str;
	_g_regex_unref0 (regex);
	return result;
}



