
from __future__ import with_statement

import glitch
import glitch.limbo.objects
from glitch.fbo import BufferCamera
from glitch.glx import GLXContext
from glitch.read import Read

class Shader(glitch.Shader):
    vertex = """
        varying vec4 pos;
        void main() {
            pos = gl_Vertex;
            gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
        }
        """

    fragment = """
        varying vec4 pos;
        void main() {
            gl_FragColor = vec4(pos.x, 0.5, pos.y, 1);
        }
        """

if __name__ == '__main__':
    width = 320
    height = 200
    read = Read(children=[Shader(children=[glitch.limbo.objects.Square()])])
    camera = BufferCamera(
        width, height, eye=[0.5, 0.5, 1], ref=[0.5, 0.5, 0], children=[read])
    context = GLXContext()

    with context:
        camera.render()

    pb = read.get_pixbuf()
    pb.save("glx.png", "png")

