#
# RBox - gDesklets control for Rhythmbox
# Copyright (c) 2005 Christoph Lenggenhager
#
# based on Rhythmlet and rbscobbler by Alex Revo
#
# ----------------------------------------------------------------------
#  IRBox.py - RBox interface
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
########################################################################

from libdesklets.controls import Interface, Permission

class IRBox(Interface):

    # properties along with their permissions
    
    # Song Info
    songinfo = Permission.READ 
    
    # status 
    play_order = Permission.READ 
    playing = Permission.READ 
    active = Permission.READ 
    elapsed_perc = Permission.READ # useable for <gauge> 
    
    elapsed = Permission.READWRITE 
    volume = Permission.READWRITE 
    repeat = Permission.READWRITE 
    shuffle = Permission.READWRITE 
    
    skip = Permission.WRITE
    
    # commands
    toggle_hide = Permission.WRITE
    toggle_mute = Permission.WRITE
    volume_up = Permission.WRITE
    volume_down = Permission.WRITE
    play_pause = Permission.WRITE
    next = Permission.WRITE
    previous = Permission.WRITE
    play_uri = Permission.WRITE
    set_rating = Permission.WRITE
    quit = Permission.WRITE
    refresh = Permission.WRITE
    grab_focus = Permission.WRITE
    
    
