#!/usr/bin/env python

from os import listdir, symlink, path, mkdir
from distutils.core import setup
import sys

glade_files = ['stuff/' + filename for filename in listdir('stuff') if filename.endswith('.glade')]

dist = setup(name='Gallery Uploader',
      version='1.10',
      description='Upload pictures and videos to Gallery installations',
      license='GPL',
      author='Pietro Battiston',
      author_email='toobaz@email.it',
      url='http://www.pietrobattiston.it/gallery-uploader',
      scripts=['gallery-uploader'],
      packages=['guplib'],
      py_modules=['galleryuploader_browser'],
      data_files=[('share/gallery-uploader/stuff', ['stuff/gallery.svg'] + glade_files),
				  ('share/pixmaps', ['stuff/gallery.svg']),
				  ('share/applications', ['stuff/gallery-uploader.desktop'])]+
					[('share/locale/'+lang+'/LC_MESSAGES/', ['locale/'+lang+'/LC_MESSAGES/gallery_uploader.mo'] ) for lang in listdir('locale')],
      classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: X11 Applications :: GTK',
        'Intended Audience :: End Users/Desktop',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Multimedia :: Graphics',
        'Topic :: Desktop Environment :: Gnome',
        'Topic :: Utilities',
        ]    
     )

if 'prefix' in dist.command_options['install']:
    prefix = dist.command_options['install']['prefix'][1]
elif 'root' in dist.command_options['install']:
    prefix = dist.command_options['install']['root'][1] + sys.prefix
else:
    prefix = sys.prefix

if path.exists(prefix + '/bin/gallery-uploader') or path.exists(sys.prefix + '/bin/gallery-uploader'):
    full_path = sys.prefix + '/bin/gallery-uploader'
else:
    full_path = sys.prefix + '/local/bin/gallery-uploader'

if prefix.endswith('local'):
    # We don't want /usr/local/nautilus-scripts; it wouldn't be recognized.
    prefix = prefix[:-6]
    # However we don't want to hardcode '/usr', since i.e. debian packages first
    # installs to a bogus directory.

if not path.exists(prefix + '/share/nautilus-scripts/Upload to Gallery'):
    if not path.exists(prefix + '/share/nautilus-scripts'):
        mkdir(prefix + '/share/nautilus-scripts')
    symlink(full_path, prefix +'/share/nautilus-scripts/Upload to Gallery')
