#ifndef IALERT_H
#define IALERT_H

#include <alertsplugin/alerts_exporter.h>

#include <QString>
#include <QDateTime>
#include <QWidget>

/**
 * \file ialert.h
 * \author Eric MAEKER <eric.maeker@free.fr>
 * \version 0.0.1
 * \date 16 Nov 2009
*/

namespace Alerts {

class ALERTS_EXPORT IAlert
{
public:
    enum Level {
        Alert_Maximum = 0,
        Alert_SimpleInformation,
        Alert_SimpleWarning,
        Alert_BlockingInformation,
        Alert_BlockingWarning,
        Alert_NeedToConnectToUserManager
    };

    IAlert() {}
    virtual ~IAlert() {}

    virtual QString senderName() const = 0;
    virtual QString senderUuid() const = 0;

    virtual QString receiverName() const = 0;
    virtual QString receiverUuid() const = 0;

    virtual QString contents() const = 0;

    virtual QDateTime dateOfRedaction() const = 0;
    virtual QDateTime dateOfExpiration() const = 0;

    virtual int level() const = 0;

    virtual void answerByMail(const QString &content) = 0;
    virtual void answerByAlert(const QString &content) = 0;

    virtual void validateAlert() = 0;

    /** \brief Use this function if you want to use a specific widget to present your alert. If
        this returns 0, a default widget will be used. */
    virtual QWidget *widget() {return 0;}

//    virtual bool actionToDoToRemoveAlert() ?

};

}  // End namespace Alerts

#endif // IALERT_H
