#ifndef ALERTMANAGER_H
#define ALERTMANAGER_H

#include <alertsplugin/ialert.h>

#include <QObject>

/**
 * \file alertmanager.h
 * \author Eric MAEKER <eric.maeker@free.fr>
 * \version 0.0.1
 * \date 16 Nov 2009
*/

/** \todo connect it with usermodel sig(userConnected(uuid)) --> check alerts for this user and show it if necessary. */
/** \todo manage patients alerts too. */

namespace Alerts {
namespace Internal {
class AlertManagerPrivate;
}

class AlertManager : public QObject
{
    Q_OBJECT
public:
    AlertManager(QObject *parent = 0);
    ~AlertManager();

    bool addAlert(IAlert *alert);
    bool userHasAlert(const QString &uuid) const;
    QList<IAlert *> userAlerts(const QString &uuid) const;
    bool executeUserAlerts(const QString &uuid);

private:
    Internal::AlertManagerPrivate *d;
};

}  // End namespace Alerts

#endif // ALERTMANAGER_H
