# Copyright (C) 2001, John Waymouth
# Adapted from Skeleton.pm by Bob McElrath.
#
# See the file COPYING for redistribution and modification terms.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package FilterProxy::Source;

use strict;
no strict 'subs';
use vars qw($VERSION $CONFIG $agent);  
use URI::Escape;

push @FilterProxy::MODULES, "Source";
$VERSION = 0.02;
$CONFIG = {};

$CONFIG->{order} = [-10,10];

$CONFIG->{mime_types} = [ "" ]; #the mime type gets zoinked to text/plain

*logger = \&FilterProxy::logger;

sub filter { 
  my($req) = shift;
  my($res) = shift;
  my($siteconfig) = shift; 
  my($order) = shift; 

  return unless (defined $res);

  if ($order == -10) {
	my $url = $res->url();
	logger(DEBUG,"$url being editted...");

        if ($url =~ m/(http:\/\/)source[\/]*\?(http[s]?:\/\/)?(.*)/) {
          if ($2) {
            $url = "$2$3";
          } else {
            $url = "$1$3";
          }
        }  

	logger(DEBUG,"Changed it to $url.");
	$res->url($url);
  } elsif ($order == 10) {
	$res->content_type('text/plain');
  }

  return;
}

# subclass UserAgent to allow redirects.
@SourceUserAgent::ISA = qw /LWP::UserAgent/;
sub SourceUserAgent::redirect_ok {1;}  # different from FilterProxy.
sub SourceUserAgent::get_basic_credentials { 
    return ($FilterProxy::CONFIG->{http_proxy_username}, $FilterProxy::CONFIG->{http_proxy_password}); 
}
$agent = new SourceUserAgent;

sub Config {
    my($req, $cgi, $siteconfig) = @_;
    
#    if(defined $cgi->param('url')) {
#        my($myreq) = $req->clone;
#        $myreq->uri(uri_unescape($cgi->param('url')));  # uri_unescape from URI::Escape module
#        my($agent) = new SourceUserAgent;
#        my($res) = $agent->request($myreq); # Use FilterProxy's UserAgent object
#        logger(INFO, "Source: [", $res->code, " ", $res->message, "] for ", $req->uri, 
#            ($res->content||$res->code == 200)
#              ?join("", " (", $res->content_type, " ", 
#                ($res->content_length?$res->content_length:"unspecified"), " bytes)\n")
#              :""
#            );
#        print $res->headers_as_string;
#        &FilterProxy::handle_filtering($myreq, $res, 1,2,3); # Decode content (FilterProxy::Compress)
#        ${$res->content_ref} =~ s/>/&gt;/g; # We're not changing mime-type, so 
#        ${$res->content_ref} =~ s/</&lt;/g; # hide all the markup
#        return($res->content() . "blah?"); # This gets passed to Source.html as $ENV{MESSAGE};
#    }
#    return "Pass a URL as the 'url' parameter in order to view source.";
}

