#!/bin/bash
#
# This file is part of fadecut
# https://github.com/micressor/fadecut
#
# fadecut is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# fadecut is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with fadecut.  If not, see <http://www.gnu.org/licenses/>.

# --- Constants ----------------------------------------------------------------
. ./config || exit 3
# --- Variables ----------------------------------------------------------------
# --- Main ---------------------------------------------------------------------
retMain=0

if [ -d "${HOME_FADECUT}" ] && \
   [ -r "/tmp/fadecut_${LOGNAME}.tgz" ];
then
  rm -rf ${HOME_FADECUT}
  cd / 
  echo "Restoring home"
  tar xf /tmp/fadecut_${LOGNAME}.tar || retMain=3
fi

rm ${LOCKFILE}

exit $retMain
