/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __DSLICE_H
#define __DSLICE_H

//--- IO includes ---
#include <iostream>
using std::ostream;
using std::endl;

class DSlice
{
 private:
  int m_start;
  int m_length1,m_length2;
  int m_stride1,m_stride2;

 public:
  DSlice(int st,int l1,int s1,int l2,int s2):
    m_start(st),m_length1(l1),m_length2(l2),m_stride1(s1),m_stride2(s2)
    {}
  
  inline unsigned int size() const {return m_length1*m_length2;}
  inline int operator[](int idx) const
    {return m_start+(idx%m_length1)*m_stride1+(idx/m_length1)*m_stride2;}

  friend bool operator==(const DSlice&,const DSlice&);
  friend bool operator!=(const DSlice&,const DSlice&);
  
  friend ostream& operator<< (ostream&,const DSlice&);
};

#endif //__DSLICE_H
