/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#include <boost/version.hpp>
#include <boost/python.hpp>
#include <boost/noncopyable.hpp>
#include "Python/esys/lsm/geometry/SimpleBlockPy.h"
#include "Python/esys/lsm/geometry/SimpleSphereCollectionPy.h"
#include "Python/esys/lsm/geometry/SimpleSpherePy.h"
#include "Geometry/SimpleBlock.h"

namespace esys
{
  namespace lsm
  {
    SimpleBlockPy::SimpleBlockPy() : SimpleSphereCollectionPy()
    {
    }
    
    SimpleBlockPy::SimpleBlockPy(
      const boost::python::list &dimCount,
      double radius
    )
      : SimpleSphereCollectionPy()
    {
      SimpleBlockGenerator<SimpleSpherePy>
        generator = SimpleBlockGenerator<SimpleSpherePy>(
            boost::python::extract<int>(dimCount[0]),
            boost::python::extract<int>(dimCount[1]),
            boost::python::extract<int>(dimCount[2]),
            radius
        );
      generator.createParticles(*this);
    }

    using boost::python::arg;
    void exportSimpleBlock()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      boost::python::class_<
        SimpleBlockPy,
        boost::python::bases<SimpleSphereCollectionPy>,
        boost::noncopyable
      >(
        "SimpleBlock",
        "A regular packing of spheres.",
        boost::python::init<
          const boost::python::list &,
          boost::python::optional<double>
        >(
          (arg("dimCount"), arg("radius")),
          "Creates a collection of C{dimCount[0]*dimCount[2]*dimCount[2]}"
          " spheres arranged in a regular rectangular lattice packing.\n"
          "@type dimCount: list of 3 elements\n"
          "@kwarg dimCount: number of particles in each packing dimension\n"
          "@type radius: float\n"
          "@kwarg radius: Radius of spheres in the packing\n"
        )
      )
      .def(
        boost::python::init<>()
      )
      ;
    }
  }
}
