/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#include <boost/version.hpp>
#include <boost/python.hpp>
#include "Python/esys/lsm/ParticleFieldSaverPrmsPy.h"

namespace esys
{
  namespace lsm
  {
    ParticleFieldSaverPrmsPy::ParticleFieldSaverPrmsPy(
      const std::string &fieldName,
      const std::string &fileName,
      const std::string &fileFormat,
      int beginTimeStep,
      int endTimeStep,
      int timeStepIncr
    ) :
      FieldSaverPrmsPy(
        fieldName,
        fileName,
        fileFormat,
        beginTimeStep,
        endTimeStep,
        timeStepIncr
      )
    {
    }

    ParticleScalarFieldSaverPrmsPy::ParticleScalarFieldSaverPrmsPy(
      const std::string &fieldName,
      const std::string &fileName,
      const std::string &fileFormat,
      int beginTimeStep,
      int endTimeStep,
      int timeStepIncr
    ) :
      ParticleFieldSaverPrmsPy(
        fieldName,
        fileName,
        fileFormat,
        beginTimeStep,
        endTimeStep,
        timeStepIncr
      )
    {
    }

    ParticleVectorFieldSaverPrmsPy::ParticleVectorFieldSaverPrmsPy(
      const std::string &fieldName,
      const std::string &fileName,
      const std::string &fileFormat,
      int beginTimeStep,
      int endTimeStep,
      int timeStepIncr
    ) :
      ParticleFieldSaverPrmsPy(
        fieldName,
        fileName,
        fileFormat,
        beginTimeStep,
        endTimeStep,
        timeStepIncr
      )
    {
    }

    TaggedParticleScalarFieldSaverPrmsPy::TaggedParticleScalarFieldSaverPrmsPy(
      const std::string &fieldName,
      const std::string &fileName,
      const std::string &fileFormat,
      int beginTimeStep,
      int endTimeStep,
      int timeStepIncr,
      int tag,
      int mask
    ) : ParticleScalarFieldSaverPrmsPy (fieldName,
					fileName,
					fileFormat,
					beginTimeStep,
					endTimeStep,
					timeStepIncr)
    {
      m_tag=tag;
      m_mask=mask;
    }
					    
    TaggedParticleVectorFieldSaverPrmsPy::TaggedParticleVectorFieldSaverPrmsPy(
      const std::string &fieldName,
      const std::string &fileName,
      const std::string &fileFormat,
      int beginTimeStep,
      int endTimeStep,
      int timeStepIncr,
      int tag,
      int mask
    ) : ParticleVectorFieldSaverPrmsPy (fieldName,
					fileName,
					fileFormat,
					beginTimeStep,
					endTimeStep,
					timeStepIncr)
    {
      m_tag=tag;
      m_mask=mask;
    }
					    

    using boost::python::arg;
    void exportParticleFieldSaverPrms()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      boost::python::class_<
        ParticleFieldSaverPrmsPy,
        boost::python::bases<FieldSaverPrmsPy>
      >(
        "ParticleFieldSaverPrms",
        "Base class describing parameters for saving particle-data to file.",
        boost::python::init<
          const std::string &,
          const std::string &,
          const std::string &,
          int,
          int,
          int
        >(
          (
            arg("fieldName"),
            arg("fileName"),
            arg("fileFormat"),
            arg("beginTimeStep"),
            arg("endTimeStep"),
            arg("timeStepIncr")
          ),
          "@type fieldName: string\n"
          "@kwarg fieldName: Name of the data field, eg 'e_kin'.\n"
          "@type fileName: string\n"
          "@kwarg fileName: Name of the file where data is saved.\n"
          "@type fileFormat: string\n"
          "@kwarg fileFormat: Format of the data - 'SUM' or 'DX'.\n"
          "@type beginTimeStep: int\n"
          "@kwarg beginTimeStep: start saving data at this time step\n"
          "@type endTimeStep: int\n"
          "@kwarg endTimeStep:   finish saving data at this time step\n"
          "@type timeStepIncr: int\n"
          "@kwarg timeStepIncr:  save data every timeStepIncr time steps"
        )
      )
      ;

      boost::python::class_<
        ParticleScalarFieldSaverPrmsPy,
        boost::python::bases<ParticleFieldSaverPrmsPy>
      >(
        "ParticleScalarFieldSaverPrms",
        "Parameters for saving scalar particle-data to file.",
        boost::python::init<
          const std::string &,
          const std::string &,
          const std::string &,
          int,
          int,
          int
        >(
          (
            arg("fieldName"),
            arg("fileName"),
            arg("fileFormat"),
            arg("beginTimeStep"),
            arg("endTimeStep"),
            arg("timeStepIncr")
          )
        )
      )
      ;

      boost::python::class_<
        ParticleVectorFieldSaverPrmsPy,
        boost::python::bases<ParticleFieldSaverPrmsPy>
      >(
        "ParticleVectorFieldSaverPrms",
        "Parameters for saving vector particle-data to file.",
        boost::python::init<
          const std::string &,
          const std::string &,
          const std::string &,
          int,
          int,
          int
        >(
          (
            arg("fieldName"),
            arg("fileName"),
            arg("fileFormat"),
            arg("beginTimeStep"),
            arg("endTimeStep"),
            arg("timeStepIncr")
          )
        )
      );

      boost::python::class_<
        TaggedParticleScalarFieldSaverPrmsPy,
        boost::python::bases<ParticleScalarFieldSaverPrmsPy>
      >(
        "TaggedParticleScalarFieldSaverPrms",
        "Parameters for saving scalar data of tagged particles to file.",
        boost::python::init<
          const std::string &,
          const std::string &,
          const std::string &,
          int,
          int,
          int,
          int,
          int
        >(
          (
            arg("fieldName"),
            arg("fileName"),
            arg("fileFormat"),
            arg("beginTimeStep"),
            arg("endTimeStep"),
            arg("timeStepIncr"),
            arg("tag"),
            arg("mask")
          )
        )
      )
      ;

      boost::python::class_<
        TaggedParticleVectorFieldSaverPrmsPy,
        boost::python::bases<ParticleVectorFieldSaverPrmsPy>
      >(
        "TaggedParticleVectorFieldSaverPrms",
        "Parameters for saving vector data of tagged particles to file.",
        boost::python::init<
          const std::string &,
          const std::string &,
          const std::string &,
          int,
          int,
          int,
          int,
          int
        >(
          (
            arg("fieldName"),
            arg("fileName"),
            arg("fileFormat"),
            arg("beginTimeStep"),
            arg("endTimeStep"),
            arg("timeStepIncr"),
            arg("tag"),
            arg("mask")
          )
        )
      );
    }
  }
}
