/*
    espctag.c : espctag
    v0.2 - 2010-11-08
    
    Copyright (C) 2010,2011 Jérôme SONRIER <jsid@emor3j.fr.eu.org>

    This file is part of espctag.

    espctag is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    espctag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with espctag.  If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdio.h>
#include <stdlib.h>
#include <spctag.h>

#include "constants.h"

int main( int argc, char **argv )
{
	FILE *spc_file;
	char msgerror[1024];
	int ret;
	
	// Exit if no filename is specify
	if ( argc < 2 ) {
		fprintf( stderr, "Usage : %s filname\n", argv[0]);
		exit( E_WRONG_ARG );
	}
	
	// Open file
	if ( ( spc_file = fopen( argv[1], "r" ) ) == NULL ) {
		sprintf( msgerror, "Unable to open file '%s'!", argv[1] );
		perror( msgerror );
		exit( E_OPEN_FILE );
	}

	// Init spctag
	if ( ( ret = spctag_init( spc_file ) ) < 0 ) {
		fprintf( stderr, "Can not init libspctag!\n" );
		fclose( spc_file );
		exit( ret );
	}
	
	// Close file
	fclose( spc_file );

	// Print tags
	if ( spctag_txt_tag )
		printf( "Tags type: Text\n" );
	else
		printf( "Tags type: Binary\n" );
	printf( "Song title : %s\n", spctag_get_songtitle() );
	printf( "Game title : %s\n", spctag_get_gametitle() );
	printf( "Dumper name : %s\n", spctag_get_dumpername() );
	printf( "Comments : %s\n", spctag_get_comments() );
	printf( "Dump date : %s\n", spctag_get_dumpdate() );
	printf( "Length(s) : %s\n", spctag_get_length() );
	printf( "Fade length(ms) : %s\n", spctag_get_fadelength() );
	printf( "Artist : %s\n", spctag_get_artist() );
	printf( "Default channels : %s\n", spctag_get_defaultchannels() );
	printf( "Emulator : %s\n", spctag_get_emulator() );

	return( SUCCESS );
}
