package de.lmu.ifi.dbs.elki.data.synthetic.bymodel;

/*
 This file is part of ELKI:
 Environment for Developing KDD-Applications Supported by Index-Structures

 Copyright (C) 2011
 Ludwig-Maximilians-Universität München
 Lehr- und Forschungseinheit für Datenbanksysteme
 ELKI Development Team

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import java.util.List;

import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;

/**
 * Interface for cluster generators
 * 
 * @author Erich Schubert
 */
public interface GeneratorInterface {
  /**
   * Get number of points to be generated by this generator.
   * 
   * @return cluster size
   */
  public int getSize();
  
  /**
   * Get dimensionality of generated data
   * 
   * @return dimensionality
   */
  public int getDim();
  
  /**
   * Generate a specified number of points
   * 
   * @param count Number of points to generate
   * @return List of generated points
   * @throws UnableToComplyException when generation fails
   */
  public abstract List<Vector> generate(int count) throws UnableToComplyException;

  /**
   * Get the density of the given vector
   * 
   * @param p vector
   * @return density
   */
  public abstract double getDensity(Vector p);

  /**
   * Get points.
   * 
   * NOTE: The list may be modified by the caller, it is not immutable.
   * The class should not return a copy, but should allow modification.
   * However when removing points, the called is expected to call setDiscarded.
   * 
   * @return points
   */
  public List<Vector> getPoints(); 

  /**
   * Get cluster name
   * @return cluster name
   */
  public String getName();
}