# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo, S.A. (www.fluendo.com).
# All rights reserved.
# 
# This software is available under three license agreements.
# 
# There are various plugins and extra modules for Elisa licensed
# under the MIT license. For instance our upnp module uses this license.
# 
# The core of Elisa is licensed under GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special 
# exception to use Elisa with Fluendo's plugins.
# 
# The GPL part is also available under a commerical licensing
# agreement.
# 
# The second license is the Elisa Commercial License Agreement.
# This license agreement is available to licensees holding valid
# Elisa Commercial Agreement licenses.
# See "LICENSE.Elisa" in the root of this distribution.

import sys
import os

from elisa.utils.i18n import compile_po_files

def main(args):
    # Argument check
    if len(args) < 3:
        print 'This script is compiling po-files into mo-files for a '
        print 'specified domain. It is also creating the correct path if it'
        print ' is not existing. The path should is going to be:'
        print '   [output/path]/_lang_/LC_MESSAGES/_domain_.mo'
        print ''
        print 'usage:'
        print '    python %s domain path/to/po/files /path/to/output' % sys.argv[0]
        print ''
        print 'example:'
        print '    python %s test-project po/ locale/' % sys.argv[0]
        return -1

    domain = sys.argv[1]
    input = sys.argv[2]
    output = sys.argv[3]
    return compile_po_files(domain, input, output)

if __name__ == '__main__':
    sys.exit(main(sys.argv[1:]))
