# 
# Tests changes to multiple tables within the same transaction 
#

--disable_warnings
DROP TABLE IF EXISTS t1, t2;
--enable_warnings

CREATE TABLE t1 (
  id INT NOT NULL PRIMARY KEY
);

CREATE TABLE t2 (
  id INT NOT NULL PRIMARY KEY
);

START TRANSACTION;
INSERT INTO t1 VALUES (1);
INSERT INTO t2 VALUES (1);
COMMIT;

START TRANSACTION;
UPDATE t1 SET id=2 WHERE id=1;
UPDATE t2 SET id=2 WHERE id=1;
COMMIT;

START TRANSACTION;
DELETE FROM t1 WHERE id=2;
DELETE FROM t2 WHERE id=2;
COMMIT;

DROP TABLE t1, t2;
