/* -*- mode: c++; c-basic-offset: 2; indent-tabs-mode: nil; -*-
 *  vim:expandtab:shiftwidth=2:tabstop=2:smarttab:
 *
 *  Copyright (C) 2010 Mark Atwood
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef PLUGIN_SYSLOG_ERRMSG_H
#define PLUGIN_SYSLOG_ERRMSG_H

#include "module.h"
#include <stdarg.h>
#include <drizzled/plugin/error_message.h>

class ErrorMessage_syslog : public drizzled::plugin::ErrorMessage
{
 private:
  int syslog_facility;
  int syslog_priority;

  ErrorMessage_syslog(const ErrorMessage_syslog&);
  ErrorMessage_syslog& operator=(const ErrorMessage_syslog&);

 public:
  ErrorMessage_syslog();

  virtual bool errmsg(drizzled::Session *, int, const char *format, va_list ap);
};

#endif /* PLUGIN_SYSLOG_ERRMSG_H */
