/* -*- mode: c++; c-basic-offset: 2; indent-tabs-mode: nil; -*-
 *  vim:expandtab:shiftwidth=2:tabstop=2:smarttab:
 *
 *  Copyright (C) 2008 Sun Microsystems
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef PLUGIN_COMPRESSION_UNCOMPRESSED_LENGTH_H
#define PLUGIN_COMPRESSION_UNCOMPRESSED_LENGTH_H

#include <drizzled/plugin/function.h>
#include <drizzled/function/math/int.h>


class Item_func_uncompressed_length : public drizzled::Item_int_func
{
  drizzled::String value;
public:
  Item_func_uncompressed_length():Item_int_func(){}
  const char *func_name() const{return "uncompressed_length";}
  void fix_length_and_dec() { max_length=10; }
  bool check_argument_count(int n) { return (n==1); }
  int64_t val_int();
};


#endif /* PLUGIN_COMPRESSION_UNCOMPRESSED_LENGTH_H */
