/* -*- mode: c++; c-basic-offset: 2; indent-tabs-mode: nil; -*-
 *  vim:expandtab:shiftwidth=2:tabstop=2:smarttab:
 *
 *  Copyright (C) 2010 Monty Taylor
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "config.h"

#include "option_map.h"


namespace drizzled
{
namespace module
{

namespace po= boost::program_options;

option_map::option_map(const std::string &module_name_in,
                       const po::variables_map &vm_in) :
  module_name(module_name_in),
  vm(vm_in)
{ }

option_map::option_map(const option_map &old) :
  module_name(old.module_name),
  vm(old.vm)
{ }


} /* namespace module */
} /* namespace drizzled */

