/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse DRIZZLEparse
#define yylex   DRIZZLElex
#define yyerror DRIZZLEerror
#define yylval  DRIZZLElval
#define yychar  DRIZZLEchar
#define yydebug DRIZZLEdebug
#define yynerrs DRIZZLEnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACTION = 259,
     ADD = 260,
     ADDDATE_SYM = 261,
     AFTER_SYM = 262,
     AGGREGATE_SYM = 263,
     ALL = 264,
     ALTER = 265,
     ANALYZE_SYM = 266,
     AND_SYM = 267,
     ANY_SYM = 268,
     AS = 269,
     ASC = 270,
     ASENSITIVE_SYM = 271,
     AT_SYM = 272,
     AUTO_INC = 273,
     AVG_ROW_LENGTH = 274,
     AVG_SYM = 275,
     BEFORE_SYM = 276,
     BEGIN_SYM = 277,
     BETWEEN_SYM = 278,
     BIGINT_SYM = 279,
     BINARY = 280,
     BIN_NUM = 281,
     BIT_SYM = 282,
     BLOB_SYM = 283,
     BLOCK_SIZE_SYM = 284,
     BLOCK_SYM = 285,
     BOOLEAN_SYM = 286,
     BOOL_SYM = 287,
     BOTH = 288,
     BTREE_SYM = 289,
     BY = 290,
     BYTE_SYM = 291,
     CALL_SYM = 292,
     CASCADE = 293,
     CASCADED = 294,
     CASE_SYM = 295,
     CAST_SYM = 296,
     CHAIN_SYM = 297,
     CHANGE = 298,
     CHAR_SYM = 299,
     CHECKSUM_SYM = 300,
     CHECK_SYM = 301,
     CLOSE_SYM = 302,
     COALESCE = 303,
     COLLATE_SYM = 304,
     COLLATION_SYM = 305,
     COLUMNS = 306,
     COLUMN_SYM = 307,
     COMMENT_SYM = 308,
     COMMITTED_SYM = 309,
     COMMIT_SYM = 310,
     COMPACT_SYM = 311,
     COMPRESSED_SYM = 312,
     CONCURRENT = 313,
     CONDITION_SYM = 314,
     CONNECTION_SYM = 315,
     CONSISTENT_SYM = 316,
     CONSTRAINT = 317,
     CONTAINS_SYM = 318,
     CONTINUE_SYM = 319,
     CONVERT_SYM = 320,
     COUNT_SYM = 321,
     CREATE = 322,
     CROSS = 323,
     CUBE_SYM = 324,
     CURDATE = 325,
     CURRENT_USER = 326,
     CURSOR_SYM = 327,
     DATABASE = 328,
     DATABASES = 329,
     DATAFILE_SYM = 330,
     DATA_SYM = 331,
     DATETIME_SYM = 332,
     DATE_ADD_INTERVAL = 333,
     DATE_SUB_INTERVAL = 334,
     DATE_SYM = 335,
     DAY_HOUR_SYM = 336,
     DAY_MICROSECOND_SYM = 337,
     DAY_MINUTE_SYM = 338,
     DAY_SECOND_SYM = 339,
     DAY_SYM = 340,
     DEALLOCATE_SYM = 341,
     DECIMAL_NUM = 342,
     DECIMAL_SYM = 343,
     DECLARE_SYM = 344,
     DEFAULT = 345,
     DELETE_SYM = 346,
     DESC = 347,
     DESCRIBE = 348,
     DETERMINISTIC_SYM = 349,
     DISABLE_SYM = 350,
     DISCARD = 351,
     DISTINCT = 352,
     DIV_SYM = 353,
     DOUBLE_SYM = 354,
     DROP = 355,
     DUMPFILE = 356,
     DUPLICATE_SYM = 357,
     DYNAMIC_SYM = 358,
     EACH_SYM = 359,
     ELSE = 360,
     ELSEIF_SYM = 361,
     ENABLE_SYM = 362,
     ENCLOSED = 363,
     END = 364,
     ENDS_SYM = 365,
     END_OF_INPUT = 366,
     ENGINE_SYM = 367,
     ENUM_SYM = 368,
     EQ = 369,
     EQUAL_SYM = 370,
     ERRORS = 371,
     ESCAPED = 372,
     ESCAPE_SYM = 373,
     EXCLUSIVE_SYM = 374,
     EXISTS = 375,
     EXTENDED_SYM = 376,
     EXTRACT_SYM = 377,
     FALSE_SYM = 378,
     FETCH_SYM = 379,
     COLUMN_FORMAT_SYM = 380,
     FILE_SYM = 381,
     FIRST_SYM = 382,
     FIXED_SYM = 383,
     FLOAT_NUM = 384,
     FLUSH_SYM = 385,
     FORCE_SYM = 386,
     FOREIGN = 387,
     FOR_SYM = 388,
     FOUND_SYM = 389,
     FRAC_SECOND_SYM = 390,
     FROM = 391,
     FULL = 392,
     GE = 393,
     GLOBAL_SYM = 394,
     GROUP_SYM = 395,
     GROUP_CONCAT_SYM = 396,
     GT_SYM = 397,
     HASH_SYM = 398,
     HAVING = 399,
     HEX_NUM = 400,
     HOUR_MICROSECOND_SYM = 401,
     HOUR_MINUTE_SYM = 402,
     HOUR_SECOND_SYM = 403,
     HOUR_SYM = 404,
     IDENT = 405,
     IDENTIFIED_SYM = 406,
     IDENT_QUOTED = 407,
     IF = 408,
     IGNORE_SYM = 409,
     IMPORT = 410,
     INDEXES = 411,
     INDEX_SYM = 412,
     INFILE = 413,
     INNER_SYM = 414,
     INOUT_SYM = 415,
     INSENSITIVE_SYM = 416,
     INSERT = 417,
     INTERVAL_SYM = 418,
     INTO = 419,
     INT_SYM = 420,
     IN_SYM = 421,
     IS = 422,
     ISOLATION = 423,
     ITERATE_SYM = 424,
     JOIN_SYM = 425,
     KEYS = 426,
     KEY_BLOCK_SIZE = 427,
     KEY_SYM = 428,
     KILL_SYM = 429,
     LAST_SYM = 430,
     LE = 431,
     LEADING = 432,
     LEFT = 433,
     LEVEL_SYM = 434,
     LEX_HOSTNAME = 435,
     LIKE = 436,
     LIMIT = 437,
     LINES = 438,
     LIST_SYM = 439,
     LOAD = 440,
     LOCAL_SYM = 441,
     LOCATOR_SYM = 442,
     LOCKS_SYM = 443,
     LOCK_SYM = 444,
     LOGS_SYM = 445,
     LONG_NUM = 446,
     LONG_SYM = 447,
     LOOP_SYM = 448,
     LT = 449,
     MATCH = 450,
     MAX_ROWS = 451,
     MAX_SIZE_SYM = 452,
     MAX_SYM = 453,
     MAX_VALUE_SYM = 454,
     MEDIUM_SYM = 455,
     MERGE_SYM = 456,
     MICROSECOND_SYM = 457,
     MINUTE_MICROSECOND_SYM = 458,
     MINUTE_SECOND_SYM = 459,
     MINUTE_SYM = 460,
     MIN_ROWS = 461,
     MIN_SYM = 462,
     MODE_SYM = 463,
     MODIFIES_SYM = 464,
     MODIFY_SYM = 465,
     MOD_SYM = 466,
     MONTH_SYM = 467,
     NAMES_SYM = 468,
     NAME_SYM = 469,
     NATIONAL_SYM = 470,
     NATURAL = 471,
     NE = 472,
     NEG = 473,
     NEW_SYM = 474,
     NEXT_SYM = 475,
     NONE_SYM = 476,
     NOT_SYM = 477,
     NOW_SYM = 478,
     NO_SYM = 479,
     NULL_SYM = 480,
     NUM = 481,
     NUMERIC_SYM = 482,
     OFFLINE_SYM = 483,
     OFFSET_SYM = 484,
     ON = 485,
     ONE_SHOT_SYM = 486,
     ONE_SYM = 487,
     ONLINE_SYM = 488,
     OPEN_SYM = 489,
     OPTIMIZE = 490,
     OPTION = 491,
     OPTIONALLY = 492,
     ORDER_SYM = 493,
     OR_SYM = 494,
     OUTER = 495,
     OUTFILE = 496,
     OUT_SYM = 497,
     PAGE_SYM = 498,
     PARTIAL = 499,
     PHASE_SYM = 500,
     POSITION_SYM = 501,
     PRECISION = 502,
     PREV_SYM = 503,
     PRIMARY_SYM = 504,
     PROCESS = 505,
     PROCESSLIST_SYM = 506,
     QUARTER_SYM = 507,
     QUERY_SYM = 508,
     RANGE_SYM = 509,
     READS_SYM = 510,
     READ_ONLY_SYM = 511,
     READ_SYM = 512,
     READ_WRITE_SYM = 513,
     REAL = 514,
     REDUNDANT_SYM = 515,
     REFERENCES = 516,
     RELEASE_SYM = 517,
     RENAME = 518,
     REPEATABLE_SYM = 519,
     REPEAT_SYM = 520,
     REPLACE = 521,
     RESTRICT = 522,
     RETURNS_SYM = 523,
     RETURN_SYM = 524,
     REVERSE_SYM = 525,
     REVOKE = 526,
     RIGHT = 527,
     ROLLBACK_SYM = 528,
     ROLLUP_SYM = 529,
     ROUTINE_SYM = 530,
     ROWS_SYM = 531,
     ROW_FORMAT_SYM = 532,
     ROW_SYM = 533,
     SAVEPOINT_SYM = 534,
     SECOND_MICROSECOND_SYM = 535,
     SECOND_SYM = 536,
     SECURITY_SYM = 537,
     SELECT_SYM = 538,
     SENSITIVE_SYM = 539,
     SEPARATOR_SYM = 540,
     SERIALIZABLE_SYM = 541,
     SERIAL_SYM = 542,
     SESSION_SYM = 543,
     SERVER_SYM = 544,
     SERVER_OPTIONS = 545,
     SET = 546,
     SET_VAR = 547,
     SHARE_SYM = 548,
     SHOW = 549,
     SHUTDOWN = 550,
     SIMPLE_SYM = 551,
     SNAPSHOT_SYM = 552,
     SPECIFIC_SYM = 553,
     SQLEXCEPTION_SYM = 554,
     SQLSTATE_SYM = 555,
     SQLWARNING_SYM = 556,
     SQL_BIG_RESULT = 557,
     SQL_BUFFER_RESULT = 558,
     SQL_CALC_FOUND_ROWS = 559,
     SQL_SMALL_RESULT = 560,
     SQL_SYM = 561,
     STARTING = 562,
     START_SYM = 563,
     STATUS_SYM = 564,
     STDDEV_SAMP_SYM = 565,
     STD_SYM = 566,
     STOP_SYM = 567,
     STORAGE_SYM = 568,
     STORED_SYM = 569,
     STRAIGHT_JOIN = 570,
     STRING_SYM = 571,
     SUBDATE_SYM = 572,
     SUBJECT_SYM = 573,
     SUBSTRING = 574,
     SUM_SYM = 575,
     SUSPEND_SYM = 576,
     SWAPS_SYM = 577,
     SWITCHES_SYM = 578,
     SYSDATE = 579,
     TABLES = 580,
     TABLESPACE = 581,
     TABLE_REF_PRIORITY = 582,
     TABLE_SYM = 583,
     TEMPORARY_SYM = 584,
     TERMINATED = 585,
     TEXT_STRING = 586,
     TEXT_SYM = 587,
     THEN_SYM = 588,
     TIMESTAMP_SYM = 589,
     TIMESTAMP_ADD = 590,
     TIMESTAMP_DIFF = 591,
     TO_SYM = 592,
     TRAILING = 593,
     TRANSACTION_SYM = 594,
     TRIM = 595,
     TRUE_SYM = 596,
     TRUNCATE_SYM = 597,
     TYPES_SYM = 598,
     TYPE_SYM = 599,
     ULONGLONG_NUM = 600,
     UNCOMMITTED_SYM = 601,
     UNDOFILE_SYM = 602,
     UNDO_SYM = 603,
     UNION_SYM = 604,
     UNIQUE_SYM = 605,
     UNKNOWN_SYM = 606,
     UNLOCK_SYM = 607,
     UPDATE_SYM = 608,
     USAGE = 609,
     USER = 610,
     USE_SYM = 611,
     USING = 612,
     UTC_DATE_SYM = 613,
     UTC_TIMESTAMP_SYM = 614,
     VALUES = 615,
     VALUE_SYM = 616,
     VARBINARY = 617,
     VARCHAR_SYM = 618,
     VARIABLES = 619,
     VARIANCE_SYM = 620,
     VARYING = 621,
     VAR_SAMP_SYM = 622,
     WARNINGS = 623,
     WEEK_SYM = 624,
     WHEN_SYM = 625,
     WHERE = 626,
     WITH = 627,
     WITH_ROLLUP_SYM = 628,
     WORK_SYM = 629,
     WRITE_SYM = 630,
     XOR = 631,
     YEAR_MONTH_SYM = 632,
     YEAR_SYM = 633
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACTION 259
#define ADD 260
#define ADDDATE_SYM 261
#define AFTER_SYM 262
#define AGGREGATE_SYM 263
#define ALL 264
#define ALTER 265
#define ANALYZE_SYM 266
#define AND_SYM 267
#define ANY_SYM 268
#define AS 269
#define ASC 270
#define ASENSITIVE_SYM 271
#define AT_SYM 272
#define AUTO_INC 273
#define AVG_ROW_LENGTH 274
#define AVG_SYM 275
#define BEFORE_SYM 276
#define BEGIN_SYM 277
#define BETWEEN_SYM 278
#define BIGINT_SYM 279
#define BINARY 280
#define BIN_NUM 281
#define BIT_SYM 282
#define BLOB_SYM 283
#define BLOCK_SIZE_SYM 284
#define BLOCK_SYM 285
#define BOOLEAN_SYM 286
#define BOOL_SYM 287
#define BOTH 288
#define BTREE_SYM 289
#define BY 290
#define BYTE_SYM 291
#define CALL_SYM 292
#define CASCADE 293
#define CASCADED 294
#define CASE_SYM 295
#define CAST_SYM 296
#define CHAIN_SYM 297
#define CHANGE 298
#define CHAR_SYM 299
#define CHECKSUM_SYM 300
#define CHECK_SYM 301
#define CLOSE_SYM 302
#define COALESCE 303
#define COLLATE_SYM 304
#define COLLATION_SYM 305
#define COLUMNS 306
#define COLUMN_SYM 307
#define COMMENT_SYM 308
#define COMMITTED_SYM 309
#define COMMIT_SYM 310
#define COMPACT_SYM 311
#define COMPRESSED_SYM 312
#define CONCURRENT 313
#define CONDITION_SYM 314
#define CONNECTION_SYM 315
#define CONSISTENT_SYM 316
#define CONSTRAINT 317
#define CONTAINS_SYM 318
#define CONTINUE_SYM 319
#define CONVERT_SYM 320
#define COUNT_SYM 321
#define CREATE 322
#define CROSS 323
#define CUBE_SYM 324
#define CURDATE 325
#define CURRENT_USER 326
#define CURSOR_SYM 327
#define DATABASE 328
#define DATABASES 329
#define DATAFILE_SYM 330
#define DATA_SYM 331
#define DATETIME_SYM 332
#define DATE_ADD_INTERVAL 333
#define DATE_SUB_INTERVAL 334
#define DATE_SYM 335
#define DAY_HOUR_SYM 336
#define DAY_MICROSECOND_SYM 337
#define DAY_MINUTE_SYM 338
#define DAY_SECOND_SYM 339
#define DAY_SYM 340
#define DEALLOCATE_SYM 341
#define DECIMAL_NUM 342
#define DECIMAL_SYM 343
#define DECLARE_SYM 344
#define DEFAULT 345
#define DELETE_SYM 346
#define DESC 347
#define DESCRIBE 348
#define DETERMINISTIC_SYM 349
#define DISABLE_SYM 350
#define DISCARD 351
#define DISTINCT 352
#define DIV_SYM 353
#define DOUBLE_SYM 354
#define DROP 355
#define DUMPFILE 356
#define DUPLICATE_SYM 357
#define DYNAMIC_SYM 358
#define EACH_SYM 359
#define ELSE 360
#define ELSEIF_SYM 361
#define ENABLE_SYM 362
#define ENCLOSED 363
#define END 364
#define ENDS_SYM 365
#define END_OF_INPUT 366
#define ENGINE_SYM 367
#define ENUM_SYM 368
#define EQ 369
#define EQUAL_SYM 370
#define ERRORS 371
#define ESCAPED 372
#define ESCAPE_SYM 373
#define EXCLUSIVE_SYM 374
#define EXISTS 375
#define EXTENDED_SYM 376
#define EXTRACT_SYM 377
#define FALSE_SYM 378
#define FETCH_SYM 379
#define COLUMN_FORMAT_SYM 380
#define FILE_SYM 381
#define FIRST_SYM 382
#define FIXED_SYM 383
#define FLOAT_NUM 384
#define FLUSH_SYM 385
#define FORCE_SYM 386
#define FOREIGN 387
#define FOR_SYM 388
#define FOUND_SYM 389
#define FRAC_SECOND_SYM 390
#define FROM 391
#define FULL 392
#define GE 393
#define GLOBAL_SYM 394
#define GROUP_SYM 395
#define GROUP_CONCAT_SYM 396
#define GT_SYM 397
#define HASH_SYM 398
#define HAVING 399
#define HEX_NUM 400
#define HOUR_MICROSECOND_SYM 401
#define HOUR_MINUTE_SYM 402
#define HOUR_SECOND_SYM 403
#define HOUR_SYM 404
#define IDENT 405
#define IDENTIFIED_SYM 406
#define IDENT_QUOTED 407
#define IF 408
#define IGNORE_SYM 409
#define IMPORT 410
#define INDEXES 411
#define INDEX_SYM 412
#define INFILE 413
#define INNER_SYM 414
#define INOUT_SYM 415
#define INSENSITIVE_SYM 416
#define INSERT 417
#define INTERVAL_SYM 418
#define INTO 419
#define INT_SYM 420
#define IN_SYM 421
#define IS 422
#define ISOLATION 423
#define ITERATE_SYM 424
#define JOIN_SYM 425
#define KEYS 426
#define KEY_BLOCK_SIZE 427
#define KEY_SYM 428
#define KILL_SYM 429
#define LAST_SYM 430
#define LE 431
#define LEADING 432
#define LEFT 433
#define LEVEL_SYM 434
#define LEX_HOSTNAME 435
#define LIKE 436
#define LIMIT 437
#define LINES 438
#define LIST_SYM 439
#define LOAD 440
#define LOCAL_SYM 441
#define LOCATOR_SYM 442
#define LOCKS_SYM 443
#define LOCK_SYM 444
#define LOGS_SYM 445
#define LONG_NUM 446
#define LONG_SYM 447
#define LOOP_SYM 448
#define LT 449
#define MATCH 450
#define MAX_ROWS 451
#define MAX_SIZE_SYM 452
#define MAX_SYM 453
#define MAX_VALUE_SYM 454
#define MEDIUM_SYM 455
#define MERGE_SYM 456
#define MICROSECOND_SYM 457
#define MINUTE_MICROSECOND_SYM 458
#define MINUTE_SECOND_SYM 459
#define MINUTE_SYM 460
#define MIN_ROWS 461
#define MIN_SYM 462
#define MODE_SYM 463
#define MODIFIES_SYM 464
#define MODIFY_SYM 465
#define MOD_SYM 466
#define MONTH_SYM 467
#define NAMES_SYM 468
#define NAME_SYM 469
#define NATIONAL_SYM 470
#define NATURAL 471
#define NE 472
#define NEG 473
#define NEW_SYM 474
#define NEXT_SYM 475
#define NONE_SYM 476
#define NOT_SYM 477
#define NOW_SYM 478
#define NO_SYM 479
#define NULL_SYM 480
#define NUM 481
#define NUMERIC_SYM 482
#define OFFLINE_SYM 483
#define OFFSET_SYM 484
#define ON 485
#define ONE_SHOT_SYM 486
#define ONE_SYM 487
#define ONLINE_SYM 488
#define OPEN_SYM 489
#define OPTIMIZE 490
#define OPTION 491
#define OPTIONALLY 492
#define ORDER_SYM 493
#define OR_SYM 494
#define OUTER 495
#define OUTFILE 496
#define OUT_SYM 497
#define PAGE_SYM 498
#define PARTIAL 499
#define PHASE_SYM 500
#define POSITION_SYM 501
#define PRECISION 502
#define PREV_SYM 503
#define PRIMARY_SYM 504
#define PROCESS 505
#define PROCESSLIST_SYM 506
#define QUARTER_SYM 507
#define QUERY_SYM 508
#define RANGE_SYM 509
#define READS_SYM 510
#define READ_ONLY_SYM 511
#define READ_SYM 512
#define READ_WRITE_SYM 513
#define REAL 514
#define REDUNDANT_SYM 515
#define REFERENCES 516
#define RELEASE_SYM 517
#define RENAME 518
#define REPEATABLE_SYM 519
#define REPEAT_SYM 520
#define REPLACE 521
#define RESTRICT 522
#define RETURNS_SYM 523
#define RETURN_SYM 524
#define REVERSE_SYM 525
#define REVOKE 526
#define RIGHT 527
#define ROLLBACK_SYM 528
#define ROLLUP_SYM 529
#define ROUTINE_SYM 530
#define ROWS_SYM 531
#define ROW_FORMAT_SYM 532
#define ROW_SYM 533
#define SAVEPOINT_SYM 534
#define SECOND_MICROSECOND_SYM 535
#define SECOND_SYM 536
#define SECURITY_SYM 537
#define SELECT_SYM 538
#define SENSITIVE_SYM 539
#define SEPARATOR_SYM 540
#define SERIALIZABLE_SYM 541
#define SERIAL_SYM 542
#define SESSION_SYM 543
#define SERVER_SYM 544
#define SERVER_OPTIONS 545
#define SET 546
#define SET_VAR 547
#define SHARE_SYM 548
#define SHOW 549
#define SHUTDOWN 550
#define SIMPLE_SYM 551
#define SNAPSHOT_SYM 552
#define SPECIFIC_SYM 553
#define SQLEXCEPTION_SYM 554
#define SQLSTATE_SYM 555
#define SQLWARNING_SYM 556
#define SQL_BIG_RESULT 557
#define SQL_BUFFER_RESULT 558
#define SQL_CALC_FOUND_ROWS 559
#define SQL_SMALL_RESULT 560
#define SQL_SYM 561
#define STARTING 562
#define START_SYM 563
#define STATUS_SYM 564
#define STDDEV_SAMP_SYM 565
#define STD_SYM 566
#define STOP_SYM 567
#define STORAGE_SYM 568
#define STORED_SYM 569
#define STRAIGHT_JOIN 570
#define STRING_SYM 571
#define SUBDATE_SYM 572
#define SUBJECT_SYM 573
#define SUBSTRING 574
#define SUM_SYM 575
#define SUSPEND_SYM 576
#define SWAPS_SYM 577
#define SWITCHES_SYM 578
#define SYSDATE 579
#define TABLES 580
#define TABLESPACE 581
#define TABLE_REF_PRIORITY 582
#define TABLE_SYM 583
#define TEMPORARY_SYM 584
#define TERMINATED 585
#define TEXT_STRING 586
#define TEXT_SYM 587
#define THEN_SYM 588
#define TIMESTAMP_SYM 589
#define TIMESTAMP_ADD 590
#define TIMESTAMP_DIFF 591
#define TO_SYM 592
#define TRAILING 593
#define TRANSACTION_SYM 594
#define TRIM 595
#define TRUE_SYM 596
#define TRUNCATE_SYM 597
#define TYPES_SYM 598
#define TYPE_SYM 599
#define ULONGLONG_NUM 600
#define UNCOMMITTED_SYM 601
#define UNDOFILE_SYM 602
#define UNDO_SYM 603
#define UNION_SYM 604
#define UNIQUE_SYM 605
#define UNKNOWN_SYM 606
#define UNLOCK_SYM 607
#define UPDATE_SYM 608
#define USAGE 609
#define USER 610
#define USE_SYM 611
#define USING 612
#define UTC_DATE_SYM 613
#define UTC_TIMESTAMP_SYM 614
#define VALUES 615
#define VALUE_SYM 616
#define VARBINARY 617
#define VARCHAR_SYM 618
#define VARIABLES 619
#define VARIANCE_SYM 620
#define VARYING 621
#define VAR_SAMP_SYM 622
#define WARNINGS 623
#define WEEK_SYM 624
#define WHEN_SYM 625
#define WHERE 626
#define WITH 627
#define WITH_ROLLUP_SYM 628
#define WORK_SYM 629
#define WRITE_SYM 630
#define XOR 631
#define YEAR_MONTH_SYM 632
#define YEAR_SYM 633




/* Copy the first part of user declarations.  */
#line 23 "sql_yacc.yy"

/* session is passed as an argument to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (Session*) when used.
** Use the YYSession macro for this.
*/
#define YYPARSE_PARAM yysession
#define YYLEX_PARAM yysession
#define YYSession (static_cast<Session *>(yysession))

#define YYENABLE_NLS 0
#define YYLTYPE_IS_TRIVIAL 0

#define DRIZZLE_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (YYSession->lex)

#include "config.h"
#include "drizzled/parser.h"

int yylex(void *yylval, void *yysession);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (drizzled::my_yyoverflow((B), (D), &val)) \
    {                                         \
      yyerror((char*) (A));                   \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define DRIZZLE_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYSession);\
    YYABORT;                                  \
  } while (0)

#define DRIZZLE_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    DRIZZLE_YYABORT;                      \
  }


#define YYDEBUG 0

namespace drizzled
{

class Table_ident;
class Item;
class Item_num;


static bool check_reserved_words(LEX_STRING *name)
{
  if (!my_strcasecmp(system_charset_info, name->str, "GLOBAL") ||
      !my_strcasecmp(system_charset_info, name->str, "LOCAL") ||
      !my_strcasecmp(system_charset_info, name->str, "SESSION"))
    return true;
  return false;
}

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

static void my_parse_error(const char *s)
{
  Session *session= current_session;
  Lex_input_stream *lip= session->m_lip;

  const char *yytext= lip->get_tok_start();
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use DRIZZLE_YYABORT/DRIZZLE_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup.
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and DRIZZLE_YYABORT
  to abort from the parser.
*/

static void DRIZZLEerror(const char *s)
{
  Session *session= current_session;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the Session.
  */
  LEX::cleanup_lex_after_parse_error(session);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param session the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
static Item* handle_sql2003_note184_exception(Session *session,
                                              Item* left, bool equal,
                                              Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      Select_Lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (session->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(session, result);

      return(result);
    }
  }

  if (equal)
    result= new (session->mem_root) Item_func_eq(left, expr);
  else
    result= new (session->mem_root) Item_func_ne(left, expr);

  return(result);
}

/**
   @brief Creates a new Select_Lex for a UNION branch.

   Sets up and initializes a Select_Lex structure for a query once the parser
   discovers a UNION token. The current Select_Lex is pushed on the stack and
   the new Select_Lex becomes the current one..=

   @lex The parser state.

   @is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
static bool add_select_to_union_list(LEX *lex, bool is_union_distinct)
{
  if (lex->result)
  {
    /* Only the last SELECT can have  INTO...... */
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return true;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return true;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return true;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return false;
}

/**
   @brief Initializes a Select_Lex for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
static bool setup_select_in_parentheses(LEX *lex)
{
  Select_Lex * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return true;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return true;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return true;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return false;
}

static Item* reserved_keyword_function(const std::string &name, List<Item> *item_list)
{
  const plugin::Function *udf= plugin::Function::get(name.c_str(), name.length());
  Item *item= NULL;

  if (udf)
  {
    item= Create_udf_func::s_singleton.create(current_session, udf, item_list);
  } else {
    my_error(ER_SP_DOES_NOT_EXIST, MYF(0), "FUNCTION", name.c_str());
  }

  return item;
}

} /* namespace drizzled; */

using namespace drizzled;


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
#line 323 "sql_yacc.yy"
{
  int  num;
  ulong ulong_num;
  uint64_t ulonglong_number;
  int64_t longlong_number;
  drizzled::LEX_STRING lex_str;
  drizzled::LEX_STRING *lex_str_ptr;
  drizzled::LEX_SYMBOL symbol;
  drizzled::Table_ident *table;
  char *simple_string;
  drizzled::Item *item;
  drizzled::Item_num *item_num;
  drizzled::List<drizzled::Item> *item_list;
  drizzled::List<drizzled::String> *string_list;
  drizzled::String *string;
  drizzled::Key_part_spec *key_part;
  const drizzled::plugin::Function *udf;
  drizzled::TableList *table_list;
  struct drizzled::sys_var_with_base variable;
  enum drizzled::sql_var_t var_type;
  drizzled::Key::Keytype key_type;
  enum drizzled::ha_key_alg key_alg;
  enum drizzled::row_type row_type;
  enum drizzled::column_format_type column_format_type;
  enum drizzled::ha_rkey_function ha_rkey_mode;
  enum drizzled::enum_tx_isolation tx_isolation;
  enum drizzled::Cast_target cast_type;
  const drizzled::CHARSET_INFO *charset;
  drizzled::thr_lock_type lock_type;
  drizzled::interval_type interval, interval_time_st;
  enum drizzled::enum_drizzle_timestamp_type date_time_type;
  drizzled::Select_Lex *select_lex;
  drizzled::chooser_compare_func_creator boolfunc2creator;
  struct drizzled::st_lex *lex;
  enum drizzled::index_hint_type index_hint;
  enum drizzled::enum_filetype filetype;
  enum drizzled::ha_build_method build_method;
  enum drizzled::Foreign_key::fk_option m_fk_option;
}
/* Line 193 of yacc.c.  */
#line 1201 "drizzled/sql_yacc.cc"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 363 "sql_yacc.yy"

namespace drizzled
{
bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);
}


/* Line 216 of yacc.c.  */
#line 1220 "drizzled/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  280
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   17687

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  392
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  401
/* YYNRULES -- Number of rules.  */
#define YYNRULES  1133
/* YYNRULES -- Number of states.  */
#define YYNSTATES  1951

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   633

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   387,     2,     2,     2,   383,     2,     2,
     384,   385,   381,   380,   386,   379,   390,   382,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   391,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   388,     2,   389,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    65,    73,    74,    88,    89,    96,    99,
     102,   106,   111,   116,   117,   122,   123,   124,   130,   131,
     139,   140,   141,   148,   149,   151,   152,   154,   155,   157,
     158,   162,   163,   165,   167,   170,   172,   175,   179,   183,
     187,   191,   195,   199,   201,   205,   210,   215,   217,   219,
     221,   223,   225,   227,   229,   231,   233,   235,   237,   240,
     242,   246,   248,   250,   253,   256,   264,   273,   282,   285,
     288,   289,   291,   294,   295,   297,   300,   301,   305,   308,
     310,   313,   318,   320,   325,   330,   332,   334,   336,   338,
     340,   343,   346,   349,   350,   356,   358,   360,   363,   365,
     367,   369,   371,   373,   376,   377,   381,   383,   389,   390,
     394,   395,   397,   398,   400,   403,   405,   407,   410,   413,
     416,   421,   423,   427,   430,   432,   435,   438,   441,   444,
     446,   448,   450,   452,   453,   455,   456,   458,   464,   465,
     469,   473,   475,   476,   479,   482,   485,   486,   490,   494,
     501,   508,   510,   512,   515,   518,   521,   523,   526,   529,
     531,   533,   534,   536,   538,   540,   542,   543,   545,   546,
     548,   551,   552,   554,   556,   559,   562,   565,   567,   571,
     574,   576,   578,   583,   586,   588,   593,   594,   596,   597,
     600,   602,   606,   607,   615,   616,   622,   623,   625,   626,
     629,   632,   634,   635,   637,   639,   641,   645,   648,   652,
     655,   660,   661,   668,   669,   670,   678,   682,   687,   691,
     695,   698,   701,   708,   714,   718,   722,   724,   726,   728,
     729,   731,   732,   734,   735,   738,   740,   741,   743,   745,
     747,   751,   752,   756,   757,   762,   763,   768,   769,   774,
     775,   780,   782,   786,   790,   792,   795,   800,   803,   807,
     810,   814,   815,   819,   820,   821,   828,   831,   833,   835,
     838,   841,   849,   850,   852,   855,   857,   859,   861,   863,
     865,   867,   869,   871,   872,   875,   880,   884,   886,   888,
     892,   897,   898,   899,   900,   903,   906,   908,   910,   911,
     914,   918,   922,   926,   929,   933,   938,   942,   947,   951,
     956,   958,   962,   967,   971,   975,   982,   984,   990,   997,
    1003,  1011,  1018,  1027,  1033,  1040,  1045,  1051,  1053,  1057,
    1061,  1067,  1073,  1077,  1081,  1085,  1089,  1093,  1095,  1097,
    1099,  1101,  1103,  1105,  1107,  1109,  1111,  1113,  1115,  1117,
    1119,  1121,  1123,  1125,  1127,  1131,  1133,  1135,  1137,  1140,
    1143,  1147,  1151,  1157,  1164,  1169,  1174,  1177,  1184,  1190,
    1197,  1202,  1207,  1213,  1218,  1221,  1226,  1231,  1236,  1247,
    1254,  1263,  1270,  1275,  1280,  1287,  1292,  1297,  1302,  1310,
    1318,  1326,  1333,  1340,  1347,  1354,  1358,  1363,  1370,  1379,
    1382,  1391,  1400,  1407,  1410,  1415,  1422,  1429,  1438,  1447,
    1454,  1463,  1470,  1473,  1478,  1487,  1496,  1499,  1502,  1507,
    1512,  1516,  1525,  1530,  1537,  1542,  1549,  1558,  1563,  1570,
    1571,  1577,  1578,  1580,  1582,  1586,  1591,  1596,  1602,  1608,
    1613,  1614,  1615,  1623,  1628,  1634,  1639,  1645,  1650,  1655,
    1660,  1665,  1670,  1676,  1677,  1686,  1687,  1691,  1695,  1697,
    1702,  1703,  1705,  1706,  1709,  1710,  1712,  1713,  1717,  1720,
    1723,  1725,  1727,  1730,  1732,  1736,  1737,  1739,  1740,  1743,
    1748,  1754,  1756,  1758,  1760,  1762,  1767,  1769,  1773,  1777,
    1781,  1782,  1789,  1790,  1797,  1798,  1807,  1812,  1813,  1822,
    1823,  1834,  1841,  1842,  1851,  1852,  1863,  1870,  1872,  1875,
    1878,  1879,  1884,  1888,  1894,  1898,  1899,  1900,  1909,  1911,
    1912,  1913,  1920,  1921,  1925,  1926,  1927,  1933,  1934,  1936,
    1937,  1939,  1940,  1943,  1947,  1951,  1953,  1955,  1956,  1964,
    1965,  1973,  1975,  1978,  1979,  1980,  1983,  1984,  1987,  1988,
    1990,  1992,  1994,  1996,  2000,  2002,  2006,  2008,  2010,  2012,
    2014,  2016,  2018,  2020,  2022,  2024,  2026,  2028,  2030,  2032,
    2034,  2036,  2038,  2040,  2042,  2044,  2046,  2048,  2050,  2052,
    2053,  2055,  2057,  2058,  2061,  2062,  2064,  2065,  2066,  2070,
    2071,  2072,  2076,  2079,  2080,  2081,  2086,  2091,  2094,  2095,
    2097,  2101,  2105,  2107,  2110,  2111,  2113,  2114,  2119,  2124,
    2127,  2128,  2130,  2132,  2133,  2135,  2136,  2138,  2141,  2143,
    2147,  2151,  2153,  2155,  2157,  2158,  2161,  2163,  2165,  2167,
    2169,  2171,  2173,  2175,  2177,  2179,  2181,  2183,  2184,  2187,
    2191,  2193,  2196,  2197,  2201,  2202,  2208,  2211,  2213,  2219,
    2220,  2228,  2233,  2235,  2239,  2241,  2242,  2245,  2246,  2248,
    2249,  2250,  2258,  2259,  2260,  2266,  2269,  2271,  2273,  2275,
    2279,  2284,  2285,  2289,  2293,  2295,  2298,  2301,  2302,  2306,
    2307,  2313,  2317,  2319,  2323,  2325,  2329,  2331,  2333,  2334,
    2336,  2337,  2342,  2343,  2345,  2349,  2351,  2353,  2355,  2356,
    2357,  2364,  2365,  2366,  2377,  2381,  2383,  2387,  2391,  2393,
    2397,  2398,  2403,  2404,  2411,  2412,  2415,  2417,  2421,  2422,
    2424,  2425,  2429,  2432,  2436,  2441,  2447,  2453,  2459,  2465,
    2468,  2471,  2475,  2477,  2481,  2486,  2490,  2491,  2494,  2496,
    2498,  2499,  2502,  2505,  2506,  2511,  2512,  2517,  2519,  2521,
    2522,  2524,  2525,  2527,  2529,  2530,  2534,  2538,  2540,  2541,
    2545,  2550,  2552,  2554,  2555,  2557,  2561,  2562,  2564,  2566,
    2569,  2570,  2571,  2572,  2573,  2592,  2594,  2595,  2597,  2598,
    2600,  2602,  2603,  2606,  2609,  2611,  2615,  2620,  2624,  2628,
    2629,  2632,  2635,  2637,  2641,  2645,  2646,  2650,  2652,  2654,
    2655,  2659,  2662,  2666,  2668,  2670,  2673,  2674,  2677,  2679,
    2682,  2684,  2686,  2688,  2690,  2693,  2696,  2698,  2700,  2702,
    2704,  2706,  2708,  2710,  2713,  2716,  2718,  2720,  2722,  2724,
    2726,  2728,  2730,  2734,  2740,  2742,  2744,  2746,  2748,  2750,
    2754,  2759,  2765,  2767,  2773,  2777,  2780,  2782,  2786,  2789,
    2791,  2793,  2795,  2797,  2799,  2801,  2803,  2805,  2807,  2809,
    2811,  2813,  2815,  2817,  2819,  2821,  2823,  2825,  2827,  2829,
    2831,  2833,  2835,  2837,  2839,  2841,  2843,  2845,  2847,  2849,
    2851,  2853,  2855,  2857,  2859,  2861,  2863,  2865,  2867,  2869,
    2871,  2873,  2875,  2877,  2879,  2881,  2883,  2885,  2887,  2889,
    2891,  2893,  2895,  2897,  2899,  2901,  2903,  2905,  2907,  2909,
    2911,  2913,  2915,  2917,  2919,  2921,  2923,  2925,  2927,  2929,
    2931,  2933,  2935,  2937,  2939,  2941,  2943,  2945,  2947,  2949,
    2951,  2953,  2955,  2957,  2959,  2961,  2963,  2965,  2967,  2969,
    2971,  2973,  2975,  2977,  2979,  2981,  2983,  2985,  2987,  2989,
    2991,  2993,  2995,  2997,  2999,  3001,  3003,  3005,  3007,  3009,
    3011,  3013,  3015,  3017,  3019,  3021,  3023,  3025,  3027,  3029,
    3031,  3033,  3035,  3037,  3039,  3041,  3043,  3045,  3047,  3049,
    3051,  3053,  3055,  3057,  3059,  3061,  3063,  3065,  3067,  3069,
    3071,  3073,  3075,  3077,  3079,  3081,  3083,  3085,  3087,  3089,
    3091,  3093,  3095,  3097,  3099,  3101,  3103,  3105,  3107,  3109,
    3111,  3113,  3115,  3117,  3119,  3121,  3123,  3125,  3127,  3129,
    3131,  3133,  3135,  3137,  3138,  3143,  3144,  3146,  3148,  3152,
    3153,  3156,  3158,  3160,  3162,  3164,  3165,  3167,  3168,  3170,
    3172,  3174,  3175,  3178,  3181,  3184,  3186,  3189,  3194,  3200,
    3205,  3212,  3214,  3217,  3220,  3223,  3225,  3227,  3229,  3231,
    3233,  3235,  3237,  3239,  3240,  3244,  3245,  3249,  3250,  3252,
    3253,  3257,  3260,  3261,  3263,  3266,  3267,  3269,  3274,  3279,
    3285,  3288,  3292,  3293,  3295,  3296,  3301,  3302,  3304,  3306,
    3307,  3310,  3313,  3315,  3316,  3318,  3320,  3323,  3327,  3329,
    3330,  3336,  3340,  3341
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     393,     0,    -1,   111,    -1,   394,   111,    -1,   395,    -1,
     769,    -1,   475,    -1,   495,    -1,   497,    -1,   493,    -1,
     775,    -1,   396,    -1,   680,    -1,   694,    -1,   641,    -1,
     700,    -1,   647,    -1,   706,    -1,   709,    -1,   778,    -1,
     499,    -1,   650,    -1,   776,    -1,   777,    -1,   503,    -1,
     750,    -1,   688,    -1,   491,    -1,   686,    -1,   767,    -1,
     673,    -1,   708,    -1,    -1,    67,   411,   328,   412,   741,
     397,   400,    -1,    -1,    67,   480,   398,   462,   157,   746,
     464,   230,   741,   384,   470,   385,   465,    -1,    -1,    67,
      73,   412,   746,   399,   410,    -1,   384,   401,    -1,   413,
     403,    -1,   181,   741,   413,    -1,   384,   181,   741,   385,
      -1,   422,   385,   413,   403,    -1,    -1,   406,   385,   402,
     782,    -1,    -1,    -1,   716,   409,   406,   404,   779,    -1,
      -1,   716,   409,   384,   406,   385,   405,   782,    -1,    -1,
      -1,   283,   407,   514,   518,   408,   421,    -1,    -1,    14,
      -1,    -1,   418,    -1,    -1,   329,    -1,    -1,   153,   530,
     120,    -1,    -1,   415,    -1,   416,    -1,   416,   414,    -1,
     416,    -1,   416,   415,    -1,   416,   386,   415,    -1,   112,
     665,   747,    -1,    29,   665,   631,    -1,    53,   665,   743,
      -1,    18,   665,   632,    -1,   277,   665,   420,    -1,   417,
      -1,   172,   665,   631,    -1,   449,    49,   665,   448,    -1,
     449,    49,   665,   448,    -1,    90,    -1,   128,    -1,   103,
      -1,    90,    -1,   128,    -1,   103,    -1,    57,    -1,   260,
      -1,    56,    -1,   243,    -1,   626,    -1,   513,   517,    -1,
     423,    -1,   422,   386,   423,    -1,   424,    -1,   425,    -1,
     430,   426,    -1,   430,   451,    -1,   457,   472,   464,   384,
     470,   385,   465,    -1,   428,   458,   472,   464,   384,   470,
     385,   465,    -1,   428,   132,   173,   472,   384,   470,   385,
     451,    -1,   429,   426,    -1,   428,   427,    -1,    -1,   427,
      -1,    46,   524,    -1,    -1,   429,    -1,    62,   472,    -1,
      -1,   740,   431,   432,    -1,   433,   443,    -1,   437,    -1,
     438,   442,    -1,   435,   384,   226,   385,    -1,   435,    -1,
     436,   384,   226,   385,    -1,   362,   384,   226,   385,    -1,
      80,    -1,   334,    -1,    77,    -1,    28,    -1,   332,    -1,
      88,   439,    -1,   227,   439,    -1,   128,   439,    -1,    -1,
     113,   434,   384,   474,   385,    -1,   287,    -1,    44,    -1,
     435,   366,    -1,   363,    -1,   165,    -1,    24,    -1,   259,
      -1,    99,    -1,    99,   247,    -1,    -1,   384,   226,   385,
      -1,   440,    -1,   384,   226,   386,   226,   385,    -1,    -1,
     384,   226,   385,    -1,    -1,   440,    -1,    -1,   444,    -1,
     444,   445,    -1,   445,    -1,   225,    -1,   125,   419,    -1,
     530,   225,    -1,    90,   446,    -1,   230,   353,   223,   523,
      -1,    18,    -1,   287,    90,   361,    -1,   450,   173,    -1,
     350,    -1,   350,   173,    -1,    53,   743,    -1,    49,   447,
      -1,   223,   523,    -1,   731,    -1,   747,    -1,   447,    -1,
      90,    -1,    -1,    90,    -1,    -1,   249,    -1,   261,   741,
     452,   454,   455,    -1,    -1,   384,   453,   385,    -1,   453,
     386,   746,    -1,   746,    -1,    -1,   195,   137,    -1,   195,
     244,    -1,   195,   296,    -1,    -1,   230,   353,   456,    -1,
     230,    91,   456,    -1,   230,   353,   456,   230,    91,   456,
      -1,   230,    91,   456,   230,   353,   456,    -1,   267,    -1,
      38,    -1,   291,   225,    -1,   224,     4,    -1,   291,    90,
      -1,   459,    -1,   249,   173,    -1,   350,   460,    -1,   173,
      -1,   157,    -1,    -1,   459,    -1,   171,    -1,   157,    -1,
     156,    -1,    -1,   350,    -1,    -1,   463,    -1,   463,   467,
      -1,    -1,   466,    -1,   468,    -1,   466,   468,    -1,   357,
     469,    -1,   344,   469,    -1,   467,    -1,   172,   665,   631,
      -1,    53,   743,    -1,    34,    -1,   143,    -1,   470,   386,
     471,   624,    -1,   471,   624,    -1,   746,    -1,   746,   384,
     226,   385,    -1,    -1,   740,    -1,    -1,   390,   746,    -1,
     730,    -1,   474,   386,   730,    -1,    -1,    10,   480,   488,
     328,   741,   476,   479,    -1,    -1,    10,    73,   478,   477,
     418,    -1,    -1,   746,    -1,    -1,    96,   326,    -1,   155,
     326,    -1,   481,    -1,    -1,   233,    -1,   228,    -1,   483,
      -1,   481,   386,   483,    -1,     5,   487,    -1,   482,   424,
     489,    -1,     5,   425,    -1,   482,   384,   422,   385,    -1,
      -1,    43,   487,   740,   484,   430,   489,    -1,    -1,    -1,
     210,   487,   740,   485,   432,   486,   489,    -1,   100,   487,
     740,    -1,   100,   132,   173,   472,    -1,   100,   249,   173,
      -1,   100,   459,   740,    -1,    95,   171,    -1,   107,   171,
      -1,    10,   487,   740,   291,    90,   731,    -1,    10,   487,
     740,   100,    90,    -1,   263,   490,   741,    -1,    65,   337,
     448,    -1,   414,    -1,   131,    -1,   617,    -1,    -1,    52,
      -1,    -1,   154,    -1,    -1,     7,   746,    -1,   127,    -1,
      -1,   337,    -1,   114,    -1,    14,    -1,   308,   339,   492,
      -1,    -1,   372,    61,   297,    -1,    -1,    45,   766,   494,
     643,    -1,    -1,    11,   766,   496,   643,    -1,    -1,    46,
     766,   498,   643,    -1,    -1,   263,   766,   500,   501,    -1,
     502,    -1,   501,   386,   502,    -1,   741,   337,   741,    -1,
     504,    -1,   283,   507,    -1,   384,   505,   385,   782,    -1,
     283,   509,    -1,   384,   505,   385,    -1,   283,   578,    -1,
     384,   506,   385,    -1,    -1,   509,   508,   779,    -1,    -1,
      -1,   510,   514,   518,   511,   512,   517,    -1,   620,   626,
      -1,   637,    -1,   513,    -1,   637,   513,    -1,   513,   637,
      -1,   136,   560,   609,   614,   611,   620,   626,    -1,    -1,
     515,    -1,   515,   516,    -1,   516,    -1,   315,    -1,    97,
      -1,   305,    -1,   302,    -1,   303,    -1,   304,    -1,     9,
      -1,    -1,   133,   353,    -1,   189,   166,   293,   208,    -1,
     518,   386,   519,    -1,   519,    -1,   381,    -1,   520,   735,
     521,    -1,   520,   524,   521,   522,    -1,    -1,    -1,    -1,
      14,   746,    -1,    14,   743,    -1,   746,    -1,   743,    -1,
      -1,   384,   385,    -1,   524,   528,   524,    -1,   524,   376,
     524,    -1,   524,   529,   524,    -1,   222,   524,    -1,   525,
     167,   341,    -1,   525,   167,   530,   341,    -1,   525,   167,
     123,    -1,   525,   167,   530,   123,    -1,   525,   167,   351,
      -1,   525,   167,   530,   351,    -1,   525,    -1,   525,   167,
     225,    -1,   525,   167,   530,   225,    -1,   525,   115,   526,
      -1,   525,   531,   526,    -1,   525,   531,   532,   384,   790,
     385,    -1,   526,    -1,   527,   166,   384,   790,   385,    -1,
     527,   530,   166,   384,   790,   385,    -1,   527,   166,   384,
     524,   385,    -1,   527,   166,   384,   524,   386,   555,   385,
      -1,   527,   530,   166,   384,   524,   385,    -1,   527,   530,
     166,   384,   524,   386,   555,   385,    -1,   527,    23,   527,
      12,   526,    -1,   527,   530,    23,   527,    12,   526,    -1,
     527,   181,   533,   613,    -1,   527,   530,   181,   533,   613,
      -1,   527,    -1,   527,   380,   527,    -1,   527,   379,   527,
      -1,   527,   380,   163,   524,   603,    -1,   527,   379,   163,
     524,   603,    -1,   527,   381,   527,    -1,   527,   382,   527,
      -1,   527,   383,   527,    -1,   527,    98,   527,    -1,   527,
     211,   527,    -1,   533,    -1,   239,    -1,    12,    -1,   222,
      -1,   114,    -1,   138,    -1,   142,    -1,   176,    -1,   194,
      -1,   217,    -1,     9,    -1,    13,    -1,   737,    -1,   534,
      -1,   535,    -1,   537,    -1,   536,    -1,   533,    49,   747,
      -1,   732,    -1,   546,    -1,   542,    -1,   380,   533,    -1,
     379,   533,    -1,   384,   790,   385,    -1,   384,   524,   385,
      -1,   384,   524,   386,   555,   385,    -1,   278,   384,   524,
     386,   555,   385,    -1,   120,   384,   790,   385,    -1,   388,
     746,   524,   389,    -1,    25,   533,    -1,    41,   384,   524,
      14,   554,   385,    -1,    40,   556,   558,   557,   109,    -1,
      65,   384,   524,   386,   554,   385,    -1,    90,   384,   737,
     385,    -1,   360,   384,   738,   385,    -1,   163,   524,   603,
     380,   524,    -1,    44,   384,   555,   385,    -1,    71,   523,
      -1,    80,   384,   524,   385,    -1,    85,   384,   524,   385,
      -1,   149,   384,   524,   385,    -1,   162,   384,   524,   386,
     524,   386,   524,   386,   524,   385,    -1,   163,   384,   524,
     386,   524,   385,    -1,   163,   384,   524,   386,   524,   386,
     555,   385,    -1,   178,   384,   524,   386,   524,   385,    -1,
     205,   384,   524,   385,    -1,   212,   384,   524,   385,    -1,
     272,   384,   524,   386,   524,   385,    -1,   281,   384,   524,
     385,    -1,   334,   384,   524,   385,    -1,   340,   384,   524,
     385,    -1,   340,   384,   177,   524,   136,   524,   385,    -1,
     340,   384,   338,   524,   136,   524,   385,    -1,   340,   384,
      33,   524,   136,   524,   385,    -1,   340,   384,   177,   136,
     524,   385,    -1,   340,   384,   338,   136,   524,   385,    -1,
     340,   384,    33,   136,   524,   385,    -1,   340,   384,   524,
     136,   524,   385,    -1,   355,   384,   385,    -1,   378,   384,
     524,   385,    -1,     6,   384,   524,   386,   524,   385,    -1,
       6,   384,   524,   386,   163,   524,   603,   385,    -1,    70,
     523,    -1,    78,   384,   524,   386,   163,   524,   603,   385,
      -1,    79,   384,   524,   386,   163,   524,   603,   385,    -1,
     122,   384,   603,   136,   524,   385,    -1,   223,   523,    -1,
     223,   384,   524,   385,    -1,   246,   384,   527,   166,   524,
     385,    -1,   317,   384,   524,   386,   524,   385,    -1,   317,
     384,   524,   386,   163,   524,   603,   385,    -1,   319,   384,
     524,   386,   524,   386,   524,   385,    -1,   319,   384,   524,
     386,   524,   385,    -1,   319,   384,   524,   136,   524,   133,
     524,   385,    -1,   319,   384,   524,   136,   524,   385,    -1,
     324,   523,    -1,   324,   384,   524,   385,    -1,   335,   384,
     604,   386,   524,   386,   524,   385,    -1,   336,   384,   604,
     386,   524,   386,   524,   385,    -1,   358,   523,    -1,   359,
     523,    -1,    48,   384,   555,   385,    -1,    50,   384,   524,
     385,    -1,    73,   384,   385,    -1,   153,   384,   524,   386,
     524,   386,   524,   385,    -1,   202,   384,   524,   385,    -1,
     211,   384,   524,   386,   524,   385,    -1,   252,   384,   524,
     385,    -1,   265,   384,   524,   386,   524,   385,    -1,   266,
     384,   524,   386,   524,   386,   524,   385,    -1,   270,   384,
     524,   385,    -1,   342,   384,   524,   386,   524,   385,    -1,
      -1,   742,   384,   538,   539,   385,    -1,    -1,   540,    -1,
     541,    -1,   540,   386,   541,    -1,   520,   524,   521,   522,
      -1,    20,   384,   552,   385,    -1,    20,   384,    97,   552,
     385,    -1,    66,   384,   608,   381,   385,    -1,    66,   384,
     552,   385,    -1,    -1,    -1,    66,   384,    97,   543,   555,
     544,   385,    -1,   207,   384,   552,   385,    -1,   207,   384,
      97,   552,   385,    -1,   198,   384,   552,   385,    -1,   198,
     384,    97,   552,   385,    -1,   311,   384,   552,   385,    -1,
     365,   384,   552,   385,    -1,   310,   384,   552,   385,    -1,
     367,   384,   552,   385,    -1,   320,   384,   552,   385,    -1,
     320,   384,    97,   552,   385,    -1,    -1,   141,   384,   549,
     545,   555,   551,   550,   385,    -1,    -1,   391,   547,   548,
      -1,   747,   292,   524,    -1,   747,    -1,   391,   759,   747,
     473,    -1,    -1,    97,    -1,    -1,   285,   730,    -1,    -1,
     621,    -1,    -1,   608,   553,   524,    -1,    25,   441,    -1,
      44,   441,    -1,    80,    -1,    77,    -1,    88,   439,    -1,
     524,    -1,   555,   386,   524,    -1,    -1,   524,    -1,    -1,
     105,   524,    -1,   370,   524,   333,   524,    -1,   558,   370,
     524,   333,   524,    -1,   572,    -1,   563,    -1,   562,    -1,
     559,    -1,   388,   746,   559,   389,    -1,   561,    -1,   562,
     386,   561,    -1,   559,   571,   559,    -1,   559,   315,   572,
      -1,    -1,   559,   571,   559,   230,   564,   524,    -1,    -1,
     559,   315,   572,   230,   565,   524,    -1,    -1,   559,   571,
     559,   357,   566,   384,   602,   385,    -1,   559,   216,   170,
     572,    -1,    -1,   559,   178,   588,   170,   559,   230,   567,
     524,    -1,    -1,   559,   178,   588,   170,   572,   568,   357,
     384,   602,   385,    -1,   559,   216,   178,   588,   170,   572,
      -1,    -1,   559,   272,   588,   170,   559,   230,   569,   524,
      -1,    -1,   559,   272,   588,   170,   572,   570,   357,   384,
     602,   385,    -1,   559,   216,   272,   588,   170,   572,    -1,
     170,    -1,   159,   170,    -1,    68,   170,    -1,    -1,   573,
     741,   607,   597,    -1,   587,   586,   583,    -1,   384,   586,
     574,   385,   607,    -1,   581,   620,   626,    -1,    -1,    -1,
     574,   349,   786,   575,   787,   576,   620,   626,    -1,   578,
      -1,    -1,    -1,   579,   514,   518,   580,   421,   517,    -1,
      -1,   586,   582,   562,    -1,    -1,    -1,   584,   514,   518,
     585,   421,    -1,    -1,   283,    -1,    -1,   240,    -1,    -1,
     133,   170,    -1,   133,   238,    35,    -1,   133,   140,    35,
      -1,   131,    -1,   154,    -1,    -1,   590,   459,   589,   592,
     384,   601,   385,    -1,    -1,   356,   459,   589,   593,   384,
     599,   385,    -1,   591,    -1,   594,   591,    -1,    -1,    -1,
     596,   594,    -1,    -1,   598,   595,    -1,    -1,   601,    -1,
     746,    -1,   249,    -1,   600,    -1,   601,   386,   600,    -1,
     746,    -1,   602,   386,   746,    -1,   605,    -1,    81,    -1,
      82,    -1,    83,    -1,    84,    -1,   146,    -1,   147,    -1,
     148,    -1,   203,    -1,   204,    -1,   280,    -1,   377,    -1,
     605,    -1,   135,    -1,    85,    -1,   369,    -1,   149,    -1,
     205,    -1,   212,    -1,   252,    -1,   281,    -1,   202,    -1,
     378,    -1,    -1,    14,    -1,   114,    -1,    -1,   606,   746,
      -1,    -1,     9,    -1,    -1,    -1,   371,   610,   524,    -1,
      -1,    -1,   144,   612,   524,    -1,   118,   533,    -1,    -1,
      -1,   140,    35,   615,   616,    -1,   615,   386,   736,   624,
      -1,   736,   624,    -1,    -1,   373,    -1,   238,    35,   618,
      -1,   618,   386,   619,    -1,   619,    -1,   738,   624,    -1,
      -1,   621,    -1,    -1,   238,    35,   622,   623,    -1,   623,
     386,   736,   624,    -1,   736,   624,    -1,    -1,    15,    -1,
      92,    -1,    -1,   627,    -1,    -1,   627,    -1,   182,   628,
      -1,   629,    -1,   629,   386,   629,    -1,   629,   229,   629,
      -1,   345,    -1,   191,    -1,   226,    -1,    -1,   182,   629,
      -1,   226,    -1,   145,    -1,   191,    -1,   345,    -1,    87,
      -1,   129,    -1,   226,    -1,   345,    -1,   191,    -1,    87,
      -1,   129,    -1,    -1,   634,   635,    -1,   635,   386,   636,
      -1,   636,    -1,   391,   747,    -1,    -1,   164,   638,   639,
      -1,    -1,   241,   745,   640,   717,   720,    -1,   101,   745,
      -1,   633,    -1,   100,   646,   766,   645,   643,    -1,    -1,
     100,   480,   157,   746,   230,   741,   642,    -1,   100,    73,
     645,   746,    -1,   644,    -1,   643,   386,   644,    -1,   741,
      -1,    -1,   153,   120,    -1,    -1,   329,    -1,    -1,    -1,
     162,   648,   488,   653,   649,   655,   671,    -1,    -1,    -1,
     266,   651,   653,   652,   655,    -1,   164,   654,    -1,   654,
      -1,   644,    -1,   658,    -1,   384,   385,   658,    -1,   384,
     657,   385,   658,    -1,    -1,   291,   656,   662,    -1,   657,
     386,   734,    -1,   734,    -1,   360,   661,    -1,   361,   661,
      -1,    -1,   406,   659,   779,    -1,    -1,   384,   406,   385,
     660,   782,    -1,   661,   386,   666,    -1,   666,    -1,   662,
     386,   663,    -1,   663,    -1,   738,   664,   670,    -1,   114,
      -1,   292,    -1,    -1,   664,    -1,    -1,   384,   667,   668,
     385,    -1,    -1,   669,    -1,   669,   386,   670,    -1,   670,
      -1,   524,    -1,    90,    -1,    -1,    -1,   230,   102,   672,
     173,   353,   678,    -1,    -1,    -1,   353,   488,   741,   674,
     291,   676,   675,   609,   620,   630,    -1,   676,   386,   677,
      -1,   677,    -1,   738,   664,   670,    -1,   678,   386,   679,
      -1,   679,    -1,   738,   664,   670,    -1,    -1,    91,   681,
     684,   682,    -1,    -1,   136,   741,   683,   609,   620,   630,
      -1,    -1,   685,   684,    -1,   154,    -1,   342,   687,   644,
      -1,    -1,   328,    -1,    -1,   294,   689,   690,    -1,    74,
     693,    -1,   325,   691,   693,    -1,   328,   309,   691,   693,
      -1,    51,   692,   741,   691,   693,    -1,   461,   692,   741,
     691,   609,    -1,    66,   384,   381,   385,   368,    -1,    66,
     384,   381,   385,   116,    -1,   368,   625,    -1,   116,   625,
      -1,   758,   309,   693,    -1,   251,    -1,   758,   364,   693,
      -1,    67,    73,   412,   746,    -1,    67,   328,   741,    -1,
      -1,   692,   746,    -1,   136,    -1,   166,    -1,    -1,   181,
     743,    -1,   371,   524,    -1,    -1,   697,   741,   695,   699,
      -1,    -1,   697,   698,   696,   503,    -1,    92,    -1,    93,
      -1,    -1,   121,    -1,    -1,   730,    -1,   746,    -1,    -1,
     130,   701,   702,    -1,   702,   386,   703,    -1,   703,    -1,
      -1,   766,   704,   705,    -1,   325,   372,   257,   189,    -1,
     190,    -1,   309,    -1,    -1,   643,    -1,   174,   707,   524,
      -1,    -1,    60,    -1,   253,    -1,   356,   746,    -1,    -1,
      -1,    -1,    -1,   185,   714,   710,   715,   158,   745,   711,
     716,   164,   712,   328,   741,   713,   717,   720,   723,   725,
     728,    -1,    76,    -1,    -1,    58,    -1,    -1,   266,    -1,
     154,    -1,    -1,    51,   718,    -1,   718,   719,    -1,   719,
      -1,   330,    35,   730,    -1,   237,   108,    35,   730,    -1,
     108,    35,   730,    -1,   117,    35,   730,    -1,    -1,   183,
     721,    -1,   721,   722,    -1,   722,    -1,   330,    35,   730,
      -1,   307,    35,   730,    -1,    -1,   154,   226,   724,    -1,
     183,    -1,   276,    -1,    -1,   384,   726,   385,    -1,   384,
     385,    -1,   726,   386,   727,    -1,   727,    -1,   738,    -1,
     391,   747,    -1,    -1,   291,   678,    -1,   744,    -1,   729,
     744,    -1,   744,    -1,   145,    -1,    26,    -1,   732,    -1,
     380,   733,    -1,   379,   733,    -1,   729,    -1,   733,    -1,
     225,    -1,   123,    -1,   341,    -1,   145,    -1,    26,    -1,
      80,   729,    -1,   334,   729,    -1,   226,    -1,   191,    -1,
     345,    -1,    87,    -1,   129,    -1,   738,    -1,   735,    -1,
     746,   390,   381,    -1,   746,   390,   746,   390,   381,    -1,
     524,    -1,   746,    -1,   739,    -1,   746,    -1,   739,    -1,
     746,   390,   746,    -1,   390,   746,   390,   746,    -1,   746,
     390,   746,   390,   746,    -1,   746,    -1,   746,   390,   746,
     390,   746,    -1,   746,   390,   746,    -1,   390,   746,    -1,
     746,    -1,   746,   390,   746,    -1,   390,   746,    -1,   150,
      -1,   152,    -1,   331,    -1,   331,    -1,   331,    -1,   742,
      -1,   748,    -1,   746,    -1,   743,    -1,   180,    -1,   749,
      -1,    22,    -1,    36,    -1,    45,    -1,    47,    -1,    53,
      -1,    55,    -1,    63,    -1,    86,    -1,   109,    -1,   130,
      -1,   224,    -1,   234,    -1,   273,    -1,   279,    -1,   282,
      -1,   289,    -1,   308,    -1,   312,    -1,   342,    -1,     4,
      -1,     6,    -1,     7,    -1,     8,    -1,    13,    -1,    17,
      -1,    18,    -1,    19,    -1,    20,    -1,    27,    -1,    29,
      -1,    30,    -1,    32,    -1,    31,    -1,    34,    -1,    39,
      -1,    42,    -1,    48,    -1,    50,    -1,   125,    -1,    51,
      -1,    54,    -1,    56,    -1,    57,    -1,    58,    -1,    60,
      -1,    61,    -1,    69,    -1,    76,    -1,    74,    -1,    75,
      -1,    77,    -1,    80,    -1,    85,    -1,    95,    -1,    96,
      -1,   101,    -1,   102,    -1,   103,    -1,   110,    -1,   113,
      -1,   112,    -1,   116,    -1,   118,    -1,   119,    -1,   121,
      -1,   134,    -1,   107,    -1,   137,    -1,   126,    -1,   127,
      -1,   128,    -1,   135,    -1,   139,    -1,   143,    -1,   149,
      -1,   151,    -1,   155,    -1,   156,    -1,   168,    -1,   172,
      -1,   175,    -1,   179,    -1,   184,    -1,   186,    -1,   188,
      -1,   190,    -1,   196,    -1,   197,    -1,   199,    -1,   200,
      -1,   201,    -1,   202,    -1,   205,    -1,   206,    -1,   210,
      -1,   208,    -1,   212,    -1,   214,    -1,   213,    -1,   215,
      -1,   220,    -1,   219,    -1,   221,    -1,   228,    -1,   229,
      -1,   231,    -1,   232,    -1,   233,    -1,   243,    -1,   244,
      -1,   245,    -1,   248,    -1,   250,    -1,   251,    -1,   252,
      -1,   253,    -1,   256,    -1,   260,    -1,   264,    -1,   268,
      -1,   270,    -1,   274,    -1,   275,    -1,   276,    -1,   277,
      -1,   278,    -1,   281,    -1,   287,    -1,   286,    -1,   288,
      -1,   296,    -1,   293,    -1,   295,    -1,   297,    -1,   303,
      -1,   309,    -1,   313,    -1,   316,    -1,   317,    -1,   318,
      -1,   321,    -1,   322,    -1,   323,    -1,   325,    -1,   326,
      -1,   329,    -1,   332,    -1,   339,    -1,   334,    -1,   335,
      -1,   336,    -1,   343,    -1,   344,    -1,   346,    -1,   347,
      -1,   351,    -1,   355,    -1,   364,    -1,   361,    -1,   368,
      -1,   369,    -1,   374,    -1,   378,    -1,    -1,   291,   752,
     751,   753,    -1,    -1,   236,    -1,   754,    -1,   753,   386,
     754,    -1,    -1,   755,   760,    -1,   757,    -1,   139,    -1,
     186,    -1,   288,    -1,    -1,   231,    -1,    -1,   139,    -1,
     186,    -1,   288,    -1,    -1,   139,   390,    -1,   186,   390,
      -1,   288,   390,    -1,   761,    -1,   757,   762,    -1,   756,
     763,   664,   765,    -1,   756,   339,   168,   179,   764,    -1,
     391,   747,   664,   524,    -1,   391,   391,   759,   763,   664,
     765,    -1,   746,    -1,   257,   346,    -1,   257,    54,    -1,
     264,   257,    -1,   286,    -1,   524,    -1,    90,    -1,   230,
      -1,     9,    -1,    25,    -1,   328,    -1,   325,    -1,    -1,
     352,   768,   766,    -1,    -1,    22,   770,   771,    -1,    -1,
     374,    -1,    -1,    12,   224,    42,    -1,    12,    42,    -1,
      -1,   262,    -1,   224,   262,    -1,    -1,   279,    -1,    55,
     771,   772,   773,    -1,   273,   771,   772,   773,    -1,   273,
     771,   337,   774,   746,    -1,   279,   746,    -1,   262,   279,
     746,    -1,    -1,   780,    -1,    -1,   349,   786,   781,   504,
      -1,    -1,   780,    -1,   783,    -1,    -1,   784,   785,    -1,
     621,   625,    -1,   627,    -1,    -1,    97,    -1,     9,    -1,
     283,   577,    -1,   384,   506,   385,    -1,   787,    -1,    -1,
     788,   349,   786,   789,   787,    -1,   791,   788,   792,    -1,
      -1,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   962,   962,   979,   983,   984,   989,   990,   991,   992,
     993,   994,   995,   996,   997,   998,   999,  1000,  1001,  1002,
    1003,  1004,  1005,  1006,  1007,  1008,  1009,  1010,  1011,  1012,
    1013,  1014,  1021,  1020,  1054,  1053,  1081,  1080,  1098,  1099,
    1101,  1111,  1124,  1127,  1126,  1132,  1134,  1133,  1137,  1136,
    1143,  1173,  1142,  1187,  1188,  1192,  1193,  1197,  1198,  1202,
    1203,  1206,  1208,  1212,  1213,  1217,  1218,  1219,  1223,  1233,
    1242,  1249,  1260,  1268,  1269,  1282,  1301,  1311,  1312,  1313,
    1316,  1317,  1318,  1319,  1320,  1321,  1322,  1326,  1327,  1331,
    1332,  1336,  1337,  1341,  1342,  1349,  1358,  1368,  1387,  1391,
    1397,  1399,  1403,  1407,  1408,  1412,  1417,  1416,  1451,  1455,
    1472,  1485,  1503,  1514,  1533,  1554,  1564,  1574,  1584,  1596,
    1607,  1617,  1627,  1638,  1637,  1649,  1667,  1671,  1672,  1676,
    1677,  1681,  1685,  1687,  1693,  1694,  1696,  1701,  1710,  1711,
    1715,  1716,  1720,  1721,  1725,  1726,  1730,  1742,  1749,  1761,
    1768,  1770,  1783,  1798,  1813,  1821,  1829,  1837,  1853,  1855,
    1860,  1871,  1872,  1876,  1877,  1880,  1882,  1886,  1898,  1899,
    1903,  1905,  1915,  1916,  1918,  1920,  1926,  1930,  1935,  1940,
    1946,  1955,  1956,  1957,  1958,  1959,  1963,  1967,  1968,  1972,
    1973,  1977,  1978,  1982,  1983,  1984,  1988,  1989,  1993,  2005,
    2006,  2010,  2011,  2015,  2016,  2020,  2021,  2025,  2026,  2028,
    2033,  2034,  2038,  2039,  2043,  2044,  2056,  2057,  2061,  2062,
    2066,  2067,  2075,  2074,  2099,  2098,  2117,  2118,  2121,  2123,
    2128,  2133,  2138,  2141,  2145,  2152,  2153,  2157,  2167,  2168,
    2174,  2182,  2181,  2189,  2202,  2188,  2217,  2224,  2231,  2239,
    2247,  2254,  2261,  2268,  2275,  2297,  2307,  2313,  2319,  2328,
    2329,  2333,  2334,  2338,  2339,  2346,  2356,  2357,  2358,  2359,
    2363,  2374,  2375,  2384,  2383,  2398,  2397,  2411,  2410,  2425,
    2424,  2436,  2437,  2441,  2459,  2471,  2472,  2476,  2481,  2486,
    2491,  2496,  2495,  2515,  2523,  2515,  2530,  2531,  2532,  2533,
    2534,  2538,  2547,  2549,  2561,  2562,  2566,  2567,  2568,  2569,
    2570,  2576,  2582,  2585,  2587,  2592,  2601,  2602,  2603,  2615,
    2622,  2642,  2650,  2658,  2659,  2660,  2661,  2662,  2666,  2667,
    2672,  2721,  2726,  2767,  2769,  2771,  2773,  2775,  2777,  2779,
    2781,  2785,  2787,  2789,  2791,  2793,  2795,  2799,  2803,  2809,
    2813,  2819,  2823,  2831,  2833,  2839,  2841,  2843,  2847,  2849,
    2851,  2853,  2855,  2857,  2859,  2861,  2863,  2865,  2869,  2873,
    2877,  2881,  2882,  2883,  2884,  2885,  2886,  2890,  2891,  2895,
    2896,  2897,  2898,  2899,  2900,  2908,  2909,  2910,  2911,  2912,
    2914,  2918,  2919,  2924,  2929,  2933,  2934,  2939,  2947,  2949,
    2956,  2961,  2966,  2978,  2980,  2984,  2986,  2988,  2990,  2992,
    3001,  3009,  3011,  3013,  3015,  3017,  3019,  3021,  3023,  3025,
    3027,  3029,  3031,  3033,  3035,  3037,  3041,  3057,  3062,  3064,
    3068,  3070,  3072,  3074,  3078,  3082,  3084,  3089,  3091,  3103,
    3114,  3126,  3137,  3139,  3141,  3143,  3145,  3149,  3161,  3163,
    3165,  3173,  3175,  3177,  3179,  3181,  3183,  3185,  3195,  3209,
    3208,  3256,  3257,  3261,  3266,  3274,  3294,  3296,  3298,  3300,
    3303,  3305,  3302,  3308,  3315,  3317,  3319,  3321,  3323,  3325,
    3327,  3329,  3331,  3334,  3333,  3349,  3348,  3357,  3361,  3365,
    3379,  3380,  3385,  3388,  3393,  3396,  3408,  3407,  3424,  3426,
    3428,  3430,  3432,  3437,  3442,  3450,  3451,  3455,  3456,  3460,
    3466,  3477,  3478,  3487,  3498,  3499,  3505,  3506,  3526,  3528,
    3532,  3530,  3547,  3545,  3563,  3561,  3568,  3577,  3575,  3593,
    3592,  3602,  3613,  3611,  3630,  3629,  3640,  3651,  3652,  3653,
    3665,  3665,  3678,  3718,  3760,  3764,  3769,  3761,  3781,  3801,
    3809,  3801,  3818,  3817,  3840,  3856,  3840,  3863,  3867,  3887,
    3888,  3893,  3896,  3897,  3898,  3902,  3903,  3908,  3907,  3913,
    3912,  3920,  3921,  3924,  3926,  3926,  3930,  3930,  3935,  3936,
    3940,  3942,  3947,  3948,  3952,  3960,  3970,  3971,  3972,  3973,
    3974,  3975,  3976,  3977,  3978,  3979,  3980,  3981,  3985,  3986,
    4004,  4005,  4006,  4007,  4008,  4009,  4010,  4011,  4012,  4015,
    4017,  4018,  4022,  4023,  4027,  4029,  4033,  4035,  4034,  4048,
    4051,  4050,  4065,  4071,  4081,  4083,  4087,  4089,  4094,  4095,
    4120,  4124,  4125,  4129,  4142,  4144,  4149,  4148,  4183,  4185,
    4190,  4191,  4192,  4197,  4203,  4207,  4208,  4212,  4216,  4223,
    4230,  4240,  4241,  4242,  4247,  4251,  4260,  4261,  4262,  4263,
    4264,  4265,  4269,  4270,  4271,  4272,  4273,  4277,  4277,  4287,
    4288,  4292,  4308,  4307,  4314,  4313,  4321,  4332,  4341,  4352,
    4352,  4367,  4379,  4380,  4384,  4392,  4393,  4397,  4398,  4406,
    4418,  4405,  4428,  4438,  4427,  4447,  4448,  4452,  4461,  4462,
    4463,  4465,  4464,  4475,  4476,  4480,  4481,  4483,  4482,  4486,
    4485,  4491,  4492,  4496,  4497,  4501,  4511,  4512,  4516,  4517,
    4522,  4521,  4535,  4536,  4540,  4545,  4553,  4554,  4557,  4559,
    4559,  4567,  4580,  4566,  4600,  4601,  4605,  4613,  4614,  4618,
    4631,  4630,  4647,  4646,  4657,  4658,  4662,  4666,  4678,  4680,
    4687,  4686,  4699,  4736,  4788,  4829,  4871,  4912,  4920,  4928,
    4935,  4942,  4981,  5003,  5042,  5052,  5064,  5065,  5069,  5070,
    5073,  5075,  5082,  5093,  5092,  5134,  5133,  5143,  5144,  5148,
    5149,  5153,  5154,  5155,  5168,  5167,  5181,  5182,  5187,  5186,
    5192,  5197,  5202,  5210,  5211,  5217,  5230,  5231,  5232,  5238,
    5253,  5267,  5276,  5282,  5252,  5298,  5301,  5302,  5309,  5310,
    5311,  5314,  5316,  5320,  5321,  5325,  5330,  5337,  5342,  5349,
    5351,  5355,  5356,  5360,  5365,  5372,  5374,  5382,  5383,  5387,
    5388,  5389,  5393,  5395,  5400,  5401,  5406,  5407,  5413,  5418,
    5425,  5431,  5442,  5455,  5456,  5457,  5465,  5466,  5467,  5472,
    5473,  5474,  5475,  5476,  5477,  5481,  5486,  5491,  5493,  5501,
    5516,  5517,  5521,  5527,  5536,  5540,  5552,  5556,  5566,  5570,
    5590,  5606,  5626,  5627,  5644,  5655,  5659,  5660,  5661,  5665,
    5666,  5684,  5691,  5698,  5705,  5706,  5715,  5716,  5717,  5722,
    5723,  5724,  5725,  5726,  5727,  5728,  5729,  5730,  5731,  5732,
    5733,  5734,  5735,  5736,  5737,  5738,  5739,  5740,  5741,  5751,
    5752,  5753,  5754,  5755,  5756,  5757,  5758,  5759,  5760,  5761,
    5762,  5763,  5764,  5765,  5766,  5767,  5768,  5769,  5770,  5771,
    5772,  5773,  5774,  5775,  5776,  5777,  5778,  5779,  5780,  5781,
    5782,  5783,  5784,  5785,  5786,  5787,  5788,  5789,  5790,  5791,
    5792,  5793,  5794,  5795,  5796,  5797,  5798,  5799,  5800,  5801,
    5802,  5803,  5804,  5805,  5806,  5807,  5808,  5809,  5810,  5811,
    5812,  5813,  5814,  5815,  5816,  5817,  5818,  5819,  5820,  5821,
    5822,  5823,  5824,  5825,  5826,  5827,  5828,  5829,  5830,  5831,
    5832,  5833,  5834,  5835,  5836,  5837,  5838,  5839,  5840,  5841,
    5842,  5843,  5844,  5845,  5846,  5847,  5848,  5849,  5850,  5851,
    5852,  5853,  5854,  5855,  5856,  5857,  5858,  5859,  5860,  5861,
    5862,  5863,  5864,  5865,  5866,  5867,  5868,  5869,  5870,  5871,
    5872,  5873,  5874,  5875,  5876,  5877,  5878,  5879,  5880,  5881,
    5882,  5883,  5884,  5885,  5886,  5887,  5888,  5889,  5890,  5891,
    5892,  5893,  5894,  5901,  5900,  5917,  5918,  5922,  5923,  5927,
    5927,  5935,  5936,  5937,  5938,  5942,  5943,  5947,  5948,  5949,
    5950,  5954,  5955,  5956,  5957,  5961,  5962,  5966,  5978,  5990,
    5994,  6002,  6019,  6020,  6021,  6022,  6026,  6027,  6028,  6029,
    6030,  6034,  6035,  6040,  6039,  6053,  6052,  6064,  6065,  6070,
    6071,  6072,  6077,  6078,  6079,  6083,  6084,  6088,  6102,  6113,
    6126,  6138,  6155,  6156,  6161,  6160,  6176,  6177,  6178,  6182,
    6182,  6206,  6207,  6211,  6212,  6213,  6217,  6221,  6228,  6231,
    6229,  6244,  6251,  6271
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACTION", "ADD",
  "ADDDATE_SYM", "AFTER_SYM", "AGGREGATE_SYM", "ALL", "ALTER",
  "ANALYZE_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC", "ASENSITIVE_SYM",
  "AT_SYM", "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BETWEEN_SYM", "BIGINT_SYM", "BINARY", "BIN_NUM", "BIT_SYM",
  "BLOB_SYM", "BLOCK_SIZE_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM",
  "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CALL_SYM", "CASCADE", "CASCADED",
  "CASE_SYM", "CAST_SYM", "CHAIN_SYM", "CHANGE", "CHAR_SYM",
  "CHECKSUM_SYM", "CHECK_SYM", "CLOSE_SYM", "COALESCE", "COLLATE_SYM",
  "COLLATION_SYM", "COLUMNS", "COLUMN_SYM", "COMMENT_SYM", "COMMITTED_SYM",
  "COMMIT_SYM", "COMPACT_SYM", "COMPRESSED_SYM", "CONCURRENT",
  "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONTAINS_SYM", "CONTINUE_SYM", "CONVERT_SYM", "COUNT_SYM", "CREATE",
  "CROSS", "CUBE_SYM", "CURDATE", "CURRENT_USER", "CURSOR_SYM", "DATABASE",
  "DATABASES", "DATAFILE_SYM", "DATA_SYM", "DATETIME_SYM",
  "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM",
  "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM",
  "DEALLOCATE_SYM", "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT",
  "DELETE_SYM", "DESC", "DESCRIBE", "DETERMINISTIC_SYM", "DISABLE_SYM",
  "DISCARD", "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DROP", "DUMPFILE",
  "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSE", "ELSEIF_SYM",
  "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM", "END_OF_INPUT",
  "ENGINE_SYM", "ENUM_SYM", "EQ", "EQUAL_SYM", "ERRORS", "ESCAPED",
  "ESCAPE_SYM", "EXCLUSIVE_SYM", "EXISTS", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FETCH_SYM", "COLUMN_FORMAT_SYM", "FILE_SYM", "FIRST_SYM",
  "FIXED_SYM", "FLOAT_NUM", "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FOR_SYM",
  "FOUND_SYM", "FRAC_SECOND_SYM", "FROM", "FULL", "GE", "GLOBAL_SYM",
  "GROUP_SYM", "GROUP_CONCAT_SYM", "GT_SYM", "HASH_SYM", "HAVING",
  "HEX_NUM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM", "HOUR_SECOND_SYM",
  "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED", "IF",
  "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE", "INNER_SYM",
  "INOUT_SYM", "INSENSITIVE_SYM", "INSERT", "INTERVAL_SYM", "INTO",
  "INT_SYM", "IN_SYM", "IS", "ISOLATION", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM", "KILL_SYM", "LAST_SYM", "LE",
  "LEADING", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT", "LINES",
  "LIST_SYM", "LOAD", "LOCAL_SYM", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM",
  "LOGS_SYM", "LONG_NUM", "LONG_SYM", "LOOP_SYM", "LT", "MATCH",
  "MAX_ROWS", "MAX_SIZE_SYM", "MAX_SYM", "MAX_VALUE_SYM", "MEDIUM_SYM",
  "MERGE_SYM", "MICROSECOND_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM", "MODE_SYM",
  "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM", "MONTH_SYM", "NAMES_SYM",
  "NAME_SYM", "NATIONAL_SYM", "NATURAL", "NE", "NEG", "NEW_SYM",
  "NEXT_SYM", "NONE_SYM", "NOT_SYM", "NOW_SYM", "NO_SYM", "NULL_SYM",
  "NUM", "NUMERIC_SYM", "OFFLINE_SYM", "OFFSET_SYM", "ON", "ONE_SHOT_SYM",
  "ONE_SYM", "ONLINE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION", "OPTIONALLY",
  "ORDER_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM", "PAGE_SYM",
  "PARTIAL", "PHASE_SYM", "POSITION_SYM", "PRECISION", "PREV_SYM",
  "PRIMARY_SYM", "PROCESS", "PROCESSLIST_SYM", "QUARTER_SYM", "QUERY_SYM",
  "RANGE_SYM", "READS_SYM", "READ_ONLY_SYM", "READ_SYM", "READ_WRITE_SYM",
  "REAL", "REDUNDANT_SYM", "REFERENCES", "RELEASE_SYM", "RENAME",
  "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE", "RESTRICT", "RETURNS_SYM",
  "RETURN_SYM", "REVERSE_SYM", "REVOKE", "RIGHT", "ROLLBACK_SYM",
  "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SERVER_SYM", "SERVER_OPTIONS", "SET",
  "SET_VAR", "SHARE_SYM", "SHOW", "SHUTDOWN", "SIMPLE_SYM", "SNAPSHOT_SYM",
  "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM",
  "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CALC_FOUND_ROWS",
  "SQL_SMALL_RESULT", "SQL_SYM", "STARTING", "START_SYM", "STATUS_SYM",
  "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM", "STORED_SYM",
  "STRAIGHT_JOIN", "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUM_SYM", "SUSPEND_SYM", "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY", "TABLE_SYM",
  "TEMPORARY_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THEN_SYM",
  "TIMESTAMP_SYM", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TO_SYM", "TRAILING",
  "TRANSACTION_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM",
  "TYPE_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDOFILE_SYM",
  "UNDO_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM", "UNLOCK_SYM",
  "UPDATE_SYM", "USAGE", "USER", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR_SYM",
  "VARIABLES", "VARIANCE_SYM", "VARYING", "VAR_SAMP_SYM", "WARNINGS",
  "WEEK_SYM", "WHEN_SYM", "WHERE", "WITH", "WITH_ROLLUP_SYM", "WORK_SYM",
  "WRITE_SYM", "XOR", "YEAR_MONTH_SYM", "YEAR_SYM", "'-'", "'+'", "'*'",
  "'/'", "'%'", "'('", "')'", "','", "'!'", "'{'", "'}'", "'.'", "'@'",
  "$accept", "query", "verb_clause", "statement", "create", "@1", "@2",
  "@3", "create2", "create2a", "@4", "create3", "@5", "@6",
  "create_select", "@7", "@8", "opt_as", "opt_create_database_options",
  "opt_table_options", "opt_if_not_exists", "opt_create_table_options",
  "create_table_options_space_separated", "create_table_options",
  "create_table_option", "default_collation", "default_collation_schema",
  "column_format_types", "row_types", "opt_select_from", "field_list",
  "field_list_item", "column_def", "key_def", "opt_check_constraint",
  "check_constraint", "opt_constraint", "constraint", "field_spec", "@9",
  "field_def", "type", "@10", "char", "varchar", "int_type", "real_type",
  "float_options", "precision", "opt_len", "opt_precision",
  "opt_attribute", "opt_attribute_list", "attribute",
  "now_or_signed_literal", "collation_name", "collation_name_or_default",
  "opt_default", "opt_primary", "references", "opt_ref_list", "ref_list",
  "opt_match_clause", "opt_on_update_delete", "delete_option", "key_type",
  "constraint_key_type", "key_or_index", "opt_key_or_index",
  "keys_or_index", "opt_unique", "init_key_options", "key_alg",
  "key_options", "key_opts", "key_using_alg", "key_opt", "btree_or_rtree",
  "key_list", "key_part", "opt_ident", "opt_component", "string_list",
  "alter", "@11", "@12", "ident_or_empty", "alter_commands",
  "build_method", "alter_list", "add_column", "alter_list_item", "@13",
  "@14", "@15", "opt_column", "opt_ignore", "opt_place", "opt_to", "start",
  "start_transaction_opts", "checksum", "@16", "analyze", "@17", "check",
  "@18", "rename", "@19", "table_to_table_list", "table_to_table",
  "select", "select_init", "select_paren", "select_paren_derived",
  "select_init2", "@20", "select_part2", "@21", "@22", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "optional_braces", "expr", "bool_pri",
  "predicate", "bit_expr", "or", "and", "not", "comp_op", "all_or_any",
  "simple_expr", "function_call_keyword", "function_call_nonkeyword",
  "function_call_conflict", "function_call_generic", "@23",
  "opt_udf_expr_list", "udf_expr_list", "udf_expr", "sum_expr", "@24",
  "@25", "@26", "variable", "@27", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@28",
  "cast_type", "expr_list", "opt_expr", "opt_else", "when_list",
  "table_ref", "join_table_list", "esc_table_ref", "derived_table_list",
  "join_table", "@29", "@30", "@31", "@32", "@33", "@34", "@35",
  "normal_join", "table_factor", "@36", "select_derived_union", "@37",
  "@38", "select_init2_derived", "select_part2_derived", "@39", "@40",
  "select_derived", "@41", "select_derived2", "@42", "@43",
  "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "@44",
  "@45", "index_hints_list", "opt_index_hints_list", "@46",
  "opt_key_definition", "@47", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "interval_time_st", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@48", "having_clause", "@49", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@50", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "select_var_list_init", "@51", "select_var_list",
  "select_var_ident", "into", "@52", "into_destination", "@53", "drop",
  "@54", "table_list", "table_name", "if_exists", "opt_temporary",
  "insert", "@55", "@56", "replace", "@57", "@58", "insert2",
  "insert_table", "insert_field_spec", "@59", "fields", "insert_values",
  "@60", "@61", "values_list", "ident_eq_list", "ident_eq_value", "equal",
  "opt_equal", "no_braces", "@62", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@63", "update", "@64", "@65",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "delete", "@66", "single_multi", "@67", "opt_delete_options",
  "opt_delete_option", "truncate", "opt_table_sym", "show", "@68",
  "show_param", "opt_db", "from_or_in", "show_wild", "describe", "@69",
  "@70", "describe_command", "opt_extended_describe",
  "opt_describe_column", "flush", "@71", "flush_options", "flush_option",
  "@72", "opt_table_list", "kill", "kill_option", "use", "load", "@73",
  "@74", "@75", "@76", "data_file", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines", "lines_or_rows",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "IDENT_sys", "TEXT_STRING_sys",
  "TEXT_STRING_literal", "TEXT_STRING_filesystem", "ident",
  "ident_or_text", "keyword", "keyword_sp", "set", "@77", "opt_option",
  "option_value_list", "option_type_value", "@78", "option_type",
  "option_type2", "opt_var_type", "opt_var_ident_type", "ext_option_value",
  "sys_option_value", "option_value", "internal_variable_name",
  "isolation_types", "set_expr_or_default", "table_or_tables", "unlock",
  "@79", "begin", "@80", "opt_work", "opt_chain", "opt_release",
  "opt_savepoint", "commit", "rollback", "savepoint", "release",
  "union_clause", "union_list", "@81", "union_opt", "union_order_or_limit",
  "@82", "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "@83", "subselect", "subselect_start",
  "subselect_end", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,    45,
      43,    42,    47,    37,    40,    41,    44,    33,   123,   125,
      46,    64
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   392,   393,   393,   394,   394,   395,   395,   395,   395,
     395,   395,   395,   395,   395,   395,   395,   395,   395,   395,
     395,   395,   395,   395,   395,   395,   395,   395,   395,   395,
     395,   395,   397,   396,   398,   396,   399,   396,   400,   400,
     400,   400,   401,   402,   401,   403,   404,   403,   405,   403,
     407,   408,   406,   409,   409,   410,   410,   411,   411,   412,
     412,   413,   413,   414,   414,   415,   415,   415,   416,   416,
     416,   416,   416,   416,   416,   417,   418,   419,   419,   419,
     420,   420,   420,   420,   420,   420,   420,   421,   421,   422,
     422,   423,   423,   424,   424,   425,   425,   425,   425,   425,
     426,   426,   427,   428,   428,   429,   431,   430,   432,   433,
     433,   433,   433,   433,   433,   433,   433,   433,   433,   433,
     433,   433,   433,   434,   433,   433,   435,   436,   436,   437,
     437,   438,   438,   438,   439,   439,   439,   440,   441,   441,
     442,   442,   443,   443,   444,   444,   445,   445,   445,   445,
     445,   445,   445,   445,   445,   445,   445,   445,   446,   446,
     447,   448,   448,   449,   449,   450,   450,   451,   452,   452,
     453,   453,   454,   454,   454,   454,   455,   455,   455,   455,
     455,   456,   456,   456,   456,   456,   457,   458,   458,   459,
     459,   460,   460,   461,   461,   461,   462,   462,   463,   464,
     464,   465,   465,   466,   466,   467,   467,   468,   468,   468,
     469,   469,   470,   470,   471,   471,   472,   472,   473,   473,
     474,   474,   476,   475,   477,   475,   478,   478,   479,   479,
     479,   479,   480,   480,   480,   481,   481,   482,   483,   483,
     483,   484,   483,   485,   486,   483,   483,   483,   483,   483,
     483,   483,   483,   483,   483,   483,   483,   483,   483,   487,
     487,   488,   488,   489,   489,   489,   490,   490,   490,   490,
     491,   492,   492,   494,   493,   496,   495,   498,   497,   500,
     499,   501,   501,   502,   503,   504,   504,   505,   505,   506,
     506,   508,   507,   510,   511,   509,   512,   512,   512,   512,
     512,   513,   514,   514,   515,   515,   516,   516,   516,   516,
     516,   516,   516,   517,   517,   517,   518,   518,   518,   519,
     519,   520,   521,   522,   522,   522,   522,   522,   523,   523,
     524,   524,   524,   524,   524,   524,   524,   524,   524,   524,
     524,   525,   525,   525,   525,   525,   525,   526,   526,   526,
     526,   526,   526,   526,   526,   526,   526,   526,   527,   527,
     527,   527,   527,   527,   527,   527,   527,   527,   528,   529,
     530,   531,   531,   531,   531,   531,   531,   532,   532,   533,
     533,   533,   533,   533,   533,   533,   533,   533,   533,   533,
     533,   533,   533,   533,   533,   533,   533,   533,   533,   533,
     533,   533,   533,   534,   534,   534,   534,   534,   534,   534,
     534,   534,   534,   534,   534,   534,   534,   534,   534,   534,
     534,   534,   534,   534,   534,   534,   534,   535,   535,   535,
     535,   535,   535,   535,   535,   535,   535,   535,   535,   535,
     535,   535,   535,   535,   535,   535,   535,   535,   536,   536,
     536,   536,   536,   536,   536,   536,   536,   536,   536,   538,
     537,   539,   539,   540,   540,   541,   542,   542,   542,   542,
     543,   544,   542,   542,   542,   542,   542,   542,   542,   542,
     542,   542,   542,   545,   542,   547,   546,   548,   548,   548,
     549,   549,   550,   550,   551,   551,   553,   552,   554,   554,
     554,   554,   554,   555,   555,   556,   556,   557,   557,   558,
     558,   559,   559,   560,   561,   561,   562,   562,   563,   563,
     564,   563,   565,   563,   566,   563,   563,   567,   563,   568,
     563,   563,   569,   563,   570,   563,   563,   571,   571,   571,
     573,   572,   572,   572,   574,   575,   576,   574,   577,   579,
     580,   578,   582,   581,   584,   585,   583,   586,   587,   588,
     588,   589,   589,   589,   589,   590,   590,   592,   591,   593,
     591,   594,   594,   595,   596,   595,   598,   597,   599,   599,
     600,   600,   601,   601,   602,   602,   603,   603,   603,   603,
     603,   603,   603,   603,   603,   603,   603,   603,   604,   604,
     605,   605,   605,   605,   605,   605,   605,   605,   605,   606,
     606,   606,   607,   607,   608,   608,   609,   610,   609,   611,
     612,   611,   613,   613,   614,   614,   615,   615,   616,   616,
     617,   618,   618,   619,   620,   620,   622,   621,   623,   623,
     624,   624,   624,   625,   625,   626,   626,   627,   628,   628,
     628,   629,   629,   629,   630,   630,   631,   631,   631,   631,
     631,   631,   632,   632,   632,   632,   632,   634,   633,   635,
     635,   636,   638,   637,   640,   639,   639,   639,   641,   642,
     641,   641,   643,   643,   644,   645,   645,   646,   646,   648,
     649,   647,   651,   652,   650,   653,   653,   654,   655,   655,
     655,   656,   655,   657,   657,   658,   658,   659,   658,   660,
     658,   661,   661,   662,   662,   663,   664,   664,   665,   665,
     667,   666,   668,   668,   669,   669,   670,   670,   671,   672,
     671,   674,   675,   673,   676,   676,   677,   678,   678,   679,
     681,   680,   683,   682,   684,   684,   685,   686,   687,   687,
     689,   688,   690,   690,   690,   690,   690,   690,   690,   690,
     690,   690,   690,   690,   690,   690,   691,   691,   692,   692,
     693,   693,   693,   695,   694,   696,   694,   697,   697,   698,
     698,   699,   699,   699,   701,   700,   702,   702,   704,   703,
     703,   703,   703,   705,   705,   706,   707,   707,   707,   708,
     710,   711,   712,   713,   709,   714,   715,   715,   716,   716,
     716,   717,   717,   718,   718,   719,   719,   719,   719,   720,
     720,   721,   721,   722,   722,   723,   723,   724,   724,   725,
     725,   725,   726,   726,   727,   727,   728,   728,   729,   729,
     730,   730,   730,   731,   731,   731,   732,   732,   732,   732,
     732,   732,   732,   732,   732,   733,   733,   733,   733,   733,
     734,   734,   735,   735,   736,   737,   737,   738,   738,   739,
     739,   739,   740,   740,   740,   740,   741,   741,   741,   742,
     742,   743,   744,   745,   746,   746,   747,   747,   747,   748,
     748,   748,   748,   748,   748,   748,   748,   748,   748,   748,
     748,   748,   748,   748,   748,   748,   748,   748,   748,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   751,   750,   752,   752,   753,   753,   755,
     754,   756,   756,   756,   756,   757,   757,   758,   758,   758,
     758,   759,   759,   759,   759,   760,   760,   761,   761,   762,
     762,   763,   764,   764,   764,   764,   765,   765,   765,   765,
     765,   766,   766,   768,   767,   770,   769,   771,   771,   772,
     772,   772,   773,   773,   773,   774,   774,   775,   776,   776,
     777,   778,   779,   779,   781,   780,   782,   782,   782,   784,
     783,   785,   785,   786,   786,   786,   787,   787,   788,   789,
     788,   790,   791,   792
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     7,     0,    13,     0,     6,     2,     2,
       3,     4,     4,     0,     4,     0,     0,     5,     0,     7,
       0,     0,     6,     0,     1,     0,     1,     0,     1,     0,
       3,     0,     1,     1,     2,     1,     2,     3,     3,     3,
       3,     3,     3,     1,     3,     4,     4,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       3,     1,     1,     2,     2,     7,     8,     8,     2,     2,
       0,     1,     2,     0,     1,     2,     0,     3,     2,     1,
       2,     4,     1,     4,     4,     1,     1,     1,     1,     1,
       2,     2,     2,     0,     5,     1,     1,     2,     1,     1,
       1,     1,     1,     2,     0,     3,     1,     5,     0,     3,
       0,     1,     0,     1,     2,     1,     1,     2,     2,     2,
       4,     1,     3,     2,     1,     2,     2,     2,     2,     1,
       1,     1,     1,     0,     1,     0,     1,     5,     0,     3,
       3,     1,     0,     2,     2,     2,     0,     3,     3,     6,
       6,     1,     1,     2,     2,     2,     1,     2,     2,     1,
       1,     0,     1,     1,     1,     1,     0,     1,     0,     1,
       2,     0,     1,     1,     2,     2,     2,     1,     3,     2,
       1,     1,     4,     2,     1,     4,     0,     1,     0,     2,
       1,     3,     0,     7,     0,     5,     0,     1,     0,     2,
       2,     1,     0,     1,     1,     1,     3,     2,     3,     2,
       4,     0,     6,     0,     0,     7,     3,     4,     3,     3,
       2,     2,     6,     5,     3,     3,     1,     1,     1,     0,
       1,     0,     1,     0,     2,     1,     0,     1,     1,     1,
       3,     0,     3,     0,     4,     0,     4,     0,     4,     0,
       4,     1,     3,     3,     1,     2,     4,     2,     3,     2,
       3,     0,     3,     0,     0,     6,     2,     1,     1,     2,
       2,     7,     0,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     2,     4,     3,     1,     1,     3,
       4,     0,     0,     0,     2,     2,     1,     1,     0,     2,
       3,     3,     3,     2,     3,     4,     3,     4,     3,     4,
       1,     3,     4,     3,     3,     6,     1,     5,     6,     5,
       7,     6,     8,     5,     6,     4,     5,     1,     3,     3,
       5,     5,     3,     3,     3,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     1,     1,     2,     2,
       3,     3,     5,     6,     4,     4,     2,     6,     5,     6,
       4,     4,     5,     4,     2,     4,     4,     4,    10,     6,
       8,     6,     4,     4,     6,     4,     4,     4,     7,     7,
       7,     6,     6,     6,     6,     3,     4,     6,     8,     2,
       8,     8,     6,     2,     4,     6,     6,     8,     8,     6,
       8,     6,     2,     4,     8,     8,     2,     2,     4,     4,
       3,     8,     4,     6,     4,     6,     8,     4,     6,     0,
       5,     0,     1,     1,     3,     4,     4,     5,     5,     4,
       0,     0,     7,     4,     5,     4,     5,     4,     4,     4,
       4,     4,     5,     0,     8,     0,     3,     3,     1,     4,
       0,     1,     0,     2,     0,     1,     0,     3,     2,     2,
       1,     1,     2,     1,     3,     0,     1,     0,     2,     4,
       5,     1,     1,     1,     1,     4,     1,     3,     3,     3,
       0,     6,     0,     6,     0,     8,     4,     0,     8,     0,
      10,     6,     0,     8,     0,    10,     6,     1,     2,     2,
       0,     4,     3,     5,     3,     0,     0,     8,     1,     0,
       0,     6,     0,     3,     0,     0,     5,     0,     1,     0,
       1,     0,     2,     3,     3,     1,     1,     0,     7,     0,
       7,     1,     2,     0,     0,     2,     0,     2,     0,     1,
       1,     1,     1,     3,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     1,     0,     2,     0,     1,     0,     0,     3,     0,
       0,     3,     2,     0,     0,     4,     4,     2,     0,     1,
       3,     3,     1,     2,     0,     1,     0,     4,     4,     2,
       0,     1,     1,     0,     1,     0,     1,     2,     1,     3,
       3,     1,     1,     1,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     2,     3,
       1,     2,     0,     3,     0,     5,     2,     1,     5,     0,
       7,     4,     1,     3,     1,     0,     2,     0,     1,     0,
       0,     7,     0,     0,     5,     2,     1,     1,     1,     3,
       4,     0,     3,     3,     1,     2,     2,     0,     3,     0,
       5,     3,     1,     3,     1,     3,     1,     1,     0,     1,
       0,     4,     0,     1,     3,     1,     1,     1,     0,     0,
       6,     0,     0,    10,     3,     1,     3,     3,     1,     3,
       0,     4,     0,     6,     0,     2,     1,     3,     0,     1,
       0,     3,     2,     3,     4,     5,     5,     5,     5,     2,
       2,     3,     1,     3,     4,     3,     0,     2,     1,     1,
       0,     2,     2,     0,     4,     0,     4,     1,     1,     0,
       1,     0,     1,     1,     0,     3,     3,     1,     0,     3,
       4,     1,     1,     0,     1,     3,     0,     1,     1,     2,
       0,     0,     0,     0,    18,     1,     0,     1,     0,     1,
       1,     0,     2,     2,     1,     3,     4,     3,     3,     0,
       2,     2,     1,     3,     3,     0,     3,     1,     1,     0,
       3,     2,     3,     1,     1,     2,     0,     2,     1,     2,
       1,     1,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     3,     5,     1,     1,     1,     1,     1,     3,
       4,     5,     1,     5,     3,     2,     1,     3,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     4,     0,     1,     1,     3,     0,
       2,     1,     1,     1,     1,     0,     1,     0,     1,     1,
       1,     0,     2,     2,     2,     1,     2,     4,     5,     4,
       6,     1,     2,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     3,     0,     3,     0,     1,     0,
       3,     2,     0,     1,     2,     0,     1,     4,     4,     5,
       2,     3,     0,     1,     0,     4,     0,     1,     1,     0,
       2,     2,     1,     0,     1,     1,     2,     3,     1,     0,
       5,     3,     0,     0
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,   232,     0,  1095,     0,     0,  1097,   232,   740,   777,
     778,   687,     2,   784,   689,   796,     0,     0,     0,   692,
    1097,     0,   293,  1055,   750,     0,   748,  1093,   261,     0,
       0,     0,     0,     4,    11,     6,    27,     9,     7,     8,
      20,    24,   284,    14,    16,    21,    30,    12,    28,    26,
      13,   779,    15,    17,    31,    18,    25,    29,     5,    10,
      22,    23,    19,   226,   234,   233,   261,  1092,  1091,   275,
    1097,   273,   277,  1098,  1099,    59,    58,     0,    34,   744,
     685,   688,     0,     0,     0,   261,   797,   798,     0,   805,
     800,     0,   279,     0,  1099,   909,   910,   911,   912,   913,
     914,   915,   916,   917,   890,   918,   919,   920,   922,   921,
     923,   891,   924,   925,   892,   893,   926,   927,   929,   894,
     930,   895,   931,   932,   933,   934,   935,   896,   936,   938,
     939,   937,   940,   941,   942,   897,   943,   944,   945,   946,
     947,   956,   898,   948,   950,   949,   951,   952,   953,   954,
     928,   958,   959,   960,   899,   955,   961,   957,   962,   963,
     964,   879,   965,   880,   966,   967,   968,   969,   970,   971,
     972,   973,   974,   975,   976,   977,   978,   979,   980,   981,
     982,   983,   985,   984,   986,   988,   987,   989,   991,   990,
     992,   900,   993,   994,   995,   996,   997,   901,   998,   999,
    1000,  1001,  1002,  1003,  1004,  1005,  1006,  1007,  1008,  1009,
    1010,   902,  1011,  1012,  1013,  1014,  1015,   903,  1016,   904,
    1018,  1017,  1019,   905,  1021,  1022,  1020,  1023,  1024,   906,
    1025,   907,  1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033,
    1034,  1035,  1036,  1038,  1039,  1040,  1037,   908,  1041,  1042,
    1043,  1044,  1045,  1046,  1048,  1047,  1049,  1050,  1051,  1052,
     884,  1110,   885,   889,   285,   291,   302,  1056,  1053,  1067,
     271,   749,     0,     0,   262,     0,   799,   293,     0,     0,
       1,     3,   954,     0,   775,   773,   876,   224,   227,     0,
       0,  1096,     0,     0,     0,  1102,     0,     0,    59,   196,
     746,     0,   744,     0,     0,     0,   685,   791,   792,  1092,
     785,   787,   788,     0,   910,   917,     0,   852,   505,     0,
       0,   926,   927,     0,     0,   328,   328,     0,     0,     0,
     941,   942,   858,     0,     0,     0,   849,   859,     0,   851,
     964,     0,     0,     0,     0,   856,     0,   981,   982,     0,
       0,   986,     0,   328,   848,   855,     0,  1004,     0,     0,
    1010,     0,  1015,  1016,     0,     0,  1028,     0,     0,   328,
     882,  1038,  1039,  1040,     0,   850,   908,   857,  1046,   328,
     328,     0,     0,     0,  1052,     0,     0,  1132,     0,     0,
     485,   795,   340,   346,   357,   367,   380,   381,   383,   382,
     387,   386,   846,   385,   847,   379,   866,   884,   838,   865,
     806,  1111,     0,     0,   697,   693,   696,   684,  1105,  1102,
    1112,   312,   307,   309,   310,   311,   308,   306,   321,   303,
     305,  1059,     0,     0,     0,   770,   643,  1068,   195,   194,
     193,  1069,   762,  1070,   766,     0,   643,     0,   751,     0,
       0,   270,   747,  1094,   731,   287,     0,  1116,   878,     0,
     781,     0,   163,     0,   276,   682,   274,   278,  1101,     0,
       0,  1103,  1107,   370,     0,    36,     0,   197,     0,     0,
     741,   745,   686,   681,     0,     0,     0,     0,   793,   690,
       0,   614,   396,   506,     0,     0,     0,     0,     0,     0,
     614,     0,   429,   404,     0,     0,     0,     0,   853,     0,
       0,  1132,     0,   490,     0,     0,     0,  1132,     0,     0,
     614,     0,     0,   614,     0,     0,   333,     0,   433,     0,
       0,     0,     0,     0,     0,     0,     0,   614,   614,     0,
       0,   614,     0,   442,     0,   854,     0,     0,     0,     0,
       0,   446,   447,     0,   614,   614,     0,   389,   388,     0,
       0,     0,     0,     0,     0,   369,   368,     0,     0,     0,
     371,     0,   372,   373,     0,   374,   375,   376,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   839,   459,     0,   807,     0,   280,   281,     0,   695,
       0,  1106,     0,  1108,  1123,   292,  1113,   318,   294,   317,
       0,   304,  1054,  1057,  1065,   768,   769,     0,     0,    59,
       0,     0,     0,   752,     0,   760,   644,   770,     0,   766,
     759,     0,   770,   770,     0,     0,   288,  1117,   286,  1118,
       0,   776,   842,   841,   774,   782,   840,   783,   877,   164,
     225,     0,   222,     0,  1100,  1104,    60,    55,    32,     0,
     742,     0,   678,     0,   786,   794,   789,     0,     0,   615,
     614,     0,   496,     0,   507,     0,   503,     0,     0,     0,
       0,   470,     0,   496,   329,   450,     0,     0,     0,     0,
       0,     0,   587,   588,   589,   590,   600,   591,   592,   593,
     602,   607,   594,   595,   603,   604,   605,   596,   606,   601,
     597,   608,     0,   586,   491,   483,     0,     0,     0,     0,
       0,     0,   614,     0,     0,     0,   614,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   614,     0,     0,     0,   599,     0,   598,
       0,     0,     0,     0,     0,     0,   425,     0,   868,   867,
       0,     0,     0,   391,     0,   390,   549,     0,  1128,  1133,
       0,     0,   888,   881,  1071,   486,   887,   886,   488,   331,
     330,   332,   343,   336,   341,   334,   338,     0,   377,   913,
     344,     0,     0,   365,  1132,   623,   366,     0,   359,     0,
     358,   362,   363,   364,     0,     0,     0,   384,   321,   869,
       0,     0,     0,    50,   701,     0,     0,     0,   707,   694,
     698,  1109,  1125,  1124,  1114,   321,   634,   322,   322,   865,
    1059,  1062,  1063,  1066,  1064,     0,  1061,  1060,  1075,   766,
       0,     0,   765,   771,   772,   652,   653,   651,   647,   648,
     753,   767,   770,   766,   761,   763,   272,     0,     0,   643,
    1122,  1120,   718,   163,   683,    37,    56,    61,   198,   616,
     679,   790,   728,     0,     0,   466,     0,     0,     0,     0,
       0,     0,   403,     0,   448,   449,     0,     0,   469,     0,
       0,     0,   405,   406,   400,   394,     0,     0,   407,     0,
       0,     0,     0,     0,     0,   475,   452,   412,     0,   473,
       0,   413,   434,     0,   454,     0,     0,   457,     0,     0,
     415,   479,   477,     0,     0,     0,     0,   481,   443,   416,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
       0,   401,   478,   480,   426,     0,  1126,   548,   302,   549,
       0,     0,  1123,  1131,   395,   870,     0,     0,     0,     0,
       0,   337,   342,   335,   339,  1132,     0,     0,     0,     0,
     355,     0,     0,     0,  1132,   623,     0,     0,   462,   463,
       0,   883,   801,   282,   283,   302,     0,   720,   705,   712,
     706,     0,     0,     0,   704,   861,   860,   867,  1112,     0,
     316,   540,   672,   313,   298,   645,   635,   297,   323,   319,
       0,  1058,  1037,  1081,     0,     0,  1076,   770,     0,   764,
       0,     0,   754,   616,   732,   735,     0,   636,  1121,   716,
     717,   719,     0,   259,   259,   718,   718,   259,   718,     0,
       0,     0,   259,     0,   718,   257,     0,   718,   259,     0,
     266,   718,   256,    63,    73,     0,   223,   231,     0,   235,
     258,     0,   103,    33,   808,    62,    65,   199,     0,   617,
     634,   680,     0,   691,     0,     0,   467,   497,     0,   508,
       0,   398,   138,   138,   501,   500,   134,     0,   504,     0,
     471,   468,     0,     0,     0,   494,     0,     0,     0,   402,
       0,   476,   474,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   482,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   392,   321,   289,     0,  1127,  1129,
    1072,  1073,  1074,   218,   487,     0,   353,   349,     0,   347,
     622,   361,   360,     0,     0,     0,   356,   322,   460,   321,
     871,   808,   321,   702,   714,     0,   722,     0,     0,   699,
     709,     0,     0,   708,  1115,   558,   557,     0,   514,   616,
     516,   513,   512,   511,     0,   557,   667,     0,     0,   295,
     300,   296,   646,   299,     0,   320,   327,   326,   862,   869,
       0,     0,  1071,     0,   755,   758,   757,   650,   649,   756,
       0,   616,     0,     0,   162,   161,    76,   160,   260,   216,
     190,   189,   239,     0,   100,   216,   186,   237,     0,     0,
       0,     0,     0,     0,   250,   229,     0,     0,     0,     0,
     251,     0,   230,     0,     0,     0,   269,   268,   267,     0,
       0,    64,   718,   163,   103,     0,   263,   100,   106,   872,
      61,     0,    38,     0,     0,    89,    91,    92,   810,   809,
      39,    53,   163,    66,     0,     0,   200,     0,     0,   654,
     729,     0,   427,   509,     0,     0,   498,   499,     0,   502,
     136,   397,   399,     0,     0,     0,   432,   492,   495,     0,
       0,   409,     0,   411,   453,   435,   455,     0,   414,   393,
       0,   436,     0,   441,   439,     0,     0,     0,   423,     0,
     421,     0,   422,     0,   424,   458,   550,   290,     0,     0,
     489,   345,     0,   354,   351,     0,   348,   323,   464,     0,
      51,     0,     0,   727,   726,     0,   723,   725,   711,  1116,
     700,   703,   557,   540,     0,     0,   537,   559,     0,   559,
     540,   540,   624,   540,   609,   554,     0,     0,   677,     0,
     673,   314,     0,   325,   324,     0,     0,  1089,  1090,  1087,
    1088,  1086,  1077,     0,     0,   734,   634,   736,   864,   637,
     640,   105,   217,     0,     0,     0,   191,    99,   216,    98,
     101,   198,     0,   665,   666,   664,   662,   663,    71,   660,
     661,   657,   658,   656,   659,    69,   241,    70,   255,   216,
     248,   249,   246,    68,    74,   243,   630,   632,   640,   254,
      85,    83,    80,    82,    81,    86,    84,    72,     0,   236,
       0,   875,     0,   265,   238,     0,    93,    94,     0,     0,
      40,     0,    43,    61,   103,    54,     0,    67,   210,   211,
     206,   205,     0,   618,     0,   743,     0,     0,   510,     0,
       0,   472,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   420,   418,   419,   645,  1130,
     219,   350,     0,   465,   802,   645,   713,   715,   721,     0,
     710,     0,   634,   552,     0,   539,   538,   560,     0,   540,
     559,   559,     0,   519,   518,     0,   619,   517,   610,   611,
       0,   576,   542,   302,   676,   674,     0,   668,   670,     0,
     863,     0,     0,  1085,  1078,     0,  1079,   654,     0,   641,
     642,   639,   102,   216,   187,   192,   188,   198,     0,     0,
       0,     0,   247,     0,     0,   633,    75,   240,   264,   168,
     130,   118,   126,   117,   115,   134,   132,   123,   134,   129,
     134,   131,   125,   119,   116,     0,   128,   107,   142,   112,
       0,   109,   140,   874,    41,  1119,   808,    90,     0,    46,
       0,   655,     0,   428,   139,   135,     0,   430,   431,   493,
     484,   451,     0,   410,   456,   437,   440,   438,   444,   445,
     313,   313,    87,   352,     0,    52,   724,  1123,   609,   645,
     540,   515,   540,   526,     0,     0,   540,   522,   520,   524,
       0,   620,   634,   613,   541,   573,   321,   811,   671,     0,
     315,  1083,  1082,  1084,     0,   733,   640,     0,     0,     0,
     253,     0,   263,   244,   631,     0,   172,   120,   133,     0,
     122,   121,     0,   151,     0,     0,     0,     0,   146,     0,
     166,     0,   154,   108,   143,   145,     0,     0,   127,     0,
       0,     0,   141,   110,     0,    44,    42,     0,  1112,     0,
     640,   214,     0,     0,     0,   551,    88,     0,   545,   543,
     544,   553,     0,   511,   540,   540,     0,   511,     0,     0,
       0,   628,   640,     0,   645,   577,     0,   555,     0,   819,
     669,  1080,   638,     0,     0,     0,     0,     0,     0,     0,
     252,   843,   242,   263,     0,   171,     0,   176,     0,     0,
     157,   156,   328,   149,   159,    77,    79,    78,   147,     0,
       0,   155,   144,   153,   148,     0,     0,     0,   873,    48,
      47,   201,     0,   213,     0,   730,   738,     0,   137,   408,
     803,     0,   527,     0,   531,   536,   532,     0,   523,   521,
       0,   629,     0,   625,   627,   621,   301,   565,   566,     0,
       0,   571,   575,   645,     0,     0,     0,     0,   812,   814,
       0,   675,     0,     0,   201,   845,   844,   245,   169,     0,
     173,   174,   175,     0,   167,     0,   220,   114,   158,   328,
     152,   111,   113,  1119,     0,   718,    35,   202,   207,   203,
     640,     0,     0,     0,   811,   546,     0,     0,     0,     0,
       0,   584,   640,   561,   561,   572,   556,     0,     0,     0,
       0,   813,     0,     0,   820,   822,     0,   201,    95,   170,
       0,     0,   124,     0,   150,    49,   209,     0,   204,   212,
     215,   737,   739,   819,   634,   528,     0,   533,     0,   525,
       0,   626,     0,   569,   567,   817,   818,     0,   815,     0,
       0,   821,    97,    96,   182,     0,   181,     0,   178,   177,
     221,   208,   825,   645,     0,     0,   585,     0,   562,     0,
       0,     0,   816,   824,   823,   184,   185,   183,     0,     0,
       0,   829,   547,   530,   535,   564,   563,   578,     0,     0,
       0,     0,     0,   836,   581,     0,   582,   579,   580,     0,
     180,   179,   827,   828,   826,   831,     0,     0,   833,   834,
       0,   804,   570,     0,   568,   835,   830,     0,   837,   583,
     832
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    31,    32,    33,    34,   867,   299,   657,  1063,  1252,
    1575,  1260,  1678,  1813,   818,   985,  1485,  1446,   865,    77,
     297,  1064,  1052,  1065,  1066,  1054,   650,  1738,  1427,  1600,
    1254,  1255,  1256,  1257,  1389,  1390,  1213,  1214,  1247,  1438,
    1567,  1568,  1649,  1569,  1570,  1571,  1572,  1279,  1280,  1276,
    1673,  1663,  1664,  1665,  1733,  1205,  1206,  1055,  1666,  1437,
    1646,  1724,  1727,  1804,  1888,  1215,  1388,  1216,  1536,   447,
     478,  1067,  1068,  1816,  1817,  1818,  1819,  1450,  1679,  1680,
    1381,  1320,  1805,    35,   863,   462,   287,  1056,    66,  1057,
    1058,  1059,  1541,  1543,  1723,  1217,   275,  1434,  1239,    36,
     451,    37,   292,    38,   290,    39,   293,    40,   412,   596,
     597,    41,    42,   279,   951,   264,   420,   265,   266,   826,
    1003,  1601,   428,   429,   430,  1179,   608,   609,   610,  1008,
    1185,   502,   676,   392,   393,   394,   568,   569,  1667,   578,
     791,   395,   396,   397,   398,   399,   808,   977,   978,   979,
     400,   887,  1283,   897,   401,   564,   775,   715,  1465,  1287,
     671,   876,  1087,   945,   494,   880,   674,  1168,  1169,  1170,
    1171,  1172,  1699,  1698,  1700,  1826,  1763,  1828,  1767,  1351,
    1173,  1174,  1491,  1761,  1864,   946,   947,   948,  1478,  1492,
    1610,  1512,  1513,  1783,  1342,  1175,  1498,  1873,  1780,  1781,
    1901,  1900,  1782,  1705,  1706,  1624,  1625,  1925,  1926,  1927,
    1830,   712,   748,   713,  1510,  1511,   672,  1070,  1268,  1622,
    1703,   970,  1506,  1701,  1773,  1060,  1416,  1417,  1005,  1006,
    1203,  1379,  1531,   625,  1602,  1182,   848,   849,  1455,  1405,
    1398,  1358,  1359,  1517,  1518,  1007,  1176,  1360,  1627,    43,
    1071,   464,   465,   304,    83,    44,    85,   667,    45,    93,
     600,   415,   416,   819,   986,   993,   820,   998,  1339,   988,
    1153,  1154,  1031,  1032,   989,  1156,  1335,  1336,  1337,  1073,
    1456,    46,   635,  1201,  1024,  1025,  1755,  1756,    47,    79,
     480,   869,   301,   302,    48,   272,    49,   269,   448,   627,
     628,   623,    50,   460,   459,    51,   284,   644,    52,    84,
     310,   311,   488,   666,    53,    88,    54,    55,   410,  1151,
    1604,  1824,    90,   595,  1261,  1709,  1788,  1789,  1791,  1844,
    1845,  1911,  1934,  1923,  1937,  1938,  1941,   402,   645,  1720,
     403,   404,   994,   995,  1380,   405,  1757,   406,  1248,   417,
     407,   776,   408,   982,   409,  1207,   262,   263,    56,   431,
     268,   612,   613,   614,   835,   836,   449,   959,   837,   838,
    1016,  1014,  1524,  1372,   312,    57,   273,    58,    70,    74,
     295,   472,   602,    59,    60,    61,    62,   605,   637,   999,
     638,   639,   640,   861,   824,   768,   769,  1318,   560,   561,
     953
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -1428
static const yytype_int16 yypact[] =
{
    1364,   524,   180, -1428,   180,   180,  -150,   513, -1428, -1428,
   -1428,   814, -1428, -1428, -1428,    65,   164,   -32,   180, -1428,
    -150, 16940, -1428,   120, -1428,    83,   210, -1428,   258, 16940,
     285,   487,   439, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, 12512, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, 16940, -1428, -1428,   258, -1428, -1428, -1428,
    -150, -1428, -1428, -1428,   568,   448, -1428,   295, -1428,   457,
     527, -1428,   562,   180,   677,   258, -1428, -1428,  5747, -1428,
   -1428, 16940, -1428, 11774,    52, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428,   846, -1428, -1428,   969,
     405, -1428, 12881,   180, -1428, 12881, -1428, -1428,   285,   362,
   -1428, -1428,   310, 16940, -1428, -1428,   410, -1428, -1428,   484,
   12881, -1428, 12881, 12881,    86,   -20,   597, 16940,   448,   465,
   -1428,   690,   457,   717, 16940, 16940,   527, -1428, -1428,   489,
     480, -1428, -1428, 11774,   488,   494,  8030, -1428,  5747,   516,
     519,   532,   553,   565,   573,   599,   599,   630,   639,   654,
     263,   660, -1428,   668,   672,   686, -1428, -1428,   702, -1428,
     709,   716,   722,  6126,   736, -1428,   738,   740,   758,   768,
     770,   776,  5747,   786, -1428, -1428,   788,   796,   799,   812,
     815,   831,   833,   838,   841,   844,   847,   852,   861,   867,
   -1428,   322,   872,   874,   881, -1428,   890, -1428,   900,   599,
     599,   902,   903,   906,   908,  8030,  8030,  5747, 16940, 16940,
   -1428,   301,  1521, -1428,   858,   835, -1428, -1428, -1428, -1428,
   -1428, -1428,   576, -1428, -1428, -1428, -1428,   909, -1428,   520,
     873, -1428, 12881, 12881, -1428, -1428, -1428, -1428,   673,   -20,
     625, -1428, -1428, -1428, -1428, -1428, -1428, -1428,   627,   846,
   -1428, -1428,    75,   912,     2,   -43,   836, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428,    75,   757,   836,    75, -1428,  -119,
    1018, -1428, -1428, -1428, -1428, -1428,   748,    -8, -1428,   348,
   14726, 16940,  1047, 12881,   761, -1428,   761,   761, -1428,  1200,
    1037, -1428, -1428, -1428,  1180, -1428, 12881, -1428,  1145, 12881,
   -1428, -1428, -1428, -1428,  1074, 12881,  1048,   677, 12881, -1428,
    5747,   277,   835,   301,   937,  5747,  5747,  5747,  5747,  5747,
     569,   926, -1428, -1428,   929,  5747,  5747,  5747,   576,  5747,
   13250, -1428,  1626,  1218,  5747,  5747,  5747,  5747,  1359,  5747,
     640,  5747,  5747,   688,  5747,  5747, -1428,  4222, -1428,  8030,
    5747,  5747,  5747,  5747,  5747,  5747,  5747,  1307,  1307,  5747,
    5747,   749,  4222, -1428,  5747,   576,  1131,  1131,  3455,  5747,
     932, -1428, -1428, 13250,  1307,  1307,  5747,   835,   835,    62,
     935,   391,  5747,   931,  9167, -1428, -1428,  5747,  5747,  5747,
   -1428,  8030, -1428, -1428,   763, -1428, -1428, -1428,  6514,  8030,
    8030,   938,  8030,  8030,  8409,  8788,  8030,  8030,  8030,   629,
   15464, -1428, -1428, 16940, -1428,  1167,   943, -1428,   989, -1428,
     478, -1428, 16940, -1428,   792, -1428, -1428, -1428,   945, -1428,
    5747, -1428,   946, -1428,     1, -1428, -1428, 12881,   954,   448,
   12881,  1007,  5747, -1428,   372, -1428, -1428,   -43, 16940,    75,
   -1428, 12881,   -43,   -43,  1043,  1050, -1428, -1428, -1428, -1428,
      -3, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428,  1293, -1428, 12881, -1428, -1428, -1428,   718, -1428, 16940,
   -1428, 12881,   761,  1158, -1428,   761, -1428,   478,    55, -1428,
    1307,   963, -1428,  5747,   -28,    84,   301,   463,   505,   172,
      73, -1428,   964,   970, -1428, -1428,    97,   114,   176,   177,
     971,   975, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428,  1219, -1428, -1428, -1428,   182,   123,   130,    76,
     981,   131,  1307,   977,   197,   207,  1307,   979,   134,   240,
     245,   785,   252,   137,   138,   283,   139,   142,   326,   980,
     983,   143,    42,  1307,   984,   327,   338, -1428,   990, -1428,
     991,  4610,  4989,  5368,    59,   145, -1428,   985, -1428,   520,
     995,   996,   345, -1428,  5747, -1428, -1428,   425, -1428,  1017,
      38, 16940, -1428, -1428,   523, -1428, -1428, -1428,  1092,  1373,
      56, -1428, -1428, -1428, -1428, -1428, -1428,   619, -1428,  1006,
   -1428,  1011,   514, -1428,  5747,   526, -1428,  6126,   645,  6126,
     645, -1428, -1428, -1428,  8030,  1012,  8030, -1428,  1002,  1009,
    1070, 12881, 12881, -1428, -1428,  1019,  1019, 11405, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428,   554,   301, -1428,  1016,
   -1428, -1428, -1428, -1428, -1428, 17309,  1024, -1428, -1428,    75,
    1031, 16940, -1428, -1428,   301, -1428, -1428, -1428, -1428,   -70,
   -1428, -1428,   -43,    75, -1428, -1428, -1428, 13250,  1367,   836,
   -1428, -1428,    87,  1851, -1428, -1428, -1428,   901, -1428,  1046,
   -1428, -1428,  1190,  6893,  1036, -1428,  5747,   308,  5747,  5747,
    1315,  1094, -1428,  5747, -1428, -1428,  1094,  5747, -1428,  1040,
    1265,  1266, -1428, -1428, -1428, -1428,  5747,  5747, -1428,  5747,
    5747,  5747,  5747,  5747,  1045, -1428, -1428, -1428,  1049, -1428,
    5747, -1428, -1428,  5747, -1428,  5747,  5747, -1428,  5747,  5747,
   -1428, -1428, -1428,  7272,  5747,  5747,  1053, -1428, -1428, -1428,
    5747,  5747,  5747,   542,  5747,   669,  5747,   670,  5747, -1428,
    5747, -1428, -1428, -1428, -1428,   536, -1428, -1428,   846, -1428,
     425,  1060,   792, -1428, -1428, -1428,  1056,  1058,  1059, 15464,
    5747, -1428, -1428, -1428, -1428, -1428,  8030,    90,  1065,  8030,
   -1428,  1359,  1359,   695,  5747,   526,  5747,  1066,  1072, -1428,
   16940, -1428, -1428, -1428, -1428,   846, 13250, -1428,  1076, -1428,
    1076,   473,  1075,   543, -1428, -1428, -1428,  1016,   625,   348,
   -1428,  -138, -1428,    47,  1269,   836, -1428,  1299, 15833, -1428,
   13988, -1428,  1295, -1428,    87,  9542, -1428,   -43,   -22, -1428,
     372,   372, -1428,  1046,  1080, -1428,    87, -1428, -1428, -1428,
   -1428, -1428, 15095,    70,  1415,    87,    87,  1415,    87,  1132,
    1297,  1144,   940,  1300,    87, -1428,  1146,    87,  1415,  1439,
      69,    87, -1428,  1310, -1428,  1431, -1428,  1100, 12143, -1428,
   -1428, 12881, 10667, -1428,    22, -1428,    40,   396,  1257, -1428,
    1250, -1428,  1389, -1428,  6126,   351, -1428,   301,  5747,   301,
     325, -1428,  1109,  1109, -1428, -1428,  1112,  1113,   301,  1116,
    1111, -1428,  5747,  5747,   375,  -111,   151,   158,    92, -1428,
     383, -1428, -1428,   388,   395,   422,   159,   492,   676,  6126,
     500,   157,    96, -1428,   163,   165,   548,  5747,   577,  5747,
     588,  5747,   590,   591, -1428,   627, -1428,  1117, -1428, -1428,
   -1428, -1428, -1428,  1114,   301,  1118, -1428, -1428,  5747, -1428,
     835, -1428, -1428,  8030,   112,  1125, -1428,   301, -1428, -1428,
   -1428,    -7,   627,  1127, -1428,    87,  7651,  1019,  1228, -1428,
   -1428,   473, 13250, -1428, -1428, -1428, -1428, 16940,  1314,  1046,
   -1428,  1129, -1428, -1428, 12881, -1428,    91,  1163,  1352, -1428,
   -1428, -1428, -1428, -1428, 16202, -1428, -1428, -1428, -1428,  1134,
    1340,  3843,   523,    87, -1428, -1428, -1428, -1428, -1428, -1428,
   13250,  1046,  7651,  5747, -1428, -1428, -1428, -1428, -1428, 13619,
   -1428, -1428, -1428,    30,    33, 13619, -1428, -1428, 13619,   753,
      27, 13619,  1007, 15095, -1428, -1428,  1348,  1349, 13619, 13619,
   -1428, 15464, -1428,    27, 13619, 13250, -1428, -1428, -1428, 12881,
     808, -1428,    87,  1885, 11036, 16940,   129,    46, -1428,  1137,
    1310, 12881, -1428,  1143,   724, -1428, -1428, -1428, -1428, -1428,
   -1428,  1515,  1260, -1428,   127,   127, -1428, 12881,  5747,  1351,
   -1428,  1359, -1428,   301,  5747,  1305, -1428, -1428,  1308, -1428,
   -1428, -1428, -1428,  1154,  1359,  1359, -1428,  1255, -1428,  5747,
    5747, -1428,  5747, -1428, -1428, -1428, -1428,  5747, -1428, -1428,
    1359, -1428,  5747, -1428, -1428,  5747,  5747,  5747, -1428,   592,
   -1428,   593, -1428,   596, -1428, -1428,   945, -1428,   391, 16940,
   -1428, -1428,   726, -1428, -1428,  5747, -1428, 15833, -1428,  1377,
     945, 13250,  7651,   668,   301,  1159,  1157, -1428, -1428,    -8,
   -1428, -1428, -1428,   433,  1375,  1378, -1428,  1311,   -12,  1311,
     433,   433,  1407,  -138,   556, -1428,  1070,  1070, -1428,  1161,
   -1428, -1428,  1261, -1428, -1428, 14357,   -49, -1428,  8030,   668,
   -1428,   301, -1428, 16940,  5747, -1428,  1250, -1428,   301,  1170,
     171, -1428, -1428,  5747,  1380,  1384,   606, -1428, 13619, -1428,
   -1428, -1428,    13, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, 13619,
   -1428, -1428, -1428, -1428, -1428, -1428,  1172, -1428,   171, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, 15095, -1428,
     730, -1428, 16940, -1428, -1428, 12881, -1428, -1428,  1437, 16940,
   -1428,  1181, -1428,  1310, 11036, -1428,   461, -1428, -1428, -1428,
   -1428, -1428,  1176,   301,   372, -1428,  1394,  -164,   301,  1183,
     746, -1428,  1184,  1185,    77,  1187,   608,   170,   750,   614,
    -152,   621,   624,   631,   634, -1428, -1428, -1428,   547, -1428,
   -1428, -1428,   759, -1428, -1428,   547, -1428, -1428, -1428,  7651,
   -1428,  -168,  1250, -1428,   745, -1428, -1428, -1428,  1403,   433,
    1311,  1311,  1404,  1346,   -77,  1542,  1435, -1428, -1428, -1428,
   16940, -1428, -1428,   846, -1428, -1428, 15464,  1196, -1428,  1376,
   -1428,     3,  1326, -1428, -1428,    87,   301,  1351,  5747, -1428,
   -1428, -1428,   301, 13619, -1428, -1428, -1428, -1428,  1204,  1495,
    1499, 13619, -1428,  1437, 13250, -1428, -1428, -1428, -1428,  1206,
   -1428, -1428, -1428, -1428, -1428,  1112,  1344, -1428,  1112, -1428,
    1112, -1428, -1428, -1428, -1428,  1210, -1428, -1428,  1004,  -161,
    1211, -1428,  1213,  1209, -1428,    10,    22, -1428,  1228, -1428,
   16940, -1428,  1247, -1428, -1428, -1428,  1379, -1428, -1428, -1428,
   -1428, -1428,  5747, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
      47,    47, -1428, -1428,  1275, -1428, -1428,   792,   710,   836,
    -138, -1428,   433, -1428,  1434,  1436,   433, -1428, -1428, -1428,
    5747, -1428,  1250, -1428, -1428,   -34,   627,  1556, -1428,  1161,
   -1428, -1428, -1428, -1428,  3843, -1428,   171,  1224,  1229, 16940,
   -1428,  1201,   129, -1428, -1428, 16940,  1417, -1428, -1428,  1230,
   -1428, -1428,  1390, -1428, 15464,  1007,   978,   110, -1428,  1262,
   -1428,  1527,  1446, -1428,  1004, -1428,  1447,  1396, -1428,  1397,
    1399,  1405, -1428, -1428, 16940, -1428, -1428,  1249,   625,   771,
     171,  1248, 13250,  1253,   636, -1428, -1428, 12881, -1428, -1428,
   -1428,  1129,  1003,  1285,   433,   433,  1175,  1287,  5747,  5747,
    1264,   403,   171,  5747,   836, -1428,   -31,   945,    89,  1462,
   -1428, -1428, -1428, 16940, 16940,   773,   576,   576,   772,   772,
   -1428, -1428, -1428,   129,   790, -1428,     0,  1416,    77,  1271,
   -1428, -1428,   599, -1428, -1428, -1428, -1428, -1428, -1428,  1426,
    1290, -1428, -1428, -1428, -1428,  1277,  1280,  1268, -1428, -1428,
   -1428,    31, 16940, -1428,  1441,  1274, -1428,    87, -1428, -1428,
   -1428,   391, -1428,  1312, -1428, -1428, -1428,  1313,   301,   301,
   16940, -1428,  5747, -1428, -1428,   301, -1428, -1428, -1428,   606,
     606, -1428,   -31,   547,  1633,  1636,  1565,  1640,    89, -1428,
    -116, -1428,   800,   805,    31, -1428, -1428, -1428, -1428, 16940,
   -1428, -1428, -1428,    -1, -1428,   826, -1428, -1428, -1428,   599,
   -1428, -1428, -1428,    10,  1007,    87, -1428,    31, -1428, -1428,
     171,  1291, 13250,  7651,  1556, -1428,  5747,  1294,  5747,  1296,
     862, -1428,   171,  1544,  1544, -1428, -1428,    77,    77,  1644,
      77, -1428,  1646,  1647,  -116, -1428,  1422,    31, -1428, -1428,
      67,    67, -1428,    77, -1428, -1428, -1428,    27, -1428, -1428,
   -1428, -1428, -1428,  1462,  1250,   301, 16940,   301, 16940, -1428,
   16940, -1428,   682, -1428, -1428, -1428, -1428,    77, -1428,    77,
      77, -1428, -1428, -1428, -1428,  1680, -1428,    74,  1455,  1456,
   -1428, -1428,  1533,   836,   864,   869, -1428,  1654, -1428,  1655,
    1317,  1318, -1428, -1428, -1428, -1428, -1428, -1428,  1338,  1603,
    1469,  1321, -1428, -1428, -1428, -1428, -1428, 16571, 16571,    67,
      67,   -15,  9917,  1408, -1428,  1327, -1428,  1328, -1428,   875,
   -1428, -1428, -1428, -1428, -1428, -1428, 15464,   878, -1428, -1428,
   13250, -1428, -1428, 16571, -1428, -1428, -1428, 10292,  1274, -1428,
   -1428
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428,   122, -1428, -1428,  -804, -1428, -1428, -1428, -1428, -1428,
    -220, -1116,   665,  -960,  -819, -1428,  1062, -1428, -1428, -1412,
     469,   278,   663,   693,   476,   517, -1428, -1428,   186, -1428,
     189, -1428, -1428, -1428, -1428, -1428, -1428,  -526,   161,   646,
   -1428, -1428, -1428,    78, -1428,    80, -1128,  -333, -1428,  -107,
   -1428, -1428, -1428, -1428,  -871, -1428, -1428, -1031, -1428, -1428,
   -1428, -1428, -1250, -1218, -1428,   674,   -73,   475,  -911,    -9,
   -1048, -1428, -1428, -1428, -1428, -1428, -1428, -1428,   649, -1428,
   -1428,   502, -1428, -1428, -1428,   150,   154, -1376, -1428, -1428,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
     936,  1292,   747,  1472,   802, -1428, -1428,  1476, -1428, -1428,
   -1428,  -714,  -922, -1428,  1325,  -332, -1090,   930,  -755,  -742,
     429,  -324,  1726, -1428,  -537,   504, -1428, -1428,  -209, -1428,
   -1428,  -304, -1428, -1428, -1428, -1428, -1428, -1428, -1428,   609,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
    1055, -1428,   871,  -474, -1428, -1428, -1428, -1252, -1428,   406,
     152, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
    -940, -1428, -1428, -1428, -1428, -1428,   811, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428,  -949, -1428,  -846,   -71, -1428,   -18,
   -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,  -178,  -157,
   -1043,  -501,  1220,   725, -1428,   160,  1270,  -904, -1428, -1428,
   -1428,   791, -1428, -1428, -1428, -1428, -1428,   232, -1067,  -601,
   -1428, -1428, -1369,  -394,  -991,  -385, -1428,  -974,   253, -1212,
   -1428, -1428, -1428, -1428,   153,   775, -1428, -1428, -1428, -1428,
   -1428,  -182,   -65,  1477, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428,  1471,  1372,  1119, -1428, -1428,  -818, -1428, -1428,   972,
   -1428,   456,  -995, -1011,   632, -1428, -1428, -1428, -1184, -1428,
   -1428, -1428, -1428, -1428, -1428,   594,  -149,   -30, -1428, -1428,
   -1428, -1428,  1488, -1428, -1428, -1428, -1428, -1428, -1428,  -244,
    -222,  -567, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428,  1306, -1428, -1428, -1428, -1428, -1428, -1428, -1428, -1428,
   -1428, -1428, -1428, -1428,   644,   -27, -1428,     8,   -61, -1428,
     -41, -1428, -1428, -1428, -1428,  -142, -1428,  -323, -1384,   155,
   -1006,  -442,   648,  1197, -1427,  1298,  -549,  -543,  -530,   -46,
     -21,  -605,  -401,   -74,   642,  -558, -1428, -1428, -1428, -1428,
   -1428, -1428,   976, -1428, -1428, -1428, -1428,   620, -1428, -1428,
   -1428,   440, -1428,   181,   113, -1428, -1428, -1428, -1428,   179,
    1723,  1400, -1428, -1428, -1428, -1428, -1428,  -983,  -411, -1428,
   -1302, -1428, -1428, -1428,  -932, -1275, -1428, -1428,  -473, -1428,
   -1428
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1120
static const yytype_int16 yytable[] =
{
     260,   591,   503,  1269,   757,   285,   778,   508,   260,   606,
     758,  1228,   492,   992,  1181,  1163,   843,   720,  1377,  1191,
    1129,  1414,   677,   678,  1219,  1220,  1125,  1222,   414,   528,
     260,  1202,   807,  1231,   782,  1316,  1233,  1490,   691,   859,
    1240,   790,   260,  1479,  1053,   543,  1197,  1198,   545,  1545,
     565,   626,   630,   976,   565,   551,   552,  1631,  1035,   646,
     850,   626,  1330,  1152,   294,   854,   855,   565,   565,  1036,
     260,   565,   260,  1605,   565,   619,  1383,   878,   476,  1383,
    1589,   557,   558,  1236,  1814,   565,  1009,   474,   565,  -163,
    1850,  1494,  1383,  1038,  1195,  1408,   565,  -574,   881,  1504,
    1777,  1636,   565,   642,   565,  1884,  1263,   591,   565,   565,
     466,   467,  1004,  1539,  1399,    69,  -103,    71,    72,  1199,
    -574, -1116,  1208,  1778,   565,    86,   565,   858,   468,   651,
     649,    92,  1209,   -45,  1440,   565,  1432,  1800,   621,  1348,
     831,  1538,   565,   565,   591,  1165,   565,  1258,  1487,   565,
     565,   565,  1044,  1618,   565,   565,  1400,   565,  1499,  1020,
    1332,  1448,  1384,   565,  1906,  -104,  1500,  1391,  1932,   565,
     565,   565,  1401,  1159, -1119,   565,  1258,   565,   924,   624,
    1177,  1607,   565,  1237,   565,   589,  1529,   832,   565,   565,
     632,  1842,  1356,  1702,   565,   938,   306,  1784,  1374,    94,
    1735,  1029,  -103,  1815,   470,  1668,  1785,   452,  1521,   565,
     617,   615,  1047,  1736,  1843,  1522,   902,  1608,  1402,   565,
     289,  1583,   643,  1669,    73,   631,  1355,  1210,   902,   454,
   -1119,  1428,   833,  1595,  1053,   858,  1178,  1523,  1737,   313,
      89,   616,   471,  1211,  1801,   633,  1166,    91,   414,   291,
    1167,   260,   565,  1403,   260,   860,  1433,   565,  1253,  1259,
    1501,  1933,   260,  1530,   565,  1352,  1722,  1712,   996,   260,
    1449,   260,   260,  1675,   758,   883,   260,   566,   795,  1385,
    1619,   566,  -104,   260,   260,  1022,   669,  1638,  1259,   834,
    1302,  1885,   260,  1183,   566,   565,  1802,  1376,   566,  1907,
    1546,   566,  1447,   662,  1540,  1606,   665,  1435,  1026,  1527,
     469,  1753,   566,   565,   758,   566,  1021,  1051,    87,  -103,
     565,   968,  -574,   566,   651,  1779,  1786,  1576,   622,   566,
     620,   566,  1357,  1774,  1886,   566,   566,   565,   565,   565,
    1537,   604,   879,  1340,  1806,  1832,  1196,  1797,   414,  1632,
     565,   566,  1851,   566,   992,  1535,   267,   565,  1887,   604,
    1692,  1542,   566,   565,  1696,   787,   598,   260,   260,   566,
     566,  1836,  1404,   566,   670,  1264,   566,   566,   566,  1030,
    1386,   566,   566,  -104,   566,   852,   453,   565,  1265,   418,
     566,   260,   260,  1493,   976,   565,   566,   566,   566,   841,
     565,  1133,   566,  1186,   566,  1327,  1238,   565,   370,   566,
    1503,   566,   274,  1090,   567,   566,   566,   652,   567,  1787,
    -103,   566,   270,  1095,  1053,  1609,  1262,   954,   925,  1136,
     658,   567,   567,   660,   565,   567,   566,  1155,   567,   260,
     260,   873,   260,   758,   939,  1108,   566,   763,   764,   567,
    1194,  1859,   567,  1875,  1876,   260,  1878,  1193,   260,   886,
     567,   763,   901,  1871,   260,  1028,   567,   260,   567,  1890,
    1141,  1142,   567,   567,   626,  1137,  1138,  1291,  1292,   566,
    1581,  1304,  1305,   890,   566,  1637,  1825,   280,   567,   260,
     567,   566,  1135,  1902,  1288,  1903,  1904,  1324,  1325,   567,
     891,  1145,   975,  1502,   565,    67,   567,   567,    68,   899,
     567,  1855,   565,   567,   567,   567,   900,   903,   567,   567,
     910,   567,   566,   915,   916,   918,   966,   567,   919,   923,
    1634,   940,   260,   567,   567,   567,  1707,  1289,   271,   567,
     566,   567,  1303,   260,  1290,  1297,   567,   566,   567,  1306,
     281,  1307,   567,   567,   565,  1704,  1592,   885,   567,  1613,
     565,   892,   893,   845,   566,   566,   566,   898,   277,   260,
    1508,   839,   260,   567,   842,   590,  1848,   566,   669,  1363,
     294,   260,   906,   567,   566,   853,    75,   606,   864,   565,
     566,  1626,   907,  -780,   370,  1017,   260,    63,   846,   260,
     565,   296,   565,   565,   565,   565,  1323,   260,   565,  1023,
     260,   300,   580,   996,   566,   870,   567,  1407,  1690,   758,
     565,   567,   566,   298,  -612,   911,   565,   566,   567,  1883,
     912,    22,   260,   565,   566,  1721,   565,   914,   260,  1862,
     260,  1078,  1579,   565,   969,  1891,   565,   507,   565,   669,
    1721,  1026,   804,   370,  1614,  1615,    78,   758,  1274,   567,
      82,   566,   956,   261,  1322,  1140,   681,  -612,   917,   278,
    1509,   276,  1693,  1413,   766,  1688,  1697,   567,  1117,  1382,
     303,   565,   565,  1001,   567,  1382,  1418,  -612,  1392,  -612,
    1001,  1406,   758,   286,  -780,  1750,  -612,   669,  1411,  1412,
    -612,   567,   567,   567,  1415,   288,   544,  1143,   949,   957,
    -612,   920,   928,  1776,   567,  -612,  1165,   847,  1002,   305,
    -612,   567,  1186,   929,  1508,   583,  -612,   567,  1715,   624,
     944,   566,    30,   411,  -612,   286,  1272,   722,  -612,   566,
    1264,    64,   961,   580,   813,  -612,    65,   457,  1833,  1834,
     260,   567,    64,  1265,  1764,  1765,   813,    65,   669,   567,
    1286,   813,  1823,  1210,   567,   598,   984,  -163,  1293,   814,
    1457,   567,  -612,  1294,  1677,   767,  1771,   450,  -612,  1211,
    1295,   566,  1155,  1462,  1463,   726,  -612,   566,   758,  1772,
     260,   260,   858,   580,  -612,   805,   260,  1893,   567,  1470,
     461,   822,  1792,  1793,  1857,  1119,  1121,  1296,   649,   950,
     806,   958,   463,  1344,   260,   477,   566,  1166,  1468,   473,
     260,  -612,  1897,  1894,  1509,  1895,   479,   566,  -612,   566,
     566,   566,   566,   815,   816,   566,   260,   482,   815,   816,
    1393,   -57,    76,  -612,   962,  1578,   743,   566,   882,   883,
    -612,  1482,  1898,   566,  -612,   421,   583,  1158,  1382,   332,
     566,   486,   817,   566,  1420,  1421,   487,   307,   567,  -612,
     566,  -612,   490,   566,  -612,   566,   567,  1298,   491,  1382,
    -612,   579,  1394,   580,   590,  1301,   783,    80,  -612,   823,
     884,   883,  -612,   584,   585,   586,   587,   588,  1422,  -612,
     495,   337,  1912,   496,  1345,  -612,   583,   370,   566,   566,
     593,  1423,  -612,  -612,   286,  1346,   497,   286,   567,  1035,
    1899,  1124,   883,  1347,   567,   458,  -612,  -612,  1161,  1162,
    1036,   594,   286,  1308,   286,   286,  1424,   498,   260,   475,
    -612,  -612,  -612,   422,  1395,  -612,   483,   484,  -612,   499,
    -163,   913,   601,   567,  1038,   286,   580,   500,  1628,   260,
     963,  1348,  1310,   345,   567,   260,   567,   567,   567,   567,
     964,  -232,   567,  1312,   604,  1314,  1315,  1475,  1476,  1396,
    1889,  1477,  -612,   501,   567,   473,   308,   260,   784,   260,
     567,   649,  1208,  1591,   260,  1418,   583,   567,   355,  1594,
     567,   758,   309,  1382,   317,    68,  1596,   567,   607,  1597,
     567,   260,   567,  1044,   504,  1250,  1598,  1349,   624,  1599,
     432,  1759,  1653,   505,   581,  -612,   586,   587,   588,  1647,
     562,   563,  1650,   731,  1651,   433,   434,   260,   506,   582,
     260,   260,    64,   435,   509,   567,   567,    65,  1930,  1931,
    1731,  1425,   510,  1654,   286,   286,   511,  1655,  1716,  -612,
    1350,  1299,   883,   646,   492,   332,   629,  -612,  1426,   583,
     512,  1344,  1226,  1047,   584,   585,   586,   587,   588,   634,
     473,  -612,  1061,   792,   793,   436,   513,   796,   798,   800,
     801,   802,   803,   514,  1656,  -612,  -612,  1210,  1397,  -612,
     515,   336,   647,   648,   785,   286,   516,   337,   437,  1443,
    1444,  1481,   883,  1211,   786,  1547,  1444,   377,   286,  1082,
     519,   286,   520,   339,   521,   438,   439,   286,  1354,  1657,
     286,  1585,  1586,   636,  1611,  1593,   883,   649,  1083,   758,
     440,   260,   522,    81,  1603,   883,   260,   653,   423,   424,
     425,   426,   523,   260,   524,   441,  1751,  1752,  1794,  1752,
     525,   427,  1345,   260,   584,   585,   586,   587,   588,   345,
     527,  1084,   529,  1346,  1085,  1798,  1799,  -165,  1051,   260,
     530,  1347,  1086,   531,  1218,  1846,  1752,  1221,   260,  1227,
    1847,  1752,  1229,  1419,   260,   759,   532,   260,  1234,   533,
     260,  1732,   260,   354,   355,  1441,   777,   260,   260,  1856,
     260,  1852,  1853,   260,   260,   534,   696,   535,   260,  1348,
     442,  1452,   536,   260,   260,   537,   473,   317,   538,  1658,
     260,   539,   777,  1762,  1659,   809,   540,   584,   585,   586,
     587,   588,   654,  1344,   821,   541,   260,  1869,  1870,  1913,
    1870,   542,   829,  1660,  1914,  1870,   546,   443,   547,   286,
    1944,  1943,   286,  1946,  1947,   548,   747,   606,  1685,  1686,
     851,   749,   749,   286,   549,  1349,  1795,  1796,  1035,   758,
     700,  1716,  1514,  1515,   550,  1062,   553,   554,   332,  1036,
     555,  1661,   556,   592,   444,   286,   618,   445,   260,   655,
     656,   868,   659,   286,   661,   663,   260,   673,   973,   370,
     260,   684,  1717,  1038,   685,   714,   669,   756,  1350,   375,
     765,   771,   794,   377,   336,   810,   812,   646,  1035,   811,
     337,   825,   830,   701,  1345,   840,   704,   446,   773,  1036,
     856,   857,   862,   705,   260,  1346,   339,   871,   875,   888,
     649,   889,   260,  1347,  1662,   896,   894,  1718,  1719,  -163,
     895,   902,   905,  1038,   909,   921,   952,   260,   922,   927,
     941,   565,  1044,  1939,     1,     2,   930,   931,  1945,   758,
     942,   943,  1344,   706,   960,   565,     3,  -461,   260,  1549,
    -378,  1348,   345,   508,   545,   965,   974,   758,  1939,   980,
     649,   981,  1027,   987,   758,  1766,  1010,   260,  1808,     4,
       5,   260,   708,   955,   260,  1015,  1018,  1069,   260,     6,
    1072,  1076,  1044,   260,  1081,  1091,   354,   355,  1092,  1093,
    1101,     7,  1047,  1002,  1102,  1001,   646,   646,  1113,   646,
     692,   693,   694,   695,   696,  1128,  1130,  1349,  1131,  1132,
    1139,  1148,   646,   286,   286,     8,     9,    10,  1149,   997,
    1160,  1550,  1157,  1190,    11,  1551,  1200,  1208,  1224,  1223,
    1225,  1230,  1232,  1345,  1235,    12,   646,  1013,   646,   646,
    1242,  1552,  1047,  1019,  1346,  1854,  1243,  1267,   858,   260,
    1350,  1270,  1347,  1275,    13,   260,  1278,   883,  1281,   759,
     709,  1282,  1317,  1321,  1319,   697,   698,   699,   700,   711,
    1326,   813,   260,  1331,  1553,  1353,  1361,  1554,  1362,  1366,
     260,  1409,  1410,   260,  1365,  1555,    14,  1439,  1442,  1445,
    1348,  1459,   370,  1454,  1460,  1717,  1556,  1051,    15,  1461,
    1464,  1484,   375,  1489,  1488,  1495,   377,  1505,  1496,    16,
    1557,  1497,  1516,  1533,  1519,   682,  1528,  1534,  1544,   260,
    1580,   701,   702,   703,   704,  1558,  1574,  1582,  1584,  1587,
    1588,   705,  1590,  1612,  1616,   723,  1617,  1620,   727,  1621,
    1718,  1719,  1629,  1633,  1630,  1640,  1349,  1051,  1639,  1641,
    1645,  1648,   739,   740,  1652,  1670,   744,  1671,   566,  1674,
    1682,   777,  1559,  1687,  1694,  1683,  1695,  1708,  1713,   760,
     761,   706,  1726,  1714,  1728,  1739,  1729,  1740,   260,  1741,
    1743,  1744,  1150,  1745,   260,  1746,    17,    18,   759,  1350,
      19,  1747,  1754,   260,  1749,   570,   571,    20,  1758,   707,
     708,  1760,  -529,    21,  -534,  1790,  1803,    22,  1770,  1809,
    1187,  1810,  1189,   260,  1586,    23,  1807,   777,    24,   572,
    1822,   260,  1811,   573,  1560,  1812,   260,  1821,  1837,  1827,
    1829,  1838,    25,  1839,   777,  1840,  1860,  1872,  1866,  1877,
    1868,  1879,  1880,  1435,  1905,  1908,  1909,  1910,   574,  1915,
    1916,  1919,   260,   260,  1920,  1921,  1561,   575,  1676,  1940,
    1249,  1917,  1918,   286,  1249,  1922,    26,   692,   693,   694,
     695,   696,  1942,  1430,  1943,   576,    27,    28,  1241,   866,
      29,  1246,  1577,  1436,  1562,   874,  1212,  1642,   709,  1277,
    1387,   260,  1643,  1672,  1730,   567,   710,   711,   577,  1882,
    1451,  1266,  1742,  1820,  1858,  1429,  1164,   983,    30,   260,
     456,   641,  1127,   455,   611,  1000,  1483,  1089,  1328,  1507,
    1126,  1929,  1691,  1874,  1835,  1949,  1146,   750,  1689,  1563,
     683,  1564,   697,   698,   699,   700,  1644,   904,   260,  1180,
    1635,   908,  1710,   485,   489,   599,   872,  1486,   990,  1338,
     481,  1948,  1861,   664,  1375,  1329,  1841,  1863,   926,  1565,
    1566,   260,  1892,  1881,   997,  1950,  1011,   828,   690,  1343,
    1341,  1734,  1373,  1525,   391,  1711,   286,   419,     0,   603,
       0,     0,     0,     0,     0,     0,  1364,     0,   701,   702,
     703,   704,     0,     0,     0,     0,     0,     0,   705,     0,
       0,     0,   759,     0,     0,   260,     0,   260,     0,   260,
       0,  1249,     0,     0,     0,     0,  1033,  1249,     0,     0,
    1249,  1034,     0,  1249,     0,   777,     0,     0,     0,  1035,
    1249,  1249,     0,   777,     0,     0,  1249,   759,   706,     0,
    1036,   286,     0,     0,     0,     0,  1249,  1431,     0,     0,
    1033,     0,     0,   286,  1037,  1034,   260,   260,     0,     0,
       0,   260,     0,  1035,  1038,     0,   707,   708,     0,   286,
       0,     0,     0,     0,  1036,   260,  1039,     0,     0,   260,
       0,     0,   260,     0,     0,     0,   260,     0,  1037,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1038,     0,
       0,   649,     0,     0,     0,     0,  1040,  1041,     0,     0,
    1039,  1042,     0,     0,     0,     0,     0,     0,  1043,     0,
       0,  1480,  -228,  1044,     0,     0,     0,     0,     0,  1187,
       0,     0,     0,   759,     0,   649,     0,     0,     0,     0,
    1040,     0,  1045,     0,     0,  1042,     0,     0,     0,     0,
       0,     0,  1043,     0,     0,   709,     0,  1044,     0,     0,
       0,     0,     0,   710,   711,     0,  1046,  1150,     0,     0,
       0,     0,     0,     0,     0,  1013,  1045,     0,     0,     0,
       0,     0,     0,  1047,     0,     0,     0,     0,     0,     0,
    1249,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   493,     0,     0,     0,     0,     0,
       0,  1249,     0,     0,     0,     0,     0,  1047,     0,     0,
       0,  1048,     0,     0,     0,     0,     0,     0,     0,   518,
     777,     0,     0,     0,  1548,     0,     0,   286,   526,     0,
       0,  1573,     0,     0,     0,     0,  1249,     0,     0,  1049,
       0,     0,     0,     0,     0,  1048,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   559,  1050,     0,     0,     0,     0,     0,
       0,     0,     0,  1049,     0,     0,     0,     0,  1051,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1050,     0,
       0,     0,  1623,     0,     0,     0,     0,     0,   777,     0,
       0,     0,  1051,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1249,     0,     0,     0,     0,
       0,     0,     0,  1249,     0,     0,   759,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   668,     0,     0,     0,
       0,   675,  1681,     0,   679,   680,     0,     0,     0,     0,
       0,   686,   687,   688,     0,   689,     0,     0,     0,     0,
     716,   717,   718,   719,     0,   721,     0,   724,   725,     0,
     728,   729,     0,   730,     0,     0,   732,   733,   734,   735,
     736,   737,   738,     0,     0,   741,   742,     0,   745,     0,
     746,     0,     0,     0,   754,   755,     0,     0,     0,     0,
       0,  1681,   762,     0,     0,     0,     0,  1725,   770,     0,
       0,     0,     0,   779,   780,   781,   777,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1748,     0,     0,     0,
       0,     0,     0,     0,   759,     0,     0,     0,     0,   286,
       0,     0,     0,     0,     0,     0,   827,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   844,     0,
       0,     0,     0,     0,     0,  1681,  1681,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1681,     0,     0,     0,     0,   877,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1831,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1849,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   759,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   933,   935,   937,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1831,     0,
    1831,     0,  1896,     0,     0,     0,     0,     0,     0,     0,
     967,     0,     0,   971,     0,   972,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1928,
    1928,     0,     0,     0,   759,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   777,     0,
       0,     0,   759,     0,     0,  1928,     0,     0,     0,   759,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1075,
       0,     0,  1077,     0,  1079,  1080,     0,     0,     0,  1088,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1094,     0,     0,  1096,  1097,  1098,  1099,  1100,
       0,     0,     0,     0,     0,     0,  1103,     0,     0,  1104,
       0,  1105,  1106,     0,  1107,     0,     0,     0,     0,  1110,
    1111,  1112,     0,     0,     0,     0,  1114,  1115,  1116,     0,
    1118,     0,  1120,     0,  1122,     0,  1123,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1144,     0,  1147,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1271,     0,     0,     0,  1273,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1284,  1285,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1300,     0,     0,     0,     0,
       0,     0,     0,  1309,     0,  1311,     0,  1313,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1334,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1371,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1334,  1378,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1453,     0,     0,     0,     0,     0,
    1458,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1466,  1467,     0,     0,     0,
       0,     0,     0,  1469,     0,     0,     0,     0,  1471,     0,
       0,  1472,  1473,  1474,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1334,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1526,     0,     0,     0,     0,     0,     0,     0,     0,  1532,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1334,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1378,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1684,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1378,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1371,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1768,  1769,     0,     0,     0,  1775,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    95,
       0,   314,    97,    98,     0,     0,     0,     0,    99,     0,
       0,     0,   100,   101,   102,   315,     0,   104,     0,     0,
     316,   317,   105,     0,   106,   107,   108,   109,   751,   110,
       0,   111,     0,     0,   112,   318,   319,   113,  1378,   320,
     114,     0,   115,   321,     0,   322,   118,     0,   119,   120,
     121,   122,   123,   124,     0,   125,   126,     0,   127,     0,
     323,   324,     0,     0,   128,   325,   326,     0,   327,   129,
     130,   131,   132,   328,   329,   330,     0,     0,     0,     0,
     331,   135,   332,     0,     0,   333,     0,     0,     0,  1334,
     136,   137,  1865,     0,  1867,     0,   138,   139,   140,     0,
       0,     0,   141,     0,   142,   143,     0,   144,   145,     0,
       0,   146,     0,   147,   148,   334,   149,   335,   336,     0,
     150,   151,   152,   153,   337,   154,     0,     0,     0,   155,
     156,     0,   157,     0,   158,     0,   338,     0,   159,     0,
     339,     0,     0,     0,   340,   161,   162,   163,   341,     0,
     164,   165,     0,     0,     0,     0,     0,   342,   343,     0,
       0,     0,     0,   166,     0,     0,     0,   167,     0,     0,
     168,     0,   752,   344,   169,     0,     0,     0,     0,   170,
       0,   171,     0,   172,     0,   173,   345,     0,     0,     0,
       0,   174,   175,   346,   176,   177,   178,   347,     0,     0,
     348,   181,   349,   182,     0,   183,   350,   351,   185,   186,
     187,     0,     0,     0,   188,   189,   190,   352,   353,   191,
     354,   355,     0,   192,   193,     0,   194,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,     0,   198,   199,
     200,   356,     0,   201,     0,   202,   203,   357,   205,     0,
       0,   206,     0,     0,     0,   207,     0,     0,     0,   208,
     358,   359,     0,   209,     0,   360,     0,   361,   211,   212,
     213,   214,   215,   362,   217,     0,   363,   219,     0,     0,
       0,   220,   221,   222,   223,     0,     0,     0,   224,     0,
     225,   226,   227,     0,     0,     0,     0,     0,   228,     0,
       0,     0,     0,   229,   230,   364,   365,   231,   232,     0,
       0,   233,   366,   235,   367,   368,   236,   237,   238,   369,
     239,   240,     0,     0,   241,     0,   370,   242,     0,   371,
     372,   373,     0,   753,   246,   374,   375,   376,   248,   249,
     377,   250,   251,     0,     0,     0,   252,     0,     0,     0,
     378,     0,     0,   379,   380,   381,   254,     0,     0,   255,
     382,     0,   383,   256,   257,     0,     0,     0,     0,   258,
       0,     0,     0,   384,   385,   386,     0,     0,     0,   387,
       0,     0,     0,   388,     0,   389,   390,    95,     0,   314,
      97,    98,  1367,     0,     0,     0,    99,     0,     0,     0,
     100,   101,   102,   315,     0,   104,     0,     0,  1368,   317,
     105,     0,   106,   107,   108,   109,     0,   110,     0,   111,
       0,     0,   112,   318,   319,   113,     0,   320,   114,     0,
     115,   321,     0,   322,   118,     0,   119,   120,   121,   122,
     123,   124,     0,   125,   126,     0,   127,     0,   323,   324,
       0,     0,   128,   325,   326,     0,   327,   129,   130,   131,
     132,   328,   329,   330,     0,     0,     0,     0,   331,   135,
     332,     0,     0,  1369,     0,     0,     0,     0,   136,   137,
       0,     0,     0,     0,   138,   139,   140,     0,     0,     0,
     141,     0,   142,   143,     0,   144,   145,     0,     0,   146,
       0,   147,   148,   334,   149,   335,   336,     0,   150,   151,
     152,   153,   337,   154,     0,     0,     0,   155,   156,     0,
     157,     0,   158,     0,   338,     0,   159,     0,   339,     0,
       0,     0,   340,   161,   162,   163,   341,     0,   164,   165,
       0,     0,     0,     0,     0,   342,   343,     0,     0,     0,
       0,   166,     0,     0,     0,   167,     0,     0,   168,     0,
       0,   344,   169,     0,     0,     0,     0,   170,     0,   171,
       0,   172,     0,   173,   345,     0,     0,     0,     0,   174,
     175,   346,   176,   177,   178,   347,     0,     0,   348,   181,
     349,   182,     0,   183,   350,   351,   185,   186,   187,     0,
       0,     0,   188,   189,   190,   352,   353,   191,   354,   355,
       0,   192,   193,  1370,   194,   195,   196,   197,     0,     0,
       0,     0,     0,     0,     0,     0,   198,   199,   200,   356,
       0,   201,     0,   202,   203,   357,   205,     0,     0,   206,
       0,     0,     0,   207,     0,     0,     0,   208,   358,   359,
       0,   209,     0,   360,     0,   361,   211,   212,   213,   214,
     215,   362,   217,     0,   363,   219,     0,     0,     0,   220,
     221,   222,   223,     0,     0,     0,   224,     0,   225,   226,
     227,     0,     0,     0,     0,     0,   228,     0,     0,     0,
       0,   229,   230,   364,   365,   231,   232,     0,     0,   233,
     366,   235,   367,   368,   236,   237,   238,   369,   239,   240,
       0,     0,   241,     0,   370,   242,     0,   371,   372,   373,
       0,     0,   246,   374,   375,   376,   248,   249,   377,   250,
     251,     0,     0,     0,   252,     0,     0,     0,   378,     0,
       0,   379,   380,   381,   254,     0,     0,   255,   382,     0,
     383,   256,   257,     0,     0,     0,     0,   258,     0,     0,
       0,   384,   385,   386,     0,     0,    95,   387,   314,    97,
      98,   388,     0,   389,   390,    99,     0,     0,     0,   100,
     101,   102,   315,     0,   104,     0,     0,   316,   317,   105,
       0,   106,   107,   108,   109,     0,   110,     0,   111,     0,
       0,   112,   318,   319,   113,     0,   320,   114,     0,   115,
     321,     0,   322,   118,     0,   119,   120,   121,   122,   123,
     124,     0,   125,   126,     0,   127,     0,   323,   324,     0,
       0,   128,   325,   326,     0,   327,   129,   130,   131,   132,
     328,   329,   330,     0,     0,     0,     0,   331,   135,   332,
       0,     0,   333,     0,     0,     0,     0,   136,   137,     0,
       0,     0,     0,   138,   139,   140,     0,     0,     0,   141,
       0,   142,   143,     0,   144,   145,     0,     0,   146,     0,
     147,   148,   334,   149,   335,   336,     0,   150,   151,   152,
     153,   337,   154,     0,     0,     0,   155,   156,     0,   157,
       0,   158,     0,   338,     0,   159,     0,   339,     0,     0,
       0,   340,   161,   162,   163,   341,     0,   164,   165,     0,
       0,     0,     0,     0,   342,   343,     0,     0,     0,     0,
     166,     0,     0,     0,   167,     0,     0,   168,     0,     0,
     344,   169,     0,     0,     0,     0,   170,     0,   171,     0,
     172,     0,   173,   345,     0,     0,     0,     0,   174,   175,
     346,   176,   177,   178,   347,     0,     0,   348,   181,   349,
     182,     0,   183,   350,   351,   185,   186,   187,     0,     0,
       0,   188,   189,   190,   352,   353,   191,   354,   355,     0,
     192,   193,     0,   194,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,     0,   198,   199,   200,   356,     0,
     201,     0,   202,   203,   357,   205,     0,     0,   206,     0,
       0,     0,   207,     0,     0,     0,   208,   358,   359,     0,
     209,     0,   360,     0,   361,   211,   212,   213,   214,   215,
     362,   217,     0,   363,   219,     0,     0,     0,   220,   221,
     222,   223,     0,     0,     0,   224,     0,   225,   226,   227,
       0,     0,     0,     0,     0,   228,     0,     0,     0,     0,
     229,   230,   364,   365,   231,   232,     0,     0,   233,   366,
     235,   367,   368,   236,   237,   238,   369,   239,   240,     0,
       0,   241,     0,   370,   242,     0,   371,   372,   373,     0,
       0,   246,   374,   375,   376,   248,   249,   377,   250,   251,
       0,     0,     0,   252,     0,     0,     0,   378,     0,     0,
     379,   380,   381,   254,     0,     0,   255,   382,     0,   383,
     256,   257,     0,     0,     0,     0,   258,     0,     0,     0,
     384,   385,   386,     0,     0,     0,   387,   684,     0,     0,
     388,     0,   389,   390,    95,     0,   314,    97,    98,     0,
       0,     0,     0,    99,     0,     0,     0,   100,   101,   102,
     315,     0,   104,     0,     0,   316,   317,   105,     0,   106,
     107,   108,   109,     0,   110,     0,   111,     0,     0,   112,
     318,   319,   113,     0,   320,   114,     0,   115,   321,     0,
     322,   118,     0,   119,   120,   121,   122,   123,   124,     0,
     125,   126,     0,   127,     0,   323,   324,     0,     0,   128,
     325,   326,     0,   327,   129,   130,   131,   132,   328,   329,
     330,     0,     0,     0,     0,   331,   135,   332,     0,     0,
     333,     0,     0,     0,     0,   136,   137,     0,     0,     0,
       0,   138,   139,   140,     0,     0,     0,   141,     0,   142,
     143,     0,   144,   145,     0,     0,   146,     0,   147,   148,
     334,   149,   335,   336,     0,   150,   151,   152,   153,   337,
     154,     0,     0,     0,   155,   156,   932,   157,     0,   158,
       0,   338,     0,   159,     0,   339,     0,     0,     0,   340,
     161,   162,   163,   341,     0,   164,   165,     0,     0,     0,
       0,     0,   342,   343,     0,     0,     0,     0,   166,     0,
       0,     0,   167,     0,     0,   168,     0,     0,   344,   169,
       0,     0,     0,     0,   170,     0,   171,     0,   172,     0,
     173,   345,     0,     0,     0,     0,   174,   175,   346,   176,
     177,   178,   347,     0,     0,   348,   181,   349,   182,     0,
     183,   350,   351,   185,   186,   187,     0,     0,     0,   188,
     189,   190,   352,   353,   191,   354,   355,     0,   192,   193,
       0,   194,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,     0,   198,   199,   200,   356,     0,   201,     0,
     202,   203,   357,   205,     0,     0,   206,     0,     0,     0,
     207,     0,     0,     0,   208,   358,   359,     0,   209,     0,
     360,     0,   361,   211,   212,   213,   214,   215,   362,   217,
       0,   363,   219,     0,     0,     0,   220,   221,   222,   223,
       0,     0,     0,   224,     0,   225,   226,   227,     0,     0,
       0,     0,     0,   228,     0,     0,     0,     0,   229,   230,
     364,   365,   231,   232,     0,     0,   233,   366,   235,   367,
     368,   236,   237,   238,   369,   239,   240,     0,     0,   241,
       0,   370,   242,     0,   371,   372,   373,     0,     0,   246,
     374,   375,   376,   248,   249,   377,   250,   251,     0,     0,
       0,   252,     0,     0,     0,   378,     0,     0,   379,   380,
     381,   254,     0,     0,   255,   382,     0,   383,   256,   257,
       0,     0,     0,     0,   258,     0,     0,     0,   384,   385,
     386,     0,     0,    95,   387,   314,    97,    98,   388,     0,
     389,   390,    99,     0,     0,     0,   100,   101,   102,   315,
       0,   104,     0,     0,   316,   317,   105,     0,   106,   107,
     108,   109,     0,   110,     0,   111,     0,     0,   112,   318,
     319,   113,     0,   320,   114,     0,   115,   321,     0,   322,
     118,     0,   119,   120,   121,   122,   123,   124,     0,   125,
     126,     0,   127,     0,   323,   324,     0,     0,   128,   325,
     326,     0,   327,   129,   130,   131,   132,   328,   329,   330,
       0,     0,     0,     0,   331,   135,   332,     0,     0,   333,
       0,     0,     0,     0,   136,   137,     0,     0,     0,     0,
     138,   139,   140,     0,     0,     0,   141,     0,   142,   143,
       0,   144,   145,     0,     0,   146,     0,   147,   148,   334,
     149,   335,   336,     0,   150,   151,   152,   153,   337,   154,
       0,     0,     0,   155,   156,   934,   157,     0,   158,     0,
     338,     0,   159,     0,   339,     0,     0,     0,   340,   161,
     162,   163,   341,     0,   164,   165,     0,     0,     0,     0,
       0,   342,   343,     0,     0,     0,     0,   166,     0,     0,
       0,   167,     0,     0,   168,     0,     0,   344,   169,     0,
       0,     0,     0,   170,     0,   171,     0,   172,     0,   173,
     345,     0,     0,     0,     0,   174,   175,   346,   176,   177,
     178,   347,     0,     0,   348,   181,   349,   182,     0,   183,
     350,   351,   185,   186,   187,     0,     0,     0,   188,   189,
     190,   352,   353,   191,   354,   355,     0,   192,   193,     0,
     194,   195,   196,   197,     0,     0,     0,     0,     0,     0,
       0,     0,   198,   199,   200,   356,     0,   201,     0,   202,
     203,   357,   205,     0,     0,   206,     0,     0,     0,   207,
       0,     0,     0,   208,   358,   359,     0,   209,     0,   360,
       0,   361,   211,   212,   213,   214,   215,   362,   217,     0,
     363,   219,     0,     0,     0,   220,   221,   222,   223,     0,
       0,     0,   224,     0,   225,   226,   227,     0,     0,     0,
       0,     0,   228,     0,     0,     0,     0,   229,   230,   364,
     365,   231,   232,     0,     0,   233,   366,   235,   367,   368,
     236,   237,   238,   369,   239,   240,     0,     0,   241,     0,
     370,   242,     0,   371,   372,   373,     0,     0,   246,   374,
     375,   376,   248,   249,   377,   250,   251,     0,     0,     0,
     252,     0,     0,     0,   378,     0,     0,   379,   380,   381,
     254,     0,     0,   255,   382,     0,   383,   256,   257,     0,
       0,     0,     0,   258,     0,     0,     0,   384,   385,   386,
       0,     0,    95,   387,   314,    97,    98,   388,     0,   389,
     390,    99,     0,     0,     0,   100,   101,   102,   315,     0,
     104,     0,     0,   316,   317,   105,     0,   106,   107,   108,
     109,     0,   110,     0,   111,     0,     0,   112,   318,   319,
     113,     0,   320,   114,     0,   115,   321,     0,   322,   118,
       0,   119,   120,   121,   122,   123,   124,     0,   125,   126,
       0,   127,     0,   323,   324,     0,     0,   128,   325,   326,
       0,   327,   129,   130,   131,   132,   328,   329,   330,     0,
       0,     0,     0,   331,   135,   332,     0,     0,   333,     0,
       0,     0,     0,   136,   137,     0,     0,     0,     0,   138,
     139,   140,     0,     0,     0,   141,     0,   142,   143,     0,
     144,   145,     0,     0,   146,     0,   147,   148,   334,   149,
     335,   336,     0,   150,   151,   152,   153,   337,   154,     0,
       0,     0,   155,   156,   936,   157,     0,   158,     0,   338,
       0,   159,     0,   339,     0,     0,     0,   340,   161,   162,
     163,   341,     0,   164,   165,     0,     0,     0,     0,     0,
     342,   343,     0,     0,     0,     0,   166,     0,     0,     0,
     167,     0,     0,   168,     0,     0,   344,   169,     0,     0,
       0,     0,   170,     0,   171,     0,   172,     0,   173,   345,
       0,     0,     0,     0,   174,   175,   346,   176,   177,   178,
     347,     0,     0,   348,   181,   349,   182,     0,   183,   350,
     351,   185,   186,   187,     0,     0,     0,   188,   189,   190,
     352,   353,   191,   354,   355,     0,   192,   193,     0,   194,
     195,   196,   197,     0,     0,     0,     0,     0,     0,     0,
       0,   198,   199,   200,   356,     0,   201,     0,   202,   203,
     357,   205,     0,     0,   206,     0,     0,     0,   207,     0,
       0,     0,   208,   358,   359,     0,   209,     0,   360,     0,
     361,   211,   212,   213,   214,   215,   362,   217,     0,   363,
     219,     0,     0,     0,   220,   221,   222,   223,     0,     0,
       0,   224,     0,   225,   226,   227,     0,     0,     0,     0,
       0,   228,     0,     0,     0,     0,   229,   230,   364,   365,
     231,   232,     0,     0,   233,   366,   235,   367,   368,   236,
     237,   238,   369,   239,   240,     0,     0,   241,     0,   370,
     242,     0,   371,   372,   373,     0,     0,   246,   374,   375,
     376,   248,   249,   377,   250,   251,     0,     0,     0,   252,
       0,     0,     0,   378,     0,     0,   379,   380,   381,   254,
       0,     0,   255,   382,     0,   383,   256,   257,     0,     0,
       0,     0,   258,     0,     0,     0,   384,   385,   386,     0,
       0,    95,   387,   314,    97,    98,   388,     0,   389,   390,
      99,     0,     0,     0,   100,   101,   102,   315,     0,   104,
       0,     0,   316,   317,   105,     0,   106,   107,   108,   109,
       0,   110,     0,   111,     0,     0,   112,   318,   319,   113,
       0,   320,   114,     0,   115,   321,     0,   322,   118,     0,
     119,   120,   121,   122,   123,   124,     0,   125,   126,     0,
     127,     0,   323,   324,     0,     0,   128,   325,   326,     0,
     327,   129,   130,   131,   132,   328,   329,   330,     0,     0,
       0,     0,   331,   135,   332,     0,     0,   333,     0,     0,
       0,     0,   136,   137,     0,     0,     0,     0,   138,   139,
     140,     0,     0,     0,   141,     0,   142,   143,     0,   144,
     145,     0,     0,   146,     0,   147,   148,   334,   149,   335,
     336,     0,   150,   151,   152,   153,   337,   154,     0,     0,
       0,   155,   156,     0,   157,     0,   158,     0,   338,     0,
     159,     0,   339,     0,     0,     0,   340,   161,   162,   163,
     341,     0,   164,   165,     0,     0,     0,     0,     0,   342,
     343,     0,     0,     0,     0,   166,     0,     0,     0,   167,
       0,     0,   168,     0,     0,   344,   169,     0,     0,     0,
       0,   170,     0,   171,     0,   172,     0,   173,   345,     0,
       0,     0,     0,   174,   175,   346,   176,   177,   178,   347,
       0,     0,   348,   181,   349,   182,     0,   183,   350,   351,
     185,   186,   187,     0,     0,     0,   188,   189,   190,   352,
     353,   191,   354,   355,     0,   192,   193,     0,   194,   195,
     196,   197,     0,     0,     0,     0,     0,     0,     0,     0,
     198,   199,   200,   356,     0,   201,     0,   202,   203,   357,
     205,     0,     0,   206,     0,     0,     0,   207,     0,     0,
       0,   208,   358,   359,     0,   209,     0,   360,     0,   361,
     211,   212,   213,   214,   215,   362,   217,     0,   363,   219,
       0,     0,     0,   220,   221,   222,   223,     0,     0,     0,
     224,     0,   225,   226,   227,     0,     0,     0,     0,     0,
     228,     0,     0,     0,     0,   229,   230,   364,   365,   231,
     232,     0,     0,   233,   366,   235,   367,   368,   236,   237,
     238,   369,   239,   240,     0,     0,   241,     0,   370,   242,
       0,   371,   372,   373,     0,     0,   246,   374,   375,   376,
     248,   249,   377,   250,   251,     0,     0,     0,   252,     0,
       0,     0,   378,     0,     0,   379,   380,   381,   254,     0,
       0,   255,   382,     0,   383,   256,   257,     0,     0,     0,
       0,   258,     0,     0,     0,   384,   385,   386,     0,     0,
      95,   387,   314,    97,    98,   388,     0,   389,   390,    99,
       0,     0,     0,   100,   101,   102,   315,     0,   104,     0,
       0,   316,   317,   105,     0,   106,   107,   108,   109,     0,
     110,     0,   111,     0,     0,   112,   318,   319,   113,     0,
     320,   114,     0,   115,   321,     0,   322,   118,     0,   119,
     120,   121,   122,   123,   124,     0,   125,   126,     0,   127,
       0,   323,   324,     0,     0,   128,   325,   326,     0,   327,
     129,   130,   131,   132,   328,   329,   330,     0,     0,     0,
       0,   331,   135,   332,     0,     0,   333,     0,     0,     0,
       0,   136,   137,     0,     0,     0,     0,   138,   139,   140,
       0,     0,     0,   141,     0,   142,   143,     0,   144,   145,
       0,     0,   146,     0,   147,   148,   334,   149,   335,   336,
       0,   150,   151,   152,   153,   337,   154,     0,     0,     0,
     155,   156,     0,   157,     0,   158,     0,   338,     0,   159,
       0,   339,     0,     0,     0,   340,   161,   162,   163,   341,
       0,   164,   165,     0,     0,     0,     0,     0,   342,   343,
       0,     0,     0,     0,   166,     0,     0,     0,   167,     0,
       0,   168,     0,     0,   344,   169,     0,     0,     0,     0,
     170,     0,   171,     0,   172,     0,   173,   345,     0,     0,
       0,     0,   174,   175,   346,   176,   177,   178,   347,     0,
       0,   348,   181,   349,   182,     0,   183,   350,   351,   185,
     186,   187,     0,     0,     0,   188,   189,   190,   352,   353,
     191,   354,   355,     0,   192,   193,     0,   194,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,     0,   198,
     199,   200,   356,     0,   201,     0,   202,   203,   357,   205,
       0,     0,   206,     0,     0,     0,   207,     0,     0,     0,
     208,   358,   359,     0,   209,     0,   360,     0,   361,   211,
     212,   213,   214,   215,   362,   217,     0,   363,   219,     0,
       0,     0,   220,   221,   222,   223,     0,     0,     0,   224,
       0,   225,   226,   227,     0,     0,     0,     0,     0,   228,
       0,     0,     0,     0,   229,   230,   364,   365,   231,   232,
       0,     0,   233,   366,   235,   367,   368,   236,   237,   238,
     369,   239,   240,     0,     0,   241,     0,   370,   242,     0,
     371,   372,   373,     0,     0,   246,   374,   375,   376,   248,
     249,   377,   250,   251,     0,     0,     0,   252,     0,     0,
       0,   378,     0,     0,   379,   380,   381,   254,     0,     0,
     255,   382,     0,   383,   256,   257,     0,     0,     0,     0,
     258,     0,     0,     0,   384,   385,   386,     0,     0,     0,
     517,     0,     0,     0,   388,     0,   389,   390,    95,     0,
     314,    97,    98,   788,     0,     0,     0,   789,     0,     0,
       0,   100,   101,   102,   315,     0,   104,     0,     0,   316,
     317,   105,     0,   106,   107,   108,   109,     0,   110,     0,
     111,     0,     0,   112,   318,   319,   113,     0,   320,   114,
       0,   115,   321,     0,   322,   118,     0,   119,   120,   121,
     122,   123,   124,     0,   125,   126,     0,   127,     0,   323,
     324,     0,     0,   128,   325,   326,     0,   327,   129,   130,
     131,   132,   328,   329,   330,     0,     0,     0,     0,   331,
     135,   332,     0,     0,   333,     0,     0,     0,     0,   136,
     137,     0,     0,     0,     0,   138,   139,   140,     0,     0,
       0,   141,     0,   142,   143,     0,   144,   145,     0,     0,
     146,     0,   147,   148,   334,   149,   335,   336,     0,   150,
     151,   152,   153,   337,   154,     0,     0,     0,   155,   156,
       0,   157,     0,   158,     0,   338,     0,   159,     0,   339,
       0,     0,     0,   340,   161,   162,   163,   341,     0,   164,
     165,     0,     0,     0,     0,     0,   342,   343,     0,     0,
       0,     0,   166,     0,     0,     0,   167,     0,     0,   168,
       0,     0,   344,   169,     0,     0,     0,     0,   170,     0,
     171,     0,   172,     0,   173,   345,     0,     0,     0,     0,
     174,   175,   346,   176,   177,   178,   347,     0,     0,   348,
     181,   349,   182,     0,   183,   350,   351,   185,   186,   187,
       0,     0,     0,   188,   189,   190,     0,   353,   191,   354,
     355,     0,   192,   193,     0,   194,   195,   196,   197,     0,
       0,     0,     0,     0,     0,     0,     0,   198,   199,   200,
     356,     0,   201,     0,   202,   203,   357,   205,     0,     0,
     206,     0,     0,     0,   207,     0,     0,     0,   208,   358,
     359,     0,   209,     0,   360,     0,   361,   211,   212,   213,
     214,   215,   362,   217,     0,   363,   219,     0,     0,     0,
     220,   221,   222,   223,     0,     0,     0,   224,     0,   225,
     226,   227,     0,     0,     0,     0,     0,   228,     0,     0,
       0,     0,   229,   230,   364,   365,   231,   232,     0,     0,
     233,   366,   235,   367,   368,   236,   237,   238,   369,   239,
     240,     0,     0,   241,     0,   370,   242,     0,   371,   372,
     373,     0,     0,   246,   374,   375,   376,   248,   249,   377,
     250,   251,     0,     0,     0,   252,     0,     0,     0,   378,
       0,     0,   379,   380,   381,   254,     0,     0,   255,   382,
       0,   383,   256,   257,     0,     0,     0,     0,   258,     0,
       0,     0,   384,   385,   386,     0,     0,    95,   387,   314,
      97,    98,   388,     0,   389,   390,    99,     0,     0,     0,
     100,   101,   102,   315,     0,   104,     0,     0,   316,   317,
     105,     0,   106,   107,   108,   109,     0,   110,     0,   111,
       0,     0,   112,   318,   319,   113,     0,   320,   114,     0,
     115,   321,     0,   322,   118,     0,   119,   120,   121,   122,
     123,   124,     0,   125,   126,     0,   127,     0,   323,   324,
       0,     0,   128,   325,   326,     0,   327,   129,   130,   131,
     132,   328,   329,   330,     0,     0,     0,     0,   331,   135,
     332,     0,     0,   333,     0,     0,     0,     0,   136,   137,
       0,     0,     0,     0,   138,   139,   140,     0,     0,     0,
     141,     0,   142,   143,     0,   144,   145,     0,     0,   146,
       0,   147,   148,   334,   149,   335,   336,     0,   150,   151,
     152,   153,   337,   154,     0,     0,     0,   155,   156,     0,
     157,     0,   158,     0,   338,     0,   159,     0,   339,     0,
       0,     0,   340,   161,   162,   163,   341,     0,   164,   165,
       0,     0,     0,     0,     0,   342,  1074,     0,     0,     0,
       0,   166,     0,     0,     0,   167,     0,     0,   168,     0,
       0,   344,   169,     0,     0,     0,     0,   170,     0,   171,
       0,   172,     0,   173,   345,     0,     0,     0,     0,   174,
     175,   346,   176,   177,   178,   347,     0,     0,   348,   181,
     349,   182,     0,   183,   350,   351,   185,   186,   187,     0,
       0,     0,   188,   189,   190,   352,   353,   191,   354,   355,
       0,   192,   193,     0,   194,   195,   196,   197,     0,     0,
       0,     0,     0,     0,     0,     0,   198,   199,   200,   356,
       0,   201,     0,   202,   203,   357,   205,     0,     0,   206,
       0,     0,     0,   207,     0,     0,     0,   208,   358,   359,
       0,   209,     0,   360,     0,   361,   211,   212,   213,   214,
     215,   362,   217,     0,   363,   219,     0,     0,     0,   220,
     221,   222,   223,     0,     0,     0,   224,     0,   225,   226,
     227,     0,     0,     0,     0,     0,   228,     0,     0,     0,
       0,   229,   230,   364,   365,   231,   232,     0,     0,   233,
     366,   235,   367,   368,   236,   237,   238,   369,   239,   240,
       0,     0,   241,     0,   370,   242,     0,   371,   372,   373,
       0,     0,   246,   374,   375,   376,   248,   249,   377,   250,
     251,     0,     0,     0,   252,     0,     0,     0,   378,     0,
       0,   379,   380,   381,   254,     0,     0,   255,   382,     0,
     383,   256,   257,     0,     0,     0,     0,   258,     0,     0,
       0,   384,   385,   386,     0,     0,    95,   387,   314,    97,
      98,   388,     0,   389,   390,    99,     0,     0,     0,   100,
     101,   102,   315,     0,   104,     0,     0,   316,   317,   105,
       0,   106,   107,   108,   109,     0,   110,     0,   111,     0,
       0,   112,   318,   319,   113,     0,   320,   114,     0,   115,
     321,     0,   322,   118,     0,   119,   120,   121,   122,   123,
     124,     0,   125,   126,     0,   127,     0,   323,   324,     0,
       0,   128,   325,   326,     0,   327,   129,   130,   131,   132,
     328,   329,   330,     0,     0,     0,     0,   331,   135,   332,
       0,     0,   333,     0,     0,     0,     0,   136,   137,     0,
       0,     0,     0,   138,   139,   140,     0,     0,     0,   141,
       0,   142,   143,     0,   144,   145,     0,     0,   146,     0,
     147,   148,   334,   149,   335,   336,     0,   150,   151,   152,
     153,   337,   154,     0,     0,     0,   155,   156,     0,   157,
       0,   158,     0,   338,     0,   159,     0,   339,     0,     0,
       0,   340,   161,   162,   163,   341,     0,   164,   165,     0,
       0,     0,     0,     0,   342,  1109,     0,     0,     0,     0,
     166,     0,     0,     0,   167,     0,     0,   168,     0,     0,
     344,   169,     0,     0,     0,     0,   170,     0,   171,     0,
     172,     0,   173,   345,     0,     0,     0,     0,   174,   175,
     346,   176,   177,   178,   347,     0,     0,   348,   181,   349,
     182,     0,   183,   350,   351,   185,   186,   187,     0,     0,
       0,   188,   189,   190,   352,   353,   191,   354,   355,     0,
     192,   193,     0,   194,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,     0,   198,   199,   200,   356,     0,
     201,     0,   202,   203,   357,   205,     0,     0,   206,     0,
       0,     0,   207,     0,     0,     0,   208,   358,   359,     0,
     209,     0,   360,     0,   361,   211,   212,   213,   214,   215,
     362,   217,     0,   363,   219,     0,     0,     0,   220,   221,
     222,   223,     0,     0,     0,   224,     0,   225,   226,   227,
       0,     0,     0,     0,     0,   228,     0,     0,     0,     0,
     229,   230,   364,   365,   231,   232,     0,     0,   233,   366,
     235,   367,   368,   236,   237,   238,   369,   239,   240,     0,
       0,   241,     0,   370,   242,     0,   371,   372,   373,     0,
       0,   246,   374,   375,   376,   248,   249,   377,   250,   251,
       0,     0,     0,   252,     0,     0,     0,   378,     0,     0,
     379,   380,   381,   254,     0,     0,   255,   382,     0,   383,
     256,   257,     0,     0,     0,     0,   258,     0,     0,     0,
     384,   385,   386,     0,     0,    95,   387,   314,    97,    98,
     388,     0,   389,   390,    99,     0,     0,     0,   100,   101,
     102,   315,     0,   104,     0,     0,   316,   317,   105,     0,
     106,   107,   108,   109,     0,   110,     0,   111,     0,     0,
     112,   318,   319,   113,     0,   320,   114,     0,   115,   321,
       0,   322,   118,     0,   119,   120,   121,   122,   123,   124,
       0,   125,   126,     0,   127,     0,   323,   324,     0,     0,
     128,   325,   326,     0,   327,   129,   130,   131,   132,   328,
     329,   330,     0,     0,     0,     0,   331,   135,   332,     0,
       0,  1333,     0,     0,     0,     0,   136,   137,     0,     0,
       0,     0,   138,   139,   140,     0,     0,     0,   141,     0,
     142,   143,     0,   144,   145,     0,     0,   146,     0,   147,
     148,   334,   149,   335,   336,     0,   150,   151,   152,   153,
     337,   154,     0,     0,     0,   155,   156,     0,   157,     0,
     158,     0,   338,     0,   159,     0,   339,     0,     0,     0,
     340,   161,   162,   163,   341,     0,   164,   165,     0,     0,
       0,     0,     0,   342,   343,     0,     0,     0,     0,   166,
       0,     0,     0,   167,     0,     0,   168,     0,     0,   344,
     169,     0,     0,     0,     0,   170,     0,   171,     0,   172,
       0,   173,   345,     0,     0,     0,     0,   174,   175,   346,
     176,   177,   178,   347,     0,     0,   348,   181,   349,   182,
       0,   183,   350,   351,   185,   186,   187,     0,     0,     0,
     188,   189,   190,   352,   353,   191,   354,   355,     0,   192,
     193,     0,   194,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,     0,   198,   199,   200,   356,     0,   201,
       0,   202,   203,   357,   205,     0,     0,   206,     0,     0,
       0,   207,     0,     0,     0,   208,   358,   359,     0,   209,
       0,   360,     0,   361,   211,   212,   213,   214,   215,   362,
     217,     0,   363,   219,     0,     0,     0,   220,   221,   222,
     223,     0,     0,     0,   224,     0,   225,   226,   227,     0,
       0,     0,     0,     0,   228,     0,     0,     0,     0,   229,
     230,   364,   365,   231,   232,     0,     0,   233,   366,   235,
     367,   368,   236,   237,   238,   369,   239,   240,     0,     0,
     241,     0,   370,   242,     0,   371,   372,   373,     0,     0,
     246,   374,   375,   376,   248,   249,   377,   250,   251,     0,
       0,     0,   252,     0,     0,     0,   378,     0,     0,   379,
     380,   381,   254,     0,     0,   255,   382,     0,   383,   256,
     257,     0,     0,     0,     0,   258,     0,     0,     0,   384,
     385,   386,     0,     0,    95,   387,   314,    97,    98,   388,
       0,   389,   390,    99,     0,     0,     0,   100,   101,   102,
     315,     0,   104,     0,     0,   316,   317,   105,     0,   106,
     107,   108,   109,     0,   110,     0,   111,     0,     0,   112,
     318,   319,   113,     0,   320,   114,     0,   115,   321,     0,
     322,   118,     0,   119,   120,   121,   122,   123,   124,     0,
     125,   126,     0,   127,     0,   323,   324,     0,     0,   128,
     325,   326,     0,   327,   129,   130,   131,   132,   328,   329,
     330,     0,     0,     0,     0,   331,   135,   332,     0,     0,
     333,     0,     0,     0,     0,   136,   137,     0,     0,     0,
       0,   138,   139,   140,     0,     0,     0,   141,     0,   142,
     143,     0,   144,   145,     0,     0,   146,     0,   147,   148,
     334,   149,   335,   336,     0,   150,   151,   152,   153,   337,
     154,     0,     0,     0,   155,   156,     0,   157,     0,   158,
       0,   338,     0,   159,     0,   339,     0,     0,     0,   340,
     161,   162,   163,   341,     0,   164,   165,     0,     0,     0,
       0,     0,   342,   343,     0,     0,     0,     0,   166,     0,
       0,     0,   167,     0,     0,   168,     0,     0,   344,   169,
       0,     0,     0,     0,   170,     0,   171,     0,   172,     0,
     173,   345,     0,     0,     0,     0,   174,   175,   346,   176,
     177,   178,   347,     0,     0,   348,   181,   349,   182,     0,
     183,   350,   351,   185,   186,   187,     0,     0,     0,   188,
     189,   190,     0,   353,   191,   354,   355,     0,   192,   193,
       0,   194,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,     0,   198,   199,   200,   356,     0,   201,     0,
     202,   203,   357,   205,     0,     0,   206,     0,     0,     0,
     207,     0,     0,     0,   208,   358,   359,     0,   209,     0,
     360,     0,   361,   211,   212,   213,   214,   215,   362,   217,
       0,   363,   219,     0,     0,     0,   220,   221,   222,   223,
       0,     0,     0,   224,     0,   225,   226,   227,     0,     0,
       0,     0,     0,   228,     0,     0,     0,     0,   229,   230,
     364,   365,   231,   232,     0,     0,   233,   366,   235,   367,
     368,   236,   237,   238,   369,   239,   240,     0,     0,   241,
       0,   370,   242,     0,   371,   372,   373,     0,     0,   246,
     374,   375,   376,   248,   249,   377,   250,   251,     0,     0,
       0,   252,     0,     0,     0,   378,     0,     0,   379,   380,
     381,   254,     0,     0,   255,   382,     0,   383,   256,   257,
       0,     0,     0,     0,   258,     0,     0,     0,   384,   385,
     386,     0,     0,    95,   387,   314,    97,    98,   388,     0,
     389,   390,    99,     0,     0,     0,   100,   101,   102,   315,
       0,   104,     0,     0,   316,   317,   105,     0,   106,   107,
     108,   109,     0,   110,     0,   111,     0,     0,   112,   318,
     319,   113,     0,   320,   114,     0,   115,   321,     0,   322,
     118,     0,   119,   120,   121,   122,   123,   124,     0,   125,
     126,     0,   127,     0,   323,   324,     0,     0,   128,   325,
     326,     0,   327,   129,   130,   131,   132,   328,   329,   330,
       0,     0,     0,     0,   331,   135,   332,     0,     0,   333,
       0,     0,     0,     0,   136,   137,     0,     0,     0,     0,
     138,   139,   140,     0,     0,     0,   141,     0,   142,   143,
       0,   144,   145,     0,     0,   146,     0,   147,   148,   334,
     149,   335,   336,     0,   150,   151,   152,   153,   337,   154,
       0,     0,     0,   155,   156,     0,   157,     0,   158,     0,
     338,     0,   159,     0,   339,     0,     0,     0,   340,   161,
     162,   163,   341,     0,   164,   165,     0,     0,     0,     0,
       0,   342,   797,     0,     0,     0,     0,   166,     0,     0,
       0,   167,     0,     0,   168,     0,     0,   344,   169,     0,
       0,     0,     0,   170,     0,   171,     0,   172,     0,   173,
     345,     0,     0,     0,     0,   174,   175,   346,   176,   177,
     178,   347,     0,     0,   348,   181,   349,   182,     0,   183,
     350,   351,   185,   186,   187,     0,     0,     0,   188,   189,
     190,     0,   353,   191,   354,   355,     0,   192,   193,     0,
     194,   195,   196,   197,     0,     0,     0,     0,     0,     0,
       0,     0,   198,   199,   200,   356,     0,   201,     0,   202,
     203,   357,   205,     0,     0,   206,     0,     0,     0,   207,
       0,     0,     0,   208,   358,   359,     0,   209,     0,   360,
       0,   361,   211,   212,   213,   214,   215,   362,   217,     0,
     363,   219,     0,     0,     0,   220,   221,   222,   223,     0,
       0,     0,   224,     0,   225,   226,   227,     0,     0,     0,
       0,     0,   228,     0,     0,     0,     0,   229,   230,   364,
     365,   231,   232,     0,     0,   233,   366,   235,   367,   368,
     236,   237,   238,   369,   239,   240,     0,     0,   241,     0,
     370,   242,     0,   371,   372,   373,     0,     0,   246,   374,
     375,   376,   248,   249,   377,   250,   251,     0,     0,     0,
     252,     0,     0,     0,   378,     0,     0,   379,   380,   381,
     254,     0,     0,   255,   382,     0,   383,   256,   257,     0,
       0,     0,     0,   258,     0,     0,     0,   384,   385,   386,
       0,     0,    95,   387,   314,    97,    98,   388,     0,   389,
     390,    99,     0,     0,     0,   100,   101,   102,   315,     0,
     104,     0,     0,   316,   317,   105,     0,   106,   107,   108,
     109,     0,   110,     0,   111,     0,     0,   112,   318,   319,
     113,     0,   320,   114,     0,   115,   321,     0,   322,   118,
       0,   119,   120,   121,   122,   123,   124,     0,   125,   126,
       0,   127,     0,   323,   324,     0,     0,   128,   325,   326,
       0,   327,   129,   130,   131,   132,   328,   329,   330,     0,
       0,     0,     0,   331,   135,   332,     0,     0,   333,     0,
       0,     0,     0,   136,   137,     0,     0,     0,     0,   138,
     139,   140,     0,     0,     0,   141,     0,   142,   143,     0,
     144,   145,     0,     0,   146,     0,   147,   148,   334,   149,
     335,   336,     0,   150,   151,   152,   153,   337,   154,     0,
       0,     0,   155,   156,     0,   157,     0,   158,     0,   338,
       0,   159,     0,   339,     0,     0,     0,   340,   161,   162,
     163,   341,     0,   164,   165,     0,     0,     0,     0,     0,
     342,   799,     0,     0,     0,     0,   166,     0,     0,     0,
     167,     0,     0,   168,     0,     0,   344,   169,     0,     0,
       0,     0,   170,     0,   171,     0,   172,     0,   173,   345,
       0,     0,     0,     0,   174,   175,   346,   176,   177,   178,
     347,     0,     0,   348,   181,   349,   182,     0,   183,   350,
     351,   185,   186,   187,     0,     0,     0,   188,   189,   190,
       0,   353,   191,   354,   355,     0,   192,   193,     0,   194,
     195,   196,   197,     0,     0,     0,     0,     0,     0,     0,
       0,   198,   199,   200,   356,     0,   201,     0,   202,   203,
     357,   205,     0,     0,   206,     0,     0,     0,   207,     0,
       0,     0,   208,   358,   359,     0,   209,     0,   360,     0,
     361,   211,   212,   213,   214,   215,   362,   217,     0,   363,
     219,     0,     0,     0,   220,   221,   222,   223,     0,     0,
       0,   224,     0,   225,   226,   227,     0,     0,     0,     0,
       0,   228,     0,     0,     0,     0,   229,   230,   364,   365,
     231,   232,     0,     0,   233,   366,   235,   367,   368,   236,
     237,   238,   369,   239,   240,     0,     0,   241,     0,   370,
     242,     0,   371,   372,   373,     0,     0,   246,   374,   375,
     376,   248,   249,   377,   250,   251,     0,     0,     0,   252,
       0,     0,     0,   378,     0,     0,   379,   380,   381,   254,
       0,     0,   255,   382,     0,   383,   256,   257,     0,     0,
       0,     0,   258,     0,     0,     0,   384,   385,   386,     0,
       0,    95,   387,    96,    97,    98,   388,     0,   389,   390,
      99,     0,     0,     0,   100,   101,   102,   103,     0,   104,
       0,     0,     0,     0,   105,     0,   106,   107,   108,   109,
       0,   110,     0,   111,     0,     0,   112,     0,     0,   113,
       0,     0,   114,     0,   115,   116,     0,   117,   118,     0,
     119,   120,   121,   122,   123,   124,     0,   125,   126,     0,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,   129,   130,   131,   132,     0,     0,   133,     0,     0,
       0,     0,   134,   135,     0,     0,     0,     0,     0,     0,
       0,     0,   136,   137,     0,     0,     0,     0,   138,   139,
     140,     0,     0,     0,   141,     0,   142,   143,     0,   144,
     145,     0,     0,   146,     0,   147,   148,     0,   149,     0,
       0,     0,   150,   151,   152,   153,     0,   154,     0,     0,
       0,   155,   156,     0,   157,     0,   158,     0,     0,     0,
     159,     0,     0,     0,     0,     0,   160,   161,   162,   163,
       0,     0,   164,   165,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   166,     0,     0,     0,   167,
       0,     0,   168,     0,     0,     0,   169,   772,     0,     0,
       0,   170,     0,   171,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,   175,     0,   176,   177,   178,   179,
       0,     0,   180,   181,     0,   182,     0,   183,     0,   184,
     185,   186,   187,     0,     0,     0,   188,   189,   190,     0,
       0,   191,     0,     0,     0,   192,   193,     0,   194,   195,
     196,   197,     0,     0,     0,     0,     0,     0,     0,     0,
     198,   199,   200,     0,     0,   201,     0,   202,   203,   204,
     205,     0,     0,   206,     0,     0,     0,   207,     0,     0,
       0,   208,     0,     0,     0,   209,     0,   210,     0,     0,
     211,   212,   213,   214,   215,   216,   217,     0,   218,   219,
       0,     0,     0,   220,   221,   222,   223,     0,     0,     0,
     224,     0,   225,   226,   227,     0,     0,     0,     0,     0,
     228,     0,     0,     0,     0,   229,   230,     0,     0,   231,
     232,     0,     0,   233,   234,   235,     0,     0,   236,   237,
     238,     0,   239,   240,     0,     0,   241,     0,   773,   242,
       0,   243,   244,   245,     0,     0,   246,     0,     0,   247,
     248,   249,     0,   250,   251,     0,     0,     0,   252,     0,
       0,     0,   253,     0,     0,     0,     0,     0,   254,     0,
       0,   255,     0,     0,     0,   256,   257,     0,     0,     0,
       0,   258,     0,     0,     0,   259,    95,     0,    96,    97,
      98,     0,     0,     0,     0,    99,     0,     0,   774,   100,
     101,   102,   103,     0,   104,     0,     0,     0,     0,   105,
       0,   106,   107,   108,   109,     0,   110,     0,   111,     0,
       0,   112,     0,     0,   113,     0,     0,   114,     0,   115,
     116,     0,   117,   118,     0,   119,   120,   121,   122,   123,
     124,     0,   125,   126,     0,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,   129,   130,   131,   132,
       0,     0,   133,     0,     0,     0,     0,   134,   135,     0,
       0,     0,     0,     0,     0,     0,     0,   136,   137,     0,
       0,     0,     0,   138,   139,   140,     0,     0,     0,   141,
       0,   142,   143,     0,   144,   145,     0,     0,   146,     0,
     147,   148,     0,   149,     0,     0,     0,   150,   151,   152,
     153,     0,   154,     0,     0,     0,   155,   156,     0,   157,
       0,   158,     0,     0,     0,   159,     0,     0,     0,     0,
       0,   160,   161,   162,   163,     0,     0,   164,   165,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     166,     0,     0,     0,   167,     0,     0,   168,     0,     0,
       0,   169,   772,     0,     0,     0,   170,     0,   171,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,   175,
       0,   176,   177,   178,   179,     0,     0,   180,   181,     0,
     182,     0,   183,     0,   184,   185,   186,   187,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
     192,   193,     0,   194,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,     0,   198,   199,   200,     0,     0,
     201,     0,   202,   203,   204,   205,     0,     0,   206,     0,
       0,     0,   207,     0,     0,     0,   208,     0,     0,     0,
     209,     0,   210,     0,     0,   211,   212,   213,   214,   215,
     216,   217,     0,   218,   219,     0,     0,     0,   220,   221,
     222,   223,     0,     0,     0,   224,     0,   225,   226,   227,
       0,     0,     0,     0,     0,   228,     0,     0,     0,     0,
     229,   230,     0,     0,   231,   232,     0,     0,   233,   234,
     235,     0,     0,   236,   237,   238,     0,   239,   240,     0,
       0,   241,     0,   773,   242,     0,   243,   244,   245,     0,
       0,   246,     0,     0,   247,   248,   249,     0,   250,   251,
       0,     0,     0,   252,     0,     0,     0,   253,     0,     0,
       0,     0,     0,   254,     0,     0,   255,     0,     0,     0,
     256,   257,     0,     0,     0,     0,   258,     0,     0,     0,
     259,    95,     0,    96,    97,    98,     0,     0,     0,     0,
      99,     0,     0,  1192,   100,   101,   102,   103,     0,   104,
       0,     0,     0,     0,   105,     0,   106,   107,   108,   109,
       0,   110,     0,   111,     0,     0,   112,     0,     0,   113,
       0,     0,   114,     0,   115,   116,     0,   117,   118,     0,
     119,   120,   121,   122,   123,   124,     0,   125,   126,     0,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,   129,   130,   131,   132,     0,     0,   133,     0,     0,
       0,     0,   134,   135,     0,     0,     0,     0,     0,     0,
       0,     0,   136,   137,     0,     0,     0,     0,   138,   139,
     140,     0,     0,     0,   141,     0,   142,   143,     0,   144,
     145,     0,     0,   146,     0,   147,   148,     0,   149,     0,
       0,     0,   150,   151,   152,   153,     0,   154,     0,     0,
       0,   155,   156,     0,   157,     0,   158,     0,     0,     0,
     159,     0,     0,     0,     0,     0,   160,   161,   162,   163,
       0,     0,   164,   165,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   166,     0,     0,     0,   167,
       0,     0,   168,     0,     0,     0,   169,     0,     0,     0,
       0,   170,     0,   171,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,   175,     0,   176,   177,   178,   179,
       0,     0,   180,   181,     0,   182,     0,   183,     0,   184,
     185,   186,   187,     0,     0,     0,   188,   189,   190,     0,
       0,   191,     0,     0,     0,   192,   193,     0,   194,   195,
     196,   197,     0,     0,     0,     0,     0,     0,     0,     0,
     198,   199,   200,     0,     0,   201,     0,   202,   203,   204,
     205,     0,     0,   206,     0,     0,     0,   207,     0,     0,
       0,   208,     0,     0,     0,   209,     0,   210,     0,     0,
     211,   212,   213,   214,   215,   216,   217,     0,   218,   219,
       0,     0,     0,   220,   221,   222,   223,     0,     0,     0,
     224,     0,   225,   226,   227,     0,     0,     0,     0,     0,
     228,     0,     0,     0,     0,   229,   230,     0,     0,   231,
     232,     0,     0,   233,   234,   235,     0,     0,   236,   237,
     238,     0,   239,   240,     0,     0,   241,     0,     0,   242,
       0,   243,   244,   245,     0,     0,   246,     0,     0,   247,
     248,   249,     0,   250,   251,     0,     0,     0,   252,     0,
       0,     0,   253,     0,     0,     0,     0,     0,   254,     0,
       0,   255,     0,     0,     0,   256,   257,     0,     0,     0,
       0,   258,     0,     0,     0,   259,    95,     0,    96,    97,
      98,     0,  1935,     0,     0,    99,     0,   389,  1936,   100,
     101,   102,   103,     0,   104,     0,     0,     0,     0,   105,
       0,   106,   107,   108,   109,     0,   110,     0,   111,     0,
       0,   112,     0,     0,   113,     0,     0,   114,     0,   115,
     116,     0,   117,   118,     0,   119,   120,   121,   122,   123,
     124,     0,   125,   126,     0,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,   129,   130,   131,   132,
       0,     0,   133,     0,     0,     0,     0,   134,   135,     0,
       0,     0,     0,     0,     0,     0,     0,   136,   137,     0,
       0,     0,     0,   138,   139,   140,     0,     0,     0,   141,
       0,   142,   143,     0,   144,   145,     0,     0,   146,     0,
     147,   148,     0,   149,     0,     0,     0,   150,   151,   152,
     153,     0,   154,     0,     0,     0,   155,   156,     0,   157,
       0,   158,     0,     0,     0,   159,     0,     0,     0,     0,
       0,   160,   161,   162,   163,     0,     0,   164,   165,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     166,     0,     0,     0,   167,     0,     0,   168,     0,     0,
       0,   169,     0,     0,     0,     0,   170,     0,   171,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,   175,
       0,   176,   177,   178,   179,     0,     0,   180,   181,     0,
     182,     0,   183,     0,   184,   185,   186,   187,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
     192,   193,     0,   194,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,     0,   198,   199,   200,     0,     0,
     201,     0,   202,   203,   204,   205,     0,     0,   206,     0,
       0,     0,   207,     0,     0,     0,   208,     0,     0,     0,
     209,     0,   210,     0,     0,   211,   212,   213,   214,   215,
     216,   217,     0,   218,   219,     0,     0,     0,   220,   221,
     222,   223,     0,     0,     0,   224,     0,   225,   226,   227,
       0,     0,     0,     0,     0,   228,     0,     0,     0,     0,
     229,   230,     0,     0,   231,   232,     0,     0,   233,   234,
     235,     0,     0,   236,   237,   238,     0,   239,   240,     0,
       0,   241,     0,     0,   242,     0,   243,   244,   245,     0,
       0,   246,     0,     0,   247,   248,   249,     0,   250,   251,
       0,     0,     0,   252,     0,     0,     0,   253,     0,     0,
       0,     0,     0,   254,     0,     0,   255,     0,     0,     0,
     256,   257,     0,     0,     0,     0,   258,     0,     0,     0,
     259,    95,     0,    96,    97,    98,     0,     0,     0,     0,
      99,     0,   389,  1936,   100,   101,   102,   103,     0,   104,
       0,     0,     0,     0,   105,     0,   106,   107,   108,   109,
       0,   110,     0,   111,     0,     0,   112,     0,     0,   113,
       0,     0,   114,     0,   115,   116,     0,   117,   118,     0,
     119,   120,   121,   122,   123,   124,     0,   125,   126,  1209,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,   129,   130,   131,   132,     0,     0,   133,     0,     0,
       0,     0,   134,   135,     0,     0,     0,     0,     0,     0,
       0,     0,   136,   137,     0,     0,     0,     0,   138,   139,
     140,     0,     0,     0,   141,     0,   142,   143,     0,   144,
     145,     0,     0,   146,     0,   147,   148,     0,   149,     0,
       0,     0,   150,   151,   152,   153,     0,   154,     0,     0,
       0,   155,   156,     0,   157,     0,   158,     0,     0,     0,
     159,     0,     0,     0,     0,     0,   160,   161,   162,   163,
       0,     0,   164,   165,  1210,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   166,     0,     0,     0,   167,
    1211,     0,   168,     0,     0,     0,   169,     0,  1251,     0,
       0,   170,     0,   171,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,   175,     0,   176,   177,   178,   179,
       0,     0,   180,   181,     0,   182,     0,   183,     0,   184,
     185,   186,   187,     0,     0,     0,   188,   189,   190,     0,
       0,   191,     0,     0,     0,   192,   193,     0,   194,   195,
     196,   197,     0,     0,     0,     0,     0,     0,     0,     0,
     198,   199,   200,     0,     0,   201,     0,   202,   203,   204,
     205,     0,     0,   206,     0,     0,     0,   207,     0,     0,
       0,   208,     0,     0,     0,   209,     0,   210,     0,     0,
     211,   212,   213,   214,   215,   216,   217,     0,   218,   219,
     813,     0,     0,   220,   221,   222,   223,     0,     0,     0,
     224,     0,   225,   226,   227,     0,     0,     0,     0,     0,
     228,     0,     0,     0,     0,   229,   230,     0,     0,   231,
     232,     0,     0,   233,   234,   235,     0,     0,   236,   237,
     238,     0,   239,   240,     0,     0,   241,     0,     0,   242,
       0,   243,   244,   245,     0,     0,   246,     0,     0,   247,
     248,   249,     0,   250,   251,     0,     0,     0,   252,     0,
       0,     0,   253,     0,     0,     0,     0,     0,   254,     0,
       0,   255,     0,     0,     0,   256,   257,     0,     0,     0,
      95,   258,    96,    97,    98,   259,     0,     0,     0,    99,
       0,     0,     0,   100,   101,   102,   103,  1245,   104,     0,
       0,     0,     0,   105,     0,   106,   107,   108,   109,     0,
     110,     0,   111,     0,     0,   112,     0,     0,   113,     0,
       0,   114,     0,   115,   116,     0,   117,   118,     0,   119,
     120,   121,   122,   123,   124,     0,   125,   126,  1209,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
     129,   130,   131,   132,     0,     0,   133,     0,     0,     0,
       0,   134,   135,     0,     0,     0,     0,     0,     0,     0,
       0,   136,   137,     0,     0,     0,     0,   138,   139,   140,
       0,     0,     0,   141,     0,   142,   143,     0,   144,   145,
       0,     0,   146,     0,   147,   148,     0,   149,     0,     0,
       0,   150,   151,   152,   153,     0,   154,     0,     0,     0,
     155,   156,     0,   157,     0,   158,     0,     0,     0,   159,
       0,     0,     0,     0,     0,   160,   161,   162,   163,     0,
       0,   164,   165,  1210,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   166,     0,     0,     0,   167,  1211,
       0,   168,     0,     0,     0,   169,     0,     0,     0,     0,
     170,     0,   171,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,   175,     0,   176,   177,   178,   179,     0,
       0,   180,   181,     0,   182,     0,   183,     0,   184,   185,
     186,   187,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,   192,   193,     0,   194,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,     0,   198,
     199,   200,     0,     0,   201,     0,   202,   203,   204,   205,
       0,     0,   206,     0,     0,     0,   207,     0,     0,     0,
     208,     0,     0,     0,   209,     0,   210,     0,     0,   211,
     212,   213,   214,   215,   216,   217,     0,   218,   219,     0,
       0,     0,   220,   221,   222,   223,     0,     0,     0,   224,
       0,   225,   226,   227,     0,     0,     0,     0,     0,   228,
       0,     0,     0,     0,   229,   230,     0,     0,   231,   232,
       0,     0,   233,   234,   235,     0,     0,   236,   237,   238,
       0,   239,   240,     0,     0,   241,     0,     0,   242,     0,
     243,   244,   245,     0,     0,   246,     0,     0,   247,   248,
     249,     0,   250,   251,     0,     0,     0,   252,     0,     0,
       0,   253,     0,     0,     0,     0,     0,   254,     0,     0,
     255,     0,     0,     0,   256,   257,     0,     0,     0,    95,
     258,    96,    97,    98,   259,     0,     0,     0,    99,     0,
       0,     0,   100,   101,   102,   103,  1245,   104,     0,     0,
       0,     0,   105,     0,   106,   107,   108,   109,     0,   110,
       0,   111,     0,     0,   112,     0,     0,   113,     0,     0,
     114,     0,   115,   116,     0,   117,   118,     0,   119,   120,
     121,   122,   123,   124,     0,   125,   126,     0,   127,     0,
       0,     0,     0,     0,   128,     0,     0,     0,     0,   129,
     130,   131,   132,     0,     0,   133,     0,     0,     0,     0,
     134,   135,     0,     0,     0,     0,     0,     0,     0,     0,
     136,   137,     0,     0,     0,     0,   138,   139,   140,     0,
       0,     0,   141,     0,   142,   143,     0,   144,   145,     0,
       0,   146,     0,   147,   148,     0,   149,     0,     0,     0,
     150,   151,   152,   153,     0,   154,     0,     0,     0,   155,
     156,     0,   157,     0,   158,     0,     0,     0,   159,     0,
       0,     0,     0,     0,   160,   161,   162,   163,     0,     0,
     164,   165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   166,     0,     0,     0,   167,     0,     0,
     168,     0,     0,     0,   169,     0,     0,     0,     0,   170,
       0,   171,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,   175,     0,   176,   177,   178,   179,     0,     0,
     180,   181,     0,   182,     0,   183,     0,   184,   185,   186,
     187,     0,     0,     0,   188,   189,   190,     0,     0,   191,
       0,     0,     0,   192,   193,     0,   194,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,     0,   198,   199,
     200,     0,     0,   201,     0,   202,   203,   204,   205,     0,
       0,   206,     0,     0,     0,   207,     0,     0,     0,   208,
       0,     0,     0,   209,     0,   210,     0,     0,   211,   212,
     213,   214,   215,   216,   217,     0,   218,   219,   813,     0,
       0,   220,   221,   222,   223,     0,     0,     0,   224,     0,
     225,   226,   227,     0,     0,     0,     0,     0,   228,     0,
       0,     0,     0,   229,   230,     0,     0,   231,   232,     0,
       0,   233,   234,   235,     0,     0,   236,   237,   238,     0,
     239,   240,     0,     0,   241,     0,     0,   242,     0,   243,
     244,   245,     0,     0,   246,     0,     0,   247,   248,   249,
       0,   250,   251,     0,     0,     0,   252,     0,     0,     0,
     253,     0,     0,     0,     0,     0,   254,     0,     0,   255,
       0,     0,     0,   256,   257,     0,     0,     0,    95,   258,
      96,    97,    98,   259,     0,     0,     0,    99,     0,     0,
     991,   100,   101,   102,   103,   389,   104,     0,     0,     0,
       0,   105,     0,   106,   107,   108,   109,     0,   110,     0,
     111,     0,     0,   112,     0,     0,   113,     0,     0,   114,
       0,   115,   116,     0,   117,   118,     0,   119,   120,   121,
     122,   123,   124,     0,   125,   126,     0,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,   129,   130,
     131,   132,     0,     0,   133,     0,     0,     0,     0,   134,
     135,     0,     0,     0,     0,     0,     0,     0,     0,   136,
     137,     0,     0,     0,     0,   138,   139,   140,     0,     0,
       0,   141,     0,   142,   143,     0,   144,   145,     0,     0,
     146,     0,   147,   148,     0,   149,     0,     0,     0,   150,
     151,   152,   153,     0,   154,     0,     0,     0,   155,   156,
       0,   157,     0,   158,     0,     0,     0,   159,     0,     0,
       0,     0,     0,   160,   161,   162,   163,     0,     0,   164,
     165,     0,     0,     0,     0,     0,     0,     0,   413,     0,
       0,     0,   166,     0,     0,     0,   167,     0,     0,   168,
       0,     0,     0,   169,     0,     0,     0,     0,   170,     0,
     171,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,   175,     0,   176,   177,   178,   179,     0,     0,   180,
     181,     0,   182,     0,   183,     0,   184,   185,   186,   187,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,   192,   193,     0,   194,   195,   196,   197,     0,
       0,     0,     0,     0,     0,     0,     0,   198,   199,   200,
       0,     0,   201,     0,   202,   203,   204,   205,     0,     0,
     206,     0,     0,     0,   207,     0,     0,     0,   208,     0,
       0,     0,   209,     0,   210,     0,     0,   211,   212,   213,
     214,   215,   216,   217,     0,   218,   219,     0,     0,     0,
     220,   221,   222,   223,     0,     0,     0,   224,     0,   225,
     226,   227,     0,     0,     0,     0,     0,   228,     0,     0,
       0,     0,   229,   230,     0,     0,   231,   232,     0,     0,
     233,   234,   235,     0,     0,   236,   237,   238,     0,   239,
     240,     0,     0,   241,     0,     0,   242,     0,   243,   244,
     245,     0,     0,   246,     0,     0,   247,   248,   249,     0,
     250,   251,     0,     0,     0,   252,     0,     0,     0,   253,
       0,     0,     0,     0,     0,   254,     0,     0,   255,     0,
       0,     0,   256,   257,     0,     0,     0,    95,   258,    96,
      97,    98,   259,     0,     0,     0,    99,     0,     0,     0,
     100,   101,   102,   103,   283,   104,     0,     0,     0,     0,
     105,     0,   106,   107,   108,   109,     0,   110,     0,   111,
       0,     0,   112,     0,     0,   113,     0,     0,   114,     0,
     115,   116,     0,   117,   118,     0,   119,   120,   121,   122,
     123,   124,     0,   125,   126,     0,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,   129,   130,   131,
     132,     0,     0,   133,     0,     0,     0,     0,   134,   135,
       0,     0,     0,     0,     0,     0,     0,     0,   136,   137,
       0,     0,     0,     0,   138,   139,   140,     0,     0,     0,
     141,     0,   142,   143,     0,   144,   145,     0,     0,   146,
       0,   147,   148,     0,   149,     0,     0,     0,   150,   151,
     152,   153,     0,   154,     0,     0,     0,   155,   156,     0,
     157,     0,   158,     0,     0,     0,   159,     0,     0,     0,
       0,     0,   160,   161,   162,   163,     0,     0,   164,   165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   166,     0,     0,     0,   167,     0,     0,   168,     0,
       0,     0,   169,     0,     0,     0,     0,   170,     0,   171,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
     175,     0,   176,   177,   178,   179,     0,     0,   180,   181,
       0,   182,     0,   183,     0,   184,   185,   186,   187,     0,
       0,     0,   188,   189,   190,     0,     0,   191,     0,     0,
       0,   192,   193,     0,   194,   195,   196,   197,     0,     0,
       0,     0,     0,     0,     0,     0,   198,   199,   200,     0,
       0,   201,     0,   202,   203,   204,   205,     0,     0,   206,
       0,     0,     0,   207,     0,     0,     0,   208,     0,     0,
       0,   209,     0,   210,     0,     0,   211,   212,   213,   214,
     215,   216,   217,     0,   218,   219,     0,     0,     0,   220,
     221,   222,   223,     0,     0,     0,   224,     0,   225,   226,
     227,     0,     0,     0,     0,     0,   228,     0,     0,     0,
       0,   229,   230,     0,     0,   231,   232,     0,     0,   233,
     234,   235,     0,     0,   236,   237,   238,     0,   239,   240,
       0,     0,   241,     0,     0,   242,     0,   243,   244,   245,
       0,     0,   246,     0,     0,   247,   248,   249,     0,   250,
     251,     0,     0,     0,   252,     0,     0,     0,   253,     0,
       0,     0,     0,     0,   254,     0,     0,   255,     0,     0,
       0,   256,   257,     0,     0,     0,    95,   258,    96,    97,
      98,   259,     0,     0,     0,    99,     0,  1244,     0,   100,
     101,   102,   103,  1245,   104,     0,     0,     0,     0,   105,
       0,   106,   107,   108,   109,     0,   110,     0,   111,     0,
       0,   112,     0,     0,   113,     0,     0,   114,     0,   115,
     116,     0,   117,   118,     0,   119,   120,   121,   122,   123,
     124,     0,   125,   126,     0,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,   129,   130,   131,   132,
       0,     0,   133,     0,     0,     0,     0,   134,   135,     0,
       0,     0,     0,     0,     0,     0,     0,   136,   137,     0,
       0,     0,     0,   138,   139,   140,     0,     0,     0,   141,
       0,   142,   143,     0,   144,   145,     0,     0,   146,     0,
     147,   148,     0,   282,     0,     0,     0,   150,   151,   152,
     153,     0,   154,     0,     0,     0,   155,   156,     0,   157,
       0,   158,     0,     0,     0,   159,     0,     0,     0,     0,
       0,   160,   161,   162,   163,     0,     0,   164,   165,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     166,     0,     0,     0,   167,     0,     0,   168,     0,     0,
       0,   169,     0,     0,     0,     0,   170,     0,   171,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,   175,
       0,   176,   177,   178,   179,     0,     0,   180,   181,     0,
     182,     0,   183,     0,   184,   185,   186,   187,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
     192,   193,     0,   194,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,     0,   198,   199,   200,     0,     0,
     201,     0,   202,   203,   204,   205,     0,     0,   206,     0,
       0,     0,   207,     0,     0,     0,   208,     0,     0,     0,
     209,     0,   210,     0,     0,   211,   212,   213,   214,   215,
     216,   217,     0,   218,   219,     0,     0,     0,   220,   221,
     222,   223,     0,     0,     0,   224,     0,   225,   226,   227,
       0,     0,     0,     0,     0,   228,     0,     0,     0,     0,
     229,   230,     0,     0,   231,   232,     0,     0,   233,   234,
     235,     0,     0,   236,   237,   238,     0,   239,   240,     0,
       0,   241,     0,     0,   242,     0,   243,   244,   245,     0,
       0,   246,     0,     0,   247,   248,   249,     0,   250,   251,
       0,     0,     0,   252,     0,     0,     0,   253,     0,     0,
       0,     0,     0,   254,     0,     0,   255,     0,     0,     0,
     256,   257,     0,     0,     0,    95,   258,    96,    97,    98,
     259,     0,     0,     0,    99,     0,     0,     0,   100,   101,
     102,   103,   283,   104,     0,     0,     0,     0,   105,     0,
     106,   107,   108,   109,     0,   110,     0,   111,     0,     0,
     112,     0,     0,   113,     0,     0,   114,     0,   115,   116,
       0,   117,   118,     0,   119,   120,   121,   122,   123,   124,
       0,   125,   126,     0,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,   129,   130,   131,   132,     0,
       0,   133,     0,     0,     0,     0,   134,   135,     0,     0,
       0,     0,     0,     0,     0,     0,   136,   137,     0,     0,
       0,     0,   138,   139,   140,     0,     0,     0,   141,     0,
     142,   143,     0,   144,   145,     0,     0,   146,     0,   147,
     148,     0,   149,     0,     0,     0,   150,   151,   152,   153,
       0,   154,     0,     0,     0,   155,   156,     0,   157,     0,
     158,     0,     0,     0,   159,     0,     0,     0,     0,     0,
     160,   161,   162,   163,     0,     0,   164,   165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   166,
       0,     0,     0,   167,     0,     0,   168,     0,     0,     0,
     169,     0,     0,     0,     0,   170,     0,   171,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,   175,     0,
     176,   177,   178,   179,     0,     0,   180,   181,     0,   182,
       0,   183,     0,   184,   185,   186,   187,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,   192,
     193,     0,   194,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,     0,   198,   199,   200,     0,     0,   201,
       0,   202,   203,   204,   205,     0,     0,   206,     0,     0,
       0,   207,     0,     0,     0,   208,     0,     0,     0,   209,
       0,   210,     0,     0,   211,   212,   213,   214,   215,   216,
     217,     0,   218,   219,     0,     0,     0,   220,   221,   222,
     223,     0,     0,     0,   224,     0,   225,   226,   227,     0,
       0,     0,     0,     0,   228,     0,     0,     0,     0,   229,
     230,     0,     0,   231,   232,     0,     0,   233,   234,   235,
       0,     0,   236,   237,   238,     0,   239,   240,     0,     0,
     241,     0,     0,   242,     0,   243,   244,   245,     0,     0,
     246,     0,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,     0,     0,     0,   253,     0,     0,     0,
       0,     0,   254,     0,     0,   255,     0,     0,     0,   256,
     257,     0,     0,     0,    95,   258,    96,    97,    98,   259,
       0,     0,     0,    99,     0,     0,     0,   100,   101,   102,
     103,   283,   104,     0,     0,     0,     0,   105,     0,   106,
     107,   108,   109,     0,   110,     0,   111,     0,     0,   112,
       0,     0,   113,     0,     0,   114,     0,   115,   116,     0,
     117,   118,     0,   119,   120,   121,   122,   123,   124,     0,
     125,   126,     0,   127,     0,     0,     0,     0,     0,   128,
       0,     0,     0,     0,   129,   130,   131,   132,     0,     0,
     133,     0,     0,     0,     0,   134,   135,     0,     0,     0,
       0,     0,     0,     0,     0,   136,   137,     0,     0,     0,
       0,   138,   139,   140,     0,     0,     0,   141,     0,   142,
     143,     0,   144,   145,     0,     0,   146,     0,   147,   148,
       0,   149,     0,     0,     0,   150,   151,   152,   153,     0,
     154,     0,     0,     0,   155,   156,     0,   157,     0,   158,
       0,     0,     0,   159,     0,     0,     0,     0,     0,   160,
     161,   162,   163,     0,     0,   164,   165,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   166,     0,
       0,     0,   167,     0,     0,   168,     0,     0,     0,   169,
       0,     0,     0,     0,   170,     0,   171,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,   175,     0,   176,
     177,   178,   179,     0,     0,   180,   181,     0,   182,     0,
     183,     0,   184,   185,   186,   187,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,   192,   193,
       0,   194,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,     0,   198,   199,   200,     0,     0,   201,     0,
     202,   203,   204,   205,     0,     0,   206,     0,     0,     0,
     207,     0,     0,     0,   208,     0,     0,     0,   209,     0,
     210,     0,     0,   211,   212,   213,   214,   215,   216,   217,
       0,   218,   219,     0,     0,     0,   220,   221,   222,   223,
       0,     0,     0,   224,     0,   225,   226,   227,     0,     0,
       0,     0,     0,   228,     0,     0,     0,     0,   229,   230,
       0,     0,   231,   232,     0,     0,   233,   234,   235,     0,
       0,   236,   237,   238,     0,   239,   240,     0,     0,   241,
       0,     0,   242,     0,   243,   244,   245,     0,     0,   246,
       0,     0,   247,   248,   249,     0,   250,   251,     0,     0,
       0,   252,     0,     0,     0,   253,     0,     0,     0,     0,
       0,   254,     0,     0,   255,     0,     0,     0,   256,   257,
       0,     0,     0,    95,   258,    96,    97,    98,   259,     0,
       0,     0,    99,     0,     0,     0,   100,   101,   102,   103,
     389,   104,     0,     0,     0,     0,   105,     0,   106,   107,
     108,   109,     0,   110,     0,   111,     0,     0,   112,     0,
       0,   113,     0,     0,   114,     0,   115,   116,     0,   117,
     118,     0,   119,   120,   121,   122,   123,   124,     0,   125,
     126,     0,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,   129,   130,   131,   132,     0,     0,   133,
       0,     0,     0,     0,   134,   135,     0,     0,     0,     0,
       0,     0,     0,     0,   136,   137,     0,     0,     0,     0,
     138,   139,   140,     0,     0,     0,   141,     0,   142,   143,
       0,   144,   145,     0,     0,   146,     0,   147,   148,     0,
     149,     0,     0,     0,   150,   151,   152,   153,     0,   154,
       0,     0,     0,   155,   156,     0,   157,     0,   158,     0,
       0,     0,   159,     0,     0,     0,     0,     0,   160,   161,
     162,   163,     0,     0,   164,   165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   166,     0,     0,
       0,   167,     0,     0,   168,     0,     0,     0,   169,     0,
       0,     0,     0,   170,     0,   171,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,   175,     0,   176,   177,
     178,   179,     0,     0,   180,   181,     0,   182,     0,   183,
       0,   184,   185,   186,   187,     0,     0,     0,   188,   189,
     190,     0,     0,   191,     0,     0,     0,   192,   193,     0,
     194,   195,   196,   197,     0,     0,     0,     0,     0,     0,
       0,     0,   198,   199,   200,     0,     0,   201,     0,   202,
     203,   204,   205,     0,     0,   206,     0,     0,     0,   207,
       0,     0,     0,   208,     0,     0,     0,   209,     0,   210,
       0,     0,   211,   212,   213,   214,   215,   216,   217,     0,
     218,   219,     0,     0,     0,   220,   221,   222,   223,     0,
       0,     0,   224,     0,   225,   226,   227,     0,     0,     0,
       0,     0,   228,     0,     0,     0,     0,   229,   230,     0,
       0,   231,   232,     0,     0,   233,   234,   235,     0,     0,
     236,   237,   238,     0,   239,   240,     0,     0,   241,     0,
       0,   242,     0,   243,   244,   245,     0,     0,   246,     0,
       0,   247,   248,   249,     0,   250,   251,     0,     0,     0,
     252,     0,     0,     0,   253,     0,     0,     0,     0,     0,
     254,     0,     0,   255,     0,     0,     0,   256,   257,     0,
       0,     0,    95,   258,    96,    97,    98,   259,     0,     0,
       0,    99,     0,     0,     0,   100,   101,   102,   103,  1245,
     104,     0,     0,     0,     0,   105,     0,   106,   107,   108,
     109,     0,   110,     0,   111,     0,     0,   112,     0,     0,
     113,     0,     0,   114,     0,   115,   116,     0,   117,   118,
       0,   119,   120,   121,   122,   123,   124,     0,   125,   126,
       0,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,   129,   130,   131,   132,     0,     0,   133,     0,
       0,     0,     0,   134,   135,     0,     0,     0,     0,     0,
       0,     0,     0,   136,   137,     0,     0,     0,     0,   138,
     139,   140,     0,     0,     0,   141,     0,   142,   143,     0,
     144,   145,     0,     0,   146,     0,   147,   148,     0,   149,
       0,     0,     0,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,   156,     0,   157,     0,   158,     0,     0,
       0,   159,     0,     0,     0,     0,     0,   160,   161,   162,
     163,     0,     0,   164,   165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   166,     0,     0,     0,
     167,     0,     0,   168,     0,     0,     0,   169,     0,     0,
       0,     0,   170,     0,   171,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,   175,     0,   176,   177,   178,
     179,     0,     0,   180,   181,     0,   182,     0,   183,     0,
     184,   185,   186,   187,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,   192,   193,     0,   194,
     195,   196,   197,     0,     0,     0,     0,     0,     0,     0,
       0,   198,   199,   200,     0,     0,   201,     0,   202,   203,
     204,   205,     0,     0,   206,     0,     0,     0,   207,     0,
       0,     0,   208,     0,     0,     0,   209,     0,   210,     0,
       0,   211,   212,   213,   214,   215,   216,   217,     0,   218,
     219,     0,     0,     0,   220,   221,   222,   223,     0,     0,
       0,   224,     0,   225,   226,   227,     0,     0,     0,     0,
       0,   228,     0,     0,     0,     0,   229,   230,     0,     0,
     231,   232,     0,     0,   233,   234,   235,     0,     0,   236,
     237,   238,     0,   239,   240,     0,     0,   241,     0,     0,
     242,     0,   243,   244,   245,     0,     0,   246,     0,     0,
     247,   248,   249,     0,   250,   251,     0,     0,     0,   252,
       0,     0,     0,   253,     0,     0,     0,     0,     0,   254,
       0,     0,   255,     0,     0,     0,   256,   257,     0,     0,
       0,    95,   258,    96,    97,    98,   259,     0,     0,  1188,
      99,     0,     0,     0,   100,   101,   102,   103,     0,   104,
       0,     0,     0,     0,   105,     0,   106,   107,   108,   109,
       0,   110,     0,   111,     0,     0,   112,     0,     0,   113,
       0,     0,   114,     0,   115,   116,     0,   117,   118,     0,
     119,   120,   121,   122,   123,   124,     0,   125,   126,     0,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,   129,   130,   131,   132,     0,     0,   133,     0,     0,
       0,     0,   134,   135,     0,     0,     0,     0,     0,     0,
       0,     0,   136,   137,     0,     0,     0,     0,   138,   139,
     140,     0,     0,     0,   141,     0,   142,   143,     0,   144,
     145,     0,     0,   146,     0,   147,   148,     0,   149,     0,
       0,     0,   150,   151,   152,   153,     0,   154,     0,     0,
       0,   155,   156,     0,   157,     0,   158,     0,     0,     0,
     159,     0,     0,     0,     0,     0,   160,   161,   162,   163,
       0,     0,   164,   165,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   166,     0,     0,     0,   167,
       0,     0,   168,     0,     0,     0,   169,     0,     0,     0,
       0,   170,     0,   171,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,   175,     0,   176,   177,   178,   179,
       0,     0,   180,   181,     0,   182,     0,   183,     0,   184,
     185,   186,   187,     0,     0,     0,   188,   189,   190,     0,
       0,   191,     0,     0,     0,   192,   193,     0,   194,   195,
     196,   197,     0,     0,     0,     0,     0,     0,     0,     0,
     198,   199,   200,     0,     0,   201,     0,   202,   203,   204,
     205,     0,     0,   206,     0,     0,     0,   207,     0,     0,
       0,   208,     0,     0,     0,   209,     0,   210,     0,     0,
     211,   212,   213,   214,   215,   216,   217,     0,   218,   219,
       0,     0,     0,   220,   221,   222,   223,     0,     0,     0,
     224,     0,   225,   226,   227,     0,     0,     0,     0,     0,
     228,     0,     0,     0,     0,   229,   230,     0,     0,   231,
     232,     0,     0,   233,   234,   235,     0,     0,   236,   237,
     238,     0,   239,   240,     0,     0,   241,     0,     0,   242,
       0,   243,   244,   245,     0,     0,   246,     0,     0,   247,
     248,   249,     0,   250,   251,     0,     0,     0,   252,     0,
       0,     0,   253,     0,     0,     0,     0,     0,   254,     0,
       0,   255,     0,     0,     0,   256,   257,     0,     0,     0,
      95,   258,    96,    97,    98,   259,     0,     0,  1520,    99,
       0,     0,     0,   100,   101,   102,   103,     0,   104,     0,
       0,     0,   642,   105,     0,   106,   107,   108,   109,     0,
     110,     0,   111,     0,     0,   112,     0,     0,   113,     0,
       0,   114,     0,   115,   116,     0,   117,   118,     0,   119,
     120,   121,   122,   123,   124,     0,   125,   126,     0,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
     129,   130,   131,   132,     0,     0,   133,     0,     0,     0,
       0,   134,   135,     0,     0,     0,     0,     0,     0,     0,
       0,   136,   137,     0,     0,     0,     0,   138,   139,   140,
       0,     0,     0,   141,     0,   142,   143,     0,   144,   145,
       0,     0,   146,     0,   147,   148,     0,   149,     0,     0,
       0,   150,   151,   152,   153,     0,   154,     0,     0,     0,
     155,   156,     0,   157,     0,   158,     0,     0,     0,   159,
       0,   643,     0,     0,     0,   160,   161,   162,   163,     0,
       0,   164,   165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   166,     0,     0,     0,   167,     0,
       0,   168,     0,     0,     0,   169,     0,     0,     0,     0,
     170,     0,   171,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,   175,     0,   176,   177,   178,   179,     0,
       0,   180,   181,     0,   182,     0,   183,     0,   184,   185,
     186,   187,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,   192,   193,     0,   194,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,     0,   198,
     199,   200,     0,     0,   201,     0,   202,   203,   204,   205,
       0,     0,   206,     0,     0,     0,   207,     0,     0,     0,
     208,     0,     0,     0,   209,     0,   210,     0,     0,   211,
     212,   213,   214,   215,   216,   217,     0,   218,   219,     0,
       0,     0,   220,   221,   222,   223,     0,     0,     0,   224,
       0,   225,   226,   227,     0,     0,     0,     0,     0,   228,
       0,     0,     0,     0,   229,   230,     0,     0,   231,   232,
       0,     0,   233,   234,   235,     0,     0,   236,   237,   238,
       0,   239,   240,     0,     0,   241,     0,   370,   242,     0,
     243,   244,   245,     0,     0,   246,     0,     0,   247,   248,
     249,     0,   250,   251,     0,     0,     0,   252,     0,     0,
       0,   253,     0,     0,     0,     0,     0,   254,     0,     0,
     255,     0,     0,     0,   256,   257,     0,     0,     0,    95,
     258,    96,    97,    98,   259,     0,     0,     0,    99,     0,
       0,     0,   100,   101,   102,   103,     0,   104,     0,     0,
       0,     0,   105,     0,   106,   107,   108,   109,     0,   110,
       0,   111,     0,     0,   112,     0,     0,   113,     0,     0,
     114,     0,   115,   116,     0,   117,   118,     0,   119,   120,
     121,   122,   123,   124,     0,   125,   126,     0,   127,     0,
       0,     0,     0,     0,   128,     0,     0,     0,     0,   129,
     130,   131,   132,     0,     0,   133,     0,     0,     0,     0,
     134,   135,     0,     0,     0,  1204,     0,     0,     0,     0,
     136,   137,     0,     0,     0,     0,   138,   139,   140,     0,
       0,     0,   141,     0,   142,   143,     0,   144,   145,     0,
       0,   146,     0,   147,   148,     0,   149,     0,     0,     0,
     150,   151,   152,   153,     0,   154,     0,     0,     0,   155,
     156,     0,   157,     0,   158,     0,     0,     0,   159,     0,
       0,     0,     0,     0,   160,   161,   162,   163,     0,     0,
     164,   165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   166,     0,     0,     0,   167,     0,     0,
     168,     0,     0,     0,   169,   772,     0,     0,     0,   170,
       0,   171,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,   175,     0,   176,   177,   178,   179,     0,     0,
     180,   181,     0,   182,     0,   183,     0,   184,   185,   186,
     187,     0,     0,     0,   188,   189,   190,     0,     0,   191,
       0,     0,     0,   192,   193,     0,   194,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,     0,   198,   199,
     200,     0,     0,   201,     0,   202,   203,   204,   205,     0,
       0,   206,     0,     0,     0,   207,     0,     0,     0,   208,
       0,     0,     0,   209,     0,   210,     0,     0,   211,   212,
     213,   214,   215,   216,   217,     0,   218,   219,     0,     0,
       0,   220,   221,   222,   223,     0,     0,     0,   224,     0,
     225,   226,   227,     0,     0,     0,     0,     0,   228,     0,
       0,     0,     0,   229,   230,     0,     0,   231,   232,     0,
       0,   233,   234,   235,     0,     0,   236,   237,   238,     0,
     239,   240,     0,     0,   241,     0,   773,   242,     0,   243,
     244,   245,     0,     0,   246,     0,     0,   247,   248,   249,
       0,   250,   251,     0,     0,     0,   252,     0,     0,     0,
     253,     0,     0,     0,     0,     0,   254,     0,     0,   255,
       0,     0,     0,   256,   257,     0,     0,     0,    95,   258,
      96,    97,    98,   259,     0,     0,     0,    99,     0,     0,
       0,   100,   101,   102,   103,     0,   104,     0,     0,     0,
       0,   105,     0,   106,   107,   108,   109,     0,   110,     0,
     111,     0,     0,   112,     0,     0,   113,     0,     0,   114,
       0,   115,   116,     0,   117,   118,     0,   119,   120,   121,
     122,   123,   124,     0,   125,   126,     0,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,   129,   130,
     131,   132,     0,     0,   133,     0,     0,     0,     0,   134,
     135,     0,     0,     0,     0,     0,     0,     0,     0,   136,
     137,     0,     0,     0,     0,   138,   139,   140,     0,     0,
       0,   141,     0,   142,   143,     0,   144,   145,     0,     0,
     146,     0,   147,   148,     0,   149,     0,     0,     0,   150,
     151,   152,   153,     0,   154,     0,     0,     0,   155,   156,
       0,   157,     0,   158,     0,     0,     0,   159,     0,     0,
       0,     0,     0,   160,   161,   162,   163,     0,     0,   164,
     165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   166,     0,     0,     0,   167,     0,     0,   168,
       0,     0,     0,   169,   772,     0,     0,     0,   170,     0,
     171,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,   175,     0,   176,   177,   178,   179,     0,     0,   180,
     181,     0,   182,     0,   183,     0,   184,   185,   186,   187,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,   192,   193,     0,   194,   195,   196,   197,     0,
       0,     0,     0,     0,     0,     0,     0,   198,   199,   200,
       0,     0,   201,     0,   202,   203,   204,   205,     0,     0,
     206,     0,     0,     0,   207,     0,     0,     0,   208,     0,
       0,     0,   209,     0,   210,     0,     0,   211,   212,   213,
     214,   215,   216,   217,     0,   218,   219,     0,     0,     0,
     220,   221,   222,   223,     0,     0,     0,   224,     0,   225,
     226,   227,     0,     0,     0,     0,     0,   228,     0,     0,
       0,     0,   229,   230,     0,     0,   231,   232,     0,     0,
     233,   234,   235,     0,     0,   236,   237,   238,     0,   239,
     240,     0,     0,   241,     0,   773,   242,     0,   243,   244,
     245,     0,     0,   246,     0,     0,   247,   248,   249,     0,
     250,   251,     0,     0,     0,   252,     0,     0,     0,   253,
       0,     0,     0,     0,     0,   254,     0,     0,   255,     0,
       0,     0,   256,   257,     0,     0,     0,    95,   258,    96,
      97,    98,   259,     0,     0,     0,    99,  1184,     0,     0,
     100,   101,   102,   103,     0,   104,     0,     0,     0,     0,
     105,     0,   106,   107,   108,   109,     0,   110,     0,   111,
       0,     0,   112,     0,     0,   113,     0,     0,   114,     0,
     115,   116,     0,   117,   118,     0,   119,   120,   121,   122,
     123,   124,     0,   125,   126,     0,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,   129,   130,   131,
     132,     0,     0,   133,     0,     0,     0,     0,   134,   135,
       0,     0,     0,     0,     0,     0,     0,     0,   136,   137,
       0,     0,     0,     0,   138,   139,   140,     0,     0,     0,
     141,     0,   142,   143,     0,   144,   145,     0,     0,   146,
       0,   147,   148,     0,   149,     0,     0,     0,   150,   151,
     152,   153,     0,   154,     0,     0,     0,   155,   156,     0,
     157,     0,   158,     0,     0,     0,   159,     0,     0,     0,
       0,     0,   160,   161,   162,   163,     0,     0,   164,   165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   166,     0,     0,     0,   167,     0,     0,   168,     0,
       0,     0,   169,     0,     0,     0,     0,   170,     0,   171,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
     175,     0,   176,   177,   178,   179,     0,     0,   180,   181,
       0,   182,     0,   183,     0,   184,   185,   186,   187,     0,
       0,     0,   188,   189,   190,     0,     0,   191,     0,     0,
       0,   192,   193,     0,   194,   195,   196,   197,     0,     0,
       0,     0,     0,     0,     0,     0,   198,   199,   200,     0,
       0,   201,     0,   202,   203,   204,   205,     0,     0,   206,
       0,     0,     0,   207,     0,     0,     0,   208,     0,     0,
       0,   209,     0,   210,     0,     0,   211,   212,   213,   214,
     215,   216,   217,     0,   218,   219,     0,     0,     0,   220,
     221,   222,   223,     0,     0,     0,   224,     0,   225,   226,
     227,     0,     0,     0,     0,     0,   228,     0,     0,     0,
       0,   229,   230,     0,     0,   231,   232,     0,     0,   233,
     234,   235,     0,     0,   236,   237,   238,     0,   239,   240,
       0,     0,   241,     0,   773,   242,     0,   243,   244,   245,
       0,     0,   246,     0,     0,   247,   248,   249,     0,   250,
     251,     0,     0,     0,   252,     0,     0,     0,   253,     0,
       0,     0,     0,     0,   254,     0,     0,   255,     0,     0,
       0,   256,   257,     0,     0,     0,    95,   258,    96,    97,
      98,   259,     0,     0,     0,    99,     0,     0,     0,   100,
     101,   102,   103,     0,   104,     0,     0,     0,     0,   105,
       0,   106,   107,   108,   109,     0,   110,     0,   111,     0,
       0,   112,     0,     0,   113,     0,     0,   114,     0,   115,
     116,     0,   117,   118,     0,   119,   120,   121,   122,   123,
     124,     0,   125,   126,     0,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,   129,   130,   131,   132,
       0,     0,   133,     0,     0,     0,     0,   134,   135,     0,
       0,     0,     0,     0,     0,     0,     0,   136,   137,     0,
       0,     0,     0,   138,   139,   140,     0,     0,     0,   141,
       0,   142,   143,     0,   144,   145,     0,     0,   146,     0,
     147,   148,     0,   149,     0,     0,     0,   150,   151,   152,
     153,     0,   154,     0,     0,     0,   155,   156,     0,   157,
       0,   158,     0,     0,     0,   159,     0,     0,     0,     0,
       0,   160,   161,   162,   163,     0,     0,   164,   165,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     166,     0,     0,     0,   167,     0,     0,   168,     0,     0,
       0,   169,     0,     0,     0,     0,   170,     0,   171,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,   175,
       0,   176,   177,   178,   179,     0,     0,   180,   181,     0,
     182,     0,   183,     0,   184,   185,   186,   187,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
     192,   193,     0,   194,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,     0,   198,   199,   200,     0,     0,
     201,     0,   202,   203,   204,   205,     0,     0,   206,     0,
       0,     0,   207,     0,     0,     0,   208,     0,     0,     0,
     209,     0,   210,     0,     0,   211,   212,   213,   214,   215,
     216,   217,     0,   218,   219,     0,     0,     0,   220,   221,
     222,   223,     0,     0,     0,   224,     0,   225,   226,   227,
       0,     0,     0,     0,     0,   228,     0,     0,     0,     0,
     229,   230,     0,     0,   231,   232,     0,     0,   233,   234,
     235,     0,     0,   236,   237,   238,     0,   239,   240,     0,
       0,   241,     0,   773,   242,     0,   243,   244,   245,     0,
       0,   246,     0,     0,   247,   248,   249,     0,   250,   251,
       0,     0,     0,   252,     0,     0,     0,   253,     0,     0,
       0,     0,     0,   254,     0,     0,   255,     0,     0,     0,
     256,   257,     0,     0,     0,    95,   258,    96,    97,    98,
     259,     0,     0,     0,    99,     0,     0,     0,   100,   101,
     102,   103,     0,   104,     0,     0,     0,     0,   105,     0,
     106,   107,   108,   109,     0,   110,     0,   111,     0,     0,
     112,     0,     0,   113,     0,     0,   114,     0,   115,   116,
       0,   117,   118,     0,   119,   120,   121,   122,   123,   124,
       0,   125,   126,     0,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,   129,   130,   131,   132,     0,
       0,   133,     0,     0,     0,     0,   134,   135,     0,     0,
       0,     0,     0,     0,     0,     0,   136,   137,     0,     0,
       0,     0,   138,   139,   140,     0,     0,     0,   141,     0,
     142,   143,     0,   144,   145,     0,     0,   146,     0,   147,
     148,     0,   149,     0,     0,     0,   150,   151,   152,   153,
       0,   154,     0,     0,     0,   155,   156,     0,   157,     0,
     158,     0,     0,     0,   159,     0,     0,     0,     0,     0,
     160,   161,   162,   163,     0,     0,   164,   165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   166,
       0,     0,     0,   167,     0,     0,   168,     0,     0,     0,
     169,     0,     0,     0,     0,   170,     0,   171,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,   175,     0,
     176,   177,   178,   179,     0,     0,   180,   181,     0,   182,
       0,   183,     0,   184,   185,   186,   187,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,   192,
     193,     0,   194,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,     0,   198,   199,   200,     0,     0,   201,
    1924,   202,   203,   204,   205,     0,     0,   206,     0,     0,
       0,   207,     0,     0,     0,   208,     0,     0,     0,   209,
       0,   210,     0,     0,   211,   212,   213,   214,   215,   216,
     217,     0,   218,   219,     0,     0,     0,   220,   221,   222,
     223,     0,     0,     0,   224,     0,   225,   226,   227,     0,
       0,     0,     0,     0,   228,     0,     0,     0,     0,   229,
     230,     0,     0,   231,   232,     0,     0,   233,   234,   235,
       0,     0,   236,   237,   238,     0,   239,   240,     0,     0,
     241,     0,     0,   242,     0,   243,   244,   245,     0,     0,
     246,     0,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,     0,     0,     0,   253,     0,     0,     0,
       0,     0,   254,     0,     0,   255,     0,     0,     0,   256,
     257,     0,     0,     0,    95,   258,    96,    97,    98,   259,
       0,     0,     0,    99,     0,     0,     0,   100,   101,   102,
     103,     0,   104,     0,     0,     0,     0,   105,     0,   106,
     107,   108,   109,     0,   110,     0,   111,     0,     0,   112,
       0,     0,   113,     0,     0,   114,     0,   115,   116,     0,
     117,   118,     0,   119,   120,   121,   122,   123,   124,     0,
     125,   126,     0,   127,     0,     0,     0,     0,     0,   128,
       0,     0,     0,     0,   129,   130,   131,   132,     0,     0,
     133,     0,     0,     0,     0,   134,   135,     0,     0,     0,
       0,     0,     0,     0,     0,   136,   137,     0,     0,     0,
       0,   138,   139,   140,     0,     0,     0,   141,     0,   142,
     143,     0,   144,   145,     0,     0,   146,     0,   147,   148,
       0,   149,     0,     0,     0,   150,   151,   152,   153,     0,
     154,     0,     0,     0,   155,   156,     0,   157,     0,   158,
       0,     0,     0,   159,     0,     0,     0,     0,     0,   160,
     161,   162,   163,     0,     0,   164,   165,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   166,     0,
       0,     0,   167,     0,     0,   168,     0,     0,     0,   169,
       0,     0,     0,     0,   170,     0,   171,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,   175,     0,   176,
     177,   178,   179,     0,     0,   180,   181,     0,   182,     0,
     183,     0,   184,   185,   186,   187,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,   192,   193,
       0,   194,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,     0,   198,   199,   200,     0,     0,   201,     0,
     202,   203,   204,   205,     0,     0,   206,     0,     0,     0,
     207,     0,     0,     0,   208,     0,     0,     0,   209,     0,
     210,     0,     0,   211,   212,   213,   214,   215,   216,   217,
       0,   218,   219,     0,     0,     0,   220,   221,   222,   223,
       0,     0,     0,   224,     0,   225,   226,   227,     0,     0,
       0,     0,     0,   228,     0,     0,     0,     0,   229,   230,
       0,     0,   231,   232,     0,     0,   233,   234,   235,     0,
       0,   236,   237,   238,     0,   239,   240,     0,     0,   241,
       0,     0,   242,     0,   243,   244,   245,     0,     0,   246,
       0,     0,   247,   248,   249,     0,   250,   251,     0,     0,
       0,   252,     0,     0,     0,   253,     0,     0,     0,     0,
       0,   254,     0,     0,   255,     0,     0,     0,   256,   257,
       0,     0,     0,    95,   258,    96,    97,    98,   259,     0,
       0,     0,    99,     0,     0,     0,   100,   101,   102,   103,
       0,   104,     0,     0,     0,     0,   105,     0,   106,   107,
     108,   109,     0,   110,     0,   111,     0,     0,   112,     0,
       0,   113,     0,     0,   114,     0,   115,   116,     0,   117,
     118,     0,   119,   120,   121,   122,   123,   124,     0,   125,
     126,     0,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,   129,   130,   131,   132,     0,     0,   133,
       0,     0,     0,     0,   134,   135,     0,     0,     0,     0,
       0,     0,     0,     0,   136,   137,     0,     0,     0,     0,
     138,   139,   140,     0,     0,     0,   141,     0,   142,   143,
       0,   144,   145,     0,     0,   146,     0,   147,   148,     0,
     149,     0,     0,     0,   150,   151,   152,   153,     0,   154,
       0,     0,     0,   155,   156,     0,   157,     0,   158,     0,
       0,     0,   159,     0,     0,     0,     0,     0,   160,   161,
     162,   163,     0,     0,   164,   165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   166,     0,     0,
       0,   167,     0,     0,   168,     0,     0,     0,   169,     0,
       0,     0,     0,   170,     0,   171,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,   175,     0,   176,   177,
     178,   179,     0,     0,   180,   181,     0,   182,     0,   183,
       0,   184,   185,   186,   187,     0,     0,     0,   188,   189,
     190,     0,     0,   191,     0,     0,     0,   192,   193,     0,
     194,   195,   196,   197,     0,     0,     0,     0,     0,     0,
       0,     0,   198,   199,   200,     0,     0,   201,     0,   202,
     203,   204,   205,     0,     0,   206,     0,     0,     0,   207,
       0,     0,     0,   208,     0,     0,     0,   209,     0,   210,
       0,     0,   211,   212,   213,   214,   215,   216,   217,     0,
     218,   219,     0,     0,     0,   220,   221,   222,   223,     0,
       0,     0,   224,     0,   225,   226,   227,     0,     0,     0,
       0,     0,   228,     0,     0,     0,     0,   229,   230,     0,
       0,   231,   232,     0,     0,   233,   234,   235,     0,     0,
     236,   237,   238,     0,   239,   240,     0,     0,   241,     0,
       0,   242,     0,   243,   244,   245,     0,     0,  1012,     0,
       0,   247,   248,   249,     0,   250,   251,     0,     0,     0,
     252,     0,     0,     0,   253,     0,     0,     0,     0,     0,
     254,     0,     0,   255,     0,     0,     0,   256,   257,     0,
       0,     0,     0,   258,     0,     0,     0,   259
};

static const yytype_int16 yycheck[] =
{
      21,   402,   326,  1070,   553,    51,   564,   330,    29,   420,
     553,  1042,   316,   817,  1005,   998,   621,   518,  1202,  1014,
     952,  1233,   496,   497,  1035,  1036,   948,  1038,    93,   353,
      51,  1026,   590,  1044,   571,  1125,  1047,  1339,   511,   640,
    1051,   578,    63,  1318,   863,   369,  1020,  1021,   371,  1418,
      12,   436,   446,   808,    12,   379,   380,    54,    18,   460,
     627,   446,  1152,   985,    12,   632,   633,    12,    12,    29,
      91,    12,    93,  1485,    12,    73,    46,   105,   298,    46,
    1464,   385,   386,    14,    53,    12,   828,   296,    12,    49,
      91,  1343,    46,    53,   116,  1223,    12,   131,    14,  1351,
     131,  1528,    12,    26,    12,    38,  1066,   508,    12,    12,
     292,   293,   826,   100,    87,     2,    46,     4,     5,  1023,
     154,   111,    52,   154,    12,    60,    12,   238,    42,   462,
      90,    18,    62,   111,  1250,    12,     7,   137,   181,   216,
     139,  1391,    12,    12,   545,   283,    12,   154,  1332,    12,
      12,    12,   112,   230,    12,    12,   129,    12,   170,   229,
    1155,    34,   132,    12,    90,   132,   178,  1215,   183,    12,
      12,    12,   145,   991,   182,    12,   154,    12,   136,   182,
     133,   349,    12,   114,    12,   394,    15,   186,    12,    12,
     309,   307,   101,  1620,    12,   136,    83,   108,  1193,    20,
      90,   114,   132,   172,   224,   366,   117,   272,   257,    12,
     432,   136,   172,   103,   330,   264,   380,   385,   191,    12,
      66,   385,   145,   384,   374,   447,  1175,   157,   380,   275,
     238,  1242,   231,   385,  1053,   238,   189,   286,   128,    85,
      76,   166,   262,   173,   244,   364,   384,   279,   313,    70,
     388,   272,    12,   226,   275,   640,   127,    12,  1062,   266,
     272,   276,   283,    92,    12,  1169,  1642,  1636,   817,   290,
     143,   292,   293,  1575,   817,   386,   297,   239,   582,   249,
     357,   239,   249,   304,   305,   852,     9,  1537,   266,   288,
     133,   224,   313,  1007,   239,    12,   296,  1201,   239,   225,
    1428,   239,  1262,   485,   291,  1489,   488,   261,   857,  1376,
     224,  1680,   239,    12,   857,   239,   386,   277,   253,   249,
      12,   794,   356,   239,   657,   356,   237,  1443,   371,   239,
     328,   239,   241,  1702,   267,   239,   239,    12,    12,    12,
    1388,   349,   370,  1161,  1728,  1772,   368,  1723,   413,   346,
      12,   239,   353,   239,  1158,  1386,   236,    12,   291,   349,
    1612,  1409,   239,    12,  1616,   574,   412,   388,   389,   239,
     239,  1783,   345,   239,    97,   344,   239,   239,   239,   292,
     350,   239,   239,   350,   239,   629,   273,    12,   357,   337,
     239,   412,   413,  1342,  1149,    12,   239,   239,   239,   619,
      12,   959,   239,  1008,   239,  1147,   337,    12,   331,   239,
    1350,   239,   154,   887,   376,   239,   239,   463,   376,   330,
     350,   239,   339,   897,  1243,  1492,   386,   389,   386,   966,
     476,   376,   376,   479,    12,   376,   239,   986,   376,   460,
     461,   386,   463,   986,   385,   919,   239,   385,   386,   376,
    1017,  1820,   376,  1837,  1838,   476,  1840,  1015,   479,   386,
     376,   385,   386,  1832,   485,   859,   376,   488,   376,  1853,
     971,   972,   376,   376,   859,   385,   386,   385,   386,   239,
    1454,   385,   386,   386,   239,  1533,  1761,     0,   376,   510,
     376,   239,   965,  1877,  1095,  1879,  1880,   385,   386,   376,
     386,   974,   806,  1349,    12,   325,   376,   376,   328,   386,
     376,  1813,    12,   376,   376,   376,   386,   386,   376,   376,
     386,   376,   239,   386,   386,   386,    12,   376,   386,   386,
    1525,   386,   553,   376,   376,   376,  1626,   386,   328,   376,
     239,   376,   385,   564,   386,   386,   376,   239,   376,   386,
     111,   386,   376,   376,    12,  1622,   386,   385,   376,  1499,
      12,   385,   385,   191,   239,   239,   239,   385,   283,   590,
      14,   617,   593,   376,   620,    49,  1794,   239,     9,  1184,
      12,   602,   385,   376,   239,   631,    73,   998,   653,    12,
     239,  1513,   385,   283,   331,   839,   617,    73,   226,   620,
      12,   153,    12,    12,    12,    12,  1143,   628,    12,   853,
     631,   154,    98,  1162,   239,   661,   376,  1222,  1609,  1162,
      12,   376,   239,   328,    68,   385,    12,   239,   376,  1847,
     385,   283,   653,    12,   239,  1641,    12,   385,   659,  1823,
     661,   333,  1446,    12,   118,  1857,    12,   384,    12,     9,
    1656,  1200,    23,   331,  1500,  1501,     7,  1200,   333,   376,
      11,   239,   139,    21,  1138,   969,    97,   111,   385,   384,
     114,    29,  1612,  1231,   283,  1607,  1616,   376,   136,  1209,
     153,    12,    12,   136,   376,  1215,  1235,   131,  1218,   133,
     136,  1221,  1235,    51,   384,  1678,   140,     9,  1228,  1229,
     144,   376,   376,   376,  1234,    63,   384,    12,   283,   186,
     154,   385,   385,  1704,   376,   159,   283,   345,   164,   157,
     164,   376,  1327,   385,    14,   211,   170,   376,  1639,   182,
     385,   239,   384,    91,   178,    93,   385,    97,   182,   239,
     344,   228,   123,    98,   283,   189,   233,   385,  1779,  1780,
     771,   376,   228,   357,  1694,  1695,   283,   233,     9,   376,
     385,   283,  1757,   157,   376,   811,   812,    49,   385,   291,
    1271,   376,   216,   385,  1578,   384,   373,   372,    68,   173,
     385,   239,  1331,  1284,  1285,    97,   230,   239,  1331,   386,
     811,   812,   238,    98,   238,   166,   817,  1864,   376,  1300,
     390,     9,  1713,  1714,  1815,   136,   136,   385,    90,   384,
     181,   288,   328,    68,   835,   350,   239,   384,  1292,   222,
     841,   111,   140,  1866,   114,  1868,   136,   239,   272,   239,
     239,   239,   239,   360,   361,   239,   857,   120,   360,   361,
      87,   328,   329,   133,   225,   384,    97,   239,   385,   386,
     140,  1325,   170,   239,   144,     9,   211,   384,  1388,    87,
     239,   372,   384,   239,    56,    57,   386,   190,   376,   159,
     239,   315,   384,   239,   164,   239,   376,   385,   384,  1409,
     170,    23,   129,    98,    49,   385,   123,    73,   178,    97,
     385,   386,   182,   379,   380,   381,   382,   383,    90,   189,
     384,   129,  1893,   384,   159,   349,   211,   331,   239,   239,
     390,   103,   356,   357,   272,   170,   384,   275,   376,    18,
     238,   385,   386,   178,   376,   283,   216,   371,   385,   386,
      29,    58,   290,   385,   292,   293,   128,   384,   959,   297,
     230,   385,   386,    97,   191,   389,   304,   305,   238,   384,
      49,   166,   279,   376,    53,   313,    98,   384,  1516,   980,
     341,   216,   385,   191,   376,   986,   376,   376,   376,   376,
     351,   157,   376,   385,   349,   385,   385,   385,   385,   226,
    1851,   385,   272,   384,   376,   222,   309,  1008,   225,  1010,
     376,    90,    52,   385,  1015,  1544,   211,   376,   226,   385,
     376,  1544,   325,  1533,    26,   328,   385,   376,   381,   385,
     376,  1032,   376,   112,   384,  1061,   385,   272,   182,   385,
      51,   385,    18,   384,   166,   315,   381,   382,   383,  1555,
     388,   389,  1558,   529,  1560,    66,    67,  1058,   384,   181,
    1061,  1062,   228,    74,   384,   376,   376,   233,  1919,  1920,
    1655,   243,   384,    49,   412,   413,   384,    53,    80,   349,
     315,   385,   386,  1464,  1368,    87,   309,   357,   260,   211,
     384,    68,   132,   172,   379,   380,   381,   382,   383,    61,
     222,   371,   181,   579,   580,   116,   384,   583,   584,   585,
     586,   587,   588,   384,    90,   385,   386,   157,   345,   389,
     384,   123,   460,   461,   341,   463,   384,   129,   139,   385,
     386,   385,   386,   173,   351,   385,   386,   345,   476,    25,
     384,   479,   384,   145,   384,   156,   157,   485,  1174,   125,
     488,   385,   386,   385,   389,   385,   386,    90,    44,  1682,
     171,  1162,   384,   329,   385,   386,  1167,   386,   302,   303,
     304,   305,   384,  1174,   384,   186,   385,   386,   385,   386,
     384,   315,   159,  1184,   379,   380,   381,   382,   383,   191,
     384,    77,   384,   170,    80,   385,   386,   173,   277,  1200,
     384,   178,    88,   384,  1034,   385,   386,  1037,  1209,   249,
     385,   386,  1042,  1239,  1215,   553,   384,  1218,  1048,   384,
    1221,   223,  1223,   225,   226,  1251,   564,  1228,  1229,  1814,
    1231,   385,   386,  1234,  1235,   384,    85,   384,  1239,   216,
     251,  1267,   384,  1244,  1245,   384,   222,    26,   384,   225,
    1251,   384,   590,   230,   230,   593,   384,   379,   380,   381,
     382,   383,    42,    68,   602,   384,  1267,   385,   386,   385,
     386,   384,   610,   249,   385,   386,   384,   288,   384,   617,
     385,   386,   620,   385,   386,   384,   135,  1678,  1600,  1601,
     628,   546,   547,   631,   384,   272,  1718,  1719,    18,  1822,
     149,    80,  1356,  1357,   384,   384,   384,   384,    87,    29,
     384,   287,   384,   384,   325,   653,   384,   328,  1319,   262,
     120,   659,   157,   661,   230,   257,  1327,   370,   804,   331,
    1331,   385,   334,    53,   385,    97,     9,   385,   315,   341,
     385,   390,   384,   345,   123,   158,   337,  1728,    18,   386,
     129,   386,   386,   202,   159,   381,   205,   368,   331,    29,
     297,   291,    49,   212,  1365,   170,   145,   189,   385,   385,
      90,   381,  1373,   178,   350,   136,   385,   379,   380,    49,
     385,   380,   385,    53,   385,   385,   349,  1388,   385,   385,
     385,    12,   112,  1922,    10,    11,   386,   386,  1936,  1922,
     385,   385,    68,   252,   292,    12,    22,   385,  1409,  1435,
     384,   216,   191,  1716,  1717,   384,   384,  1940,  1947,   390,
      90,   331,    35,   384,  1947,   230,   390,  1428,  1732,    45,
      46,  1432,   281,   771,  1435,   391,   385,   371,  1439,    55,
     230,   385,   112,  1444,   109,   385,   225,   226,   163,   163,
     385,    67,   172,   164,   385,   136,  1837,  1838,   385,  1840,
      81,    82,    83,    84,    85,   385,   390,   272,   390,   390,
     385,   385,  1853,   811,   812,    91,    92,    93,   386,   817,
     385,    24,   386,   168,   100,    28,   386,    52,   171,   337,
     326,   171,   326,   159,    35,   111,  1877,   835,  1879,  1880,
      49,    44,   172,   841,   170,  1809,   386,   230,   238,  1510,
     315,   102,   178,   384,   130,  1516,   384,   386,   385,   857,
     369,   385,   385,   385,   390,   146,   147,   148,   149,   378,
     385,   283,  1533,   386,    77,   386,   353,    80,   166,   179,
    1541,   173,   173,  1544,   390,    88,   162,   390,   385,    14,
     216,   226,   331,   182,   226,   334,    99,   277,   174,   385,
     285,   164,   341,   386,   385,   170,   345,   140,   170,   185,
     113,   240,   391,   173,   293,   500,   386,   173,   386,  1580,
     384,   202,   203,   204,   205,   128,   385,   173,   385,   385,
     385,   212,   385,   170,   170,   520,   230,    35,   523,   144,
     379,   380,   386,   257,   208,    90,   272,   277,   384,    90,
     384,   247,   537,   538,   384,   384,   541,   384,   239,   390,
     353,   959,   165,   328,   170,   226,   170,    51,   384,   554,
     555,   252,   195,   384,   384,   353,   226,    90,  1639,   173,
     173,   225,   980,   226,  1645,   226,   262,   263,   986,   315,
     266,   226,   384,  1654,   385,   114,   115,   273,   385,   280,
     281,  1687,   357,   279,   357,   183,   230,   283,   384,   223,
    1008,   361,  1010,  1674,   386,   291,   385,  1015,   294,   138,
     386,  1682,   385,   142,   227,   385,  1687,   226,    35,   357,
     357,    35,   308,   108,  1032,    35,   385,   133,   384,    35,
     384,    35,    35,   261,     4,   230,   230,   154,   167,    35,
      35,   353,  1713,  1714,    91,   226,   259,   176,  1576,   291,
    1058,   384,   384,  1061,  1062,   384,   342,    81,    82,    83,
      84,    85,   385,  1244,   386,   194,   352,   353,  1053,   657,
     356,  1058,  1444,  1247,   287,   670,  1033,  1541,   369,  1083,
    1213,  1752,  1543,  1572,  1654,   376,   377,   378,   217,  1846,
    1265,  1067,  1664,  1752,  1817,  1243,   999,   811,   384,  1770,
     278,   459,   950,   277,   429,   825,  1327,   886,  1149,  1353,
     949,  1918,  1610,  1834,  1782,  1943,   975,   547,  1608,   332,
     500,   334,   146,   147,   148,   149,  1544,   722,  1799,  1004,
    1527,   726,  1629,   306,   313,   413,   667,  1331,   816,  1157,
     302,  1940,  1822,   487,  1200,  1151,  1788,  1824,   743,   362,
     363,  1822,  1863,  1844,  1162,  1947,   830,   610,   510,  1167,
    1162,  1656,  1192,  1373,    88,  1634,  1174,    94,    -1,   419,
      -1,    -1,    -1,    -1,    -1,    -1,  1184,    -1,   202,   203,
     204,   205,    -1,    -1,    -1,    -1,    -1,    -1,   212,    -1,
      -1,    -1,  1200,    -1,    -1,  1866,    -1,  1868,    -1,  1870,
      -1,  1209,    -1,    -1,    -1,    -1,     5,  1215,    -1,    -1,
    1218,    10,    -1,  1221,    -1,  1223,    -1,    -1,    -1,    18,
    1228,  1229,    -1,  1231,    -1,    -1,  1234,  1235,   252,    -1,
      29,  1239,    -1,    -1,    -1,    -1,  1244,  1245,    -1,    -1,
       5,    -1,    -1,  1251,    43,    10,  1917,  1918,    -1,    -1,
      -1,  1922,    -1,    18,    53,    -1,   280,   281,    -1,  1267,
      -1,    -1,    -1,    -1,    29,  1936,    65,    -1,    -1,  1940,
      -1,    -1,  1943,    -1,    -1,    -1,  1947,    -1,    43,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    53,    -1,
      -1,    90,    -1,    -1,    -1,    -1,    95,    96,    -1,    -1,
      65,   100,    -1,    -1,    -1,    -1,    -1,    -1,   107,    -1,
      -1,  1319,   111,   112,    -1,    -1,    -1,    -1,    -1,  1327,
      -1,    -1,    -1,  1331,    -1,    90,    -1,    -1,    -1,    -1,
      95,    -1,   131,    -1,    -1,   100,    -1,    -1,    -1,    -1,
      -1,    -1,   107,    -1,    -1,   369,    -1,   112,    -1,    -1,
      -1,    -1,    -1,   377,   378,    -1,   155,  1365,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1373,   131,    -1,    -1,    -1,
      -1,    -1,    -1,   172,    -1,    -1,    -1,    -1,    -1,    -1,
    1388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   318,    -1,    -1,    -1,    -1,    -1,
      -1,  1409,    -1,    -1,    -1,    -1,    -1,   172,    -1,    -1,
      -1,   210,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   343,
    1428,    -1,    -1,    -1,  1432,    -1,    -1,  1435,   352,    -1,
      -1,  1439,    -1,    -1,    -1,    -1,  1444,    -1,    -1,   238,
      -1,    -1,    -1,    -1,    -1,   210,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   387,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   238,    -1,    -1,    -1,    -1,   277,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   263,    -1,
      -1,    -1,  1510,    -1,    -1,    -1,    -1,    -1,  1516,    -1,
      -1,    -1,   277,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1533,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1541,    -1,    -1,  1544,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   490,    -1,    -1,    -1,
      -1,   495,  1580,    -1,   498,   499,    -1,    -1,    -1,    -1,
      -1,   505,   506,   507,    -1,   509,    -1,    -1,    -1,    -1,
     514,   515,   516,   517,    -1,   519,    -1,   521,   522,    -1,
     524,   525,    -1,   527,    -1,    -1,   530,   531,   532,   533,
     534,   535,   536,    -1,    -1,   539,   540,    -1,   542,    -1,
     544,    -1,    -1,    -1,   548,   549,    -1,    -1,    -1,    -1,
      -1,  1639,   556,    -1,    -1,    -1,    -1,  1645,   562,    -1,
      -1,    -1,    -1,   567,   568,   569,  1654,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1674,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1682,    -1,    -1,    -1,    -1,  1687,
      -1,    -1,    -1,    -1,    -1,    -1,   610,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   622,    -1,
      -1,    -1,    -1,    -1,    -1,  1713,  1714,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1752,    -1,    -1,    -1,    -1,   673,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1770,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1799,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1822,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   751,   752,   753,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1866,    -1,
    1868,    -1,  1870,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     794,    -1,    -1,   797,    -1,   799,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1917,
    1918,    -1,    -1,    -1,  1922,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1936,    -1,
      -1,    -1,  1940,    -1,    -1,  1943,    -1,    -1,    -1,  1947,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   873,
      -1,    -1,   876,    -1,   878,   879,    -1,    -1,    -1,   883,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   896,    -1,    -1,   899,   900,   901,   902,   903,
      -1,    -1,    -1,    -1,    -1,    -1,   910,    -1,    -1,   913,
      -1,   915,   916,    -1,   918,    -1,    -1,    -1,    -1,   923,
     924,   925,    -1,    -1,    -1,    -1,   930,   931,   932,    -1,
     934,    -1,   936,    -1,   938,    -1,   940,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   960,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     974,    -1,   976,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1074,    -1,    -1,    -1,  1078,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1092,  1093,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1109,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1117,    -1,  1119,    -1,  1121,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1191,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1202,  1203,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1268,    -1,    -1,    -1,    -1,    -1,
    1274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1289,  1290,    -1,    -1,    -1,
      -1,    -1,    -1,  1297,    -1,    -1,    -1,    -1,  1302,    -1,
      -1,  1305,  1306,  1307,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1332,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1489,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1528,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1592,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1620,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1634,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1698,  1699,    -1,    -1,    -1,  1703,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     4,
      -1,     6,     7,     8,    -1,    -1,    -1,    -1,    13,    -1,
      -1,    -1,    17,    18,    19,    20,    -1,    22,    -1,    -1,
      25,    26,    27,    -1,    29,    30,    31,    32,    33,    34,
      -1,    36,    -1,    -1,    39,    40,    41,    42,  1772,    44,
      45,    -1,    47,    48,    -1,    50,    51,    -1,    53,    54,
      55,    56,    57,    58,    -1,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    70,    71,    -1,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    -1,    -1,    -1,
      85,    86,    87,    -1,    -1,    90,    -1,    -1,    -1,  1823,
      95,    96,  1826,    -1,  1828,    -1,   101,   102,   103,    -1,
      -1,    -1,   107,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,    -1,   118,   119,   120,   121,   122,   123,    -1,
     125,   126,   127,   128,   129,   130,    -1,    -1,    -1,   134,
     135,    -1,   137,    -1,   139,    -1,   141,    -1,   143,    -1,
     145,    -1,    -1,    -1,   149,   150,   151,   152,   153,    -1,
     155,   156,    -1,    -1,    -1,    -1,    -1,   162,   163,    -1,
      -1,    -1,    -1,   168,    -1,    -1,    -1,   172,    -1,    -1,
     175,    -1,   177,   178,   179,    -1,    -1,    -1,    -1,   184,
      -1,   186,    -1,   188,    -1,   190,   191,    -1,    -1,    -1,
      -1,   196,   197,   198,   199,   200,   201,   202,    -1,    -1,
     205,   206,   207,   208,    -1,   210,   211,   212,   213,   214,
     215,    -1,    -1,    -1,   219,   220,   221,   222,   223,   224,
     225,   226,    -1,   228,   229,    -1,   231,   232,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,    -1,
      -1,   256,    -1,    -1,    -1,   260,    -1,    -1,    -1,   264,
     265,   266,    -1,   268,    -1,   270,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,    -1,   281,   282,    -1,    -1,
      -1,   286,   287,   288,   289,    -1,    -1,    -1,   293,    -1,
     295,   296,   297,    -1,    -1,    -1,    -1,    -1,   303,    -1,
      -1,    -1,    -1,   308,   309,   310,   311,   312,   313,    -1,
      -1,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,    -1,    -1,   329,    -1,   331,   332,    -1,   334,
     335,   336,    -1,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,    -1,    -1,    -1,   351,    -1,    -1,    -1,
     355,    -1,    -1,   358,   359,   360,   361,    -1,    -1,   364,
     365,    -1,   367,   368,   369,    -1,    -1,    -1,    -1,   374,
      -1,    -1,    -1,   378,   379,   380,    -1,    -1,    -1,   384,
      -1,    -1,    -1,   388,    -1,   390,   391,     4,    -1,     6,
       7,     8,     9,    -1,    -1,    -1,    13,    -1,    -1,    -1,
      17,    18,    19,    20,    -1,    22,    -1,    -1,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    34,    -1,    36,
      -1,    -1,    39,    40,    41,    42,    -1,    44,    45,    -1,
      47,    48,    -1,    50,    51,    -1,    53,    54,    55,    56,
      57,    58,    -1,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    70,    71,    -1,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    -1,    -1,    -1,    85,    86,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    95,    96,
      -1,    -1,    -1,    -1,   101,   102,   103,    -1,    -1,    -1,
     107,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
      -1,   118,   119,   120,   121,   122,   123,    -1,   125,   126,
     127,   128,   129,   130,    -1,    -1,    -1,   134,   135,    -1,
     137,    -1,   139,    -1,   141,    -1,   143,    -1,   145,    -1,
      -1,    -1,   149,   150,   151,   152,   153,    -1,   155,   156,
      -1,    -1,    -1,    -1,    -1,   162,   163,    -1,    -1,    -1,
      -1,   168,    -1,    -1,    -1,   172,    -1,    -1,   175,    -1,
      -1,   178,   179,    -1,    -1,    -1,    -1,   184,    -1,   186,
      -1,   188,    -1,   190,   191,    -1,    -1,    -1,    -1,   196,
     197,   198,   199,   200,   201,   202,    -1,    -1,   205,   206,
     207,   208,    -1,   210,   211,   212,   213,   214,   215,    -1,
      -1,    -1,   219,   220,   221,   222,   223,   224,   225,   226,
      -1,   228,   229,   230,   231,   232,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,    -1,    -1,   256,
      -1,    -1,    -1,   260,    -1,    -1,    -1,   264,   265,   266,
      -1,   268,    -1,   270,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,    -1,   281,   282,    -1,    -1,    -1,   286,
     287,   288,   289,    -1,    -1,    -1,   293,    -1,   295,   296,
     297,    -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,
      -1,   308,   309,   310,   311,   312,   313,    -1,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,   326,
      -1,    -1,   329,    -1,   331,   332,    -1,   334,   335,   336,
      -1,    -1,   339,   340,   341,   342,   343,   344,   345,   346,
     347,    -1,    -1,    -1,   351,    -1,    -1,    -1,   355,    -1,
      -1,   358,   359,   360,   361,    -1,    -1,   364,   365,    -1,
     367,   368,   369,    -1,    -1,    -1,    -1,   374,    -1,    -1,
      -1,   378,   379,   380,    -1,    -1,     4,   384,     6,     7,
       8,   388,    -1,   390,   391,    13,    -1,    -1,    -1,    17,
      18,    19,    20,    -1,    22,    -1,    -1,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    34,    -1,    36,    -1,
      -1,    39,    40,    41,    42,    -1,    44,    45,    -1,    47,
      48,    -1,    50,    51,    -1,    53,    54,    55,    56,    57,
      58,    -1,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      -1,    69,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    85,    86,    87,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    95,    96,    -1,
      -1,    -1,    -1,   101,   102,   103,    -1,    -1,    -1,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,    -1,
     118,   119,   120,   121,   122,   123,    -1,   125,   126,   127,
     128,   129,   130,    -1,    -1,    -1,   134,   135,    -1,   137,
      -1,   139,    -1,   141,    -1,   143,    -1,   145,    -1,    -1,
      -1,   149,   150,   151,   152,   153,    -1,   155,   156,    -1,
      -1,    -1,    -1,    -1,   162,   163,    -1,    -1,    -1,    -1,
     168,    -1,    -1,    -1,   172,    -1,    -1,   175,    -1,    -1,
     178,   179,    -1,    -1,    -1,    -1,   184,    -1,   186,    -1,
     188,    -1,   190,   191,    -1,    -1,    -1,    -1,   196,   197,
     198,   199,   200,   201,   202,    -1,    -1,   205,   206,   207,
     208,    -1,   210,   211,   212,   213,   214,   215,    -1,    -1,
      -1,   219,   220,   221,   222,   223,   224,   225,   226,    -1,
     228,   229,    -1,   231,   232,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,    -1,    -1,   256,    -1,
      -1,    -1,   260,    -1,    -1,    -1,   264,   265,   266,    -1,
     268,    -1,   270,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,    -1,   281,   282,    -1,    -1,    -1,   286,   287,
     288,   289,    -1,    -1,    -1,   293,    -1,   295,   296,   297,
      -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,
     308,   309,   310,   311,   312,   313,    -1,    -1,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,   326,    -1,
      -1,   329,    -1,   331,   332,    -1,   334,   335,   336,    -1,
      -1,   339,   340,   341,   342,   343,   344,   345,   346,   347,
      -1,    -1,    -1,   351,    -1,    -1,    -1,   355,    -1,    -1,
     358,   359,   360,   361,    -1,    -1,   364,   365,    -1,   367,
     368,   369,    -1,    -1,    -1,    -1,   374,    -1,    -1,    -1,
     378,   379,   380,    -1,    -1,    -1,   384,   385,    -1,    -1,
     388,    -1,   390,   391,     4,    -1,     6,     7,     8,    -1,
      -1,    -1,    -1,    13,    -1,    -1,    -1,    17,    18,    19,
      20,    -1,    22,    -1,    -1,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    34,    -1,    36,    -1,    -1,    39,
      40,    41,    42,    -1,    44,    45,    -1,    47,    48,    -1,
      50,    51,    -1,    53,    54,    55,    56,    57,    58,    -1,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    -1,    -1,    -1,    85,    86,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    95,    96,    -1,    -1,    -1,
      -1,   101,   102,   103,    -1,    -1,    -1,   107,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,    -1,   118,   119,
     120,   121,   122,   123,    -1,   125,   126,   127,   128,   129,
     130,    -1,    -1,    -1,   134,   135,   136,   137,    -1,   139,
      -1,   141,    -1,   143,    -1,   145,    -1,    -1,    -1,   149,
     150,   151,   152,   153,    -1,   155,   156,    -1,    -1,    -1,
      -1,    -1,   162,   163,    -1,    -1,    -1,    -1,   168,    -1,
      -1,    -1,   172,    -1,    -1,   175,    -1,    -1,   178,   179,
      -1,    -1,    -1,    -1,   184,    -1,   186,    -1,   188,    -1,
     190,   191,    -1,    -1,    -1,    -1,   196,   197,   198,   199,
     200,   201,   202,    -1,    -1,   205,   206,   207,   208,    -1,
     210,   211,   212,   213,   214,   215,    -1,    -1,    -1,   219,
     220,   221,   222,   223,   224,   225,   226,    -1,   228,   229,
      -1,   231,   232,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,    -1,    -1,   256,    -1,    -1,    -1,
     260,    -1,    -1,    -1,   264,   265,   266,    -1,   268,    -1,
     270,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
      -1,   281,   282,    -1,    -1,    -1,   286,   287,   288,   289,
      -1,    -1,    -1,   293,    -1,   295,   296,   297,    -1,    -1,
      -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,   326,    -1,    -1,   329,
      -1,   331,   332,    -1,   334,   335,   336,    -1,    -1,   339,
     340,   341,   342,   343,   344,   345,   346,   347,    -1,    -1,
      -1,   351,    -1,    -1,    -1,   355,    -1,    -1,   358,   359,
     360,   361,    -1,    -1,   364,   365,    -1,   367,   368,   369,
      -1,    -1,    -1,    -1,   374,    -1,    -1,    -1,   378,   379,
     380,    -1,    -1,     4,   384,     6,     7,     8,   388,    -1,
     390,   391,    13,    -1,    -1,    -1,    17,    18,    19,    20,
      -1,    22,    -1,    -1,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    34,    -1,    36,    -1,    -1,    39,    40,
      41,    42,    -1,    44,    45,    -1,    47,    48,    -1,    50,
      51,    -1,    53,    54,    55,    56,    57,    58,    -1,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    -1,    -1,    -1,    85,    86,    87,    -1,    -1,    90,
      -1,    -1,    -1,    -1,    95,    96,    -1,    -1,    -1,    -1,
     101,   102,   103,    -1,    -1,    -1,   107,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,    -1,   118,   119,   120,
     121,   122,   123,    -1,   125,   126,   127,   128,   129,   130,
      -1,    -1,    -1,   134,   135,   136,   137,    -1,   139,    -1,
     141,    -1,   143,    -1,   145,    -1,    -1,    -1,   149,   150,
     151,   152,   153,    -1,   155,   156,    -1,    -1,    -1,    -1,
      -1,   162,   163,    -1,    -1,    -1,    -1,   168,    -1,    -1,
      -1,   172,    -1,    -1,   175,    -1,    -1,   178,   179,    -1,
      -1,    -1,    -1,   184,    -1,   186,    -1,   188,    -1,   190,
     191,    -1,    -1,    -1,    -1,   196,   197,   198,   199,   200,
     201,   202,    -1,    -1,   205,   206,   207,   208,    -1,   210,
     211,   212,   213,   214,   215,    -1,    -1,    -1,   219,   220,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,    -1,    -1,   256,    -1,    -1,    -1,   260,
      -1,    -1,    -1,   264,   265,   266,    -1,   268,    -1,   270,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,    -1,
     281,   282,    -1,    -1,    -1,   286,   287,   288,   289,    -1,
      -1,    -1,   293,    -1,   295,   296,   297,    -1,    -1,    -1,
      -1,    -1,   303,    -1,    -1,    -1,    -1,   308,   309,   310,
     311,   312,   313,    -1,    -1,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,   326,    -1,    -1,   329,    -1,
     331,   332,    -1,   334,   335,   336,    -1,    -1,   339,   340,
     341,   342,   343,   344,   345,   346,   347,    -1,    -1,    -1,
     351,    -1,    -1,    -1,   355,    -1,    -1,   358,   359,   360,
     361,    -1,    -1,   364,   365,    -1,   367,   368,   369,    -1,
      -1,    -1,    -1,   374,    -1,    -1,    -1,   378,   379,   380,
      -1,    -1,     4,   384,     6,     7,     8,   388,    -1,   390,
     391,    13,    -1,    -1,    -1,    17,    18,    19,    20,    -1,
      22,    -1,    -1,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    34,    -1,    36,    -1,    -1,    39,    40,    41,
      42,    -1,    44,    45,    -1,    47,    48,    -1,    50,    51,
      -1,    53,    54,    55,    56,    57,    58,    -1,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    70,    71,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      -1,    -1,    -1,    85,    86,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    95,    96,    -1,    -1,    -1,    -1,   101,
     102,   103,    -1,    -1,    -1,   107,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,    -1,   118,   119,   120,   121,
     122,   123,    -1,   125,   126,   127,   128,   129,   130,    -1,
      -1,    -1,   134,   135,   136,   137,    -1,   139,    -1,   141,
      -1,   143,    -1,   145,    -1,    -1,    -1,   149,   150,   151,
     152,   153,    -1,   155,   156,    -1,    -1,    -1,    -1,    -1,
     162,   163,    -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,
     172,    -1,    -1,   175,    -1,    -1,   178,   179,    -1,    -1,
      -1,    -1,   184,    -1,   186,    -1,   188,    -1,   190,   191,
      -1,    -1,    -1,    -1,   196,   197,   198,   199,   200,   201,
     202,    -1,    -1,   205,   206,   207,   208,    -1,   210,   211,
     212,   213,   214,   215,    -1,    -1,    -1,   219,   220,   221,
     222,   223,   224,   225,   226,    -1,   228,   229,    -1,   231,
     232,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,
      -1,    -1,   264,   265,   266,    -1,   268,    -1,   270,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,    -1,   281,
     282,    -1,    -1,    -1,   286,   287,   288,   289,    -1,    -1,
      -1,   293,    -1,   295,   296,   297,    -1,    -1,    -1,    -1,
      -1,   303,    -1,    -1,    -1,    -1,   308,   309,   310,   311,
     312,   313,    -1,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,   325,   326,    -1,    -1,   329,    -1,   331,
     332,    -1,   334,   335,   336,    -1,    -1,   339,   340,   341,
     342,   343,   344,   345,   346,   347,    -1,    -1,    -1,   351,
      -1,    -1,    -1,   355,    -1,    -1,   358,   359,   360,   361,
      -1,    -1,   364,   365,    -1,   367,   368,   369,    -1,    -1,
      -1,    -1,   374,    -1,    -1,    -1,   378,   379,   380,    -1,
      -1,     4,   384,     6,     7,     8,   388,    -1,   390,   391,
      13,    -1,    -1,    -1,    17,    18,    19,    20,    -1,    22,
      -1,    -1,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    34,    -1,    36,    -1,    -1,    39,    40,    41,    42,
      -1,    44,    45,    -1,    47,    48,    -1,    50,    51,    -1,
      53,    54,    55,    56,    57,    58,    -1,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    -1,    69,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    -1,
      -1,    -1,    85,    86,    87,    -1,    -1,    90,    -1,    -1,
      -1,    -1,    95,    96,    -1,    -1,    -1,    -1,   101,   102,
     103,    -1,    -1,    -1,   107,    -1,   109,   110,    -1,   112,
     113,    -1,    -1,   116,    -1,   118,   119,   120,   121,   122,
     123,    -1,   125,   126,   127,   128,   129,   130,    -1,    -1,
      -1,   134,   135,    -1,   137,    -1,   139,    -1,   141,    -1,
     143,    -1,   145,    -1,    -1,    -1,   149,   150,   151,   152,
     153,    -1,   155,   156,    -1,    -1,    -1,    -1,    -1,   162,
     163,    -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,   172,
      -1,    -1,   175,    -1,    -1,   178,   179,    -1,    -1,    -1,
      -1,   184,    -1,   186,    -1,   188,    -1,   190,   191,    -1,
      -1,    -1,    -1,   196,   197,   198,   199,   200,   201,   202,
      -1,    -1,   205,   206,   207,   208,    -1,   210,   211,   212,
     213,   214,   215,    -1,    -1,    -1,   219,   220,   221,   222,
     223,   224,   225,   226,    -1,   228,   229,    -1,   231,   232,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,    -1,
      -1,   264,   265,   266,    -1,   268,    -1,   270,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,    -1,   281,   282,
      -1,    -1,    -1,   286,   287,   288,   289,    -1,    -1,    -1,
     293,    -1,   295,   296,   297,    -1,    -1,    -1,    -1,    -1,
     303,    -1,    -1,    -1,    -1,   308,   309,   310,   311,   312,
     313,    -1,    -1,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,   326,    -1,    -1,   329,    -1,   331,   332,
      -1,   334,   335,   336,    -1,    -1,   339,   340,   341,   342,
     343,   344,   345,   346,   347,    -1,    -1,    -1,   351,    -1,
      -1,    -1,   355,    -1,    -1,   358,   359,   360,   361,    -1,
      -1,   364,   365,    -1,   367,   368,   369,    -1,    -1,    -1,
      -1,   374,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,
       4,   384,     6,     7,     8,   388,    -1,   390,   391,    13,
      -1,    -1,    -1,    17,    18,    19,    20,    -1,    22,    -1,
      -1,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      34,    -1,    36,    -1,    -1,    39,    40,    41,    42,    -1,
      44,    45,    -1,    47,    48,    -1,    50,    51,    -1,    53,
      54,    55,    56,    57,    58,    -1,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    -1,    69,    70,    71,    -1,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    -1,    -1,
      -1,    85,    86,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    95,    96,    -1,    -1,    -1,    -1,   101,   102,   103,
      -1,    -1,    -1,   107,    -1,   109,   110,    -1,   112,   113,
      -1,    -1,   116,    -1,   118,   119,   120,   121,   122,   123,
      -1,   125,   126,   127,   128,   129,   130,    -1,    -1,    -1,
     134,   135,    -1,   137,    -1,   139,    -1,   141,    -1,   143,
      -1,   145,    -1,    -1,    -1,   149,   150,   151,   152,   153,
      -1,   155,   156,    -1,    -1,    -1,    -1,    -1,   162,   163,
      -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,   172,    -1,
      -1,   175,    -1,    -1,   178,   179,    -1,    -1,    -1,    -1,
     184,    -1,   186,    -1,   188,    -1,   190,   191,    -1,    -1,
      -1,    -1,   196,   197,   198,   199,   200,   201,   202,    -1,
      -1,   205,   206,   207,   208,    -1,   210,   211,   212,   213,
     214,   215,    -1,    -1,    -1,   219,   220,   221,   222,   223,
     224,   225,   226,    -1,   228,   229,    -1,   231,   232,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
      -1,    -1,   256,    -1,    -1,    -1,   260,    -1,    -1,    -1,
     264,   265,   266,    -1,   268,    -1,   270,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,    -1,   281,   282,    -1,
      -1,    -1,   286,   287,   288,   289,    -1,    -1,    -1,   293,
      -1,   295,   296,   297,    -1,    -1,    -1,    -1,    -1,   303,
      -1,    -1,    -1,    -1,   308,   309,   310,   311,   312,   313,
      -1,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   326,    -1,    -1,   329,    -1,   331,   332,    -1,
     334,   335,   336,    -1,    -1,   339,   340,   341,   342,   343,
     344,   345,   346,   347,    -1,    -1,    -1,   351,    -1,    -1,
      -1,   355,    -1,    -1,   358,   359,   360,   361,    -1,    -1,
     364,   365,    -1,   367,   368,   369,    -1,    -1,    -1,    -1,
     374,    -1,    -1,    -1,   378,   379,   380,    -1,    -1,    -1,
     384,    -1,    -1,    -1,   388,    -1,   390,   391,     4,    -1,
       6,     7,     8,     9,    -1,    -1,    -1,    13,    -1,    -1,
      -1,    17,    18,    19,    20,    -1,    22,    -1,    -1,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    34,    -1,
      36,    -1,    -1,    39,    40,    41,    42,    -1,    44,    45,
      -1,    47,    48,    -1,    50,    51,    -1,    53,    54,    55,
      56,    57,    58,    -1,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    -1,    -1,    -1,    85,
      86,    87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    95,
      96,    -1,    -1,    -1,    -1,   101,   102,   103,    -1,    -1,
      -1,   107,    -1,   109,   110,    -1,   112,   113,    -1,    -1,
     116,    -1,   118,   119,   120,   121,   122,   123,    -1,   125,
     126,   127,   128,   129,   130,    -1,    -1,    -1,   134,   135,
      -1,   137,    -1,   139,    -1,   141,    -1,   143,    -1,   145,
      -1,    -1,    -1,   149,   150,   151,   152,   153,    -1,   155,
     156,    -1,    -1,    -1,    -1,    -1,   162,   163,    -1,    -1,
      -1,    -1,   168,    -1,    -1,    -1,   172,    -1,    -1,   175,
      -1,    -1,   178,   179,    -1,    -1,    -1,    -1,   184,    -1,
     186,    -1,   188,    -1,   190,   191,    -1,    -1,    -1,    -1,
     196,   197,   198,   199,   200,   201,   202,    -1,    -1,   205,
     206,   207,   208,    -1,   210,   211,   212,   213,   214,   215,
      -1,    -1,    -1,   219,   220,   221,    -1,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,    -1,    -1,
     256,    -1,    -1,    -1,   260,    -1,    -1,    -1,   264,   265,
     266,    -1,   268,    -1,   270,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,    -1,   281,   282,    -1,    -1,    -1,
     286,   287,   288,   289,    -1,    -1,    -1,   293,    -1,   295,
     296,   297,    -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,
      -1,    -1,   308,   309,   310,   311,   312,   313,    -1,    -1,
     316,   317,   318,   319,   320,   321,   322,   323,   324,   325,
     326,    -1,    -1,   329,    -1,   331,   332,    -1,   334,   335,
     336,    -1,    -1,   339,   340,   341,   342,   343,   344,   345,
     346,   347,    -1,    -1,    -1,   351,    -1,    -1,    -1,   355,
      -1,    -1,   358,   359,   360,   361,    -1,    -1,   364,   365,
      -1,   367,   368,   369,    -1,    -1,    -1,    -1,   374,    -1,
      -1,    -1,   378,   379,   380,    -1,    -1,     4,   384,     6,
       7,     8,   388,    -1,   390,   391,    13,    -1,    -1,    -1,
      17,    18,    19,    20,    -1,    22,    -1,    -1,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    34,    -1,    36,
      -1,    -1,    39,    40,    41,    42,    -1,    44,    45,    -1,
      47,    48,    -1,    50,    51,    -1,    53,    54,    55,    56,
      57,    58,    -1,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    70,    71,    -1,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    -1,    -1,    -1,    85,    86,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    95,    96,
      -1,    -1,    -1,    -1,   101,   102,   103,    -1,    -1,    -1,
     107,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
      -1,   118,   119,   120,   121,   122,   123,    -1,   125,   126,
     127,   128,   129,   130,    -1,    -1,    -1,   134,   135,    -1,
     137,    -1,   139,    -1,   141,    -1,   143,    -1,   145,    -1,
      -1,    -1,   149,   150,   151,   152,   153,    -1,   155,   156,
      -1,    -1,    -1,    -1,    -1,   162,   163,    -1,    -1,    -1,
      -1,   168,    -1,    -1,    -1,   172,    -1,    -1,   175,    -1,
      -1,   178,   179,    -1,    -1,    -1,    -1,   184,    -1,   186,
      -1,   188,    -1,   190,   191,    -1,    -1,    -1,    -1,   196,
     197,   198,   199,   200,   201,   202,    -1,    -1,   205,   206,
     207,   208,    -1,   210,   211,   212,   213,   214,   215,    -1,
      -1,    -1,   219,   220,   221,   222,   223,   224,   225,   226,
      -1,   228,   229,    -1,   231,   232,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,    -1,    -1,   256,
      -1,    -1,    -1,   260,    -1,    -1,    -1,   264,   265,   266,
      -1,   268,    -1,   270,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,    -1,   281,   282,    -1,    -1,    -1,   286,
     287,   288,   289,    -1,    -1,    -1,   293,    -1,   295,   296,
     297,    -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,
      -1,   308,   309,   310,   311,   312,   313,    -1,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,   326,
      -1,    -1,   329,    -1,   331,   332,    -1,   334,   335,   336,
      -1,    -1,   339,   340,   341,   342,   343,   344,   345,   346,
     347,    -1,    -1,    -1,   351,    -1,    -1,    -1,   355,    -1,
      -1,   358,   359,   360,   361,    -1,    -1,   364,   365,    -1,
     367,   368,   369,    -1,    -1,    -1,    -1,   374,    -1,    -1,
      -1,   378,   379,   380,    -1,    -1,     4,   384,     6,     7,
       8,   388,    -1,   390,   391,    13,    -1,    -1,    -1,    17,
      18,    19,    20,    -1,    22,    -1,    -1,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    34,    -1,    36,    -1,
      -1,    39,    40,    41,    42,    -1,    44,    45,    -1,    47,
      48,    -1,    50,    51,    -1,    53,    54,    55,    56,    57,
      58,    -1,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      -1,    69,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    85,    86,    87,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    95,    96,    -1,
      -1,    -1,    -1,   101,   102,   103,    -1,    -1,    -1,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,    -1,
     118,   119,   120,   121,   122,   123,    -1,   125,   126,   127,
     128,   129,   130,    -1,    -1,    -1,   134,   135,    -1,   137,
      -1,   139,    -1,   141,    -1,   143,    -1,   145,    -1,    -1,
      -1,   149,   150,   151,   152,   153,    -1,   155,   156,    -1,
      -1,    -1,    -1,    -1,   162,   163,    -1,    -1,    -1,    -1,
     168,    -1,    -1,    -1,   172,    -1,    -1,   175,    -1,    -1,
     178,   179,    -1,    -1,    -1,    -1,   184,    -1,   186,    -1,
     188,    -1,   190,   191,    -1,    -1,    -1,    -1,   196,   197,
     198,   199,   200,   201,   202,    -1,    -1,   205,   206,   207,
     208,    -1,   210,   211,   212,   213,   214,   215,    -1,    -1,
      -1,   219,   220,   221,   222,   223,   224,   225,   226,    -1,
     228,   229,    -1,   231,   232,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,    -1,    -1,   256,    -1,
      -1,    -1,   260,    -1,    -1,    -1,   264,   265,   266,    -1,
     268,    -1,   270,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,    -1,   281,   282,    -1,    -1,    -1,   286,   287,
     288,   289,    -1,    -1,    -1,   293,    -1,   295,   296,   297,
      -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,
     308,   309,   310,   311,   312,   313,    -1,    -1,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,   326,    -1,
      -1,   329,    -1,   331,   332,    -1,   334,   335,   336,    -1,
      -1,   339,   340,   341,   342,   343,   344,   345,   346,   347,
      -1,    -1,    -1,   351,    -1,    -1,    -1,   355,    -1,    -1,
     358,   359,   360,   361,    -1,    -1,   364,   365,    -1,   367,
     368,   369,    -1,    -1,    -1,    -1,   374,    -1,    -1,    -1,
     378,   379,   380,    -1,    -1,     4,   384,     6,     7,     8,
     388,    -1,   390,   391,    13,    -1,    -1,    -1,    17,    18,
      19,    20,    -1,    22,    -1,    -1,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    34,    -1,    36,    -1,    -1,
      39,    40,    41,    42,    -1,    44,    45,    -1,    47,    48,
      -1,    50,    51,    -1,    53,    54,    55,    56,    57,    58,
      -1,    60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,
      69,    70,    71,    -1,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    -1,    -1,    -1,    85,    86,    87,    -1,
      -1,    90,    -1,    -1,    -1,    -1,    95,    96,    -1,    -1,
      -1,    -1,   101,   102,   103,    -1,    -1,    -1,   107,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,    -1,   118,
     119,   120,   121,   122,   123,    -1,   125,   126,   127,   128,
     129,   130,    -1,    -1,    -1,   134,   135,    -1,   137,    -1,
     139,    -1,   141,    -1,   143,    -1,   145,    -1,    -1,    -1,
     149,   150,   151,   152,   153,    -1,   155,   156,    -1,    -1,
      -1,    -1,    -1,   162,   163,    -1,    -1,    -1,    -1,   168,
      -1,    -1,    -1,   172,    -1,    -1,   175,    -1,    -1,   178,
     179,    -1,    -1,    -1,    -1,   184,    -1,   186,    -1,   188,
      -1,   190,   191,    -1,    -1,    -1,    -1,   196,   197,   198,
     199,   200,   201,   202,    -1,    -1,   205,   206,   207,   208,
      -1,   210,   211,   212,   213,   214,   215,    -1,    -1,    -1,
     219,   220,   221,   222,   223,   224,   225,   226,    -1,   228,
     229,    -1,   231,   232,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,    -1,    -1,   256,    -1,    -1,
      -1,   260,    -1,    -1,    -1,   264,   265,   266,    -1,   268,
      -1,   270,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,    -1,   281,   282,    -1,    -1,    -1,   286,   287,   288,
     289,    -1,    -1,    -1,   293,    -1,   295,   296,   297,    -1,
      -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,   308,
     309,   310,   311,   312,   313,    -1,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,   326,    -1,    -1,
     329,    -1,   331,   332,    -1,   334,   335,   336,    -1,    -1,
     339,   340,   341,   342,   343,   344,   345,   346,   347,    -1,
      -1,    -1,   351,    -1,    -1,    -1,   355,    -1,    -1,   358,
     359,   360,   361,    -1,    -1,   364,   365,    -1,   367,   368,
     369,    -1,    -1,    -1,    -1,   374,    -1,    -1,    -1,   378,
     379,   380,    -1,    -1,     4,   384,     6,     7,     8,   388,
      -1,   390,   391,    13,    -1,    -1,    -1,    17,    18,    19,
      20,    -1,    22,    -1,    -1,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    34,    -1,    36,    -1,    -1,    39,
      40,    41,    42,    -1,    44,    45,    -1,    47,    48,    -1,
      50,    51,    -1,    53,    54,    55,    56,    57,    58,    -1,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    -1,    -1,    -1,    85,    86,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    95,    96,    -1,    -1,    -1,
      -1,   101,   102,   103,    -1,    -1,    -1,   107,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,    -1,   118,   119,
     120,   121,   122,   123,    -1,   125,   126,   127,   128,   129,
     130,    -1,    -1,    -1,   134,   135,    -1,   137,    -1,   139,
      -1,   141,    -1,   143,    -1,   145,    -1,    -1,    -1,   149,
     150,   151,   152,   153,    -1,   155,   156,    -1,    -1,    -1,
      -1,    -1,   162,   163,    -1,    -1,    -1,    -1,   168,    -1,
      -1,    -1,   172,    -1,    -1,   175,    -1,    -1,   178,   179,
      -1,    -1,    -1,    -1,   184,    -1,   186,    -1,   188,    -1,
     190,   191,    -1,    -1,    -1,    -1,   196,   197,   198,   199,
     200,   201,   202,    -1,    -1,   205,   206,   207,   208,    -1,
     210,   211,   212,   213,   214,   215,    -1,    -1,    -1,   219,
     220,   221,    -1,   223,   224,   225,   226,    -1,   228,   229,
      -1,   231,   232,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,    -1,    -1,   256,    -1,    -1,    -1,
     260,    -1,    -1,    -1,   264,   265,   266,    -1,   268,    -1,
     270,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
      -1,   281,   282,    -1,    -1,    -1,   286,   287,   288,   289,
      -1,    -1,    -1,   293,    -1,   295,   296,   297,    -1,    -1,
      -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,   326,    -1,    -1,   329,
      -1,   331,   332,    -1,   334,   335,   336,    -1,    -1,   339,
     340,   341,   342,   343,   344,   345,   346,   347,    -1,    -1,
      -1,   351,    -1,    -1,    -1,   355,    -1,    -1,   358,   359,
     360,   361,    -1,    -1,   364,   365,    -1,   367,   368,   369,
      -1,    -1,    -1,    -1,   374,    -1,    -1,    -1,   378,   379,
     380,    -1,    -1,     4,   384,     6,     7,     8,   388,    -1,
     390,   391,    13,    -1,    -1,    -1,    17,    18,    19,    20,
      -1,    22,    -1,    -1,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    34,    -1,    36,    -1,    -1,    39,    40,
      41,    42,    -1,    44,    45,    -1,    47,    48,    -1,    50,
      51,    -1,    53,    54,    55,    56,    57,    58,    -1,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    -1,    -1,    -1,    85,    86,    87,    -1,    -1,    90,
      -1,    -1,    -1,    -1,    95,    96,    -1,    -1,    -1,    -1,
     101,   102,   103,    -1,    -1,    -1,   107,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,    -1,   118,   119,   120,
     121,   122,   123,    -1,   125,   126,   127,   128,   129,   130,
      -1,    -1,    -1,   134,   135,    -1,   137,    -1,   139,    -1,
     141,    -1,   143,    -1,   145,    -1,    -1,    -1,   149,   150,
     151,   152,   153,    -1,   155,   156,    -1,    -1,    -1,    -1,
      -1,   162,   163,    -1,    -1,    -1,    -1,   168,    -1,    -1,
      -1,   172,    -1,    -1,   175,    -1,    -1,   178,   179,    -1,
      -1,    -1,    -1,   184,    -1,   186,    -1,   188,    -1,   190,
     191,    -1,    -1,    -1,    -1,   196,   197,   198,   199,   200,
     201,   202,    -1,    -1,   205,   206,   207,   208,    -1,   210,
     211,   212,   213,   214,   215,    -1,    -1,    -1,   219,   220,
     221,    -1,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,    -1,    -1,   256,    -1,    -1,    -1,   260,
      -1,    -1,    -1,   264,   265,   266,    -1,   268,    -1,   270,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,    -1,
     281,   282,    -1,    -1,    -1,   286,   287,   288,   289,    -1,
      -1,    -1,   293,    -1,   295,   296,   297,    -1,    -1,    -1,
      -1,    -1,   303,    -1,    -1,    -1,    -1,   308,   309,   310,
     311,   312,   313,    -1,    -1,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,   326,    -1,    -1,   329,    -1,
     331,   332,    -1,   334,   335,   336,    -1,    -1,   339,   340,
     341,   342,   343,   344,   345,   346,   347,    -1,    -1,    -1,
     351,    -1,    -1,    -1,   355,    -1,    -1,   358,   359,   360,
     361,    -1,    -1,   364,   365,    -1,   367,   368,   369,    -1,
      -1,    -1,    -1,   374,    -1,    -1,    -1,   378,   379,   380,
      -1,    -1,     4,   384,     6,     7,     8,   388,    -1,   390,
     391,    13,    -1,    -1,    -1,    17,    18,    19,    20,    -1,
      22,    -1,    -1,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    34,    -1,    36,    -1,    -1,    39,    40,    41,
      42,    -1,    44,    45,    -1,    47,    48,    -1,    50,    51,
      -1,    53,    54,    55,    56,    57,    58,    -1,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    70,    71,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      -1,    -1,    -1,    85,    86,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    95,    96,    -1,    -1,    -1,    -1,   101,
     102,   103,    -1,    -1,    -1,   107,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,    -1,   118,   119,   120,   121,
     122,   123,    -1,   125,   126,   127,   128,   129,   130,    -1,
      -1,    -1,   134,   135,    -1,   137,    -1,   139,    -1,   141,
      -1,   143,    -1,   145,    -1,    -1,    -1,   149,   150,   151,
     152,   153,    -1,   155,   156,    -1,    -1,    -1,    -1,    -1,
     162,   163,    -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,
     172,    -1,    -1,   175,    -1,    -1,   178,   179,    -1,    -1,
      -1,    -1,   184,    -1,   186,    -1,   188,    -1,   190,   191,
      -1,    -1,    -1,    -1,   196,   197,   198,   199,   200,   201,
     202,    -1,    -1,   205,   206,   207,   208,    -1,   210,   211,
     212,   213,   214,   215,    -1,    -1,    -1,   219,   220,   221,
      -1,   223,   224,   225,   226,    -1,   228,   229,    -1,   231,
     232,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,
      -1,    -1,   264,   265,   266,    -1,   268,    -1,   270,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,    -1,   281,
     282,    -1,    -1,    -1,   286,   287,   288,   289,    -1,    -1,
      -1,   293,    -1,   295,   296,   297,    -1,    -1,    -1,    -1,
      -1,   303,    -1,    -1,    -1,    -1,   308,   309,   310,   311,
     312,   313,    -1,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,   325,   326,    -1,    -1,   329,    -1,   331,
     332,    -1,   334,   335,   336,    -1,    -1,   339,   340,   341,
     342,   343,   344,   345,   346,   347,    -1,    -1,    -1,   351,
      -1,    -1,    -1,   355,    -1,    -1,   358,   359,   360,   361,
      -1,    -1,   364,   365,    -1,   367,   368,   369,    -1,    -1,
      -1,    -1,   374,    -1,    -1,    -1,   378,   379,   380,    -1,
      -1,     4,   384,     6,     7,     8,   388,    -1,   390,   391,
      13,    -1,    -1,    -1,    17,    18,    19,    20,    -1,    22,
      -1,    -1,    -1,    -1,    27,    -1,    29,    30,    31,    32,
      -1,    34,    -1,    36,    -1,    -1,    39,    -1,    -1,    42,
      -1,    -1,    45,    -1,    47,    48,    -1,    50,    51,    -1,
      53,    54,    55,    56,    57,    58,    -1,    60,    61,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,
      -1,    74,    75,    76,    77,    -1,    -1,    80,    -1,    -1,
      -1,    -1,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    -1,    -1,    -1,   101,   102,
     103,    -1,    -1,    -1,   107,    -1,   109,   110,    -1,   112,
     113,    -1,    -1,   116,    -1,   118,   119,    -1,   121,    -1,
      -1,    -1,   125,   126,   127,   128,    -1,   130,    -1,    -1,
      -1,   134,   135,    -1,   137,    -1,   139,    -1,    -1,    -1,
     143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
      -1,    -1,   155,   156,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,   172,
      -1,    -1,   175,    -1,    -1,    -1,   179,   180,    -1,    -1,
      -1,   184,    -1,   186,    -1,   188,    -1,   190,    -1,    -1,
      -1,    -1,    -1,   196,   197,    -1,   199,   200,   201,   202,
      -1,    -1,   205,   206,    -1,   208,    -1,   210,    -1,   212,
     213,   214,   215,    -1,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,    -1,   228,   229,    -1,   231,   232,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     243,   244,   245,    -1,    -1,   248,    -1,   250,   251,   252,
     253,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,    -1,
      -1,   264,    -1,    -1,    -1,   268,    -1,   270,    -1,    -1,
     273,   274,   275,   276,   277,   278,   279,    -1,   281,   282,
      -1,    -1,    -1,   286,   287,   288,   289,    -1,    -1,    -1,
     293,    -1,   295,   296,   297,    -1,    -1,    -1,    -1,    -1,
     303,    -1,    -1,    -1,    -1,   308,   309,    -1,    -1,   312,
     313,    -1,    -1,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,    -1,    -1,   329,    -1,   331,   332,
      -1,   334,   335,   336,    -1,    -1,   339,    -1,    -1,   342,
     343,   344,    -1,   346,   347,    -1,    -1,    -1,   351,    -1,
      -1,    -1,   355,    -1,    -1,    -1,    -1,    -1,   361,    -1,
      -1,   364,    -1,    -1,    -1,   368,   369,    -1,    -1,    -1,
      -1,   374,    -1,    -1,    -1,   378,     4,    -1,     6,     7,
       8,    -1,    -1,    -1,    -1,    13,    -1,    -1,   391,    17,
      18,    19,    20,    -1,    22,    -1,    -1,    -1,    -1,    27,
      -1,    29,    30,    31,    32,    -1,    34,    -1,    36,    -1,
      -1,    39,    -1,    -1,    42,    -1,    -1,    45,    -1,    47,
      48,    -1,    50,    51,    -1,    53,    54,    55,    56,    57,
      58,    -1,    60,    61,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    69,    -1,    -1,    -1,    -1,    74,    75,    76,    77,
      -1,    -1,    80,    -1,    -1,    -1,    -1,    85,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      -1,    -1,    -1,   101,   102,   103,    -1,    -1,    -1,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,    -1,
     118,   119,    -1,   121,    -1,    -1,    -1,   125,   126,   127,
     128,    -1,   130,    -1,    -1,    -1,   134,   135,    -1,   137,
      -1,   139,    -1,    -1,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,    -1,    -1,   155,   156,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     168,    -1,    -1,    -1,   172,    -1,    -1,   175,    -1,    -1,
      -1,   179,   180,    -1,    -1,    -1,   184,    -1,   186,    -1,
     188,    -1,   190,    -1,    -1,    -1,    -1,    -1,   196,   197,
      -1,   199,   200,   201,   202,    -1,    -1,   205,   206,    -1,
     208,    -1,   210,    -1,   212,   213,   214,   215,    -1,    -1,
      -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,    -1,
     228,   229,    -1,   231,   232,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   243,   244,   245,    -1,    -1,
     248,    -1,   250,   251,   252,   253,    -1,    -1,   256,    -1,
      -1,    -1,   260,    -1,    -1,    -1,   264,    -1,    -1,    -1,
     268,    -1,   270,    -1,    -1,   273,   274,   275,   276,   277,
     278,   279,    -1,   281,   282,    -1,    -1,    -1,   286,   287,
     288,   289,    -1,    -1,    -1,   293,    -1,   295,   296,   297,
      -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,
     308,   309,    -1,    -1,   312,   313,    -1,    -1,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,    -1,
      -1,   329,    -1,   331,   332,    -1,   334,   335,   336,    -1,
      -1,   339,    -1,    -1,   342,   343,   344,    -1,   346,   347,
      -1,    -1,    -1,   351,    -1,    -1,    -1,   355,    -1,    -1,
      -1,    -1,    -1,   361,    -1,    -1,   364,    -1,    -1,    -1,
     368,   369,    -1,    -1,    -1,    -1,   374,    -1,    -1,    -1,
     378,     4,    -1,     6,     7,     8,    -1,    -1,    -1,    -1,
      13,    -1,    -1,   391,    17,    18,    19,    20,    -1,    22,
      -1,    -1,    -1,    -1,    27,    -1,    29,    30,    31,    32,
      -1,    34,    -1,    36,    -1,    -1,    39,    -1,    -1,    42,
      -1,    -1,    45,    -1,    47,    48,    -1,    50,    51,    -1,
      53,    54,    55,    56,    57,    58,    -1,    60,    61,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,
      -1,    74,    75,    76,    77,    -1,    -1,    80,    -1,    -1,
      -1,    -1,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    -1,    -1,    -1,   101,   102,
     103,    -1,    -1,    -1,   107,    -1,   109,   110,    -1,   112,
     113,    -1,    -1,   116,    -1,   118,   119,    -1,   121,    -1,
      -1,    -1,   125,   126,   127,   128,    -1,   130,    -1,    -1,
      -1,   134,   135,    -1,   137,    -1,   139,    -1,    -1,    -1,
     143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
      -1,    -1,   155,   156,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,   172,
      -1,    -1,   175,    -1,    -1,    -1,   179,    -1,    -1,    -1,
      -1,   184,    -1,   186,    -1,   188,    -1,   190,    -1,    -1,
      -1,    -1,    -1,   196,   197,    -1,   199,   200,   201,   202,
      -1,    -1,   205,   206,    -1,   208,    -1,   210,    -1,   212,
     213,   214,   215,    -1,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,    -1,   228,   229,    -1,   231,   232,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     243,   244,   245,    -1,    -1,   248,    -1,   250,   251,   252,
     253,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,    -1,
      -1,   264,    -1,    -1,    -1,   268,    -1,   270,    -1,    -1,
     273,   274,   275,   276,   277,   278,   279,    -1,   281,   282,
      -1,    -1,    -1,   286,   287,   288,   289,    -1,    -1,    -1,
     293,    -1,   295,   296,   297,    -1,    -1,    -1,    -1,    -1,
     303,    -1,    -1,    -1,    -1,   308,   309,    -1,    -1,   312,
     313,    -1,    -1,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,    -1,    -1,   329,    -1,    -1,   332,
      -1,   334,   335,   336,    -1,    -1,   339,    -1,    -1,   342,
     343,   344,    -1,   346,   347,    -1,    -1,    -1,   351,    -1,
      -1,    -1,   355,    -1,    -1,    -1,    -1,    -1,   361,    -1,
      -1,   364,    -1,    -1,    -1,   368,   369,    -1,    -1,    -1,
      -1,   374,    -1,    -1,    -1,   378,     4,    -1,     6,     7,
       8,    -1,   385,    -1,    -1,    13,    -1,   390,   391,    17,
      18,    19,    20,    -1,    22,    -1,    -1,    -1,    -1,    27,
      -1,    29,    30,    31,    32,    -1,    34,    -1,    36,    -1,
      -1,    39,    -1,    -1,    42,    -1,    -1,    45,    -1,    47,
      48,    -1,    50,    51,    -1,    53,    54,    55,    56,    57,
      58,    -1,    60,    61,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    69,    -1,    -1,    -1,    -1,    74,    75,    76,    77,
      -1,    -1,    80,    -1,    -1,    -1,    -1,    85,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      -1,    -1,    -1,   101,   102,   103,    -1,    -1,    -1,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,    -1,
     118,   119,    -1,   121,    -1,    -1,    -1,   125,   126,   127,
     128,    -1,   130,    -1,    -1,    -1,   134,   135,    -1,   137,
      -1,   139,    -1,    -1,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,    -1,    -1,   155,   156,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     168,    -1,    -1,    -1,   172,    -1,    -1,   175,    -1,    -1,
      -1,   179,    -1,    -1,    -1,    -1,   184,    -1,   186,    -1,
     188,    -1,   190,    -1,    -1,    -1,    -1,    -1,   196,   197,
      -1,   199,   200,   201,   202,    -1,    -1,   205,   206,    -1,
     208,    -1,   210,    -1,   212,   213,   214,   215,    -1,    -1,
      -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,    -1,
     228,   229,    -1,   231,   232,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   243,   244,   245,    -1,    -1,
     248,    -1,   250,   251,   252,   253,    -1,    -1,   256,    -1,
      -1,    -1,   260,    -1,    -1,    -1,   264,    -1,    -1,    -1,
     268,    -1,   270,    -1,    -1,   273,   274,   275,   276,   277,
     278,   279,    -1,   281,   282,    -1,    -1,    -1,   286,   287,
     288,   289,    -1,    -1,    -1,   293,    -1,   295,   296,   297,
      -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,
     308,   309,    -1,    -1,   312,   313,    -1,    -1,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,    -1,
      -1,   329,    -1,    -1,   332,    -1,   334,   335,   336,    -1,
      -1,   339,    -1,    -1,   342,   343,   344,    -1,   346,   347,
      -1,    -1,    -1,   351,    -1,    -1,    -1,   355,    -1,    -1,
      -1,    -1,    -1,   361,    -1,    -1,   364,    -1,    -1,    -1,
     368,   369,    -1,    -1,    -1,    -1,   374,    -1,    -1,    -1,
     378,     4,    -1,     6,     7,     8,    -1,    -1,    -1,    -1,
      13,    -1,   390,   391,    17,    18,    19,    20,    -1,    22,
      -1,    -1,    -1,    -1,    27,    -1,    29,    30,    31,    32,
      -1,    34,    -1,    36,    -1,    -1,    39,    -1,    -1,    42,
      -1,    -1,    45,    -1,    47,    48,    -1,    50,    51,    -1,
      53,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,
      -1,    74,    75,    76,    77,    -1,    -1,    80,    -1,    -1,
      -1,    -1,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    -1,    -1,    -1,   101,   102,
     103,    -1,    -1,    -1,   107,    -1,   109,   110,    -1,   112,
     113,    -1,    -1,   116,    -1,   118,   119,    -1,   121,    -1,
      -1,    -1,   125,   126,   127,   128,    -1,   130,    -1,    -1,
      -1,   134,   135,    -1,   137,    -1,   139,    -1,    -1,    -1,
     143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
      -1,    -1,   155,   156,   157,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,   172,
     173,    -1,   175,    -1,    -1,    -1,   179,    -1,   181,    -1,
      -1,   184,    -1,   186,    -1,   188,    -1,   190,    -1,    -1,
      -1,    -1,    -1,   196,   197,    -1,   199,   200,   201,   202,
      -1,    -1,   205,   206,    -1,   208,    -1,   210,    -1,   212,
     213,   214,   215,    -1,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,    -1,   228,   229,    -1,   231,   232,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     243,   244,   245,    -1,    -1,   248,    -1,   250,   251,   252,
     253,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,    -1,
      -1,   264,    -1,    -1,    -1,   268,    -1,   270,    -1,    -1,
     273,   274,   275,   276,   277,   278,   279,    -1,   281,   282,
     283,    -1,    -1,   286,   287,   288,   289,    -1,    -1,    -1,
     293,    -1,   295,   296,   297,    -1,    -1,    -1,    -1,    -1,
     303,    -1,    -1,    -1,    -1,   308,   309,    -1,    -1,   312,
     313,    -1,    -1,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,    -1,    -1,   329,    -1,    -1,   332,
      -1,   334,   335,   336,    -1,    -1,   339,    -1,    -1,   342,
     343,   344,    -1,   346,   347,    -1,    -1,    -1,   351,    -1,
      -1,    -1,   355,    -1,    -1,    -1,    -1,    -1,   361,    -1,
      -1,   364,    -1,    -1,    -1,   368,   369,    -1,    -1,    -1,
       4,   374,     6,     7,     8,   378,    -1,    -1,    -1,    13,
      -1,    -1,    -1,    17,    18,    19,    20,   390,    22,    -1,
      -1,    -1,    -1,    27,    -1,    29,    30,    31,    32,    -1,
      34,    -1,    36,    -1,    -1,    39,    -1,    -1,    42,    -1,
      -1,    45,    -1,    47,    48,    -1,    50,    51,    -1,    53,
      54,    55,    56,    57,    58,    -1,    60,    61,    62,    63,
      -1,    -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,    -1,
      74,    75,    76,    77,    -1,    -1,    80,    -1,    -1,    -1,
      -1,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    -1,    -1,    -1,   101,   102,   103,
      -1,    -1,    -1,   107,    -1,   109,   110,    -1,   112,   113,
      -1,    -1,   116,    -1,   118,   119,    -1,   121,    -1,    -1,
      -1,   125,   126,   127,   128,    -1,   130,    -1,    -1,    -1,
     134,   135,    -1,   137,    -1,   139,    -1,    -1,    -1,   143,
      -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,    -1,
      -1,   155,   156,   157,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,   172,   173,
      -1,   175,    -1,    -1,    -1,   179,    -1,    -1,    -1,    -1,
     184,    -1,   186,    -1,   188,    -1,   190,    -1,    -1,    -1,
      -1,    -1,   196,   197,    -1,   199,   200,   201,   202,    -1,
      -1,   205,   206,    -1,   208,    -1,   210,    -1,   212,   213,
     214,   215,    -1,    -1,    -1,   219,   220,   221,    -1,    -1,
     224,    -1,    -1,    -1,   228,   229,    -1,   231,   232,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,
     244,   245,    -1,    -1,   248,    -1,   250,   251,   252,   253,
      -1,    -1,   256,    -1,    -1,    -1,   260,    -1,    -1,    -1,
     264,    -1,    -1,    -1,   268,    -1,   270,    -1,    -1,   273,
     274,   275,   276,   277,   278,   279,    -1,   281,   282,    -1,
      -1,    -1,   286,   287,   288,   289,    -1,    -1,    -1,   293,
      -1,   295,   296,   297,    -1,    -1,    -1,    -1,    -1,   303,
      -1,    -1,    -1,    -1,   308,   309,    -1,    -1,   312,   313,
      -1,    -1,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,    -1,    -1,   329,    -1,    -1,   332,    -1,
     334,   335,   336,    -1,    -1,   339,    -1,    -1,   342,   343,
     344,    -1,   346,   347,    -1,    -1,    -1,   351,    -1,    -1,
      -1,   355,    -1,    -1,    -1,    -1,    -1,   361,    -1,    -1,
     364,    -1,    -1,    -1,   368,   369,    -1,    -1,    -1,     4,
     374,     6,     7,     8,   378,    -1,    -1,    -1,    13,    -1,
      -1,    -1,    17,    18,    19,    20,   390,    22,    -1,    -1,
      -1,    -1,    27,    -1,    29,    30,    31,    32,    -1,    34,
      -1,    36,    -1,    -1,    39,    -1,    -1,    42,    -1,    -1,
      45,    -1,    47,    48,    -1,    50,    51,    -1,    53,    54,
      55,    56,    57,    58,    -1,    60,    61,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,    -1,    74,
      75,    76,    77,    -1,    -1,    80,    -1,    -1,    -1,    -1,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    -1,    -1,    -1,   101,   102,   103,    -1,
      -1,    -1,   107,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,    -1,   118,   119,    -1,   121,    -1,    -1,    -1,
     125,   126,   127,   128,    -1,   130,    -1,    -1,    -1,   134,
     135,    -1,   137,    -1,   139,    -1,    -1,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,    -1,    -1,
     155,   156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   168,    -1,    -1,    -1,   172,    -1,    -1,
     175,    -1,    -1,    -1,   179,    -1,    -1,    -1,    -1,   184,
      -1,   186,    -1,   188,    -1,   190,    -1,    -1,    -1,    -1,
      -1,   196,   197,    -1,   199,   200,   201,   202,    -1,    -1,
     205,   206,    -1,   208,    -1,   210,    -1,   212,   213,   214,
     215,    -1,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,    -1,   228,   229,    -1,   231,   232,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,   244,
     245,    -1,    -1,   248,    -1,   250,   251,   252,   253,    -1,
      -1,   256,    -1,    -1,    -1,   260,    -1,    -1,    -1,   264,
      -1,    -1,    -1,   268,    -1,   270,    -1,    -1,   273,   274,
     275,   276,   277,   278,   279,    -1,   281,   282,   283,    -1,
      -1,   286,   287,   288,   289,    -1,    -1,    -1,   293,    -1,
     295,   296,   297,    -1,    -1,    -1,    -1,    -1,   303,    -1,
      -1,    -1,    -1,   308,   309,    -1,    -1,   312,   313,    -1,
      -1,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,    -1,    -1,   329,    -1,    -1,   332,    -1,   334,
     335,   336,    -1,    -1,   339,    -1,    -1,   342,   343,   344,
      -1,   346,   347,    -1,    -1,    -1,   351,    -1,    -1,    -1,
     355,    -1,    -1,    -1,    -1,    -1,   361,    -1,    -1,   364,
      -1,    -1,    -1,   368,   369,    -1,    -1,    -1,     4,   374,
       6,     7,     8,   378,    -1,    -1,    -1,    13,    -1,    -1,
     385,    17,    18,    19,    20,   390,    22,    -1,    -1,    -1,
      -1,    27,    -1,    29,    30,    31,    32,    -1,    34,    -1,
      36,    -1,    -1,    39,    -1,    -1,    42,    -1,    -1,    45,
      -1,    47,    48,    -1,    50,    51,    -1,    53,    54,    55,
      56,    57,    58,    -1,    60,    61,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    69,    -1,    -1,    -1,    -1,    74,    75,
      76,    77,    -1,    -1,    80,    -1,    -1,    -1,    -1,    85,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    -1,    -1,    -1,   101,   102,   103,    -1,    -1,
      -1,   107,    -1,   109,   110,    -1,   112,   113,    -1,    -1,
     116,    -1,   118,   119,    -1,   121,    -1,    -1,    -1,   125,
     126,   127,   128,    -1,   130,    -1,    -1,    -1,   134,   135,
      -1,   137,    -1,   139,    -1,    -1,    -1,   143,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,    -1,    -1,   155,
     156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   164,    -1,
      -1,    -1,   168,    -1,    -1,    -1,   172,    -1,    -1,   175,
      -1,    -1,    -1,   179,    -1,    -1,    -1,    -1,   184,    -1,
     186,    -1,   188,    -1,   190,    -1,    -1,    -1,    -1,    -1,
     196,   197,    -1,   199,   200,   201,   202,    -1,    -1,   205,
     206,    -1,   208,    -1,   210,    -1,   212,   213,   214,   215,
      -1,    -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,
      -1,    -1,   228,   229,    -1,   231,   232,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,   244,   245,
      -1,    -1,   248,    -1,   250,   251,   252,   253,    -1,    -1,
     256,    -1,    -1,    -1,   260,    -1,    -1,    -1,   264,    -1,
      -1,    -1,   268,    -1,   270,    -1,    -1,   273,   274,   275,
     276,   277,   278,   279,    -1,   281,   282,    -1,    -1,    -1,
     286,   287,   288,   289,    -1,    -1,    -1,   293,    -1,   295,
     296,   297,    -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,
      -1,    -1,   308,   309,    -1,    -1,   312,   313,    -1,    -1,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,    -1,    -1,   329,    -1,    -1,   332,    -1,   334,   335,
     336,    -1,    -1,   339,    -1,    -1,   342,   343,   344,    -1,
     346,   347,    -1,    -1,    -1,   351,    -1,    -1,    -1,   355,
      -1,    -1,    -1,    -1,    -1,   361,    -1,    -1,   364,    -1,
      -1,    -1,   368,   369,    -1,    -1,    -1,     4,   374,     6,
       7,     8,   378,    -1,    -1,    -1,    13,    -1,    -1,    -1,
      17,    18,    19,    20,   390,    22,    -1,    -1,    -1,    -1,
      27,    -1,    29,    30,    31,    32,    -1,    34,    -1,    36,
      -1,    -1,    39,    -1,    -1,    42,    -1,    -1,    45,    -1,
      47,    48,    -1,    50,    51,    -1,    53,    54,    55,    56,
      57,    58,    -1,    60,    61,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    69,    -1,    -1,    -1,    -1,    74,    75,    76,
      77,    -1,    -1,    80,    -1,    -1,    -1,    -1,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    -1,    -1,    -1,   101,   102,   103,    -1,    -1,    -1,
     107,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
      -1,   118,   119,    -1,   121,    -1,    -1,    -1,   125,   126,
     127,   128,    -1,   130,    -1,    -1,    -1,   134,   135,    -1,
     137,    -1,   139,    -1,    -1,    -1,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,    -1,    -1,   155,   156,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   168,    -1,    -1,    -1,   172,    -1,    -1,   175,    -1,
      -1,    -1,   179,    -1,    -1,    -1,    -1,   184,    -1,   186,
      -1,   188,    -1,   190,    -1,    -1,    -1,    -1,    -1,   196,
     197,    -1,   199,   200,   201,   202,    -1,    -1,   205,   206,
      -1,   208,    -1,   210,    -1,   212,   213,   214,   215,    -1,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
      -1,   228,   229,    -1,   231,   232,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,   244,   245,    -1,
      -1,   248,    -1,   250,   251,   252,   253,    -1,    -1,   256,
      -1,    -1,    -1,   260,    -1,    -1,    -1,   264,    -1,    -1,
      -1,   268,    -1,   270,    -1,    -1,   273,   274,   275,   276,
     277,   278,   279,    -1,   281,   282,    -1,    -1,    -1,   286,
     287,   288,   289,    -1,    -1,    -1,   293,    -1,   295,   296,
     297,    -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,
      -1,   308,   309,    -1,    -1,   312,   313,    -1,    -1,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
      -1,    -1,   329,    -1,    -1,   332,    -1,   334,   335,   336,
      -1,    -1,   339,    -1,    -1,   342,   343,   344,    -1,   346,
     347,    -1,    -1,    -1,   351,    -1,    -1,    -1,   355,    -1,
      -1,    -1,    -1,    -1,   361,    -1,    -1,   364,    -1,    -1,
      -1,   368,   369,    -1,    -1,    -1,     4,   374,     6,     7,
       8,   378,    -1,    -1,    -1,    13,    -1,   384,    -1,    17,
      18,    19,    20,   390,    22,    -1,    -1,    -1,    -1,    27,
      -1,    29,    30,    31,    32,    -1,    34,    -1,    36,    -1,
      -1,    39,    -1,    -1,    42,    -1,    -1,    45,    -1,    47,
      48,    -1,    50,    51,    -1,    53,    54,    55,    56,    57,
      58,    -1,    60,    61,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    69,    -1,    -1,    -1,    -1,    74,    75,    76,    77,
      -1,    -1,    80,    -1,    -1,    -1,    -1,    85,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      -1,    -1,    -1,   101,   102,   103,    -1,    -1,    -1,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,    -1,
     118,   119,    -1,   121,    -1,    -1,    -1,   125,   126,   127,
     128,    -1,   130,    -1,    -1,    -1,   134,   135,    -1,   137,
      -1,   139,    -1,    -1,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,    -1,    -1,   155,   156,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     168,    -1,    -1,    -1,   172,    -1,    -1,   175,    -1,    -1,
      -1,   179,    -1,    -1,    -1,    -1,   184,    -1,   186,    -1,
     188,    -1,   190,    -1,    -1,    -1,    -1,    -1,   196,   197,
      -1,   199,   200,   201,   202,    -1,    -1,   205,   206,    -1,
     208,    -1,   210,    -1,   212,   213,   214,   215,    -1,    -1,
      -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,    -1,
     228,   229,    -1,   231,   232,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   243,   244,   245,    -1,    -1,
     248,    -1,   250,   251,   252,   253,    -1,    -1,   256,    -1,
      -1,    -1,   260,    -1,    -1,    -1,   264,    -1,    -1,    -1,
     268,    -1,   270,    -1,    -1,   273,   274,   275,   276,   277,
     278,   279,    -1,   281,   282,    -1,    -1,    -1,   286,   287,
     288,   289,    -1,    -1,    -1,   293,    -1,   295,   296,   297,
      -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,
     308,   309,    -1,    -1,   312,   313,    -1,    -1,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,    -1,
      -1,   329,    -1,    -1,   332,    -1,   334,   335,   336,    -1,
      -1,   339,    -1,    -1,   342,   343,   344,    -1,   346,   347,
      -1,    -1,    -1,   351,    -1,    -1,    -1,   355,    -1,    -1,
      -1,    -1,    -1,   361,    -1,    -1,   364,    -1,    -1,    -1,
     368,   369,    -1,    -1,    -1,     4,   374,     6,     7,     8,
     378,    -1,    -1,    -1,    13,    -1,    -1,    -1,    17,    18,
      19,    20,   390,    22,    -1,    -1,    -1,    -1,    27,    -1,
      29,    30,    31,    32,    -1,    34,    -1,    36,    -1,    -1,
      39,    -1,    -1,    42,    -1,    -1,    45,    -1,    47,    48,
      -1,    50,    51,    -1,    53,    54,    55,    56,    57,    58,
      -1,    60,    61,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      69,    -1,    -1,    -1,    -1,    74,    75,    76,    77,    -1,
      -1,    80,    -1,    -1,    -1,    -1,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    -1,
      -1,    -1,   101,   102,   103,    -1,    -1,    -1,   107,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,    -1,   118,
     119,    -1,   121,    -1,    -1,    -1,   125,   126,   127,   128,
      -1,   130,    -1,    -1,    -1,   134,   135,    -1,   137,    -1,
     139,    -1,    -1,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,    -1,    -1,   155,   156,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   168,
      -1,    -1,    -1,   172,    -1,    -1,   175,    -1,    -1,    -1,
     179,    -1,    -1,    -1,    -1,   184,    -1,   186,    -1,   188,
      -1,   190,    -1,    -1,    -1,    -1,    -1,   196,   197,    -1,
     199,   200,   201,   202,    -1,    -1,   205,   206,    -1,   208,
      -1,   210,    -1,   212,   213,   214,   215,    -1,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,    -1,   228,
     229,    -1,   231,   232,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   243,   244,   245,    -1,    -1,   248,
      -1,   250,   251,   252,   253,    -1,    -1,   256,    -1,    -1,
      -1,   260,    -1,    -1,    -1,   264,    -1,    -1,    -1,   268,
      -1,   270,    -1,    -1,   273,   274,   275,   276,   277,   278,
     279,    -1,   281,   282,    -1,    -1,    -1,   286,   287,   288,
     289,    -1,    -1,    -1,   293,    -1,   295,   296,   297,    -1,
      -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,   308,
     309,    -1,    -1,   312,   313,    -1,    -1,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,    -1,    -1,
     329,    -1,    -1,   332,    -1,   334,   335,   336,    -1,    -1,
     339,    -1,    -1,   342,   343,   344,    -1,   346,   347,    -1,
      -1,    -1,   351,    -1,    -1,    -1,   355,    -1,    -1,    -1,
      -1,    -1,   361,    -1,    -1,   364,    -1,    -1,    -1,   368,
     369,    -1,    -1,    -1,     4,   374,     6,     7,     8,   378,
      -1,    -1,    -1,    13,    -1,    -1,    -1,    17,    18,    19,
      20,   390,    22,    -1,    -1,    -1,    -1,    27,    -1,    29,
      30,    31,    32,    -1,    34,    -1,    36,    -1,    -1,    39,
      -1,    -1,    42,    -1,    -1,    45,    -1,    47,    48,    -1,
      50,    51,    -1,    53,    54,    55,    56,    57,    58,    -1,
      60,    61,    -1,    63,    -1,    -1,    -1,    -1,    -1,    69,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    -1,    -1,
      80,    -1,    -1,    -1,    -1,    85,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    -1,    -1,
      -1,   101,   102,   103,    -1,    -1,    -1,   107,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,    -1,   118,   119,
      -1,   121,    -1,    -1,    -1,   125,   126,   127,   128,    -1,
     130,    -1,    -1,    -1,   134,   135,    -1,   137,    -1,   139,
      -1,    -1,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,    -1,    -1,   155,   156,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   168,    -1,
      -1,    -1,   172,    -1,    -1,   175,    -1,    -1,    -1,   179,
      -1,    -1,    -1,    -1,   184,    -1,   186,    -1,   188,    -1,
     190,    -1,    -1,    -1,    -1,    -1,   196,   197,    -1,   199,
     200,   201,   202,    -1,    -1,   205,   206,    -1,   208,    -1,
     210,    -1,   212,   213,   214,   215,    -1,    -1,    -1,   219,
     220,   221,    -1,    -1,   224,    -1,    -1,    -1,   228,   229,
      -1,   231,   232,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,   244,   245,    -1,    -1,   248,    -1,
     250,   251,   252,   253,    -1,    -1,   256,    -1,    -1,    -1,
     260,    -1,    -1,    -1,   264,    -1,    -1,    -1,   268,    -1,
     270,    -1,    -1,   273,   274,   275,   276,   277,   278,   279,
      -1,   281,   282,    -1,    -1,    -1,   286,   287,   288,   289,
      -1,    -1,    -1,   293,    -1,   295,   296,   297,    -1,    -1,
      -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,   308,   309,
      -1,    -1,   312,   313,    -1,    -1,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,    -1,    -1,   329,
      -1,    -1,   332,    -1,   334,   335,   336,    -1,    -1,   339,
      -1,    -1,   342,   343,   344,    -1,   346,   347,    -1,    -1,
      -1,   351,    -1,    -1,    -1,   355,    -1,    -1,    -1,    -1,
      -1,   361,    -1,    -1,   364,    -1,    -1,    -1,   368,   369,
      -1,    -1,    -1,     4,   374,     6,     7,     8,   378,    -1,
      -1,    -1,    13,    -1,    -1,    -1,    17,    18,    19,    20,
     390,    22,    -1,    -1,    -1,    -1,    27,    -1,    29,    30,
      31,    32,    -1,    34,    -1,    36,    -1,    -1,    39,    -1,
      -1,    42,    -1,    -1,    45,    -1,    47,    48,    -1,    50,
      51,    -1,    53,    54,    55,    56,    57,    58,    -1,    60,
      61,    -1,    63,    -1,    -1,    -1,    -1,    -1,    69,    -1,
      -1,    -1,    -1,    74,    75,    76,    77,    -1,    -1,    80,
      -1,    -1,    -1,    -1,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    -1,    -1,    -1,
     101,   102,   103,    -1,    -1,    -1,   107,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,    -1,   118,   119,    -1,
     121,    -1,    -1,    -1,   125,   126,   127,   128,    -1,   130,
      -1,    -1,    -1,   134,   135,    -1,   137,    -1,   139,    -1,
      -1,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,    -1,    -1,   155,   156,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,
      -1,   172,    -1,    -1,   175,    -1,    -1,    -1,   179,    -1,
      -1,    -1,    -1,   184,    -1,   186,    -1,   188,    -1,   190,
      -1,    -1,    -1,    -1,    -1,   196,   197,    -1,   199,   200,
     201,   202,    -1,    -1,   205,   206,    -1,   208,    -1,   210,
      -1,   212,   213,   214,   215,    -1,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,    -1,   228,   229,    -1,
     231,   232,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,   244,   245,    -1,    -1,   248,    -1,   250,
     251,   252,   253,    -1,    -1,   256,    -1,    -1,    -1,   260,
      -1,    -1,    -1,   264,    -1,    -1,    -1,   268,    -1,   270,
      -1,    -1,   273,   274,   275,   276,   277,   278,   279,    -1,
     281,   282,    -1,    -1,    -1,   286,   287,   288,   289,    -1,
      -1,    -1,   293,    -1,   295,   296,   297,    -1,    -1,    -1,
      -1,    -1,   303,    -1,    -1,    -1,    -1,   308,   309,    -1,
      -1,   312,   313,    -1,    -1,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,    -1,    -1,   329,    -1,
      -1,   332,    -1,   334,   335,   336,    -1,    -1,   339,    -1,
      -1,   342,   343,   344,    -1,   346,   347,    -1,    -1,    -1,
     351,    -1,    -1,    -1,   355,    -1,    -1,    -1,    -1,    -1,
     361,    -1,    -1,   364,    -1,    -1,    -1,   368,   369,    -1,
      -1,    -1,     4,   374,     6,     7,     8,   378,    -1,    -1,
      -1,    13,    -1,    -1,    -1,    17,    18,    19,    20,   390,
      22,    -1,    -1,    -1,    -1,    27,    -1,    29,    30,    31,
      32,    -1,    34,    -1,    36,    -1,    -1,    39,    -1,    -1,
      42,    -1,    -1,    45,    -1,    47,    48,    -1,    50,    51,
      -1,    53,    54,    55,    56,    57,    58,    -1,    60,    61,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    69,    -1,    -1,
      -1,    -1,    74,    75,    76,    77,    -1,    -1,    80,    -1,
      -1,    -1,    -1,    85,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    -1,    -1,    -1,   101,
     102,   103,    -1,    -1,    -1,   107,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,    -1,   118,   119,    -1,   121,
      -1,    -1,    -1,   125,   126,   127,   128,    -1,   130,    -1,
      -1,    -1,   134,   135,    -1,   137,    -1,   139,    -1,    -1,
      -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,    -1,    -1,   155,   156,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,
     172,    -1,    -1,   175,    -1,    -1,    -1,   179,    -1,    -1,
      -1,    -1,   184,    -1,   186,    -1,   188,    -1,   190,    -1,
      -1,    -1,    -1,    -1,   196,   197,    -1,   199,   200,   201,
     202,    -1,    -1,   205,   206,    -1,   208,    -1,   210,    -1,
     212,   213,   214,   215,    -1,    -1,    -1,   219,   220,   221,
      -1,    -1,   224,    -1,    -1,    -1,   228,   229,    -1,   231,
     232,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,   244,   245,    -1,    -1,   248,    -1,   250,   251,
     252,   253,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,
      -1,    -1,   264,    -1,    -1,    -1,   268,    -1,   270,    -1,
      -1,   273,   274,   275,   276,   277,   278,   279,    -1,   281,
     282,    -1,    -1,    -1,   286,   287,   288,   289,    -1,    -1,
      -1,   293,    -1,   295,   296,   297,    -1,    -1,    -1,    -1,
      -1,   303,    -1,    -1,    -1,    -1,   308,   309,    -1,    -1,
     312,   313,    -1,    -1,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,    -1,    -1,   329,    -1,    -1,
     332,    -1,   334,   335,   336,    -1,    -1,   339,    -1,    -1,
     342,   343,   344,    -1,   346,   347,    -1,    -1,    -1,   351,
      -1,    -1,    -1,   355,    -1,    -1,    -1,    -1,    -1,   361,
      -1,    -1,   364,    -1,    -1,    -1,   368,   369,    -1,    -1,
      -1,     4,   374,     6,     7,     8,   378,    -1,    -1,   381,
      13,    -1,    -1,    -1,    17,    18,    19,    20,    -1,    22,
      -1,    -1,    -1,    -1,    27,    -1,    29,    30,    31,    32,
      -1,    34,    -1,    36,    -1,    -1,    39,    -1,    -1,    42,
      -1,    -1,    45,    -1,    47,    48,    -1,    50,    51,    -1,
      53,    54,    55,    56,    57,    58,    -1,    60,    61,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,
      -1,    74,    75,    76,    77,    -1,    -1,    80,    -1,    -1,
      -1,    -1,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    -1,    -1,    -1,   101,   102,
     103,    -1,    -1,    -1,   107,    -1,   109,   110,    -1,   112,
     113,    -1,    -1,   116,    -1,   118,   119,    -1,   121,    -1,
      -1,    -1,   125,   126,   127,   128,    -1,   130,    -1,    -1,
      -1,   134,   135,    -1,   137,    -1,   139,    -1,    -1,    -1,
     143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
      -1,    -1,   155,   156,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,   172,
      -1,    -1,   175,    -1,    -1,    -1,   179,    -1,    -1,    -1,
      -1,   184,    -1,   186,    -1,   188,    -1,   190,    -1,    -1,
      -1,    -1,    -1,   196,   197,    -1,   199,   200,   201,   202,
      -1,    -1,   205,   206,    -1,   208,    -1,   210,    -1,   212,
     213,   214,   215,    -1,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,    -1,   228,   229,    -1,   231,   232,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     243,   244,   245,    -1,    -1,   248,    -1,   250,   251,   252,
     253,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,    -1,
      -1,   264,    -1,    -1,    -1,   268,    -1,   270,    -1,    -1,
     273,   274,   275,   276,   277,   278,   279,    -1,   281,   282,
      -1,    -1,    -1,   286,   287,   288,   289,    -1,    -1,    -1,
     293,    -1,   295,   296,   297,    -1,    -1,    -1,    -1,    -1,
     303,    -1,    -1,    -1,    -1,   308,   309,    -1,    -1,   312,
     313,    -1,    -1,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,    -1,    -1,   329,    -1,    -1,   332,
      -1,   334,   335,   336,    -1,    -1,   339,    -1,    -1,   342,
     343,   344,    -1,   346,   347,    -1,    -1,    -1,   351,    -1,
      -1,    -1,   355,    -1,    -1,    -1,    -1,    -1,   361,    -1,
      -1,   364,    -1,    -1,    -1,   368,   369,    -1,    -1,    -1,
       4,   374,     6,     7,     8,   378,    -1,    -1,   381,    13,
      -1,    -1,    -1,    17,    18,    19,    20,    -1,    22,    -1,
      -1,    -1,    26,    27,    -1,    29,    30,    31,    32,    -1,
      34,    -1,    36,    -1,    -1,    39,    -1,    -1,    42,    -1,
      -1,    45,    -1,    47,    48,    -1,    50,    51,    -1,    53,
      54,    55,    56,    57,    58,    -1,    60,    61,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,    -1,
      74,    75,    76,    77,    -1,    -1,    80,    -1,    -1,    -1,
      -1,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    -1,    -1,    -1,   101,   102,   103,
      -1,    -1,    -1,   107,    -1,   109,   110,    -1,   112,   113,
      -1,    -1,   116,    -1,   118,   119,    -1,   121,    -1,    -1,
      -1,   125,   126,   127,   128,    -1,   130,    -1,    -1,    -1,
     134,   135,    -1,   137,    -1,   139,    -1,    -1,    -1,   143,
      -1,   145,    -1,    -1,    -1,   149,   150,   151,   152,    -1,
      -1,   155,   156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,   172,    -1,
      -1,   175,    -1,    -1,    -1,   179,    -1,    -1,    -1,    -1,
     184,    -1,   186,    -1,   188,    -1,   190,    -1,    -1,    -1,
      -1,    -1,   196,   197,    -1,   199,   200,   201,   202,    -1,
      -1,   205,   206,    -1,   208,    -1,   210,    -1,   212,   213,
     214,   215,    -1,    -1,    -1,   219,   220,   221,    -1,    -1,
     224,    -1,    -1,    -1,   228,   229,    -1,   231,   232,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,
     244,   245,    -1,    -1,   248,    -1,   250,   251,   252,   253,
      -1,    -1,   256,    -1,    -1,    -1,   260,    -1,    -1,    -1,
     264,    -1,    -1,    -1,   268,    -1,   270,    -1,    -1,   273,
     274,   275,   276,   277,   278,   279,    -1,   281,   282,    -1,
      -1,    -1,   286,   287,   288,   289,    -1,    -1,    -1,   293,
      -1,   295,   296,   297,    -1,    -1,    -1,    -1,    -1,   303,
      -1,    -1,    -1,    -1,   308,   309,    -1,    -1,   312,   313,
      -1,    -1,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,    -1,    -1,   329,    -1,   331,   332,    -1,
     334,   335,   336,    -1,    -1,   339,    -1,    -1,   342,   343,
     344,    -1,   346,   347,    -1,    -1,    -1,   351,    -1,    -1,
      -1,   355,    -1,    -1,    -1,    -1,    -1,   361,    -1,    -1,
     364,    -1,    -1,    -1,   368,   369,    -1,    -1,    -1,     4,
     374,     6,     7,     8,   378,    -1,    -1,    -1,    13,    -1,
      -1,    -1,    17,    18,    19,    20,    -1,    22,    -1,    -1,
      -1,    -1,    27,    -1,    29,    30,    31,    32,    -1,    34,
      -1,    36,    -1,    -1,    39,    -1,    -1,    42,    -1,    -1,
      45,    -1,    47,    48,    -1,    50,    51,    -1,    53,    54,
      55,    56,    57,    58,    -1,    60,    61,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,    -1,    74,
      75,    76,    77,    -1,    -1,    80,    -1,    -1,    -1,    -1,
      85,    86,    -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,
      95,    96,    -1,    -1,    -1,    -1,   101,   102,   103,    -1,
      -1,    -1,   107,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,    -1,   118,   119,    -1,   121,    -1,    -1,    -1,
     125,   126,   127,   128,    -1,   130,    -1,    -1,    -1,   134,
     135,    -1,   137,    -1,   139,    -1,    -1,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,    -1,    -1,
     155,   156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   168,    -1,    -1,    -1,   172,    -1,    -1,
     175,    -1,    -1,    -1,   179,   180,    -1,    -1,    -1,   184,
      -1,   186,    -1,   188,    -1,   190,    -1,    -1,    -1,    -1,
      -1,   196,   197,    -1,   199,   200,   201,   202,    -1,    -1,
     205,   206,    -1,   208,    -1,   210,    -1,   212,   213,   214,
     215,    -1,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,    -1,   228,   229,    -1,   231,   232,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,   244,
     245,    -1,    -1,   248,    -1,   250,   251,   252,   253,    -1,
      -1,   256,    -1,    -1,    -1,   260,    -1,    -1,    -1,   264,
      -1,    -1,    -1,   268,    -1,   270,    -1,    -1,   273,   274,
     275,   276,   277,   278,   279,    -1,   281,   282,    -1,    -1,
      -1,   286,   287,   288,   289,    -1,    -1,    -1,   293,    -1,
     295,   296,   297,    -1,    -1,    -1,    -1,    -1,   303,    -1,
      -1,    -1,    -1,   308,   309,    -1,    -1,   312,   313,    -1,
      -1,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,    -1,    -1,   329,    -1,   331,   332,    -1,   334,
     335,   336,    -1,    -1,   339,    -1,    -1,   342,   343,   344,
      -1,   346,   347,    -1,    -1,    -1,   351,    -1,    -1,    -1,
     355,    -1,    -1,    -1,    -1,    -1,   361,    -1,    -1,   364,
      -1,    -1,    -1,   368,   369,    -1,    -1,    -1,     4,   374,
       6,     7,     8,   378,    -1,    -1,    -1,    13,    -1,    -1,
      -1,    17,    18,    19,    20,    -1,    22,    -1,    -1,    -1,
      -1,    27,    -1,    29,    30,    31,    32,    -1,    34,    -1,
      36,    -1,    -1,    39,    -1,    -1,    42,    -1,    -1,    45,
      -1,    47,    48,    -1,    50,    51,    -1,    53,    54,    55,
      56,    57,    58,    -1,    60,    61,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    69,    -1,    -1,    -1,    -1,    74,    75,
      76,    77,    -1,    -1,    80,    -1,    -1,    -1,    -1,    85,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    -1,    -1,    -1,   101,   102,   103,    -1,    -1,
      -1,   107,    -1,   109,   110,    -1,   112,   113,    -1,    -1,
     116,    -1,   118,   119,    -1,   121,    -1,    -1,    -1,   125,
     126,   127,   128,    -1,   130,    -1,    -1,    -1,   134,   135,
      -1,   137,    -1,   139,    -1,    -1,    -1,   143,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,    -1,    -1,   155,
     156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   168,    -1,    -1,    -1,   172,    -1,    -1,   175,
      -1,    -1,    -1,   179,   180,    -1,    -1,    -1,   184,    -1,
     186,    -1,   188,    -1,   190,    -1,    -1,    -1,    -1,    -1,
     196,   197,    -1,   199,   200,   201,   202,    -1,    -1,   205,
     206,    -1,   208,    -1,   210,    -1,   212,   213,   214,   215,
      -1,    -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,
      -1,    -1,   228,   229,    -1,   231,   232,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,   244,   245,
      -1,    -1,   248,    -1,   250,   251,   252,   253,    -1,    -1,
     256,    -1,    -1,    -1,   260,    -1,    -1,    -1,   264,    -1,
      -1,    -1,   268,    -1,   270,    -1,    -1,   273,   274,   275,
     276,   277,   278,   279,    -1,   281,   282,    -1,    -1,    -1,
     286,   287,   288,   289,    -1,    -1,    -1,   293,    -1,   295,
     296,   297,    -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,
      -1,    -1,   308,   309,    -1,    -1,   312,   313,    -1,    -1,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,    -1,    -1,   329,    -1,   331,   332,    -1,   334,   335,
     336,    -1,    -1,   339,    -1,    -1,   342,   343,   344,    -1,
     346,   347,    -1,    -1,    -1,   351,    -1,    -1,    -1,   355,
      -1,    -1,    -1,    -1,    -1,   361,    -1,    -1,   364,    -1,
      -1,    -1,   368,   369,    -1,    -1,    -1,     4,   374,     6,
       7,     8,   378,    -1,    -1,    -1,    13,    14,    -1,    -1,
      17,    18,    19,    20,    -1,    22,    -1,    -1,    -1,    -1,
      27,    -1,    29,    30,    31,    32,    -1,    34,    -1,    36,
      -1,    -1,    39,    -1,    -1,    42,    -1,    -1,    45,    -1,
      47,    48,    -1,    50,    51,    -1,    53,    54,    55,    56,
      57,    58,    -1,    60,    61,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    69,    -1,    -1,    -1,    -1,    74,    75,    76,
      77,    -1,    -1,    80,    -1,    -1,    -1,    -1,    85,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    -1,    -1,    -1,   101,   102,   103,    -1,    -1,    -1,
     107,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
      -1,   118,   119,    -1,   121,    -1,    -1,    -1,   125,   126,
     127,   128,    -1,   130,    -1,    -1,    -1,   134,   135,    -1,
     137,    -1,   139,    -1,    -1,    -1,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,    -1,    -1,   155,   156,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   168,    -1,    -1,    -1,   172,    -1,    -1,   175,    -1,
      -1,    -1,   179,    -1,    -1,    -1,    -1,   184,    -1,   186,
      -1,   188,    -1,   190,    -1,    -1,    -1,    -1,    -1,   196,
     197,    -1,   199,   200,   201,   202,    -1,    -1,   205,   206,
      -1,   208,    -1,   210,    -1,   212,   213,   214,   215,    -1,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
      -1,   228,   229,    -1,   231,   232,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,   244,   245,    -1,
      -1,   248,    -1,   250,   251,   252,   253,    -1,    -1,   256,
      -1,    -1,    -1,   260,    -1,    -1,    -1,   264,    -1,    -1,
      -1,   268,    -1,   270,    -1,    -1,   273,   274,   275,   276,
     277,   278,   279,    -1,   281,   282,    -1,    -1,    -1,   286,
     287,   288,   289,    -1,    -1,    -1,   293,    -1,   295,   296,
     297,    -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,
      -1,   308,   309,    -1,    -1,   312,   313,    -1,    -1,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
      -1,    -1,   329,    -1,   331,   332,    -1,   334,   335,   336,
      -1,    -1,   339,    -1,    -1,   342,   343,   344,    -1,   346,
     347,    -1,    -1,    -1,   351,    -1,    -1,    -1,   355,    -1,
      -1,    -1,    -1,    -1,   361,    -1,    -1,   364,    -1,    -1,
      -1,   368,   369,    -1,    -1,    -1,     4,   374,     6,     7,
       8,   378,    -1,    -1,    -1,    13,    -1,    -1,    -1,    17,
      18,    19,    20,    -1,    22,    -1,    -1,    -1,    -1,    27,
      -1,    29,    30,    31,    32,    -1,    34,    -1,    36,    -1,
      -1,    39,    -1,    -1,    42,    -1,    -1,    45,    -1,    47,
      48,    -1,    50,    51,    -1,    53,    54,    55,    56,    57,
      58,    -1,    60,    61,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    69,    -1,    -1,    -1,    -1,    74,    75,    76,    77,
      -1,    -1,    80,    -1,    -1,    -1,    -1,    85,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      -1,    -1,    -1,   101,   102,   103,    -1,    -1,    -1,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,    -1,
     118,   119,    -1,   121,    -1,    -1,    -1,   125,   126,   127,
     128,    -1,   130,    -1,    -1,    -1,   134,   135,    -1,   137,
      -1,   139,    -1,    -1,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,    -1,    -1,   155,   156,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     168,    -1,    -1,    -1,   172,    -1,    -1,   175,    -1,    -1,
      -1,   179,    -1,    -1,    -1,    -1,   184,    -1,   186,    -1,
     188,    -1,   190,    -1,    -1,    -1,    -1,    -1,   196,   197,
      -1,   199,   200,   201,   202,    -1,    -1,   205,   206,    -1,
     208,    -1,   210,    -1,   212,   213,   214,   215,    -1,    -1,
      -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,    -1,
     228,   229,    -1,   231,   232,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   243,   244,   245,    -1,    -1,
     248,    -1,   250,   251,   252,   253,    -1,    -1,   256,    -1,
      -1,    -1,   260,    -1,    -1,    -1,   264,    -1,    -1,    -1,
     268,    -1,   270,    -1,    -1,   273,   274,   275,   276,   277,
     278,   279,    -1,   281,   282,    -1,    -1,    -1,   286,   287,
     288,   289,    -1,    -1,    -1,   293,    -1,   295,   296,   297,
      -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,
     308,   309,    -1,    -1,   312,   313,    -1,    -1,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,    -1,
      -1,   329,    -1,   331,   332,    -1,   334,   335,   336,    -1,
      -1,   339,    -1,    -1,   342,   343,   344,    -1,   346,   347,
      -1,    -1,    -1,   351,    -1,    -1,    -1,   355,    -1,    -1,
      -1,    -1,    -1,   361,    -1,    -1,   364,    -1,    -1,    -1,
     368,   369,    -1,    -1,    -1,     4,   374,     6,     7,     8,
     378,    -1,    -1,    -1,    13,    -1,    -1,    -1,    17,    18,
      19,    20,    -1,    22,    -1,    -1,    -1,    -1,    27,    -1,
      29,    30,    31,    32,    -1,    34,    -1,    36,    -1,    -1,
      39,    -1,    -1,    42,    -1,    -1,    45,    -1,    47,    48,
      -1,    50,    51,    -1,    53,    54,    55,    56,    57,    58,
      -1,    60,    61,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      69,    -1,    -1,    -1,    -1,    74,    75,    76,    77,    -1,
      -1,    80,    -1,    -1,    -1,    -1,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    -1,
      -1,    -1,   101,   102,   103,    -1,    -1,    -1,   107,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,    -1,   118,
     119,    -1,   121,    -1,    -1,    -1,   125,   126,   127,   128,
      -1,   130,    -1,    -1,    -1,   134,   135,    -1,   137,    -1,
     139,    -1,    -1,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,    -1,    -1,   155,   156,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   168,
      -1,    -1,    -1,   172,    -1,    -1,   175,    -1,    -1,    -1,
     179,    -1,    -1,    -1,    -1,   184,    -1,   186,    -1,   188,
      -1,   190,    -1,    -1,    -1,    -1,    -1,   196,   197,    -1,
     199,   200,   201,   202,    -1,    -1,   205,   206,    -1,   208,
      -1,   210,    -1,   212,   213,   214,   215,    -1,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,    -1,   228,
     229,    -1,   231,   232,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   243,   244,   245,    -1,    -1,   248,
     249,   250,   251,   252,   253,    -1,    -1,   256,    -1,    -1,
      -1,   260,    -1,    -1,    -1,   264,    -1,    -1,    -1,   268,
      -1,   270,    -1,    -1,   273,   274,   275,   276,   277,   278,
     279,    -1,   281,   282,    -1,    -1,    -1,   286,   287,   288,
     289,    -1,    -1,    -1,   293,    -1,   295,   296,   297,    -1,
      -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,   308,
     309,    -1,    -1,   312,   313,    -1,    -1,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,    -1,    -1,
     329,    -1,    -1,   332,    -1,   334,   335,   336,    -1,    -1,
     339,    -1,    -1,   342,   343,   344,    -1,   346,   347,    -1,
      -1,    -1,   351,    -1,    -1,    -1,   355,    -1,    -1,    -1,
      -1,    -1,   361,    -1,    -1,   364,    -1,    -1,    -1,   368,
     369,    -1,    -1,    -1,     4,   374,     6,     7,     8,   378,
      -1,    -1,    -1,    13,    -1,    -1,    -1,    17,    18,    19,
      20,    -1,    22,    -1,    -1,    -1,    -1,    27,    -1,    29,
      30,    31,    32,    -1,    34,    -1,    36,    -1,    -1,    39,
      -1,    -1,    42,    -1,    -1,    45,    -1,    47,    48,    -1,
      50,    51,    -1,    53,    54,    55,    56,    57,    58,    -1,
      60,    61,    -1,    63,    -1,    -1,    -1,    -1,    -1,    69,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    -1,    -1,
      80,    -1,    -1,    -1,    -1,    85,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    -1,    -1,
      -1,   101,   102,   103,    -1,    -1,    -1,   107,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,    -1,   118,   119,
      -1,   121,    -1,    -1,    -1,   125,   126,   127,   128,    -1,
     130,    -1,    -1,    -1,   134,   135,    -1,   137,    -1,   139,
      -1,    -1,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,    -1,    -1,   155,   156,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   168,    -1,
      -1,    -1,   172,    -1,    -1,   175,    -1,    -1,    -1,   179,
      -1,    -1,    -1,    -1,   184,    -1,   186,    -1,   188,    -1,
     190,    -1,    -1,    -1,    -1,    -1,   196,   197,    -1,   199,
     200,   201,   202,    -1,    -1,   205,   206,    -1,   208,    -1,
     210,    -1,   212,   213,   214,   215,    -1,    -1,    -1,   219,
     220,   221,    -1,    -1,   224,    -1,    -1,    -1,   228,   229,
      -1,   231,   232,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,   244,   245,    -1,    -1,   248,    -1,
     250,   251,   252,   253,    -1,    -1,   256,    -1,    -1,    -1,
     260,    -1,    -1,    -1,   264,    -1,    -1,    -1,   268,    -1,
     270,    -1,    -1,   273,   274,   275,   276,   277,   278,   279,
      -1,   281,   282,    -1,    -1,    -1,   286,   287,   288,   289,
      -1,    -1,    -1,   293,    -1,   295,   296,   297,    -1,    -1,
      -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,   308,   309,
      -1,    -1,   312,   313,    -1,    -1,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,    -1,    -1,   329,
      -1,    -1,   332,    -1,   334,   335,   336,    -1,    -1,   339,
      -1,    -1,   342,   343,   344,    -1,   346,   347,    -1,    -1,
      -1,   351,    -1,    -1,    -1,   355,    -1,    -1,    -1,    -1,
      -1,   361,    -1,    -1,   364,    -1,    -1,    -1,   368,   369,
      -1,    -1,    -1,     4,   374,     6,     7,     8,   378,    -1,
      -1,    -1,    13,    -1,    -1,    -1,    17,    18,    19,    20,
      -1,    22,    -1,    -1,    -1,    -1,    27,    -1,    29,    30,
      31,    32,    -1,    34,    -1,    36,    -1,    -1,    39,    -1,
      -1,    42,    -1,    -1,    45,    -1,    47,    48,    -1,    50,
      51,    -1,    53,    54,    55,    56,    57,    58,    -1,    60,
      61,    -1,    63,    -1,    -1,    -1,    -1,    -1,    69,    -1,
      -1,    -1,    -1,    74,    75,    76,    77,    -1,    -1,    80,
      -1,    -1,    -1,    -1,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    -1,    -1,    -1,
     101,   102,   103,    -1,    -1,    -1,   107,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,    -1,   118,   119,    -1,
     121,    -1,    -1,    -1,   125,   126,   127,   128,    -1,   130,
      -1,    -1,    -1,   134,   135,    -1,   137,    -1,   139,    -1,
      -1,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,    -1,    -1,   155,   156,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,
      -1,   172,    -1,    -1,   175,    -1,    -1,    -1,   179,    -1,
      -1,    -1,    -1,   184,    -1,   186,    -1,   188,    -1,   190,
      -1,    -1,    -1,    -1,    -1,   196,   197,    -1,   199,   200,
     201,   202,    -1,    -1,   205,   206,    -1,   208,    -1,   210,
      -1,   212,   213,   214,   215,    -1,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,    -1,   228,   229,    -1,
     231,   232,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,   244,   245,    -1,    -1,   248,    -1,   250,
     251,   252,   253,    -1,    -1,   256,    -1,    -1,    -1,   260,
      -1,    -1,    -1,   264,    -1,    -1,    -1,   268,    -1,   270,
      -1,    -1,   273,   274,   275,   276,   277,   278,   279,    -1,
     281,   282,    -1,    -1,    -1,   286,   287,   288,   289,    -1,
      -1,    -1,   293,    -1,   295,   296,   297,    -1,    -1,    -1,
      -1,    -1,   303,    -1,    -1,    -1,    -1,   308,   309,    -1,
      -1,   312,   313,    -1,    -1,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,    -1,    -1,   329,    -1,
      -1,   332,    -1,   334,   335,   336,    -1,    -1,   339,    -1,
      -1,   342,   343,   344,    -1,   346,   347,    -1,    -1,    -1,
     351,    -1,    -1,    -1,   355,    -1,    -1,    -1,    -1,    -1,
     361,    -1,    -1,   364,    -1,    -1,    -1,   368,   369,    -1,
      -1,    -1,    -1,   374,    -1,    -1,    -1,   378
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,    10,    11,    22,    45,    46,    55,    67,    91,    92,
      93,   100,   111,   130,   162,   174,   185,   262,   263,   266,
     273,   279,   283,   291,   294,   308,   342,   352,   353,   356,
     384,   393,   394,   395,   396,   475,   491,   493,   495,   497,
     499,   503,   504,   641,   647,   650,   673,   680,   686,   688,
     694,   697,   700,   706,   708,   709,   750,   767,   769,   775,
     776,   777,   778,    73,   228,   233,   480,   325,   328,   766,
     770,   766,   766,   374,   771,    73,   329,   411,   480,   681,
      73,   329,   480,   646,   701,   648,    60,   253,   707,    76,
     714,   279,   766,   651,   771,     4,     6,     7,     8,    13,
      17,    18,    19,    20,    22,    27,    29,    30,    31,    32,
      34,    36,    39,    42,    45,    47,    48,    50,    51,    53,
      54,    55,    56,    57,    58,    60,    61,    63,    69,    74,
      75,    76,    77,    80,    85,    86,    95,    96,   101,   102,
     103,   107,   109,   110,   112,   113,   116,   118,   119,   121,
     125,   126,   127,   128,   130,   134,   135,   137,   139,   143,
     149,   150,   151,   152,   155,   156,   168,   172,   175,   179,
     184,   186,   188,   190,   196,   197,   199,   200,   201,   202,
     205,   206,   208,   210,   212,   213,   214,   215,   219,   220,
     221,   224,   228,   229,   231,   232,   233,   234,   243,   244,
     245,   248,   250,   251,   252,   253,   256,   260,   264,   268,
     270,   273,   274,   275,   276,   277,   278,   279,   281,   282,
     286,   287,   288,   289,   293,   295,   296,   297,   303,   308,
     309,   312,   313,   316,   317,   318,   321,   322,   323,   325,
     326,   329,   332,   334,   335,   336,   339,   342,   343,   344,
     346,   347,   351,   355,   361,   364,   368,   369,   374,   378,
     742,   746,   748,   749,   507,   509,   510,   236,   752,   689,
     339,   328,   687,   768,   154,   488,   746,   283,   384,   505,
       0,   111,   121,   390,   698,   741,   746,   478,   746,   488,
     496,   771,   494,   498,    12,   772,   153,   412,   328,   398,
     154,   684,   685,   153,   645,   157,   766,   190,   309,   325,
     702,   703,   766,   488,     6,    20,    25,    26,    40,    41,
      44,    48,    50,    65,    66,    70,    71,    73,    78,    79,
      80,    85,    87,    90,   120,   122,   123,   129,   141,   145,
     149,   153,   162,   163,   178,   191,   198,   202,   205,   207,
     211,   212,   222,   223,   225,   226,   246,   252,   265,   266,
     270,   272,   278,   281,   310,   311,   317,   319,   320,   324,
     331,   334,   335,   336,   340,   341,   342,   345,   355,   358,
     359,   360,   365,   367,   378,   379,   380,   384,   388,   390,
     391,   524,   525,   526,   527,   533,   534,   535,   536,   537,
     542,   546,   729,   732,   733,   737,   739,   742,   744,   746,
     710,   746,   500,   164,   644,   653,   654,   741,   337,   772,
     508,     9,    97,   302,   303,   304,   305,   315,   514,   515,
     516,   751,    51,    66,    67,    74,   116,   139,   156,   157,
     171,   186,   251,   288,   325,   328,   368,   461,   690,   758,
     372,   492,   644,   766,   741,   509,   505,   385,   746,   696,
     695,   390,   477,   328,   643,   644,   643,   643,    42,   224,
     224,   262,   773,   222,   530,   746,   412,   350,   462,   136,
     682,   684,   120,   746,   746,   645,   372,   386,   704,   653,
     384,   384,   533,   524,   556,   384,   384,   384,   384,   384,
     384,   384,   523,   523,   384,   384,   384,   384,   729,   384,
     384,   384,   384,   384,   384,   384,   384,   384,   524,   384,
     384,   384,   384,   384,   384,   384,   524,   384,   523,   384,
     384,   384,   384,   384,   384,   384,   384,   384,   384,   384,
     384,   384,   384,   523,   384,   729,   384,   384,   384,   384,
     384,   523,   523,   384,   384,   384,   384,   533,   533,   524,
     790,   791,   746,   746,   547,    12,   239,   376,   528,   529,
     114,   115,   138,   142,   167,   176,   194,   217,   531,    23,
      98,   166,   181,   211,   379,   380,   381,   382,   383,   530,
      49,   744,   384,   390,    58,   715,   501,   502,   741,   654,
     652,   279,   774,   773,   349,   779,   780,   381,   518,   519,
     520,   516,   753,   754,   755,   136,   166,   692,   384,    73,
     328,   181,   371,   693,   182,   625,   627,   691,   692,   309,
     625,   692,   309,   364,    61,   674,   385,   780,   782,   783,
     784,   503,    26,   145,   699,   730,   744,   746,   746,    90,
     418,   449,   741,   386,    42,   262,   120,   399,   741,   157,
     741,   230,   643,   257,   703,   643,   705,   649,   524,     9,
      97,   552,   608,   370,   558,   524,   524,   555,   555,   524,
     524,    97,   552,   608,   385,   385,   524,   524,   524,   524,
     737,   790,    81,    82,    83,    84,    85,   146,   147,   148,
     149,   202,   203,   204,   205,   212,   252,   280,   281,   369,
     377,   378,   603,   605,    97,   549,   524,   524,   524,   524,
     603,   524,    97,   552,   524,   524,    97,   552,   524,   524,
     524,   527,   524,   524,   524,   524,   524,   524,   524,   552,
     552,   524,   524,    97,   552,   524,   524,   135,   604,   605,
     604,    33,   177,   338,   524,   524,   385,   738,   739,   746,
     552,   552,   524,   385,   386,   385,   283,   384,   787,   788,
     524,   390,   180,   331,   391,   548,   743,   746,   747,   524,
     524,   524,   526,   123,   225,   341,   351,   530,     9,    13,
     526,   532,   527,   527,   384,   533,   527,   163,   527,   163,
     527,   527,   527,   527,    23,   166,   181,   747,   538,   746,
     158,   386,   337,   283,   291,   360,   361,   384,   406,   655,
     658,   746,     9,    97,   786,   386,   511,   524,   735,   746,
     386,   139,   186,   231,   288,   756,   757,   760,   761,   741,
     381,   412,   741,   743,   524,   191,   226,   345,   628,   629,
     693,   746,   691,   741,   693,   693,   297,   291,   238,   621,
     627,   785,    49,   476,   644,   410,   418,   397,   746,   683,
     741,   189,   655,   386,   552,   385,   553,   524,   105,   370,
     557,    14,   385,   386,   385,   385,   386,   543,   385,   381,
     386,   386,   385,   385,   385,   385,   136,   545,   385,   386,
     386,   386,   380,   386,   552,   385,   385,   385,   552,   385,
     386,   385,   385,   166,   385,   386,   386,   385,   386,   386,
     385,   385,   385,   386,   136,   386,   552,   385,   385,   385,
     386,   386,   136,   524,   136,   524,   136,   524,   136,   385,
     386,   385,   385,   385,   385,   555,   577,   578,   579,   283,
     384,   506,   349,   792,   389,   746,   139,   186,   288,   759,
     292,   123,   225,   341,   351,   384,    12,   524,   790,   118,
     613,   524,   524,   527,   384,   533,   520,   539,   540,   541,
     390,   331,   745,   502,   741,   407,   656,   384,   661,   666,
     661,   385,   406,   657,   734,   735,   738,   746,   659,   781,
     519,   136,   164,   512,   513,   620,   621,   637,   521,   521,
     390,   754,   339,   746,   763,   391,   762,   691,   385,   746,
     229,   386,   693,   691,   676,   677,   738,    35,   625,   114,
     292,   664,   665,     5,    10,    18,    29,    43,    53,    65,
      95,    96,   100,   107,   112,   131,   155,   172,   210,   238,
     263,   277,   414,   416,   417,   449,   479,   481,   482,   483,
     617,   181,   384,   400,   413,   415,   416,   463,   464,   371,
     609,   642,   230,   671,   163,   524,   385,   524,   333,   524,
     524,   109,    25,    44,    77,    80,    88,   554,   524,   554,
     555,   385,   163,   163,   524,   555,   524,   524,   524,   524,
     524,   385,   385,   524,   524,   524,   524,   524,   555,   163,
     524,   524,   524,   385,   524,   524,   524,   136,   524,   136,
     524,   136,   524,   524,   385,   514,   578,   506,   385,   786,
     390,   390,   390,   747,   524,   790,   526,   385,   386,   385,
     533,   603,   603,    12,   524,   790,   613,   524,   385,   386,
     746,   711,   514,   662,   663,   738,   667,   386,   384,   658,
     385,   385,   386,   779,   504,   283,   384,   388,   559,   560,
     561,   562,   563,   572,   573,   587,   638,   133,   189,   517,
     637,   626,   627,   513,    14,   522,   743,   746,   381,   746,
     168,   664,   391,   747,   693,   116,   368,   629,   629,   609,
     386,   675,   664,   622,    90,   447,   448,   747,    52,    62,
     157,   173,   425,   428,   429,   457,   459,   487,   487,   665,
     665,   487,   665,   337,   171,   326,   132,   249,   459,   487,
     171,   665,   326,   665,   487,    35,    14,   114,   337,   490,
     665,   414,    49,   386,   384,   390,   424,   430,   740,   746,
     741,   181,   401,   406,   422,   423,   424,   425,   154,   266,
     403,   716,   386,   415,   344,   357,   467,   230,   610,   620,
     102,   524,   385,   524,   333,   384,   441,   441,   384,   439,
     440,   385,   385,   544,   524,   524,   385,   551,   621,   386,
     386,   385,   386,   385,   385,   385,   385,   386,   385,   385,
     524,   385,   133,   385,   385,   386,   386,   386,   385,   524,
     385,   524,   385,   524,   385,   385,   518,   385,   789,   390,
     473,   385,   555,   526,   385,   386,   385,   521,   541,   716,
     518,   386,   664,    90,   524,   668,   669,   670,   666,   660,
     658,   734,   586,   746,    68,   159,   170,   178,   216,   272,
     315,   571,   609,   386,   741,   586,   101,   241,   633,   634,
     639,   353,   166,   743,   746,   390,   179,     9,    25,    90,
     230,   524,   765,   759,   664,   677,   609,   670,   524,   623,
     736,   472,   740,    46,   132,   249,   350,   427,   458,   426,
     427,   472,   740,    87,   129,   191,   226,   345,   632,    87,
     129,   145,   191,   226,   345,   631,   740,   743,   448,   173,
     173,   740,   740,   747,   631,   740,   618,   619,   738,   741,
      56,    57,    90,   103,   128,   243,   260,   420,   665,   483,
     422,   746,     7,   127,   489,   261,   426,   451,   431,   390,
     413,   741,   385,   385,   386,    14,   409,   415,    34,   143,
     469,   469,   741,   524,   182,   630,   672,   603,   524,   226,
     226,   385,   603,   603,   285,   550,   524,   524,   555,   524,
     603,   524,   524,   524,   524,   385,   385,   385,   580,   787,
     746,   385,   555,   522,   164,   408,   663,   670,   385,   386,
     782,   574,   581,   586,   559,   170,   170,   240,   588,   170,
     178,   272,   588,   572,   559,   140,   614,   561,    14,   114,
     606,   607,   583,   584,   745,   745,   391,   635,   636,   293,
     381,   257,   264,   286,   764,   763,   524,   620,   386,    15,
      92,   624,   524,   173,   173,   459,   460,   472,   464,   100,
     291,   484,   472,   485,   386,   624,   448,   385,   746,   741,
      24,    28,    44,    77,    80,    88,    99,   113,   128,   165,
     227,   259,   287,   332,   334,   362,   363,   432,   433,   435,
     436,   437,   438,   746,   385,   402,   413,   423,   384,   406,
     384,   629,   173,   385,   385,   385,   386,   385,   385,   730,
     385,   385,   386,   385,   385,   385,   385,   385,   385,   385,
     421,   513,   626,   385,   712,   421,   670,   349,   385,   620,
     582,   389,   170,   572,   588,   588,   170,   230,   230,   357,
      35,   144,   611,   746,   597,   598,   514,   640,   747,   386,
     208,    54,   346,   257,   664,   630,   736,   472,   464,   384,
      90,    90,   430,   432,   619,   384,   452,   439,   247,   434,
     439,   439,   384,    18,    49,    53,    90,   125,   225,   230,
     249,   287,   350,   443,   444,   445,   450,   530,   366,   384,
     384,   384,   440,   442,   390,   782,   403,   406,   404,   470,
     471,   746,   353,   226,   524,   517,   517,   328,   786,   607,
     626,   562,   559,   572,   170,   170,   559,   572,   565,   564,
     566,   615,   736,   612,   620,   595,   596,   518,    51,   717,
     636,   765,   624,   384,   384,   470,    80,   334,   379,   380,
     731,   732,   489,   486,   453,   746,   195,   454,   384,   226,
     447,   743,   223,   446,   731,    90,   103,   128,   419,   353,
      90,   173,   445,   173,   225,   226,   226,   226,   746,   385,
     779,   385,   386,   624,   384,   678,   679,   738,   385,   385,
     741,   575,   230,   568,   572,   572,   230,   570,   524,   524,
     384,   373,   386,   616,   624,   524,   626,   131,   154,   356,
     590,   591,   594,   585,   108,   117,   237,   330,   718,   719,
     183,   720,   470,   470,   385,   733,   733,   489,   385,   386,
     137,   244,   296,   230,   455,   474,   730,   385,   523,   223,
     361,   385,   385,   405,    53,   172,   465,   466,   467,   468,
     471,   226,   386,   664,   713,   787,   567,   357,   569,   357,
     602,   746,   736,   459,   459,   591,   421,    35,    35,   108,
      35,   719,   307,   330,   721,   722,   385,   385,   465,   746,
      91,   353,   385,   386,   523,   782,   743,   665,   468,   624,
     385,   679,   670,   717,   576,   524,   384,   524,   384,   385,
     386,   624,   133,   589,   589,   730,   730,    35,   730,    35,
      35,   722,   451,   465,    38,   224,   267,   291,   456,   456,
     730,   631,   720,   620,   602,   602,   746,   140,   170,   238,
     593,   592,   730,   730,   730,     4,    90,   225,   230,   230,
     154,   723,   626,   385,   385,    35,    35,   384,   384,   353,
      91,   226,   384,   725,   249,   599,   600,   601,   746,   601,
     456,   456,   183,   276,   724,   385,   391,   726,   727,   738,
     291,   728,   385,   386,   385,   747,   385,   386,   678,   600,
     727
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 963 "sql_yacc.yy"
    {
            Session *session= YYSession;
            if (!(session->lex->select_lex.options & OPTION_FOUND_COMMENT))
            {
              my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
              DRIZZLE_YYABORT;
            }
            else
            {
              session->lex->sql_command= SQLCOM_EMPTY_QUERY;
              session->lex->statement=
                new(std::nothrow) statement::EmptyQuery(YYSession);
              if (session->lex->statement == NULL)
                DRIZZLE_YYABORT;
            }
          }
    break;

  case 3:
#line 979 "sql_yacc.yy"
    {}
    break;

  case 32:
#line 1021 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            lex->sql_command= SQLCOM_CREATE_TABLE;
            statement::CreateTable *statement= new(std::nothrow) statement::CreateTable(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            if (!lex->select_lex.add_table_to_list(session, (yyvsp[(5) - (5)].table), NULL,
                                                   TL_OPTION_UPDATING,
                                                   TL_WRITE))
              DRIZZLE_YYABORT;
            lex->col_list.empty();
            statement->change=NULL;
            statement->is_if_not_exists= (yyvsp[(4) - (5)].num);
            statement->create_info.db_type= NULL;
            statement->create_info.default_table_charset= NULL;
            lex->name.str= 0;

	    message::Table &proto= statement->create_table_proto;
	   
	    proto.set_name((yyvsp[(5) - (5)].table)->table.str);
	    if((yyvsp[(2) - (5)].num))
	      proto.set_type(message::Table::TEMPORARY);
	    else
	      proto.set_type(message::Table::STANDARD);
          }
    break;

  case 33:
#line 1049 "sql_yacc.yy"
    {
            LEX *lex= YYSession->lex;
            lex->current_select= &lex->select_lex;
          }
    break;

  case 34:
#line 1054 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_CREATE_INDEX;
            statement::CreateIndex *statement= new(std::nothrow) statement::CreateIndex(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->alter_info.flags.set(ALTER_ADD_INDEX);
            statement->alter_info.build_method= (yyvsp[(2) - (2)].build_method);
            lex->col_list.empty();
            statement->change=NULL;
          }
    break;

  case 35:
#line 1067 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::CreateIndex *statement= (statement::CreateIndex *)Lex->statement;

            if (!lex->current_select->add_table_to_list(lex->session, (yyvsp[(9) - (13)].table),
                                                        NULL,
                                                        TL_OPTION_UPDATING))
              DRIZZLE_YYABORT;
            Key *key;
            key= new Key((yyvsp[(4) - (13)].key_type), (yyvsp[(6) - (13)].lex_str), &statement->key_create_info, 0, lex->col_list);
            statement->alter_info.key_list.push_back(key);
            lex->col_list.empty();
          }
    break;

  case 36:
#line 1081 "sql_yacc.yy"
    {
            LEX *lex=Lex;

            lex->sql_command=SQLCOM_CREATE_DB;
            statement::CreateSchema *statement= new(std::nothrow) statement::CreateSchema(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->is_if_not_exists= (yyvsp[(3) - (4)].num);
          }
    break;

  case 37:
#line 1092 "sql_yacc.yy"
    {
            Lex->name= (yyvsp[(4) - (6)].lex_str);
          }
    break;

  case 38:
#line 1098 "sql_yacc.yy"
    {}
    break;

  case 39:
#line 1100 "sql_yacc.yy"
    {}
    break;

  case 40:
#line 1102 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;

            statement->is_create_table_like= true;
            if (!lex->select_lex.add_table_to_list(session, (yyvsp[(2) - (3)].table), NULL, 0, TL_READ))
              DRIZZLE_YYABORT;
          }
    break;

  case 41:
#line 1112 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;

            statement->is_create_table_like= true;
            if (!lex->select_lex.add_table_to_list(session, (yyvsp[(3) - (4)].table), NULL, 0, TL_READ))
              DRIZZLE_YYABORT;
          }
    break;

  case 42:
#line 1125 "sql_yacc.yy"
    {}
    break;

  case 43:
#line 1127 "sql_yacc.yy"
    { Lex->current_select->set_braces(1);}
    break;

  case 44:
#line 1128 "sql_yacc.yy"
    {}
    break;

  case 45:
#line 1132 "sql_yacc.yy"
    {}
    break;

  case 46:
#line 1134 "sql_yacc.yy"
    { Lex->current_select->set_braces(0);}
    break;

  case 47:
#line 1135 "sql_yacc.yy"
    {}
    break;

  case 48:
#line 1137 "sql_yacc.yy"
    { Lex->current_select->set_braces(1);}
    break;

  case 49:
#line 1138 "sql_yacc.yy"
    {}
    break;

  case 50:
#line 1143 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->lock_option= TL_READ;
            if (lex->sql_command == SQLCOM_INSERT)
            {
              lex->sql_command= SQLCOM_INSERT_SELECT;
              delete lex->statement;
              lex->statement=
                new(std::nothrow) statement::InsertSelect(YYSession);
              if (lex->statement == NULL)
                DRIZZLE_YYABORT;
            }
            else if (lex->sql_command == SQLCOM_REPLACE)
            {
              lex->sql_command= SQLCOM_REPLACE_SELECT;
              delete lex->statement;
              lex->statement=
                new(std::nothrow) statement::ReplaceSelect(YYSession);
              if (lex->statement == NULL)
                DRIZZLE_YYABORT;
            }
            /*
              The following work only with the local list, the global list
              is created correctly in this case
            */
            lex->current_select->table_list.save_and_clear(&lex->save_list);
            mysql_init_select(lex);
            lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 51:
#line 1173 "sql_yacc.yy"
    {
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 52:
#line 1177 "sql_yacc.yy"
    {
            /*
              The following work only with the local list, the global list
              is created correctly in this case
            */
            Lex->current_select->table_list.push_front(&Lex->save_list);
          }
    break;

  case 53:
#line 1187 "sql_yacc.yy"
    {}
    break;

  case 54:
#line 1188 "sql_yacc.yy"
    {}
    break;

  case 55:
#line 1192 "sql_yacc.yy"
    {}
    break;

  case 56:
#line 1193 "sql_yacc.yy"
    {}
    break;

  case 57:
#line 1197 "sql_yacc.yy"
    { (yyval.num)= false; }
    break;

  case 58:
#line 1198 "sql_yacc.yy"
    { (yyval.num)= true; }
    break;

  case 59:
#line 1202 "sql_yacc.yy"
    { (yyval.num)= false; }
    break;

  case 60:
#line 1203 "sql_yacc.yy"
    { (yyval.num)= true; }
    break;

  case 68:
#line 1224 "sql_yacc.yy"
    {
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;
            message::Table::StorageEngine *protoengine;
            protoengine= ((statement::CreateTable *)Lex->statement)->create_table_proto.mutable_engine();

            statement->is_engine_set= true;

            protoengine->set_name((yyvsp[(3) - (3)].lex_str).str);
          }
    break;

  case 69:
#line 1234 "sql_yacc.yy"
    {
	    message::Table::TableOptions *tableopts;
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;
	    tableopts= ((statement::CreateTable *)Lex->statement)->create_table_proto.mutable_options();

            tableopts->set_block_size((yyvsp[(3) - (3)].ulong_num));
            statement->create_info.used_fields|= HA_CREATE_USED_BLOCK_SIZE;
          }
    break;

  case 70:
#line 1243 "sql_yacc.yy"
    {
	    message::Table::TableOptions *tableopts;
	    tableopts= ((statement::CreateTable *)Lex->statement)->create_table_proto.mutable_options();

	    tableopts->set_comment((yyvsp[(3) - (3)].lex_str).str);
          }
    break;

  case 71:
#line 1250 "sql_yacc.yy"
    {
	    message::Table::TableOptions *tableopts;
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;

	    tableopts= ((statement::CreateTable *)Lex->statement)->create_table_proto.mutable_options();

            statement->create_info.auto_increment_value=(yyvsp[(3) - (3)].ulonglong_number);
            statement->create_info.used_fields|= HA_CREATE_USED_AUTO;
	    tableopts->set_auto_increment_value((yyvsp[(3) - (3)].ulonglong_number));
          }
    break;

  case 72:
#line 1261 "sql_yacc.yy"
    {
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;

            statement->create_info.row_type= (yyvsp[(3) - (3)].row_type);
            statement->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT;
            statement->alter_info.flags.set(ALTER_ROW_FORMAT);
          }
    break;

  case 74:
#line 1270 "sql_yacc.yy"
    {
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;

            statement->create_info.used_fields|= HA_CREATE_USED_KEY_BLOCK_SIZE;

            message::Table::TableOptions *tableopts;
            tableopts= ((statement::CreateTable *)Lex->statement)->create_table_proto.mutable_options();
            tableopts->set_key_block_size((yyvsp[(3) - (3)].ulong_num));
          }
    break;

  case 75:
#line 1283 "sql_yacc.yy"
    {
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;

            HA_CREATE_INFO *cinfo= &statement->create_info;
            if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
                 cinfo->default_table_charset && (yyvsp[(4) - (4)].charset) &&
                 !my_charset_same(cinfo->default_table_charset,(yyvsp[(4) - (4)].charset)))
              {
                my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                         (yyvsp[(4) - (4)].charset)->name, cinfo->default_table_charset->csname);
                DRIZZLE_YYABORT;
              }
              statement->create_info.default_table_charset= (yyvsp[(4) - (4)].charset);
              statement->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
          }
    break;

  case 76:
#line 1302 "sql_yacc.yy"
    {
            statement::CreateSchema *statement= (statement::CreateSchema *)Lex->statement;

            message::Schema &schema_message= statement->schema_message;
            schema_message.set_collation((yyvsp[(4) - (4)].charset)->name);
          }
    break;

  case 77:
#line 1311 "sql_yacc.yy"
    { (yyval.column_format_type)= COLUMN_FORMAT_TYPE_DEFAULT; }
    break;

  case 78:
#line 1312 "sql_yacc.yy"
    { (yyval.column_format_type)= COLUMN_FORMAT_TYPE_FIXED; }
    break;

  case 79:
#line 1313 "sql_yacc.yy"
    { (yyval.column_format_type)= COLUMN_FORMAT_TYPE_DYNAMIC; }
    break;

  case 80:
#line 1316 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DEFAULT; }
    break;

  case 81:
#line 1317 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_FIXED; }
    break;

  case 82:
#line 1318 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DYNAMIC; }
    break;

  case 83:
#line 1319 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPRESSED; }
    break;

  case 84:
#line 1320 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_REDUNDANT; }
    break;

  case 85:
#line 1321 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPACT; }
    break;

  case 86:
#line 1322 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_PAGE; }
    break;

  case 87:
#line 1326 "sql_yacc.yy"
    {}
    break;

  case 94:
#line 1343 "sql_yacc.yy"
    {
            Lex->col_list.empty(); /* Alloced by memory::sql_alloc */
          }
    break;

  case 95:
#line 1350 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            Key *key= new Key((yyvsp[(1) - (7)].key_type), (yyvsp[(2) - (7)].lex_str), &statement->key_create_info, 0,
                              lex->col_list);
            statement->alter_info.key_list.push_back(key);
            lex->col_list.empty(); /* Alloced by memory::sql_alloc */
          }
    break;

  case 96:
#line 1360 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            Key *key= new Key((yyvsp[(2) - (8)].key_type), (yyvsp[(3) - (8)].lex_str).str ? (yyvsp[(3) - (8)].lex_str) : (yyvsp[(1) - (8)].lex_str), &statement->key_create_info, 0,
                              lex->col_list);
            statement->alter_info.key_list.push_back(key);
            lex->col_list.empty(); /* Alloced by memory::sql_alloc */
          }
    break;

  case 97:
#line 1369 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            Key *key= new Foreign_key((yyvsp[(4) - (8)].lex_str).str ? (yyvsp[(4) - (8)].lex_str) : (yyvsp[(1) - (8)].lex_str), lex->col_list,
                                      (yyvsp[(8) - (8)].table),
                                      lex->ref_list,
                                      statement->fk_delete_opt,
                                      statement->fk_update_opt,
                                      statement->fk_match_option);
            statement->alter_info.key_list.push_back(key);
            key= new Key(Key::MULTIPLE, (yyvsp[(1) - (8)].lex_str).str ? (yyvsp[(1) - (8)].lex_str) : (yyvsp[(4) - (8)].lex_str),
                         &default_key_create_info, 1,
                         lex->col_list);
            statement->alter_info.key_list.push_back(key);
            lex->col_list.empty(); /* Alloced by memory::sql_alloc */
            /* Only used for ALTER TABLE. Ignored otherwise. */
            statement->alter_info.flags.set(ALTER_FOREIGN_KEY);
          }
    break;

  case 98:
#line 1388 "sql_yacc.yy"
    {
            Lex->col_list.empty(); /* Alloced by memory::sql_alloc */
          }
    break;

  case 99:
#line 1392 "sql_yacc.yy"
    {
            Lex->col_list.empty(); /* Alloced by memory::sql_alloc */
          }
    break;

  case 103:
#line 1407 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 104:
#line 1408 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str); }
    break;

  case 105:
#line 1412 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(2) - (2)].lex_str); }
    break;

  case 106:
#line 1417 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;
            lex->length=lex->dec=0;
            lex->type=0;
            statement->default_value= statement->on_update_value= 0;
            statement->comment= null_lex_str;
            lex->charset=NULL;
            statement->column_format= COLUMN_FORMAT_TYPE_DEFAULT;

            message::AlterTable &alter_proto=
              ((statement::CreateTable *)Lex->statement)->alter_info.alter_proto;
            statement->current_proto_field= alter_proto.add_added_field();
          }
    break;

  case 107:
#line 1432 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_name((yyvsp[(1) - (3)].lex_str).str);

            if (add_field_to_list(lex->session, &(yyvsp[(1) - (3)].lex_str), (enum enum_field_types) (yyvsp[(3) - (3)].num),
                                  lex->length,lex->dec,lex->type,
                                  statement->column_format,
                                  statement->default_value, statement->on_update_value,
                                  &statement->comment,
                                  statement->change, &lex->interval_list, lex->charset))
              DRIZZLE_YYABORT;

            statement->current_proto_field= NULL;
          }
    break;

  case 108:
#line 1451 "sql_yacc.yy"
    {}
    break;

  case 109:
#line 1456 "sql_yacc.yy"
    {
          (yyval.num)=(yyvsp[(1) - (1)].num);
          Lex->length=(char*) 0; /* use default length */
          statement::CreateTable *statement=
            (statement::CreateTable *)Lex->statement;

          if (statement->current_proto_field)
          {
            if ((yyvsp[(1) - (1)].num) == DRIZZLE_TYPE_LONG)
              statement->current_proto_field->set_type(message::Table::Field::INTEGER);
            else if ((yyvsp[(1) - (1)].num) == DRIZZLE_TYPE_LONGLONG)
              statement->current_proto_field->set_type(message::Table::Field::BIGINT);
            else
              abort();
          }
          }
    break;

  case 110:
#line 1473 "sql_yacc.yy"
    {
            (yyval.num)=(yyvsp[(1) - (2)].num);

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
            {
              assert ((yyvsp[(1) - (2)].num) == DRIZZLE_TYPE_DOUBLE);
              statement->current_proto_field->set_type(message::Table::Field::DOUBLE);
            }
          }
    break;

  case 111:
#line 1486 "sql_yacc.yy"
    {
              Lex->length=(yyvsp[(3) - (4)].lex_str).str;
              (yyval.num)=DRIZZLE_TYPE_VARCHAR;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
            {
              statement->current_proto_field->set_type(message::Table::Field::VARCHAR);
              message::Table::Field::StringFieldOptions *string_field_options;

              string_field_options= statement->current_proto_field->mutable_string_options();

              string_field_options->set_length(atoi((yyvsp[(3) - (4)].lex_str).str));
            }
            }
    break;

  case 112:
#line 1504 "sql_yacc.yy"
    {
              Lex->length=(char*) "1";
              (yyval.num)=DRIZZLE_TYPE_VARCHAR;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::VARCHAR);
            }
    break;

  case 113:
#line 1515 "sql_yacc.yy"
    {
              Lex->length=(yyvsp[(3) - (4)].lex_str).str;
              (yyval.num)= DRIZZLE_TYPE_VARCHAR;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
	    {
              statement->current_proto_field->set_type(message::Table::Field::VARCHAR);

              message::Table::Field::StringFieldOptions *string_field_options;

              string_field_options= statement->current_proto_field->mutable_string_options();

              string_field_options->set_length(atoi((yyvsp[(3) - (4)].lex_str).str));
            }
            }
    break;

  case 114:
#line 1534 "sql_yacc.yy"
    {
              Lex->length=(yyvsp[(3) - (4)].lex_str).str;
              Lex->charset=&my_charset_bin;
              (yyval.num)= DRIZZLE_TYPE_VARCHAR;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
	    {
              statement->current_proto_field->set_type(message::Table::Field::VARCHAR);
              message::Table::Field::StringFieldOptions *string_field_options;

              string_field_options= statement->current_proto_field->mutable_string_options();

              string_field_options->set_length(atoi((yyvsp[(3) - (4)].lex_str).str));
              string_field_options->set_collation_id(my_charset_bin.number);
              string_field_options->set_collation(my_charset_bin.name);
            }
            }
    break;

  case 115:
#line 1555 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_DATE;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::DATE);
          }
    break;

  case 116:
#line 1565 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_TIMESTAMP;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::TIMESTAMP);
          }
    break;

  case 117:
#line 1575 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_DATETIME;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::DATETIME);
          }
    break;

  case 118:
#line 1585 "sql_yacc.yy"
    {
              Lex->charset=&my_charset_bin;
              (yyval.num)=DRIZZLE_TYPE_BLOB;
              Lex->length=(char*) 0; /* use default length */

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::BLOB);
            }
    break;

  case 119:
#line 1597 "sql_yacc.yy"
    {
              (yyval.num)=DRIZZLE_TYPE_BLOB;
              Lex->length=(char*) 0; /* use default length */

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::BLOB);
            }
    break;

  case 120:
#line 1608 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_DECIMAL;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::DECIMAL);
          }
    break;

  case 121:
#line 1618 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_DECIMAL;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::DECIMAL);
          }
    break;

  case 122:
#line 1628 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_DECIMAL;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::DECIMAL);
          }
    break;

  case 123:
#line 1638 "sql_yacc.yy"
    {Lex->interval_list.empty();}
    break;

  case 124:
#line 1640 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_ENUM;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::ENUM);
          }
    break;

  case 125:
#line 1650 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_LONGLONG;
            Lex->type|= (AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNIQUE_FLAG);

            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;
            if (statement->current_proto_field)
            {
              message::Table::Field::FieldConstraints *constraints;
              constraints= statement->current_proto_field->mutable_constraints();
              constraints->set_is_nullable(false);

              statement->current_proto_field->set_type(message::Table::Field::BIGINT);
            }
          }
    break;

  case 126:
#line 1667 "sql_yacc.yy"
    {}
    break;

  case 127:
#line 1671 "sql_yacc.yy"
    {}
    break;

  case 128:
#line 1672 "sql_yacc.yy"
    {}
    break;

  case 129:
#line 1676 "sql_yacc.yy"
    { (yyval.num)=DRIZZLE_TYPE_LONG; }
    break;

  case 130:
#line 1677 "sql_yacc.yy"
    { (yyval.num)=DRIZZLE_TYPE_LONGLONG; }
    break;

  case 131:
#line 1682 "sql_yacc.yy"
    {
            (yyval.num)= DRIZZLE_TYPE_DOUBLE;
          }
    break;

  case 132:
#line 1686 "sql_yacc.yy"
    { (yyval.num)=DRIZZLE_TYPE_DOUBLE; }
    break;

  case 133:
#line 1688 "sql_yacc.yy"
    { (yyval.num)=DRIZZLE_TYPE_DOUBLE; }
    break;

  case 134:
#line 1693 "sql_yacc.yy"
    { Lex->dec=Lex->length= (char*)0; }
    break;

  case 135:
#line 1695 "sql_yacc.yy"
    { Lex->length=(yyvsp[(2) - (3)].lex_str).str; Lex->dec= (char*)0; }
    break;

  case 136:
#line 1697 "sql_yacc.yy"
    {}
    break;

  case 137:
#line 1702 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->length=(yyvsp[(2) - (5)].lex_str).str;
            lex->dec=(yyvsp[(4) - (5)].lex_str).str;
          }
    break;

  case 138:
#line 1710 "sql_yacc.yy"
    { Lex->length=(char*) 0; /* use default length */ }
    break;

  case 139:
#line 1711 "sql_yacc.yy"
    { Lex->length= (yyvsp[(2) - (3)].lex_str).str; }
    break;

  case 140:
#line 1715 "sql_yacc.yy"
    {}
    break;

  case 141:
#line 1716 "sql_yacc.yy"
    {}
    break;

  case 142:
#line 1720 "sql_yacc.yy"
    {}
    break;

  case 143:
#line 1721 "sql_yacc.yy"
    {}
    break;

  case 144:
#line 1725 "sql_yacc.yy"
    {}
    break;

  case 146:
#line 1731 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            Lex->type&= ~ NOT_NULL_FLAG;

            if (statement->current_proto_field)
            {
              message::Table::Field::FieldConstraints *constraints;
              constraints= statement->current_proto_field->mutable_constraints();
              constraints->set_is_nullable(true);
            }
          }
    break;

  case 147:
#line 1743 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->column_format= (yyvsp[(2) - (2)].column_format_type);
            statement->alter_info.flags.set(ALTER_COLUMN_FORMAT);
          }
    break;

  case 148:
#line 1750 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            Lex->type|= NOT_NULL_FLAG;

            if (statement->current_proto_field)
            {
              message::Table::Field::FieldConstraints *constraints;
              constraints= statement->current_proto_field->mutable_constraints();
              constraints->set_is_nullable(false);
            }
          }
    break;

  case 149:
#line 1762 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->default_value=(yyvsp[(2) - (2)].item);
            statement->alter_info.flags.set(ALTER_COLUMN_DEFAULT);
          }
    break;

  case 150:
#line 1769 "sql_yacc.yy"
    { ((statement::AlterTable *)Lex->statement)->on_update_value= new Item_func_now_local(); }
    break;

  case 151:
#line 1771 "sql_yacc.yy"
    {
            Lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG;

            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            if (statement->current_proto_field)
            {
              message::Table::Field::FieldConstraints *constraints;

              constraints= statement->current_proto_field->mutable_constraints();
              constraints->set_is_nullable(false);
            }
          }
    break;

  case 152:
#line 1784 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNIQUE_FLAG;
            statement->alter_info.flags.set(ALTER_ADD_INDEX);

            if (statement->current_proto_field)
            {
              message::Table::Field::FieldConstraints *constraints;
              constraints= statement->current_proto_field->mutable_constraints();
              constraints->set_is_nullable(false);
            }
          }
    break;

  case 153:
#line 1799 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            lex->type|= PRI_KEY_FLAG | NOT_NULL_FLAG;
            statement->alter_info.flags.set(ALTER_ADD_INDEX);

            if (statement->current_proto_field)
            {
              message::Table::Field::FieldConstraints *constraints;
              constraints= statement->current_proto_field->mutable_constraints();
              constraints->set_is_nullable(false);
            }
          }
    break;

  case 154:
#line 1814 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            lex->type|= UNIQUE_FLAG;
            statement->alter_info.flags.set(ALTER_ADD_INDEX);
          }
    break;

  case 155:
#line 1822 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            lex->type|= UNIQUE_KEY_FLAG;
            statement->alter_info.flags.set(ALTER_ADD_INDEX);
          }
    break;

  case 156:
#line 1830 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            statement->comment= (yyvsp[(2) - (2)].lex_str);

            if (statement->current_proto_field)
              statement->current_proto_field->set_comment((yyvsp[(2) - (2)].lex_str).str);
          }
    break;

  case 157:
#line 1838 "sql_yacc.yy"
    {
            if (Lex->charset && !my_charset_same(Lex->charset,(yyvsp[(2) - (2)].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[(2) - (2)].charset)->name,Lex->charset->csname);
              DRIZZLE_YYABORT;
            }
            else
            {
              Lex->charset=(yyvsp[(2) - (2)].charset);
            }
          }
    break;

  case 158:
#line 1854 "sql_yacc.yy"
    { (yyval.item)= new Item_func_now_local(); }
    break;

  case 159:
#line 1856 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[(1) - (1)].item); }
    break;

  case 160:
#line 1861 "sql_yacc.yy"
    {
            if (!((yyval.charset)=get_charset_by_name((yyvsp[(1) - (1)].lex_str).str)))
            {
              my_error(ER_UNKNOWN_COLLATION, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 161:
#line 1871 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[(1) - (1)].charset); }
    break;

  case 162:
#line 1872 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 163:
#line 1876 "sql_yacc.yy"
    {}
    break;

  case 164:
#line 1877 "sql_yacc.yy"
    {}
    break;

  case 167:
#line 1891 "sql_yacc.yy"
    {
            (yyval.table)=(yyvsp[(2) - (5)].table);
          }
    break;

  case 168:
#line 1898 "sql_yacc.yy"
    { Lex->ref_list.empty(); }
    break;

  case 170:
#line 1904 "sql_yacc.yy"
    { Lex->ref_list.push_back(new Key_part_spec((yyvsp[(3) - (3)].lex_str), 0)); }
    break;

  case 171:
#line 1906 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->ref_list.empty();
            lex->ref_list.push_back(new Key_part_spec((yyvsp[(1) - (1)].lex_str), 0));
          }
    break;

  case 172:
#line 1915 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->fk_match_option= Foreign_key::FK_MATCH_UNDEF; }
    break;

  case 173:
#line 1917 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->fk_match_option= Foreign_key::FK_MATCH_FULL; }
    break;

  case 174:
#line 1919 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->fk_match_option= Foreign_key::FK_MATCH_PARTIAL; }
    break;

  case 175:
#line 1921 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->fk_match_option= Foreign_key::FK_MATCH_SIMPLE; }
    break;

  case 176:
#line 1926 "sql_yacc.yy"
    {
            ((statement::CreateTable *)Lex->statement)->fk_update_opt= Foreign_key::FK_OPTION_UNDEF;
            ((statement::CreateTable *)Lex->statement)->fk_delete_opt= Foreign_key::FK_OPTION_UNDEF;
          }
    break;

  case 177:
#line 1931 "sql_yacc.yy"
    {
            ((statement::CreateTable *)Lex->statement)->fk_update_opt= (yyvsp[(3) - (3)].m_fk_option);
            ((statement::CreateTable *)Lex->statement)->fk_delete_opt= Foreign_key::FK_OPTION_UNDEF;
          }
    break;

  case 178:
#line 1936 "sql_yacc.yy"
    {
            ((statement::CreateTable *)Lex->statement)->fk_update_opt= Foreign_key::FK_OPTION_UNDEF;
            ((statement::CreateTable *)Lex->statement)->fk_delete_opt= (yyvsp[(3) - (3)].m_fk_option);
          }
    break;

  case 179:
#line 1942 "sql_yacc.yy"
    {
            ((statement::CreateTable *)Lex->statement)->fk_update_opt= (yyvsp[(3) - (6)].m_fk_option);
            ((statement::CreateTable *)Lex->statement)->fk_delete_opt= (yyvsp[(6) - (6)].m_fk_option);
          }
    break;

  case 180:
#line 1948 "sql_yacc.yy"
    {
            ((statement::CreateTable *)Lex->statement)->fk_update_opt= (yyvsp[(6) - (6)].m_fk_option);
            ((statement::CreateTable *)Lex->statement)->fk_delete_opt= (yyvsp[(3) - (6)].m_fk_option);
          }
    break;

  case 181:
#line 1955 "sql_yacc.yy"
    { (yyval.m_fk_option)= Foreign_key::FK_OPTION_RESTRICT; }
    break;

  case 182:
#line 1956 "sql_yacc.yy"
    { (yyval.m_fk_option)= Foreign_key::FK_OPTION_CASCADE; }
    break;

  case 183:
#line 1957 "sql_yacc.yy"
    { (yyval.m_fk_option)= Foreign_key::FK_OPTION_SET_NULL; }
    break;

  case 184:
#line 1958 "sql_yacc.yy"
    { (yyval.m_fk_option)= Foreign_key::FK_OPTION_NO_ACTION; }
    break;

  case 185:
#line 1959 "sql_yacc.yy"
    { (yyval.m_fk_option)= Foreign_key::FK_OPTION_DEFAULT;  }
    break;

  case 186:
#line 1963 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 187:
#line 1967 "sql_yacc.yy"
    { (yyval.key_type)= Key::PRIMARY; }
    break;

  case 188:
#line 1968 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 189:
#line 1972 "sql_yacc.yy"
    {}
    break;

  case 190:
#line 1973 "sql_yacc.yy"
    {}
    break;

  case 191:
#line 1977 "sql_yacc.yy"
    {}
    break;

  case 193:
#line 1982 "sql_yacc.yy"
    {}
    break;

  case 194:
#line 1983 "sql_yacc.yy"
    {}
    break;

  case 195:
#line 1984 "sql_yacc.yy"
    {}
    break;

  case 196:
#line 1988 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 197:
#line 1989 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 198:
#line 1993 "sql_yacc.yy"
    {
            ((statement::CreateTable *)Lex->statement)->key_create_info= default_key_create_info;
          }
    break;

  case 201:
#line 2010 "sql_yacc.yy"
    {}
    break;

  case 205:
#line 2020 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->key_create_info.algorithm= (yyvsp[(2) - (2)].key_alg); }
    break;

  case 206:
#line 2021 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->key_create_info.algorithm= (yyvsp[(2) - (2)].key_alg); }
    break;

  case 208:
#line 2027 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->key_create_info.block_size= (yyvsp[(3) - (3)].ulong_num); }
    break;

  case 209:
#line 2029 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->key_create_info.comment= (yyvsp[(2) - (2)].lex_str); }
    break;

  case 210:
#line 2033 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_BTREE; }
    break;

  case 211:
#line 2034 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_HASH; }
    break;

  case 212:
#line 2038 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[(3) - (4)].key_part)); }
    break;

  case 213:
#line 2039 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[(1) - (2)].key_part)); }
    break;

  case 214:
#line 2043 "sql_yacc.yy"
    { (yyval.key_part)=new Key_part_spec((yyvsp[(1) - (1)].lex_str), 0); }
    break;

  case 215:
#line 2045 "sql_yacc.yy"
    {
            int key_part_len= atoi((yyvsp[(3) - (4)].lex_str).str);
            if (!key_part_len)
            {
              my_error(ER_KEY_PART_0, MYF(0), (yyvsp[(1) - (4)].lex_str).str);
            }
            (yyval.key_part)=new Key_part_spec((yyvsp[(1) - (4)].lex_str), (uint) key_part_len);
          }
    break;

  case 216:
#line 2056 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 217:
#line 2057 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str); }
    break;

  case 218:
#line 2061 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 219:
#line 2062 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(2) - (2)].lex_str); }
    break;

  case 220:
#line 2066 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[(1) - (1)].string)); }
    break;

  case 221:
#line 2067 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[(3) - (3)].string)); }
    break;

  case 222:
#line 2075 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            lex->name.str= 0;
            lex->name.length= 0;
            lex->sql_command= SQLCOM_ALTER_TABLE;
            statement::AlterTable *statement= new(std::nothrow) statement::AlterTable(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->duplicates= DUP_ERROR;
            if (!lex->select_lex.add_table_to_list(session, (yyvsp[(5) - (5)].table), NULL,
                                                   TL_OPTION_UPDATING))
              DRIZZLE_YYABORT;
            lex->col_list.empty();
            lex->select_lex.init_order();
            lex->select_lex.db=
              ((TableList*) lex->select_lex.table_list.first)->db;
            statement->create_info.row_type= ROW_TYPE_NOT_USED;
            statement->alter_info.build_method= (yyvsp[(2) - (5)].build_method);
          }
    break;

  case 223:
#line 2097 "sql_yacc.yy"
    {}
    break;

  case 224:
#line 2099 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command=SQLCOM_ALTER_DB;
            lex->statement= new(std::nothrow) statement::AlterSchema(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 225:
#line 2107 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->name= (yyvsp[(3) - (5)].lex_str);
            if (lex->name.str == NULL &&
                lex->copy_db_to(&lex->name.str, &lex->name.length))
              DRIZZLE_YYABORT;
          }
    break;

  case 226:
#line 2117 "sql_yacc.yy"
    { (yyval.lex_str).str= 0; (yyval.lex_str).length= 0; }
    break;

  case 227:
#line 2118 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str); }
    break;

  case 229:
#line 2124 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            statement->alter_info.tablespace_op= DISCARD_TABLESPACE;
          }
    break;

  case 230:
#line 2129 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            statement->alter_info.tablespace_op= IMPORT_TABLESPACE;
          }
    break;

  case 232:
#line 2138 "sql_yacc.yy"
    {
            (yyval.build_method)= HA_BUILD_DEFAULT;
          }
    break;

  case 233:
#line 2142 "sql_yacc.yy"
    {
            (yyval.build_method)= HA_BUILD_ONLINE;
          }
    break;

  case 234:
#line 2146 "sql_yacc.yy"
    {
            (yyval.build_method)= HA_BUILD_OFFLINE;
          }
    break;

  case 237:
#line 2158 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->change=0;
            statement->alter_info.flags.set(ALTER_ADD_COLUMN);
          }
    break;

  case 238:
#line 2167 "sql_yacc.yy"
    { }
    break;

  case 239:
#line 2169 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.flags.set(ALTER_ADD_INDEX);
          }
    break;

  case 240:
#line 2175 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.flags.set(ALTER_ADD_COLUMN);
            statement->alter_info.flags.set(ALTER_ADD_INDEX);
          }
    break;

  case 241:
#line 2182 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            statement->change= (yyvsp[(3) - (3)].lex_str).str;
            statement->alter_info.flags.set(ALTER_CHANGE_COLUMN);
          }
    break;

  case 243:
#line 2189 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            lex->length=lex->dec=0; lex->type=0;
            statement->default_value= statement->on_update_value= 0;
            statement->comment= null_lex_str;
            lex->charset= NULL;
            statement->alter_info.flags.set(ALTER_CHANGE_COLUMN);
            statement->column_format= COLUMN_FORMAT_TYPE_DEFAULT;

            statement->current_proto_field= NULL;
          }
    break;

  case 244:
#line 2202 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            if (add_field_to_list(lex->session,&(yyvsp[(3) - (5)].lex_str),
                                  (enum enum_field_types) (yyvsp[(5) - (5)].num),
                                  lex->length, lex->dec, lex->type,
                                  statement->column_format,
                                  statement->default_value,
                                  statement->on_update_value,
                                  &statement->comment,
                                  (yyvsp[(3) - (5)].lex_str).str, &lex->interval_list, lex->charset))
              DRIZZLE_YYABORT;
          }
    break;

  case 246:
#line 2218 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.drop_list.push_back(new AlterDrop(AlterDrop::COLUMN, (yyvsp[(3) - (3)].lex_str).str));
            statement->alter_info.flags.set(ALTER_DROP_COLUMN);
          }
    break;

  case 247:
#line 2225 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.flags.set(ALTER_DROP_INDEX);
            statement->alter_info.flags.set(ALTER_FOREIGN_KEY);
          }
    break;

  case 248:
#line 2232 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.drop_list.push_back(new AlterDrop(AlterDrop::KEY,
                                                               "PRIMARY"));
            statement->alter_info.flags.set(ALTER_DROP_INDEX);
          }
    break;

  case 249:
#line 2240 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.drop_list.push_back(new AlterDrop(AlterDrop::KEY,
                                                                    (yyvsp[(3) - (3)].lex_str).str));
            statement->alter_info.flags.set(ALTER_DROP_INDEX);
          }
    break;

  case 250:
#line 2248 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.keys_onoff= DISABLE;
            statement->alter_info.flags.set(ALTER_KEYS_ONOFF);
          }
    break;

  case 251:
#line 2255 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.keys_onoff= ENABLE;
            statement->alter_info.flags.set(ALTER_KEYS_ONOFF);
          }
    break;

  case 252:
#line 2262 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.alter_list.push_back(new AlterColumn((yyvsp[(3) - (6)].lex_str).str,(yyvsp[(6) - (6)].item)));
            statement->alter_info.flags.set(ALTER_COLUMN_DEFAULT);
          }
    break;

  case 253:
#line 2269 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.alter_list.push_back(new AlterColumn((yyvsp[(3) - (5)].lex_str).str, (Item*) 0));
            statement->alter_info.flags.set(ALTER_COLUMN_DEFAULT);
          }
    break;

  case 254:
#line 2276 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            size_t dummy;

            lex->select_lex.db=(yyvsp[(3) - (3)].table)->db.str;
            if (lex->select_lex.db == NULL &&
                lex->copy_db_to(&lex->select_lex.db, &dummy))
            {
              DRIZZLE_YYABORT;
            }

            if (check_table_name((yyvsp[(3) - (3)].table)->table.str,(yyvsp[(3) - (3)].table)->table.length))
            {
              my_error(ER_WRONG_TABLE_NAME, MYF(0), (yyvsp[(3) - (3)].table)->table.str);
              DRIZZLE_YYABORT;
            }

            lex->name= (yyvsp[(3) - (3)].table)->table;
            statement->alter_info.flags.set(ALTER_RENAME);
          }
    break;

  case 255:
#line 2298 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->create_info.table_charset=
            statement->create_info.default_table_charset= (yyvsp[(3) - (3)].charset);
            statement->create_info.used_fields|= (HA_CREATE_USED_CHARSET |
              HA_CREATE_USED_DEFAULT_CHARSET);
            statement->alter_info.flags.set(ALTER_CONVERT);
          }
    break;

  case 256:
#line 2308 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.flags.set(ALTER_OPTIONS);
          }
    break;

  case 257:
#line 2314 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.flags.set(ALTER_FORCE);
          }
    break;

  case 258:
#line 2320 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.flags.set(ALTER_ORDER);
          }
    break;

  case 259:
#line 2328 "sql_yacc.yy"
    {}
    break;

  case 260:
#line 2329 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2333 "sql_yacc.yy"
    { Lex->ignore= 0;}
    break;

  case 262:
#line 2334 "sql_yacc.yy"
    { Lex->ignore= 1;}
    break;

  case 263:
#line 2338 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2340 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            store_position_for_column((yyvsp[(2) - (2)].lex_str).str);
            statement->alter_info.flags.set(ALTER_COLUMN_ORDER);
          }
    break;

  case 265:
#line 2347 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            store_position_for_column(first_keyword);
            statement->alter_info.flags.set(ALTER_COLUMN_ORDER);
          }
    break;

  case 266:
#line 2356 "sql_yacc.yy"
    {}
    break;

  case 267:
#line 2357 "sql_yacc.yy"
    {}
    break;

  case 268:
#line 2358 "sql_yacc.yy"
    {}
    break;

  case 269:
#line 2359 "sql_yacc.yy"
    {}
    break;

  case 270:
#line 2364 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command= SQLCOM_BEGIN;
            lex->statement= new(std::nothrow) statement::StartTransaction(YYSession, (start_transaction_option_t)(yyvsp[(3) - (3)].num));
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 271:
#line 2374 "sql_yacc.yy"
    { (yyval.num) = START_TRANS_NO_OPTIONS; }
    break;

  case 272:
#line 2376 "sql_yacc.yy"
    {
            (yyval.num)= START_TRANS_OPT_WITH_CONS_SNAPSHOT;
          }
    break;

  case 273:
#line 2384 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command = SQLCOM_CHECKSUM;
            lex->statement= new(std::nothrow) statement::Checksum(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 274:
#line 2392 "sql_yacc.yy"
    {}
    break;

  case 275:
#line 2398 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command = SQLCOM_ANALYZE;
            lex->statement= new(std::nothrow) statement::Analyze(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 276:
#line 2406 "sql_yacc.yy"
    {}
    break;

  case 277:
#line 2411 "sql_yacc.yy"
    {
            LEX *lex=Lex;

            lex->sql_command = SQLCOM_CHECK;
            lex->statement= new(std::nothrow) statement::Check(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 278:
#line 2420 "sql_yacc.yy"
    {}
    break;

  case 279:
#line 2425 "sql_yacc.yy"
    {
            Lex->sql_command= SQLCOM_RENAME_TABLE;
            Lex->statement= new(std::nothrow) statement::RenameTable(YYSession);
            if (Lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 280:
#line 2432 "sql_yacc.yy"
    {}
    break;

  case 283:
#line 2442 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            Select_Lex *sl= lex->current_select;
            if (!sl->add_table_to_list(lex->session, (yyvsp[(1) - (3)].table),NULL,TL_OPTION_UPDATING,
                                       TL_IGNORE) ||
                !sl->add_table_to_list(lex->session, (yyvsp[(3) - (3)].table),NULL,TL_OPTION_UPDATING,
                                       TL_IGNORE))
              DRIZZLE_YYABORT;
          }
    break;

  case 284:
#line 2460 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command= SQLCOM_SELECT;
            lex->statement= new(std::nothrow) statement::Select(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 287:
#line 2477 "sql_yacc.yy"
    {
            if (setup_select_in_parentheses(Lex))
              DRIZZLE_YYABORT;
          }
    break;

  case 289:
#line 2487 "sql_yacc.yy"
    {
            if (setup_select_in_parentheses(Lex))
              DRIZZLE_YYABORT;
          }
    break;

  case 291:
#line 2496 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            Select_Lex * sel= lex->current_select;
            if (lex->current_select->set_braces(0))
            {
              my_parse_error(ER(ER_SYNTAX_ERROR));
              DRIZZLE_YYABORT;
            }
            if (sel->linkage == UNION_TYPE &&
                sel->master_unit()->first_select()->braces)
            {
              my_parse_error(ER(ER_SYNTAX_ERROR));
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 293:
#line 2515 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            Select_Lex *sel= lex->current_select;
            if (sel->linkage != UNION_TYPE)
              mysql_init_select(lex);
            lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 294:
#line 2523 "sql_yacc.yy"
    {
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 296:
#line 2530 "sql_yacc.yy"
    {}
    break;

  case 301:
#line 2540 "sql_yacc.yy"
    {
            Lex->current_select->context.table_list=
              Lex->current_select->context.first_name_resolution_table=
                reinterpret_cast<TableList *>(Lex->current_select->table_list.first);
          }
    break;

  case 303:
#line 2550 "sql_yacc.yy"
    {
            if (Lex->current_select->options & SELECT_DISTINCT &&
                Lex->current_select->options & SELECT_ALL)
            {
              my_error(ER_WRONG_USAGE, MYF(0), "ALL", "DISTINCT");
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 306:
#line 2566 "sql_yacc.yy"
    { Lex->current_select->options|= SELECT_STRAIGHT_JOIN; }
    break;

  case 307:
#line 2567 "sql_yacc.yy"
    { Lex->current_select->options|= SELECT_DISTINCT; }
    break;

  case 308:
#line 2568 "sql_yacc.yy"
    { Lex->current_select->options|= SELECT_SMALL_RESULT; }
    break;

  case 309:
#line 2569 "sql_yacc.yy"
    { Lex->current_select->options|= SELECT_BIG_RESULT; }
    break;

  case 310:
#line 2571 "sql_yacc.yy"
    {
            if (check_simple_select())
              DRIZZLE_YYABORT;
            Lex->current_select->options|= OPTION_BUFFER_RESULT;
          }
    break;

  case 311:
#line 2577 "sql_yacc.yy"
    {
            if (check_simple_select())
              DRIZZLE_YYABORT;
            Lex->current_select->options|= OPTION_FOUND_ROWS;
          }
    break;

  case 312:
#line 2582 "sql_yacc.yy"
    { Lex->current_select->options|= SELECT_ALL; }
    break;

  case 314:
#line 2588 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->current_select->set_lock_for_tables(TL_WRITE);
          }
    break;

  case 315:
#line 2593 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->current_select->
              set_lock_for_tables(TL_READ_WITH_SHARED_LOCKS);
          }
    break;

  case 318:
#line 2604 "sql_yacc.yy"
    {
            Session *session= YYSession;
            if (session->add_item_to_list( new Item_field(&session->lex->current_select->
                                                          context,
                                                          NULL, NULL, "*")))
              DRIZZLE_YYABORT;
            (session->lex->current_select->with_wild)++;
          }
    break;

  case 319:
#line 2616 "sql_yacc.yy"
    {
            Session *session= YYSession;

            if (session->add_item_to_list((yyvsp[(2) - (3)].item)))
              DRIZZLE_YYABORT;
          }
    break;

  case 320:
#line 2623 "sql_yacc.yy"
    {
            Session *session= YYSession;
            assert((yyvsp[(1) - (4)].simple_string) < (yyvsp[(3) - (4)].simple_string));

            if (session->add_item_to_list((yyvsp[(2) - (4)].item)))
              DRIZZLE_YYABORT;
            if ((yyvsp[(4) - (4)].lex_str).str)
            {
              (yyvsp[(2) - (4)].item)->is_autogenerated_name= false;
              (yyvsp[(2) - (4)].item)->set_name((yyvsp[(4) - (4)].lex_str).str, (yyvsp[(4) - (4)].lex_str).length, system_charset_info);
            }
            else if (!(yyvsp[(2) - (4)].item)->name)
            {
              (yyvsp[(2) - (4)].item)->set_name((yyvsp[(1) - (4)].simple_string), (uint) ((yyvsp[(3) - (4)].simple_string) - (yyvsp[(1) - (4)].simple_string)), session->charset());
            }
          }
    break;

  case 321:
#line 2642 "sql_yacc.yy"
    {
            Session *session= YYSession;
            Lex_input_stream *lip= session->m_lip;
            (yyval.simple_string)= (char*) lip->get_cpp_tok_start();
          }
    break;

  case 322:
#line 2650 "sql_yacc.yy"
    {
            Session *session= YYSession;
            Lex_input_stream *lip= session->m_lip;
            (yyval.simple_string)= (char*) lip->get_cpp_tok_end();
          }
    break;

  case 323:
#line 2658 "sql_yacc.yy"
    { (yyval.lex_str)=null_lex_str;}
    break;

  case 324:
#line 2659 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(2) - (2)].lex_str); }
    break;

  case 325:
#line 2660 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(2) - (2)].lex_str); }
    break;

  case 326:
#line 2661 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str); }
    break;

  case 327:
#line 2662 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str); }
    break;

  case 328:
#line 2666 "sql_yacc.yy"
    {}
    break;

  case 329:
#line 2667 "sql_yacc.yy"
    {}
    break;

  case 330:
#line 2673 "sql_yacc.yy"
    {
            /*
              Design notes:
              Do not use a manually maintained stack like session->lex->xxx_list,
              but use the internal bison stack ($$, $1 and $3) instead.
              Using the bison stack is:
              - more robust to changes in the grammar,
              - guaranteed to be in sync with the parser state,
              - better for performances (no memory allocation).
            */
            Item_cond_or *item1;
            Item_cond_or *item3;
            if (is_cond_or((yyvsp[(1) - (3)].item)))
            {
              item1= (Item_cond_or*) (yyvsp[(1) - (3)].item);
              if (is_cond_or((yyvsp[(3) - (3)].item)))
              {
                item3= (Item_cond_or*) (yyvsp[(3) - (3)].item);
                /*
                  (X1 OR X2) OR (Y1 OR Y2) ==> OR (X1, X2, Y1, Y2)
                */
                item3->add_at_head(item1->argument_list());
                (yyval.item) = (yyvsp[(3) - (3)].item);
              }
              else
              {
                /*
                  (X1 OR X2) OR Y ==> OR (X1, X2, Y)
                */
                item1->add((yyvsp[(3) - (3)].item));
                (yyval.item) = (yyvsp[(1) - (3)].item);
              }
            }
            else if (is_cond_or((yyvsp[(3) - (3)].item)))
            {
              item3= (Item_cond_or*) (yyvsp[(3) - (3)].item);
              /*
                X OR (Y1 OR Y2) ==> OR (X, Y1, Y2)
              */
              item3->add_at_head((yyvsp[(1) - (3)].item));
              (yyval.item) = (yyvsp[(3) - (3)].item);
            }
            else
            {
              /* X OR Y */
              (yyval.item) = new (YYSession->mem_root) Item_cond_or((yyvsp[(1) - (3)].item), (yyvsp[(3) - (3)].item));
            }
          }
    break;

  case 331:
#line 2722 "sql_yacc.yy"
    {
            /* XOR is a proprietary extension */
            (yyval.item) = new (YYSession->mem_root) Item_cond_xor((yyvsp[(1) - (3)].item), (yyvsp[(3) - (3)].item));
          }
    break;

  case 332:
#line 2727 "sql_yacc.yy"
    {
            /* See comments in rule expr: expr or expr */
            Item_cond_and *item1;
            Item_cond_and *item3;
            if (is_cond_and((yyvsp[(1) - (3)].item)))
            {
              item1= (Item_cond_and*) (yyvsp[(1) - (3)].item);
              if (is_cond_and((yyvsp[(3) - (3)].item)))
              {
                item3= (Item_cond_and*) (yyvsp[(3) - (3)].item);
                /*
                  (X1 AND X2) AND (Y1 AND Y2) ==> AND (X1, X2, Y1, Y2)
                */
                item3->add_at_head(item1->argument_list());
                (yyval.item) = (yyvsp[(3) - (3)].item);
              }
              else
              {
                /*
                  (X1 AND X2) AND Y ==> AND (X1, X2, Y)
                */
                item1->add((yyvsp[(3) - (3)].item));
                (yyval.item) = (yyvsp[(1) - (3)].item);
              }
            }
            else if (is_cond_and((yyvsp[(3) - (3)].item)))
            {
              item3= (Item_cond_and*) (yyvsp[(3) - (3)].item);
              /*
                X AND (Y1 AND Y2) ==> AND (X, Y1, Y2)
              */
              item3->add_at_head((yyvsp[(1) - (3)].item));
              (yyval.item) = (yyvsp[(3) - (3)].item);
            }
            else
            {
              /* X AND Y */
              (yyval.item) = new (YYSession->mem_root) Item_cond_and((yyvsp[(1) - (3)].item), (yyvsp[(3) - (3)].item));
            }
          }
    break;

  case 333:
#line 2768 "sql_yacc.yy"
    { (yyval.item)= negate_expression(YYSession, (yyvsp[(2) - (2)].item)); }
    break;

  case 334:
#line 2770 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_istrue((yyvsp[(1) - (3)].item)); }
    break;

  case 335:
#line 2772 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_isnottrue((yyvsp[(1) - (4)].item)); }
    break;

  case 336:
#line 2774 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_isfalse((yyvsp[(1) - (3)].item)); }
    break;

  case 337:
#line 2776 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_isnotfalse((yyvsp[(1) - (4)].item)); }
    break;

  case 338:
#line 2778 "sql_yacc.yy"
    { (yyval.item)= new Item_func_isnull((yyvsp[(1) - (3)].item)); }
    break;

  case 339:
#line 2780 "sql_yacc.yy"
    { (yyval.item)= new Item_func_isnotnull((yyvsp[(1) - (4)].item)); }
    break;

  case 341:
#line 2786 "sql_yacc.yy"
    { (yyval.item)= new Item_func_isnull((yyvsp[(1) - (3)].item)); }
    break;

  case 342:
#line 2788 "sql_yacc.yy"
    { (yyval.item)= new Item_func_isnotnull((yyvsp[(1) - (4)].item)); }
    break;

  case 343:
#line 2790 "sql_yacc.yy"
    { (yyval.item)= new Item_func_equal((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 344:
#line 2792 "sql_yacc.yy"
    { (yyval.item)= (*(yyvsp[(2) - (3)].boolfunc2creator))(0)->create((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 345:
#line 2794 "sql_yacc.yy"
    { (yyval.item)= all_any_subquery_creator((yyvsp[(1) - (6)].item), (yyvsp[(2) - (6)].boolfunc2creator), (yyvsp[(3) - (6)].num), (yyvsp[(5) - (6)].select_lex)); }
    break;

  case 347:
#line 2800 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_in_subselect((yyvsp[(1) - (5)].item), (yyvsp[(4) - (5)].select_lex));
          }
    break;

  case 348:
#line 2804 "sql_yacc.yy"
    {
            Session *session= YYSession;
            Item *item= new (session->mem_root) Item_in_subselect((yyvsp[(1) - (6)].item), (yyvsp[(5) - (6)].select_lex));
            (yyval.item)= negate_expression(session, item);
          }
    break;

  case 349:
#line 2810 "sql_yacc.yy"
    {
            (yyval.item)= handle_sql2003_note184_exception(YYSession, (yyvsp[(1) - (5)].item), true, (yyvsp[(4) - (5)].item));
          }
    break;

  case 350:
#line 2814 "sql_yacc.yy"
    {
            (yyvsp[(6) - (7)].item_list)->push_front((yyvsp[(4) - (7)].item));
            (yyvsp[(6) - (7)].item_list)->push_front((yyvsp[(1) - (7)].item));
            (yyval.item)= new (YYSession->mem_root) Item_func_in(*(yyvsp[(6) - (7)].item_list));
          }
    break;

  case 351:
#line 2820 "sql_yacc.yy"
    {
            (yyval.item)= handle_sql2003_note184_exception(YYSession, (yyvsp[(1) - (6)].item), false, (yyvsp[(5) - (6)].item));
          }
    break;

  case 352:
#line 2824 "sql_yacc.yy"
    {
            (yyvsp[(7) - (8)].item_list)->push_front((yyvsp[(5) - (8)].item));
            (yyvsp[(7) - (8)].item_list)->push_front((yyvsp[(1) - (8)].item));
            Item_func_in *item = new (YYSession->mem_root) Item_func_in(*(yyvsp[(7) - (8)].item_list));
            item->negate();
            (yyval.item)= item;
          }
    break;

  case 353:
#line 2832 "sql_yacc.yy"
    { (yyval.item)= new Item_func_between((yyvsp[(1) - (5)].item),(yyvsp[(3) - (5)].item),(yyvsp[(5) - (5)].item)); }
    break;

  case 354:
#line 2834 "sql_yacc.yy"
    {
            Item_func_between *item= new Item_func_between((yyvsp[(1) - (6)].item),(yyvsp[(4) - (6)].item),(yyvsp[(6) - (6)].item));
            item->negate();
            (yyval.item)= item;
          }
    break;

  case 355:
#line 2840 "sql_yacc.yy"
    { (yyval.item)= new Item_func_like((yyvsp[(1) - (4)].item),(yyvsp[(3) - (4)].item),(yyvsp[(4) - (4)].item),Lex->escape_used); }
    break;

  case 356:
#line 2842 "sql_yacc.yy"
    { (yyval.item)= new Item_func_not(new Item_func_like((yyvsp[(1) - (5)].item),(yyvsp[(4) - (5)].item),(yyvsp[(5) - (5)].item), Lex->escape_used)); }
    break;

  case 358:
#line 2848 "sql_yacc.yy"
    { (yyval.item)= new Item_func_plus((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 359:
#line 2850 "sql_yacc.yy"
    { (yyval.item)= new Item_func_minus((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 360:
#line 2852 "sql_yacc.yy"
    { (yyval.item)= new Item_date_add_interval((yyvsp[(1) - (5)].item),(yyvsp[(4) - (5)].item),(yyvsp[(5) - (5)].interval),0); }
    break;

  case 361:
#line 2854 "sql_yacc.yy"
    { (yyval.item)= new Item_date_add_interval((yyvsp[(1) - (5)].item),(yyvsp[(4) - (5)].item),(yyvsp[(5) - (5)].interval),1); }
    break;

  case 362:
#line 2856 "sql_yacc.yy"
    { (yyval.item)= new Item_func_mul((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 363:
#line 2858 "sql_yacc.yy"
    { (yyval.item)= new Item_func_div((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 364:
#line 2860 "sql_yacc.yy"
    { (yyval.item)= new Item_func_mod((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 365:
#line 2862 "sql_yacc.yy"
    { (yyval.item)= new Item_func_int_div((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 366:
#line 2864 "sql_yacc.yy"
    { (yyval.item)= new Item_func_mod((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 371:
#line 2881 "sql_yacc.yy"
    { (yyval.boolfunc2creator) = &comp_eq_creator; }
    break;

  case 372:
#line 2882 "sql_yacc.yy"
    { (yyval.boolfunc2creator) = &comp_ge_creator; }
    break;

  case 373:
#line 2883 "sql_yacc.yy"
    { (yyval.boolfunc2creator) = &comp_gt_creator; }
    break;

  case 374:
#line 2884 "sql_yacc.yy"
    { (yyval.boolfunc2creator) = &comp_le_creator; }
    break;

  case 375:
#line 2885 "sql_yacc.yy"
    { (yyval.boolfunc2creator) = &comp_lt_creator; }
    break;

  case 376:
#line 2886 "sql_yacc.yy"
    { (yyval.boolfunc2creator) = &comp_ne_creator; }
    break;

  case 377:
#line 2890 "sql_yacc.yy"
    { (yyval.num) = 1; }
    break;

  case 378:
#line 2891 "sql_yacc.yy"
    { (yyval.num) = 0; }
    break;

  case 384:
#line 2901 "sql_yacc.yy"
    {
            Session *session= YYSession;
            Item *i1= new (session->mem_root) Item_string((yyvsp[(3) - (3)].lex_str).str,
                                                      (yyvsp[(3) - (3)].lex_str).length,
                                                      session->charset());
            (yyval.item)= new (session->mem_root) Item_func_set_collation((yyvsp[(1) - (3)].item), i1);
          }
    break;

  case 388:
#line 2911 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(2) - (2)].item); }
    break;

  case 389:
#line 2913 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_neg((yyvsp[(2) - (2)].item)); }
    break;

  case 390:
#line 2915 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_singlerow_subselect((yyvsp[(2) - (3)].select_lex));
          }
    break;

  case 391:
#line 2918 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(2) - (3)].item); }
    break;

  case 392:
#line 2920 "sql_yacc.yy"
    {
            (yyvsp[(4) - (5)].item_list)->push_front((yyvsp[(2) - (5)].item));
            (yyval.item)= new (YYSession->mem_root) Item_row(*(yyvsp[(4) - (5)].item_list));
          }
    break;

  case 393:
#line 2925 "sql_yacc.yy"
    {
            (yyvsp[(5) - (6)].item_list)->push_front((yyvsp[(3) - (6)].item));
            (yyval.item)= new (YYSession->mem_root) Item_row(*(yyvsp[(5) - (6)].item_list));
          }
    break;

  case 394:
#line 2930 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_exists_subselect((yyvsp[(3) - (4)].select_lex));
          }
    break;

  case 395:
#line 2933 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(3) - (4)].item); }
    break;

  case 396:
#line 2935 "sql_yacc.yy"
    {
            (yyval.item)= create_func_cast(YYSession, (yyvsp[(2) - (2)].item), ITEM_CAST_CHAR, NULL, NULL,
                                 &my_charset_bin);
          }
    break;

  case 397:
#line 2940 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            (yyval.item)= create_func_cast(YYSession, (yyvsp[(3) - (6)].item), (yyvsp[(5) - (6)].cast_type), lex->length, lex->dec,
                                 lex->charset);
            if (!(yyval.item))
              DRIZZLE_YYABORT;
          }
    break;

  case 398:
#line 2948 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_case(* (yyvsp[(3) - (5)].item_list), (yyvsp[(2) - (5)].item), (yyvsp[(4) - (5)].item) ); }
    break;

  case 399:
#line 2950 "sql_yacc.yy"
    {
            (yyval.item)= create_func_cast(YYSession, (yyvsp[(3) - (6)].item), (yyvsp[(5) - (6)].cast_type), Lex->length, Lex->dec,
                                 Lex->charset);
            if (!(yyval.item))
              DRIZZLE_YYABORT;
          }
    break;

  case 400:
#line 2957 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_default_value(Lex->current_context(),
                                                         (yyvsp[(3) - (4)].item));
          }
    break;

  case 401:
#line 2962 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_insert_value(Lex->current_context(),
                                                        (yyvsp[(3) - (4)].item));
          }
    break;

  case 402:
#line 2968 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(5) - (5)].item),(yyvsp[(2) - (5)].item),(yyvsp[(3) - (5)].interval),0); }
    break;

  case 403:
#line 2979 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_char(*(yyvsp[(3) - (4)].item_list)); }
    break;

  case 404:
#line 2981 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_func_current_user(Lex->current_context());
          }
    break;

  case 405:
#line 2985 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_typecast((yyvsp[(3) - (4)].item)); }
    break;

  case 406:
#line 2987 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_dayofmonth((yyvsp[(3) - (4)].item)); }
    break;

  case 407:
#line 2989 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_hour((yyvsp[(3) - (4)].item)); }
    break;

  case 408:
#line 2991 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_insert((yyvsp[(3) - (10)].item),(yyvsp[(5) - (10)].item),(yyvsp[(7) - (10)].item),(yyvsp[(9) - (10)].item)); }
    break;

  case 409:
#line 2993 "sql_yacc.yy"
    {
            Session *session= YYSession;
            List<Item> *list= new (session->mem_root) List<Item>;
            list->push_front((yyvsp[(5) - (6)].item));
            list->push_front((yyvsp[(3) - (6)].item));
            Item_row *item= new (session->mem_root) Item_row(*list);
            (yyval.item)= new (session->mem_root) Item_func_interval(item);
          }
    break;

  case 410:
#line 3002 "sql_yacc.yy"
    {
            Session *session= YYSession;
            (yyvsp[(7) - (8)].item_list)->push_front((yyvsp[(5) - (8)].item));
            (yyvsp[(7) - (8)].item_list)->push_front((yyvsp[(3) - (8)].item));
            Item_row *item= new (session->mem_root) Item_row(*(yyvsp[(7) - (8)].item_list));
            (yyval.item)= new (session->mem_root) Item_func_interval(item);
          }
    break;

  case 411:
#line 3010 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_left((yyvsp[(3) - (6)].item),(yyvsp[(5) - (6)].item)); }
    break;

  case 412:
#line 3012 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_minute((yyvsp[(3) - (4)].item)); }
    break;

  case 413:
#line 3014 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_month((yyvsp[(3) - (4)].item)); }
    break;

  case 414:
#line 3016 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_right((yyvsp[(3) - (6)].item),(yyvsp[(5) - (6)].item)); }
    break;

  case 415:
#line 3018 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_second((yyvsp[(3) - (4)].item)); }
    break;

  case 416:
#line 3020 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_datetime_typecast((yyvsp[(3) - (4)].item)); }
    break;

  case 417:
#line 3022 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_trim((yyvsp[(3) - (4)].item)); }
    break;

  case 418:
#line 3024 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_ltrim((yyvsp[(6) - (7)].item),(yyvsp[(4) - (7)].item)); }
    break;

  case 419:
#line 3026 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_rtrim((yyvsp[(6) - (7)].item),(yyvsp[(4) - (7)].item)); }
    break;

  case 420:
#line 3028 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_trim((yyvsp[(6) - (7)].item),(yyvsp[(4) - (7)].item)); }
    break;

  case 421:
#line 3030 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_ltrim((yyvsp[(5) - (6)].item)); }
    break;

  case 422:
#line 3032 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_rtrim((yyvsp[(5) - (6)].item)); }
    break;

  case 423:
#line 3034 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_trim((yyvsp[(5) - (6)].item)); }
    break;

  case 424:
#line 3036 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_trim((yyvsp[(5) - (6)].item),(yyvsp[(3) - (6)].item)); }
    break;

  case 425:
#line 3038 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_func_user();
          }
    break;

  case 426:
#line 3042 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_year((yyvsp[(3) - (4)].item)); }
    break;

  case 427:
#line 3058 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(3) - (6)].item), (yyvsp[(5) - (6)].item),
                                                             INTERVAL_DAY, 0);
          }
    break;

  case 428:
#line 3063 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(3) - (8)].item), (yyvsp[(6) - (8)].item), (yyvsp[(7) - (8)].interval), 0); }
    break;

  case 429:
#line 3065 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_func_curdate_local();
          }
    break;

  case 430:
#line 3069 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(3) - (8)].item),(yyvsp[(6) - (8)].item),(yyvsp[(7) - (8)].interval),0); }
    break;

  case 431:
#line 3071 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(3) - (8)].item),(yyvsp[(6) - (8)].item),(yyvsp[(7) - (8)].interval),1); }
    break;

  case 432:
#line 3073 "sql_yacc.yy"
    { (yyval.item)=new (YYSession->mem_root) Item_extract( (yyvsp[(3) - (6)].interval), (yyvsp[(5) - (6)].item)); }
    break;

  case 433:
#line 3075 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_func_now_local();
          }
    break;

  case 434:
#line 3079 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_func_now_local((yyvsp[(3) - (4)].item));
          }
    break;

  case 435:
#line 3083 "sql_yacc.yy"
    { (yyval.item) = new (YYSession->mem_root) Item_func_locate((yyvsp[(5) - (6)].item),(yyvsp[(3) - (6)].item)); }
    break;

  case 436:
#line 3085 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(3) - (6)].item), (yyvsp[(5) - (6)].item),
                                                             INTERVAL_DAY, 1);
          }
    break;

  case 437:
#line 3090 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(3) - (8)].item), (yyvsp[(6) - (8)].item), (yyvsp[(7) - (8)].interval), 1); }
    break;

  case 438:
#line 3092 "sql_yacc.yy"
    {
            std::string reverse_str("substr");
            List<Item> *args= new (YYSession->mem_root) List<Item>;
            args->push_back((yyvsp[(3) - (8)].item));
            args->push_back((yyvsp[(5) - (8)].item));
            args->push_back((yyvsp[(7) - (8)].item));
            if (! ((yyval.item)= reserved_keyword_function(reverse_str, args)))
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 439:
#line 3104 "sql_yacc.yy"
    {
            std::string reverse_str("substr");
            List<Item> *args= new (YYSession->mem_root) List<Item>;
            args->push_back((yyvsp[(3) - (6)].item));
            args->push_back((yyvsp[(5) - (6)].item));
            if (! ((yyval.item)= reserved_keyword_function(reverse_str, args)))
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 440:
#line 3115 "sql_yacc.yy"
    {
            std::string reverse_str("substr");
            List<Item> *args= new (YYSession->mem_root) List<Item>;
            args->push_back((yyvsp[(3) - (8)].item));
            args->push_back((yyvsp[(5) - (8)].item));
            args->push_back((yyvsp[(7) - (8)].item));
            if (! ((yyval.item)= reserved_keyword_function(reverse_str, args)))
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 441:
#line 3127 "sql_yacc.yy"
    {
            std::string reverse_str("substr");
            List<Item> *args= new (YYSession->mem_root) List<Item>;
            args->push_back((yyvsp[(3) - (6)].item));
            args->push_back((yyvsp[(5) - (6)].item));
            if (! ((yyval.item)= reserved_keyword_function(reverse_str, args)))
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 442:
#line 3138 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_sysdate_local(); }
    break;

  case 443:
#line 3140 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_sysdate_local((yyvsp[(3) - (4)].item)); }
    break;

  case 444:
#line 3142 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(7) - (8)].item),(yyvsp[(5) - (8)].item),(yyvsp[(3) - (8)].interval_time_st),0); }
    break;

  case 445:
#line 3144 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_timestamp_diff((yyvsp[(5) - (8)].item),(yyvsp[(7) - (8)].item),(yyvsp[(3) - (8)].interval_time_st)); }
    break;

  case 446:
#line 3146 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_func_curdate_utc();
          }
    break;

  case 447:
#line 3150 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_func_now_utc();
          }
    break;

  case 448:
#line 3162 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_coalesce(* (yyvsp[(3) - (4)].item_list)); }
    break;

  case 449:
#line 3164 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_collation((yyvsp[(3) - (4)].item)); }
    break;

  case 450:
#line 3166 "sql_yacc.yy"
    {
            std::string database_str("database");
            if (! ((yyval.item)= reserved_keyword_function(database_str, NULL)))
            {
              DRIZZLE_YYABORT;
            }
	  }
    break;

  case 451:
#line 3174 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_if((yyvsp[(3) - (8)].item),(yyvsp[(5) - (8)].item),(yyvsp[(7) - (8)].item)); }
    break;

  case 452:
#line 3176 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_microsecond((yyvsp[(3) - (4)].item)); }
    break;

  case 453:
#line 3178 "sql_yacc.yy"
    { (yyval.item) = new (YYSession->mem_root) Item_func_mod( (yyvsp[(3) - (6)].item), (yyvsp[(5) - (6)].item)); }
    break;

  case 454:
#line 3180 "sql_yacc.yy"
    { (yyval.item) = new (YYSession->mem_root) Item_func_quarter((yyvsp[(3) - (4)].item)); }
    break;

  case 455:
#line 3182 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_repeat((yyvsp[(3) - (6)].item),(yyvsp[(5) - (6)].item)); }
    break;

  case 456:
#line 3184 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_replace((yyvsp[(3) - (8)].item),(yyvsp[(5) - (8)].item),(yyvsp[(7) - (8)].item)); }
    break;

  case 457:
#line 3186 "sql_yacc.yy"
    {
            std::string reverse_str("reverse");
            List<Item> *args= new (YYSession->mem_root) List<Item>;
            args->push_back((yyvsp[(3) - (4)].item));
            if (! ((yyval.item)= reserved_keyword_function(reverse_str, args)))
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 458:
#line 3196 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_round((yyvsp[(3) - (6)].item),(yyvsp[(5) - (6)].item),1); }
    break;

  case 459:
#line 3209 "sql_yacc.yy"
    {
            const plugin::Function *udf= plugin::Function::get((yyvsp[(1) - (2)].lex_str).str, (yyvsp[(1) - (2)].lex_str).length);

            /* Temporary placing the result of getFunction in $3 */
            (yyval.udf)= udf;
          }
    break;

  case 460:
#line 3216 "sql_yacc.yy"
    {
            Session *session= YYSession;
            Create_func *builder;
            Item *item= NULL;

            /*
              Implementation note:
              names are resolved with the following order:
              - MySQL native functions,
              - User Defined Functions,
              - Stored Functions (assuming the current <use> database)

              This will be revised with WL#2128 (SQL PATH)
            */
            builder= find_native_function_builder((yyvsp[(1) - (5)].lex_str));
            if (builder)
            {
              item= builder->create(session, (yyvsp[(1) - (5)].lex_str), (yyvsp[(4) - (5)].item_list));
            }
            else
            {
              /* Retrieving the result of service::Function::get */
              const plugin::Function *udf= (yyvsp[(3) - (5)].udf);
              if (udf)
              {
                item= Create_udf_func::s_singleton.create(session, udf, (yyvsp[(4) - (5)].item_list));
              } else {
                /* fix for bug 250065, from Andrew Garner <muzazzi@gmail.com> */
                my_error(ER_SP_DOES_NOT_EXIST, MYF(0), "FUNCTION", (yyvsp[(1) - (5)].lex_str).str);
              }
            }

            if (! ((yyval.item)= item))
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 461:
#line 3256 "sql_yacc.yy"
    { (yyval.item_list)= NULL; }
    break;

  case 462:
#line 3257 "sql_yacc.yy"
    { (yyval.item_list)= (yyvsp[(1) - (1)].item_list); }
    break;

  case 463:
#line 3262 "sql_yacc.yy"
    {
            (yyval.item_list)= new (YYSession->mem_root) List<Item>;
            (yyval.item_list)->push_back((yyvsp[(1) - (1)].item));
          }
    break;

  case 464:
#line 3267 "sql_yacc.yy"
    {
            (yyvsp[(1) - (3)].item_list)->push_back((yyvsp[(3) - (3)].item));
            (yyval.item_list)= (yyvsp[(1) - (3)].item_list);
          }
    break;

  case 465:
#line 3275 "sql_yacc.yy"
    {
            /*
             Use Item::name as a storage for the attribute value of user
             defined function argument. It is safe to use Item::name
             because the syntax will not allow having an explicit name here.
             See WL#1017 re. udf attributes.
            */
            if ((yyvsp[(4) - (4)].lex_str).str)
            {
              (yyvsp[(2) - (4)].item)->is_autogenerated_name= false;
              (yyvsp[(2) - (4)].item)->set_name((yyvsp[(4) - (4)].lex_str).str, (yyvsp[(4) - (4)].lex_str).length, system_charset_info);
            }
            else
              (yyvsp[(2) - (4)].item)->set_name((yyvsp[(1) - (4)].simple_string), (uint) ((yyvsp[(3) - (4)].simple_string) - (yyvsp[(1) - (4)].simple_string)), YYSession->charset());
            (yyval.item)= (yyvsp[(2) - (4)].item);
          }
    break;

  case 466:
#line 3295 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_avg((yyvsp[(3) - (4)].item)); }
    break;

  case 467:
#line 3297 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_avg_distinct((yyvsp[(4) - (5)].item)); }
    break;

  case 468:
#line 3299 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_count(new Item_int((int32_t) 0L,1)); }
    break;

  case 469:
#line 3301 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_count((yyvsp[(3) - (4)].item)); }
    break;

  case 470:
#line 3303 "sql_yacc.yy"
    { Lex->current_select->in_sum_expr++; }
    break;

  case 471:
#line 3305 "sql_yacc.yy"
    { Lex->current_select->in_sum_expr--; }
    break;

  case 472:
#line 3307 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_count_distinct(* (yyvsp[(5) - (7)].item_list)); }
    break;

  case 473:
#line 3309 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_min((yyvsp[(3) - (4)].item)); }
    break;

  case 474:
#line 3316 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_min((yyvsp[(4) - (5)].item)); }
    break;

  case 475:
#line 3318 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_max((yyvsp[(3) - (4)].item)); }
    break;

  case 476:
#line 3320 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_max((yyvsp[(4) - (5)].item)); }
    break;

  case 477:
#line 3322 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_std((yyvsp[(3) - (4)].item), 0); }
    break;

  case 478:
#line 3324 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_variance((yyvsp[(3) - (4)].item), 0); }
    break;

  case 479:
#line 3326 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_std((yyvsp[(3) - (4)].item), 1); }
    break;

  case 480:
#line 3328 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_variance((yyvsp[(3) - (4)].item), 1); }
    break;

  case 481:
#line 3330 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_sum((yyvsp[(3) - (4)].item)); }
    break;

  case 482:
#line 3332 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_sum_distinct((yyvsp[(4) - (5)].item)); }
    break;

  case 483:
#line 3334 "sql_yacc.yy"
    { Lex->current_select->in_sum_expr++; }
    break;

  case 484:
#line 3338 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->in_sum_expr--;
            (yyval.item)=new Item_func_group_concat(Lex->current_context(), (yyvsp[(3) - (8)].num), (yyvsp[(5) - (8)].item_list),
                                          sel->gorder_list, (yyvsp[(7) - (8)].string));
            (yyvsp[(5) - (8)].item_list)->empty();
          }
    break;

  case 485:
#line 3349 "sql_yacc.yy"
    { }
    break;

  case 486:
#line 3351 "sql_yacc.yy"
    {
            (yyval.item)= (yyvsp[(3) - (3)].item);
          }
    break;

  case 487:
#line 3358 "sql_yacc.yy"
    {
            (yyval.item)= new Item_func_set_user_var((yyvsp[(1) - (3)].lex_str), (yyvsp[(3) - (3)].item));
          }
    break;

  case 488:
#line 3362 "sql_yacc.yy"
    {
            (yyval.item)= new Item_func_get_user_var((yyvsp[(1) - (1)].lex_str));
          }
    break;

  case 489:
#line 3366 "sql_yacc.yy"
    {
            /* disallow "SELECT @@global.global.variable" */
            if ((yyvsp[(3) - (4)].lex_str).str && (yyvsp[(4) - (4)].lex_str).str && check_reserved_words(&(yyvsp[(3) - (4)].lex_str)))
            {
              my_parse_error(ER(ER_SYNTAX_ERROR));
              DRIZZLE_YYABORT;
            }
            if (!((yyval.item)= get_system_var(YYSession, (yyvsp[(2) - (4)].var_type), (yyvsp[(3) - (4)].lex_str), (yyvsp[(4) - (4)].lex_str))))
              DRIZZLE_YYABORT;
          }
    break;

  case 490:
#line 3379 "sql_yacc.yy"
    { (yyval.num) = 0; }
    break;

  case 491:
#line 3380 "sql_yacc.yy"
    { (yyval.num) = 1; }
    break;

  case 492:
#line 3385 "sql_yacc.yy"
    {
              (yyval.string)= new (YYSession->mem_root) String(",", 1, &my_charset_utf8_general_ci);
            }
    break;

  case 493:
#line 3388 "sql_yacc.yy"
    { (yyval.string) = (yyvsp[(2) - (2)].string); }
    break;

  case 494:
#line 3393 "sql_yacc.yy"
    {
            Lex->current_select->gorder_list = NULL;
          }
    break;

  case 495:
#line 3397 "sql_yacc.yy"
    {
            Select_Lex *select= Lex->current_select;
            select->gorder_list=
              (SQL_LIST*) memory::sql_memdup((char*) &select->order_list,
                                     sizeof(st_sql_list));
            select->order_list.empty();
          }
    break;

  case 496:
#line 3408 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (lex->current_select->inc_in_sum_expr())
            {
              my_parse_error(ER(ER_SYNTAX_ERROR));
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 497:
#line 3417 "sql_yacc.yy"
    {
            Lex->current_select->in_sum_expr--;
            (yyval.item)= (yyvsp[(3) - (3)].item);
          }
    break;

  case 498:
#line 3425 "sql_yacc.yy"
    { (yyval.cast_type)=ITEM_CAST_CHAR; Lex->charset= &my_charset_bin; Lex->dec= 0; }
    break;

  case 499:
#line 3427 "sql_yacc.yy"
    { (yyval.cast_type)=ITEM_CAST_CHAR; Lex->dec= 0; }
    break;

  case 500:
#line 3429 "sql_yacc.yy"
    { (yyval.cast_type)=ITEM_CAST_DATE; Lex->charset= NULL; Lex->dec=Lex->length= (char*)0; }
    break;

  case 501:
#line 3431 "sql_yacc.yy"
    { (yyval.cast_type)=ITEM_CAST_DATETIME; Lex->charset= NULL; Lex->dec=Lex->length= (char*)0; }
    break;

  case 502:
#line 3433 "sql_yacc.yy"
    { (yyval.cast_type)=ITEM_CAST_DECIMAL; Lex->charset= NULL; }
    break;

  case 503:
#line 3438 "sql_yacc.yy"
    {
            (yyval.item_list)= new (YYSession->mem_root) List<Item>;
            (yyval.item_list)->push_back((yyvsp[(1) - (1)].item));
          }
    break;

  case 504:
#line 3443 "sql_yacc.yy"
    {
            (yyvsp[(1) - (3)].item_list)->push_back((yyvsp[(3) - (3)].item));
            (yyval.item_list)= (yyvsp[(1) - (3)].item_list);
          }
    break;

  case 505:
#line 3450 "sql_yacc.yy"
    { (yyval.item)= NULL; }
    break;

  case 506:
#line 3451 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(1) - (1)].item); }
    break;

  case 507:
#line 3455 "sql_yacc.yy"
    { (yyval.item)= NULL; }
    break;

  case 508:
#line 3456 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(2) - (2)].item); }
    break;

  case 509:
#line 3461 "sql_yacc.yy"
    {
            (yyval.item_list)= new List<Item>;
            (yyval.item_list)->push_back((yyvsp[(2) - (4)].item));
            (yyval.item_list)->push_back((yyvsp[(4) - (4)].item));
          }
    break;

  case 510:
#line 3467 "sql_yacc.yy"
    {
            (yyvsp[(1) - (5)].item_list)->push_back((yyvsp[(3) - (5)].item));
            (yyvsp[(1) - (5)].item_list)->push_back((yyvsp[(5) - (5)].item));
            (yyval.item_list)= (yyvsp[(1) - (5)].item_list);
          }
    break;

  case 511:
#line 3477 "sql_yacc.yy"
    { (yyval.table_list)=(yyvsp[(1) - (1)].table_list); }
    break;

  case 512:
#line 3479 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (!((yyval.table_list)= lex->current_select->nest_last_join(lex->session)))
              DRIZZLE_YYABORT;
          }
    break;

  case 513:
#line 3487 "sql_yacc.yy"
    { DRIZZLE_YYABORT_UNLESS((yyval.table_list)=(yyvsp[(1) - (1)].table_list)); }
    break;

  case 514:
#line 3498 "sql_yacc.yy"
    { (yyval.table_list)=(yyvsp[(1) - (1)].table_list); }
    break;

  case 515:
#line 3499 "sql_yacc.yy"
    { (yyval.table_list)=(yyvsp[(3) - (4)].table_list); }
    break;

  case 516:
#line 3505 "sql_yacc.yy"
    { (yyval.table_list)=(yyvsp[(1) - (1)].table_list); }
    break;

  case 517:
#line 3507 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (3)].table_list) && ((yyval.table_list)=(yyvsp[(3) - (3)].table_list)));
          }
    break;

  case 518:
#line 3527 "sql_yacc.yy"
    { DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (3)].table_list) && ((yyval.table_list)=(yyvsp[(3) - (3)].table_list))); }
    break;

  case 519:
#line 3529 "sql_yacc.yy"
    { DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (3)].table_list) && ((yyval.table_list)=(yyvsp[(3) - (3)].table_list))); (yyvsp[(3) - (3)].table_list)->straight=1; }
    break;

  case 520:
#line 3532 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (4)].table_list) && (yyvsp[(3) - (4)].table_list));
            /* Change the current name resolution context to a local context. */
            if (push_new_name_resolution_context(YYSession, (yyvsp[(1) - (4)].table_list), (yyvsp[(3) - (4)].table_list)))
              DRIZZLE_YYABORT;
            Lex->current_select->parsing_place= IN_ON;
          }
    break;

  case 521:
#line 3540 "sql_yacc.yy"
    {
            add_join_on((yyvsp[(3) - (6)].table_list),(yyvsp[(6) - (6)].item));
            Lex->pop_context();
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 522:
#line 3547 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (4)].table_list) && (yyvsp[(3) - (4)].table_list));
            /* Change the current name resolution context to a local context. */
            if (push_new_name_resolution_context(YYSession, (yyvsp[(1) - (4)].table_list), (yyvsp[(3) - (4)].table_list)))
              DRIZZLE_YYABORT;
            Lex->current_select->parsing_place= IN_ON;
          }
    break;

  case 523:
#line 3555 "sql_yacc.yy"
    {
            (yyvsp[(3) - (6)].table_list)->straight=1;
            add_join_on((yyvsp[(3) - (6)].table_list),(yyvsp[(6) - (6)].item));
            Lex->pop_context();
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 524:
#line 3563 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (4)].table_list) && (yyvsp[(3) - (4)].table_list));
          }
    break;

  case 525:
#line 3567 "sql_yacc.yy"
    { add_join_natural((yyvsp[(1) - (8)].table_list),(yyvsp[(3) - (8)].table_list),(yyvsp[(7) - (8)].string_list),Lex->current_select); (yyval.table_list)=(yyvsp[(3) - (8)].table_list); }
    break;

  case 526:
#line 3569 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (4)].table_list) && ((yyval.table_list)=(yyvsp[(4) - (4)].table_list)));
            add_join_natural((yyvsp[(1) - (4)].table_list),(yyvsp[(4) - (4)].table_list),NULL,Lex->current_select);
          }
    break;

  case 527:
#line 3577 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (6)].table_list) && (yyvsp[(5) - (6)].table_list));
            /* Change the current name resolution context to a local context. */
            if (push_new_name_resolution_context(YYSession, (yyvsp[(1) - (6)].table_list), (yyvsp[(5) - (6)].table_list)))
              DRIZZLE_YYABORT;
            Lex->current_select->parsing_place= IN_ON;
          }
    break;

  case 528:
#line 3585 "sql_yacc.yy"
    {
            add_join_on((yyvsp[(5) - (8)].table_list),(yyvsp[(8) - (8)].item));
            Lex->pop_context();
            (yyvsp[(5) - (8)].table_list)->outer_join|=JOIN_TYPE_LEFT;
            (yyval.table_list)=(yyvsp[(5) - (8)].table_list);
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 529:
#line 3593 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (5)].table_list) && (yyvsp[(5) - (5)].table_list));
          }
    break;

  case 530:
#line 3597 "sql_yacc.yy"
    {
            add_join_natural((yyvsp[(1) - (10)].table_list),(yyvsp[(5) - (10)].table_list),(yyvsp[(9) - (10)].string_list),Lex->current_select);
            (yyvsp[(5) - (10)].table_list)->outer_join|=JOIN_TYPE_LEFT;
            (yyval.table_list)=(yyvsp[(5) - (10)].table_list);
          }
    break;

  case 531:
#line 3603 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (6)].table_list) && (yyvsp[(6) - (6)].table_list));
            add_join_natural((yyvsp[(1) - (6)].table_list),(yyvsp[(6) - (6)].table_list),NULL,Lex->current_select);
            (yyvsp[(6) - (6)].table_list)->outer_join|=JOIN_TYPE_LEFT;
            (yyval.table_list)=(yyvsp[(6) - (6)].table_list);
          }
    break;

  case 532:
#line 3613 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (6)].table_list) && (yyvsp[(5) - (6)].table_list));
            /* Change the current name resolution context to a local context. */
            if (push_new_name_resolution_context(YYSession, (yyvsp[(1) - (6)].table_list), (yyvsp[(5) - (6)].table_list)))
              DRIZZLE_YYABORT;
            Lex->current_select->parsing_place= IN_ON;
          }
    break;

  case 533:
#line 3621 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (!((yyval.table_list)= lex->current_select->convert_right_join()))
              DRIZZLE_YYABORT;
            add_join_on((yyval.table_list), (yyvsp[(8) - (8)].item));
            Lex->pop_context();
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 534:
#line 3630 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (5)].table_list) && (yyvsp[(5) - (5)].table_list));
          }
    break;

  case 535:
#line 3634 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (!((yyval.table_list)= lex->current_select->convert_right_join()))
              DRIZZLE_YYABORT;
            add_join_natural((yyval.table_list),(yyvsp[(5) - (10)].table_list),(yyvsp[(9) - (10)].string_list),Lex->current_select);
          }
    break;

  case 536:
#line 3641 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (6)].table_list) && (yyvsp[(6) - (6)].table_list));
            add_join_natural((yyvsp[(6) - (6)].table_list),(yyvsp[(1) - (6)].table_list),NULL,Lex->current_select);
            LEX *lex= Lex;
            if (!((yyval.table_list)= lex->current_select->convert_right_join()))
              DRIZZLE_YYABORT;
          }
    break;

  case 537:
#line 3651 "sql_yacc.yy"
    {}
    break;

  case 538:
#line 3652 "sql_yacc.yy"
    {}
    break;

  case 539:
#line 3653 "sql_yacc.yy"
    {}
    break;

  case 540:
#line 3665 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->table_join_options= 0;
          }
    break;

  case 541:
#line 3670 "sql_yacc.yy"
    {
            if (!((yyval.table_list)= Lex->current_select->add_table_to_list(YYSession, (yyvsp[(2) - (4)].table), (yyvsp[(3) - (4)].lex_str_ptr),
                             Lex->current_select->get_table_join_options(),
                             Lex->lock_option,
                             Lex->current_select->pop_index_hints())))
              DRIZZLE_YYABORT;
            Lex->current_select->add_joined_table((yyval.table_list));
          }
    break;

  case 542:
#line 3679 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            Select_Lex *sel= lex->current_select;
            if ((yyvsp[(1) - (3)].num))
            {
              if (sel->set_braces(1))
              {
                my_parse_error(ER(ER_SYNTAX_ERROR));
                DRIZZLE_YYABORT;
              }
              /* select in braces, can't contain global parameters */
              if (sel->master_unit()->fake_select_lex)
                sel->master_unit()->global_parameters=
                   sel->master_unit()->fake_select_lex;
            }
            if ((yyvsp[(2) - (3)].select_lex)->init_nested_join(lex->session))
              DRIZZLE_YYABORT;
            (yyval.table_list)= 0;
            /* incomplete derived tables return NULL, we must be
               nested in select_derived rule to be here. */
          }
    break;

  case 543:
#line 3719 "sql_yacc.yy"
    {
            /* Use $2 instead of Lex->current_select as derived table will
               alter value of Lex->current_select. */
            if (!((yyvsp[(3) - (5)].table_list) || (yyvsp[(5) - (5)].lex_str_ptr)) && (yyvsp[(2) - (5)].select_lex)->embedding &&
                !(yyvsp[(2) - (5)].select_lex)->embedding->nested_join->join_list.elements)
            {
              /* we have a derived table ($3 == NULL) but no alias,
                 Since we are nested in further parentheses so we
                 can pass NULL to the outer level parentheses
                 Permits parsing of "((((select ...))) as xyz)" */
              (yyval.table_list)= 0;
            }
            else if (!(yyvsp[(3) - (5)].table_list))
            {
              /* Handle case of derived table, alias may be NULL if there
                 are no outer parentheses, add_table_to_list() will throw
                 error in this case */
              LEX *lex=Lex;
              Select_Lex *sel= lex->current_select;
              Select_Lex_Unit *unit= sel->master_unit();
              lex->current_select= sel= unit->outer_select();
              if (!((yyval.table_list)= sel->add_table_to_list(lex->session,
                                               new Table_ident(unit), (yyvsp[(5) - (5)].lex_str_ptr), 0,
                                               TL_READ)))

                DRIZZLE_YYABORT;
              sel->add_joined_table((yyval.table_list));
              lex->pop_context();
            }
            else if (((yyvsp[(3) - (5)].table_list)->select_lex && (yyvsp[(3) - (5)].table_list)->select_lex->master_unit()->is_union()) || (yyvsp[(5) - (5)].lex_str_ptr))
            {
              /* simple nested joins cannot have aliases or unions */
              my_parse_error(ER(ER_SYNTAX_ERROR));
              DRIZZLE_YYABORT;
            }
            else
              (yyval.table_list)= (yyvsp[(3) - (5)].table_list);
          }
    break;

  case 545:
#line 3764 "sql_yacc.yy"
    {
            if (add_select_to_union_list(Lex, (bool)(yyvsp[(3) - (3)].num)))
              DRIZZLE_YYABORT;
          }
    break;

  case 546:
#line 3769 "sql_yacc.yy"
    {
            /*
              Remove from the name resolution context stack the context of the
              last select in the union.
             */
            Lex->pop_context();
          }
    break;

  case 548:
#line 3782 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            Select_Lex * sel= lex->current_select;
            if (lex->current_select->set_braces(0))
            {
              my_parse_error(ER(ER_SYNTAX_ERROR));
              DRIZZLE_YYABORT;
            }
            if (sel->linkage == UNION_TYPE &&
                sel->master_unit()->first_select()->braces)
            {
              my_parse_error(ER(ER_SYNTAX_ERROR));
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 549:
#line 3801 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            Select_Lex *sel= lex->current_select;
            if (sel->linkage != UNION_TYPE)
              mysql_init_select(lex);
            lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 550:
#line 3809 "sql_yacc.yy"
    {
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 552:
#line 3818 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if ((yyvsp[(1) - (1)].select_lex)->init_nested_join(lex->session))
              DRIZZLE_YYABORT;
          }
    break;

  case 553:
#line 3824 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            /* for normal joins, $3 != NULL and end_nested_join() != NULL,
               for derived tables, both must equal NULL */

            if (!((yyval.table_list)= (yyvsp[(1) - (3)].select_lex)->end_nested_join(lex->session)) && (yyvsp[(3) - (3)].table_list))
              DRIZZLE_YYABORT;
            if (!(yyvsp[(3) - (3)].table_list) && (yyval.table_list))
            {
              my_parse_error(ER(ER_SYNTAX_ERROR));
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 554:
#line 3840 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->derived_tables|= DERIVED_SUBQUERY;
            if (!lex->expr_allows_subselect)
            {
              my_parse_error(ER(ER_SYNTAX_ERROR));
              DRIZZLE_YYABORT;
            }
            if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE ||
                mysql_new_select(lex, 1))
              DRIZZLE_YYABORT;
            mysql_init_select(lex);
            lex->current_select->linkage= DERIVED_TABLE_TYPE;
            lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 555:
#line 3856 "sql_yacc.yy"
    {
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 557:
#line 3863 "sql_yacc.yy"
    { (yyval.select_lex)= Lex->current_select; }
    break;

  case 558:
#line 3868 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            Select_Lex *sel= lex->current_select;
            TableList *embedding;
            if (!sel->embedding || sel->end_nested_join(lex->session))
            {
              /* we are not in parentheses */
              my_parse_error(ER(ER_SYNTAX_ERROR));
              DRIZZLE_YYABORT;
            }
            embedding= Lex->current_select->embedding;
            (yyval.num)= embedding &&
                !embedding->nested_join->join_list.elements;
            /* return true if we are deeply nested */
          }
    break;

  case 559:
#line 3887 "sql_yacc.yy"
    {}
    break;

  case 560:
#line 3888 "sql_yacc.yy"
    {}
    break;

  case 561:
#line 3893 "sql_yacc.yy"
    {
            (yyval.num)= INDEX_HINT_MASK_ALL;
          }
    break;

  case 562:
#line 3896 "sql_yacc.yy"
    { (yyval.num)= INDEX_HINT_MASK_JOIN;  }
    break;

  case 563:
#line 3897 "sql_yacc.yy"
    { (yyval.num)= INDEX_HINT_MASK_ORDER; }
    break;

  case 564:
#line 3898 "sql_yacc.yy"
    { (yyval.num)= INDEX_HINT_MASK_GROUP; }
    break;

  case 565:
#line 3902 "sql_yacc.yy"
    { (yyval.index_hint)= INDEX_HINT_FORCE; }
    break;

  case 566:
#line 3903 "sql_yacc.yy"
    { (yyval.index_hint)= INDEX_HINT_IGNORE; }
    break;

  case 567:
#line 3908 "sql_yacc.yy"
    {
            Lex->current_select->set_index_hint_type((yyvsp[(1) - (3)].index_hint), (yyvsp[(3) - (3)].num));
          }
    break;

  case 569:
#line 3913 "sql_yacc.yy"
    {
            Lex->current_select->set_index_hint_type(INDEX_HINT_USE, (yyvsp[(3) - (3)].num));
          }
    break;

  case 574:
#line 3926 "sql_yacc.yy"
    { Lex->current_select->alloc_index_hints(YYSession); }
    break;

  case 576:
#line 3930 "sql_yacc.yy"
    {  Lex->current_select->clear_index_hints(); }
    break;

  case 578:
#line 3935 "sql_yacc.yy"
    { Lex->current_select->add_index_hint(YYSession, NULL, 0); }
    break;

  case 579:
#line 3936 "sql_yacc.yy"
    {}
    break;

  case 580:
#line 3941 "sql_yacc.yy"
    { Lex->current_select->add_index_hint(YYSession, (yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length); }
    break;

  case 581:
#line 3943 "sql_yacc.yy"
    { Lex->current_select->add_index_hint(YYSession, (char *)"PRIMARY", 7); }
    break;

  case 584:
#line 3953 "sql_yacc.yy"
    {
            if (!((yyval.string_list)= new List<String>))
              DRIZZLE_YYABORT;
            (yyval.string_list)->push_back(new (YYSession->mem_root)
                              String((const char *) (yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length,
                                      system_charset_info));
          }
    break;

  case 585:
#line 3961 "sql_yacc.yy"
    {
            (yyvsp[(1) - (3)].string_list)->push_back(new (YYSession->mem_root)
                              String((const char *) (yyvsp[(3) - (3)].lex_str).str, (yyvsp[(3) - (3)].lex_str).length,
                                      system_charset_info));
            (yyval.string_list)= (yyvsp[(1) - (3)].string_list);
          }
    break;

  case 586:
#line 3970 "sql_yacc.yy"
    {}
    break;

  case 587:
#line 3971 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_DAY_HOUR; }
    break;

  case 588:
#line 3972 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_DAY_MICROSECOND; }
    break;

  case 589:
#line 3973 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_DAY_MINUTE; }
    break;

  case 590:
#line 3974 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_DAY_SECOND; }
    break;

  case 591:
#line 3975 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_HOUR_MICROSECOND; }
    break;

  case 592:
#line 3976 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_HOUR_MINUTE; }
    break;

  case 593:
#line 3977 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_HOUR_SECOND; }
    break;

  case 594:
#line 3978 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_MINUTE_MICROSECOND; }
    break;

  case 595:
#line 3979 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_MINUTE_SECOND; }
    break;

  case 596:
#line 3980 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_SECOND_MICROSECOND; }
    break;

  case 597:
#line 3981 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_YEAR_MONTH; }
    break;

  case 598:
#line 3985 "sql_yacc.yy"
    {}
    break;

  case 599:
#line 3986 "sql_yacc.yy"
    {
                                  (yyval.interval_time_st)=INTERVAL_MICROSECOND;
                                  /*
                                    FRAC_SECOND was mistakenly implemented with
                                    a wrong resolution. According to the ODBC
                                    standard it should be nanoseconds, not
                                    microseconds. Changing it to nanoseconds
                                    in MySQL would mean making TIMESTAMPDIFF
                                    and TIMESTAMPADD to return DECIMAL, since
                                    the return value would be too big for BIGINT
                                    Hence we just deprecate the incorrect
                                    implementation without changing its
                                    resolution.
                                  */
                                }
    break;

  case 600:
#line 4004 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_DAY; }
    break;

  case 601:
#line 4005 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_WEEK; }
    break;

  case 602:
#line 4006 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_HOUR; }
    break;

  case 603:
#line 4007 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_MINUTE; }
    break;

  case 604:
#line 4008 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_MONTH; }
    break;

  case 605:
#line 4009 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_QUARTER; }
    break;

  case 606:
#line 4010 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_SECOND; }
    break;

  case 607:
#line 4011 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_MICROSECOND; }
    break;

  case 608:
#line 4012 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_YEAR; }
    break;

  case 612:
#line 4022 "sql_yacc.yy"
    { (yyval.lex_str_ptr)=0; }
    break;

  case 613:
#line 4024 "sql_yacc.yy"
    { (yyval.lex_str_ptr)= (drizzled::LEX_STRING*) memory::sql_memdup(&(yyvsp[(2) - (2)].lex_str),sizeof(drizzled::LEX_STRING)); }
    break;

  case 616:
#line 4033 "sql_yacc.yy"
    { Lex->current_select->where= 0; }
    break;

  case 617:
#line 4035 "sql_yacc.yy"
    {
            Lex->current_select->parsing_place= IN_WHERE;
          }
    break;

  case 618:
#line 4039 "sql_yacc.yy"
    {
            Select_Lex *select= Lex->current_select;
            select->where= (yyvsp[(3) - (3)].item);
            select->parsing_place= NO_MATTER;
            if ((yyvsp[(3) - (3)].item))
              (yyvsp[(3) - (3)].item)->top_level_item();
          }
    break;

  case 620:
#line 4051 "sql_yacc.yy"
    {
            Lex->current_select->parsing_place= IN_HAVING;
          }
    break;

  case 621:
#line 4055 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->having= (yyvsp[(3) - (3)].item);
            sel->parsing_place= NO_MATTER;
            if ((yyvsp[(3) - (3)].item))
              (yyvsp[(3) - (3)].item)->top_level_item();
          }
    break;

  case 622:
#line 4066 "sql_yacc.yy"
    {
            Lex->escape_used= true;
            (yyval.item)= (yyvsp[(2) - (2)].item);
          }
    break;

  case 623:
#line 4071 "sql_yacc.yy"
    {
            Lex->escape_used= false;
            (yyval.item)= new Item_string("\\", 1, &my_charset_utf8_general_ci);
          }
    break;

  case 626:
#line 4088 "sql_yacc.yy"
    { if (YYSession->add_group_to_list((yyvsp[(3) - (4)].item),(bool) (yyvsp[(4) - (4)].num))) DRIZZLE_YYABORT; }
    break;

  case 627:
#line 4090 "sql_yacc.yy"
    { if (YYSession->add_group_to_list((yyvsp[(1) - (2)].item),(bool) (yyvsp[(2) - (2)].num))) DRIZZLE_YYABORT; }
    break;

  case 628:
#line 4094 "sql_yacc.yy"
    {}
    break;

  case 629:
#line 4096 "sql_yacc.yy"
    {
            /*
              'WITH ROLLUP' is needed for backward compatibility,
              and cause LALR(2) conflicts.
              This syntax is not standard.
              MySQL syntax: GROUP BY col1, col2, col3 WITH ROLLUP
              SQL-2003: GROUP BY ... ROLLUP(col1, col2, col3)
            */
            LEX *lex= Lex;
            if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
            {
              my_error(ER_WRONG_USAGE, MYF(0), "WITH ROLLUP",
                       "global union parameters");
              DRIZZLE_YYABORT;
            }
            lex->current_select->olap= ROLLUP_TYPE;
          }
    break;

  case 633:
#line 4130 "sql_yacc.yy"
    {
            Session *session= YYSession;
            bool ascending= ((yyvsp[(2) - (2)].num) == 1) ? true : false;
            if (session->add_order_to_list((yyvsp[(1) - (2)].item), ascending))
              DRIZZLE_YYABORT;
          }
    break;

  case 636:
#line 4149 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            Select_Lex *sel= lex->current_select;
            Select_Lex_Unit *unit= sel-> master_unit();
            if (sel->linkage != GLOBAL_OPTIONS_TYPE &&
                sel->olap != UNSPECIFIED_OLAP_TYPE &&
                (sel->linkage != UNION_TYPE || sel->braces))
            {
              my_error(ER_WRONG_USAGE, MYF(0),
                       "CUBE/ROLLUP", "ORDER BY");
              DRIZZLE_YYABORT;
            }
            if (lex->sql_command != SQLCOM_ALTER_TABLE && !unit->fake_select_lex)
            {
              /*
                A query of the of the form (SELECT ...) ORDER BY order_list is
                executed in the same way as the query
                SELECT ... ORDER BY order_list
                unless the SELECT construct contains ORDER BY or LIMIT clauses.
                Otherwise we create a fake Select_Lex if it has not been created
                yet.
              */
              Select_Lex *first_sl= unit->first_select();
              if (!unit->is_union() &&
                  (first_sl->order_list.elements ||
                   first_sl->select_limit) &&           
                  unit->add_fake_select_lex(lex->session))
                DRIZZLE_YYABORT;
            }
          }
    break;

  case 638:
#line 4184 "sql_yacc.yy"
    { if (YYSession->add_order_to_list((yyvsp[(3) - (4)].item),(bool) (yyvsp[(4) - (4)].num))) DRIZZLE_YYABORT; }
    break;

  case 639:
#line 4186 "sql_yacc.yy"
    { if (YYSession->add_order_to_list((yyvsp[(1) - (2)].item),(bool) (yyvsp[(2) - (2)].num))) DRIZZLE_YYABORT; }
    break;

  case 640:
#line 4190 "sql_yacc.yy"
    { (yyval.num) =  1; }
    break;

  case 641:
#line 4191 "sql_yacc.yy"
    { (yyval.num) =1; }
    break;

  case 642:
#line 4192 "sql_yacc.yy"
    { (yyval.num) =0; }
    break;

  case 643:
#line 4197 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            Select_Lex *sel= lex->current_select;
            sel->offset_limit= 0;
            sel->select_limit= 0;
          }
    break;

  case 644:
#line 4203 "sql_yacc.yy"
    {}
    break;

  case 645:
#line 4207 "sql_yacc.yy"
    {}
    break;

  case 646:
#line 4208 "sql_yacc.yy"
    {}
    break;

  case 647:
#line 4212 "sql_yacc.yy"
    {}
    break;

  case 648:
#line 4217 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->select_limit= (yyvsp[(1) - (1)].item);
            sel->offset_limit= 0;
            sel->explicit_limit= 1;
          }
    break;

  case 649:
#line 4224 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->select_limit= (yyvsp[(3) - (3)].item);
            sel->offset_limit= (yyvsp[(1) - (3)].item);
            sel->explicit_limit= 1;
          }
    break;

  case 650:
#line 4231 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->select_limit= (yyvsp[(1) - (3)].item);
            sel->offset_limit= (yyvsp[(3) - (3)].item);
            sel->explicit_limit= 1;
          }
    break;

  case 651:
#line 4240 "sql_yacc.yy"
    { (yyval.item)= new Item_uint((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length); }
    break;

  case 652:
#line 4241 "sql_yacc.yy"
    { (yyval.item)= new Item_uint((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length); }
    break;

  case 653:
#line 4242 "sql_yacc.yy"
    { (yyval.item)= new Item_uint((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length); }
    break;

  case 654:
#line 4247 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->current_select->select_limit= 0;
          }
    break;

  case 655:
#line 4252 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->select_limit= (yyvsp[(2) - (2)].item);
            sel->explicit_limit= 1;
          }
    break;

  case 656:
#line 4260 "sql_yacc.yy"
    { int error; (yyval.ulong_num)= (ulong) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 657:
#line 4261 "sql_yacc.yy"
    { (yyval.ulong_num)= (ulong) strtol((yyvsp[(1) - (1)].lex_str).str, (char**) 0, 16); }
    break;

  case 658:
#line 4262 "sql_yacc.yy"
    { int error; (yyval.ulong_num)= (ulong) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 659:
#line 4263 "sql_yacc.yy"
    { int error; (yyval.ulong_num)= (ulong) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 660:
#line 4264 "sql_yacc.yy"
    { int error; (yyval.ulong_num)= (ulong) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 661:
#line 4265 "sql_yacc.yy"
    { int error; (yyval.ulong_num)= (ulong) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 662:
#line 4269 "sql_yacc.yy"
    { int error; (yyval.ulonglong_number)= (uint64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 663:
#line 4270 "sql_yacc.yy"
    { int error; (yyval.ulonglong_number)= (uint64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 664:
#line 4271 "sql_yacc.yy"
    { int error; (yyval.ulonglong_number)= (uint64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 665:
#line 4272 "sql_yacc.yy"
    { int error; (yyval.ulonglong_number)= (uint64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 666:
#line 4273 "sql_yacc.yy"
    { int error; (yyval.ulonglong_number)= (uint64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 667:
#line 4277 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (!lex->describe && (!(lex->result= new select_dumpvar())))
              DRIZZLE_YYABORT;
          }
    break;

  case 668:
#line 4283 "sql_yacc.yy"
    {}
    break;

  case 670:
#line 4288 "sql_yacc.yy"
    {}
    break;

  case 671:
#line 4293 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (lex->result)
              ((select_dumpvar *)lex->result)->var_list.push_back( new my_var((yyvsp[(2) - (2)].lex_str),0,0,(enum_field_types)0));
            else
              /*
                The parser won't create select_result instance only
                if it's an EXPLAIN.
              */
              assert(lex->describe);
          }
    break;

  case 672:
#line 4308 "sql_yacc.yy"
    { }
    break;

  case 674:
#line 4314 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (!(lex->exchange= new file_exchange((yyvsp[(2) - (2)].lex_str).str, 0)) ||
                !(lex->result= new select_export(lex->exchange)))
              DRIZZLE_YYABORT;
          }
    break;

  case 676:
#line 4322 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (!lex->describe)
            {
              if (!(lex->exchange= new file_exchange((yyvsp[(2) - (2)].lex_str).str,1)))
                DRIZZLE_YYABORT;
              if (!(lex->result= new select_dump(lex->exchange)))
                DRIZZLE_YYABORT;
            }
          }
    break;

  case 677:
#line 4333 "sql_yacc.yy"
    { }
    break;

  case 678:
#line 4342 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command = SQLCOM_DROP_TABLE;
            statement::DropTable *statement= new(std::nothrow) statement::DropTable(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->drop_temporary= (yyvsp[(2) - (5)].num);
            statement->drop_if_exists= (yyvsp[(4) - (5)].num);
          }
    break;

  case 679:
#line 4352 "sql_yacc.yy"
    {}
    break;

  case 680:
#line 4353 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_DROP_INDEX;
            statement::DropIndex *statement= new(std::nothrow) statement::DropIndex(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->alter_info.flags.set(ALTER_DROP_INDEX);
            statement->alter_info.build_method= (yyvsp[(2) - (7)].build_method);
            statement->alter_info.drop_list.push_back(new AlterDrop(AlterDrop::KEY, (yyvsp[(4) - (7)].lex_str).str));
            if (!lex->current_select->add_table_to_list(lex->session, (yyvsp[(6) - (7)].table), NULL,
                                                        TL_OPTION_UPDATING))
              DRIZZLE_YYABORT;
          }
    break;

  case 681:
#line 4368 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_DROP_DB;
            statement::DropSchema *statement= new(std::nothrow) statement::DropSchema(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->drop_if_exists=(yyvsp[(3) - (4)].num);
            lex->name= (yyvsp[(4) - (4)].lex_str);
          }
    break;

  case 684:
#line 4385 "sql_yacc.yy"
    {
            if (!Lex->current_select->add_table_to_list(YYSession, (yyvsp[(1) - (1)].table), NULL, TL_OPTION_UPDATING))
              DRIZZLE_YYABORT;
          }
    break;

  case 685:
#line 4392 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 686:
#line 4393 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 687:
#line 4397 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 688:
#line 4398 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 689:
#line 4406 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command= SQLCOM_INSERT;
            lex->statement= new(std::nothrow) statement::Insert(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->duplicates= DUP_ERROR;
            mysql_init_select(lex);
            /* for subselects */
            lex->lock_option= TL_READ;
          }
    break;

  case 690:
#line 4418 "sql_yacc.yy"
    {
            Lex->current_select->set_lock_for_tables(TL_WRITE_CONCURRENT_INSERT);
            Lex->current_select= &Lex->select_lex;
          }
    break;

  case 691:
#line 4423 "sql_yacc.yy"
    {}
    break;

  case 692:
#line 4428 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command= SQLCOM_REPLACE;
            lex->statement= new(std::nothrow) statement::Replace(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->duplicates= DUP_REPLACE;
            mysql_init_select(lex);
          }
    break;

  case 693:
#line 4438 "sql_yacc.yy"
    {
            Lex->current_select->set_lock_for_tables(TL_WRITE_DEFAULT);
            Lex->current_select= &Lex->select_lex;
          }
    break;

  case 694:
#line 4443 "sql_yacc.yy"
    {}
    break;

  case 695:
#line 4447 "sql_yacc.yy"
    {}
    break;

  case 696:
#line 4448 "sql_yacc.yy"
    {}
    break;

  case 697:
#line 4453 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->field_list.empty();
            lex->many_values.empty();
            lex->insert_list=0;
          }
    break;

  case 698:
#line 4461 "sql_yacc.yy"
    {}
    break;

  case 699:
#line 4462 "sql_yacc.yy"
    {}
    break;

  case 700:
#line 4463 "sql_yacc.yy"
    {}
    break;

  case 701:
#line 4465 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (!(lex->insert_list = new List_item) ||
                lex->many_values.push_back(lex->insert_list))
              DRIZZLE_YYABORT;
          }
    break;

  case 703:
#line 4475 "sql_yacc.yy"
    { Lex->field_list.push_back((yyvsp[(3) - (3)].item)); }
    break;

  case 704:
#line 4476 "sql_yacc.yy"
    { Lex->field_list.push_back((yyvsp[(1) - (1)].item)); }
    break;

  case 705:
#line 4480 "sql_yacc.yy"
    {}
    break;

  case 706:
#line 4481 "sql_yacc.yy"
    {}
    break;

  case 707:
#line 4483 "sql_yacc.yy"
    { Lex->current_select->set_braces(0);}
    break;

  case 708:
#line 4484 "sql_yacc.yy"
    {}
    break;

  case 709:
#line 4486 "sql_yacc.yy"
    { Lex->current_select->set_braces(1);}
    break;

  case 710:
#line 4487 "sql_yacc.yy"
    {}
    break;

  case 715:
#line 4502 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (lex->field_list.push_back((yyvsp[(1) - (3)].item)) ||
                lex->insert_list->push_back((yyvsp[(3) - (3)].item)))
              DRIZZLE_YYABORT;
          }
    break;

  case 716:
#line 4511 "sql_yacc.yy"
    {}
    break;

  case 717:
#line 4512 "sql_yacc.yy"
    {}
    break;

  case 718:
#line 4516 "sql_yacc.yy"
    {}
    break;

  case 719:
#line 4517 "sql_yacc.yy"
    {}
    break;

  case 720:
#line 4522 "sql_yacc.yy"
    {
              if (!(Lex->insert_list = new List_item))
                DRIZZLE_YYABORT;
          }
    break;

  case 721:
#line 4527 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (lex->many_values.push_back(lex->insert_list))
              DRIZZLE_YYABORT;
          }
    break;

  case 722:
#line 4535 "sql_yacc.yy"
    {}
    break;

  case 724:
#line 4541 "sql_yacc.yy"
    {
            if (Lex->insert_list->push_back((yyvsp[(3) - (3)].item)))
              DRIZZLE_YYABORT;
          }
    break;

  case 725:
#line 4546 "sql_yacc.yy"
    {
            if (Lex->insert_list->push_back((yyvsp[(1) - (1)].item)))
              DRIZZLE_YYABORT;
          }
    break;

  case 726:
#line 4553 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(1) - (1)].item);}
    break;

  case 727:
#line 4554 "sql_yacc.yy"
    {(yyval.item)= new Item_default_value(Lex->current_context()); }
    break;

  case 729:
#line 4559 "sql_yacc.yy"
    { Lex->duplicates= DUP_UPDATE; }
    break;

  case 731:
#line 4567 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            mysql_init_select(lex);
            lex->sql_command= SQLCOM_UPDATE;
            lex->statement= new(std::nothrow) statement::Update(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->lock_option= TL_UNLOCK; /* Will be set later */
            lex->duplicates= DUP_ERROR;
            if (!lex->select_lex.add_table_to_list(YYSession, (yyvsp[(3) - (3)].table), NULL,0))
              DRIZZLE_YYABORT;
          }
    break;

  case 732:
#line 4580 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (lex->select_lex.get_table_list()->derived)
            {
              /* it is single table update and it is update of derived table */
              my_error(ER_NON_UPDATABLE_TABLE, MYF(0),
                       lex->select_lex.get_table_list()->alias, "UPDATE");
              DRIZZLE_YYABORT;
            }
            /*
              In case of multi-update setting write lock for all tables may
              be too pessimistic. We will decrease lock level if possible in
              mysql_multi_update().
            */
            Lex->current_select->set_lock_for_tables(TL_WRITE_DEFAULT);
          }
    break;

  case 733:
#line 4596 "sql_yacc.yy"
    {}
    break;

  case 736:
#line 4606 "sql_yacc.yy"
    {
            if (YYSession->add_item_to_list((yyvsp[(1) - (3)].item)) || YYSession->add_value_to_list((yyvsp[(3) - (3)].item)))
              DRIZZLE_YYABORT;
          }
    break;

  case 739:
#line 4619 "sql_yacc.yy"
    {
          LEX *lex= Lex;
          if (lex->update_list.push_back((yyvsp[(1) - (3)].item)) ||
              lex->value_list.push_back((yyvsp[(3) - (3)].item)))
              DRIZZLE_YYABORT;
          }
    break;

  case 740:
#line 4631 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command= SQLCOM_DELETE;
            lex->statement= new(std::nothrow) statement::Delete(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            mysql_init_select(lex);
            lex->lock_option= TL_WRITE_DEFAULT;
            lex->ignore= 0;
            lex->select_lex.init_order();
          }
    break;

  case 742:
#line 4647 "sql_yacc.yy"
    {
            if (!Lex->current_select->add_table_to_list(YYSession, (yyvsp[(2) - (2)].table), NULL, TL_OPTION_UPDATING,
                                           Lex->lock_option))
              DRIZZLE_YYABORT;
          }
    break;

  case 743:
#line 4653 "sql_yacc.yy"
    {}
    break;

  case 744:
#line 4657 "sql_yacc.yy"
    {}
    break;

  case 745:
#line 4658 "sql_yacc.yy"
    {}
    break;

  case 746:
#line 4662 "sql_yacc.yy"
    { Lex->ignore= 1; }
    break;

  case 747:
#line 4667 "sql_yacc.yy"
    {
            LEX* lex= Lex;
            lex->sql_command= SQLCOM_TRUNCATE;
            lex->statement= new(std::nothrow) statement::Truncate(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->select_lex.options= 0;
            lex->select_lex.init_order();
          }
    break;

  case 750:
#line 4687 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->wild=0;
            lex->lock_option= TL_READ;
            mysql_init_select(lex);
            lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 751:
#line 4695 "sql_yacc.yy"
    {}
    break;

  case 752:
#line 4700 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             lex->sql_command= SQLCOM_SELECT;
             lex->statement=
               new(std::nothrow) statement::Select(YYSession);
             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             Session *session= YYSession;

             std::string column_name= "Database";
             if (Lex->wild)
             {
               column_name.append(" (");
               column_name.append(Lex->wild->ptr());
               column_name.append(")");
             }

             if (Lex->current_select->where)
             {
               if (prepare_new_schema_table(YYSession, lex, "SCHEMAS"))
                 DRIZZLE_YYABORT;
             }
             else
             {
               if (prepare_new_schema_table(YYSession, lex, "SCHEMA_NAMES"))
                 DRIZZLE_YYABORT;
             }

             Item_field *my_field= new Item_field(&session->lex->current_select->context, NULL, NULL, "SCHEMA_NAME");
             my_field->is_autogenerated_name= false;
             my_field->set_name(column_name.c_str(), column_name.length(), system_charset_info);

             if (session->add_item_to_list(my_field))
               DRIZZLE_YYABORT;
           }
    break;

  case 753:
#line 4737 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             lex->sql_command= SQLCOM_SELECT;
             lex->statement=
               new(std::nothrow) statement::Select(YYSession);
             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

              Session *session= YYSession;

              std::string column_name= "Tables_in_";

              if ((yyvsp[(2) - (3)].simple_string))
              {
                column_name.append((yyvsp[(2) - (3)].simple_string));
                lex->select_lex.db= (yyvsp[(2) - (3)].simple_string);
                if (not plugin::StorageEngine::doesSchemaExist((yyvsp[(2) - (3)].simple_string)))
                {
                  my_error(ER_BAD_DB_ERROR, MYF(0), (yyvsp[(2) - (3)].simple_string));
                }
              }
              else
              {
                column_name.append(session->db);
              }

             if (Lex->wild)
             {
               column_name.append(" (");
               column_name.append(Lex->wild->ptr());
               column_name.append(")");
             }

             if (Lex->current_select->where)
             {
               if (prepare_new_schema_table(YYSession, lex, "TABLES"))
                 DRIZZLE_YYABORT;
             }
             else
             {
               if (prepare_new_schema_table(YYSession, lex, "SHOW_TABLES"))
                 DRIZZLE_YYABORT;
             }

             Item_field *my_field= new Item_field(&session->lex->current_select->context, NULL, NULL, "TABLE_NAME");
             my_field->is_autogenerated_name= false;
             my_field->set_name(column_name.c_str(), column_name.length(), system_charset_info);

             if (session->add_item_to_list(my_field))
               DRIZZLE_YYABORT;
           }
    break;

  case 754:
#line 4789 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             lex->sql_command= SQLCOM_SELECT;
             statement::Select *select=
               new(std::nothrow) statement::Select(YYSession);

             lex->statement= select;

             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             Session *session= YYSession;

             std::string column_name= "Tables_in_";

             if ((yyvsp[(3) - (4)].simple_string))
             {
               lex->select_lex.db= (yyvsp[(3) - (4)].simple_string);

               if (not plugin::StorageEngine::doesSchemaExist((yyvsp[(3) - (4)].simple_string)))
               {
                 my_error(ER_BAD_DB_ERROR, MYF(0), (yyvsp[(3) - (4)].simple_string));
               }

               select->setShowPredicate((yyvsp[(3) - (4)].simple_string), "");
             }
             else
             {
               select->setShowPredicate(session->db, "");
             }

             if (prepare_new_schema_table(session, lex, "SHOW_TABLE_STATUS"))
               DRIZZLE_YYABORT;

             if (session->add_item_to_list( new Item_field(&session->lex->current_select->
                                                           context,
                                                           NULL, NULL, "*")))
               DRIZZLE_YYABORT;
             (session->lex->current_select->with_wild)++;
           }
    break;

  case 755:
#line 4830 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             Session *session= YYSession;
             statement::Select *select;

             lex->sql_command= SQLCOM_SELECT;

             select= new(std::nothrow) statement::Select(session);

             lex->statement= select;

             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             if ((yyvsp[(4) - (5)].simple_string))
              select->setShowPredicate((yyvsp[(4) - (5)].simple_string), (yyvsp[(3) - (5)].table)->table.str);
             else if ((yyvsp[(3) - (5)].table)->db.str)
              select->setShowPredicate((yyvsp[(3) - (5)].table)->db.str, (yyvsp[(3) - (5)].table)->table.str);
             else
              select->setShowPredicate(session->db, (yyvsp[(3) - (5)].table)->table.str);

             {
               drizzled::TableIdentifier identifier(select->getShowSchema().c_str(), (yyvsp[(3) - (5)].table)->table.str);
               if (not plugin::StorageEngine::doesTableExist(*session, identifier))
               {
                   my_error(ER_NO_SUCH_TABLE, MYF(0),
                            select->getShowSchema().c_str(), 
                            (yyvsp[(3) - (5)].table)->table.str);
               }
             }

             if (prepare_new_schema_table(session, lex, "SHOW_COLUMNS"))
               DRIZZLE_YYABORT;

             if (session->add_item_to_list( new Item_field(&session->lex->current_select->
                                                           context,
                                                           NULL, NULL, "*")))
               DRIZZLE_YYABORT;
             (session->lex->current_select->with_wild)++;

          }
    break;

  case 756:
#line 4872 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             Session *session= YYSession;
             statement::Select *select;

             lex->sql_command= SQLCOM_SELECT;

             select= new(std::nothrow) statement::Select(session);

             lex->statement= select;

             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             if ((yyvsp[(4) - (5)].simple_string))
              select->setShowPredicate((yyvsp[(4) - (5)].simple_string), (yyvsp[(3) - (5)].table)->table.str);
             else if ((yyvsp[(3) - (5)].table)->db.str)
              select->setShowPredicate((yyvsp[(3) - (5)].table)->db.str, (yyvsp[(3) - (5)].table)->table.str);
             else
              select->setShowPredicate(session->db, (yyvsp[(3) - (5)].table)->table.str);

             {
               drizzled::TableIdentifier identifier(select->getShowSchema().c_str(), (yyvsp[(3) - (5)].table)->table.str);
               if (not plugin::StorageEngine::doesTableExist(*session, identifier))
               {
                   my_error(ER_NO_SUCH_TABLE, MYF(0),
                            select->getShowSchema().c_str(), 
                            (yyvsp[(3) - (5)].table)->table.str);
               }
             }

             if (prepare_new_schema_table(session, lex, "show_indexes"))
               DRIZZLE_YYABORT;

             if (session->add_item_to_list( new Item_field(&session->lex->current_select->
                                                           context,
                                                           NULL, NULL, "*")))
               DRIZZLE_YYABORT;
             (session->lex->current_select->with_wild)++;
          }
    break;

  case 757:
#line 4913 "sql_yacc.yy"
    {
            (void) create_select_for_variable("warning_count");
            LEX *lex= Lex;
            lex->statement= new(std::nothrow) statement::Select(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 758:
#line 4921 "sql_yacc.yy"
    {
            (void) create_select_for_variable("error_count");
            LEX *lex= Lex;
            lex->statement= new(std::nothrow) statement::Select(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 759:
#line 4929 "sql_yacc.yy"
    {
            Lex->sql_command = SQLCOM_SHOW_WARNS;
            Lex->statement= new(std::nothrow) statement::ShowWarnings(YYSession);
            if (Lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 760:
#line 4936 "sql_yacc.yy"
    {
            Lex->sql_command = SQLCOM_SHOW_ERRORS;
            Lex->statement= new(std::nothrow) statement::ShowErrors(YYSession);
            if (Lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 761:
#line 4943 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             lex->sql_command= SQLCOM_SELECT;
             lex->statement=
               new(std::nothrow) statement::Select(YYSession);
             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             Session *session= YYSession;

             if ((yyvsp[(1) - (3)].var_type) == OPT_GLOBAL)
             {
               if (prepare_new_schema_table(session, lex, "GLOBAL_STATUS"))
                 DRIZZLE_YYABORT;
             }
             else
             {
               if (prepare_new_schema_table(session, lex, "SESSION_STATUS"))
                 DRIZZLE_YYABORT;
             }

             std::string key("Variable_name");
             std::string value("Value");

             Item_field *my_field= new Item_field(&session->lex->current_select->context, NULL, NULL, "VARIABLE_NAME");
             my_field->is_autogenerated_name= false;
             my_field->set_name(key.c_str(), key.length(), system_charset_info);

             if (session->add_item_to_list(my_field))
               DRIZZLE_YYABORT;

             my_field= new Item_field(&session->lex->current_select->context, NULL, NULL, "VARIABLE_VALUE");
             my_field->is_autogenerated_name= false;
             my_field->set_name(value.c_str(), value.length(), system_charset_info);

             if (session->add_item_to_list(my_field))
               DRIZZLE_YYABORT;
           }
    break;

  case 762:
#line 4982 "sql_yacc.yy"
    {
           {
             LEX *lex= Lex;
             lex->sql_command= SQLCOM_SELECT;
             lex->statement=
               new(std::nothrow) statement::Select(YYSession);
             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             Session *session= YYSession;

             if (prepare_new_schema_table(session, lex, "PROCESSLIST"))
               DRIZZLE_YYABORT;

             if (session->add_item_to_list( new Item_field(&session->lex->current_select->
                                                           context,
                                                           NULL, NULL, "*")))
               DRIZZLE_YYABORT;
             (session->lex->current_select->with_wild)++;
           }
          }
    break;

  case 763:
#line 5004 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             lex->sql_command= SQLCOM_SELECT;
             lex->statement=
               new(std::nothrow) statement::Select(YYSession);
             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             Session *session= YYSession;

             if ((yyvsp[(1) - (3)].var_type) == OPT_GLOBAL)
             {
               if (prepare_new_schema_table(session, lex, "GLOBAL_VARIABLES"))
                 DRIZZLE_YYABORT;
             }
             else
             {
               if (prepare_new_schema_table(session, lex, "SESSION_VARIABLES"))
                 DRIZZLE_YYABORT;
             }

             std::string key("Variable_name");
             std::string value("Value");

             Item_field *my_field= new Item_field(&session->lex->current_select->context, NULL, NULL, "VARIABLE_NAME");
             my_field->is_autogenerated_name= false;
             my_field->set_name(key.c_str(), key.length(), system_charset_info);

             if (session->add_item_to_list(my_field))
               DRIZZLE_YYABORT;

             my_field= new Item_field(&session->lex->current_select->context, NULL, NULL, "VARIABLE_VALUE");
             my_field->is_autogenerated_name= false;
             my_field->set_name(value.c_str(), value.length(), system_charset_info);

             if (session->add_item_to_list(my_field))
               DRIZZLE_YYABORT;
           }
    break;

  case 764:
#line 5043 "sql_yacc.yy"
    {
            Lex->sql_command=SQLCOM_SHOW_CREATE_DB;
            statement::ShowCreateSchema *statement= new(std::nothrow) statement::ShowCreateSchema(YYSession);
            Lex->statement= statement;
            if (Lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->is_if_not_exists= (yyvsp[(3) - (4)].num);
            Lex->name= (yyvsp[(4) - (4)].lex_str);
          }
    break;

  case 765:
#line 5053 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command = SQLCOM_SHOW_CREATE;
            lex->statement= new(std::nothrow) statement::ShowCreate(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            if (!lex->select_lex.add_table_to_list(YYSession, (yyvsp[(3) - (3)].table), NULL,0))
              DRIZZLE_YYABORT;
          }
    break;

  case 766:
#line 5064 "sql_yacc.yy"
    { (yyval.simple_string)= 0; }
    break;

  case 767:
#line 5065 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[(2) - (2)].lex_str).str; }
    break;

  case 771:
#line 5076 "sql_yacc.yy"
    {
            Lex->wild= new (YYSession->mem_root) String((yyvsp[(2) - (2)].lex_str).str, (yyvsp[(2) - (2)].lex_str).length,
                                                    system_charset_info);
            if (Lex->wild == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 772:
#line 5083 "sql_yacc.yy"
    {
            Lex->current_select->where= (yyvsp[(2) - (2)].item);
            if ((yyvsp[(2) - (2)].item))
              (yyvsp[(2) - (2)].item)->top_level_item();
          }
    break;

  case 773:
#line 5093 "sql_yacc.yy"
    {
            Session *session= YYSession;
            statement::Select *select;
            LEX *lex= Lex;
            lex->lock_option= TL_READ;
            mysql_init_select(lex);
            lex->current_select->parsing_place= SELECT_LIST;
            lex->sql_command= SQLCOM_SELECT;
            select= new(std::nothrow) statement::Select(session);
            lex->statement= select;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->select_lex.db= 0;

             if ((yyvsp[(2) - (2)].table)->db.str)
              select->setShowPredicate((yyvsp[(2) - (2)].table)->db.str, (yyvsp[(2) - (2)].table)->table.str);
             else
              select->setShowPredicate(session->db, (yyvsp[(2) - (2)].table)->table.str);

             {
               drizzled::TableIdentifier identifier(select->getShowSchema().c_str(), (yyvsp[(2) - (2)].table)->table.str);
               if (not plugin::StorageEngine::doesTableExist(*session, identifier))
               {
                   my_error(ER_NO_SUCH_TABLE, MYF(0),
                            select->getShowSchema().c_str(), 
                            (yyvsp[(2) - (2)].table)->table.str);
               }
             }

             if (prepare_new_schema_table(session, lex, "SHOW_COLUMNS"))
               DRIZZLE_YYABORT;

             if (session->add_item_to_list( new Item_field(&session->lex->current_select->
                                                           context,
                                                           NULL, NULL, "*")))
               DRIZZLE_YYABORT;
             (session->lex->current_select->with_wild)++;

          }
    break;

  case 774:
#line 5132 "sql_yacc.yy"
    {}
    break;

  case 775:
#line 5134 "sql_yacc.yy"
    { Lex->describe|= DESCRIBE_NORMAL; }
    break;

  case 776:
#line 5136 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->select_lex.options|= SELECT_DESCRIBE;
          }
    break;

  case 779:
#line 5148 "sql_yacc.yy"
    {}
    break;

  case 780:
#line 5149 "sql_yacc.yy"
    { Lex->describe|= DESCRIBE_EXTENDED; }
    break;

  case 781:
#line 5153 "sql_yacc.yy"
    {}
    break;

  case 782:
#line 5154 "sql_yacc.yy"
    { Lex->wild= (yyvsp[(1) - (1)].string); }
    break;

  case 783:
#line 5156 "sql_yacc.yy"
    {
            Lex->wild= new (YYSession->mem_root) String((const char*) (yyvsp[(1) - (1)].lex_str).str,
                                                    (yyvsp[(1) - (1)].lex_str).length,
                                                    system_charset_info);
          }
    break;

  case 784:
#line 5168 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_FLUSH;
            lex->statement= new(std::nothrow) statement::Flush(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->type= 0;
          }
    break;

  case 785:
#line 5177 "sql_yacc.yy"
    {}
    break;

  case 788:
#line 5187 "sql_yacc.yy"
    {
            statement::Flush *statement= (statement::Flush*)Lex->statement;
            statement->setFlushTables(true);
          }
    break;

  case 789:
#line 5191 "sql_yacc.yy"
    {}
    break;

  case 790:
#line 5193 "sql_yacc.yy"
    {
            statement::Flush *statement= (statement::Flush*)Lex->statement;
            statement->setFlushTablesWithReadLock(true);
          }
    break;

  case 791:
#line 5198 "sql_yacc.yy"
    {
            statement::Flush *statement= (statement::Flush*)Lex->statement;
            statement->setFlushLog(true);
          }
    break;

  case 792:
#line 5203 "sql_yacc.yy"
    {
            statement::Flush *statement= (statement::Flush*)Lex->statement;
            statement->setFlushStatus(true);
          }
    break;

  case 793:
#line 5210 "sql_yacc.yy"
    {}
    break;

  case 794:
#line 5211 "sql_yacc.yy"
    {}
    break;

  case 795:
#line 5218 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->value_list.empty();
            lex->value_list.push_front((yyvsp[(3) - (3)].item));
            lex->sql_command= SQLCOM_KILL;
            lex->statement= new(std::nothrow) statement::Kill(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 796:
#line 5230 "sql_yacc.yy"
    { Lex->type= 0; }
    break;

  case 797:
#line 5231 "sql_yacc.yy"
    { Lex->type= 0; }
    break;

  case 798:
#line 5232 "sql_yacc.yy"
    { Lex->type= ONLY_KILL_QUERY; }
    break;

  case 799:
#line 5239 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command=SQLCOM_CHANGE_DB;
            lex->statement= new(std::nothrow) statement::ChangeSchema(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->select_lex.db= (yyvsp[(2) - (2)].lex_str).str;
          }
    break;

  case 800:
#line 5253 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;

            lex->sql_command= SQLCOM_LOAD;
            statement::Load *statement= new(std::nothrow) statement::Load(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;

            Lex_input_stream *lip= session->m_lip;
            statement->fname_start= lip->get_ptr();
          }
    break;

  case 801:
#line 5267 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->lock_option= (yyvsp[(4) - (6)].lock_type);
            lex->duplicates= DUP_ERROR;
            lex->ignore= 0;
            if (!(lex->exchange= new file_exchange((yyvsp[(6) - (6)].lex_str).str, 0, (yyvsp[(2) - (6)].filetype))))
              DRIZZLE_YYABORT;
          }
    break;

  case 802:
#line 5276 "sql_yacc.yy"
    {
            Session *session= YYSession;
            Lex_input_stream *lip= session->m_lip;
            ((statement::Load *)Lex->statement)->fname_end= lip->get_ptr();
          }
    break;

  case 803:
#line 5282 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (!Lex->current_select->add_table_to_list(YYSession,
                    (yyvsp[(12) - (12)].table), NULL, TL_OPTION_UPDATING,
                    lex->lock_option))
              DRIZZLE_YYABORT;
            lex->field_list.empty();
            lex->update_list.empty();
            lex->value_list.empty();
          }
    break;

  case 804:
#line 5294 "sql_yacc.yy"
    {}
    break;

  case 805:
#line 5298 "sql_yacc.yy"
    { (yyval.filetype)= FILETYPE_CSV; }
    break;

  case 806:
#line 5301 "sql_yacc.yy"
    { (yyval.lock_type)= TL_WRITE_DEFAULT; }
    break;

  case 807:
#line 5303 "sql_yacc.yy"
    {
              (yyval.lock_type)= TL_WRITE_CONCURRENT_INSERT;
          }
    break;

  case 808:
#line 5309 "sql_yacc.yy"
    { Lex->duplicates=DUP_ERROR; }
    break;

  case 809:
#line 5310 "sql_yacc.yy"
    { Lex->duplicates=DUP_REPLACE; }
    break;

  case 810:
#line 5311 "sql_yacc.yy"
    { Lex->ignore= 1; }
    break;

  case 815:
#line 5326 "sql_yacc.yy"
    {
            assert(Lex->exchange != 0);
            Lex->exchange->field_term= (yyvsp[(3) - (3)].string);
          }
    break;

  case 816:
#line 5331 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            assert(lex->exchange != 0);
            lex->exchange->enclosed= (yyvsp[(4) - (4)].string);
            lex->exchange->opt_enclosed= 1;
          }
    break;

  case 817:
#line 5338 "sql_yacc.yy"
    {
            assert(Lex->exchange != 0);
            Lex->exchange->enclosed= (yyvsp[(3) - (3)].string);
          }
    break;

  case 818:
#line 5343 "sql_yacc.yy"
    {
            assert(Lex->exchange != 0);
            Lex->exchange->escaped= (yyvsp[(3) - (3)].string);
          }
    break;

  case 823:
#line 5361 "sql_yacc.yy"
    {
            assert(Lex->exchange != 0);
            Lex->exchange->line_term= (yyvsp[(3) - (3)].string);
          }
    break;

  case 824:
#line 5366 "sql_yacc.yy"
    {
            assert(Lex->exchange != 0);
            Lex->exchange->line_start= (yyvsp[(3) - (3)].string);
          }
    break;

  case 826:
#line 5375 "sql_yacc.yy"
    {
            assert(Lex->exchange != 0);
            Lex->exchange->skip_lines= atol((yyvsp[(2) - (3)].lex_str).str);
          }
    break;

  case 827:
#line 5382 "sql_yacc.yy"
    { }
    break;

  case 828:
#line 5383 "sql_yacc.yy"
    { }
    break;

  case 829:
#line 5387 "sql_yacc.yy"
    {}
    break;

  case 830:
#line 5388 "sql_yacc.yy"
    {}
    break;

  case 831:
#line 5389 "sql_yacc.yy"
    {}
    break;

  case 832:
#line 5394 "sql_yacc.yy"
    { Lex->field_list.push_back((yyvsp[(3) - (3)].item)); }
    break;

  case 833:
#line 5396 "sql_yacc.yy"
    { Lex->field_list.push_back((yyvsp[(1) - (1)].item)); }
    break;

  case 834:
#line 5400 "sql_yacc.yy"
    {(yyval.item)= (yyvsp[(1) - (1)].item);}
    break;

  case 835:
#line 5402 "sql_yacc.yy"
    { (yyval.item)= new Item_user_var_as_out_param((yyvsp[(2) - (2)].lex_str)); }
    break;

  case 836:
#line 5406 "sql_yacc.yy"
    {}
    break;

  case 837:
#line 5407 "sql_yacc.yy"
    {}
    break;

  case 838:
#line 5414 "sql_yacc.yy"
    {
          Session *session= YYSession;
          (yyval.item) = new Item_string((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length, session->variables.getCollation());
        }
    break;

  case 839:
#line 5419 "sql_yacc.yy"
    {
            ((Item_string*) (yyvsp[(1) - (2)].item))->append((yyvsp[(2) - (2)].lex_str).str, (yyvsp[(2) - (2)].lex_str).length);
          }
    break;

  case 840:
#line 5426 "sql_yacc.yy"
    {
            (yyval.string)= new (YYSession->mem_root) String((yyvsp[(1) - (1)].lex_str).str,
                                             (yyvsp[(1) - (1)].lex_str).length,
                                             YYSession->variables.getCollation());
          }
    break;

  case 841:
#line 5432 "sql_yacc.yy"
    {
            Item *tmp= new Item_hex_string((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length);
            /*
              it is OK only emulate fix_fields, because we need only
              value of constant
            */
            (yyval.string)= tmp ?
              tmp->quick_fix_field(), tmp->val_str((String*) 0) :
              (String*) 0;
          }
    break;

  case 842:
#line 5443 "sql_yacc.yy"
    {
            Item *tmp= new Item_bin_string((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length);
            /*
              it is OK only emulate fix_fields, because we need only
              value of constant
            */
            (yyval.string)= tmp ? tmp->quick_fix_field(), tmp->val_str((String*) 0) :
              (String*) 0;
          }
    break;

  case 843:
#line 5455 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(1) - (1)].item); }
    break;

  case 844:
#line 5456 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(2) - (2)].item_num); }
    break;

  case 845:
#line 5458 "sql_yacc.yy"
    {
            (yyvsp[(2) - (2)].item_num)->max_length++;
            (yyval.item)= (yyvsp[(2) - (2)].item_num)->neg();
          }
    break;

  case 846:
#line 5465 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(1) - (1)].item); }
    break;

  case 847:
#line 5466 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(1) - (1)].item_num); }
    break;

  case 848:
#line 5468 "sql_yacc.yy"
    {
            (yyval.item) = new Item_null();
            YYSession->m_lip->next_state=MY_LEX_OPERATOR_OR_IDENT;
          }
    break;

  case 849:
#line 5472 "sql_yacc.yy"
    { (yyval.item)= new Item_int((char*) "FALSE",0,1); }
    break;

  case 850:
#line 5473 "sql_yacc.yy"
    { (yyval.item)= new Item_int((char*) "TRUE",1,1); }
    break;

  case 851:
#line 5474 "sql_yacc.yy"
    { (yyval.item) = new Item_hex_string((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length);}
    break;

  case 852:
#line 5475 "sql_yacc.yy"
    { (yyval.item)= new Item_bin_string((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length); }
    break;

  case 853:
#line 5476 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(2) - (2)].item); }
    break;

  case 854:
#line 5477 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(2) - (2)].item); }
    break;

  case 855:
#line 5482 "sql_yacc.yy"
    {
            int error;
            (yyval.item_num) = new Item_int((yyvsp[(1) - (1)].lex_str).str, (int64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, NULL, &error), (yyvsp[(1) - (1)].lex_str).length);
          }
    break;

  case 856:
#line 5487 "sql_yacc.yy"
    {
            int error;
            (yyval.item_num) = new Item_int((yyvsp[(1) - (1)].lex_str).str, (int64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, NULL, &error), (yyvsp[(1) - (1)].lex_str).length);
          }
    break;

  case 857:
#line 5492 "sql_yacc.yy"
    { (yyval.item_num) = new Item_uint((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length); }
    break;

  case 858:
#line 5494 "sql_yacc.yy"
    {
            (yyval.item_num)= new Item_decimal((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length, YYSession->charset());
            if (YYSession->is_error())
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 859:
#line 5502 "sql_yacc.yy"
    {
            (yyval.item_num) = new Item_float((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length);
            if (YYSession->is_error())
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 860:
#line 5516 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[(1) - (1)].item); }
    break;

  case 861:
#line 5517 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[(1) - (1)].item); }
    break;

  case 862:
#line 5522 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            (yyval.item) = new Item_field(Lex->current_context(), NULL, (yyvsp[(1) - (3)].lex_str).str, "*");
            sel->with_wild++;
          }
    break;

  case 863:
#line 5528 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            (yyval.item) = new Item_field(Lex->current_context(), (yyvsp[(1) - (5)].lex_str).str, (yyvsp[(3) - (5)].lex_str).str,"*");
            sel->with_wild++;
          }
    break;

  case 864:
#line 5536 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[(1) - (1)].item); }
    break;

  case 865:
#line 5541 "sql_yacc.yy"
    {
            {
              Select_Lex *sel=Lex->current_select;
              (yyval.item)= (sel->parsing_place != IN_HAVING ||
                  sel->get_in_sum_expr() > 0) ?
                  (Item*) new Item_field(Lex->current_context(),
                                         (const char *)NULL, NULL, (yyvsp[(1) - (1)].lex_str).str) :
                  (Item*) new Item_ref(Lex->current_context(),
                                       (const char *)NULL, NULL, (yyvsp[(1) - (1)].lex_str).str);
            }
          }
    break;

  case 866:
#line 5552 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(1) - (1)].item); }
    break;

  case 867:
#line 5557 "sql_yacc.yy"
    {
            Select_Lex *sel=Lex->current_select;
            (yyval.item)= (sel->parsing_place != IN_HAVING ||
                sel->get_in_sum_expr() > 0) ?
                (Item*) new Item_field(Lex->current_context(),
                                       (const char *)NULL, NULL, (yyvsp[(1) - (1)].lex_str).str) :
                (Item*) new Item_ref(Lex->current_context(),
                                     (const char *)NULL, NULL, (yyvsp[(1) - (1)].lex_str).str);
          }
    break;

  case 868:
#line 5566 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(1) - (1)].item); }
    break;

  case 869:
#line 5571 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;

            {
              Select_Lex *sel= lex->current_select;
              if (sel->no_table_names_allowed)
              {
                my_error(ER_TABLENAME_NOT_ALLOWED_HERE,
                         MYF(0), (yyvsp[(1) - (3)].lex_str).str, session->where);
              }
              (yyval.item)= (sel->parsing_place != IN_HAVING ||
                  sel->get_in_sum_expr() > 0) ?
                  (Item*) new Item_field(Lex->current_context(),
                                         (const char *)NULL, (yyvsp[(1) - (3)].lex_str).str, (yyvsp[(3) - (3)].lex_str).str) :
                  (Item*) new Item_ref(Lex->current_context(),
                                       (const char *)NULL, (yyvsp[(1) - (3)].lex_str).str, (yyvsp[(3) - (3)].lex_str).str);
            }
          }
    break;

  case 870:
#line 5591 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            Select_Lex *sel= lex->current_select;
            if (sel->no_table_names_allowed)
            {
              my_error(ER_TABLENAME_NOT_ALLOWED_HERE,
                       MYF(0), (yyvsp[(2) - (4)].lex_str).str, session->where);
            }
            (yyval.item)= (sel->parsing_place != IN_HAVING ||
                sel->get_in_sum_expr() > 0) ?
                (Item*) new Item_field(Lex->current_context(), NULL, (yyvsp[(2) - (4)].lex_str).str, (yyvsp[(4) - (4)].lex_str).str) :
                (Item*) new Item_ref(Lex->current_context(),
                                     (const char *)NULL, (yyvsp[(2) - (4)].lex_str).str, (yyvsp[(4) - (4)].lex_str).str);
          }
    break;

  case 871:
#line 5607 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            Select_Lex *sel= lex->current_select;
            if (sel->no_table_names_allowed)
            {
              my_error(ER_TABLENAME_NOT_ALLOWED_HERE,
                       MYF(0), (yyvsp[(3) - (5)].lex_str).str, session->where);
            }
            (yyval.item)= (sel->parsing_place != IN_HAVING ||
                sel->get_in_sum_expr() > 0) ?
                (Item*) new Item_field(Lex->current_context(), (yyvsp[(1) - (5)].lex_str).str, (yyvsp[(3) - (5)].lex_str).str,
                                       (yyvsp[(5) - (5)].lex_str).str) :
                (Item*) new Item_ref(Lex->current_context(), (yyvsp[(1) - (5)].lex_str).str, (yyvsp[(3) - (5)].lex_str).str,
                                     (yyvsp[(5) - (5)].lex_str).str);
          }
    break;

  case 872:
#line 5626 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str);}
    break;

  case 873:
#line 5628 "sql_yacc.yy"
    {
            TableList *table=
              reinterpret_cast<TableList*>(Lex->current_select->table_list.first);
            if (my_strcasecmp(table_alias_charset, (yyvsp[(1) - (5)].lex_str).str, table->db))
            {
              my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[(1) - (5)].lex_str).str);
              DRIZZLE_YYABORT;
            }
            if (my_strcasecmp(table_alias_charset, (yyvsp[(3) - (5)].lex_str).str,
                              table->table_name))
            {
              my_error(ER_WRONG_TABLE_NAME, MYF(0), (yyvsp[(3) - (5)].lex_str).str);
              DRIZZLE_YYABORT;
            }
            (yyval.lex_str)=(yyvsp[(5) - (5)].lex_str);
          }
    break;

  case 874:
#line 5645 "sql_yacc.yy"
    {
            TableList *table=
              reinterpret_cast<TableList*>(Lex->current_select->table_list.first);
            if (my_strcasecmp(table_alias_charset, (yyvsp[(1) - (3)].lex_str).str, table->alias))
            {
              my_error(ER_WRONG_TABLE_NAME, MYF(0), (yyvsp[(1) - (3)].lex_str).str);
              DRIZZLE_YYABORT;
            }
            (yyval.lex_str)=(yyvsp[(3) - (3)].lex_str);
          }
    break;

  case 875:
#line 5655 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(2) - (2)].lex_str);}
    break;

  case 876:
#line 5659 "sql_yacc.yy"
    { (yyval.table)=new Table_ident((yyvsp[(1) - (1)].lex_str)); }
    break;

  case 877:
#line 5660 "sql_yacc.yy"
    { (yyval.table)=new Table_ident((yyvsp[(1) - (3)].lex_str),(yyvsp[(3) - (3)].lex_str));}
    break;

  case 878:
#line 5661 "sql_yacc.yy"
    { (yyval.table)=new Table_ident((yyvsp[(2) - (2)].lex_str));}
    break;

  case 879:
#line 5665 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str); }
    break;

  case 880:
#line 5667 "sql_yacc.yy"
    {
            const CHARSET_INFO * const cs= system_charset_info;
            int dummy_error;
            uint32_t wlen= cs->cset->well_formed_len(cs, (yyvsp[(1) - (1)].lex_str).str,
                                                 (yyvsp[(1) - (1)].lex_str).str+(yyvsp[(1) - (1)].lex_str).length,
                                                 (yyvsp[(1) - (1)].lex_str).length, &dummy_error);
            if (wlen < (yyvsp[(1) - (1)].lex_str).length)
            {
              my_error(ER_INVALID_CHARACTER_STRING, MYF(0),
                       cs->csname, (yyvsp[(1) - (1)].lex_str).str + wlen);
              DRIZZLE_YYABORT;
            }
            (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str);
          }
    break;

  case 881:
#line 5685 "sql_yacc.yy"
    {
            (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str);
          }
    break;

  case 882:
#line 5692 "sql_yacc.yy"
    {
            (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str);
          }
    break;

  case 883:
#line 5699 "sql_yacc.yy"
    {
            (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str);
          }
    break;

  case 884:
#line 5705 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str); }
    break;

  case 885:
#line 5707 "sql_yacc.yy"
    {
            Session *session= YYSession;
            (yyval.lex_str).str= session->strmake((yyvsp[(1) - (1)].symbol).str, (yyvsp[(1) - (1)].symbol).length);
            (yyval.lex_str).length= (yyvsp[(1) - (1)].symbol).length;
          }
    break;

  case 886:
#line 5715 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str);}
    break;

  case 887:
#line 5716 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str);}
    break;

  case 888:
#line 5717 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str);}
    break;

  case 889:
#line 5722 "sql_yacc.yy"
    {}
    break;

  case 890:
#line 5723 "sql_yacc.yy"
    {}
    break;

  case 891:
#line 5724 "sql_yacc.yy"
    {}
    break;

  case 892:
#line 5725 "sql_yacc.yy"
    {}
    break;

  case 893:
#line 5726 "sql_yacc.yy"
    {}
    break;

  case 894:
#line 5727 "sql_yacc.yy"
    {}
    break;

  case 895:
#line 5728 "sql_yacc.yy"
    {}
    break;

  case 896:
#line 5729 "sql_yacc.yy"
    {}
    break;

  case 897:
#line 5730 "sql_yacc.yy"
    {}
    break;

  case 898:
#line 5731 "sql_yacc.yy"
    {}
    break;

  case 899:
#line 5732 "sql_yacc.yy"
    {}
    break;

  case 900:
#line 5733 "sql_yacc.yy"
    {}
    break;

  case 901:
#line 5734 "sql_yacc.yy"
    {}
    break;

  case 902:
#line 5735 "sql_yacc.yy"
    {}
    break;

  case 903:
#line 5736 "sql_yacc.yy"
    {}
    break;

  case 904:
#line 5737 "sql_yacc.yy"
    {}
    break;

  case 905:
#line 5738 "sql_yacc.yy"
    {}
    break;

  case 906:
#line 5739 "sql_yacc.yy"
    {}
    break;

  case 907:
#line 5740 "sql_yacc.yy"
    {}
    break;

  case 908:
#line 5741 "sql_yacc.yy"
    {}
    break;

  case 909:
#line 5751 "sql_yacc.yy"
    {}
    break;

  case 910:
#line 5752 "sql_yacc.yy"
    {}
    break;

  case 911:
#line 5753 "sql_yacc.yy"
    {}
    break;

  case 912:
#line 5754 "sql_yacc.yy"
    {}
    break;

  case 913:
#line 5755 "sql_yacc.yy"
    {}
    break;

  case 914:
#line 5756 "sql_yacc.yy"
    {}
    break;

  case 915:
#line 5757 "sql_yacc.yy"
    {}
    break;

  case 916:
#line 5758 "sql_yacc.yy"
    {}
    break;

  case 917:
#line 5759 "sql_yacc.yy"
    {}
    break;

  case 918:
#line 5760 "sql_yacc.yy"
    {}
    break;

  case 919:
#line 5761 "sql_yacc.yy"
    {}
    break;

  case 920:
#line 5762 "sql_yacc.yy"
    {}
    break;

  case 921:
#line 5763 "sql_yacc.yy"
    {}
    break;

  case 922:
#line 5764 "sql_yacc.yy"
    {}
    break;

  case 923:
#line 5765 "sql_yacc.yy"
    {}
    break;

  case 924:
#line 5766 "sql_yacc.yy"
    {}
    break;

  case 925:
#line 5767 "sql_yacc.yy"
    {}
    break;

  case 926:
#line 5768 "sql_yacc.yy"
    {}
    break;

  case 927:
#line 5769 "sql_yacc.yy"
    {}
    break;

  case 928:
#line 5770 "sql_yacc.yy"
    {}
    break;

  case 929:
#line 5771 "sql_yacc.yy"
    {}
    break;

  case 930:
#line 5772 "sql_yacc.yy"
    {}
    break;

  case 931:
#line 5773 "sql_yacc.yy"
    {}
    break;

  case 932:
#line 5774 "sql_yacc.yy"
    {}
    break;

  case 933:
#line 5775 "sql_yacc.yy"
    {}
    break;

  case 934:
#line 5776 "sql_yacc.yy"
    {}
    break;

  case 935:
#line 5777 "sql_yacc.yy"
    {}
    break;

  case 936:
#line 5778 "sql_yacc.yy"
    {}
    break;

  case 937:
#line 5779 "sql_yacc.yy"
    {}
    break;

  case 938:
#line 5780 "sql_yacc.yy"
    {}
    break;

  case 939:
#line 5781 "sql_yacc.yy"
    {}
    break;

  case 940:
#line 5782 "sql_yacc.yy"
    {}
    break;

  case 941:
#line 5783 "sql_yacc.yy"
    {}
    break;

  case 942:
#line 5784 "sql_yacc.yy"
    {}
    break;

  case 943:
#line 5785 "sql_yacc.yy"
    {}
    break;

  case 944:
#line 5786 "sql_yacc.yy"
    {}
    break;

  case 945:
#line 5787 "sql_yacc.yy"
    {}
    break;

  case 946:
#line 5788 "sql_yacc.yy"
    {}
    break;

  case 947:
#line 5789 "sql_yacc.yy"
    {}
    break;

  case 948:
#line 5790 "sql_yacc.yy"
    {}
    break;

  case 949:
#line 5791 "sql_yacc.yy"
    {}
    break;

  case 950:
#line 5792 "sql_yacc.yy"
    {}
    break;

  case 951:
#line 5793 "sql_yacc.yy"
    {}
    break;

  case 952:
#line 5794 "sql_yacc.yy"
    {}
    break;

  case 953:
#line 5795 "sql_yacc.yy"
    {}
    break;

  case 954:
#line 5796 "sql_yacc.yy"
    {}
    break;

  case 955:
#line 5797 "sql_yacc.yy"
    {}
    break;

  case 956:
#line 5798 "sql_yacc.yy"
    {}
    break;

  case 957:
#line 5799 "sql_yacc.yy"
    {}
    break;

  case 958:
#line 5800 "sql_yacc.yy"
    {}
    break;

  case 959:
#line 5801 "sql_yacc.yy"
    {}
    break;

  case 960:
#line 5802 "sql_yacc.yy"
    {}
    break;

  case 961:
#line 5803 "sql_yacc.yy"
    {}
    break;

  case 962:
#line 5804 "sql_yacc.yy"
    {}
    break;

  case 963:
#line 5805 "sql_yacc.yy"
    {}
    break;

  case 964:
#line 5806 "sql_yacc.yy"
    {}
    break;

  case 965:
#line 5807 "sql_yacc.yy"
    {}
    break;

  case 966:
#line 5808 "sql_yacc.yy"
    {}
    break;

  case 967:
#line 5809 "sql_yacc.yy"
    {}
    break;

  case 968:
#line 5810 "sql_yacc.yy"
    {}
    break;

  case 969:
#line 5811 "sql_yacc.yy"
    {}
    break;

  case 970:
#line 5812 "sql_yacc.yy"
    {}
    break;

  case 971:
#line 5813 "sql_yacc.yy"
    {}
    break;

  case 972:
#line 5814 "sql_yacc.yy"
    {}
    break;

  case 973:
#line 5815 "sql_yacc.yy"
    {}
    break;

  case 974:
#line 5816 "sql_yacc.yy"
    {}
    break;

  case 975:
#line 5817 "sql_yacc.yy"
    {}
    break;

  case 976:
#line 5818 "sql_yacc.yy"
    {}
    break;

  case 977:
#line 5819 "sql_yacc.yy"
    {}
    break;

  case 978:
#line 5820 "sql_yacc.yy"
    {}
    break;

  case 979:
#line 5821 "sql_yacc.yy"
    {}
    break;

  case 980:
#line 5822 "sql_yacc.yy"
    {}
    break;

  case 981:
#line 5823 "sql_yacc.yy"
    {}
    break;

  case 982:
#line 5824 "sql_yacc.yy"
    {}
    break;

  case 983:
#line 5825 "sql_yacc.yy"
    {}
    break;

  case 984:
#line 5826 "sql_yacc.yy"
    {}
    break;

  case 985:
#line 5827 "sql_yacc.yy"
    {}
    break;

  case 986:
#line 5828 "sql_yacc.yy"
    {}
    break;

  case 987:
#line 5829 "sql_yacc.yy"
    {}
    break;

  case 988:
#line 5830 "sql_yacc.yy"
    {}
    break;

  case 989:
#line 5831 "sql_yacc.yy"
    {}
    break;

  case 990:
#line 5832 "sql_yacc.yy"
    {}
    break;

  case 991:
#line 5833 "sql_yacc.yy"
    {}
    break;

  case 992:
#line 5834 "sql_yacc.yy"
    {}
    break;

  case 993:
#line 5835 "sql_yacc.yy"
    {}
    break;

  case 994:
#line 5836 "sql_yacc.yy"
    {}
    break;

  case 995:
#line 5837 "sql_yacc.yy"
    {}
    break;

  case 996:
#line 5838 "sql_yacc.yy"
    {}
    break;

  case 997:
#line 5839 "sql_yacc.yy"
    {}
    break;

  case 998:
#line 5840 "sql_yacc.yy"
    {}
    break;

  case 999:
#line 5841 "sql_yacc.yy"
    {}
    break;

  case 1000:
#line 5842 "sql_yacc.yy"
    {}
    break;

  case 1001:
#line 5843 "sql_yacc.yy"
    {}
    break;

  case 1002:
#line 5844 "sql_yacc.yy"
    {}
    break;

  case 1003:
#line 5845 "sql_yacc.yy"
    {}
    break;

  case 1004:
#line 5846 "sql_yacc.yy"
    {}
    break;

  case 1005:
#line 5847 "sql_yacc.yy"
    {}
    break;

  case 1006:
#line 5848 "sql_yacc.yy"
    {}
    break;

  case 1007:
#line 5849 "sql_yacc.yy"
    {}
    break;

  case 1008:
#line 5850 "sql_yacc.yy"
    {}
    break;

  case 1009:
#line 5851 "sql_yacc.yy"
    {}
    break;

  case 1010:
#line 5852 "sql_yacc.yy"
    {}
    break;

  case 1011:
#line 5853 "sql_yacc.yy"
    {}
    break;

  case 1012:
#line 5854 "sql_yacc.yy"
    {}
    break;

  case 1013:
#line 5855 "sql_yacc.yy"
    {}
    break;

  case 1014:
#line 5856 "sql_yacc.yy"
    {}
    break;

  case 1015:
#line 5857 "sql_yacc.yy"
    {}
    break;

  case 1016:
#line 5858 "sql_yacc.yy"
    {}
    break;

  case 1017:
#line 5859 "sql_yacc.yy"
    {}
    break;

  case 1018:
#line 5860 "sql_yacc.yy"
    {}
    break;

  case 1019:
#line 5861 "sql_yacc.yy"
    {}
    break;

  case 1020:
#line 5862 "sql_yacc.yy"
    {}
    break;

  case 1021:
#line 5863 "sql_yacc.yy"
    {}
    break;

  case 1022:
#line 5864 "sql_yacc.yy"
    {}
    break;

  case 1023:
#line 5865 "sql_yacc.yy"
    {}
    break;

  case 1024:
#line 5866 "sql_yacc.yy"
    {}
    break;

  case 1025:
#line 5867 "sql_yacc.yy"
    {}
    break;

  case 1026:
#line 5868 "sql_yacc.yy"
    {}
    break;

  case 1027:
#line 5869 "sql_yacc.yy"
    {}
    break;

  case 1028:
#line 5870 "sql_yacc.yy"
    {}
    break;

  case 1029:
#line 5871 "sql_yacc.yy"
    {}
    break;

  case 1030:
#line 5872 "sql_yacc.yy"
    {}
    break;

  case 1031:
#line 5873 "sql_yacc.yy"
    {}
    break;

  case 1032:
#line 5874 "sql_yacc.yy"
    {}
    break;

  case 1033:
#line 5875 "sql_yacc.yy"
    {}
    break;

  case 1034:
#line 5876 "sql_yacc.yy"
    {}
    break;

  case 1035:
#line 5877 "sql_yacc.yy"
    {}
    break;

  case 1036:
#line 5878 "sql_yacc.yy"
    {}
    break;

  case 1037:
#line 5879 "sql_yacc.yy"
    {}
    break;

  case 1038:
#line 5880 "sql_yacc.yy"
    {}
    break;

  case 1039:
#line 5881 "sql_yacc.yy"
    {}
    break;

  case 1040:
#line 5882 "sql_yacc.yy"
    {}
    break;

  case 1041:
#line 5883 "sql_yacc.yy"
    {}
    break;

  case 1042:
#line 5884 "sql_yacc.yy"
    {}
    break;

  case 1043:
#line 5885 "sql_yacc.yy"
    {}
    break;

  case 1044:
#line 5886 "sql_yacc.yy"
    {}
    break;

  case 1045:
#line 5887 "sql_yacc.yy"
    {}
    break;

  case 1046:
#line 5888 "sql_yacc.yy"
    {}
    break;

  case 1047:
#line 5889 "sql_yacc.yy"
    {}
    break;

  case 1048:
#line 5890 "sql_yacc.yy"
    {}
    break;

  case 1049:
#line 5891 "sql_yacc.yy"
    {}
    break;

  case 1050:
#line 5892 "sql_yacc.yy"
    {}
    break;

  case 1051:
#line 5893 "sql_yacc.yy"
    {}
    break;

  case 1052:
#line 5894 "sql_yacc.yy"
    {}
    break;

  case 1053:
#line 5901 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_SET_OPTION;
            statement::SetOption *statement= new(std::nothrow) statement::SetOption(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            mysql_init_select(lex);
            lex->option_type=OPT_SESSION;
            lex->var_list.empty();
          }
    break;

  case 1054:
#line 5913 "sql_yacc.yy"
    {}
    break;

  case 1055:
#line 5917 "sql_yacc.yy"
    {}
    break;

  case 1056:
#line 5918 "sql_yacc.yy"
    {}
    break;

  case 1059:
#line 5927 "sql_yacc.yy"
    {
          }
    break;

  case 1060:
#line 5930 "sql_yacc.yy"
    {
          }
    break;

  case 1061:
#line 5935 "sql_yacc.yy"
    {}
    break;

  case 1062:
#line 5936 "sql_yacc.yy"
    { (yyval.var_type)=OPT_GLOBAL; }
    break;

  case 1063:
#line 5937 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1064:
#line 5938 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1065:
#line 5942 "sql_yacc.yy"
    { (yyval.num)= OPT_DEFAULT; }
    break;

  case 1066:
#line 5943 "sql_yacc.yy"
    { ((statement::SetOption *)Lex->statement)->one_shot_set= true; (yyval.num)= OPT_SESSION; }
    break;

  case 1067:
#line 5947 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1068:
#line 5948 "sql_yacc.yy"
    { (yyval.var_type)=OPT_GLOBAL; }
    break;

  case 1069:
#line 5949 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1070:
#line 5950 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1071:
#line 5954 "sql_yacc.yy"
    { (yyval.var_type)=OPT_DEFAULT; }
    break;

  case 1072:
#line 5955 "sql_yacc.yy"
    { (yyval.var_type)=OPT_GLOBAL; }
    break;

  case 1073:
#line 5956 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1074:
#line 5957 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1077:
#line 5967 "sql_yacc.yy"
    {
            LEX *lex=Lex;

            if ((yyvsp[(2) - (4)].variable).var)
            { /* System variable */
              if ((yyvsp[(1) - (4)].var_type))
                lex->option_type= (yyvsp[(1) - (4)].var_type);
              lex->var_list.push_back(new set_var(lex->option_type, (yyvsp[(2) - (4)].variable).var,
                                      &(yyvsp[(2) - (4)].variable).base_name, (yyvsp[(4) - (4)].item)));
            }
          }
    break;

  case 1078:
#line 5979 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->option_type= (yyvsp[(1) - (5)].var_type);
            lex->var_list.push_back(new set_var(lex->option_type,
                                                find_sys_var(YYSession, "tx_isolation"),
                                                &null_lex_str,
                                                new Item_int((int32_t) (yyvsp[(5) - (5)].tx_isolation))));
          }
    break;

  case 1079:
#line 5991 "sql_yacc.yy"
    {
            Lex->var_list.push_back(new set_var_user(new Item_func_set_user_var((yyvsp[(2) - (4)].lex_str),(yyvsp[(4) - (4)].item))));
          }
    break;

  case 1080:
#line 5995 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->var_list.push_back(new set_var((yyvsp[(3) - (6)].var_type), (yyvsp[(4) - (6)].variable).var, &(yyvsp[(4) - (6)].variable).base_name, (yyvsp[(6) - (6)].item)));
          }
    break;

  case 1081:
#line 6003 "sql_yacc.yy"
    {
            Session *session= YYSession;

            /* We have to lookup here since local vars can shadow sysvars */
            {
              /* Not an SP local variable */
              sys_var *tmp=find_sys_var(session, (yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length);
              if (!tmp)
                DRIZZLE_YYABORT;
              (yyval.variable).var= tmp;
              (yyval.variable).base_name= null_lex_str;
            }
          }
    break;

  case 1082:
#line 6019 "sql_yacc.yy"
    { (yyval.tx_isolation)= ISO_READ_UNCOMMITTED; }
    break;

  case 1083:
#line 6020 "sql_yacc.yy"
    { (yyval.tx_isolation)= ISO_READ_COMMITTED; }
    break;

  case 1084:
#line 6021 "sql_yacc.yy"
    { (yyval.tx_isolation)= ISO_REPEATABLE_READ; }
    break;

  case 1085:
#line 6022 "sql_yacc.yy"
    { (yyval.tx_isolation)= ISO_SERIALIZABLE; }
    break;

  case 1086:
#line 6026 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[(1) - (1)].item); }
    break;

  case 1087:
#line 6027 "sql_yacc.yy"
    { (yyval.item)=0; }
    break;

  case 1088:
#line 6028 "sql_yacc.yy"
    { (yyval.item)=new Item_string("ON",  2, system_charset_info); }
    break;

  case 1089:
#line 6029 "sql_yacc.yy"
    { (yyval.item)=new Item_string("ALL", 3, system_charset_info); }
    break;

  case 1090:
#line 6030 "sql_yacc.yy"
    { (yyval.item)=new Item_string("binary", 6, system_charset_info); }
    break;

  case 1093:
#line 6040 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command= SQLCOM_UNLOCK_TABLES;
            lex->statement= new(std::nothrow) statement::UnlockTables(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 1094:
#line 6048 "sql_yacc.yy"
    {}
    break;

  case 1095:
#line 6053 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command = SQLCOM_BEGIN;
            lex->statement= new(std::nothrow) statement::StartTransaction(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 1096:
#line 6060 "sql_yacc.yy"
    {}
    break;

  case 1097:
#line 6064 "sql_yacc.yy"
    {}
    break;

  case 1098:
#line 6065 "sql_yacc.yy"
    {}
    break;

  case 1099:
#line 6070 "sql_yacc.yy"
    { (yyval.num)= (YYSession->variables.completion_type == 1); }
    break;

  case 1100:
#line 6071 "sql_yacc.yy"
    { (yyval.num)=0; }
    break;

  case 1101:
#line 6072 "sql_yacc.yy"
    { (yyval.num)=1; }
    break;

  case 1102:
#line 6077 "sql_yacc.yy"
    { (yyval.num)= (YYSession->variables.completion_type == 2); }
    break;

  case 1103:
#line 6078 "sql_yacc.yy"
    { (yyval.num)=1; }
    break;

  case 1104:
#line 6079 "sql_yacc.yy"
    { (yyval.num)=0; }
    break;

  case 1105:
#line 6083 "sql_yacc.yy"
    {}
    break;

  case 1106:
#line 6084 "sql_yacc.yy"
    {}
    break;

  case 1107:
#line 6089 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_COMMIT;
            statement::Commit *statement= new(std::nothrow) statement::Commit(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->tx_chain= (yyvsp[(3) - (4)].num);
            statement->tx_release= (yyvsp[(4) - (4)].num);
          }
    break;

  case 1108:
#line 6103 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_ROLLBACK;
            statement::Rollback *statement= new(std::nothrow) statement::Rollback(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->tx_chain= (yyvsp[(3) - (4)].num);
            statement->tx_release= (yyvsp[(4) - (4)].num);
          }
    break;

  case 1109:
#line 6115 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_ROLLBACK_TO_SAVEPOINT;
            lex->statement= new(std::nothrow) statement::RollbackToSavepoint(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->ident= (yyvsp[(5) - (5)].lex_str);
          }
    break;

  case 1110:
#line 6127 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_SAVEPOINT;
            lex->statement= new(std::nothrow) statement::Savepoint(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->ident= (yyvsp[(2) - (2)].lex_str);
          }
    break;

  case 1111:
#line 6139 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_RELEASE_SAVEPOINT;
            lex->statement= new(std::nothrow) statement::ReleaseSavepoint(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->ident= (yyvsp[(3) - (3)].lex_str);
          }
    break;

  case 1112:
#line 6155 "sql_yacc.yy"
    {}
    break;

  case 1114:
#line 6161 "sql_yacc.yy"
    {
            if (add_select_to_union_list(Lex, (bool)(yyvsp[(2) - (2)].num)))
              DRIZZLE_YYABORT;
          }
    break;

  case 1115:
#line 6166 "sql_yacc.yy"
    {
            /*
              Remove from the name resolution context stack the context of the
              last select in the union.
            */
            Lex->pop_context();
          }
    break;

  case 1116:
#line 6176 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 1117:
#line 6177 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 1118:
#line 6178 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 1119:
#line 6182 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            assert(lex->current_select->linkage != GLOBAL_OPTIONS_TYPE);
            Select_Lex *sel= lex->current_select;
            Select_Lex_Unit *unit= sel->master_unit();
            Select_Lex *fake= unit->fake_select_lex;
            if (fake)
            {
              unit->global_parameters= fake;
              fake->no_table_names_allowed= 1;
              lex->current_select= fake;
            }
            session->where= "global ORDER clause";
          }
    break;

  case 1120:
#line 6198 "sql_yacc.yy"
    {
            Session *session= YYSession;
            session->lex->current_select->no_table_names_allowed= 0;
            session->where= "";
          }
    break;

  case 1123:
#line 6211 "sql_yacc.yy"
    { (yyval.num)=1; }
    break;

  case 1124:
#line 6212 "sql_yacc.yy"
    { (yyval.num)=1; }
    break;

  case 1125:
#line 6213 "sql_yacc.yy"
    { (yyval.num)=0; }
    break;

  case 1126:
#line 6218 "sql_yacc.yy"
    {
            (yyval.select_lex)= Lex->current_select->master_unit()->first_select();
          }
    break;

  case 1127:
#line 6222 "sql_yacc.yy"
    {
            (yyval.select_lex)= Lex->current_select->master_unit()->first_select();
          }
    break;

  case 1129:
#line 6231 "sql_yacc.yy"
    {
            if (add_select_to_union_list(Lex, (bool)(yyvsp[(3) - (3)].num)))
              DRIZZLE_YYABORT;
          }
    break;

  case 1130:
#line 6236 "sql_yacc.yy"
    {
            Lex->pop_context();
            (yyval.select_lex)= (yyvsp[(1) - (5)].select_lex);
          }
    break;

  case 1131:
#line 6245 "sql_yacc.yy"
    {
            (yyval.select_lex)= (yyvsp[(2) - (3)].select_lex);
          }
    break;

  case 1132:
#line 6251 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (!lex->expr_allows_subselect)
            {
              my_parse_error(ER(ER_SYNTAX_ERROR));
              DRIZZLE_YYABORT;
            }
            /*
              we are making a "derived table" for the parenthesis
              as we need to have a lex level to fit the union
              after the parenthesis, e.g.
              (SELECT .. ) UNION ...  becomes
              SELECT * FROM ((SELECT ...) UNION ...)
            */
            if (mysql_new_select(Lex, 1))
              DRIZZLE_YYABORT;
          }
    break;

  case 1133:
#line 6271 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->pop_context();
            Select_Lex *child= lex->current_select;
            lex->current_select = lex->current_select->return_after_parsing();
            lex->nest_level--;
            lex->current_select->n_child_sum_items += child->n_sum_items;
            /*
              A subselect can add fields to an outer select. Reserve space for
              them.
            */
            lex->current_select->select_n_where_fields+=
            child->select_n_where_fields;
          }
    break;


/* Line 1267 of yacc.c.  */
#line 15026 "drizzled/sql_yacc.cc"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



