"""Main module for DOLFIN"""

# Special module to handle import issues
import dolfin.importhandler

# Attempt to import vtk (imported here to avoid a segfault with Ubuntu
# 11.10 and Nvidia OpenGL libraries)
try:
    import vtk
except:
    pass

# Import UFL form language
from ufl import *

# Add log level present in C++ DOLFIN but not ufl.log
PROGRESS = 16

# Remove some unnecessary imports from UFL
del set_handler, set_level

# Import names from the compiled cpp module
from dolfin.cppimports import *
from dolfin.cppimports import __version__, __swigversion__

# Import UFL color printing
from ufl.log import info_red, info_green, info_blue

# List of supported elements from FFC
try:
    from ffc import supported_elements, supported_elements_for_plotting
except:
    supported_elements = []
    supported_elements_for_plotting = []

# Imports from pure Python modules
from dolfin.functions import *
from dolfin.common import *
from dolfin.compilemodules import *
from dolfin.fem import *
from dolfin.mesh import *
